/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.SumExpression;

class CompareExpression
extends BasicExpression {
    BasicExpression E1;
    BasicExpression E2;
    int Operator;
    static final int LESS = 1;
    static final int LESSEQUAL = 2;
    static final int GREATER = 3;
    static final int GREATEREQUAL = 4;
    static final int EQUAL = 5;
    static final int ABOUTEQUAL = 6;

    public CompareExpression(BasicExpression basicExpression, BasicExpression basicExpression2, int n) {
        this.E1 = basicExpression;
        this.E2 = basicExpression2;
        this.Operator = n;
    }

    public static BasicExpression scan(ExpressionText expressionText) throws ConstructionException {
        BasicExpression basicExpression = SumExpression.scan(expressionText);
        char c2 = expressionText.next();
        int n = 0;
        if (c2 == '<') {
            expressionText.advance();
            if (expressionText.next(true) == '=') {
                n = 2;
                expressionText.advance();
            } else {
                n = 1;
            }
        } else if (c2 == '>') {
            expressionText.advance();
            if (expressionText.next(true) == '=') {
                n = 4;
                expressionText.advance();
            } else {
                n = 3;
            }
        } else if (c2 == '=') {
            expressionText.advance();
            if (expressionText.next(true) == '=') {
                expressionText.advance();
            }
            n = 5;
        } else if (c2 == '~') {
            expressionText.advance();
            if (expressionText.next(true) == '=') {
                expressionText.advance();
            }
            n = 6;
        } else {
            return basicExpression;
        }
        BasicExpression basicExpression2 = SumExpression.scan(expressionText);
        return new CompareExpression(basicExpression, basicExpression2, n);
    }

    public double getValue() throws ConstructionException {
        switch (this.Operator) {
            case 1: {
                return this.logical(this.E1.getValue() < this.E2.getValue());
            }
            case 2: {
                return this.logical(this.E1.getValue() <= this.E2.getValue());
            }
            case 3: {
                return this.logical(this.E1.getValue() > this.E2.getValue());
            }
            case 4: {
                return this.logical(this.E1.getValue() >= this.E2.getValue());
            }
            case 5: {
                return this.logical(this.E1.getValue() == this.E2.getValue());
            }
            case 6: {
                return this.logical(Math.abs(this.E1.getValue() - this.E2.getValue()) < 1.0E-10);
            }
        }
        return 0.0;
    }

    public double logical(boolean bl) {
        if (bl) {
            return 1.0;
        }
        return 0.0;
    }

    public void translate() {
        this.E1.translate();
        this.E2.translate();
    }

    public String toString() {
        switch (this.Operator) {
            case 1: {
                return this.E1 + "<" + this.E2;
            }
            case 2: {
                return this.E1 + "<=" + this.E2;
            }
            case 3: {
                return this.E1 + ">" + this.E2;
            }
            case 4: {
                return this.E1 + ">=" + this.E2;
            }
            case 5: {
                return this.E1 + "==" + this.E2;
            }
            case 6: {
                return this.E1 + "~=" + this.E2;
            }
        }
        return "";
    }

    public void reset() {
        this.E1.reset();
        this.E2.reset();
    }

    public boolean isLogical() {
        return true;
    }
}

