/*---------------------------------------------------------------------------*\

	FILE....: ADPCM.H
	TYPE....: Microsoft C Header
	AUTHOR..: Horse
	DATE....: 12/5/98

	ADPCM Functions for VLC card.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __ADPCM__
#define __ADPCM__

#ifdef __FreeBSD__
#include <sys/types.h>
#endif

#include "contypes.h"

void adpcm_pack(USHORT codes[], USHORT packed[], USHORT n);
void adpcm_unpack(USHORT codes[], USHORT packed[], USHORT n);

void adpcm_open(void **states);
void adpcm_reset(void *states);
void adpcm_close(void *states);

void adpcm_encode(void *states, USHORT codes[], short X[], USHORT n);
void adpcm_decode(void *states, short X_[], USHORT codes[], USHORT n);

#endif
