// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_CLZ_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_CLZ_A32_H_

const byte kInstruction_clz_cs_r12_r1[] = {
  0x11, 0xcf, 0x6f, 0x21 // clz cs r12 r1
};
const byte kInstruction_clz_hi_r6_r12[] = {
  0x1c, 0x6f, 0x6f, 0x81 // clz hi r6 r12
};
const byte kInstruction_clz_lt_r11_r10[] = {
  0x1a, 0xbf, 0x6f, 0xb1 // clz lt r11 r10
};
const byte kInstruction_clz_vs_r10_r8[] = {
  0x18, 0xaf, 0x6f, 0x61 // clz vs r10 r8
};
const byte kInstruction_clz_pl_r5_r8[] = {
  0x18, 0x5f, 0x6f, 0x51 // clz pl r5 r8
};
const byte kInstruction_clz_ls_r14_r14[] = {
  0x1e, 0xef, 0x6f, 0x91 // clz ls r14 r14
};
const byte kInstruction_clz_gt_r8_r6[] = {
  0x16, 0x8f, 0x6f, 0xc1 // clz gt r8 r6
};
const byte kInstruction_clz_vc_r7_r11[] = {
  0x1b, 0x7f, 0x6f, 0x71 // clz vc r7 r11
};
const byte kInstruction_clz_pl_r4_r12[] = {
  0x1c, 0x4f, 0x6f, 0x51 // clz pl r4 r12
};
const byte kInstruction_clz_gt_r12_r12[] = {
  0x1c, 0xcf, 0x6f, 0xc1 // clz gt r12 r12
};
const byte kInstruction_clz_ne_r8_r4[] = {
  0x14, 0x8f, 0x6f, 0x11 // clz ne r8 r4
};
const byte kInstruction_clz_le_r1_r11[] = {
  0x1b, 0x1f, 0x6f, 0xd1 // clz le r1 r11
};
const byte kInstruction_clz_cc_r4_r10[] = {
  0x1a, 0x4f, 0x6f, 0x31 // clz cc r4 r10
};
const byte kInstruction_clz_gt_r14_r0[] = {
  0x10, 0xef, 0x6f, 0xc1 // clz gt r14 r0
};
const byte kInstruction_clz_cs_r2_r11[] = {
  0x1b, 0x2f, 0x6f, 0x21 // clz cs r2 r11
};
const byte kInstruction_clz_al_r3_r12[] = {
  0x1c, 0x3f, 0x6f, 0xe1 // clz al r3 r12
};
const byte kInstruction_clz_hi_r6_r0[] = {
  0x10, 0x6f, 0x6f, 0x81 // clz hi r6 r0
};
const byte kInstruction_clz_ls_r10_r10[] = {
  0x1a, 0xaf, 0x6f, 0x91 // clz ls r10 r10
};
const byte kInstruction_clz_ls_r4_r8[] = {
  0x18, 0x4f, 0x6f, 0x91 // clz ls r4 r8
};
const byte kInstruction_clz_le_r8_r0[] = {
  0x10, 0x8f, 0x6f, 0xd1 // clz le r8 r0
};
const byte kInstruction_clz_pl_r5_r3[] = {
  0x13, 0x5f, 0x6f, 0x51 // clz pl r5 r3
};
const byte kInstruction_clz_ls_r8_r5[] = {
  0x15, 0x8f, 0x6f, 0x91 // clz ls r8 r5
};
const byte kInstruction_clz_ge_r0_r10[] = {
  0x1a, 0x0f, 0x6f, 0xa1 // clz ge r0 r10
};
const byte kInstruction_clz_lt_r10_r6[] = {
  0x16, 0xaf, 0x6f, 0xb1 // clz lt r10 r6
};
const byte kInstruction_clz_ne_r9_r9[] = {
  0x19, 0x9f, 0x6f, 0x11 // clz ne r9 r9
};
const byte kInstruction_clz_hi_r5_r0[] = {
  0x10, 0x5f, 0x6f, 0x81 // clz hi r5 r0
};
const byte kInstruction_clz_pl_r10_r6[] = {
  0x16, 0xaf, 0x6f, 0x51 // clz pl r10 r6
};
const byte kInstruction_clz_vs_r1_r3[] = {
  0x13, 0x1f, 0x6f, 0x61 // clz vs r1 r3
};
const byte kInstruction_clz_vs_r9_r8[] = {
  0x18, 0x9f, 0x6f, 0x61 // clz vs r9 r8
};
const byte kInstruction_clz_cc_r2_r10[] = {
  0x1a, 0x2f, 0x6f, 0x31 // clz cc r2 r10
};
const byte kInstruction_clz_cs_r11_r3[] = {
  0x13, 0xbf, 0x6f, 0x21 // clz cs r11 r3
};
const byte kInstruction_clz_hi_r8_r2[] = {
  0x12, 0x8f, 0x6f, 0x81 // clz hi r8 r2
};
const byte kInstruction_clz_pl_r6_r0[] = {
  0x10, 0x6f, 0x6f, 0x51 // clz pl r6 r0
};
const byte kInstruction_clz_hi_r9_r2[] = {
  0x12, 0x9f, 0x6f, 0x81 // clz hi r9 r2
};
const byte kInstruction_clz_al_r14_r11[] = {
  0x1b, 0xef, 0x6f, 0xe1 // clz al r14 r11
};
const byte kInstruction_clz_eq_r8_r13[] = {
  0x1d, 0x8f, 0x6f, 0x01 // clz eq r8 r13
};
const byte kInstruction_clz_ge_r12_r2[] = {
  0x12, 0xcf, 0x6f, 0xa1 // clz ge r12 r2
};
const byte kInstruction_clz_cc_r2_r6[] = {
  0x16, 0x2f, 0x6f, 0x31 // clz cc r2 r6
};
const byte kInstruction_clz_ne_r13_r9[] = {
  0x19, 0xdf, 0x6f, 0x11 // clz ne r13 r9
};
const byte kInstruction_clz_ne_r13_r10[] = {
  0x1a, 0xdf, 0x6f, 0x11 // clz ne r13 r10
};
const byte kInstruction_clz_mi_r10_r9[] = {
  0x19, 0xaf, 0x6f, 0x41 // clz mi r10 r9
};
const byte kInstruction_clz_lt_r13_r12[] = {
  0x1c, 0xdf, 0x6f, 0xb1 // clz lt r13 r12
};
const byte kInstruction_clz_lt_r14_r3[] = {
  0x13, 0xef, 0x6f, 0xb1 // clz lt r14 r3
};
const byte kInstruction_clz_mi_r12_r14[] = {
  0x1e, 0xcf, 0x6f, 0x41 // clz mi r12 r14
};
const byte kInstruction_clz_vs_r11_r2[] = {
  0x12, 0xbf, 0x6f, 0x61 // clz vs r11 r2
};
const byte kInstruction_clz_ls_r11_r0[] = {
  0x10, 0xbf, 0x6f, 0x91 // clz ls r11 r0
};
const byte kInstruction_clz_gt_r10_r9[] = {
  0x19, 0xaf, 0x6f, 0xc1 // clz gt r10 r9
};
const byte kInstruction_clz_le_r10_r12[] = {
  0x1c, 0xaf, 0x6f, 0xd1 // clz le r10 r12
};
const byte kInstruction_clz_ge_r0_r14[] = {
  0x1e, 0x0f, 0x6f, 0xa1 // clz ge r0 r14
};
const byte kInstruction_clz_mi_r5_r8[] = {
  0x18, 0x5f, 0x6f, 0x41 // clz mi r5 r8
};
const byte kInstruction_clz_vs_r4_r11[] = {
  0x1b, 0x4f, 0x6f, 0x61 // clz vs r4 r11
};
const byte kInstruction_clz_lt_r7_r12[] = {
  0x1c, 0x7f, 0x6f, 0xb1 // clz lt r7 r12
};
const byte kInstruction_clz_gt_r2_r8[] = {
  0x18, 0x2f, 0x6f, 0xc1 // clz gt r2 r8
};
const byte kInstruction_clz_gt_r5_r7[] = {
  0x17, 0x5f, 0x6f, 0xc1 // clz gt r5 r7
};
const byte kInstruction_clz_pl_r6_r3[] = {
  0x13, 0x6f, 0x6f, 0x51 // clz pl r6 r3
};
const byte kInstruction_clz_ne_r2_r12[] = {
  0x1c, 0x2f, 0x6f, 0x11 // clz ne r2 r12
};
const byte kInstruction_clz_hi_r11_r11[] = {
  0x1b, 0xbf, 0x6f, 0x81 // clz hi r11 r11
};
const byte kInstruction_clz_vs_r4_r14[] = {
  0x1e, 0x4f, 0x6f, 0x61 // clz vs r4 r14
};
const byte kInstruction_clz_vs_r13_r1[] = {
  0x11, 0xdf, 0x6f, 0x61 // clz vs r13 r1
};
const byte kInstruction_clz_cs_r4_r3[] = {
  0x13, 0x4f, 0x6f, 0x21 // clz cs r4 r3
};
const byte kInstruction_clz_eq_r13_r6[] = {
  0x16, 0xdf, 0x6f, 0x01 // clz eq r13 r6
};
const byte kInstruction_clz_gt_r11_r14[] = {
  0x1e, 0xbf, 0x6f, 0xc1 // clz gt r11 r14
};
const byte kInstruction_clz_vc_r14_r4[] = {
  0x14, 0xef, 0x6f, 0x71 // clz vc r14 r4
};
const byte kInstruction_clz_vc_r1_r10[] = {
  0x1a, 0x1f, 0x6f, 0x71 // clz vc r1 r10
};
const byte kInstruction_clz_mi_r10_r3[] = {
  0x13, 0xaf, 0x6f, 0x41 // clz mi r10 r3
};
const byte kInstruction_clz_vs_r9_r3[] = {
  0x13, 0x9f, 0x6f, 0x61 // clz vs r9 r3
};
const byte kInstruction_clz_vc_r14_r5[] = {
  0x15, 0xef, 0x6f, 0x71 // clz vc r14 r5
};
const byte kInstruction_clz_ne_r9_r1[] = {
  0x11, 0x9f, 0x6f, 0x11 // clz ne r9 r1
};
const byte kInstruction_clz_al_r9_r6[] = {
  0x16, 0x9f, 0x6f, 0xe1 // clz al r9 r6
};
const byte kInstruction_clz_vc_r7_r8[] = {
  0x18, 0x7f, 0x6f, 0x71 // clz vc r7 r8
};
const byte kInstruction_clz_ls_r6_r9[] = {
  0x19, 0x6f, 0x6f, 0x91 // clz ls r6 r9
};
const byte kInstruction_clz_le_r14_r2[] = {
  0x12, 0xef, 0x6f, 0xd1 // clz le r14 r2
};
const byte kInstruction_clz_ls_r9_r13[] = {
  0x1d, 0x9f, 0x6f, 0x91 // clz ls r9 r13
};
const byte kInstruction_clz_eq_r1_r5[] = {
  0x15, 0x1f, 0x6f, 0x01 // clz eq r1 r5
};
const byte kInstruction_clz_le_r9_r2[] = {
  0x12, 0x9f, 0x6f, 0xd1 // clz le r9 r2
};
const byte kInstruction_clz_eq_r2_r1[] = {
  0x11, 0x2f, 0x6f, 0x01 // clz eq r2 r1
};
const byte kInstruction_clz_ls_r9_r11[] = {
  0x1b, 0x9f, 0x6f, 0x91 // clz ls r9 r11
};
const byte kInstruction_clz_lt_r7_r13[] = {
  0x1d, 0x7f, 0x6f, 0xb1 // clz lt r7 r13
};
const byte kInstruction_clz_cc_r8_r7[] = {
  0x17, 0x8f, 0x6f, 0x31 // clz cc r8 r7
};
const byte kInstruction_clz_ls_r5_r1[] = {
  0x11, 0x5f, 0x6f, 0x91 // clz ls r5 r1
};
const byte kInstruction_clz_le_r1_r9[] = {
  0x19, 0x1f, 0x6f, 0xd1 // clz le r1 r9
};
const byte kInstruction_clz_ls_r8_r14[] = {
  0x1e, 0x8f, 0x6f, 0x91 // clz ls r8 r14
};
const byte kInstruction_clz_le_r9_r1[] = {
  0x11, 0x9f, 0x6f, 0xd1 // clz le r9 r1
};
const byte kInstruction_clz_gt_r1_r6[] = {
  0x16, 0x1f, 0x6f, 0xc1 // clz gt r1 r6
};
const byte kInstruction_clz_gt_r11_r10[] = {
  0x1a, 0xbf, 0x6f, 0xc1 // clz gt r11 r10
};
const byte kInstruction_clz_hi_r0_r12[] = {
  0x1c, 0x0f, 0x6f, 0x81 // clz hi r0 r12
};
const byte kInstruction_clz_gt_r1_r7[] = {
  0x17, 0x1f, 0x6f, 0xc1 // clz gt r1 r7
};
const byte kInstruction_clz_mi_r7_r1[] = {
  0x11, 0x7f, 0x6f, 0x41 // clz mi r7 r1
};
const byte kInstruction_clz_mi_r7_r0[] = {
  0x10, 0x7f, 0x6f, 0x41 // clz mi r7 r0
};
const byte kInstruction_clz_ls_r1_r3[] = {
  0x13, 0x1f, 0x6f, 0x91 // clz ls r1 r3
};
const byte kInstruction_clz_mi_r13_r3[] = {
  0x13, 0xdf, 0x6f, 0x41 // clz mi r13 r3
};
const byte kInstruction_clz_eq_r4_r3[] = {
  0x13, 0x4f, 0x6f, 0x01 // clz eq r4 r3
};
const byte kInstruction_clz_vc_r14_r9[] = {
  0x19, 0xef, 0x6f, 0x71 // clz vc r14 r9
};
const byte kInstruction_clz_pl_r3_r1[] = {
  0x11, 0x3f, 0x6f, 0x51 // clz pl r3 r1
};
const byte kInstruction_clz_mi_r0_r2[] = {
  0x12, 0x0f, 0x6f, 0x41 // clz mi r0 r2
};
const byte kInstruction_clz_hi_r2_r7[] = {
  0x17, 0x2f, 0x6f, 0x81 // clz hi r2 r7
};
const byte kInstruction_clz_hi_r13_r12[] = {
  0x1c, 0xdf, 0x6f, 0x81 // clz hi r13 r12
};
const byte kInstruction_clz_ls_r12_r8[] = {
  0x18, 0xcf, 0x6f, 0x91 // clz ls r12 r8
};
const byte kInstruction_clz_ne_r5_r6[] = {
  0x16, 0x5f, 0x6f, 0x11 // clz ne r5 r6
};
const byte kInstruction_clz_pl_r5_r4[] = {
  0x14, 0x5f, 0x6f, 0x51 // clz pl r5 r4
};
const byte kInstruction_clz_ge_r1_r6[] = {
  0x16, 0x1f, 0x6f, 0xa1 // clz ge r1 r6
};
const byte kInstruction_clz_eq_r8_r10[] = {
  0x1a, 0x8f, 0x6f, 0x01 // clz eq r8 r10
};
const byte kInstruction_clz_cs_r5_r4[] = {
  0x14, 0x5f, 0x6f, 0x21 // clz cs r5 r4
};
const byte kInstruction_clz_eq_r11_r6[] = {
  0x16, 0xbf, 0x6f, 0x01 // clz eq r11 r6
};
const byte kInstruction_clz_cs_r13_r3[] = {
  0x13, 0xdf, 0x6f, 0x21 // clz cs r13 r3
};
const byte kInstruction_clz_pl_r2_r8[] = {
  0x18, 0x2f, 0x6f, 0x51 // clz pl r2 r8
};
const byte kInstruction_clz_gt_r10_r0[] = {
  0x10, 0xaf, 0x6f, 0xc1 // clz gt r10 r0
};
const byte kInstruction_clz_lt_r4_r10[] = {
  0x1a, 0x4f, 0x6f, 0xb1 // clz lt r4 r10
};
const byte kInstruction_clz_vs_r14_r14[] = {
  0x1e, 0xef, 0x6f, 0x61 // clz vs r14 r14
};
const byte kInstruction_clz_hi_r0_r7[] = {
  0x17, 0x0f, 0x6f, 0x81 // clz hi r0 r7
};
const byte kInstruction_clz_cc_r9_r6[] = {
  0x16, 0x9f, 0x6f, 0x31 // clz cc r9 r6
};
const byte kInstruction_clz_ne_r7_r13[] = {
  0x1d, 0x7f, 0x6f, 0x11 // clz ne r7 r13
};
const byte kInstruction_clz_eq_r2_r6[] = {
  0x16, 0x2f, 0x6f, 0x01 // clz eq r2 r6
};
const byte kInstruction_clz_cs_r12_r12[] = {
  0x1c, 0xcf, 0x6f, 0x21 // clz cs r12 r12
};
const byte kInstruction_clz_mi_r3_r10[] = {
  0x1a, 0x3f, 0x6f, 0x41 // clz mi r3 r10
};
const byte kInstruction_clz_le_r6_r13[] = {
  0x1d, 0x6f, 0x6f, 0xd1 // clz le r6 r13
};
const byte kInstruction_clz_al_r2_r1[] = {
  0x11, 0x2f, 0x6f, 0xe1 // clz al r2 r1
};
const byte kInstruction_clz_le_r3_r4[] = {
  0x14, 0x3f, 0x6f, 0xd1 // clz le r3 r4
};
const byte kInstruction_clz_pl_r4_r4[] = {
  0x14, 0x4f, 0x6f, 0x51 // clz pl r4 r4
};
const byte kInstruction_clz_lt_r12_r3[] = {
  0x13, 0xcf, 0x6f, 0xb1 // clz lt r12 r3
};
const byte kInstruction_clz_ls_r7_r4[] = {
  0x14, 0x7f, 0x6f, 0x91 // clz ls r7 r4
};
const byte kInstruction_clz_le_r9_r4[] = {
  0x14, 0x9f, 0x6f, 0xd1 // clz le r9 r4
};
const byte kInstruction_clz_vc_r13_r3[] = {
  0x13, 0xdf, 0x6f, 0x71 // clz vc r13 r3
};
const byte kInstruction_clz_vc_r8_r8[] = {
  0x18, 0x8f, 0x6f, 0x71 // clz vc r8 r8
};
const byte kInstruction_clz_ge_r2_r8[] = {
  0x18, 0x2f, 0x6f, 0xa1 // clz ge r2 r8
};
const byte kInstruction_clz_le_r11_r13[] = {
  0x1d, 0xbf, 0x6f, 0xd1 // clz le r11 r13
};
const byte kInstruction_clz_le_r1_r5[] = {
  0x15, 0x1f, 0x6f, 0xd1 // clz le r1 r5
};
const byte kInstruction_clz_ge_r9_r12[] = {
  0x1c, 0x9f, 0x6f, 0xa1 // clz ge r9 r12
};
const byte kInstruction_clz_cs_r14_r14[] = {
  0x1e, 0xef, 0x6f, 0x21 // clz cs r14 r14
};
const byte kInstruction_clz_cc_r1_r0[] = {
  0x10, 0x1f, 0x6f, 0x31 // clz cc r1 r0
};
const byte kInstruction_clz_ge_r3_r0[] = {
  0x10, 0x3f, 0x6f, 0xa1 // clz ge r3 r0
};
const byte kInstruction_clz_al_r10_r0[] = {
  0x10, 0xaf, 0x6f, 0xe1 // clz al r10 r0
};
const byte kInstruction_clz_cc_r11_r10[] = {
  0x1a, 0xbf, 0x6f, 0x31 // clz cc r11 r10
};
const byte kInstruction_clz_mi_r11_r11[] = {
  0x1b, 0xbf, 0x6f, 0x41 // clz mi r11 r11
};
const byte kInstruction_clz_ne_r12_r7[] = {
  0x17, 0xcf, 0x6f, 0x11 // clz ne r12 r7
};
const byte kInstruction_clz_lt_r4_r12[] = {
  0x1c, 0x4f, 0x6f, 0xb1 // clz lt r4 r12
};
const byte kInstruction_clz_gt_r14_r5[] = {
  0x15, 0xef, 0x6f, 0xc1 // clz gt r14 r5
};
const byte kInstruction_clz_ge_r1_r7[] = {
  0x17, 0x1f, 0x6f, 0xa1 // clz ge r1 r7
};
const byte kInstruction_clz_al_r7_r0[] = {
  0x10, 0x7f, 0x6f, 0xe1 // clz al r7 r0
};
const byte kInstruction_clz_ls_r2_r0[] = {
  0x10, 0x2f, 0x6f, 0x91 // clz ls r2 r0
};
const byte kInstruction_clz_pl_r6_r11[] = {
  0x1b, 0x6f, 0x6f, 0x51 // clz pl r6 r11
};
const byte kInstruction_clz_vc_r0_r6[] = {
  0x16, 0x0f, 0x6f, 0x71 // clz vc r0 r6
};
const byte kInstruction_clz_pl_r6_r9[] = {
  0x19, 0x6f, 0x6f, 0x51 // clz pl r6 r9
};
const byte kInstruction_clz_vs_r8_r1[] = {
  0x11, 0x8f, 0x6f, 0x61 // clz vs r8 r1
};
const byte kInstruction_clz_cs_r1_r6[] = {
  0x16, 0x1f, 0x6f, 0x21 // clz cs r1 r6
};
const byte kInstruction_clz_hi_r4_r11[] = {
  0x1b, 0x4f, 0x6f, 0x81 // clz hi r4 r11
};
const byte kInstruction_clz_gt_r5_r5[] = {
  0x15, 0x5f, 0x6f, 0xc1 // clz gt r5 r5
};
const byte kInstruction_clz_al_r3_r4[] = {
  0x14, 0x3f, 0x6f, 0xe1 // clz al r3 r4
};
const byte kInstruction_clz_ge_r11_r12[] = {
  0x1c, 0xbf, 0x6f, 0xa1 // clz ge r11 r12
};
const byte kInstruction_clz_cc_r14_r2[] = {
  0x12, 0xef, 0x6f, 0x31 // clz cc r14 r2
};
const byte kInstruction_clz_ge_r2_r4[] = {
  0x14, 0x2f, 0x6f, 0xa1 // clz ge r2 r4
};
const byte kInstruction_clz_lt_r5_r11[] = {
  0x1b, 0x5f, 0x6f, 0xb1 // clz lt r5 r11
};
const byte kInstruction_clz_mi_r11_r14[] = {
  0x1e, 0xbf, 0x6f, 0x41 // clz mi r11 r14
};
const byte kInstruction_clz_ne_r3_r3[] = {
  0x13, 0x3f, 0x6f, 0x11 // clz ne r3 r3
};
const byte kInstruction_clz_pl_r14_r0[] = {
  0x10, 0xef, 0x6f, 0x51 // clz pl r14 r0
};
const byte kInstruction_clz_vc_r4_r10[] = {
  0x1a, 0x4f, 0x6f, 0x71 // clz vc r4 r10
};
const byte kInstruction_clz_vs_r6_r8[] = {
  0x18, 0x6f, 0x6f, 0x61 // clz vs r6 r8
};
const byte kInstruction_clz_vc_r4_r7[] = {
  0x17, 0x4f, 0x6f, 0x71 // clz vc r4 r7
};
const byte kInstruction_clz_cs_r11_r10[] = {
  0x1a, 0xbf, 0x6f, 0x21 // clz cs r11 r10
};
const byte kInstruction_clz_eq_r11_r8[] = {
  0x18, 0xbf, 0x6f, 0x01 // clz eq r11 r8
};
const byte kInstruction_clz_ne_r9_r2[] = {
  0x12, 0x9f, 0x6f, 0x11 // clz ne r9 r2
};
const byte kInstruction_clz_hi_r9_r7[] = {
  0x17, 0x9f, 0x6f, 0x81 // clz hi r9 r7
};
const byte kInstruction_clz_lt_r0_r6[] = {
  0x16, 0x0f, 0x6f, 0xb1 // clz lt r0 r6
};
const byte kInstruction_clz_vc_r5_r8[] = {
  0x18, 0x5f, 0x6f, 0x71 // clz vc r5 r8
};
const byte kInstruction_clz_gt_r3_r1[] = {
  0x11, 0x3f, 0x6f, 0xc1 // clz gt r3 r1
};
const byte kInstruction_clz_pl_r3_r5[] = {
  0x15, 0x3f, 0x6f, 0x51 // clz pl r3 r5
};
const byte kInstruction_clz_al_r11_r5[] = {
  0x15, 0xbf, 0x6f, 0xe1 // clz al r11 r5
};
const byte kInstruction_clz_hi_r8_r14[] = {
  0x1e, 0x8f, 0x6f, 0x81 // clz hi r8 r14
};
const byte kInstruction_clz_le_r5_r4[] = {
  0x14, 0x5f, 0x6f, 0xd1 // clz le r5 r4
};
const byte kInstruction_clz_ge_r13_r3[] = {
  0x13, 0xdf, 0x6f, 0xa1 // clz ge r13 r3
};
const byte kInstruction_clz_pl_r7_r14[] = {
  0x1e, 0x7f, 0x6f, 0x51 // clz pl r7 r14
};
const byte kInstruction_clz_cs_r6_r9[] = {
  0x19, 0x6f, 0x6f, 0x21 // clz cs r6 r9
};
const byte kInstruction_clz_lt_r8_r12[] = {
  0x1c, 0x8f, 0x6f, 0xb1 // clz lt r8 r12
};
const byte kInstruction_clz_cc_r12_r0[] = {
  0x10, 0xcf, 0x6f, 0x31 // clz cc r12 r0
};
const byte kInstruction_clz_mi_r14_r13[] = {
  0x1d, 0xef, 0x6f, 0x41 // clz mi r14 r13
};
const byte kInstruction_clz_pl_r12_r13[] = {
  0x1d, 0xcf, 0x6f, 0x51 // clz pl r12 r13
};
const byte kInstruction_clz_al_r4_r8[] = {
  0x18, 0x4f, 0x6f, 0xe1 // clz al r4 r8
};
const byte kInstruction_clz_ls_r5_r11[] = {
  0x1b, 0x5f, 0x6f, 0x91 // clz ls r5 r11
};
const byte kInstruction_clz_ge_r11_r3[] = {
  0x13, 0xbf, 0x6f, 0xa1 // clz ge r11 r3
};
const byte kInstruction_clz_le_r1_r0[] = {
  0x10, 0x1f, 0x6f, 0xd1 // clz le r1 r0
};
const byte kInstruction_clz_gt_r14_r4[] = {
  0x14, 0xef, 0x6f, 0xc1 // clz gt r14 r4
};
const byte kInstruction_clz_ne_r3_r14[] = {
  0x1e, 0x3f, 0x6f, 0x11 // clz ne r3 r14
};
const byte kInstruction_clz_cc_r3_r8[] = {
  0x18, 0x3f, 0x6f, 0x31 // clz cc r3 r8
};
const byte kInstruction_clz_eq_r7_r10[] = {
  0x1a, 0x7f, 0x6f, 0x01 // clz eq r7 r10
};
const byte kInstruction_clz_pl_r0_r10[] = {
  0x1a, 0x0f, 0x6f, 0x51 // clz pl r0 r10
};
const byte kInstruction_clz_mi_r6_r13[] = {
  0x1d, 0x6f, 0x6f, 0x41 // clz mi r6 r13
};
const byte kInstruction_clz_gt_r10_r5[] = {
  0x15, 0xaf, 0x6f, 0xc1 // clz gt r10 r5
};
const byte kInstruction_clz_ne_r0_r1[] = {
  0x11, 0x0f, 0x6f, 0x11 // clz ne r0 r1
};
const byte kInstruction_clz_ge_r4_r8[] = {
  0x18, 0x4f, 0x6f, 0xa1 // clz ge r4 r8
};
const byte kInstruction_clz_cs_r3_r7[] = {
  0x17, 0x3f, 0x6f, 0x21 // clz cs r3 r7
};
const byte kInstruction_clz_pl_r2_r12[] = {
  0x1c, 0x2f, 0x6f, 0x51 // clz pl r2 r12
};
const byte kInstruction_clz_ls_r9_r12[] = {
  0x1c, 0x9f, 0x6f, 0x91 // clz ls r9 r12
};
const byte kInstruction_clz_ge_r4_r9[] = {
  0x19, 0x4f, 0x6f, 0xa1 // clz ge r4 r9
};
const byte kInstruction_clz_lt_r7_r2[] = {
  0x12, 0x7f, 0x6f, 0xb1 // clz lt r7 r2
};
const byte kInstruction_clz_hi_r10_r10[] = {
  0x1a, 0xaf, 0x6f, 0x81 // clz hi r10 r10
};
const byte kInstruction_clz_ls_r1_r7[] = {
  0x17, 0x1f, 0x6f, 0x91 // clz ls r1 r7
};
const byte kInstruction_clz_vs_r1_r12[] = {
  0x1c, 0x1f, 0x6f, 0x61 // clz vs r1 r12
};
const byte kInstruction_clz_ge_r9_r14[] = {
  0x1e, 0x9f, 0x6f, 0xa1 // clz ge r9 r14
};
const byte kInstruction_clz_pl_r6_r4[] = {
  0x14, 0x6f, 0x6f, 0x51 // clz pl r6 r4
};
const byte kInstruction_clz_ls_r3_r2[] = {
  0x12, 0x3f, 0x6f, 0x91 // clz ls r3 r2
};
const byte kInstruction_clz_cs_r4_r4[] = {
  0x14, 0x4f, 0x6f, 0x21 // clz cs r4 r4
};
const byte kInstruction_clz_eq_r6_r2[] = {
  0x12, 0x6f, 0x6f, 0x01 // clz eq r6 r2
};
const byte kInstruction_clz_ge_r14_r0[] = {
  0x10, 0xef, 0x6f, 0xa1 // clz ge r14 r0
};
const byte kInstruction_clz_le_r11_r6[] = {
  0x16, 0xbf, 0x6f, 0xd1 // clz le r11 r6
};
const byte kInstruction_clz_vs_r0_r0[] = {
  0x10, 0x0f, 0x6f, 0x61 // clz vs r0 r0
};
const byte kInstruction_clz_vs_r4_r6[] = {
  0x16, 0x4f, 0x6f, 0x61 // clz vs r4 r6
};
const byte kInstruction_clz_gt_r6_r10[] = {
  0x1a, 0x6f, 0x6f, 0xc1 // clz gt r6 r10
};
const byte kInstruction_clz_vc_r12_r7[] = {
  0x17, 0xcf, 0x6f, 0x71 // clz vc r12 r7
};
const byte kInstruction_clz_gt_r8_r3[] = {
  0x13, 0x8f, 0x6f, 0xc1 // clz gt r8 r3
};
const byte kInstruction_clz_hi_r14_r4[] = {
  0x14, 0xef, 0x6f, 0x81 // clz hi r14 r4
};
const byte kInstruction_clz_hi_r9_r14[] = {
  0x1e, 0x9f, 0x6f, 0x81 // clz hi r9 r14
};
const byte kInstruction_clz_vs_r6_r1[] = {
  0x11, 0x6f, 0x6f, 0x61 // clz vs r6 r1
};
const byte kInstruction_clz_hi_r5_r4[] = {
  0x14, 0x5f, 0x6f, 0x81 // clz hi r5 r4
};
const byte kInstruction_clz_lt_r10_r14[] = {
  0x1e, 0xaf, 0x6f, 0xb1 // clz lt r10 r14
};
const byte kInstruction_clz_cc_r8_r10[] = {
  0x1a, 0x8f, 0x6f, 0x31 // clz cc r8 r10
};
const byte kInstruction_clz_lt_r11_r0[] = {
  0x10, 0xbf, 0x6f, 0xb1 // clz lt r11 r0
};
const byte kInstruction_clz_ge_r4_r12[] = {
  0x1c, 0x4f, 0x6f, 0xa1 // clz ge r4 r12
};
const byte kInstruction_clz_cc_r5_r7[] = {
  0x17, 0x5f, 0x6f, 0x31 // clz cc r5 r7
};
const byte kInstruction_clz_gt_r3_r9[] = {
  0x19, 0x3f, 0x6f, 0xc1 // clz gt r3 r9
};
const byte kInstruction_clz_vc_r11_r5[] = {
  0x15, 0xbf, 0x6f, 0x71 // clz vc r11 r5
};
const byte kInstruction_clz_lt_r7_r1[] = {
  0x11, 0x7f, 0x6f, 0xb1 // clz lt r7 r1
};
const byte kInstruction_clz_lt_r1_r8[] = {
  0x18, 0x1f, 0x6f, 0xb1 // clz lt r1 r8
};
const byte kInstruction_clz_hi_r11_r13[] = {
  0x1d, 0xbf, 0x6f, 0x81 // clz hi r11 r13
};
const byte kInstruction_clz_vs_r10_r2[] = {
  0x12, 0xaf, 0x6f, 0x61 // clz vs r10 r2
};
const byte kInstruction_clz_ne_r1_r10[] = {
  0x1a, 0x1f, 0x6f, 0x11 // clz ne r1 r10
};
const byte kInstruction_clz_vc_r10_r0[] = {
  0x10, 0xaf, 0x6f, 0x71 // clz vc r10 r0
};
const byte kInstruction_clz_al_r2_r2[] = {
  0x12, 0x2f, 0x6f, 0xe1 // clz al r2 r2
};
const byte kInstruction_clz_ne_r7_r8[] = {
  0x18, 0x7f, 0x6f, 0x11 // clz ne r7 r8
};
const byte kInstruction_clz_hi_r11_r14[] = {
  0x1e, 0xbf, 0x6f, 0x81 // clz hi r11 r14
};
const byte kInstruction_clz_ne_r6_r14[] = {
  0x1e, 0x6f, 0x6f, 0x11 // clz ne r6 r14
};
const byte kInstruction_clz_ge_r8_r5[] = {
  0x15, 0x8f, 0x6f, 0xa1 // clz ge r8 r5
};
const byte kInstruction_clz_vs_r7_r3[] = {
  0x13, 0x7f, 0x6f, 0x61 // clz vs r7 r3
};
const byte kInstruction_clz_ne_r14_r13[] = {
  0x1d, 0xef, 0x6f, 0x11 // clz ne r14 r13
};
const byte kInstruction_clz_hi_r12_r11[] = {
  0x1b, 0xcf, 0x6f, 0x81 // clz hi r12 r11
};
const byte kInstruction_clz_ls_r11_r9[] = {
  0x19, 0xbf, 0x6f, 0x91 // clz ls r11 r9
};
const byte kInstruction_clz_mi_r12_r7[] = {
  0x17, 0xcf, 0x6f, 0x41 // clz mi r12 r7
};
const byte kInstruction_clz_cc_r8_r8[] = {
  0x18, 0x8f, 0x6f, 0x31 // clz cc r8 r8
};
const byte kInstruction_clz_ls_r14_r12[] = {
  0x1c, 0xef, 0x6f, 0x91 // clz ls r14 r12
};
const byte kInstruction_clz_ls_r3_r6[] = {
  0x16, 0x3f, 0x6f, 0x91 // clz ls r3 r6
};
const byte kInstruction_clz_hi_r7_r8[] = {
  0x18, 0x7f, 0x6f, 0x81 // clz hi r7 r8
};
const byte kInstruction_clz_vs_r4_r10[] = {
  0x1a, 0x4f, 0x6f, 0x61 // clz vs r4 r10
};
const byte kInstruction_clz_ne_r12_r1[] = {
  0x11, 0xcf, 0x6f, 0x11 // clz ne r12 r1
};
const byte kInstruction_clz_vs_r12_r4[] = {
  0x14, 0xcf, 0x6f, 0x61 // clz vs r12 r4
};
const byte kInstruction_clz_hi_r5_r5[] = {
  0x15, 0x5f, 0x6f, 0x81 // clz hi r5 r5
};
const byte kInstruction_clz_gt_r8_r8[] = {
  0x18, 0x8f, 0x6f, 0xc1 // clz gt r8 r8
};
const byte kInstruction_clz_lt_r10_r10[] = {
  0x1a, 0xaf, 0x6f, 0xb1 // clz lt r10 r10
};
const byte kInstruction_clz_vs_r13_r4[] = {
  0x14, 0xdf, 0x6f, 0x61 // clz vs r13 r4
};
const byte kInstruction_clz_mi_r8_r3[] = {
  0x13, 0x8f, 0x6f, 0x41 // clz mi r8 r3
};
const byte kInstruction_clz_eq_r6_r13[] = {
  0x1d, 0x6f, 0x6f, 0x01 // clz eq r6 r13
};
const byte kInstruction_clz_al_r2_r0[] = {
  0x10, 0x2f, 0x6f, 0xe1 // clz al r2 r0
};
const byte kInstruction_clz_ls_r6_r12[] = {
  0x1c, 0x6f, 0x6f, 0x91 // clz ls r6 r12
};
const byte kInstruction_clz_vs_r1_r4[] = {
  0x14, 0x1f, 0x6f, 0x61 // clz vs r1 r4
};
const byte kInstruction_clz_vc_r11_r1[] = {
  0x11, 0xbf, 0x6f, 0x71 // clz vc r11 r1
};
const byte kInstruction_clz_ne_r9_r10[] = {
  0x1a, 0x9f, 0x6f, 0x11 // clz ne r9 r10
};
const byte kInstruction_clz_ne_r3_r10[] = {
  0x1a, 0x3f, 0x6f, 0x11 // clz ne r3 r10
};
const byte kInstruction_clz_hi_r7_r10[] = {
  0x1a, 0x7f, 0x6f, 0x81 // clz hi r7 r10
};
const byte kInstruction_clz_pl_r4_r10[] = {
  0x1a, 0x4f, 0x6f, 0x51 // clz pl r4 r10
};
const byte kInstruction_clz_le_r7_r1[] = {
  0x11, 0x7f, 0x6f, 0xd1 // clz le r7 r1
};
const byte kInstruction_clz_gt_r13_r10[] = {
  0x1a, 0xdf, 0x6f, 0xc1 // clz gt r13 r10
};
const byte kInstruction_clz_lt_r4_r14[] = {
  0x1e, 0x4f, 0x6f, 0xb1 // clz lt r4 r14
};
const byte kInstruction_clz_al_r10_r1[] = {
  0x11, 0xaf, 0x6f, 0xe1 // clz al r10 r1
};
const byte kInstruction_clz_mi_r6_r12[] = {
  0x1c, 0x6f, 0x6f, 0x41 // clz mi r6 r12
};
const byte kInstruction_clz_eq_r13_r9[] = {
  0x19, 0xdf, 0x6f, 0x01 // clz eq r13 r9
};
const byte kInstruction_clz_ge_r11_r4[] = {
  0x14, 0xbf, 0x6f, 0xa1 // clz ge r11 r4
};
const byte kInstruction_clz_hi_r1_r12[] = {
  0x1c, 0x1f, 0x6f, 0x81 // clz hi r1 r12
};
const byte kInstruction_clz_ge_r0_r1[] = {
  0x11, 0x0f, 0x6f, 0xa1 // clz ge r0 r1
};
const byte kInstruction_clz_lt_r2_r3[] = {
  0x13, 0x2f, 0x6f, 0xb1 // clz lt r2 r3
};
const byte kInstruction_clz_al_r12_r9[] = {
  0x19, 0xcf, 0x6f, 0xe1 // clz al r12 r9
};
const byte kInstruction_clz_hi_r2_r10[] = {
  0x1a, 0x2f, 0x6f, 0x81 // clz hi r2 r10
};
const byte kInstruction_clz_mi_r14_r11[] = {
  0x1b, 0xef, 0x6f, 0x41 // clz mi r14 r11
};
const byte kInstruction_clz_pl_r3_r10[] = {
  0x1a, 0x3f, 0x6f, 0x51 // clz pl r3 r10
};
const byte kInstruction_clz_vs_r1_r6[] = {
  0x16, 0x1f, 0x6f, 0x61 // clz vs r1 r6
};
const byte kInstruction_clz_al_r7_r6[] = {
  0x16, 0x7f, 0x6f, 0xe1 // clz al r7 r6
};
const byte kInstruction_clz_ge_r6_r8[] = {
  0x18, 0x6f, 0x6f, 0xa1 // clz ge r6 r8
};
const byte kInstruction_clz_eq_r3_r3[] = {
  0x13, 0x3f, 0x6f, 0x01 // clz eq r3 r3
};
const byte kInstruction_clz_ne_r14_r4[] = {
  0x14, 0xef, 0x6f, 0x11 // clz ne r14 r4
};
const byte kInstruction_clz_vc_r13_r10[] = {
  0x1a, 0xdf, 0x6f, 0x71 // clz vc r13 r10
};
const byte kInstruction_clz_mi_r3_r12[] = {
  0x1c, 0x3f, 0x6f, 0x41 // clz mi r3 r12
};
const byte kInstruction_clz_pl_r9_r1[] = {
  0x11, 0x9f, 0x6f, 0x51 // clz pl r9 r1
};
const byte kInstruction_clz_hi_r14_r14[] = {
  0x1e, 0xef, 0x6f, 0x81 // clz hi r14 r14
};
const byte kInstruction_clz_ne_r0_r9[] = {
  0x19, 0x0f, 0x6f, 0x11 // clz ne r0 r9
};
const byte kInstruction_clz_mi_r1_r1[] = {
  0x11, 0x1f, 0x6f, 0x41 // clz mi r1 r1
};
const byte kInstruction_clz_hi_r7_r2[] = {
  0x12, 0x7f, 0x6f, 0x81 // clz hi r7 r2
};
const byte kInstruction_clz_gt_r2_r3[] = {
  0x13, 0x2f, 0x6f, 0xc1 // clz gt r2 r3
};
const byte kInstruction_clz_eq_r2_r0[] = {
  0x10, 0x2f, 0x6f, 0x01 // clz eq r2 r0
};
const byte kInstruction_clz_vs_r10_r12[] = {
  0x1c, 0xaf, 0x6f, 0x61 // clz vs r10 r12
};
const byte kInstruction_clz_gt_r11_r7[] = {
  0x17, 0xbf, 0x6f, 0xc1 // clz gt r11 r7
};
const byte kInstruction_clz_vs_r13_r2[] = {
  0x12, 0xdf, 0x6f, 0x61 // clz vs r13 r2
};
const byte kInstruction_clz_ls_r11_r12[] = {
  0x1c, 0xbf, 0x6f, 0x91 // clz ls r11 r12
};
const byte kInstruction_clz_al_r8_r8[] = {
  0x18, 0x8f, 0x6f, 0xe1 // clz al r8 r8
};
const byte kInstruction_clz_hi_r6_r10[] = {
  0x1a, 0x6f, 0x6f, 0x81 // clz hi r6 r10
};
const byte kInstruction_clz_vs_r5_r1[] = {
  0x11, 0x5f, 0x6f, 0x61 // clz vs r5 r1
};
const byte kInstruction_clz_ls_r0_r10[] = {
  0x1a, 0x0f, 0x6f, 0x91 // clz ls r0 r10
};
const byte kInstruction_clz_gt_r0_r1[] = {
  0x11, 0x0f, 0x6f, 0xc1 // clz gt r0 r1
};
const byte kInstruction_clz_ne_r11_r12[] = {
  0x1c, 0xbf, 0x6f, 0x11 // clz ne r11 r12
};
const byte kInstruction_clz_ne_r13_r5[] = {
  0x15, 0xdf, 0x6f, 0x11 // clz ne r13 r5
};
const byte kInstruction_clz_mi_r0_r12[] = {
  0x1c, 0x0f, 0x6f, 0x41 // clz mi r0 r12
};
const byte kInstruction_clz_lt_r11_r6[] = {
  0x16, 0xbf, 0x6f, 0xb1 // clz lt r11 r6
};
const byte kInstruction_clz_eq_r11_r14[] = {
  0x1e, 0xbf, 0x6f, 0x01 // clz eq r11 r14
};
const byte kInstruction_clz_vc_r11_r10[] = {
  0x1a, 0xbf, 0x6f, 0x71 // clz vc r11 r10
};
const byte kInstruction_clz_cs_r3_r3[] = {
  0x13, 0x3f, 0x6f, 0x21 // clz cs r3 r3
};
const byte kInstruction_clz_le_r12_r2[] = {
  0x12, 0xcf, 0x6f, 0xd1 // clz le r12 r2
};
const byte kInstruction_clz_hi_r13_r8[] = {
  0x18, 0xdf, 0x6f, 0x81 // clz hi r13 r8
};
const byte kInstruction_clz_pl_r6_r6[] = {
  0x16, 0x6f, 0x6f, 0x51 // clz pl r6 r6
};
const byte kInstruction_clz_al_r4_r5[] = {
  0x15, 0x4f, 0x6f, 0xe1 // clz al r4 r5
};
const byte kInstruction_clz_hi_r1_r0[] = {
  0x10, 0x1f, 0x6f, 0x81 // clz hi r1 r0
};
const byte kInstruction_clz_ls_r10_r11[] = {
  0x1b, 0xaf, 0x6f, 0x91 // clz ls r10 r11
};
const byte kInstruction_clz_al_r8_r7[] = {
  0x17, 0x8f, 0x6f, 0xe1 // clz al r8 r7
};
const byte kInstruction_clz_vc_r7_r1[] = {
  0x11, 0x7f, 0x6f, 0x71 // clz vc r7 r1
};
const byte kInstruction_clz_ne_r7_r14[] = {
  0x1e, 0x7f, 0x6f, 0x11 // clz ne r7 r14
};
const byte kInstruction_clz_lt_r5_r9[] = {
  0x19, 0x5f, 0x6f, 0xb1 // clz lt r5 r9
};
const byte kInstruction_clz_al_r13_r8[] = {
  0x18, 0xdf, 0x6f, 0xe1 // clz al r13 r8
};
const byte kInstruction_clz_ls_r6_r14[] = {
  0x1e, 0x6f, 0x6f, 0x91 // clz ls r6 r14
};
const byte kInstruction_clz_eq_r12_r0[] = {
  0x10, 0xcf, 0x6f, 0x01 // clz eq r12 r0
};
const byte kInstruction_clz_mi_r8_r14[] = {
  0x1e, 0x8f, 0x6f, 0x41 // clz mi r8 r14
};
const byte kInstruction_clz_hi_r13_r2[] = {
  0x12, 0xdf, 0x6f, 0x81 // clz hi r13 r2
};
const byte kInstruction_clz_al_r13_r2[] = {
  0x12, 0xdf, 0x6f, 0xe1 // clz al r13 r2
};
const byte kInstruction_clz_vs_r8_r9[] = {
  0x19, 0x8f, 0x6f, 0x61 // clz vs r8 r9
};
const byte kInstruction_clz_cc_r6_r2[] = {
  0x12, 0x6f, 0x6f, 0x31 // clz cc r6 r2
};
const byte kInstruction_clz_lt_r8_r0[] = {
  0x10, 0x8f, 0x6f, 0xb1 // clz lt r8 r0
};
const byte kInstruction_clz_ls_r3_r13[] = {
  0x1d, 0x3f, 0x6f, 0x91 // clz ls r3 r13
};
const byte kInstruction_clz_gt_r10_r14[] = {
  0x1e, 0xaf, 0x6f, 0xc1 // clz gt r10 r14
};
const byte kInstruction_clz_pl_r9_r8[] = {
  0x18, 0x9f, 0x6f, 0x51 // clz pl r9 r8
};
const byte kInstruction_clz_pl_r14_r11[] = {
  0x1b, 0xef, 0x6f, 0x51 // clz pl r14 r11
};
const byte kInstruction_clz_lt_r9_r3[] = {
  0x13, 0x9f, 0x6f, 0xb1 // clz lt r9 r3
};
const byte kInstruction_clz_hi_r9_r0[] = {
  0x10, 0x9f, 0x6f, 0x81 // clz hi r9 r0
};
const byte kInstruction_clz_cc_r9_r3[] = {
  0x13, 0x9f, 0x6f, 0x31 // clz cc r9 r3
};
const byte kInstruction_clz_ge_r10_r14[] = {
  0x1e, 0xaf, 0x6f, 0xa1 // clz ge r10 r14
};
const byte kInstruction_clz_vs_r2_r1[] = {
  0x11, 0x2f, 0x6f, 0x61 // clz vs r2 r1
};
const byte kInstruction_clz_vc_r4_r13[] = {
  0x1d, 0x4f, 0x6f, 0x71 // clz vc r4 r13
};
const byte kInstruction_clz_ls_r1_r9[] = {
  0x19, 0x1f, 0x6f, 0x91 // clz ls r1 r9
};
const byte kInstruction_clz_lt_r13_r11[] = {
  0x1b, 0xdf, 0x6f, 0xb1 // clz lt r13 r11
};
const byte kInstruction_clz_cs_r2_r10[] = {
  0x1a, 0x2f, 0x6f, 0x21 // clz cs r2 r10
};
const byte kInstruction_clz_le_r0_r13[] = {
  0x1d, 0x0f, 0x6f, 0xd1 // clz le r0 r13
};
const byte kInstruction_clz_al_r13_r11[] = {
  0x1b, 0xdf, 0x6f, 0xe1 // clz al r13 r11
};
const byte kInstruction_clz_eq_r5_r2[] = {
  0x12, 0x5f, 0x6f, 0x01 // clz eq r5 r2
};
const byte kInstruction_clz_vs_r5_r12[] = {
  0x1c, 0x5f, 0x6f, 0x61 // clz vs r5 r12
};
const byte kInstruction_clz_al_r12_r0[] = {
  0x10, 0xcf, 0x6f, 0xe1 // clz al r12 r0
};
const byte kInstruction_clz_le_r13_r9[] = {
  0x19, 0xdf, 0x6f, 0xd1 // clz le r13 r9
};
const byte kInstruction_clz_cs_r14_r4[] = {
  0x14, 0xef, 0x6f, 0x21 // clz cs r14 r4
};
const byte kInstruction_clz_ne_r5_r7[] = {
  0x17, 0x5f, 0x6f, 0x11 // clz ne r5 r7
};
const byte kInstruction_clz_al_r6_r6[] = {
  0x16, 0x6f, 0x6f, 0xe1 // clz al r6 r6
};
const byte kInstruction_clz_gt_r4_r8[] = {
  0x18, 0x4f, 0x6f, 0xc1 // clz gt r4 r8
};
const byte kInstruction_clz_gt_r12_r8[] = {
  0x18, 0xcf, 0x6f, 0xc1 // clz gt r12 r8
};
const byte kInstruction_clz_eq_r4_r12[] = {
  0x1c, 0x4f, 0x6f, 0x01 // clz eq r4 r12
};
const byte kInstruction_clz_cs_r7_r13[] = {
  0x1d, 0x7f, 0x6f, 0x21 // clz cs r7 r13
};
const byte kInstruction_clz_cs_r2_r4[] = {
  0x14, 0x2f, 0x6f, 0x21 // clz cs r2 r4
};
const byte kInstruction_clz_al_r10_r3[] = {
  0x13, 0xaf, 0x6f, 0xe1 // clz al r10 r3
};
const byte kInstruction_clz_cs_r8_r9[] = {
  0x19, 0x8f, 0x6f, 0x21 // clz cs r8 r9
};
const byte kInstruction_clz_cs_r1_r12[] = {
  0x1c, 0x1f, 0x6f, 0x21 // clz cs r1 r12
};
const byte kInstruction_clz_gt_r13_r0[] = {
  0x10, 0xdf, 0x6f, 0xc1 // clz gt r13 r0
};
const byte kInstruction_clz_vc_r13_r12[] = {
  0x1c, 0xdf, 0x6f, 0x71 // clz vc r13 r12
};
const byte kInstruction_clz_lt_r12_r14[] = {
  0x1e, 0xcf, 0x6f, 0xb1 // clz lt r12 r14
};
const byte kInstruction_clz_lt_r0_r1[] = {
  0x11, 0x0f, 0x6f, 0xb1 // clz lt r0 r1
};
const byte kInstruction_clz_cc_r10_r2[] = {
  0x12, 0xaf, 0x6f, 0x31 // clz cc r10 r2
};
const byte kInstruction_clz_le_r3_r5[] = {
  0x15, 0x3f, 0x6f, 0xd1 // clz le r3 r5
};
const byte kInstruction_clz_eq_r2_r11[] = {
  0x1b, 0x2f, 0x6f, 0x01 // clz eq r2 r11
};
const byte kInstruction_clz_al_r12_r4[] = {
  0x14, 0xcf, 0x6f, 0xe1 // clz al r12 r4
};
const byte kInstruction_clz_cs_r6_r5[] = {
  0x15, 0x6f, 0x6f, 0x21 // clz cs r6 r5
};
const byte kInstruction_clz_hi_r13_r10[] = {
  0x1a, 0xdf, 0x6f, 0x81 // clz hi r13 r10
};
const byte kInstruction_clz_vs_r4_r3[] = {
  0x13, 0x4f, 0x6f, 0x61 // clz vs r4 r3
};
const byte kInstruction_clz_ls_r7_r9[] = {
  0x19, 0x7f, 0x6f, 0x91 // clz ls r7 r9
};
const byte kInstruction_clz_vs_r14_r8[] = {
  0x18, 0xef, 0x6f, 0x61 // clz vs r14 r8
};
const byte kInstruction_clz_cs_r1_r0[] = {
  0x10, 0x1f, 0x6f, 0x21 // clz cs r1 r0
};
const byte kInstruction_clz_mi_r10_r8[] = {
  0x18, 0xaf, 0x6f, 0x41 // clz mi r10 r8
};
const byte kInstruction_clz_ge_r10_r4[] = {
  0x14, 0xaf, 0x6f, 0xa1 // clz ge r10 r4
};
const byte kInstruction_clz_cc_r5_r4[] = {
  0x14, 0x5f, 0x6f, 0x31 // clz cc r5 r4
};
const byte kInstruction_clz_lt_r0_r7[] = {
  0x17, 0x0f, 0x6f, 0xb1 // clz lt r0 r7
};
const byte kInstruction_clz_mi_r14_r10[] = {
  0x1a, 0xef, 0x6f, 0x41 // clz mi r14 r10
};
const byte kInstruction_clz_mi_r0_r14[] = {
  0x1e, 0x0f, 0x6f, 0x41 // clz mi r0 r14
};
const byte kInstruction_clz_eq_r14_r10[] = {
  0x1a, 0xef, 0x6f, 0x01 // clz eq r14 r10
};
const byte kInstruction_clz_ls_r4_r4[] = {
  0x14, 0x4f, 0x6f, 0x91 // clz ls r4 r4
};
const byte kInstruction_clz_pl_r14_r1[] = {
  0x11, 0xef, 0x6f, 0x51 // clz pl r14 r1
};
const byte kInstruction_clz_eq_r10_r8[] = {
  0x18, 0xaf, 0x6f, 0x01 // clz eq r10 r8
};
const byte kInstruction_clz_cs_r10_r6[] = {
  0x16, 0xaf, 0x6f, 0x21 // clz cs r10 r6
};
const byte kInstruction_clz_al_r12_r2[] = {
  0x12, 0xcf, 0x6f, 0xe1 // clz al r12 r2
};
const byte kInstruction_clz_ls_r12_r1[] = {
  0x11, 0xcf, 0x6f, 0x91 // clz ls r12 r1
};
const byte kInstruction_clz_eq_r12_r11[] = {
  0x1b, 0xcf, 0x6f, 0x01 // clz eq r12 r11
};
const byte kInstruction_clz_vc_r4_r1[] = {
  0x11, 0x4f, 0x6f, 0x71 // clz vc r4 r1
};
const byte kInstruction_clz_vs_r12_r2[] = {
  0x12, 0xcf, 0x6f, 0x61 // clz vs r12 r2
};
const byte kInstruction_clz_al_r11_r8[] = {
  0x18, 0xbf, 0x6f, 0xe1 // clz al r11 r8
};
const byte kInstruction_clz_hi_r6_r13[] = {
  0x1d, 0x6f, 0x6f, 0x81 // clz hi r6 r13
};
const byte kInstruction_clz_eq_r2_r8[] = {
  0x18, 0x2f, 0x6f, 0x01 // clz eq r2 r8
};
const byte kInstruction_clz_cc_r9_r5[] = {
  0x15, 0x9f, 0x6f, 0x31 // clz cc r9 r5
};
const byte kInstruction_clz_cc_r9_r7[] = {
  0x17, 0x9f, 0x6f, 0x31 // clz cc r9 r7
};
const byte kInstruction_clz_lt_r4_r6[] = {
  0x16, 0x4f, 0x6f, 0xb1 // clz lt r4 r6
};
const byte kInstruction_clz_cc_r14_r13[] = {
  0x1d, 0xef, 0x6f, 0x31 // clz cc r14 r13
};
const byte kInstruction_clz_vc_r3_r2[] = {
  0x12, 0x3f, 0x6f, 0x71 // clz vc r3 r2
};
const byte kInstruction_clz_al_r6_r13[] = {
  0x1d, 0x6f, 0x6f, 0xe1 // clz al r6 r13
};
const byte kInstruction_clz_vs_r10_r10[] = {
  0x1a, 0xaf, 0x6f, 0x61 // clz vs r10 r10
};
const byte kInstruction_clz_cs_r6_r10[] = {
  0x1a, 0x6f, 0x6f, 0x21 // clz cs r6 r10
};
const byte kInstruction_clz_cc_r8_r12[] = {
  0x1c, 0x8f, 0x6f, 0x31 // clz cc r8 r12
};
const byte kInstruction_clz_vs_r7_r5[] = {
  0x15, 0x7f, 0x6f, 0x61 // clz vs r7 r5
};
const byte kInstruction_clz_pl_r14_r10[] = {
  0x1a, 0xef, 0x6f, 0x51 // clz pl r14 r10
};
const byte kInstruction_clz_hi_r1_r14[] = {
  0x1e, 0x1f, 0x6f, 0x81 // clz hi r1 r14
};
const byte kInstruction_clz_vc_r8_r12[] = {
  0x1c, 0x8f, 0x6f, 0x71 // clz vc r8 r12
};
const byte kInstruction_clz_ls_r2_r4[] = {
  0x14, 0x2f, 0x6f, 0x91 // clz ls r2 r4
};
const byte kInstruction_clz_mi_r5_r12[] = {
  0x1c, 0x5f, 0x6f, 0x41 // clz mi r5 r12
};
const byte kInstruction_clz_eq_r6_r12[] = {
  0x1c, 0x6f, 0x6f, 0x01 // clz eq r6 r12
};
const byte kInstruction_clz_lt_r14_r9[] = {
  0x19, 0xef, 0x6f, 0xb1 // clz lt r14 r9
};
const byte kInstruction_clz_lt_r11_r9[] = {
  0x19, 0xbf, 0x6f, 0xb1 // clz lt r11 r9
};
const byte kInstruction_clz_ne_r1_r9[] = {
  0x19, 0x1f, 0x6f, 0x11 // clz ne r1 r9
};
const byte kInstruction_clz_pl_r11_r8[] = {
  0x18, 0xbf, 0x6f, 0x51 // clz pl r11 r8
};
const byte kInstruction_clz_ne_r0_r6[] = {
  0x16, 0x0f, 0x6f, 0x11 // clz ne r0 r6
};
const byte kInstruction_clz_vs_r4_r4[] = {
  0x14, 0x4f, 0x6f, 0x61 // clz vs r4 r4
};
const byte kInstruction_clz_ls_r12_r9[] = {
  0x19, 0xcf, 0x6f, 0x91 // clz ls r12 r9
};
const byte kInstruction_clz_cs_r9_r7[] = {
  0x17, 0x9f, 0x6f, 0x21 // clz cs r9 r7
};
const byte kInstruction_clz_ne_r7_r2[] = {
  0x12, 0x7f, 0x6f, 0x11 // clz ne r7 r2
};
const byte kInstruction_clz_hi_r9_r10[] = {
  0x1a, 0x9f, 0x6f, 0x81 // clz hi r9 r10
};
const byte kInstruction_clz_gt_r5_r2[] = {
  0x12, 0x5f, 0x6f, 0xc1 // clz gt r5 r2
};
const byte kInstruction_clz_pl_r4_r6[] = {
  0x16, 0x4f, 0x6f, 0x51 // clz pl r4 r6
};
const byte kInstruction_clz_lt_r11_r8[] = {
  0x18, 0xbf, 0x6f, 0xb1 // clz lt r11 r8
};
const byte kInstruction_clz_hi_r13_r4[] = {
  0x14, 0xdf, 0x6f, 0x81 // clz hi r13 r4
};
const byte kInstruction_clz_le_r1_r10[] = {
  0x1a, 0x1f, 0x6f, 0xd1 // clz le r1 r10
};
const byte kInstruction_clz_le_r11_r3[] = {
  0x13, 0xbf, 0x6f, 0xd1 // clz le r11 r3
};
const byte kInstruction_clz_pl_r0_r11[] = {
  0x1b, 0x0f, 0x6f, 0x51 // clz pl r0 r11
};
const byte kInstruction_clz_le_r7_r4[] = {
  0x14, 0x7f, 0x6f, 0xd1 // clz le r7 r4
};
const byte kInstruction_clz_le_r2_r11[] = {
  0x1b, 0x2f, 0x6f, 0xd1 // clz le r2 r11
};
const byte kInstruction_clz_cc_r1_r10[] = {
  0x1a, 0x1f, 0x6f, 0x31 // clz cc r1 r10
};
const byte kInstruction_clz_gt_r13_r14[] = {
  0x1e, 0xdf, 0x6f, 0xc1 // clz gt r13 r14
};
const byte kInstruction_clz_ls_r10_r6[] = {
  0x16, 0xaf, 0x6f, 0x91 // clz ls r10 r6
};
const byte kInstruction_clz_ls_r13_r4[] = {
  0x14, 0xdf, 0x6f, 0x91 // clz ls r13 r4
};
const byte kInstruction_clz_gt_r12_r13[] = {
  0x1d, 0xcf, 0x6f, 0xc1 // clz gt r12 r13
};
const byte kInstruction_clz_pl_r13_r7[] = {
  0x17, 0xdf, 0x6f, 0x51 // clz pl r13 r7
};
const byte kInstruction_clz_le_r14_r0[] = {
  0x10, 0xef, 0x6f, 0xd1 // clz le r14 r0
};
const byte kInstruction_clz_gt_r1_r4[] = {
  0x14, 0x1f, 0x6f, 0xc1 // clz gt r1 r4
};
const byte kInstruction_clz_mi_r3_r5[] = {
  0x15, 0x3f, 0x6f, 0x41 // clz mi r3 r5
};
const byte kInstruction_clz_vc_r4_r0[] = {
  0x10, 0x4f, 0x6f, 0x71 // clz vc r4 r0
};
const byte kInstruction_clz_gt_r4_r11[] = {
  0x1b, 0x4f, 0x6f, 0xc1 // clz gt r4 r11
};
const byte kInstruction_clz_vc_r5_r3[] = {
  0x13, 0x5f, 0x6f, 0x71 // clz vc r5 r3
};
const byte kInstruction_clz_pl_r4_r7[] = {
  0x17, 0x4f, 0x6f, 0x51 // clz pl r4 r7
};
const byte kInstruction_clz_al_r12_r6[] = {
  0x16, 0xcf, 0x6f, 0xe1 // clz al r12 r6
};
const byte kInstruction_clz_mi_r2_r3[] = {
  0x13, 0x2f, 0x6f, 0x41 // clz mi r2 r3
};
const byte kInstruction_clz_lt_r12_r4[] = {
  0x14, 0xcf, 0x6f, 0xb1 // clz lt r12 r4
};
const byte kInstruction_clz_lt_r10_r4[] = {
  0x14, 0xaf, 0x6f, 0xb1 // clz lt r10 r4
};
const byte kInstruction_clz_hi_r10_r8[] = {
  0x18, 0xaf, 0x6f, 0x81 // clz hi r10 r8
};
const byte kInstruction_clz_al_r0_r14[] = {
  0x1e, 0x0f, 0x6f, 0xe1 // clz al r0 r14
};
const byte kInstruction_clz_cc_r3_r3[] = {
  0x13, 0x3f, 0x6f, 0x31 // clz cc r3 r3
};
const byte kInstruction_clz_pl_r10_r13[] = {
  0x1d, 0xaf, 0x6f, 0x51 // clz pl r10 r13
};
const byte kInstruction_clz_lt_r7_r8[] = {
  0x18, 0x7f, 0x6f, 0xb1 // clz lt r7 r8
};
const byte kInstruction_clz_le_r12_r7[] = {
  0x17, 0xcf, 0x6f, 0xd1 // clz le r12 r7
};
const byte kInstruction_clz_ge_r11_r8[] = {
  0x18, 0xbf, 0x6f, 0xa1 // clz ge r11 r8
};
const byte kInstruction_clz_ls_r10_r8[] = {
  0x18, 0xaf, 0x6f, 0x91 // clz ls r10 r8
};
const byte kInstruction_clz_vs_r9_r1[] = {
  0x11, 0x9f, 0x6f, 0x61 // clz vs r9 r1
};
const byte kInstruction_clz_ne_r10_r10[] = {
  0x1a, 0xaf, 0x6f, 0x11 // clz ne r10 r10
};
const byte kInstruction_clz_al_r6_r4[] = {
  0x14, 0x6f, 0x6f, 0xe1 // clz al r6 r4
};
const byte kInstruction_clz_ls_r10_r0[] = {
  0x10, 0xaf, 0x6f, 0x91 // clz ls r10 r0
};
const byte kInstruction_clz_eq_r7_r1[] = {
  0x11, 0x7f, 0x6f, 0x01 // clz eq r7 r1
};
const byte kInstruction_clz_al_r11_r6[] = {
  0x16, 0xbf, 0x6f, 0xe1 // clz al r11 r6
};
const byte kInstruction_clz_ge_r5_r10[] = {
  0x1a, 0x5f, 0x6f, 0xa1 // clz ge r5 r10
};
const byte kInstruction_clz_vs_r0_r8[] = {
  0x18, 0x0f, 0x6f, 0x61 // clz vs r0 r8
};
const byte kInstruction_clz_lt_r2_r1[] = {
  0x11, 0x2f, 0x6f, 0xb1 // clz lt r2 r1
};
const byte kInstruction_clz_le_r13_r2[] = {
  0x12, 0xdf, 0x6f, 0xd1 // clz le r13 r2
};
const byte kInstruction_clz_al_r13_r6[] = {
  0x16, 0xdf, 0x6f, 0xe1 // clz al r13 r6
};
const byte kInstruction_clz_lt_r12_r10[] = {
  0x1a, 0xcf, 0x6f, 0xb1 // clz lt r12 r10
};
const byte kInstruction_clz_al_r13_r1[] = {
  0x11, 0xdf, 0x6f, 0xe1 // clz al r13 r1
};
const byte kInstruction_clz_ge_r8_r14[] = {
  0x1e, 0x8f, 0x6f, 0xa1 // clz ge r8 r14
};
const byte kInstruction_clz_mi_r11_r6[] = {
  0x16, 0xbf, 0x6f, 0x41 // clz mi r11 r6
};
const byte kInstruction_clz_pl_r12_r14[] = {
  0x1e, 0xcf, 0x6f, 0x51 // clz pl r12 r14
};
const byte kInstruction_clz_ne_r14_r9[] = {
  0x19, 0xef, 0x6f, 0x11 // clz ne r14 r9
};
const byte kInstruction_clz_cc_r3_r1[] = {
  0x11, 0x3f, 0x6f, 0x31 // clz cc r3 r1
};
const byte kInstruction_clz_ge_r0_r8[] = {
  0x18, 0x0f, 0x6f, 0xa1 // clz ge r0 r8
};
const byte kInstruction_clz_vc_r7_r9[] = {
  0x19, 0x7f, 0x6f, 0x71 // clz vc r7 r9
};
const byte kInstruction_clz_gt_r11_r4[] = {
  0x14, 0xbf, 0x6f, 0xc1 // clz gt r11 r4
};
const byte kInstruction_clz_mi_r4_r0[] = {
  0x10, 0x4f, 0x6f, 0x41 // clz mi r4 r0
};
const byte kInstruction_clz_ls_r3_r11[] = {
  0x1b, 0x3f, 0x6f, 0x91 // clz ls r3 r11
};
const byte kInstruction_clz_le_r14_r5[] = {
  0x15, 0xef, 0x6f, 0xd1 // clz le r14 r5
};
const byte kInstruction_clz_ls_r6_r7[] = {
  0x17, 0x6f, 0x6f, 0x91 // clz ls r6 r7
};
const byte kInstruction_clz_ne_r4_r6[] = {
  0x16, 0x4f, 0x6f, 0x11 // clz ne r4 r6
};
const byte kInstruction_clz_cc_r1_r14[] = {
  0x1e, 0x1f, 0x6f, 0x31 // clz cc r1 r14
};
const byte kInstruction_clz_pl_r11_r7[] = {
  0x17, 0xbf, 0x6f, 0x51 // clz pl r11 r7
};
const byte kInstruction_clz_vc_r6_r5[] = {
  0x15, 0x6f, 0x6f, 0x71 // clz vc r6 r5
};
const byte kInstruction_clz_al_r1_r11[] = {
  0x1b, 0x1f, 0x6f, 0xe1 // clz al r1 r11
};
const byte kInstruction_clz_ne_r2_r13[] = {
  0x1d, 0x2f, 0x6f, 0x11 // clz ne r2 r13
};
const byte kInstruction_clz_vc_r14_r6[] = {
  0x16, 0xef, 0x6f, 0x71 // clz vc r14 r6
};
const byte kInstruction_clz_gt_r3_r8[] = {
  0x18, 0x3f, 0x6f, 0xc1 // clz gt r3 r8
};
const byte kInstruction_clz_pl_r1_r8[] = {
  0x18, 0x1f, 0x6f, 0x51 // clz pl r1 r8
};
const byte kInstruction_clz_vc_r2_r14[] = {
  0x1e, 0x2f, 0x6f, 0x71 // clz vc r2 r14
};
const byte kInstruction_clz_pl_r12_r3[] = {
  0x13, 0xcf, 0x6f, 0x51 // clz pl r12 r3
};
const byte kInstruction_clz_ls_r0_r12[] = {
  0x1c, 0x0f, 0x6f, 0x91 // clz ls r0 r12
};
const byte kInstruction_clz_le_r2_r1[] = {
  0x11, 0x2f, 0x6f, 0xd1 // clz le r2 r1
};
const byte kInstruction_clz_eq_r13_r5[] = {
  0x15, 0xdf, 0x6f, 0x01 // clz eq r13 r5
};
const byte kInstruction_clz_al_r11_r11[] = {
  0x1b, 0xbf, 0x6f, 0xe1 // clz al r11 r11
};
const byte kInstruction_clz_ls_r9_r3[] = {
  0x13, 0x9f, 0x6f, 0x91 // clz ls r9 r3
};
const byte kInstruction_clz_ne_r7_r12[] = {
  0x1c, 0x7f, 0x6f, 0x11 // clz ne r7 r12
};
const byte kInstruction_clz_al_r6_r2[] = {
  0x12, 0x6f, 0x6f, 0xe1 // clz al r6 r2
};
const byte kInstruction_clz_ne_r7_r4[] = {
  0x14, 0x7f, 0x6f, 0x11 // clz ne r7 r4
};
const byte kInstruction_clz_vc_r7_r5[] = {
  0x15, 0x7f, 0x6f, 0x71 // clz vc r7 r5
};
const byte kInstruction_clz_ne_r7_r1[] = {
  0x11, 0x7f, 0x6f, 0x11 // clz ne r7 r1
};
const byte kInstruction_clz_eq_r5_r3[] = {
  0x13, 0x5f, 0x6f, 0x01 // clz eq r5 r3
};
const byte kInstruction_clz_cs_r3_r5[] = {
  0x15, 0x3f, 0x6f, 0x21 // clz cs r3 r5
};
const byte kInstruction_clz_lt_r7_r4[] = {
  0x14, 0x7f, 0x6f, 0xb1 // clz lt r7 r4
};
const byte kInstruction_clz_ls_r4_r5[] = {
  0x15, 0x4f, 0x6f, 0x91 // clz ls r4 r5
};
const byte kInstruction_clz_eq_r11_r2[] = {
  0x12, 0xbf, 0x6f, 0x01 // clz eq r11 r2
};
const byte kInstruction_clz_hi_r2_r6[] = {
  0x16, 0x2f, 0x6f, 0x81 // clz hi r2 r6
};
const byte kInstruction_clz_vc_r2_r3[] = {
  0x13, 0x2f, 0x6f, 0x71 // clz vc r2 r3
};
const byte kInstruction_clz_ls_r12_r12[] = {
  0x1c, 0xcf, 0x6f, 0x91 // clz ls r12 r12
};
const byte kInstruction_clz_lt_r8_r2[] = {
  0x12, 0x8f, 0x6f, 0xb1 // clz lt r8 r2
};
const byte kInstruction_clz_cc_r14_r8[] = {
  0x18, 0xef, 0x6f, 0x31 // clz cc r14 r8
};
const byte kInstruction_clz_ge_r12_r8[] = {
  0x18, 0xcf, 0x6f, 0xa1 // clz ge r12 r8
};
const TestResult kReferenceclz[] = {
  {
    ARRAY_SIZE(kInstruction_clz_cs_r12_r1),
    kInstruction_clz_cs_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r6_r12),
    kInstruction_clz_hi_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r11_r10),
    kInstruction_clz_lt_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r10_r8),
    kInstruction_clz_vs_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r5_r8),
    kInstruction_clz_pl_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r14_r14),
    kInstruction_clz_ls_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r8_r6),
    kInstruction_clz_gt_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r7_r11),
    kInstruction_clz_vc_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r4_r12),
    kInstruction_clz_pl_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r12_r12),
    kInstruction_clz_gt_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r8_r4),
    kInstruction_clz_ne_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r1_r11),
    kInstruction_clz_le_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r4_r10),
    kInstruction_clz_cc_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r14_r0),
    kInstruction_clz_gt_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r2_r11),
    kInstruction_clz_cs_r2_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r3_r12),
    kInstruction_clz_al_r3_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r6_r0),
    kInstruction_clz_hi_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r10_r10),
    kInstruction_clz_ls_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r4_r8),
    kInstruction_clz_ls_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r8_r0),
    kInstruction_clz_le_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r5_r3),
    kInstruction_clz_pl_r5_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r8_r5),
    kInstruction_clz_ls_r8_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r0_r10),
    kInstruction_clz_ge_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r10_r6),
    kInstruction_clz_lt_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r9_r9),
    kInstruction_clz_ne_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r5_r0),
    kInstruction_clz_hi_r5_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r10_r6),
    kInstruction_clz_pl_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r1_r3),
    kInstruction_clz_vs_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r9_r8),
    kInstruction_clz_vs_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r2_r10),
    kInstruction_clz_cc_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r11_r3),
    kInstruction_clz_cs_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r8_r2),
    kInstruction_clz_hi_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r6_r0),
    kInstruction_clz_pl_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r9_r2),
    kInstruction_clz_hi_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r14_r11),
    kInstruction_clz_al_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r8_r13),
    kInstruction_clz_eq_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r12_r2),
    kInstruction_clz_ge_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r2_r6),
    kInstruction_clz_cc_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r13_r9),
    kInstruction_clz_ne_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r13_r10),
    kInstruction_clz_ne_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r10_r9),
    kInstruction_clz_mi_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r13_r12),
    kInstruction_clz_lt_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r14_r3),
    kInstruction_clz_lt_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r12_r14),
    kInstruction_clz_mi_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r11_r2),
    kInstruction_clz_vs_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r11_r0),
    kInstruction_clz_ls_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r10_r9),
    kInstruction_clz_gt_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r10_r12),
    kInstruction_clz_le_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r0_r14),
    kInstruction_clz_ge_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r5_r8),
    kInstruction_clz_mi_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r4_r11),
    kInstruction_clz_vs_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r7_r12),
    kInstruction_clz_lt_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r2_r8),
    kInstruction_clz_gt_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r5_r7),
    kInstruction_clz_gt_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r6_r3),
    kInstruction_clz_pl_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r2_r12),
    kInstruction_clz_ne_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r11_r11),
    kInstruction_clz_hi_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r4_r14),
    kInstruction_clz_vs_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r13_r1),
    kInstruction_clz_vs_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r4_r3),
    kInstruction_clz_cs_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r13_r6),
    kInstruction_clz_eq_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r11_r14),
    kInstruction_clz_gt_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r14_r4),
    kInstruction_clz_vc_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r1_r10),
    kInstruction_clz_vc_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r10_r3),
    kInstruction_clz_mi_r10_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r9_r3),
    kInstruction_clz_vs_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r14_r5),
    kInstruction_clz_vc_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r9_r1),
    kInstruction_clz_ne_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r9_r6),
    kInstruction_clz_al_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r7_r8),
    kInstruction_clz_vc_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r6_r9),
    kInstruction_clz_ls_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r14_r2),
    kInstruction_clz_le_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r9_r13),
    kInstruction_clz_ls_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r1_r5),
    kInstruction_clz_eq_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r9_r2),
    kInstruction_clz_le_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r2_r1),
    kInstruction_clz_eq_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r9_r11),
    kInstruction_clz_ls_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r7_r13),
    kInstruction_clz_lt_r7_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r8_r7),
    kInstruction_clz_cc_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r5_r1),
    kInstruction_clz_ls_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r1_r9),
    kInstruction_clz_le_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r8_r14),
    kInstruction_clz_ls_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r9_r1),
    kInstruction_clz_le_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r1_r6),
    kInstruction_clz_gt_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r11_r10),
    kInstruction_clz_gt_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r0_r12),
    kInstruction_clz_hi_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r1_r7),
    kInstruction_clz_gt_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r7_r1),
    kInstruction_clz_mi_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r7_r0),
    kInstruction_clz_mi_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r1_r3),
    kInstruction_clz_ls_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r13_r3),
    kInstruction_clz_mi_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r4_r3),
    kInstruction_clz_eq_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r14_r9),
    kInstruction_clz_vc_r14_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r3_r1),
    kInstruction_clz_pl_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r0_r2),
    kInstruction_clz_mi_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r2_r7),
    kInstruction_clz_hi_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r13_r12),
    kInstruction_clz_hi_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r12_r8),
    kInstruction_clz_ls_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r5_r6),
    kInstruction_clz_ne_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r5_r4),
    kInstruction_clz_pl_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r1_r6),
    kInstruction_clz_ge_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r8_r10),
    kInstruction_clz_eq_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r5_r4),
    kInstruction_clz_cs_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r11_r6),
    kInstruction_clz_eq_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r13_r3),
    kInstruction_clz_cs_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r2_r8),
    kInstruction_clz_pl_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r10_r0),
    kInstruction_clz_gt_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r4_r10),
    kInstruction_clz_lt_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r14_r14),
    kInstruction_clz_vs_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r0_r7),
    kInstruction_clz_hi_r0_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r9_r6),
    kInstruction_clz_cc_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r7_r13),
    kInstruction_clz_ne_r7_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r2_r6),
    kInstruction_clz_eq_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r12_r12),
    kInstruction_clz_cs_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r3_r10),
    kInstruction_clz_mi_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r6_r13),
    kInstruction_clz_le_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r2_r1),
    kInstruction_clz_al_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r3_r4),
    kInstruction_clz_le_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r4_r4),
    kInstruction_clz_pl_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r12_r3),
    kInstruction_clz_lt_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r7_r4),
    kInstruction_clz_ls_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r9_r4),
    kInstruction_clz_le_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r13_r3),
    kInstruction_clz_vc_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r8_r8),
    kInstruction_clz_vc_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r2_r8),
    kInstruction_clz_ge_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r11_r13),
    kInstruction_clz_le_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r1_r5),
    kInstruction_clz_le_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r9_r12),
    kInstruction_clz_ge_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r14_r14),
    kInstruction_clz_cs_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r1_r0),
    kInstruction_clz_cc_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r3_r0),
    kInstruction_clz_ge_r3_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r10_r0),
    kInstruction_clz_al_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r11_r10),
    kInstruction_clz_cc_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r11_r11),
    kInstruction_clz_mi_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r12_r7),
    kInstruction_clz_ne_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r4_r12),
    kInstruction_clz_lt_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r14_r5),
    kInstruction_clz_gt_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r1_r7),
    kInstruction_clz_ge_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r7_r0),
    kInstruction_clz_al_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r2_r0),
    kInstruction_clz_ls_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r6_r11),
    kInstruction_clz_pl_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r0_r6),
    kInstruction_clz_vc_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r6_r9),
    kInstruction_clz_pl_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r8_r1),
    kInstruction_clz_vs_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r1_r6),
    kInstruction_clz_cs_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r4_r11),
    kInstruction_clz_hi_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r5_r5),
    kInstruction_clz_gt_r5_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r3_r4),
    kInstruction_clz_al_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r11_r12),
    kInstruction_clz_ge_r11_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r14_r2),
    kInstruction_clz_cc_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r2_r4),
    kInstruction_clz_ge_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r5_r11),
    kInstruction_clz_lt_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r11_r14),
    kInstruction_clz_mi_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r3_r3),
    kInstruction_clz_ne_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r14_r0),
    kInstruction_clz_pl_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r4_r10),
    kInstruction_clz_vc_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r6_r8),
    kInstruction_clz_vs_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r4_r7),
    kInstruction_clz_vc_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r11_r10),
    kInstruction_clz_cs_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r11_r8),
    kInstruction_clz_eq_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r9_r2),
    kInstruction_clz_ne_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r9_r7),
    kInstruction_clz_hi_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r0_r6),
    kInstruction_clz_lt_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r5_r8),
    kInstruction_clz_vc_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r3_r1),
    kInstruction_clz_gt_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r3_r5),
    kInstruction_clz_pl_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r11_r5),
    kInstruction_clz_al_r11_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r8_r14),
    kInstruction_clz_hi_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r5_r4),
    kInstruction_clz_le_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r13_r3),
    kInstruction_clz_ge_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r7_r14),
    kInstruction_clz_pl_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r6_r9),
    kInstruction_clz_cs_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r8_r12),
    kInstruction_clz_lt_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r12_r0),
    kInstruction_clz_cc_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r14_r13),
    kInstruction_clz_mi_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r12_r13),
    kInstruction_clz_pl_r12_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r4_r8),
    kInstruction_clz_al_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r5_r11),
    kInstruction_clz_ls_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r11_r3),
    kInstruction_clz_ge_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r1_r0),
    kInstruction_clz_le_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r14_r4),
    kInstruction_clz_gt_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r3_r14),
    kInstruction_clz_ne_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r3_r8),
    kInstruction_clz_cc_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r7_r10),
    kInstruction_clz_eq_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r0_r10),
    kInstruction_clz_pl_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r6_r13),
    kInstruction_clz_mi_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r10_r5),
    kInstruction_clz_gt_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r0_r1),
    kInstruction_clz_ne_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r4_r8),
    kInstruction_clz_ge_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r3_r7),
    kInstruction_clz_cs_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r2_r12),
    kInstruction_clz_pl_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r9_r12),
    kInstruction_clz_ls_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r4_r9),
    kInstruction_clz_ge_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r7_r2),
    kInstruction_clz_lt_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r10_r10),
    kInstruction_clz_hi_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r1_r7),
    kInstruction_clz_ls_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r1_r12),
    kInstruction_clz_vs_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r9_r14),
    kInstruction_clz_ge_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r6_r4),
    kInstruction_clz_pl_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r3_r2),
    kInstruction_clz_ls_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r4_r4),
    kInstruction_clz_cs_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r6_r2),
    kInstruction_clz_eq_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r14_r0),
    kInstruction_clz_ge_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r11_r6),
    kInstruction_clz_le_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r0_r0),
    kInstruction_clz_vs_r0_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r4_r6),
    kInstruction_clz_vs_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r6_r10),
    kInstruction_clz_gt_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r12_r7),
    kInstruction_clz_vc_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r8_r3),
    kInstruction_clz_gt_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r14_r4),
    kInstruction_clz_hi_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r9_r14),
    kInstruction_clz_hi_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r6_r1),
    kInstruction_clz_vs_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r5_r4),
    kInstruction_clz_hi_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r10_r14),
    kInstruction_clz_lt_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r8_r10),
    kInstruction_clz_cc_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r11_r0),
    kInstruction_clz_lt_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r4_r12),
    kInstruction_clz_ge_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r5_r7),
    kInstruction_clz_cc_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r3_r9),
    kInstruction_clz_gt_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r11_r5),
    kInstruction_clz_vc_r11_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r7_r1),
    kInstruction_clz_lt_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r1_r8),
    kInstruction_clz_lt_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r11_r13),
    kInstruction_clz_hi_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r10_r2),
    kInstruction_clz_vs_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r1_r10),
    kInstruction_clz_ne_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r10_r0),
    kInstruction_clz_vc_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r2_r2),
    kInstruction_clz_al_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r7_r8),
    kInstruction_clz_ne_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r11_r14),
    kInstruction_clz_hi_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r6_r14),
    kInstruction_clz_ne_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r8_r5),
    kInstruction_clz_ge_r8_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r7_r3),
    kInstruction_clz_vs_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r14_r13),
    kInstruction_clz_ne_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r12_r11),
    kInstruction_clz_hi_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r11_r9),
    kInstruction_clz_ls_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r12_r7),
    kInstruction_clz_mi_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r8_r8),
    kInstruction_clz_cc_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r14_r12),
    kInstruction_clz_ls_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r3_r6),
    kInstruction_clz_ls_r3_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r7_r8),
    kInstruction_clz_hi_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r4_r10),
    kInstruction_clz_vs_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r12_r1),
    kInstruction_clz_ne_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r12_r4),
    kInstruction_clz_vs_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r5_r5),
    kInstruction_clz_hi_r5_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r8_r8),
    kInstruction_clz_gt_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r10_r10),
    kInstruction_clz_lt_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r13_r4),
    kInstruction_clz_vs_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r8_r3),
    kInstruction_clz_mi_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r6_r13),
    kInstruction_clz_eq_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r2_r0),
    kInstruction_clz_al_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r6_r12),
    kInstruction_clz_ls_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r1_r4),
    kInstruction_clz_vs_r1_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r11_r1),
    kInstruction_clz_vc_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r9_r10),
    kInstruction_clz_ne_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r3_r10),
    kInstruction_clz_ne_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r7_r10),
    kInstruction_clz_hi_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r4_r10),
    kInstruction_clz_pl_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r7_r1),
    kInstruction_clz_le_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r13_r10),
    kInstruction_clz_gt_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r4_r14),
    kInstruction_clz_lt_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r10_r1),
    kInstruction_clz_al_r10_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r6_r12),
    kInstruction_clz_mi_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r13_r9),
    kInstruction_clz_eq_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r11_r4),
    kInstruction_clz_ge_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r1_r12),
    kInstruction_clz_hi_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r0_r1),
    kInstruction_clz_ge_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r2_r3),
    kInstruction_clz_lt_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r12_r9),
    kInstruction_clz_al_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r2_r10),
    kInstruction_clz_hi_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r14_r11),
    kInstruction_clz_mi_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r3_r10),
    kInstruction_clz_pl_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r1_r6),
    kInstruction_clz_vs_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r7_r6),
    kInstruction_clz_al_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r6_r8),
    kInstruction_clz_ge_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r3_r3),
    kInstruction_clz_eq_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r14_r4),
    kInstruction_clz_ne_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r13_r10),
    kInstruction_clz_vc_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r3_r12),
    kInstruction_clz_mi_r3_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r9_r1),
    kInstruction_clz_pl_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r14_r14),
    kInstruction_clz_hi_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r0_r9),
    kInstruction_clz_ne_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r1_r1),
    kInstruction_clz_mi_r1_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r7_r2),
    kInstruction_clz_hi_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r2_r3),
    kInstruction_clz_gt_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r2_r0),
    kInstruction_clz_eq_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r10_r12),
    kInstruction_clz_vs_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r11_r7),
    kInstruction_clz_gt_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r13_r2),
    kInstruction_clz_vs_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r11_r12),
    kInstruction_clz_ls_r11_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r8_r8),
    kInstruction_clz_al_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r6_r10),
    kInstruction_clz_hi_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r5_r1),
    kInstruction_clz_vs_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r0_r10),
    kInstruction_clz_ls_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r0_r1),
    kInstruction_clz_gt_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r11_r12),
    kInstruction_clz_ne_r11_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r13_r5),
    kInstruction_clz_ne_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r0_r12),
    kInstruction_clz_mi_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r11_r6),
    kInstruction_clz_lt_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r11_r14),
    kInstruction_clz_eq_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r11_r10),
    kInstruction_clz_vc_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r3_r3),
    kInstruction_clz_cs_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r12_r2),
    kInstruction_clz_le_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r13_r8),
    kInstruction_clz_hi_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r6_r6),
    kInstruction_clz_pl_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r4_r5),
    kInstruction_clz_al_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r1_r0),
    kInstruction_clz_hi_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r10_r11),
    kInstruction_clz_ls_r10_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r8_r7),
    kInstruction_clz_al_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r7_r1),
    kInstruction_clz_vc_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r7_r14),
    kInstruction_clz_ne_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r5_r9),
    kInstruction_clz_lt_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r13_r8),
    kInstruction_clz_al_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r6_r14),
    kInstruction_clz_ls_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r12_r0),
    kInstruction_clz_eq_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r8_r14),
    kInstruction_clz_mi_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r13_r2),
    kInstruction_clz_hi_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r13_r2),
    kInstruction_clz_al_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r8_r9),
    kInstruction_clz_vs_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r6_r2),
    kInstruction_clz_cc_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r8_r0),
    kInstruction_clz_lt_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r3_r13),
    kInstruction_clz_ls_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r10_r14),
    kInstruction_clz_gt_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r9_r8),
    kInstruction_clz_pl_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r14_r11),
    kInstruction_clz_pl_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r9_r3),
    kInstruction_clz_lt_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r9_r0),
    kInstruction_clz_hi_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r9_r3),
    kInstruction_clz_cc_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r10_r14),
    kInstruction_clz_ge_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r2_r1),
    kInstruction_clz_vs_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r4_r13),
    kInstruction_clz_vc_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r1_r9),
    kInstruction_clz_ls_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r13_r11),
    kInstruction_clz_lt_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r2_r10),
    kInstruction_clz_cs_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r0_r13),
    kInstruction_clz_le_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r13_r11),
    kInstruction_clz_al_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r5_r2),
    kInstruction_clz_eq_r5_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r5_r12),
    kInstruction_clz_vs_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r12_r0),
    kInstruction_clz_al_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r13_r9),
    kInstruction_clz_le_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r14_r4),
    kInstruction_clz_cs_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r5_r7),
    kInstruction_clz_ne_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r6_r6),
    kInstruction_clz_al_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r4_r8),
    kInstruction_clz_gt_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r12_r8),
    kInstruction_clz_gt_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r4_r12),
    kInstruction_clz_eq_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r7_r13),
    kInstruction_clz_cs_r7_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r2_r4),
    kInstruction_clz_cs_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r10_r3),
    kInstruction_clz_al_r10_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r8_r9),
    kInstruction_clz_cs_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r1_r12),
    kInstruction_clz_cs_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r13_r0),
    kInstruction_clz_gt_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r13_r12),
    kInstruction_clz_vc_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r12_r14),
    kInstruction_clz_lt_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r0_r1),
    kInstruction_clz_lt_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r10_r2),
    kInstruction_clz_cc_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r3_r5),
    kInstruction_clz_le_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r2_r11),
    kInstruction_clz_eq_r2_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r12_r4),
    kInstruction_clz_al_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r6_r5),
    kInstruction_clz_cs_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r13_r10),
    kInstruction_clz_hi_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r4_r3),
    kInstruction_clz_vs_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r7_r9),
    kInstruction_clz_ls_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r14_r8),
    kInstruction_clz_vs_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r1_r0),
    kInstruction_clz_cs_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r10_r8),
    kInstruction_clz_mi_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r10_r4),
    kInstruction_clz_ge_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r5_r4),
    kInstruction_clz_cc_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r0_r7),
    kInstruction_clz_lt_r0_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r14_r10),
    kInstruction_clz_mi_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r0_r14),
    kInstruction_clz_mi_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r14_r10),
    kInstruction_clz_eq_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r4_r4),
    kInstruction_clz_ls_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r14_r1),
    kInstruction_clz_pl_r14_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r10_r8),
    kInstruction_clz_eq_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r10_r6),
    kInstruction_clz_cs_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r12_r2),
    kInstruction_clz_al_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r12_r1),
    kInstruction_clz_ls_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r12_r11),
    kInstruction_clz_eq_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r4_r1),
    kInstruction_clz_vc_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r12_r2),
    kInstruction_clz_vs_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r11_r8),
    kInstruction_clz_al_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r6_r13),
    kInstruction_clz_hi_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r2_r8),
    kInstruction_clz_eq_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r9_r5),
    kInstruction_clz_cc_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r9_r7),
    kInstruction_clz_cc_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r4_r6),
    kInstruction_clz_lt_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r14_r13),
    kInstruction_clz_cc_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r3_r2),
    kInstruction_clz_vc_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r6_r13),
    kInstruction_clz_al_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r10_r10),
    kInstruction_clz_vs_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r6_r10),
    kInstruction_clz_cs_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r8_r12),
    kInstruction_clz_cc_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r7_r5),
    kInstruction_clz_vs_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r14_r10),
    kInstruction_clz_pl_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r1_r14),
    kInstruction_clz_hi_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r8_r12),
    kInstruction_clz_vc_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r2_r4),
    kInstruction_clz_ls_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r5_r12),
    kInstruction_clz_mi_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r6_r12),
    kInstruction_clz_eq_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r14_r9),
    kInstruction_clz_lt_r14_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r11_r9),
    kInstruction_clz_lt_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r1_r9),
    kInstruction_clz_ne_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r11_r8),
    kInstruction_clz_pl_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r0_r6),
    kInstruction_clz_ne_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r4_r4),
    kInstruction_clz_vs_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r12_r9),
    kInstruction_clz_ls_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r9_r7),
    kInstruction_clz_cs_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r7_r2),
    kInstruction_clz_ne_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r9_r10),
    kInstruction_clz_hi_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r5_r2),
    kInstruction_clz_gt_r5_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r4_r6),
    kInstruction_clz_pl_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r11_r8),
    kInstruction_clz_lt_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r13_r4),
    kInstruction_clz_hi_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r1_r10),
    kInstruction_clz_le_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r11_r3),
    kInstruction_clz_le_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r0_r11),
    kInstruction_clz_pl_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r7_r4),
    kInstruction_clz_le_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r2_r11),
    kInstruction_clz_le_r2_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r1_r10),
    kInstruction_clz_cc_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r13_r14),
    kInstruction_clz_gt_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r10_r6),
    kInstruction_clz_ls_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r13_r4),
    kInstruction_clz_ls_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r12_r13),
    kInstruction_clz_gt_r12_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r13_r7),
    kInstruction_clz_pl_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r14_r0),
    kInstruction_clz_le_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r1_r4),
    kInstruction_clz_gt_r1_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r3_r5),
    kInstruction_clz_mi_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r4_r0),
    kInstruction_clz_vc_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r4_r11),
    kInstruction_clz_gt_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r5_r3),
    kInstruction_clz_vc_r5_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r4_r7),
    kInstruction_clz_pl_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r12_r6),
    kInstruction_clz_al_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r2_r3),
    kInstruction_clz_mi_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r12_r4),
    kInstruction_clz_lt_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r10_r4),
    kInstruction_clz_lt_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r10_r8),
    kInstruction_clz_hi_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r0_r14),
    kInstruction_clz_al_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r3_r3),
    kInstruction_clz_cc_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r10_r13),
    kInstruction_clz_pl_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r7_r8),
    kInstruction_clz_lt_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r12_r7),
    kInstruction_clz_le_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r11_r8),
    kInstruction_clz_ge_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r10_r8),
    kInstruction_clz_ls_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r9_r1),
    kInstruction_clz_vs_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r10_r10),
    kInstruction_clz_ne_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r6_r4),
    kInstruction_clz_al_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r10_r0),
    kInstruction_clz_ls_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r7_r1),
    kInstruction_clz_eq_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r11_r6),
    kInstruction_clz_al_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r5_r10),
    kInstruction_clz_ge_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vs_r0_r8),
    kInstruction_clz_vs_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r2_r1),
    kInstruction_clz_lt_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r13_r2),
    kInstruction_clz_le_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r13_r6),
    kInstruction_clz_al_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r12_r10),
    kInstruction_clz_lt_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r13_r1),
    kInstruction_clz_al_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r8_r14),
    kInstruction_clz_ge_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r11_r6),
    kInstruction_clz_mi_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r12_r14),
    kInstruction_clz_pl_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r14_r9),
    kInstruction_clz_ne_r14_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r3_r1),
    kInstruction_clz_cc_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r0_r8),
    kInstruction_clz_ge_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r7_r9),
    kInstruction_clz_vc_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r11_r4),
    kInstruction_clz_gt_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_mi_r4_r0),
    kInstruction_clz_mi_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r3_r11),
    kInstruction_clz_ls_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r14_r5),
    kInstruction_clz_le_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r6_r7),
    kInstruction_clz_ls_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r4_r6),
    kInstruction_clz_ne_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r1_r14),
    kInstruction_clz_cc_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r11_r7),
    kInstruction_clz_pl_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r6_r5),
    kInstruction_clz_vc_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r1_r11),
    kInstruction_clz_al_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r2_r13),
    kInstruction_clz_ne_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r14_r6),
    kInstruction_clz_vc_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_gt_r3_r8),
    kInstruction_clz_gt_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r1_r8),
    kInstruction_clz_pl_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r2_r14),
    kInstruction_clz_vc_r2_r14,
  },
  {
    ARRAY_SIZE(kInstruction_clz_pl_r12_r3),
    kInstruction_clz_pl_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r0_r12),
    kInstruction_clz_ls_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_le_r2_r1),
    kInstruction_clz_le_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r13_r5),
    kInstruction_clz_eq_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r11_r11),
    kInstruction_clz_al_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r9_r3),
    kInstruction_clz_ls_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r7_r12),
    kInstruction_clz_ne_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_al_r6_r2),
    kInstruction_clz_al_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r7_r4),
    kInstruction_clz_ne_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r7_r5),
    kInstruction_clz_vc_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ne_r7_r1),
    kInstruction_clz_ne_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r5_r3),
    kInstruction_clz_eq_r5_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cs_r3_r5),
    kInstruction_clz_cs_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r7_r4),
    kInstruction_clz_lt_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r4_r5),
    kInstruction_clz_ls_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_clz_eq_r11_r2),
    kInstruction_clz_eq_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_hi_r2_r6),
    kInstruction_clz_hi_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_clz_vc_r2_r3),
    kInstruction_clz_vc_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ls_r12_r12),
    kInstruction_clz_ls_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_clz_lt_r8_r2),
    kInstruction_clz_lt_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_clz_cc_r14_r8),
    kInstruction_clz_cc_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_clz_ge_r12_r8),
    kInstruction_clz_ge_r12_r8,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_CLZ_A32_H_
