/* test-umockdev-run.c generated by valac 0.44.9, the Vala compiler
 * generated from test-umockdev-run.vala, do not modify */

/*
 * test-umockdev-run.vala
 *
 * Copyright (C) 2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <sys/wait.h>
#include <signal.h>
#include "config.h"
#include <glib/gstdio.h>
#include <unistd.h>
#include <float.h>
#include <math.h>
#include <sys/stat.h>
#include <sys/types.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

extern gchar* rootdir;
gchar* rootdir = NULL;

#define umockdev_run_command "env LC_ALL=C umockdev-run "
void assert_in (const gchar* needle,
                const gchar* haystack);
gboolean have_program (const gchar* program);
gboolean get_program_out (const gchar* program,
                          const gchar* command,
                          gchar* * sout,
                          gchar* * serr,
                          gint* exit);
void check_program_out (const gchar* program,
                        const gchar* run_command,
                        const gchar* expected_out);
void check_program_error (const gchar* program,
                          const gchar* run_command,
                          const gchar* expected_err);
void t_run_exit_code (void);
void t_run_version (void);
void t_run_pipes (void);
void t_run_invalid_args (void);
void t_run_invalid_device (void);
void t_run_invalid_ioctl (void);
void t_run_invalid_script (void);
void t_run_invalid_program (void);
void t_run_script_chatter (void);
void t_run_script_chatter_socket_stream (void);
void t_gphoto_detect (void);
gboolean check_gphoto_version (void);
void t_gphoto_folderlist (void);
void t_gphoto_filelist (void);
void t_gphoto_thumbs (void);
void t_gphoto_download (void);
void t_input_touchpad (void);
void t_input_evtest (void);
void t_input_evtest_evemu (void);
gint _vala_main (gchar** args,
                 gint args_length1);
static void _t_run_exit_code_gtest_func (void);
static void _t_run_version_gtest_func (void);
static void _t_run_pipes_gtest_func (void);
static void _t_run_invalid_args_gtest_func (void);
static void _t_run_invalid_device_gtest_func (void);
static void _t_run_invalid_ioctl_gtest_func (void);
static void _t_run_invalid_script_gtest_func (void);
static void _t_run_invalid_program_gtest_func (void);
static void _t_run_script_chatter_gtest_func (void);
static void _t_run_script_chatter_socket_stream_gtest_func (void);
static void _t_gphoto_detect_gtest_func (void);
static void _t_input_touchpad_gtest_func (void);
static void _t_input_evtest_gtest_func (void);
static void _t_input_evtest_evemu_gtest_func (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
assert_in (const gchar* needle,
           const gchar* haystack)
{
	g_return_if_fail (needle != NULL);
	g_return_if_fail (haystack != NULL);
	if (!string_contains (haystack, needle)) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "'%s' not found in '%s'\n", needle, haystack);
		abort ();
	}
}

gboolean
have_program (const gchar* program)
{
	gchar* sout = NULL;
	gint exit = 0;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (program != NULL, FALSE);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp0_ = g_strconcat ("which ", program, NULL);
		_tmp1_ = _tmp0_;
		g_spawn_command_line_sync (_tmp1_, &_tmp2_, NULL, &_tmp3_, &_inner_error0_);
		_g_free0 (sout);
		sout = _tmp2_;
		exit = _tmp3_;
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (sout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e->message;
		fprintf (_tmp5_, "cannot call which %s: %s\n", program, _tmp6_);
		abort ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		_g_free0 (sout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = exit == 0;
	_g_free0 (sout);
	return result;
}

gboolean
get_program_out (const gchar* program,
                 const gchar* command,
                 gchar* * sout,
                 gchar* * serr,
                 gint* exit)
{
	gchar* _vala_sout = NULL;
	gchar* _vala_serr = NULL;
	gint _vala_exit = 0;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (program != NULL, FALSE);
	g_return_val_if_fail (command != NULL, FALSE);
	if (!have_program (program)) {
		FILE* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "[SKIP: %s not installed] ", program);
		_tmp1_ = g_strdup ("");
		_g_free0 (_vala_sout);
		_vala_sout = _tmp1_;
		_tmp2_ = g_strdup ("");
		_g_free0 (_vala_serr);
		_vala_serr = _tmp2_;
		_vala_exit = -1;
		result = FALSE;
		if (sout) {
			*sout = _vala_sout;
		} else {
			_g_free0 (_vala_sout);
		}
		if (serr) {
			*serr = _vala_serr;
		} else {
			_g_free0 (_vala_serr);
		}
		if (exit) {
			*exit = _vala_exit;
		}
		return result;
	}
	{
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		g_spawn_command_line_sync (command, &_tmp3_, &_tmp4_, &_tmp5_, &_inner_error0_);
		_g_free0 (_vala_sout);
		_vala_sout = _tmp3_;
		_g_free0 (_vala_serr);
		_vala_serr = _tmp4_;
		_vala_exit = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e->message;
		fprintf (_tmp7_, "cannot call %s: %s\n", command, _tmp8_);
		abort ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = TRUE;
	if (sout) {
		*sout = _vala_sout;
	} else {
		_g_free0 (_vala_sout);
	}
	if (serr) {
		*serr = _vala_serr;
	} else {
		_g_free0 (_vala_serr);
	}
	if (exit) {
		*exit = _vala_exit;
	}
	return result;
}

void
check_program_out (const gchar* program,
                   const gchar* run_command,
                   const gchar* expected_out)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (program != NULL);
	g_return_if_fail (run_command != NULL);
	g_return_if_fail (expected_out != NULL);
	_tmp0_ = g_strconcat (umockdev_run_command, run_command, NULL);
	_tmp1_ = _tmp0_;
	_tmp5_ = get_program_out (program, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_g_free0 (sout);
	sout = _tmp2_;
	_g_free0 (serr);
	serr = _tmp3_;
	exit = _tmp4_;
	_tmp6_ = !_tmp5_;
	_g_free0 (_tmp1_);
	if (_tmp6_) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp7_ = sout;
	g_assert_cmpstr (_tmp7_, ==, expected_out);
	_tmp8_ = serr;
	g_assert_cmpstr (_tmp8_, ==, "");
	g_assert_cmpint (exit, ==, 0);
	_g_free0 (serr);
	_g_free0 (sout);
}

void
check_program_error (const gchar* program,
                     const gchar* run_command,
                     const gchar* expected_err)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (program != NULL);
	g_return_if_fail (run_command != NULL);
	g_return_if_fail (expected_err != NULL);
	_tmp0_ = g_strconcat (umockdev_run_command, run_command, NULL);
	_tmp1_ = _tmp0_;
	_tmp5_ = get_program_out (program, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_g_free0 (sout);
	sout = _tmp2_;
	_g_free0 (serr);
	serr = _tmp3_;
	exit = _tmp4_;
	_tmp6_ = !_tmp5_;
	_g_free0 (_tmp1_);
	if (_tmp6_) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp7_ = serr;
	assert_in (expected_err, _tmp7_);
	g_assert_cmpint (exit, !=, 0);
	_vala_assert (WIFEXITED (exit), "Process.if_exited (exit)");
	_tmp8_ = sout;
	g_assert_cmpstr (_tmp8_, ==, "");
	_g_free0 (serr);
	_g_free0 (sout);
}

void
t_run_exit_code (void)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	check_program_out ("true", umockdev_run_command "true", "");
	get_program_out ("ls", umockdev_run_command "ls /nonexisting", &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (sout);
	sout = _tmp0_;
	_g_free0 (serr);
	serr = _tmp1_;
	exit = _tmp2_;
	_vala_assert (WIFEXITED (exit), "Process.if_exited (exit)");
	g_assert_cmpint (WEXITSTATUS (exit), >, 0);
	_tmp3_ = sout;
	g_assert_cmpstr (_tmp3_, ==, "");
	_tmp4_ = serr;
	g_assert_cmpstr (_tmp4_, !=, "");
	get_program_out ("sh", umockdev_run_command "-- sh -c 'kill -SEGV $$'", &_tmp5_, &_tmp6_, &_tmp7_);
	_g_free0 (sout);
	sout = _tmp5_;
	_g_free0 (serr);
	serr = _tmp6_;
	exit = _tmp7_;
	_vala_assert (WIFSIGNALED (exit), "Process.if_signaled (exit)");
	g_assert_cmpint ((gint) WTERMSIG (exit), ==, (gint) SIGSEGV);
	_tmp8_ = sout;
	g_assert_cmpstr (_tmp8_, ==, "");
	_tmp9_ = serr;
	g_assert_cmpstr (_tmp9_, ==, "");
	_g_free0 (serr);
	_g_free0 (sout);
}

void
t_run_version (void)
{
	check_program_out ("true", "--version", VERSION "\n");
}

void
t_run_pipes (void)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_;
	_tmp3_ = get_program_out ("echo", "sh -c 'echo hello | " umockdev_run_command "cat'", &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (sout);
	sout = _tmp0_;
	_g_free0 (serr);
	serr = _tmp1_;
	exit = _tmp2_;
	_vala_assert (_tmp3_, "get_program_out (\"echo\", \"sh -c 'echo hello | \" + umockdev_run_command + \"cat'\",                             out sout, out serr, out exit)");
	g_assert_cmpstr (sout, ==, "hello\n");
	g_assert_cmpstr (serr, ==, "");
	g_assert_cmpint (exit, ==, 0);
	_g_free0 (serr);
	_g_free0 (sout);
}

void
t_run_invalid_args (void)
{
	check_program_error ("true", "", "--help");
	check_program_error ("true", "--foobarize", "--help");
}

void
t_run_invalid_device (void)
{
	GError* _inner_error0_ = NULL;
	check_program_error ("true", "-d non.existing", "Cannot open non.existing:");
	{
		gchar* umockdev_file = NULL;
		gint fd = 0;
		gchar* _tmp0_ = NULL;
		gint _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp1_ = g_file_open_tmp ("ttyS0.XXXXXX.umockdev", &_tmp0_, &_inner_error0_);
		_g_free0 (umockdev_file);
		umockdev_file = _tmp0_;
		fd = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (umockdev_file);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		close (fd);
		_tmp2_ = umockdev_file;
		g_file_set_contents (_tmp2_, "P: /devices/foo\n", (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (umockdev_file);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp3_ = umockdev_file;
		_tmp4_ = g_strconcat ("-d ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = umockdev_file;
		_tmp7_ = g_strconcat ("Invalid record file ", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, ": missing SUBSYSTEM", NULL);
		_tmp10_ = _tmp9_;
		check_program_error ("true", _tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp5_);
		_g_free0 (umockdev_file);
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = stderr;
		_tmp12_ = e->message;
		fprintf (_tmp11_, "cannot create temporary file: %s\n", _tmp12_);
		abort ();
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
t_run_invalid_ioctl (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "/dev/bus/usb/001/011=/non/existing.ioctl -- gphoto2 -l", NULL);
	_tmp6_ = _tmp5_;
	check_program_error ("gphoto2", _tmp6_, "/non/existing.ioctl");
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = rootdir;
	_tmp8_ = g_strconcat ("-d ", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "/dev/bus/usb/001/011=/dev/null -- gphoto2 -l", NULL);
	_tmp13_ = _tmp12_;
	check_program_error ("gphoto2", _tmp13_, "001/011");
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp14_ = rootdir;
	_tmp15_ = g_strconcat ("-d ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "/dev/bus/usb/001/011=", NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = rootdir;
	_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, "/NEWS -- gphoto2 -l", NULL);
	_tmp25_ = _tmp24_;
	check_program_error ("gphoto2", _tmp25_, "001/011");
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_tmp26_ = rootdir;
	_tmp27_ = g_strconcat ("-d ", _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp28_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp30_, "/dev/bus/usb/001/011 -- gphoto2 -l", NULL);
	_tmp32_ = _tmp31_;
	check_program_error ("gphoto2", _tmp32_, "--ioctl");
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
}

void
t_run_invalid_script (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -s ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "/dev/bus/usb/001/011 -- true", NULL);
	_tmp6_ = _tmp5_;
	check_program_error ("true", _tmp6_, "--script argument must be");
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = rootdir;
	_tmp8_ = g_strconcat ("-d ", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "/devices/cameras/canon-powershot-sx200.umockdev -s ", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "/dev/bus/usb/001/011=/etc/passwd -- true", NULL);
	_tmp13_ = _tmp12_;
	check_program_error ("true", _tmp13_, "not a device suitable for scripts");
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp14_ = rootdir;
	_tmp15_ = g_strconcat ("-d ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, "/devices/input/usbkbd.umockdev -s ", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "/dev/input/event5=/non/existing -- true", NULL);
	_tmp20_ = _tmp19_;
	check_program_error ("true", _tmp20_, "Cannot install /non/existing for device /dev/input/event5:");
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	check_program_error ("true", "-u /dev/mysock -- true", "--unix-stream argument must be");
}

void
t_run_invalid_program (void)
{
	check_program_error ("true", "no.such.prog", "Cannot run no.such.prog: Failed to execute");
}

void
t_run_script_chatter (void)
{
	gchar* umockdev_file = NULL;
	gchar* script_file = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	{
		gint fd = 0;
		gchar* _tmp0_ = NULL;
		gint _tmp1_;
		gint _tmp2_ = 0;
		gchar* _tmp3_ = NULL;
		gint _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp1_ = g_file_open_tmp ("ttyS0.XXXXXX.umockdev", &_tmp0_, &_inner_error0_);
		_g_free0 (umockdev_file);
		umockdev_file = _tmp0_;
		fd = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		close (fd);
		_tmp4_ = g_file_open_tmp ("chatter.XXXXXX.script", &_tmp3_, &_inner_error0_);
		_g_free0 (script_file);
		script_file = _tmp3_;
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		fd = _tmp2_;
		close (fd);
		_tmp5_ = umockdev_file;
		g_file_set_contents (_tmp5_, "P: /devices/platform/serial8250/tty/ttyS0\n" \
"N: ttyS0\n" \
"E: DEVNAME=/dev/ttyS0\n" \
"E: SUBSYSTEM=tty\n" \
"A: dev=4:64", (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp6_ = script_file;
		g_file_set_contents (_tmp6_, "w 0 Hello world!^JWhat is your name?^J\n" \
"r 300 Joe Tester^J\n" \
"w 0 I \342\231\245 Joe Tester^Ja^I tab and a^J   line break in one wri" \
"te^J\n" \
"r 200 somejunk^J\n" \
"w 0 bye!^J", (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally3;
	__catch3_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e->message;
		fprintf (_tmp7_, "cannot create temporary file: %s\n", _tmp8_);
		abort ();
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (script_file);
		_g_free0 (umockdev_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = umockdev_file;
	_tmp10_ = g_strconcat ("-d ", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, " -s /dev/ttyS0=", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = script_file;
	_tmp15_ = g_strconcat (_tmp13_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, " -- tests/chatter /dev/ttyS0", NULL);
	_tmp18_ = _tmp17_;
	check_program_out ("true", _tmp18_, "Got input: Joe Tester\nGot input: somejunk\n");
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp19_ = umockdev_file;
	g_remove (_tmp19_);
	_tmp20_ = script_file;
	g_remove (_tmp20_);
	_g_free0 (script_file);
	_g_free0 (umockdev_file);
}

void
t_run_script_chatter_socket_stream (void)
{
	gchar* script_file = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	{
		gint fd = 0;
		gchar* _tmp0_ = NULL;
		gint _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_file_open_tmp ("chatter.XXXXXX.script", &_tmp0_, &_inner_error0_);
		_g_free0 (script_file);
		script_file = _tmp0_;
		fd = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (script_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		close (fd);
		_tmp2_ = script_file;
		g_file_set_contents (_tmp2_, "w 0 What is your name?^J\n" \
"r 307 Joe Tester^J\n" \
"w 0 hello Joe Tester^J\n" \
"w 20 send()\n" \
"r 30 somejunk", (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (script_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e->message;
		fprintf (_tmp3_, "cannot create temporary file: %s\n", _tmp4_);
		abort ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (script_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = script_file;
	_tmp6_ = g_strconcat (" -u /dev/socket/chatter=", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, " -- tests/chatter-socket-stream /dev/socket/chatter", NULL);
	_tmp9_ = _tmp8_;
	check_program_out ("true", _tmp9_, "Got name: Joe Tester\n\nGot recv: somejunk\n");
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_tmp10_ = script_file;
	g_remove (_tmp10_);
	_g_free0 (script_file);
}

void
t_gphoto_detect (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rootdir;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 --auto-detect", NULL);
	_tmp9_ = _tmp8_;
	check_program_out ("gphoto2", _tmp9_, "Model                          Port            \n" \
"----------------------------------------------------------\n" \
"Canon PowerShot SX200 IS       usb:001,011     \n");
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

gboolean
check_gphoto_version (void)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_;
	gchar** words = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint words_length1;
	gint _words_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gboolean result = FALSE;
	_tmp3_ = get_program_out ("gphoto2", "gphoto2 --version", &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (sout);
	sout = _tmp0_;
	_g_free0 (serr);
	serr = _tmp1_;
	exit = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		_g_free0 (serr);
		_g_free0 (sout);
		return result;
	}
	_tmp4_ = sout;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, " ", 3);
	words = _tmp6_;
	words_length1 = _vala_array_length (_tmp5_);
	_words_size_ = words_length1;
	_tmp7_ = words;
	_tmp7__length1 = words_length1;
	if (_tmp7__length1 < 2) {
		result = FALSE;
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (serr);
		_g_free0 (sout);
		return result;
	}
	_tmp8_ = words;
	_tmp8__length1 = words_length1;
	_tmp9_ = _tmp8_[1];
	if (double_parse (_tmp9_) < 2.5) {
		FILE* _tmp10_;
		_tmp10_ = stdout;
		fprintf (_tmp10_, "[SKIP: needs gphoto >= 2.5] ");
		result = FALSE;
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (serr);
		_g_free0 (sout);
		return result;
	}
	result = TRUE;
	words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (serr);
	_g_free0 (sout);
	return result;
}

void
t_gphoto_folderlist (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	if (!check_gphoto_version ()) {
		return;
	}
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rootdir;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -l", NULL);
	_tmp9_ = _tmp8_;
	check_program_out ("gphoto2", _tmp9_, "There is 1 folder in folder '/'.\n" \
" - store_00010001\n" \
"There is 1 folder in folder '/store_00010001'.\n" \
" - DCIM\n" \
"There is 1 folder in folder '/store_00010001/DCIM'.\n" \
" - 100CANON\n" \
"There are 0 folders in folder '/store_00010001/DCIM/100CANON'.\n");
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

void
t_gphoto_filelist (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	if (!check_gphoto_version ()) {
		return;
	}
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rootdir;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -L", NULL);
	_tmp9_ = _tmp8_;
	check_program_out ("gphoto2", _tmp9_, "There is no file in folder '/'.\n" \
"There is no file in folder '/store_00010001'.\n" \
"There is no file in folder '/store_00010001/DCIM'.\n" \
"There are 2 files in folder '/store_00010001/DCIM/100CANON'.\n" \
"#1     IMG_0001.JPG               rd    67 KB  640x480  image/jpeg\n" \
"#2     IMG_0002.JPG               rd    88 KB  640x480  image/jpeg\n");
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

void
t_gphoto_thumbs (void)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	struct stat st = {0};
	struct stat _tmp15_ = {0};
	gint _tmp16_;
	struct stat _tmp17_;
	struct stat _tmp18_ = {0};
	gint _tmp19_;
	struct stat _tmp20_;
	if (!check_gphoto_version ()) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat (umockdev_run_command "-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rootdir;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -T", NULL);
	_tmp9_ = _tmp8_;
	get_program_out ("gphoto2", _tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (sout);
	sout = _tmp10_;
	_g_free0 (serr);
	serr = _tmp11_;
	exit = _tmp12_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	g_assert_cmpint (exit, ==, 0);
	_tmp13_ = sout;
	assert_in ("thumb_IMG_0001.jpg", _tmp13_);
	_tmp14_ = sout;
	assert_in ("thumb_IMG_0002.jpg", _tmp14_);
	_tmp16_ = stat ("thumb_IMG_0001.jpg", &_tmp15_);
	st = _tmp15_;
	_vala_assert (_tmp16_ == 0, "Posix.stat(\"thumb_IMG_0001.jpg\", out st) == 0");
	_tmp17_ = st;
	g_assert_cmpuint ((guint) _tmp17_.st_size, >, (guint) 500);
	_tmp19_ = stat ("thumb_IMG_0002.jpg", &_tmp18_);
	st = _tmp18_;
	_vala_assert (_tmp19_ == 0, "Posix.stat(\"thumb_IMG_0002.jpg\", out st) == 0");
	_tmp20_ = st;
	g_assert_cmpuint ((guint) _tmp20_.st_size, >, (guint) 500);
	g_remove ("thumb_IMG_0001.jpg");
	g_remove ("thumb_IMG_0002.jpg");
	_g_free0 (serr);
	_g_free0 (sout);
}

void
t_gphoto_download (void)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	struct stat st = {0};
	struct stat _tmp15_ = {0};
	gint _tmp16_;
	struct stat _tmp17_;
	struct stat _tmp18_ = {0};
	gint _tmp19_;
	struct stat _tmp20_;
	if (!check_gphoto_version ()) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat (umockdev_run_command "-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rootdir;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -P", NULL);
	_tmp9_ = _tmp8_;
	get_program_out ("gphoto2", _tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (sout);
	sout = _tmp10_;
	_g_free0 (serr);
	serr = _tmp11_;
	exit = _tmp12_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	g_assert_cmpint (exit, ==, 0);
	_tmp13_ = sout;
	assert_in ("IMG_0001.JPG", _tmp13_);
	_tmp14_ = sout;
	assert_in ("IMG_0002.JPG", _tmp14_);
	_tmp16_ = stat ("IMG_0001.JPG", &_tmp15_);
	st = _tmp15_;
	_vala_assert (_tmp16_ == 0, "Posix.stat(\"IMG_0001.JPG\", out st) == 0");
	_tmp17_ = st;
	g_assert_cmpuint ((guint) _tmp17_.st_size, >, (guint) 5000);
	_tmp19_ = stat ("IMG_0002.JPG", &_tmp18_);
	st = _tmp18_;
	_vala_assert (_tmp19_ == 0, "Posix.stat(\"IMG_0002.JPG\", out st) == 0");
	_tmp20_ = st;
	g_assert_cmpuint ((guint) _tmp20_.st_size, >, (guint) 5000);
	g_remove ("IMG_0001.JPG");
	g_remove ("IMG_0002.JPG");
	_g_free0 (serr);
	_g_free0 (sout);
}

void
t_input_touchpad (void)
{
	GPid xorg_pid = 0;
	gchar* logfile = NULL;
	gint timeout = 0;
	gchar* xinput_out = NULL;
	gchar* xinput_err = NULL;
	gint xinput_exit = 0;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gchar* props_out = NULL;
	gchar* props_err = NULL;
	gint props_exit = 0;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint status = 0;
	gint _tmp38_ = 0;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	GError* _inner_error0_ = NULL;
	if (G_BYTE_ORDER == G_BIG_ENDIAN) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "[SKIP: this test only works on little endian machines] ");
		return;
	}
	if (!have_program ("Xorg")) {
		FILE* _tmp1_;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "[SKIP: Xorg not installed] ");
		return;
	}
	if (((gint64) G_MAXLONG) != G_MAXINT64) {
		FILE* _tmp2_;
		_tmp2_ = stdout;
		fprintf (_tmp2_, "[SKIP: test only works on 64 bit architectures] ");
		return;
	}
	{
		gint fd = 0;
		gchar* _tmp3_ = NULL;
		gint _tmp4_;
		_tmp4_ = g_file_open_tmp ("Xorg.log.XXXXXX", &_tmp3_, &_inner_error0_);
		_g_free0 (logfile);
		logfile = _tmp3_;
		fd = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch5_g_file_error;
			}
			_g_free0 (logfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		close (fd);
	}
	goto __finally5;
	__catch5_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e->message;
		fprintf (_tmp5_, "cannot create temporary file: %s\n", _tmp6_);
		abort ();
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (logfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar** _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		GPid _tmp27_ = 0;
		_tmp7_ = g_strdup ("umockdev-run");
		_tmp8_ = g_strdup ("-d");
		_tmp9_ = rootdir;
		_tmp10_ = g_strconcat (_tmp9_, "/devices/input/synaptics-touchpad.umockdev", NULL);
		_tmp11_ = g_strdup ("-i");
		_tmp12_ = rootdir;
		_tmp13_ = g_strconcat ("/dev/input/event12=", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, "/devices/input/synaptics-touchpad.ioctl", NULL);
		_tmp16_ = g_strdup ("--");
		_tmp17_ = g_strdup ("Xorg");
		_tmp18_ = g_strdup ("-config");
		_tmp19_ = rootdir;
		_tmp20_ = g_strconcat (_tmp19_, "/tests/xorg-dummy.conf", NULL);
		_tmp21_ = g_strdup ("-logfile");
		_tmp22_ = logfile;
		_tmp23_ = g_strdup (_tmp22_);
		_tmp24_ = g_strdup (":5");
		_tmp25_ = g_new0 (gchar*, 12 + 1);
		_tmp25_[0] = _tmp7_;
		_tmp25_[1] = _tmp8_;
		_tmp25_[2] = _tmp10_;
		_tmp25_[3] = _tmp11_;
		_tmp25_[4] = _tmp15_;
		_tmp25_[5] = _tmp16_;
		_tmp25_[6] = _tmp17_;
		_tmp25_[7] = _tmp18_;
		_tmp25_[8] = _tmp20_;
		_tmp25_[9] = _tmp21_;
		_tmp25_[10] = _tmp23_;
		_tmp25_[11] = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp26__length1 = 12;
		g_spawn_async (NULL, _tmp26_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &_tmp27_, &_inner_error0_);
		xorg_pid = _tmp27_;
		_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp14_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch6_g_spawn_error;
			}
			_g_free0 (logfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally6;
	__catch6_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = stderr;
		_tmp29_ = e->message;
		fprintf (_tmp28_, "cannot call Xorg: %s\n", _tmp29_);
		abort ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (logfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	timeout = 50;
	while (TRUE) {
		if (!(timeout > 0)) {
			break;
		}
		timeout = timeout - 1;
		usleep ((guint) 100000);
		if (g_file_test ("/tmp/.X11-unix/X5", G_FILE_TEST_EXISTS)) {
			break;
		}
	}
	if (timeout <= 0) {
		FILE* _tmp30_;
		const gchar* _tmp31_;
		_tmp30_ = stderr;
		_tmp31_ = logfile;
		fprintf (_tmp30_, "SKIP: Xorg failed to start up; please ensure you have the X.org dummy " \
"driver installed, and check the log file: %s\n", _tmp31_);
		_g_free0 (logfile);
		return;
	}
	get_program_out ("xinput", "env DISPLAY=:5 xinput", &_tmp32_, &_tmp33_, &_tmp34_);
	_g_free0 (xinput_out);
	xinput_out = _tmp32_;
	_g_free0 (xinput_err);
	xinput_err = _tmp33_;
	xinput_exit = _tmp34_;
	get_program_out ("xinput", "env DISPLAY=:5 xinput --list-props 'SynPS/2 Synaptics TouchPad'", &_tmp35_, &_tmp36_, &_tmp37_);
	_g_free0 (props_out);
	props_out = _tmp35_;
	_g_free0 (props_err);
	props_err = _tmp36_;
	props_exit = _tmp37_;
	kill ((pid_t) xorg_pid, (gint) SIGTERM);
	waitpid ((pid_t) xorg_pid, &_tmp38_, 0);
	status = _tmp38_;
	g_spawn_close_pid (xorg_pid);
	_tmp39_ = logfile;
	g_remove (_tmp39_);
	_tmp40_ = logfile;
	_tmp41_ = g_strconcat (_tmp40_, ".old", NULL);
	_tmp42_ = _tmp41_;
	g_remove (_tmp42_);
	_g_free0 (_tmp42_);
	_tmp43_ = xinput_err;
	g_assert_cmpstr (_tmp43_, ==, "");
	g_assert_cmpint (xinput_exit, ==, 0);
	_tmp44_ = xinput_out;
	assert_in ("SynPS/2 Synaptics TouchPad", _tmp44_);
	_tmp45_ = props_err;
	g_assert_cmpstr (_tmp45_, ==, "");
	g_assert_cmpint (props_exit, ==, 0);
	_tmp46_ = props_out;
	assert_in ("Synaptics Two-Finger Scrolling", _tmp46_);
	_tmp47_ = props_out;
	assert_in ("/dev/input/event12", _tmp47_);
	_g_free0 (props_err);
	_g_free0 (props_out);
	_g_free0 (xinput_err);
	_g_free0 (xinput_out);
	_g_free0 (logfile);
}

void
t_input_evtest (void)
{
	GPid evtest_pid = 0;
	gint outfd = 0;
	gint errfd = 0;
	gchar* script_arch = NULL;
	guint8* sout = NULL;
	guint8* _tmp30_;
	gint sout_length1;
	gint _sout_size_;
	guint8* serr = NULL;
	guint8* _tmp31_;
	gint serr_length1;
	gint _serr_size_;
	gssize sout_len = 0L;
	guint8* _tmp32_;
	gint _tmp32__length1;
	guint8* _tmp33_;
	gint _tmp33__length1;
	gssize serr_len = 0L;
	guint8* _tmp34_;
	gint _tmp34__length1;
	guint8* _tmp35_;
	gint _tmp35__length1;
	gint status = 0;
	gint _tmp36_ = 0;
	guint8* _tmp40_;
	gint _tmp40__length1;
	gchar* output = NULL;
	guint8* _tmp41_;
	gint _tmp41__length1;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	GError* _inner_error0_ = NULL;
	if (G_BYTE_ORDER == G_BIG_ENDIAN) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "[SKIP: this test only works on little endian machines] ");
		return;
	}
	if (!have_program ("evtest")) {
		FILE* _tmp1_;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "[SKIP: evtest not installed] ");
		return;
	}
	if (((gint64) G_MAXLONG) == G_MAXINT64) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("64");
		_g_free0 (script_arch);
		script_arch = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("32");
		_g_free0 (script_arch);
		script_arch = _tmp3_;
	}
	{
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar** _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		GPid _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		_tmp4_ = g_strdup ("umockdev-run");
		_tmp5_ = g_strdup ("-d");
		_tmp6_ = rootdir;
		_tmp7_ = g_strconcat (_tmp6_, "/devices/input/usbkbd.umockdev", NULL);
		_tmp8_ = g_strdup ("-i");
		_tmp9_ = rootdir;
		_tmp10_ = g_strconcat ("/dev/input/event5=", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "/devices/input/usbkbd.evtest.ioctl", NULL);
		_tmp13_ = g_strdup ("-s");
		_tmp14_ = rootdir;
		_tmp15_ = g_strconcat ("/dev/input/event5=", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "/devices/input/usbkbd.evtest.script.", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = script_arch;
		_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
		_tmp21_ = g_strdup ("evtest");
		_tmp22_ = g_strdup ("/dev/input/event5");
		_tmp23_ = g_new0 (gchar*, 9 + 1);
		_tmp23_[0] = _tmp4_;
		_tmp23_[1] = _tmp5_;
		_tmp23_[2] = _tmp7_;
		_tmp23_[3] = _tmp8_;
		_tmp23_[4] = _tmp12_;
		_tmp23_[5] = _tmp13_;
		_tmp23_[6] = _tmp20_;
		_tmp23_[7] = _tmp21_;
		_tmp23_[8] = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp24__length1 = 9;
		g_spawn_async_with_pipes (NULL, _tmp24_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp25_, NULL, &_tmp26_, &_tmp27_, &_inner_error0_);
		evtest_pid = _tmp25_;
		outfd = _tmp26_;
		errfd = _tmp27_;
		_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch7_g_spawn_error;
			}
			_g_free0 (script_arch);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally7;
	__catch7_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = stderr;
		_tmp29_ = e->message;
		fprintf (_tmp28_, "cannot call evtest: %s\n", _tmp29_);
		abort ();
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (script_arch);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	sleep ((guint) 2);
	kill ((pid_t) evtest_pid, (gint) SIGTERM);
	_tmp30_ = g_new0 (guint8, 10000);
	sout = _tmp30_;
	sout_length1 = 10000;
	_sout_size_ = sout_length1;
	_tmp31_ = g_new0 (guint8, 10000);
	serr = _tmp31_;
	serr_length1 = 10000;
	_serr_size_ = serr_length1;
	_tmp32_ = sout;
	_tmp32__length1 = sout_length1;
	_tmp33_ = sout;
	_tmp33__length1 = sout_length1;
	sout_len = read (outfd, _tmp32_, (gsize) _tmp33__length1);
	_tmp34_ = serr;
	_tmp34__length1 = serr_length1;
	_tmp35_ = sout;
	_tmp35__length1 = sout_length1;
	serr_len = read (errfd, _tmp34_, (gsize) _tmp35__length1);
	waitpid ((pid_t) evtest_pid, &_tmp36_, 0);
	status = _tmp36_;
	g_spawn_close_pid (evtest_pid);
	if (serr_len > ((gssize) 0)) {
		guint8* _tmp37_;
		gint _tmp37__length1;
		FILE* _tmp38_;
		guint8* _tmp39_;
		gint _tmp39__length1;
		_tmp37_ = serr;
		_tmp37__length1 = serr_length1;
		_tmp37_[serr_len] = (guint8) 0;
		_tmp38_ = stderr;
		_tmp39_ = serr;
		_tmp39__length1 = serr_length1;
		fprintf (_tmp38_, "evtest error: %s\n", (const gchar*) _tmp39_);
		abort ();
	}
	g_assert_cmpint ((gint) sout_len, >, 10);
	_tmp40_ = sout;
	_tmp40__length1 = sout_length1;
	_tmp40_[sout_len] = (guint8) 0;
	_tmp41_ = sout;
	_tmp41__length1 = sout_length1;
	_tmp42_ = g_strdup ((const gchar*) _tmp41_);
	output = _tmp42_;
	_tmp43_ = output;
	assert_in ("Event type 1 (EV_KEY)", _tmp43_);
	_tmp44_ = output;
	assert_in ("Event code 15 (KEY_TAB)", _tmp44_);
	_tmp45_ = output;
	assert_in ("type 4 (EV_MSC), code 4 (MSC_SCAN), value 70004", _tmp45_);
	_tmp46_ = output;
	assert_in ("type 1 (EV_KEY), code 30 (KEY_A), value 1\n", _tmp46_);
	_tmp47_ = output;
	assert_in ("type 1 (EV_KEY), code 30 (KEY_A), value 0\n", _tmp47_);
	_tmp48_ = output;
	assert_in ("type 4 (EV_MSC), code 4 (MSC_SCAN), value 700e1", _tmp48_);
	_tmp49_ = output;
	assert_in ("type 1 (EV_KEY), code 42 (KEY_LEFTSHIFT), value 1\n", _tmp49_);
	_tmp50_ = output;
	assert_in ("type 1 (EV_KEY), code 42 (KEY_LEFTSHIFT), value 0\n", _tmp50_);
	_g_free0 (output);
	serr = (g_free (serr), NULL);
	sout = (g_free (sout), NULL);
	_g_free0 (script_arch);
}

void
t_input_evtest_evemu (void)
{
	GPid evtest_pid = 0;
	gint outfd = 0;
	gint errfd = 0;
	gchar* evemu_file = NULL;
	const gchar* _tmp28_;
	guint8* sout = NULL;
	guint8* _tmp29_;
	gint sout_length1;
	gint _sout_size_;
	guint8* serr = NULL;
	guint8* _tmp30_;
	gint serr_length1;
	gint _serr_size_;
	gssize sout_len = 0L;
	guint8* _tmp31_;
	gint _tmp31__length1;
	guint8* _tmp32_;
	gint _tmp32__length1;
	gssize serr_len = 0L;
	guint8* _tmp33_;
	gint _tmp33__length1;
	guint8* _tmp34_;
	gint _tmp34__length1;
	gint status = 0;
	gint _tmp35_ = 0;
	guint8* _tmp39_;
	gint _tmp39__length1;
	gchar* output = NULL;
	guint8* _tmp40_;
	gint _tmp40__length1;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	GError* _inner_error0_ = NULL;
	if (G_BYTE_ORDER == G_BIG_ENDIAN) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "[SKIP: this test only works on little endian machines] ");
		return;
	}
	if (!have_program ("evtest")) {
		FILE* _tmp1_;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "[SKIP: evtest not installed] ");
		return;
	}
	{
		gint fd = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_file_open_tmp ("evemu.XXXXXX.events", &_tmp2_, &_inner_error0_);
		_g_free0 (evemu_file);
		evemu_file = _tmp2_;
		fd = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch8_g_file_error;
			}
			_g_free0 (evemu_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		close (fd);
		_tmp4_ = evemu_file;
		g_file_set_contents (_tmp4_, "E: 0.000000 0000 0000 0000\t# ------------ SYN_REPORT (0) ----------\n" \
"E: 0.200000 0004 0004 458756\t# EV_MSC / MSC_SCAN             458756\n" \
"E: 0.200000 0001 001e 0001\t# EV_KEY / KEY_A                1\n" \
"E: 0.200000 0000 0000 0000\t# ------------ SYN_REPORT (0) ----------\n" \
"E: 0.500000 0004 0004 458756\t# EV_MSC / MSC_SCAN             458756\n" \
"E: 0.500000 0001 001e 0000\t# EV_KEY / KEY_A                0\n", (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch8_g_file_error;
			}
			_g_free0 (evemu_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally8;
	__catch8_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e->message;
		fprintf (_tmp5_, "cannot create temporary file: %s\n", _tmp6_);
		abort ();
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (evemu_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar** _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		GPid _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		_tmp7_ = g_strdup ("umockdev-run");
		_tmp8_ = g_strdup ("-d");
		_tmp9_ = rootdir;
		_tmp10_ = g_strconcat (_tmp9_, "/devices/input/usbkbd.umockdev", NULL);
		_tmp11_ = g_strdup ("-i");
		_tmp12_ = rootdir;
		_tmp13_ = g_strconcat ("/dev/input/event5=", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, "/devices/input/usbkbd.evtest.ioctl", NULL);
		_tmp16_ = g_strdup ("-e");
		_tmp17_ = evemu_file;
		_tmp18_ = g_strconcat ("/dev/input/event5=", _tmp17_, NULL);
		_tmp19_ = g_strdup ("evtest");
		_tmp20_ = g_strdup ("/dev/input/event5");
		_tmp21_ = g_new0 (gchar*, 9 + 1);
		_tmp21_[0] = _tmp7_;
		_tmp21_[1] = _tmp8_;
		_tmp21_[2] = _tmp10_;
		_tmp21_[3] = _tmp11_;
		_tmp21_[4] = _tmp15_;
		_tmp21_[5] = _tmp16_;
		_tmp21_[6] = _tmp18_;
		_tmp21_[7] = _tmp19_;
		_tmp21_[8] = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp22__length1 = 9;
		g_spawn_async_with_pipes (NULL, _tmp22_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp23_, NULL, &_tmp24_, &_tmp25_, &_inner_error0_);
		evtest_pid = _tmp23_;
		outfd = _tmp24_;
		errfd = _tmp25_;
		_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp14_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch9_g_spawn_error;
			}
			_g_free0 (evemu_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally9;
	__catch9_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp26_;
		const gchar* _tmp27_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = stderr;
		_tmp27_ = e->message;
		fprintf (_tmp26_, "cannot call evtest: %s\n", _tmp27_);
		abort ();
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (evemu_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	sleep ((guint) 1);
	_tmp28_ = evemu_file;
	g_remove (_tmp28_);
	kill ((pid_t) evtest_pid, (gint) SIGTERM);
	_tmp29_ = g_new0 (guint8, 10000);
	sout = _tmp29_;
	sout_length1 = 10000;
	_sout_size_ = sout_length1;
	_tmp30_ = g_new0 (guint8, 10000);
	serr = _tmp30_;
	serr_length1 = 10000;
	_serr_size_ = serr_length1;
	_tmp31_ = sout;
	_tmp31__length1 = sout_length1;
	_tmp32_ = sout;
	_tmp32__length1 = sout_length1;
	sout_len = read (outfd, _tmp31_, (gsize) _tmp32__length1);
	_tmp33_ = serr;
	_tmp33__length1 = serr_length1;
	_tmp34_ = sout;
	_tmp34__length1 = sout_length1;
	serr_len = read (errfd, _tmp33_, (gsize) _tmp34__length1);
	waitpid ((pid_t) evtest_pid, &_tmp35_, 0);
	status = _tmp35_;
	g_spawn_close_pid (evtest_pid);
	if (serr_len > ((gssize) 0)) {
		guint8* _tmp36_;
		gint _tmp36__length1;
		FILE* _tmp37_;
		guint8* _tmp38_;
		gint _tmp38__length1;
		_tmp36_ = serr;
		_tmp36__length1 = serr_length1;
		_tmp36_[serr_len] = (guint8) 0;
		_tmp37_ = stderr;
		_tmp38_ = serr;
		_tmp38__length1 = serr_length1;
		fprintf (_tmp37_, "evtest error: %s\n", (const gchar*) _tmp38_);
		abort ();
	}
	g_assert_cmpint ((gint) sout_len, >, 10);
	_tmp39_ = sout;
	_tmp39__length1 = sout_length1;
	_tmp39_[sout_len] = (guint8) 0;
	_tmp40_ = sout;
	_tmp40__length1 = sout_length1;
	_tmp41_ = g_strdup ((const gchar*) _tmp40_);
	output = _tmp41_;
	_tmp42_ = output;
	assert_in ("Event: time 0.000000, -------------- ", _tmp42_);
	_tmp43_ = output;
	assert_in ("Event: time 0.200000, type 4 (EV_MSC), code 4 (MSC_SCAN), value 70004\n" \
"Event: time 0.200000, type 1 (EV_KEY), code 30 (KEY_A), value 1\n", _tmp43_);
	_tmp44_ = output;
	assert_in ("Event: time 0.200000, -------------- ", _tmp44_);
	_tmp45_ = output;
	assert_in ("Event: time 0.500000, type 4 (EV_MSC), code 4 (MSC_SCAN), value 70004\n" \
"Event: time 0.500000, type 1 (EV_KEY), code 30 (KEY_A), value 0\n", _tmp45_);
	_g_free0 (output);
	serr = (g_free (serr), NULL);
	sout = (g_free (sout), NULL);
	_g_free0 (evemu_file);
}

static void
_t_run_exit_code_gtest_func (void)
{
	t_run_exit_code ();
}

static void
_t_run_version_gtest_func (void)
{
	t_run_version ();
}

static void
_t_run_pipes_gtest_func (void)
{
	t_run_pipes ();
}

static void
_t_run_invalid_args_gtest_func (void)
{
	t_run_invalid_args ();
}

static void
_t_run_invalid_device_gtest_func (void)
{
	t_run_invalid_device ();
}

static void
_t_run_invalid_ioctl_gtest_func (void)
{
	t_run_invalid_ioctl ();
}

static void
_t_run_invalid_script_gtest_func (void)
{
	t_run_invalid_script ();
}

static void
_t_run_invalid_program_gtest_func (void)
{
	t_run_invalid_program ();
}

static void
_t_run_script_chatter_gtest_func (void)
{
	t_run_script_chatter ();
}

static void
_t_run_script_chatter_socket_stream_gtest_func (void)
{
	t_run_script_chatter_socket_stream ();
}

static void
_t_gphoto_detect_gtest_func (void)
{
	t_gphoto_detect ();
}

static void
_t_input_touchpad_gtest_func (void)
{
	t_input_touchpad ();
}

static void
_t_input_evtest_gtest_func (void)
{
	t_input_evtest ();
}

static void
_t_input_evtest_evemu_gtest_func (void)
{
	t_input_evtest_evemu ();
}

gint
_vala_main (gchar** args,
            gint args_length1)
{
	gchar* top_srcdir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result = 0;
	g_test_init ((gint*) (&args_length1), &args, NULL);
	_tmp0_ = g_getenv ("TOP_SRCDIR");
	_tmp1_ = g_strdup (_tmp0_);
	top_srcdir = _tmp1_;
	_tmp2_ = top_srcdir;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = top_srcdir;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (rootdir);
		rootdir = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (".");
		_g_free0 (rootdir);
		rootdir = _tmp5_;
	}
	g_test_add_func ("/umockdev-run/exit_code", _t_run_exit_code_gtest_func);
	g_test_add_func ("/umockdev-run/version", _t_run_version_gtest_func);
	g_test_add_func ("/umockdev-run/pipes", _t_run_pipes_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-args", _t_run_invalid_args_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-device", _t_run_invalid_device_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-ioctl", _t_run_invalid_ioctl_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-script", _t_run_invalid_script_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-program", _t_run_invalid_program_gtest_func);
	g_test_add_func ("/umockdev-run/script-chatter", _t_run_script_chatter_gtest_func);
	g_test_add_func ("/umockdev-run/script-chatter-socket-stream", _t_run_script_chatter_socket_stream_gtest_func);
	g_test_add_func ("/umockdev-run/integration/gphoto-detect", _t_gphoto_detect_gtest_func);
	g_test_add_func ("/umockdev-run/integration/input-touchpad", _t_input_touchpad_gtest_func);
	g_test_add_func ("/umockdev-run/integration/input-evtest", _t_input_evtest_gtest_func);
	g_test_add_func ("/umockdev-run/integration/input-evtest-evemu", _t_input_evtest_evemu_gtest_func);
	result = g_test_run ();
	_g_free0 (top_srcdir);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

