---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, 
              polices de caractères, police en mode mathématique, 
              théorème en caractères droits
---

# Comment obtenir un texte de théorème en caractères romains ?

Lorsque vous souhaitez utiliser la commande `\newtheorem` sans la contrainte
d'un contenu du théorème affiché dans une police italique, 
plusieurs possibilités s'offrent à vous.


## Avec les commandes de base

L'exemple qui suit montre la manière d'obtenir un environnement dont le contenu
est présenté en caractères romains (avec l'environnement `lemme`). Il montre
aussi la présentation classique (avec l'environnement `remarque`).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newtheorem{remarque}{Remarque}
  \newtheorem{prelemme}{Lemme}
  \newenvironment{lemme}{\begin{prelemme}\upshape}{\end{prelemme}}

\begin{document}
\begin{remarque}
  Ce qui suit est un lemme.
\end{remarque}

\begin{lemme}
  Si un ensemble $E$ possède une partition en $p$ sous-ensembles contenant 
  chacun $r$ éléments, alors $E$ contient $p \times r$ éléments.
\end{lemme}
\end{document}
```


## Avec l'extension <ctanpkg:amsthm>

L'extension AMSLaTeX dédiée à la gestion des théorèmes, <ctanpkg:amsthm>, 
permet de faire une modification similaire.

```{todo} Faire un exemple.
```


## Avec l'extension <ctanpkg:ntheorem>

L'extension <ctanpkg:ntheorem> permet de contrôler directement 
les polices utilisées par les environnements de théorème.

```{todo} Faire un exemple.
```


## Avec l'extension <ctanpkg:theorem> 

:::{warning}
L’extension <ctanpkg:theorem> est classée comme
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). Ce qui suit
est informatif.
:::

L'extension <ctanpkg:theorem> permettait aussi d'obtenir cette modification. 
L'auteur de l'extension, Frank Mittelbach, recommande d'utiliser 
à présent <ctanpkg:amsthm> ou <ctanpkg:ntheorem>.


:::{sources}
- [Theorem bodies printed in a roman font](faquk:FAQ-theoremfmt)
:::