---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, taille de caractères
---

# Comment obtenir des fontes de toute taille ?

De nos jours, presque toutes les polices sont fournies avec des fichiers de contrôle LaTeX (`fd`), 
de sorte qu'il est généralement facile de résister à la tentation d'utiliser 
la commande `\newfont` évoquée à la question 
"[](/3_composition/texte/symboles/polices/pourquoi_ne_pas_utiliser_newfont)".

Cependant, une tentation subsiste, liée à la façon dont LaTeX restreint la taille des polices. 
En fait, cette restriction ne s'applique de manière significative qu'aux polices par défaut 
(*Computer Modern*) et aux polices *European Computer* (en encodage T1), 
mais elle est largement considérée comme dépassée. 

## Avec l'extension <ctanpkg:fix-cm> 

En conséquence, l'extension <ctanpkg:fix-cm> vous permettra d'utiliser les polices, 
dans LaTeX, à la taille de votre choix. Si vous n'utilisez pas de versions extensibles des polices, 
la plupart des distributions modernes généreront simplement une image bitmap appropriée pour vous.

Ainsi, supposons que vous souhaitiez produire un titre en *Computer Modern Roman* 
avec une taille de 30 points, vous pourriez être tenté d'écrire :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\newfont{\bigfont}{cmr10 at 30pt}
\begin{center}
  \bigfont Un grand texte
\end{center}
\end{document}
```

Cela fonctionnera mais produira en fait un résultat bien moins bon 
que celui obtenu avec <ctanpkg:fix-cm>.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{fix-cm}

\begin{document}
\begin{center}
  \fontsize{30}{36}\selectfont
  Un grand texte
\end{center}
\end{document}
```

Notez que l'extension <ctanpkg:fix-cm> n'a pas été distribuée 
avant l'édition de décembre 2003 de LaTeX. Si vous avez une distribution plus ancienne, 
les extensions <ctanpkg:type1cm> (pour les polices *Computer Modern*) 
et <ctanpkg:type1ec> (pour les polices *European Computer*) sont disponibles.


# Avec d'autres extensions

L'extension <ctanpkg:fix-cm> comporte une ou deux omissions --- 
des polices que l'équipe LaTeX n'a vraisemblablement pas jugées utiles. 
Les polices *Computer Modern Dunhill* (avec des hampes plus étirées que *Computer Modern*)
et la police *Computer Modern Fibonacci* (qui n'est disponible qu'en taille 8 points) 
sont ainsi manquantes. Si <ctanpkg:fix-cm> ne fait pas l'affaire, 
essayez les extensions [type1xx](ctanpkg:type1cm) ou <ctanpkg:anyfontsize>.


# Avec des fontes mieux adaptées (pour *Computer Modern*)

Une autre alternative serait de passer aux fontes 
*[Latin Modern](utiliser_les_fontes_latin_modern)* qui fournissent un proche parent 
de l'ensemble *Computer Modern*. 
Ces polices ont été mises à l'échelle dès leur première distribution, 
et n'ont donc pas besoin d'une astuce telle que celle décrite ci-dessus.


:::{sources}
[Fonts at arbitrary sizes](faquk:FAQ-fontsize)
:::
