/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CANCELSTARTEVENT_H
#define _SC_CANCELSTARTEVENT_H

// sc
#include "CustomEvents.h"
class Cancel;

// qt
#include <QtCore/QEvent>

/**
 * Event class for bringing up a new cancel button.
 */
class CancelStartEvent : public QCustomEvent
{
public:
  /**
   * Create new CancelStartEvent.
   *
   * \param id    the command id.
   * \param cb    the Cancel callback.
   */
  CancelStartEvent( long id, Cancel* cb )
  : QCustomEvent(ScCancelStartEvent), _id(id), _cb(cb)
  {
  }

  long getId() const
  {
    return _id;
  }

  Cancel* getCancel() const
  {
    return _cb;
  }

private:
  long    _id;
  Cancel* _cb;
};

#endif // _SC_CANCELSTARTEVENT_H
