-- Basic
CREATE DATABASE db1;

-- WITH options
CREATE DATABASE db2 WITH OWNER = my_owner CONNECTION LIMIT 10 COLLATE CASE_SENSITIVE ISOLATION LEVEL SERIALIZABLE;

-- FROM INTEGRATION with DATABASE
CREATE DATABASE db3 FROM INTEGRATION 'integration_id' DATABASE 'source_db';

-- FROM INTEGRATION with SET and options
CREATE DATABASE db4 FROM INTEGRATION 'integration_id' SET ACCEPTINVCHARS = TRUE QUERY_ALL_STATES = FALSE REFRESH_INTERVAL 60 TRUNCATECOLUMNS = TRUE HISTORY_MODE = FALSE;

-- FROM ARN with DATA CATALOG SCHEMA
CREATE DATABASE db5 FROM ARN 'arn:aws:redshift:us-east-1:123456789012:datashare:mydatashare' WITH DATA CATALOG SCHEMA 'my_schema';

-- FROM ARN with NO DATA CATALOG SCHEMA
CREATE DATABASE db6 FROM ARN 'arn:aws:redshift:us-east-1:123456789012:datashare:mydatashare' WITH NO DATA CATALOG SCHEMA;

-- IAM_ROLE default
CREATE DATABASE db7 IAM_ROLE default;

-- IAM_ROLE SESSION
CREATE DATABASE db8 IAM_ROLE 'SESSION';

-- IAM_ROLE with ARN
CREATE DATABASE db9 IAM_ROLE 'arn:aws:iam::123456789012:role/MyRedshiftRole';

-- FROM DATASHARE minimal
CREATE DATABASE db10 FROM DATASHARE my_datashare OF NAMESPACE 'my_namespace_guid';

-- FROM DATASHARE with ACCOUNT and NAMESPACE
CREATE DATABASE db11 FROM DATASHARE my_datashare OF ACCOUNT '123456789012' NAMESPACE 'my_namespace_guid';

-- WITH PERMISSIONS FROM DATASHARE
CREATE DATABASE db12 WITH PERMISSIONS FROM DATASHARE my_datashare OF ACCOUNT 123456789012 NAMESPACE my_namespace_guid;

-- Combination: WITH and FROM DATASHARE
CREATE DATABASE db13 WITH OWNER = my_owner CONNECTION LIMIT 5 FROM DATASHARE my_datashare OF NAMESPACE 'my_namespace_guid';

-- Combination: FROM INTEGRATION and WITH
CREATE DATABASE db14 FROM INTEGRATION 'integration_id' WITH OWNER = my_owner COLLATE CASE_INSENSITIVE;

-- WITH options: COLLATE short forms and CONNECTION LIMIT UNLIMITED
CREATE DATABASE db15 WITH OWNER = my_owner CONNECTION LIMIT UNLIMITED COLLATE CS ISOLATION LEVEL SNAPSHOT;

-- WITH options: OWNER without equals
CREATE DATABASE db16 WITH OWNER my_owner CONNECTION LIMIT 20 COLLATE CI;

-- FROM INTEGRATION with only SET and one option
CREATE DATABASE db17 FROM INTEGRATION 'integration_id' SET ACCEPTINVCHARS = FALSE;

-- FROM INTEGRATION with SET and options in different order
CREATE DATABASE db18 FROM INTEGRATION 'integration_id' SET HISTORY_MODE = TRUE TRUNCATECOLUMNS = FALSE;

-- FROM ARN with DATA CATALOG SCHEMA, schema name
CREATE DATABASE db19 FROM ARN 'arn:aws:redshift:us-east-1:123456789012:datashare:mydatashare' WITH DATA CATALOG SCHEMA 'my_schema';

-- FROM ARN with NO DATA CATALOG SCHEMA (no quotes)
CREATE DATABASE db20 FROM ARN 'arn:aws:redshift:us-east-1:123456789012:datashare:mydatashare' WITH NO DATA CATALOG SCHEMA;

-- FROM DATASHARE with ACCOUNT as unquoted number, NAMESPACE as unquoted identifier
CREATE DATABASE db22 FROM DATASHARE my_datashare OF ACCOUNT 123456789012 NAMESPACE my_namespace_guid;

-- WITH and FROM INTEGRATION and IAM_ROLE
CREATE DATABASE db26 FROM INTEGRATION 'integration_id' WITH OWNER = my_owner IAM_ROLE 'arn:aws:iam::123456789012:role/MyRedshiftRole';

-- WITH and FROM ARN and IAM_ROLE
CREATE DATABASE db27 FROM ARN 'arn:aws:redshift:us-east-1:123456789012:datashare:mydatashare' WITH DATA CATALOG SCHEMA 'my_schema' IAM_ROLE default;

-- WITH and FROM DATASHARE and IAM_ROLE
CREATE DATABASE db28 WITH OWNER = my_owner FROM DATASHARE my_datashare OF NAMESPACE 'hello' IAM_ROLE 'SESSION';

-- WITH only COLLATE
CREATE DATABASE db29 WITH COLLATE CS;

-- WITH only ISOLATION LEVEL
CREATE DATABASE db30 WITH ISOLATION LEVEL SNAPSHOT;
