#ifndef INCLUDED_TOMO_
#define INCLUDED_TOMO_

#include "../enums/enums.h"
#include "../modbase/modbase.h"
#include "../agegroupvsd/agegroupvsd.h"


// Tomo:
//     costs:         64   
// 
//     #      bi-rad:  a       b       c       d             
//     dose:           3       3       3       3  
//     sensitivity:    .87     .84     .73     .65   
//     #             ageGroup
//     specificity:  0 - 40:  .961     40 - *: .965


//    Tomo:
//        costs:         64   
//
//        Dose:           
//          #            mean   spread    dist
//          bi-rad: a     3       1       Normal
//          bi-rad: b     3       1       Normal
//          bi-rad: c     3       1       Normal
//          bi-rad: d     3       1       Normal
//
//        Sensitivity:
//          #           proportion    spread      dist
//          bi-rad: a     .87          .05         Normal
//          bi-rad: b     .84          .05         Normal
//          bi-rad: c     .73          .05         Normal
//          bi-rad: d     .65          .05         Normal
//
//        Specificity:
//          #           range     proportion   spread      dist
//          ageGroup:   0 - 40:     .961       .0025       Normal
//          agegroup:  40 - * :     .965       .0025       Normal


class Tomo: public ModBase
{
    StringVect d_base;

    VSDvect d_dose;
    VSDvect d_sens;

    AgeGroupVSDvect d_specVect;     // was: d_specificity;

    public:
        Tomo();
        ~Tomo() override;

    private:
        void setSensitivity();

        VSDvect const *vDose() const override;              // 1
        double vDose(uint16_t) const override;              // 2
        void vInsert(std::ostream &out) const override;
        double vSensitivity(size_t idx) const override;
        double vSpecificity(double age) const override;
        void vVary(std::ostream &out) override;


};

#endif




