/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: HwTextSrc.cpp
Responsibility: Sharon Correll
Last reviewed: Not yet.

Description:
	A simple text source that shows how to use this interface within Graphite.
-------------------------------------------------------------------------------*//*:End Ignore*/

//:>********************************************************************************************
//:>	Include files
//:>********************************************************************************************
///////#include "Main.h"

#include "GrClient.h"
#include "GrDebug.h"
#include "ITextSource.h"
#include "HwTextSrc.h"

#pragma hdrstop
// any other headers (not precompiled)

#undef THIS_FILE
DEFINE_THIS_FILE

//:>********************************************************************************************
//:>	Forward declarations
//:>********************************************************************************************

//:>********************************************************************************************
//:>	Initialization and destruction
//:>********************************************************************************************

/*----------------------------------------------------------------------------------------------
	Constructors.
----------------------------------------------------------------------------------------------*/
HwTextSrc::HwTextSrc(gr::utf16 * pszText,
	gr::utf16 * szFaceName, int pointSize, bool fBold, bool fItalic)
	//gr::utf16 * prgchFontVar, int ichFontVar)
{
	//Assert(ichFontVar < isizeof(m_rgchFontVar));

	m_cref = 1; // COM-like behavior

	m_cchLength = wcslen(pszText);
	m_prgchText = new gr::utf16[m_cchLength + 1];
	std::copy(pszText, pszText + m_cchLength, m_prgchText);
	m_prgchText[m_cchLength] = 0; // zero-terminate

	wcscpy(m_szFaceName, szFaceName);
	m_pointSize = pointSize;
	m_fBold = fBold;
	m_fItalic = fItalic;

}


/*----------------------------------------------------------------------------------------------
	Destructor.
----------------------------------------------------------------------------------------------*/
HwTextSrc::~HwTextSrc()
{
	delete[] m_prgchText;
}

//:>********************************************************************************************
//:>	Interface methods
//:>********************************************************************************************

/*----------------------------------------------------------------------------------------------
	Get the specified range of text
----------------------------------------------------------------------------------------------*/
size_t HwTextSrc::fetch(toffset ichMin, size_t cch, gr::utf16 * prgchwBuffer)
{
	size_t ichRet = min(cch, m_cchLength - ichMin);
	std::copy(m_prgchText + ichMin, m_prgchText + ichMin + ichRet, prgchwBuffer);
	return ichRet;
}
