/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "xeen/worldofxeen/worldofxeen_resources.h"

namespace Xeen {
namespace WorldOfXeen {

const char *const WorldOfXeenResources::CLOUDS_INTRO1 = "\xC" "00\xB" "082\x9" "040\x3"
	"cKing Burlock\xB" "190\x9" "040Peasants\xB" "082\x9" "247"
	"Lord Xeen\xB" "190\x9" "258Xeen's Pet\xB" "179\x9" "150Crodo";

const char *const WorldOfXeenResources::DARKSIDE_ENDING1 = "\n\x3" "cCongratulations\n"
	"\n"
	"Your Final Score is:\n"
	"\n"
	"%010lu\n"
	"\x3" "l\n"
	"Please send this score to the Ancient's Headquarters "
	"where you'll be added to the Hall of Legends!\n"
	"\n"
	"Ancient's Headquarters\n"
	"New World Computing, Inc.\n"
	"P.O. Box 4302\n"
	"Hollywood, CA 90078";

const char *const WorldOfXeenResources::DARKSIDE_ENDING2 = "\n"
	"Adventurers,\n"
	"\n"
	"I have saved your game in Castleview.\n"
	"\n"
	"The World of Xeen still needs you!\n"
	"\n"
	"Load your game and come visit me in the Great Pyramid "
	"for further instructions";

const char *const WorldOfXeenResources::PHAROAH_ENDING_TEXT1 = "\xC" "d\xB"
	"001\x9" "001%s\x3" "c\x9" "000\xB" "180Press a Key!\x3" "l";
const char *const WorldOfXeenResources::PHAROAH_ENDING_TEXT2 = "\xC" "04\xB"
	"000\x9" "000%s\x3" "c\x9" "000\xB" "180Press a Key!\x3" "l\xC" "d";

} // End of namespace WorldOfXeen
} // End of namespace Xeen
