/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/*
 * This code is based on original Tony Tough source code
 *
 * Copyright (c) 1997-2003 Nayma Software
 */

// From 10500 onwards there are .OGG for inventory and scrap
#ifndef TONY_RESID_H
#define TONY_RESID_H

#define RES_I_INTERFACE 10300
#define RES_I_INTERPAL  10301
#define RES_I_INTERPPAL 10302
#define RES_I_INTERP1   10303
#define RES_I_INTERP2   10304
#define RES_I_INTERP3   10305
#define RES_I_INTERP4   10306
#define RES_I_INTERP5   10307

#define RES_I_DLGTEXT     10350
#define RES_I_DLGTEXTLINE 10351
#define RES_I_DLGTEXTPAL  10352

#define RES_I_MINIINTER 10360

#define RES_P_PAL   10410
#define RES_P_GO    10400
#define RES_P_TAKE  10401
#define RES_P_USE   10402
#define RES_P_EXAM  10403
#define RES_P_TALK  10404

#define RES_P_PAP1  10420
#define RES_P_PAP2  10421
#define RES_P_PAP3  10422
#define RES_P_PAP4  10423
#define RES_P_FRMAP 10424

#define RES_F_PAL   10700
#define RES_F_PARL  10701
#define RES_F_OBJ   10702
#define RES_F_MACC  10703
#define RES_F_CREDITS 10704
#define RES_F_CPAL 10705

#define RES_W_CIRCLE 10800

#endif
