
#line 1 "ragel/i18n/bm.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/bm.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_bm/gherkin_lexer_bm.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 21, 22, 23, 43, 44, 45, 
	47, 49, 54, 59, 64, 69, 73, 77, 
	79, 80, 81, 82, 83, 84, 85, 86, 
	87, 88, 89, 90, 91, 92, 93, 94, 
	95, 97, 99, 104, 111, 116, 117, 118, 
	119, 120, 121, 122, 123, 124, 125, 126, 
	127, 128, 129, 130, 131, 132, 133, 140, 
	142, 144, 146, 148, 150, 152, 172, 174, 
	175, 176, 177, 178, 179, 180, 181, 182, 
	183, 184, 185, 186, 200, 202, 204, 206, 
	208, 210, 212, 214, 216, 218, 220, 222, 
	224, 226, 228, 230, 232, 234, 236, 238, 
	240, 242, 244, 246, 248, 250, 252, 254, 
	256, 258, 260, 262, 264, 266, 268, 270, 
	272, 274, 276, 278, 280, 282, 284, 286, 
	288, 290, 292, 294, 296, 298, 300, 302, 
	304, 306, 308, 310, 312, 314, 316, 318, 
	320, 322, 324, 326, 329, 331, 333, 335, 
	337, 339, 341, 343, 345, 347, 349, 351, 
	354, 355, 357, 358, 359, 360, 361, 362, 
	363, 364, 381, 383, 385, 387, 389, 391, 
	393, 395, 397, 399, 401, 403, 405, 407, 
	409, 411, 413, 415, 417, 419, 421, 423, 
	425, 427, 429, 432, 434, 436, 438, 440, 
	442, 444, 446, 448, 450, 452, 454, 457, 
	459, 461, 463, 465, 467, 469, 471, 473, 
	475, 477, 479, 481, 483, 485, 487, 489, 
	491, 493, 495, 497, 499, 502, 504, 506, 
	508, 510, 512, 514, 516, 518, 520, 522, 
	524, 526, 528, 530, 532, 534, 536, 538, 
	540, 543, 545, 547, 549, 552, 554, 557, 
	559, 561, 563, 565, 567, 569, 572, 574, 
	576, 578, 579, 580, 581, 582, 583, 584, 
	585, 586, 587, 588, 589, 590, 591, 592, 
	593, 594, 595, 596, 597, 598, 614, 616, 
	618, 620, 622, 624, 626, 628, 630, 632, 
	634, 636, 638, 640, 642, 644, 646, 648, 
	650, 652, 654, 656, 658, 660, 662, 665, 
	667, 669, 671, 673, 675, 677, 679, 681, 
	683, 685, 687, 690, 692, 694, 696, 698, 
	700, 702, 704, 706, 709, 711, 713, 715, 
	717, 719, 721, 723, 725, 727, 729, 731, 
	733, 735, 737, 739, 741, 743, 745, 747, 
	750, 752, 754, 756, 759, 761, 764, 766, 
	768, 770, 772, 774, 776, 779, 781, 783, 
	785, 787, 788, 789, 790, 791, 792, 793, 
	794, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 807, 808, 809, 
	825, 827, 829, 831, 833, 835, 837, 839, 
	841, 843, 845, 847, 849, 851, 853, 855, 
	857, 859, 861, 863, 865, 867, 869, 871, 
	873, 876, 878, 880, 882, 884, 886, 888, 
	890, 892, 894, 896, 898, 901, 903, 905, 
	907, 909, 911, 913, 915, 917, 919, 921, 
	924, 926, 928, 930, 932, 934, 936, 938, 
	940, 943, 945, 947, 949, 951, 952, 953, 
	954, 955, 956, 957, 958, 959, 960, 962, 
	963, 965, 966, 967, 968, 969, 970, 971, 
	973, 974, 975, 976, 977, 978, 979, 981, 
	982, 983, 984, 985, 986, 990, 996, 999, 
	1001, 1007, 1027
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	65, 66, 67, 68, 70, 75, 76, 77, 
	83, 84, 124, 9, 13, -69, -65, 10, 
	32, 34, 35, 37, 42, 64, 65, 66, 
	67, 68, 70, 75, 76, 77, 83, 84, 
	124, 9, 13, 34, 34, 10, 13, 10, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 9, 
	13, 10, 32, 9, 13, 10, 13, 10, 
	95, 70, 69, 65, 84, 85, 82, 69, 
	95, 69, 78, 68, 95, 37, 32, 10, 
	13, 10, 13, 13, 32, 64, 9, 10, 
	9, 10, 13, 32, 64, 11, 12, 10, 
	32, 64, 9, 13, 112, 97, 98, 105, 
	108, 97, 97, 103, 105, 111, 110, 116, 
	111, 104, 58, 10, 10, 10, 32, 35, 
	70, 124, 9, 13, 10, 117, 10, 110, 
	10, 103, 10, 115, 10, 105, 10, 58, 
	10, 32, 34, 35, 37, 42, 64, 65, 
	66, 67, 68, 70, 75, 76, 77, 83, 
	84, 124, 9, 13, 97, 105, 110, 98, 
	101, 114, 117, 110, 103, 115, 105, 58, 
	10, 10, 10, 32, 35, 37, 64, 67, 
	70, 75, 76, 77, 83, 84, 9, 13, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, 10, 111, 10, 110, 
	10, 116, 10, 111, 10, 104, 10, 58, 
	10, 117, 10, 110, 10, 103, 10, 115, 
	10, 105, 10, 101, 10, 97, 10, 100, 
	10, 97, 10, 97, 10, 110, 10, 97, 
	10, 116, 10, 97, 10, 114, 10, 32, 
	10, 66, 10, 101, 10, 108, 10, 97, 
	10, 107, 10, 97, 10, 110, 10, 103, 
	10, 101, 10, 110, 10, 103, 10, 103, 
	10, 97, 10, 114, 10, 105, 10, 115, 
	10, 107, 10, 97, 10, 110, 10, 32, 
	10, 83, 10, 101, 10, 110, 10, 97, 
	10, 114, 10, 105, 10, 111, 10, 101, 
	105, 10, 116, 10, 117, 10, 97, 10, 
	101, 10, 109, 10, 112, 10, 108, 10, 
	97, 10, 116, 10, 101, 10, 32, 10, 
	75, 83, 101, 97, 109, 100, 97, 97, 
	110, 58, 10, 10, 10, 32, 35, 37, 
	42, 64, 65, 66, 68, 70, 75, 76, 
	77, 83, 84, 9, 13, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, 10, 32, 10, 112, 10, 97, 10, 
	98, 10, 105, 10, 108, 10, 97, 10, 
	97, 10, 103, 10, 105, 10, 97, 105, 
	10, 110, 10, 98, 10, 101, 10, 114, 
	10, 117, 10, 110, 10, 103, 10, 115, 
	10, 105, 10, 58, 10, 101, 10, 97, 
	109, 10, 100, 10, 97, 10, 97, 10, 
	110, 10, 117, 10, 100, 10, 105, 10, 
	97, 10, 97, 10, 116, 10, 97, 10, 
	114, 10, 32, 10, 66, 10, 101, 10, 
	108, 10, 97, 10, 107, 10, 97, 10, 
	110, 10, 103, 10, 97, 101, 10, 107, 
	10, 110, 10, 103, 10, 103, 10, 97, 
	10, 114, 10, 105, 10, 115, 10, 107, 
	10, 97, 10, 110, 10, 32, 10, 83, 
	10, 101, 10, 110, 10, 97, 10, 114, 
	10, 105, 10, 111, 10, 101, 105, 10, 
	116, 10, 117, 10, 97, 10, 97, 101, 
	10, 112, 10, 109, 116, 10, 112, 10, 
	108, 10, 97, 10, 116, 10, 101, 10, 
	32, 10, 75, 83, 10, 101, 10, 97, 
	10, 97, 117, 100, 105, 97, 97, 116, 
	97, 114, 32, 66, 101, 108, 97, 107, 
	97, 110, 103, 58, 10, 10, 10, 32, 
	35, 37, 42, 64, 65, 66, 68, 70, 
	75, 77, 83, 84, 9, 13, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, 10, 32, 10, 112, 10, 97, 
	10, 98, 10, 105, 10, 108, 10, 97, 
	10, 97, 10, 103, 10, 105, 10, 97, 
	105, 10, 110, 10, 98, 10, 101, 10, 
	114, 10, 117, 10, 110, 10, 103, 10, 
	115, 10, 105, 10, 58, 10, 101, 10, 
	97, 109, 10, 100, 10, 97, 10, 97, 
	10, 110, 10, 117, 10, 100, 10, 105, 
	10, 97, 10, 97, 101, 10, 107, 10, 
	110, 10, 103, 10, 103, 10, 97, 10, 
	114, 10, 105, 10, 115, 10, 107, 10, 
	97, 10, 110, 10, 32, 10, 83, 10, 
	101, 10, 110, 10, 97, 10, 114, 10, 
	105, 10, 111, 10, 101, 105, 10, 116, 
	10, 117, 10, 97, 10, 97, 101, 10, 
	112, 10, 109, 116, 10, 112, 10, 108, 
	10, 97, 10, 116, 10, 101, 10, 32, 
	10, 75, 83, 10, 101, 10, 97, 10, 
	97, 97, 101, 107, 110, 103, 103, 97, 
	114, 105, 115, 107, 97, 110, 32, 83, 
	101, 110, 97, 114, 105, 111, 58, 10, 
	10, 10, 32, 35, 37, 42, 64, 65, 
	66, 68, 70, 75, 77, 83, 84, 9, 
	13, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, 10, 32, 10, 
	112, 10, 97, 10, 98, 10, 105, 10, 
	108, 10, 97, 10, 97, 10, 103, 10, 
	105, 10, 97, 105, 10, 110, 10, 98, 
	10, 101, 10, 114, 10, 117, 10, 110, 
	10, 103, 10, 115, 10, 105, 10, 58, 
	10, 101, 10, 97, 109, 10, 100, 10, 
	97, 10, 97, 10, 110, 10, 117, 10, 
	100, 10, 105, 10, 97, 10, 97, 10, 
	107, 10, 101, 105, 10, 110, 10, 97, 
	10, 114, 10, 105, 10, 111, 10, 116, 
	10, 117, 10, 97, 10, 97, 101, 10, 
	112, 10, 116, 10, 97, 101, 105, 110, 
	97, 114, 105, 111, 116, 117, 97, 105, 
	97, 101, 112, 109, 116, 112, 108, 97, 
	116, 101, 32, 75, 83, 101, 97, 100, 
	97, 97, 110, 101, 105, 116, 117, 97, 
	105, 97, 32, 124, 9, 13, 10, 32, 
	92, 124, 9, 13, 10, 92, 124, 10, 
	92, 10, 32, 92, 124, 9, 13, 10, 
	32, 34, 35, 37, 42, 64, 65, 66, 
	67, 68, 70, 75, 76, 77, 83, 84, 
	124, 9, 13, 0
};

static const char _lexer_single_lengths[] = {
	0, 19, 1, 1, 18, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 3, 5, 3, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 5, 2, 
	2, 2, 2, 2, 2, 18, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 12, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	1, 2, 1, 1, 1, 1, 1, 1, 
	1, 15, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 3, 2, 3, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 14, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 3, 2, 3, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 14, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	2, 1, 1, 1, 1, 1, 1, 2, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 2, 4, 3, 2, 
	4, 18, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 1, 0, 0, 
	1, 1, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 21, 23, 25, 45, 47, 49, 
	52, 55, 60, 65, 70, 75, 79, 83, 
	86, 88, 90, 92, 94, 96, 98, 100, 
	102, 104, 106, 108, 110, 112, 114, 116, 
	118, 121, 124, 129, 136, 141, 143, 145, 
	147, 149, 151, 153, 155, 157, 159, 161, 
	163, 165, 167, 169, 171, 173, 175, 182, 
	185, 188, 191, 194, 197, 200, 220, 223, 
	225, 227, 229, 231, 233, 235, 237, 239, 
	241, 243, 245, 247, 261, 264, 267, 270, 
	273, 276, 279, 282, 285, 288, 291, 294, 
	297, 300, 303, 306, 309, 312, 315, 318, 
	321, 324, 327, 330, 333, 336, 339, 342, 
	345, 348, 351, 354, 357, 360, 363, 366, 
	369, 372, 375, 378, 381, 384, 387, 390, 
	393, 396, 399, 402, 405, 408, 411, 414, 
	417, 420, 423, 426, 429, 432, 435, 438, 
	441, 444, 447, 450, 454, 457, 460, 463, 
	466, 469, 472, 475, 478, 481, 484, 487, 
	491, 493, 496, 498, 500, 502, 504, 506, 
	508, 510, 527, 530, 533, 536, 539, 542, 
	545, 548, 551, 554, 557, 560, 563, 566, 
	569, 572, 575, 578, 581, 584, 587, 590, 
	593, 596, 599, 603, 606, 609, 612, 615, 
	618, 621, 624, 627, 630, 633, 636, 640, 
	643, 646, 649, 652, 655, 658, 661, 664, 
	667, 670, 673, 676, 679, 682, 685, 688, 
	691, 694, 697, 700, 703, 707, 710, 713, 
	716, 719, 722, 725, 728, 731, 734, 737, 
	740, 743, 746, 749, 752, 755, 758, 761, 
	764, 768, 771, 774, 777, 781, 784, 788, 
	791, 794, 797, 800, 803, 806, 810, 813, 
	816, 819, 821, 823, 825, 827, 829, 831, 
	833, 835, 837, 839, 841, 843, 845, 847, 
	849, 851, 853, 855, 857, 859, 875, 878, 
	881, 884, 887, 890, 893, 896, 899, 902, 
	905, 908, 911, 914, 917, 920, 923, 926, 
	929, 932, 935, 938, 941, 944, 947, 951, 
	954, 957, 960, 963, 966, 969, 972, 975, 
	978, 981, 984, 988, 991, 994, 997, 1000, 
	1003, 1006, 1009, 1012, 1016, 1019, 1022, 1025, 
	1028, 1031, 1034, 1037, 1040, 1043, 1046, 1049, 
	1052, 1055, 1058, 1061, 1064, 1067, 1070, 1073, 
	1077, 1080, 1083, 1086, 1090, 1093, 1097, 1100, 
	1103, 1106, 1109, 1112, 1115, 1119, 1122, 1125, 
	1128, 1131, 1133, 1135, 1137, 1139, 1141, 1143, 
	1145, 1147, 1149, 1151, 1153, 1155, 1157, 1159, 
	1161, 1163, 1165, 1167, 1169, 1171, 1173, 1175, 
	1191, 1194, 1197, 1200, 1203, 1206, 1209, 1212, 
	1215, 1218, 1221, 1224, 1227, 1230, 1233, 1236, 
	1239, 1242, 1245, 1248, 1251, 1254, 1257, 1260, 
	1263, 1267, 1270, 1273, 1276, 1279, 1282, 1285, 
	1288, 1291, 1294, 1297, 1300, 1304, 1307, 1310, 
	1313, 1316, 1319, 1322, 1325, 1328, 1331, 1334, 
	1338, 1341, 1344, 1347, 1350, 1353, 1356, 1359, 
	1362, 1366, 1369, 1372, 1375, 1378, 1380, 1382, 
	1384, 1386, 1388, 1390, 1392, 1394, 1396, 1399, 
	1401, 1404, 1406, 1408, 1410, 1412, 1414, 1416, 
	1419, 1421, 1423, 1425, 1427, 1429, 1431, 1434, 
	1436, 1438, 1440, 1442, 1444, 1448, 1454, 1458, 
	1461, 1467, 1487
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 15, 17, 31, 34, 
	37, 43, 46, 62, 67, 152, 261, 360, 
	444, 454, 476, 4, 0, 3, 0, 4, 
	0, 4, 4, 5, 15, 17, 31, 34, 
	37, 43, 46, 62, 67, 152, 261, 360, 
	444, 454, 476, 4, 0, 6, 0, 7, 
	0, 9, 8, 8, 9, 8, 8, 10, 
	10, 11, 10, 10, 10, 10, 11, 10, 
	10, 10, 10, 12, 10, 10, 10, 10, 
	13, 10, 10, 4, 14, 14, 0, 4, 
	14, 14, 0, 4, 16, 15, 4, 0, 
	18, 0, 19, 0, 20, 0, 21, 0, 
	22, 0, 23, 0, 24, 0, 25, 0, 
	26, 0, 27, 0, 28, 0, 29, 0, 
	30, 0, 482, 0, 32, 0, 4, 16, 
	33, 4, 16, 33, 0, 0, 0, 0, 
	35, 36, 4, 36, 36, 34, 35, 35, 
	4, 36, 34, 36, 0, 38, 0, 39, 
	0, 40, 0, 41, 0, 42, 0, 31, 
	0, 44, 0, 45, 0, 31, 0, 47, 
	0, 48, 0, 49, 0, 50, 0, 51, 
	0, 52, 0, 54, 53, 54, 53, 54, 
	54, 4, 55, 4, 54, 53, 54, 56, 
	53, 54, 57, 53, 54, 58, 53, 54, 
	59, 53, 54, 60, 53, 54, 61, 53, 
	4, 4, 5, 15, 17, 31, 34, 37, 
	43, 46, 62, 67, 152, 261, 360, 444, 
	454, 476, 4, 0, 63, 64, 0, 31, 
	0, 65, 0, 66, 0, 45, 0, 68, 
	0, 69, 0, 70, 0, 71, 0, 72, 
	0, 73, 0, 75, 74, 75, 74, 75, 
	75, 4, 76, 4, 90, 96, 101, 107, 
	120, 139, 143, 75, 74, 75, 77, 74, 
	75, 78, 74, 75, 79, 74, 75, 80, 
	74, 75, 81, 74, 75, 82, 74, 75, 
	83, 74, 75, 84, 74, 75, 85, 74, 
	75, 86, 74, 75, 87, 74, 75, 88, 
	74, 75, 89, 74, 75, 4, 74, 75, 
	91, 74, 75, 92, 74, 75, 93, 74, 
	75, 94, 74, 75, 95, 74, 75, 61, 
	74, 75, 97, 74, 75, 98, 74, 75, 
	99, 74, 75, 100, 74, 75, 95, 74, 
	75, 102, 74, 75, 103, 74, 75, 104, 
	74, 75, 105, 74, 75, 106, 74, 75, 
	95, 74, 75, 108, 74, 75, 109, 74, 
	75, 110, 74, 75, 111, 74, 75, 112, 
	74, 75, 113, 74, 75, 114, 74, 75, 
	115, 74, 75, 116, 74, 75, 117, 74, 
	75, 118, 74, 75, 119, 74, 75, 95, 
	74, 75, 121, 74, 75, 122, 74, 75, 
	123, 74, 75, 124, 74, 75, 125, 74, 
	75, 126, 74, 75, 127, 74, 75, 128, 
	74, 75, 129, 74, 75, 130, 74, 75, 
	131, 74, 75, 132, 74, 75, 133, 74, 
	75, 134, 74, 75, 135, 74, 75, 136, 
	74, 75, 137, 74, 75, 138, 74, 75, 
	95, 74, 75, 134, 140, 74, 75, 141, 
	74, 75, 142, 74, 75, 100, 74, 75, 
	144, 74, 75, 145, 74, 75, 146, 74, 
	75, 147, 74, 75, 148, 74, 75, 149, 
	74, 75, 150, 74, 75, 151, 74, 75, 
	101, 139, 74, 153, 0, 154, 257, 0, 
	155, 0, 156, 0, 157, 0, 158, 0, 
	159, 0, 161, 160, 161, 160, 161, 161, 
	4, 162, 176, 4, 177, 183, 186, 191, 
	197, 207, 220, 240, 244, 161, 160, 161, 
	163, 160, 161, 164, 160, 161, 165, 160, 
	161, 166, 160, 161, 167, 160, 161, 168, 
	160, 161, 169, 160, 161, 170, 160, 161, 
	171, 160, 161, 172, 160, 161, 173, 160, 
	161, 174, 160, 161, 175, 160, 161, 4, 
	160, 161, 61, 160, 161, 178, 160, 161, 
	179, 160, 161, 180, 160, 161, 181, 160, 
	161, 182, 160, 161, 176, 160, 161, 184, 
	160, 161, 185, 160, 161, 176, 160, 161, 
	187, 188, 160, 161, 176, 160, 161, 189, 
	160, 161, 190, 160, 161, 185, 160, 161, 
	192, 160, 161, 193, 160, 161, 194, 160, 
	161, 195, 160, 161, 196, 160, 161, 61, 
	160, 161, 198, 160, 161, 199, 203, 160, 
	161, 200, 160, 161, 201, 160, 161, 202, 
	160, 161, 196, 160, 161, 204, 160, 161, 
	205, 160, 161, 206, 160, 161, 187, 160, 
	161, 208, 160, 161, 209, 160, 161, 210, 
	160, 161, 211, 160, 161, 212, 160, 161, 
	213, 160, 161, 214, 160, 161, 215, 160, 
	161, 216, 160, 161, 217, 160, 161, 218, 
	160, 161, 219, 160, 161, 196, 160, 161, 
	221, 222, 160, 161, 182, 160, 161, 223, 
	160, 161, 224, 160, 161, 225, 160, 161, 
	226, 160, 161, 227, 160, 161, 228, 160, 
	161, 229, 160, 161, 230, 160, 161, 231, 
	160, 161, 232, 160, 161, 233, 160, 161, 
	234, 160, 161, 235, 160, 161, 236, 160, 
	161, 237, 160, 161, 238, 160, 161, 239, 
	160, 161, 196, 160, 161, 235, 241, 160, 
	161, 242, 160, 161, 243, 160, 161, 195, 
	160, 161, 245, 246, 160, 161, 185, 160, 
	161, 247, 256, 160, 161, 248, 160, 161, 
	249, 160, 161, 250, 160, 161, 251, 160, 
	161, 252, 160, 161, 253, 160, 161, 254, 
	240, 160, 161, 255, 160, 161, 199, 160, 
	161, 245, 160, 258, 0, 259, 0, 260, 
	0, 63, 0, 262, 0, 263, 0, 264, 
	0, 265, 0, 266, 0, 267, 0, 268, 
	0, 269, 0, 270, 0, 271, 0, 272, 
	0, 273, 0, 274, 0, 275, 0, 277, 
	276, 277, 276, 277, 277, 4, 278, 292, 
	4, 293, 299, 302, 307, 313, 323, 343, 
	347, 277, 276, 277, 279, 276, 277, 280, 
	276, 277, 281, 276, 277, 282, 276, 277, 
	283, 276, 277, 284, 276, 277, 285, 276, 
	277, 286, 276, 277, 287, 276, 277, 288, 
	276, 277, 289, 276, 277, 290, 276, 277, 
	291, 276, 277, 4, 276, 277, 61, 276, 
	277, 294, 276, 277, 295, 276, 277, 296, 
	276, 277, 297, 276, 277, 298, 276, 277, 
	292, 276, 277, 300, 276, 277, 301, 276, 
	277, 292, 276, 277, 303, 304, 276, 277, 
	292, 276, 277, 305, 276, 277, 306, 276, 
	277, 301, 276, 277, 308, 276, 277, 309, 
	276, 277, 310, 276, 277, 311, 276, 277, 
	312, 276, 277, 61, 276, 277, 314, 276, 
	277, 315, 319, 276, 277, 316, 276, 277, 
	317, 276, 277, 318, 276, 277, 312, 276, 
	277, 320, 276, 277, 321, 276, 277, 322, 
	276, 277, 303, 276, 277, 324, 325, 276, 
	277, 298, 276, 277, 326, 276, 277, 327, 
	276, 277, 328, 276, 277, 329, 276, 277, 
	330, 276, 277, 331, 276, 277, 332, 276, 
	277, 333, 276, 277, 334, 276, 277, 335, 
	276, 277, 336, 276, 277, 337, 276, 277, 
	338, 276, 277, 339, 276, 277, 340, 276, 
	277, 341, 276, 277, 342, 276, 277, 312, 
	276, 277, 338, 344, 276, 277, 345, 276, 
	277, 346, 276, 277, 311, 276, 277, 348, 
	349, 276, 277, 301, 276, 277, 350, 359, 
	276, 277, 351, 276, 277, 352, 276, 277, 
	353, 276, 277, 354, 276, 277, 355, 276, 
	277, 356, 276, 277, 357, 343, 276, 277, 
	358, 276, 277, 315, 276, 277, 348, 276, 
	361, 362, 0, 42, 0, 363, 0, 364, 
	0, 365, 0, 366, 0, 367, 0, 368, 
	0, 369, 0, 370, 0, 371, 0, 372, 
	0, 373, 0, 374, 0, 375, 0, 376, 
	0, 377, 0, 378, 0, 379, 0, 380, 
	0, 381, 0, 383, 382, 383, 382, 383, 
	383, 4, 384, 398, 4, 399, 405, 408, 
	413, 419, 429, 431, 440, 383, 382, 383, 
	385, 382, 383, 386, 382, 383, 387, 382, 
	383, 388, 382, 383, 389, 382, 383, 390, 
	382, 383, 391, 382, 383, 392, 382, 383, 
	393, 382, 383, 394, 382, 383, 395, 382, 
	383, 396, 382, 383, 397, 382, 383, 4, 
	382, 383, 61, 382, 383, 400, 382, 383, 
	401, 382, 383, 402, 382, 383, 403, 382, 
	383, 404, 382, 383, 398, 382, 383, 406, 
	382, 383, 407, 382, 383, 398, 382, 383, 
	409, 410, 382, 383, 398, 382, 383, 411, 
	382, 383, 412, 382, 383, 407, 382, 383, 
	414, 382, 383, 415, 382, 383, 416, 382, 
	383, 417, 382, 383, 418, 382, 383, 61, 
	382, 383, 420, 382, 383, 421, 425, 382, 
	383, 422, 382, 383, 423, 382, 383, 424, 
	382, 383, 418, 382, 383, 426, 382, 383, 
	427, 382, 383, 428, 382, 383, 409, 382, 
	383, 430, 382, 383, 404, 382, 383, 432, 
	437, 382, 383, 433, 382, 383, 434, 382, 
	383, 435, 382, 383, 436, 382, 383, 418, 
	382, 383, 438, 382, 383, 439, 382, 383, 
	417, 382, 383, 441, 442, 382, 383, 407, 
	382, 383, 443, 382, 383, 441, 382, 445, 
	450, 0, 446, 0, 447, 0, 448, 0, 
	449, 0, 158, 0, 451, 0, 452, 0, 
	453, 0, 158, 0, 455, 456, 0, 45, 
	0, 457, 475, 0, 458, 0, 459, 0, 
	460, 0, 461, 0, 462, 0, 463, 0, 
	464, 470, 0, 465, 0, 466, 0, 467, 
	0, 468, 0, 469, 0, 380, 0, 375, 
	471, 0, 472, 0, 473, 0, 474, 0, 
	380, 0, 455, 0, 476, 477, 476, 0, 
	481, 480, 479, 477, 480, 478, 0, 479, 
	477, 478, 0, 479, 478, 481, 480, 479, 
	477, 480, 478, 481, 481, 5, 15, 17, 
	31, 34, 37, 43, 46, 62, 67, 152, 
	261, 360, 444, 454, 476, 481, 0, 0, 
	0
};

static const unsigned char _lexer_trans_actions[] = {
	0, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 35, 0, 43, 0, 43, 0, 
	43, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 35, 0, 43, 0, 43, 0, 
	43, 139, 48, 9, 106, 11, 0, 134, 
	45, 45, 45, 3, 122, 33, 33, 33, 
	0, 122, 33, 33, 33, 0, 122, 33, 
	0, 33, 0, 102, 7, 7, 43, 54, 
	0, 0, 43, 114, 25, 0, 54, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 149, 126, 
	57, 110, 23, 0, 43, 43, 43, 43, 
	0, 27, 118, 27, 27, 51, 27, 0, 
	54, 0, 1, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 54, 
	0, 81, 84, 81, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 21, 0, 
	130, 31, 60, 57, 31, 63, 57, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	63, 66, 31, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 54, 
	0, 69, 33, 69, 84, 84, 84, 84, 
	84, 84, 84, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 13, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 13, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 54, 0, 
	75, 33, 84, 75, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 17, 
	0, 54, 17, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 17, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 54, 0, 72, 33, 84, 
	72, 84, 84, 84, 84, 84, 84, 84, 
	84, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 15, 0, 54, 15, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 15, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 54, 
	0, 78, 33, 84, 78, 84, 84, 84, 
	84, 84, 84, 84, 84, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 19, 
	0, 54, 19, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 19, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 0, 0, 43, 
	54, 37, 37, 87, 37, 37, 43, 0, 
	39, 0, 43, 0, 0, 54, 0, 0, 
	39, 0, 0, 54, 0, 93, 90, 41, 
	96, 90, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 99, 0, 43, 0, 
	0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 482;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/bm.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1120 "ext/gherkin_lexer_bm/gherkin_lexer_bm.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/bm.c.rl"
    
#line 1127 "ext/gherkin_lexer_bm/gherkin_lexer_bm.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/bm.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/bm.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/bm.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/bm.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/bm.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/bm.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/bm.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/bm.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/bm.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/bm.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/bm.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/bm.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/bm.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/bm.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/bm.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/bm.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/bm.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/bm.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/bm.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/bm.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/bm.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/bm.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/bm.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/bm.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1417 "ext/gherkin_lexer_bm/gherkin_lexer_bm.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/bm.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1480 "ext/gherkin_lexer_bm/gherkin_lexer_bm.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/bm.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_bm()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Bm", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

