/*
*  RAL -- Rubrica Addressbook Library
*  file: personal.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_PERSONAL_CARD_H
#define _R_PERSONAL_CARD_H

#include <glib.h>
#include <glib-object.h>

#include "card.h"
#include "contact.h"
#include "work.h"
#include "notes.h"


#define R_PERSONAL_CARD_TYPE           (r_personal_card_get_type())
 
#define R_PERSONAL_CARD(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),  \
                                        R_PERSONAL_CARD_TYPE,              \
                                        RPersonalCard))

#define R_PERSONAL_CARD_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),   \
                                        R_PERSONAL_CARD_TYPE,              \
                                        RPersonalCardClass))

#define IS_R_PERSONAL_CARD(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),  \
                                        R_PERSONAL_CARD_TYPE))

#define IS_R_PERSONAL_CARD_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls),     \
                                        R_PERSONAL_CARD_TYPE))

#define R_PERSONAL_CARD_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),   \
                                        R_PERSONAL_CARD_TYPE,              \
                                        RPersonalCardClass))



typedef struct _RPersonalCard        RPersonalCard;
typedef struct _RPersonalCardClass   RPersonalCardClass;
typedef struct _RPersonalCardPrivate RPersonalCardPrivate;


               
struct _RPersonalCard 
{
  RCard parent;

  RPersonalCardPrivate* priv;
};



struct _RPersonalCardClass
{
  RCardClass parent;
};



GType          r_personal_card_get_type (void);

RPersonalCard* r_personal_card_new  (void);


RContact* r_personal_card_get_contact (RPersonalCard* card);
RWork*    r_personal_card_get_work    (RPersonalCard* card);
RNotes*   r_personal_card_get_notes   (RPersonalCard* card);


void      r_personal_card_set_contact (RPersonalCard* card, RContact* contact);
void      r_personal_card_set_work    (RPersonalCard* card, RWork* work);
void      r_personal_card_set_notes   (RPersonalCard* card, RNotes* notes);

gboolean  r_personal_card_belongs_to_genre (RPersonalCard* card, 
					    const gchar* genre);

#endif
