set terminal pslatex color auxfile
set output "p-laplacian-newton-square-r1.tex"

set logscale y
set size square 0.7
set xtics (0,25)
set ytics (\
        "[r]{$10^{-15}$}" 1e-15, \
        "[r]{$10^{-10}$}" 1e-10, \
        "[r]{$10^{-5}$}" 1e-5, \
        "[r]{$10^{0}$}" 1 )
set xlabel "[c]{$n$}"
set  label "[r]{\\Large $\\|r_h\\|_{-1,h}$}" at graph -0.05,0.43


set logscale y

plot [0:25][1e-15:1e4] \
"p-laplacian-newton-square-p=1.5.gdat" title "[r]{$p=1.5$}" w l, \
"p-laplacian-newton-square-p=1.6.gdat" title "[r]{$p=1.6$}" w l, \
"p-laplacian-newton-square-p=1.7.gdat" title "[r]{$p=1.7$}" w l

#pause -1 "<retour>"
