% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remotes.R
\name{git_remote}
\alias{git_remote}
\alias{git_remote_list}
\alias{git_remote_add}
\alias{git_remote_remove}
\alias{git_remote_info}
\alias{git_remote_set_url}
\alias{git_remote_set_pushurl}
\alias{git_remote_refspecs}
\title{Git Remotes}
\usage{
git_remote_list(repo = ".")

git_remote_add(url, name = "origin", refspec = NULL, repo = ".")

git_remote_remove(remote, repo = ".")

git_remote_info(remote = NULL, repo = ".")

git_remote_set_url(url, remote = NULL, repo = ".")

git_remote_set_pushurl(url, remote = NULL, repo = ".")

git_remote_refspecs(remote = NULL, repo = ".")
}
\arguments{
\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}. When using this
parameter, always explicitly call by name (i.e. \verb{repo = }) because future
versions of gert may have additional parameters.}

\item{url}{server url (https or ssh)}

\item{name}{unique name for the new remote}

\item{refspec}{optional string with the remote fetch value}

\item{remote}{name of an existing remote. Default \code{NULL} means the remote
from the upstream of the current branch.}
}
\description{
List, add, configure, or remove remotes.
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_branch}()},
\code{\link{git_commit}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_fetch}()},
\code{\link{git_ignore}},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_repo}},
\code{\link{git_signature}()},
\code{\link{git_stash}},
\code{\link{git_tag}}
}
\concept{git}
