% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A1-to-from-RC.R
\name{A1_to_R1C1}
\alias{A1_to_R1C1}
\title{Convert cell reference strings from A1 to R1C1 format}
\usage{
A1_to_R1C1(x, strict = TRUE)
}
\arguments{
\item{x}{character vector of cell references in A1 format}

\item{strict}{logical, affects reading and writing of A1 formatted cell
references. When \code{strict = TRUE}, references must be declared absolute
through the use of dollar signs, e.g., \code{$A$1},  for parsing. When
making a string, \code{strict = TRUE} requests dollar signs for absolute
reference. When \code{strict = FALSE}, pure relative reference strings will
be interpreted as absolute, i.e. \code{A1} and \code{$A$1} are treated the
same. When making a string, \code{strict = FALSE} will cause dollars signs
to be omitted in the reference string.}
}
\value{
character vector of absolute cell references in R1C1 format
}
\description{
Convert cell reference strings from A1 to R1C1 format. Strictly speaking,
this only makes sense for absolute references, such as \code{"$B$4"}. Why?
Because otherwise, we'd have to know the host cell of the reference. Set
\code{strict = FALSE} to relax and treat pure relative references, like
(\code{"B4"}), as if they are absolute. Mixed references, like
(\code{"B$4"}), will always return \code{NA}, no matter the value of
\code{strict}.
}
\examples{
A1_to_R1C1("$A$1")
A1_to_R1C1("A1")                 ## raises a warning, returns NA
A1_to_R1C1("A1", strict = FALSE) ## unless strict = FALSE
A1_to_R1C1(c("A1", "B$4")) ## raises a warning, includes an NA, because
A1_to_R1C1(c("A1", "B$4"), strict = FALSE) ## mixed ref always returns NA
}

