% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mefisto.R
\name{interpolate_factors}
\alias{interpolate_factors}
\title{Interpolate factors in MEFISTO based on new covariate values}
\usage{
interpolate_factors(object, new_values)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object trained with MEFISTO options and a covariate}

\item{new_values}{a matrix containing the new covariate values to inter/extrapolate to. Should be
in the same format as the covariated used for training.}
}
\value{
Returns the \code{\link{MOFA}} with interpolated factor values filled in the corresponding slot (interpolatedZ)
}
\description{
Function to interpolate factors in MEFISTO based on new covariate values.
}
\details{
This function requires the functional MEFISTO framework to be used in training. 
Use \code{set_covariates} and specify mefisto_options when preparing the training using \code{prepare_mofa}. 
Currenlty, only the mean of the interpolation is provided from R.
}
\examples{
# Using an existing trained model
file <- system.file("extdata", "MEFISTO_model.hdf5", package = "MOFA2")
model <- load_model(file)
model <- interpolate_factors(model, new_values = seq(0,1.1,0.01))
}
