% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_methods.R
\name{get_data}
\alias{get_data}
\title{Get data}
\usage{
get_data(
  object,
  views = "all",
  groups = "all",
  features = "all",
  as.data.frame = FALSE,
  add_intercept = TRUE,
  denoise = FALSE,
  na.rm = TRUE
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{views}{character vector with the view name(s), or numeric vector with the view index(es). 
Default is "all".}

\item{groups}{character vector with the group name(s), or numeric vector with the group index(es). 
Default is "all".}

\item{features}{a *named* list of character vectors. Example: list("view1"=c("feature_1","feature_2"), "view2"=c("feature_3","feature_4"))
Default is "all".}

\item{as.data.frame}{logical indicating whether to return a long data frame instead of a list of matrices. Default is \code{FALSE}.}

\item{add_intercept}{logical indicating whether to add feature intercepts to the data. Default is \code{TRUE}.}

\item{denoise}{logical indicating whether to return the denoised data (i.e. the model predictions). Default is \code{FALSE}.}

\item{na.rm}{remove NAs from the data.frame (only if as.data.frame is \code{TRUE}).}
}
\value{
A  list of data matrices with dimensionality (D,N) or a \code{data.frame} (if \code{as.data.frame} is TRUE)
}
\description{
Fetch the input data
}
\details{
By default this function returns a list where each element is a data matrix with dimensionality (D,N) 
where D is the number of features and N is the number of samples. \cr
Alternatively, if \code{as.data.frame} is \code{TRUE}, the function returns a long-formatted data frame with columns (view,feature,sample,value).
Missing values are not included in the the long data.frame format by default. To include them use the argument \code{na.rm=FALSE}.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Fetch data
data <- get_data(model)

# Fetch a specific view
data <- get_data(model, views = "view_0")

# Fetch data in data.frame format instead of matrix format
data <- get_data(model, as.data.frame = TRUE)

# Fetch centered data (do not add the feature intercepts)
data <- get_data(model, as.data.frame = FALSE)

# Fetch denoised data (do not add the feature intercepts)
data <- get_data(model, denoise = TRUE)
}
