# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, Generic, List, Optional, TypeVar, Union
import warnings

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest

from ... import models as _models

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class AzureAppConfigurationOperationsMixin:

    def get_keys(
        self,
        name: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.KeyListResult"]:
        """Gets a list of keys.

        Gets a list of keys.

        :param name: A filter for the name of the returned keys.
        :type name: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time.
        :type accept_datetime: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyListResult or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.KeyListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.KeyListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/vnd.microsoft.appconfig.keyset+json, application/json, application/problem+json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            if self._config.sync_token is not None:
                header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
            if accept_datetime is not None:
                header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.get_keys.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if name is not None:
                    query_parameters['name'] = self._serialize.query("name", name, 'str')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if after is not None:
                    query_parameters['After'] = self._serialize.query("after", after, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize('KeyListResult', pipeline_response)
            list_of_elem = deserialized.items
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.Error, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(
            get_next, extract_data
        )
    get_keys.metadata = {'url': '/keys'}  # type: ignore

    async def check_keys(
        self,
        name: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param name: A filter for the name of the returned keys.
        :type name: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time.
        :type accept_datetime: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"

        # Construct URL
        url = self.check_keys.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if name is not None:
            query_parameters['name'] = self._serialize.query("name", name, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if after is not None:
            query_parameters['After'] = self._serialize.query("after", after, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Sync-Token']=self._deserialize('str', response.headers.get('Sync-Token'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    check_keys.metadata = {'url': '/keys'}  # type: ignore

    def get_key_values(
        self,
        key: Optional[str] = None,
        label: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Get6ItemsItem"]]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.KeyValueListResult"]:
        """Gets a list of key-values.

        Gets a list of key-values.

        :param key: A filter used to match keys.
        :type key: str
        :param label: A filter used to match labels.
        :type label: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s).
        :type select: list[str or ~azure.appconfiguration.models.Get6ItemsItem]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyValueListResult or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.KeyValueListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.KeyValueListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/vnd.microsoft.appconfig.kvset+json, application/json, application/problem+json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            if self._config.sync_token is not None:
                header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
            if accept_datetime is not None:
                header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.get_key_values.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if key is not None:
                    query_parameters['key'] = self._serialize.query("key", key, 'str')
                if label is not None:
                    query_parameters['label'] = self._serialize.query("label", label, 'str')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if after is not None:
                    query_parameters['After'] = self._serialize.query("after", after, 'str')
                if select is not None:
                    query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize('KeyValueListResult', pipeline_response)
            list_of_elem = deserialized.items
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.Error, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(
            get_next, extract_data
        )
    get_key_values.metadata = {'url': '/kv'}  # type: ignore

    async def check_key_values(
        self,
        key: Optional[str] = None,
        label: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Head6ItemsItem"]]] = None,
        **kwargs: Any
    ) -> None:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param key: A filter used to match keys.
        :type key: str
        :param label: A filter used to match labels.
        :type label: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s).
        :type select: list[str or ~azure.appconfiguration.models.Head6ItemsItem]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"

        # Construct URL
        url = self.check_key_values.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if key is not None:
            query_parameters['key'] = self._serialize.query("key", key, 'str')
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if after is not None:
            query_parameters['After'] = self._serialize.query("after", after, 'str')
        if select is not None:
            query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Sync-Token']=self._deserialize('str', response.headers.get('Sync-Token'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    check_key_values.metadata = {'url': '/kv'}  # type: ignore

    async def get_key_value(
        self,
        key: str,
        label: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Get7ItemsItem"]]] = None,
        **kwargs: Any
    ) -> "_models.KeyValue":
        """Gets a single key-value.

        Gets a single key-value.

        :param key: The key of the key-value to retrieve.
        :type key: str
        :param label: The label of the key-value to retrieve.
        :type label: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time.
        :type accept_datetime: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided.
        :type if_none_match: str
        :param select: Used to select what fields are present in the returned resource(s).
        :type select: list[str or ~azure.appconfiguration.models.Get7ItemsItem]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue, or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.KeyValue"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/vnd.microsoft.appconfig.kv+json, application/json, application/problem+json"

        # Construct URL
        url = self.get_key_value.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'key': self._serialize.url("key", key, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if select is not None:
            query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Sync-Token']=self._deserialize('str', response.headers.get('Sync-Token'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('str', response.headers.get('Last-Modified'))
        deserialized = self._deserialize('KeyValue', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get_key_value.metadata = {'url': '/kv/{key}'}  # type: ignore

    async def put_key_value(
        self,
        key: str,
        label: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        entity: Optional["_models.KeyValue"] = None,
        **kwargs: Any
    ) -> "_models.KeyValue":
        """Creates a key-value.

        Creates a key-value.

        :param key: The key of the key-value to create.
        :type key: str
        :param label: The label of the key-value to create.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided.
        :type if_none_match: str
        :param entity: The key-value to create.
        :type entity: ~azure.appconfiguration.models.KeyValue
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue, or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.KeyValue"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        content_type = kwargs.pop("content_type", "application/vnd.microsoft.appconfig.kv+json")
        accept = "application/vnd.microsoft.appconfig.kv+json, application/json, application/problem+json"

        # Construct URL
        url = self.put_key_value.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'key': self._serialize.url("key", key, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if entity is not None:
            body_content = self._serialize.body(entity, 'KeyValue')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Sync-Token']=self._deserialize('str', response.headers.get('Sync-Token'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('KeyValue', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    put_key_value.metadata = {'url': '/kv/{key}'}  # type: ignore

    async def delete_key_value(
        self,
        key: str,
        label: Optional[str] = None,
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> Optional["_models.KeyValue"]:
        """Deletes a key-value.

        Deletes a key-value.

        :param key: The key of the key-value to delete.
        :type key: str
        :param label: The label of the key-value to delete.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue, or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.KeyValue"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/vnd.microsoft.appconfig.kv+json, application/json, application/problem+json"

        # Construct URL
        url = self.delete_key_value.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'key': self._serialize.url("key", key, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        deserialized = None
        if response.status_code == 200:
            response_headers['Sync-Token']=self._deserialize('str', response.headers.get('Sync-Token'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            deserialized = self._deserialize('KeyValue', pipeline_response)

        if response.status_code == 204:
            response_headers['Sync-Token']=self._deserialize('str', response.headers.get('Sync-Token'))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    delete_key_value.metadata = {'url': '/kv/{key}'}  # type: ignore

    async def check_key_value(
        self,
        key: str,
        label: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Head7ItemsItem"]]] = None,
        **kwargs: Any
    ) -> None:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param key: The key of the key-value to retrieve.
        :type key: str
        :param label: The label of the key-value to retrieve.
        :type label: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time.
        :type accept_datetime: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided.
        :type if_none_match: str
        :param select: Used to select what fields are present in the returned resource(s).
        :type select: list[str or ~azure.appconfiguration.models.Head7ItemsItem]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"

        # Construct URL
        url = self.check_key_value.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'key': self._serialize.url("key", key, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if select is not None:
            query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')

        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Sync-Token']=self._deserialize('str', response.headers.get('Sync-Token'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('str', response.headers.get('Last-Modified'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    check_key_value.metadata = {'url': '/kv/{key}'}  # type: ignore

    def get_labels(
        self,
        name: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.LabelListResult"]:
        """Gets a list of labels.

        Gets a list of labels.

        :param name: A filter for the name of the returned labels.
        :type name: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s).
        :type select: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either LabelListResult or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.LabelListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LabelListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/vnd.microsoft.appconfig.labelset+json, application/json, application/problem+json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            if self._config.sync_token is not None:
                header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
            if accept_datetime is not None:
                header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.get_labels.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if name is not None:
                    query_parameters['name'] = self._serialize.query("name", name, 'str')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if after is not None:
                    query_parameters['After'] = self._serialize.query("after", after, 'str')
                if select is not None:
                    query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize('LabelListResult', pipeline_response)
            list_of_elem = deserialized.items
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.Error, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(
            get_next, extract_data
        )
    get_labels.metadata = {'url': '/labels'}  # type: ignore

    async def check_labels(
        self,
        name: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param name: A filter for the name of the returned labels.
        :type name: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s).
        :type select: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"

        # Construct URL
        url = self.check_labels.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if name is not None:
            query_parameters['name'] = self._serialize.query("name", name, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if after is not None:
            query_parameters['After'] = self._serialize.query("after", after, 'str')
        if select is not None:
            query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Sync-Token']=self._deserialize('str', response.headers.get('Sync-Token'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    check_labels.metadata = {'url': '/labels'}  # type: ignore

    async def put_lock(
        self,
        key: str,
        label: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.KeyValue":
        """Locks a key-value.

        Locks a key-value.

        :param key: The key of the key-value to lock.
        :type key: str
        :param label: The label, if any, of the key-value to lock.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided.
        :type if_none_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue, or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.KeyValue"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/vnd.microsoft.appconfig.kv+json, application/json, application/problem+json"

        # Construct URL
        url = self.put_lock.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'key': self._serialize.url("key", key, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Sync-Token']=self._deserialize('str', response.headers.get('Sync-Token'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('KeyValue', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    put_lock.metadata = {'url': '/locks/{key}'}  # type: ignore

    async def delete_lock(
        self,
        key: str,
        label: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.KeyValue":
        """Unlocks a key-value.

        Unlocks a key-value.

        :param key: The key of the key-value to unlock.
        :type key: str
        :param label: The label, if any, of the key-value to unlock.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided.
        :type if_none_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue, or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.KeyValue"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/vnd.microsoft.appconfig.kv+json, application/json, application/problem+json"

        # Construct URL
        url = self.delete_lock.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'key': self._serialize.url("key", key, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Sync-Token']=self._deserialize('str', response.headers.get('Sync-Token'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('KeyValue', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    delete_lock.metadata = {'url': '/locks/{key}'}  # type: ignore

    def get_revisions(
        self,
        key: Optional[str] = None,
        label: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Enum4"]]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.KeyValueListResult"]:
        """Gets a list of key-value revisions.

        Gets a list of key-value revisions.

        :param key: A filter used to match keys.
        :type key: str
        :param label: A filter used to match labels.
        :type label: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s).
        :type select: list[str or ~azure.appconfiguration.models.Enum4]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyValueListResult or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.KeyValueListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.KeyValueListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/vnd.microsoft.appconfig.kvset+json, application/json, application/problem+json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            if self._config.sync_token is not None:
                header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
            if accept_datetime is not None:
                header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.get_revisions.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if key is not None:
                    query_parameters['key'] = self._serialize.query("key", key, 'str')
                if label is not None:
                    query_parameters['label'] = self._serialize.query("label", label, 'str')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
                if after is not None:
                    query_parameters['After'] = self._serialize.query("after", after, 'str')
                if select is not None:
                    query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize('KeyValueListResult', pipeline_response)
            list_of_elem = deserialized.items
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.Error, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(
            get_next, extract_data
        )
    get_revisions.metadata = {'url': '/revisions'}  # type: ignore

    async def check_revisions(
        self,
        key: Optional[str] = None,
        label: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Enum5"]]] = None,
        **kwargs: Any
    ) -> None:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param key: A filter used to match keys.
        :type key: str
        :param label: A filter used to match labels.
        :type label: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s).
        :type select: list[str or ~azure.appconfiguration.models.Enum5]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"

        # Construct URL
        url = self.check_revisions.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if key is not None:
            query_parameters['key'] = self._serialize.query("key", key, 'str')
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if after is not None:
            query_parameters['After'] = self._serialize.query("after", after, 'str')
        if select is not None:
            query_parameters['$Select'] = self._serialize.query("select", select, '[str]', div=',')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.sync_token is not None:
            header_parameters['Sync-Token'] = self._serialize.header("self._config.sync_token", self._config.sync_token, 'str')
        if accept_datetime is not None:
            header_parameters['Accept-Datetime'] = self._serialize.header("accept_datetime", accept_datetime, 'str')

        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Sync-Token']=self._deserialize('str', response.headers.get('Sync-Token'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    check_revisions.metadata = {'url': '/revisions'}  # type: ignore
