# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class APIKeyRequest(Model):
    """An Application Insights component API Key creation request definition.

    :param name: The name of the API Key.
    :type name: str
    :param linked_read_properties: The read access rights of this API Key.
    :type linked_read_properties: list[str]
    :param linked_write_properties: The write access rights of this API Key.
    :type linked_write_properties: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'linked_read_properties': {'key': 'linkedReadProperties', 'type': '[str]'},
        'linked_write_properties': {'key': 'linkedWriteProperties', 'type': '[str]'},
    }

    def __init__(self, *, name: str=None, linked_read_properties=None, linked_write_properties=None, **kwargs) -> None:
        super(APIKeyRequest, self).__init__(**kwargs)
        self.name = name
        self.linked_read_properties = linked_read_properties
        self.linked_write_properties = linked_write_properties
