/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __COMMANDESEC__
#define __COMMANDESEC__

#include <src/global/global.h>

typedef struct commandesec CONTENEUR(CommandeSec);

#include <src/donnees/flux/flux.h>
#include <src/donnees/flux/actionflux.h>
#include <src/donnees/commandes/localisationfichier.h>

struct commandesec
{
	STOCKAGE(LocalisationFichier) localisation;
	//Localisation du remplacement par un nom de section
	//dans le source.
	STOCKAGE(Flux) niveau;
	//Niveau cible du nom  remplacer.
	//Si ce flux est gal  NULL, alors le niveau
	//de la destination de la rfrence sera choisi.
	//Dans le cas o le niveau est indiqu, si le paramtre est
	//numrique, la commande sera remplace par le nom de la
	//section du niveau demand. S'il est textuel, le texte en
	//question sera recherch dans la liste des noms de sections
	//et conserv seulement si n nom correspond. Dans le cas
	//contraire, la commande sera simplement ignore.
	//Ce flux est de type FLUX_NIVEAU.
};
/* Commande dsigne pour indiquer o remplacer par un nom de section
 * dans un format de rfrence.
 */

Resultat commandesec_initialisation(TRAVAIL(CommandeSec) commandesec);
/* Cre une commande sec vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandesec_definition_localisationfichier(TRAVAIL(CommandeSec) commandesec , TRAVAIL(LocalisationFichier) localisationfichier);
/* Indique la position d'une commande sec.
 * Renvoie RESULTAT_ERREUR si commandesec est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandesec_definition_niveau(TRAVAIL(CommandeSec) commandesec , TRAVAIL(Flux) niveau);
/* Assigne un niveau  une commande sec.
 * Renvoie RESULTAT_ERREUR si commandesec est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandesec_lecture_localisationfichier(TRAVAIL(CommandeSec) commandesec , REFERENCE(LocalisationFichier) localisationfichier);
/* Indique la position d'une commande sec.
 * Renvoie RESULTAT_ERREUR si commandesec est NULL.
 */

Resultat commandesec_lecture_niveau(TRAVAIL(CommandeSec) commandesec , REFERENCE(Flux) niveau);
/* Lit un niveau  une commande sec.
 * Renvoie RESULTAT_ERREUR si commandesec est NULL.
 */

Resultat commandesec_parcours(TRAVAIL(CommandeSec) commandesec , TRAVAIL(ActionFlux) action , TRAVAIL(General) general);
/* Ralise un parcours des flux inclus dans la commande spcifie.
 * Renvoie les mmes erreurs que flux_parcours,
 * ainsi que RESULTAT_ERREUR si commande est NULL,
 * rien ne se passe si action est NULL.
 */

Resultat commandesec_copie(TRAVAIL(CommandeSec) commandesec , TRAVAIL(CommandeSec) copie);
/* Cre une copie de la commande sec.
 * Renvoie RESULTAT_ERREUR si commandesec est NULL, et
 * RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 * Si la copie est non vide, elle est au pralable supprime.
 */

Resultat commandesec_destruction(TRAVAIL(CommandeSec) commandesec);
/* Dtruit une commande sec.
 */

#endif
