/* Copyright (c) 2001-2025, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

package com.pixelmed.dicom;

/**
 * <p>Standard DICOM PET 20 Step color palette.</p>
 *
 * @author	dclunie
 */
public class ColorPalettePET20Step extends ColorPalette {
	private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ColorPalettePET20Step.java,v 1.15 2025/01/29 10:58:06 dclunie Exp $";
	
	protected static String sopInstanceUIDStatic = "1.2.840.10008.1.5.4";
	protected static String contentLabelStatic = "PET_20_STEP";
	protected static String contentDescriptionStatic = "PET 20 Step";
	protected static String contentCreatorNameStatic = "PixelMed^Publishing";
	protected static String referenceEncodedInstanceURLStatic = "ftp://medical.nema.org/Medical/Dicom/Palettes/pet20step.dcm";
	
	protected static String[] alternateContentDescriptionStatic = { "TEP Vingt étapes", "PET 20 Schritte" };
	protected static String[] alternateContentLanguageCodeValueStatic = { "fr", "de" };
	protected static String[] alternateContentLanguageCodeMeaningStatic = { "French", "German" };
	
	protected static byte[] redStaticArray = {
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255
	};
	
	protected static byte[] greenStaticArray = {
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)208,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)144,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255
	};

	protected static byte[] blueStaticArray = {
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)112,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)128,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)176,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)192,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)224,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)48,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)80,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)96,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)64,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255
	};

	public ColorPalettePET20Step() {
		red = redStaticArray;
		green = greenStaticArray;
		blue = blueStaticArray;
		sopInstanceUID= sopInstanceUIDStatic;
		contentLabel = contentLabelStatic;
		contentDescription = contentDescriptionStatic;
		contentCreatorName = contentCreatorNameStatic;
		referenceEncodedInstanceURL = referenceEncodedInstanceURLStatic;
		alternateContentDescription = alternateContentDescriptionStatic;
		alternateContentLanguageCodeValue = alternateContentLanguageCodeValueStatic;
		alternateContentLanguageCodeMeaning = alternateContentLanguageCodeMeaningStatic;
	}

	/**
	 * <p>Create a DICOM color palette storage instance from the palette characteristics.</p>
	 *
	 * @param	arg one or two arguments, the name of the DICOM file to write, and optionally the name of a file containing the ICC profile to include
	 */
	public static void main(String arg[]) {

		try {
			new ColorPalettePET20Step().createDICOMInstance(arg[0],(arg.length > 1 ? arg[1] : null),"OURAETITLE");
		}
		catch (Exception e) {
			System.err.println(e);
			e.printStackTrace(System.err);	// no need to use SLF4J since command line utility/test
			System.exit(0);
		}
	}
}
