/*	Host_Address

CVS ID: Host_Address.java,v 1.3 2012/04/16 06:18:24 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Utilities.Host;

import	javax.swing.JFrame;
import	javax.swing.JPanel;
import	javax.swing.JLabel;
import	javax.swing.JTextField;
import	java.awt.Dimension;
import	java.awt.BorderLayout;
import	java.awt.GridBagLayout;
import	java.awt.GridBagConstraints;
import	java.awt.Insets;
import	java.awt.event.ActionListener;
import	java.awt.event.ActionEvent;


public class Host_Address
	extends JFrame
{
JTextField
	Hostname_Field		= new JTextField (Host.FULL_HOSTNAME),
	IP_Address_Field	= new JTextField (Host.IP_ADDRESS);

public Host_Address ()
{
super ("Host Address");
JPanel
	panel = new JPanel (new GridBagLayout ());
GridBagConstraints
	location = new GridBagConstraints ();

//	Hostname.
location.anchor		= GridBagConstraints.EAST;
location.gridwidth	= 1;
location.weightx	= 0.0;
location.fill		= GridBagConstraints.NONE;
location.insets		= new Insets (5, 5, 5, 3);
panel.add (new JLabel ("Hostname:"), location);

Dimension
	dimension = Hostname_Field.getPreferredSize ();
dimension.width = 175;
Hostname_Field.setMinimumSize (dimension);
Hostname_Field.setPreferredSize (dimension);
location.gridwidth	= GridBagConstraints.REMAINDER;
location.weightx	= 1.0;
location.fill		= GridBagConstraints.HORIZONTAL;
location.insets		= new Insets (5, 0, 5, 5);
panel.add (Hostname_Field, location);
Hostname_Field.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event)
		{Reset_from_Name (Hostname_Field.getText ());}});

//	IP Address.
location.anchor		= GridBagConstraints.EAST;
location.gridwidth	= 1;
location.weightx	= 0.0;
location.fill		= GridBagConstraints.NONE;
location.insets		= new Insets (5, 5, 5, 3);
panel.add (new JLabel ("IP Address:"), location);

location.gridwidth	= GridBagConstraints.REMAINDER;
location.weightx	= 1.0;
location.fill		= GridBagConstraints.HORIZONTAL;
location.insets		= new Insets (5, 0, 5, 5);
panel.add (IP_Address_Field, location);
IP_Address_Field.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event)
		{Reset_from_Name (IP_Address_Field.getText ());}});

getContentPane ().add (panel, BorderLayout.CENTER);
setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);
pack ();
}


private void Reset_from_Name
	(
	String	hostname
	)
{
Hostname_Field.setText (Host.Full_Hostname (hostname));
IP_Address_Field.setText (Host.IP_Address (hostname));
}


public static void main (String[] args)
{
Host_Address
	host_address = new Host_Address ();
host_address.setLocation (250, 300);
//host_address.setPreferredSize (new Dimension (100, 50));
host_address.setVisible (true);
}

}
