/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <AxisTickMarks.h>
#include <DataNode.h>

// Type map format string
const char *AxisTickMarks::TypeMapFormatString = "bdddd";

// ****************************************************************************
// Method: AxisTickMarks::AxisTickMarks
//
// Purpose: 
//   Constructor for the AxisTickMarks class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisTickMarks::AxisTickMarks() : 
    AttributeSubject(AxisTickMarks::TypeMapFormatString)
{
    visible = true;
    majorMinimum = 0;
    majorMaximum = 1;
    minorSpacing = 0.02;
    majorSpacing = 0.2;
}

// ****************************************************************************
// Method: AxisTickMarks::AxisTickMarks
//
// Purpose: 
//   Copy constructor for the AxisTickMarks class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisTickMarks::AxisTickMarks(const AxisTickMarks &obj) : 
    AttributeSubject(AxisTickMarks::TypeMapFormatString)
{
    visible = obj.visible;
    majorMinimum = obj.majorMinimum;
    majorMaximum = obj.majorMaximum;
    minorSpacing = obj.minorSpacing;
    majorSpacing = obj.majorSpacing;

    SelectAll();
}

// ****************************************************************************
// Method: AxisTickMarks::~AxisTickMarks
//
// Purpose: 
//   Destructor for the AxisTickMarks class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisTickMarks::~AxisTickMarks()
{
    // nothing here
}

// ****************************************************************************
// Method: AxisTickMarks::operator = 
//
// Purpose: 
//   Assignment operator for the AxisTickMarks class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisTickMarks& 
AxisTickMarks::operator = (const AxisTickMarks &obj)
{
    if (this == &obj) return *this;
    visible = obj.visible;
    majorMinimum = obj.majorMinimum;
    majorMaximum = obj.majorMaximum;
    minorSpacing = obj.minorSpacing;
    majorSpacing = obj.majorSpacing;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: AxisTickMarks::operator == 
//
// Purpose: 
//   Comparison operator == for the AxisTickMarks class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisTickMarks::operator == (const AxisTickMarks &obj) const
{
    // Create the return value
    return ((visible == obj.visible) &&
            (majorMinimum == obj.majorMinimum) &&
            (majorMaximum == obj.majorMaximum) &&
            (minorSpacing == obj.minorSpacing) &&
            (majorSpacing == obj.majorSpacing));
}

// ****************************************************************************
// Method: AxisTickMarks::operator != 
//
// Purpose: 
//   Comparison operator != for the AxisTickMarks class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisTickMarks::operator != (const AxisTickMarks &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AxisTickMarks::TypeName
//
// Purpose: 
//   Type name method for the AxisTickMarks class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
AxisTickMarks::TypeName() const
{
    return "AxisTickMarks";
}

// ****************************************************************************
// Method: AxisTickMarks::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AxisTickMarks class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisTickMarks::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AxisTickMarks *tmp = (const AxisTickMarks *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AxisTickMarks::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AxisTickMarks class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AxisTickMarks::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AxisTickMarks(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AxisTickMarks::NewInstance
//
// Purpose: 
//   NewInstance method for the AxisTickMarks class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AxisTickMarks::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AxisTickMarks(*this);
    else
        retval = new AxisTickMarks;

    return retval;
}

// ****************************************************************************
// Method: AxisTickMarks::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AxisTickMarks::SelectAll()
{
    Select(ID_visible,      (void *)&visible);
    Select(ID_majorMinimum, (void *)&majorMinimum);
    Select(ID_majorMaximum, (void *)&majorMaximum);
    Select(ID_minorSpacing, (void *)&minorSpacing);
    Select(ID_majorSpacing, (void *)&majorSpacing);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxisTickMarks::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisTickMarks::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AxisTickMarks defaultObject;
    bool addToParent = false;
    // Create a node for AxisTickMarks.
    DataNode *node = new DataNode("AxisTickMarks");

    if(completeSave || !FieldsEqual(ID_visible, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("visible", visible));
    }

    if(completeSave || !FieldsEqual(ID_majorMinimum, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("majorMinimum", majorMinimum));
    }

    if(completeSave || !FieldsEqual(ID_majorMaximum, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("majorMaximum", majorMaximum));
    }

    if(completeSave || !FieldsEqual(ID_minorSpacing, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minorSpacing", minorSpacing));
    }

    if(completeSave || !FieldsEqual(ID_majorSpacing, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("majorSpacing", majorSpacing));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AxisTickMarks::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AxisTickMarks::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AxisTickMarks");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("visible")) != 0)
        SetVisible(node->AsBool());
    if((node = searchNode->GetNode("majorMinimum")) != 0)
        SetMajorMinimum(node->AsDouble());
    if((node = searchNode->GetNode("majorMaximum")) != 0)
        SetMajorMaximum(node->AsDouble());
    if((node = searchNode->GetNode("minorSpacing")) != 0)
        SetMinorSpacing(node->AsDouble());
    if((node = searchNode->GetNode("majorSpacing")) != 0)
        SetMajorSpacing(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AxisTickMarks::SetVisible(bool visible_)
{
    visible = visible_;
    Select(ID_visible, (void *)&visible);
}

void
AxisTickMarks::SetMajorMinimum(double majorMinimum_)
{
    majorMinimum = majorMinimum_;
    Select(ID_majorMinimum, (void *)&majorMinimum);
}

void
AxisTickMarks::SetMajorMaximum(double majorMaximum_)
{
    majorMaximum = majorMaximum_;
    Select(ID_majorMaximum, (void *)&majorMaximum);
}

void
AxisTickMarks::SetMinorSpacing(double minorSpacing_)
{
    minorSpacing = minorSpacing_;
    Select(ID_minorSpacing, (void *)&minorSpacing);
}

void
AxisTickMarks::SetMajorSpacing(double majorSpacing_)
{
    majorSpacing = majorSpacing_;
    Select(ID_majorSpacing, (void *)&majorSpacing);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
AxisTickMarks::GetVisible() const
{
    return visible;
}

double
AxisTickMarks::GetMajorMinimum() const
{
    return majorMinimum;
}

double
AxisTickMarks::GetMajorMaximum() const
{
    return majorMaximum;
}

double
AxisTickMarks::GetMinorSpacing() const
{
    return minorSpacing;
}

double
AxisTickMarks::GetMajorSpacing() const
{
    return majorSpacing;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxisTickMarks::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AxisTickMarks::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_visible:      return "visible";
    case ID_majorMinimum: return "majorMinimum";
    case ID_majorMaximum: return "majorMaximum";
    case ID_minorSpacing: return "minorSpacing";
    case ID_majorSpacing: return "majorSpacing";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxisTickMarks::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AxisTickMarks::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_visible:      return FieldType_bool;
    case ID_majorMinimum: return FieldType_double;
    case ID_majorMaximum: return FieldType_double;
    case ID_minorSpacing: return FieldType_double;
    case ID_majorSpacing: return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AxisTickMarks::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AxisTickMarks::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_visible:      return "bool";
    case ID_majorMinimum: return "double";
    case ID_majorMaximum: return "double";
    case ID_minorSpacing: return "double";
    case ID_majorSpacing: return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxisTickMarks::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisTickMarks::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AxisTickMarks &obj = *((const AxisTickMarks*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_visible:
        {  // new scope
        retval = (visible == obj.visible);
        }
        break;
    case ID_majorMinimum:
        {  // new scope
        retval = (majorMinimum == obj.majorMinimum);
        }
        break;
    case ID_majorMaximum:
        {  // new scope
        retval = (majorMaximum == obj.majorMaximum);
        }
        break;
    case ID_minorSpacing:
        {  // new scope
        retval = (minorSpacing == obj.minorSpacing);
        }
        break;
    case ID_majorSpacing:
        {  // new scope
        retval = (majorSpacing == obj.majorSpacing);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

