##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_campsite_detect.nasl 3105 2009-06-30 15:33:29Z jun $
#
# Campsite Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900384);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Campsite Version Detection");
  desc = "

  Overview: This script detects the installed version of Campsite and
  sets the result in KB.

  Risk factor:None";

  script_description(desc);
  script_summary("Set KB for the Version of Campsite");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

campsitePort = get_http_port(default:80);
if(!campsitePort){
  campsitePort = 80;
}

if(!get_port_state(campsitePort)){
  exit(0);
}

foreach dir (make_list("/", "/campsite/", "campsite1/implementation/site/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "admin/login.php"), port:campsitePort);
  rcvRes = http_send_recv(port:campsitePort, data:sndReq);
  if("Campsite" >!< rcvRes || "Campware" >!< rcvRes )
  {
    sndReq = http_get(item:string(dir, "/index.php"), port:campsitePort);
    rcvRes = http_send_recv(port:campsitePort, data:sndReq);
  }

  # Check for Campsite and Proper Response
  if("Campsite" >< rcvRes && egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    # For matching the version
    ver = eregmatch(pattern:"Campsite[^?]+(([0-9]\.[0-9]\.[0-9.]+)(.(rc|RC)"+
                            "[0-9])?)", string:rcvRes);
    campsiteVer = ereg_replace(pattern:string("-"), replace:string("."),
                               string:ver[1]);
  }
  if(campsiteVer != NULL)
  {
    set_kb_item(name:"www/"+ campsitePort + "/Campsite",
                value:campsiteVer + " under " + dir);
    security_note(data:"Campsite version " + campsiteVer + 
                 " running at location " + dir +  " was detected on the host");
  }
}
