/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.db;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.turbine.om.BaseObject;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.SecurityObject;
import org.apache.turbine.om.security.TurbineGroup;
import org.apache.turbine.om.security.TurbinePermission;
import org.apache.turbine.om.security.TurbineRole;
import org.apache.turbine.om.security.User;
import org.apache.turbine.om.security.peer.GroupPeer;
import org.apache.turbine.om.security.peer.PermissionPeer;
import org.apache.turbine.om.security.peer.RolePeer;
import org.apache.turbine.om.security.peer.RolePermissionPeer;
import org.apache.turbine.om.security.peer.UserGroupRolePeer;
import org.apache.turbine.om.security.peer.UserPeer;
import org.apache.turbine.services.security.BaseSecurityService;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.security.AccessControlList;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.turbine.util.security.GroupSet;
import org.apache.turbine.util.security.PermissionSet;
import org.apache.turbine.util.security.RoleSet;
import org.apache.turbine.util.security.UnknownEntityException;

public class DBSecurityService
extends BaseSecurityService {
    public static final String USER_PEER_CLASS_KEY = "userPeer.class";
    public static final String USER_PEER_CLASS_DEFAULT = "org.apache.turbine.om.security.peer.TurbineUserPeer";

    public AccessControlList getACL(User user) throws DataBackendException, UnknownEntityException {
        if (!TurbineSecurity.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        try {
            try {
                Hashtable<Group, RoleSet> roles = new Hashtable<Group, RoleSet>();
                Hashtable<Group, PermissionSet> permissions = new Hashtable<Group, PermissionSet>();
                this.lockShared();
                Iterator groupsIterator = this.getAllGroups().elements();
                while (groupsIterator.hasNext()) {
                    Group group = (Group)groupsIterator.next();
                    RoleSet groupRoles = RolePeer.retrieveSet(user, group);
                    roles.put(group, groupRoles);
                    PermissionSet groupPermissions = new PermissionSet();
                    Iterator rolesIterator = groupRoles.elements();
                    while (rolesIterator.hasNext()) {
                        Role role = (Role)rolesIterator.next();
                        PermissionSet rolePermissions = PermissionPeer.retrieveSet(role);
                        groupPermissions.add(rolePermissions);
                    }
                    permissions.put(group, groupPermissions);
                }
                AccessControlList accessControlList = new AccessControlList(roles, permissions);
                Object var3_13 = null;
                this.unlockShared();
                return accessControlList;
            }
            catch (Exception e) {
                throw new DataBackendException("Failed to build ACL for user '" + user.getUserName() + "'", e);
            }
        }
        catch (Throwable throwable) {
            Object var3_14 = null;
            this.unlockShared();
            throw throwable;
        }
    }

    public synchronized void grant(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        boolean groupExists = false;
        boolean roleExists = false;
        try {
            try {
                this.lockExclusive();
                userExists = TurbineSecurity.accountExists(user);
                groupExists = this.checkExists(group);
                roleExists = this.checkExists(role);
                if (userExists && groupExists && roleExists) {
                    Criteria criteria = new Criteria();
                    criteria.add(UserGroupRolePeer.USER_ID, ((BaseObject)((Object)user)).getPrimaryKey());
                    criteria.add(UserGroupRolePeer.GROUP_ID, ((BaseObject)((Object)group)).getPrimaryKey());
                    criteria.add(UserGroupRolePeer.ROLE_ID, ((TurbineRole)role).getPrimaryKey());
                    BasePeer.doInsert(criteria);
                    Object var8_9 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var8_10 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("grant(User,Group,Role) failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.unlockExclusive();
            throw throwable;
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getUserName() + "'");
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + ((SecurityObject)((Object)group)).getName() + "'");
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    public synchronized void revoke(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        boolean groupExists = false;
        boolean roleExists = false;
        try {
            try {
                this.lockExclusive();
                userExists = TurbineSecurity.accountExists(user);
                groupExists = this.checkExists(group);
                roleExists = this.checkExists(role);
                if (userExists && groupExists && roleExists) {
                    Criteria criteria = new Criteria();
                    criteria.add(UserGroupRolePeer.USER_ID, ((BaseObject)((Object)user)).getPrimaryKey());
                    criteria.add(UserGroupRolePeer.GROUP_ID, ((BaseObject)((Object)group)).getPrimaryKey());
                    criteria.add(UserGroupRolePeer.ROLE_ID, ((TurbineRole)role).getPrimaryKey());
                    BasePeer.doDelete(criteria);
                    Object var8_9 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var8_10 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("revoke(User,Role,Group) failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.unlockExclusive();
            throw throwable;
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getUserName() + "'");
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + ((SecurityObject)((Object)group)).getName() + "'");
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    public synchronized void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        try {
            try {
                this.lockExclusive();
                userExists = TurbineSecurity.accountExists(user);
                if (userExists) {
                    int id = ((BaseObject)((Object)user)).getPrimaryKeyAsInt();
                    BasePeer.deleteAll(UserGroupRolePeer.TABLE_NAME, UserGroupRolePeer.USER_ID, id);
                    Object var4_5 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var4_6 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("revokeAll(User) failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown user '" + user.getUserName() + "'");
    }

    public synchronized void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        boolean permissionExists = false;
        try {
            try {
                this.lockExclusive();
                roleExists = this.checkExists(role);
                permissionExists = this.checkExists(permission);
                if (roleExists && permissionExists) {
                    Criteria criteria = new Criteria();
                    criteria.add(RolePermissionPeer.ROLE_ID, ((TurbineRole)role).getPrimaryKey());
                    criteria.add(RolePermissionPeer.PERMISSION_ID, ((BaseObject)((Object)permission)).getPrimaryKey());
                    BasePeer.doInsert(criteria);
                    Object var6_7 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var6_8 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("grant(Role,Permission) failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.unlockExclusive();
            throw throwable;
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + ((SecurityObject)((Object)permission)).getName() + "'");
        }
    }

    public synchronized void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        boolean permissionExists = false;
        try {
            try {
                this.lockExclusive();
                roleExists = this.checkExists(role);
                permissionExists = this.checkExists(permission);
                if (roleExists && permissionExists) {
                    Criteria criteria = new Criteria();
                    criteria.add(RolePermissionPeer.ROLE_ID, ((TurbineRole)role).getPrimaryKey());
                    criteria.add(RolePermissionPeer.PERMISSION_ID, ((BaseObject)((Object)permission)).getPrimaryKey());
                    BasePeer.doDelete(criteria);
                    Object var6_7 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var6_8 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("revoke(Role,Permission) failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.unlockExclusive();
            throw throwable;
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + ((SecurityObject)((Object)permission)).getName() + "'");
        }
    }

    public synchronized void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            try {
                this.lockExclusive();
                roleExists = this.checkExists(role);
                if (roleExists) {
                    int id = ((TurbineRole)role).getPrimaryKeyAsInt();
                    BasePeer.deleteAll(RolePermissionPeer.TABLE_NAME, RolePermissionPeer.ROLE_ID, id);
                    Object var4_5 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var4_6 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("revokeAll(Role) failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
    }

    public GroupSet getGroups(Criteria criteria) throws DataBackendException {
        Criteria dbCriteria = new Criteria();
        Iterator keys = criteria.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            dbCriteria.put(GroupPeer.getColumnName(key), criteria.get(key));
        }
        Vector groups = new Vector(0);
        try {
            groups = GroupPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("getGroups(Criteria) failed", e);
        }
        return new GroupSet(groups);
    }

    public RoleSet getRoles(Criteria criteria) throws DataBackendException {
        Criteria dbCriteria = new Criteria();
        Iterator keys = criteria.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            dbCriteria.put(RolePeer.getColumnName(key), criteria.get(key));
        }
        Vector roles = new Vector(0);
        try {
            roles = RolePeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("getRoles(Criteria) failed", e);
        }
        return new RoleSet(roles);
    }

    public PermissionSet getPermissions(Criteria criteria) throws DataBackendException {
        Criteria dbCriteria = new Criteria();
        Iterator keys = criteria.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            dbCriteria.put(PermissionPeer.getColumnName(key), criteria.get(key));
        }
        Vector permissions = new Vector(0);
        try {
            permissions = PermissionPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("getPermissions(Criteria) failed", e);
        }
        return new PermissionSet(permissions);
    }

    public PermissionSet getPermissions(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            try {
                this.lockShared();
                roleExists = this.checkExists(role);
                if (roleExists) {
                    PermissionSet permissionSet = PermissionPeer.retrieveSet(role);
                    Object var4_4 = null;
                    this.unlockShared();
                    return permissionSet;
                }
                Object var4_5 = null;
                this.unlockShared();
            }
            catch (Exception e) {
                throw new DataBackendException("getPermissions(Role) failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.unlockShared();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
    }

    public void saveGroup(Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        try {
            groupExists = this.checkExists(group);
            if (groupExists) {
                Criteria criteria = GroupPeer.buildCriteria(group);
                GroupPeer.doUpdate(criteria);
            }
        }
        catch (Exception e) {
            throw new DataBackendException("saveGroup(Group) failed", e);
        }
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    public void saveRole(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            roleExists = this.checkExists(role);
            if (roleExists) {
                Criteria criteria = RolePeer.buildCriteria(role);
                RolePeer.doUpdate(criteria);
            }
        }
        catch (Exception e) {
            throw new DataBackendException("saveRole(Role) failed", e);
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    public void savePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        try {
            permissionExists = this.checkExists(permission);
            if (permissionExists) {
                Criteria criteria = PermissionPeer.buildCriteria(permission);
                PermissionPeer.doUpdate(criteria);
            }
        }
        catch (Exception e) {
            throw new DataBackendException("savePermission(Permission) failed", e);
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    public Group getNewGroup(String groupName) {
        return new TurbineGroup(groupName);
    }

    public Role getNewRole(String roleName) {
        return new TurbineRole(roleName);
    }

    public Permission getNewPermission(String permissionName) {
        return new TurbinePermission(permissionName);
    }

    public synchronized Group addGroup(Group group) throws DataBackendException, EntityExistsException {
        boolean groupExists = false;
        try {
            try {
                this.lockExclusive();
                groupExists = this.checkExists(group);
                if (!groupExists) {
                    Criteria criteria = GroupPeer.buildCriteria(group);
                    BasePeer.doInsert(criteria);
                    criteria = new Criteria();
                    criteria.add(GroupPeer.NAME, ((SecurityObject)((Object)group)).getName());
                    Vector results = GroupPeer.doSelect(criteria);
                    if (results.size() != 1) {
                        throw new DataBackendException("Internal error - query returned " + results.size() + " rows");
                    }
                    Group newGroup = (Group)results.get(0);
                    this.getAllGroups().add(newGroup);
                    Group group2 = newGroup;
                    Object var4_8 = null;
                    this.unlockExclusive();
                    return group2;
                }
                Object var4_9 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("addGroup(Group) failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new EntityExistsException("Group '" + group + "' already exists");
    }

    public synchronized Role addRole(Role role) throws DataBackendException, EntityExistsException {
        boolean roleExists = false;
        try {
            try {
                this.lockExclusive();
                roleExists = this.checkExists(role);
                if (!roleExists) {
                    Criteria criteria = RolePeer.buildCriteria(role);
                    BasePeer.doInsert(criteria);
                    criteria = new Criteria();
                    criteria.add(RolePeer.NAME, role.getName());
                    Vector results = RolePeer.doSelect(criteria);
                    if (results.size() != 1) {
                        throw new DataBackendException("Internal error - query returned " + results.size() + " rows");
                    }
                    Role newRole = (Role)results.get(0);
                    this.getAllRoles().add(newRole);
                    Role role2 = newRole;
                    Object var4_8 = null;
                    this.unlockExclusive();
                    return role2;
                }
                Object var4_9 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("addRole(Role) failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new EntityExistsException("Role '" + role + "' already exists");
    }

    public synchronized Permission addPermission(Permission permission) throws DataBackendException, EntityExistsException {
        boolean permissionExists = false;
        try {
            try {
                this.lockExclusive();
                permissionExists = this.checkExists(permission);
                if (!permissionExists) {
                    Criteria criteria = PermissionPeer.buildCriteria(permission);
                    BasePeer.doInsert(criteria);
                    criteria = new Criteria();
                    criteria.add(PermissionPeer.NAME, ((SecurityObject)((Object)permission)).getName());
                    Vector results = PermissionPeer.doSelect(criteria);
                    if (results.size() != 1) {
                        throw new DataBackendException("Internal error - query returned " + results.size() + " rows");
                    }
                    Permission newPermission = (Permission)results.get(0);
                    this.getAllPermissions().add(newPermission);
                    Permission permission2 = newPermission;
                    Object var4_8 = null;
                    this.unlockExclusive();
                    return permission2;
                }
                Object var4_9 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("addPermission(Permission) failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new EntityExistsException("Permission '" + permission + "' already exists");
    }

    public synchronized void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        try {
            try {
                this.lockExclusive();
                groupExists = this.checkExists(group);
                if (groupExists) {
                    Criteria criteria = GroupPeer.buildCriteria(group);
                    BasePeer.doDelete(criteria);
                    this.getAllGroups().remove(group);
                    Object var4_5 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var4_6 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                Log.error("Failed to delete a Group");
                Log.error(e);
                throw new DataBackendException("removeGroup(Group) failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    public synchronized void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            try {
                this.lockExclusive();
                roleExists = this.checkExists(role);
                if (roleExists) {
                    this.revokeAll(role);
                    Criteria criteria = RolePeer.buildCriteria(role);
                    BasePeer.doDelete(criteria);
                    this.getAllRoles().remove(role);
                    Object var4_5 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var4_6 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("removeRole(Role)", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    public synchronized void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        try {
            try {
                this.lockExclusive();
                permissionExists = this.checkExists(permission);
                if (permissionExists) {
                    Criteria criteria = PermissionPeer.buildCriteria(permission);
                    BasePeer.doDelete(criteria);
                    this.getAllPermissions().remove(permission);
                    Object var4_5 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var4_6 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("removePermission(Permission)", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    public synchronized void renameGroup(Group group, String name) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        try {
            try {
                this.lockExclusive();
                groupExists = this.checkExists(group);
                if (groupExists) {
                    ((SecurityObject)((Object)group)).setName(name);
                    Criteria criteria = GroupPeer.buildCriteria(group);
                    GroupPeer.doUpdate(criteria);
                    Object var5_6 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var5_7 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("renameGroup(Group,String)", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    public synchronized void renameRole(Role role, String name) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            try {
                this.lockExclusive();
                roleExists = this.checkExists(role);
                if (roleExists) {
                    role.setName(name);
                    Criteria criteria = RolePeer.buildCriteria(role);
                    RolePeer.doUpdate(criteria);
                    Object var5_6 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var5_7 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("renameRole(Role,String)", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    public synchronized void renamePermission(Permission permission, String name) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        try {
            try {
                this.lockExclusive();
                permissionExists = this.checkExists(permission);
                if (permissionExists) {
                    ((SecurityObject)((Object)permission)).setName(name);
                    Criteria criteria = PermissionPeer.buildCriteria(permission);
                    PermissionPeer.doUpdate(criteria);
                    Object var5_6 = null;
                    this.unlockExclusive();
                    return;
                }
                Object var5_7 = null;
                this.unlockExclusive();
            }
            catch (Exception e) {
                throw new DataBackendException("renamePermission(Permission,name)", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.unlockExclusive();
            throw throwable;
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    public Class getUserPeerClass() throws UnknownEntityException {
        String userPeerClassName = this.getProperties().getProperty(USER_PEER_CLASS_KEY, USER_PEER_CLASS_DEFAULT);
        try {
            return Class.forName(userPeerClassName);
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed create a Class object for UserPeer implementation", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public UserPeer getUserPeerInstance() throws UnknownEntityException {
        void up;
        try {
            UserPeer userPeer = (UserPeer)this.getUserPeerClass().newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed instantiate an UserPeer implementation object", e);
        }
        return up;
    }

    protected boolean checkExists(Group group) throws DataBackendException, Exception {
        return GroupPeer.checkExists(group);
    }

    protected boolean checkExists(Role role) throws DataBackendException, Exception {
        return RolePeer.checkExists(role);
    }

    protected boolean checkExists(Permission permission) throws DataBackendException, Exception {
        return PermissionPeer.checkExists(permission);
    }
}

