C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_p91.F 
C> The nwxcm_c_p91 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_p91 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_4} &=& 1.0-{\it t_2}\,{\it t_3}\\\\ 
C>   {\it t_5} &=& {\it t_2}\,{\it t_3}+1.0\\\\ 
C>   {\it t_6} &=& 0.5\,{\it t_5}^{{{2}\over{3}}}+0.5\,{
C>    \it t_4}^{{{2}\over{3}}}\\\\ 
C>   {\it t_7} &=& {\it t_6}^{3.0}\\\\ 
C>   {\it t_8} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_6}^{2.0}}}\\\\ 
C>   {\it t_{10}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{11}} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{13}} &=& 0.1325688999052018\,{\it t_{12}}+1.0\\\\ 
C>   {\it t_{14}} &=& \sqrt{{\it t_{11}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{14}}}}\\\\ 
C>   {\it t_{16}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{14}}}\over{0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.02414199311453321\,{\it t_{15}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{17}} &=& 0.06901399211255826\,{\it t_{12}}+1.0\\\\ 
C>   {\it t_{18}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{14}}}\over{0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.01321299881039884\,{\it t_{15}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{19}} &=& {{1}\over{e^{{{40.42761511756372\,
C>    \left(0.5848223622634648\,\left(1.923661050931536\,{
C>    \it t_5}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_4}^{{{4}\over{3}}}-3.847322101863072\right)\,\left({{{
C>    \it t_2}^4\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_{13}}\,{\it t_{16}}-0.0310907\,\left(0.1274696188700087
C>    \,{\it t_{12}}+1.0\right)\,\log \left({{1.269642451250142\,{
C>    \it t_{14}}}\over{0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.01530901310039024\,{\it t_{15}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{17}}\,{\it t_{18}}\right)}\over{{
C>    \it t_1}^4}}+0.0337738\,{\it t_{17}}\,{\it t_{18}}\right)
C>    -0.0621814\,{\it t_{13}}\,{\it t_{16}}\right)}\over{{
C>    \it t_7}}}}}}-1.0\\\\ 
C>   {\it t_{20}} &=& {{0.1712109500228822\,{\it t_8}\,{\it t_9}
C>    \,{\it t_{10}}}\over{{\it t_{19}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{22}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{23}} &=& \sqrt{{\it t_{22}}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_{23}}}}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{{\it t_{22}}}}\\\\ 
C>   {\it t_{26}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{24}}+0.10186556948\right)
C>    \,{\it t_{24}}+0.22308199064\right)\,{\it t_{24}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{27}} &=& 0.1325688999052018\,{\it t_{25}}+1.0\\\\ 
C>   {\it t_{28}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{24}}
C>    +0.029729725188\right)\,{\it t_{24}}+0.12236585478\right)\,{
C>    \it t_{24}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{29}} &=& 0.06901399211255826\,{\it t_{25}}+1.0\\\\ 
C>   {\it t_{30}} &=& {{1}\over{e^{80.85523023512745\,
C>    \left(0.5848223622634643\,\left(0.0337738\,{\it t_{28}}\,{
C>    \it t_{29}}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_{26}}\,{\it t_{27}}-0.0310907\,\log 
C>    \left({{1.269642451250142\,{\it t_{23}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{24}}+0.10465751434\right)
C>    \,{\it t_{24}}+0.19269083139\right)\,{\it t_{24}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{25}}+1.0\right)\right)-0.0337738\,{\it t_{28}}\,{
C>    \it t_{29}}\right)\right)-0.0621814\,{\it t_{26}}\,{
C>    \it t_{27}}\right)}}}-1.0\\\\ 
C>   {\it t_{31}} &=& {{0.2717804421747981\,{\it t_{21}}\,
C>    \sigma_{ss}}\over{{\it t_{30}}}}\\\\ 
C>   f &=& 0.02473556743557577\,{\it t_1}\,{\it t_7}\,\log 
C>    \left({{0.1712109500228822\,{\it t_8}\,{\it t_9}\,{\it t_{10}}
C>    \,\left({\it t_{20}}+1.0\right)}\over{{{0.02931318940773787
C>    \,\left({\it t_8}\,{\it t_{10}}\right)^{2.0}}\over{{
C>    \it t_6}^{4.0}\,{\it t_{19}}^{2.0}}}+{\it t_{20}}+1.0}}
C>    +1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.01236778371778788\,\rho_s\,\log 
C>    \left({{0.2717804421747981\,{\it t_{21}}\,\sigma_{ss}\,
C>    \left({\it t_{31}}+1.0\right)}\over{{{0.0738646087487288
C>    \,\left({\it t_{21}}\,\sigma_{ss}\right)^{2.0}}\over{{
C>    \it t_{30}}^{2.0}}}+{\it t_{31}}+1.0}}+1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] JP Perdew, JA Chevary, SH Vosko, KA Jackson, MR Pederson
C>    , DJ Singh, C. Fiolhais, Phys.Rev. B 46, 6671 (1992)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/jp050536c "> 
C> 10.1021/jp050536c </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_p91(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Cmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = exp(2.5138457066712766d+0*log(1.4251254664507676d+0*t4/
     1         (7.016926042943223d-1*t5*(7.016926042943223d-1*(2.1508070
     2         71909054d-2*t5+1.0186556948d-1)*t5+2.2308199064d-1)+4.723
     3         1125998d-1)+1.0d+0)*(1.0522000558389215d-1*t6+1.0d+0))-1.
     4         0d+0
            t8 = 1.35890221087399d-1*gammaaa*t2/t7
            t9 = (gammaaa*t2)**2.0d+0
            t10 = 2.1508070719090538d-2*t5+1.0186556948d-1
            t11 = 7.016926042943222d-1*t10*t5+2.2308199064d-1
            t12 = 7.016926042943222d-1*t11*t5+4.7231125998d-1
            t13 = 1/t12
            t14 = 1.425125466450768d+0*t13*t4+1.0d+0
            t15 = log(t14)
            t16 = 1.0522000558389213d-1*t6+1.0d+0
            t17 = exp(2.5138457066712766d+0*t15*t16)
            t18 = t17-1.0d+0
            t19 = 1/t18
            t20 = 1.3589022108739904d-1*gammaaa*t19*t2
            t21 = t20+1.0d+0
            t22 = 1/t18**2.0d+0
            t23 = 1.8466152187182186d-2*t22*t9+t20+1.0d+0
            t24 = 1/t23
            t25 = 1.3589022108739904d-1*gammaaa*t2*t21*t24+1.0d+0
            t26 = 1/t25
            t27 = rhoa**1.6666666666666674d-1
            t28 = 1/t1**3.0d+0
            t29 = -1.585385912686322d-1*gammaaa*t19*t27*t28
            t30 = 1/t4**3
            t31 = 1/rhoa**6.666666666666667d-1
            t32 = 1.090454542535705d-3*t15/rhoa**1.3333333333333333d+0-6
     1         .21814d-2*t16*(1.1876045553756398d-1*t13*t31*t5-1.4251254
     2         66450768d+0*t4*(7.016926042943222d-1*(-5.847438369119352d
     3         -2*t10*t30*t31-1.2576711796854242d-3/rhoa**1.333333333333
     4         3336d+0)*t5-5.847438369119352d-2*t11*t30*t31)/t12**2)/t14
            t33 = 5.493717556362009d+0*gammaaa*t17*t2*t32/t18**2
            t34 = 1/t23**2
            t35 = 1/t1**4.0d+0
            fnc(iq) = 4.947113487115154d-2*rhoa*log(1.35890221087399d-1*
     1         gammaaa*t2*(t8+1.0d+0)/(1.8466152187182178d-2*t9/t7**2.0d
     2         +0+t8+1.0d+0)+1.0d+0)*wght+fnc(iq)
            Amat(iq,D1_RA) = 4.947113487115154d-2*rhoa*t26*(-1.358902210
     1         8739904d-1*gammaaa*t2*t21*t34*(1.4930849866515178d+0*t17*
     2         t32*t9/t18**3.0d+0+t33+t29-4.308768843675843d-2*gammaaa**
     3         2*t22*t27/t1**5.0d+0)+1.3589022108739904d-1*gammaaa*t2*t2
     4         4*(t33+t29)-1.585385912686322d-1*gammaaa*t21*t24*t27*t28)
     5         *wght+2.473556743557577d-2*log(t25)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 4.947113487115154d-2*rhoa*t26*(-1.35890221
     1         08739904d-1*gammaaa*t2*t21*t34*(9.233076093591093d-3*gamm
     2         aaa*t22*t35+3.397255527184976d-2*t19*t2)+4.61653804679554
     3         64d-3*gammaaa*t19*t24*t35+3.397255527184976d-2*t2*t21*t24
     4         )*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 4.947113487115154d-2*rhoa*t26*(-1.35890221
     1         08739904d-1*gammaaa*t2*t21*t34*(1.8466152187182186d-2*gam
     2         maaa*t22*t35+6.794511054369952d-2*t19*t2)+9.2330760935910
     3         93d-3*gammaaa*t19*t24*t35+6.794511054369952d-2*t2*t21*t24
     4         )*wght+Cmat(iq,D1_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = rhoa-rhob
            t3 = 1/t1
            t4 = 1.0d+0-t2*t3
            t5 = t2*t3+1.0d+0
            t6 = 5.0d-1*t5**6.666666666666666d-1+5.0d-1*t4**6.6666666666
     1         66666d-1
            t7 = t6**3.0d+0
            t8 = gammabb+2.0d+0*gammaab+gammaaa
            t9 = t1**1.1666666666666667d+0
            t10 = 1/t9**2.0d+0
            t11 = t6**2.0d+0
            t12 = 1/t11
            t13 = 1/t7
            t14 = t1**3.333333333333333d-1
            t15 = 1/t14
            t16 = 1.325688999052018d-1*t15+1.0d+0
            t17 = t14**5.0d-1
            t18 = 1/t17
            t19 = 2.4141993114533214d-2*t18+1.0186556948d-1
            t20 = 7.876233178997433d-1*t18*t19+2.2308199064d-1
            t21 = 7.876233178997433d-1*t18*t20+4.7231125998d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t17*t22+1.0d+0
            t24 = log(t23)
            t25 = 1.923661050931536d+0*t5**1.3333333333333333d+0+1.92366
     1         1050931536d+0*t4**1.3333333333333333d+0-3.847322101863072
     2         d+0
            t26 = 6.901399211255826d-2*t15+1.0d+0
            t27 = 1.3212998810398843d-2*t18+2.9729725188d-2
            t28 = 7.876233178997433d-1*t18*t27+1.2236585478d-1
            t29 = 7.876233178997433d-1*t18*t28+3.497952466d-1
            t30 = 1/t29
            t31 = 1.269642451250142d+0*t17*t30+1.0d+0
            t32 = log(t31)
            t33 = t2**4
            t34 = 1/t1**4
            t35 = 1.2746961887000874d-1*t15+1.0d+0
            t36 = 1.530901310039024d-2*t18+1.0465751434d-1
            t37 = 7.876233178997433d-1*t18*t36+1.9269083139d-1
            t38 = 7.876233178997433d-1*t18*t37+4.3896648423d-1
            t39 = 1/t38
            t40 = 1.269642451250142d+0*t17*t39+1.0d+0
            t41 = log(t40)
            t42 = 1.709920934161365d+0*(6.21814d-2*t16*t24-3.10907d-2*t3
     1         5*t41)-3.37738d-2*t26*t32
            t43 = t33*t34*t42+3.37738d-2*t26*t32
            t44 = 5.848223622634648d-1*t25*t43-6.21814d-2*t16*t24
            t45 = exp(-4.042761511756372d+1*t13*t44)
            t46 = t45-1.0d+0
            t47 = 1/t46
            t48 = 1.7121095002288222d-1*t10*t12*t47*t8
            t49 = t48+1.0d+0
            t50 = 1/t6**4.0d+0
            t51 = (t10*t8)**2.0d+0
            t52 = 1/t46**2.0d+0
            t53 = 2.931318940773787d-2*t50*t51*t52+t48+1.0d+0
            t54 = 1/t53
            t55 = 1.7121095002288222d-1*t10*t12*t49*t54*t8+1.0d+0
            t56 = log(t55)
            t57 = 1/t55
            t58 = 1/t1**2
            t59 = t2*t58
            t60 = -t3
            t61 = t60+t59
            t62 = t4**3.333333333333333d-1
            t63 = 1/t62
            t64 = -t2*t58
            t65 = t64+t3
            t66 = t5**3.333333333333333d-1
            t67 = 1/t66
            t68 = 3.333333333333333d-1*t65*t67+3.333333333333333d-1*t61*
     1         t63
            t69 = t1**1.6666666666666674d-1
            t70 = 1/t9**3.0d+0
            t71 = -3.994922167200585d-1*t12*t49*t54*t69*t70*t8
            t72 = -3.4242190004576445d-1*t10*t13*t47*t68*t8
            t73 = -3.994922167200585d-1*t12*t47*t69*t70*t8
            t74 = 1/t46**2
            t75 = 1/t1**1.3333333333333336d+0
            t76 = 1/t1**6.666666666666667d-1
            t77 = 1/t17**3
            t78 = 2.11607075208357d-1*t18*t22*t76-1.269642451250142d+0*t
     1         17*(7.876233178997433d-1*t18*(-1.3127055298329054d-1*t19*
     2         t76*t77-3.169132786263567d-3*t75)-1.3127055298329054d-1*t
     3         20*t76*t77)/t21**2
            t79 = 1/t23
            t80 = -6.21814d-2*t16*t78*t79
            t81 = 1/t1**1.3333333333333333d+0
            t82 = 2.747773264188438d-3*t24*t81
            t83 = 2.11607075208357d-1*t18*t30*t76-1.269642451250142d+0*t
     1         17*(7.876233178997433d-1*t18*(-1.3127055298329054d-1*t27*
     2         t76*t77-1.7344776604086162d-3*t75)-1.3127055298329054d-1*
     3         t28*t76*t77)/t29**2
            t84 = 1/t31
            t85 = 3.37738d-2*t26*t83*t84
            t86 = -7.769549222703733d-4*t32*t81
            t87 = t33*t34*(-3.37738d-2*t26*t83*t84+1.709920934161365d+0*
     1         (1.3210398931339265d-3*t41*t81-2.747773264188438d-3*t24*t
     2         81+6.21814d-2*t16*t78*t79-3.10907d-2*t35*(2.1160707520835
     3         7d-1*t18*t39*t76-1.269642451250142d+0*t17*(7.876233178997
     4         433d-1*t18*(-1.3127055298329054d-1*t36*t76*t77-2.00962261
     5         53166658d-3*t75)-1.3127055298329054d-1*t37*t76*t77)/t38**
     6         2)/t40)+7.769549222703733d-4*t32*t81)
            t88 = -4*t33*t42/t1**5
            t89 = t2**3
            t90 = 1.2128284535269115d+2*t44*t50*t68-4.042761511756372d+1
     1         *t13*(5.848223622634648d-1*t25*(4*t34*t42*t89+t88+t87+t86
     2         +t85)+t82+t80+5.848223622634648d-1*t43*(2.564881401242048
     3         d+0*t65*t66+2.564881401242048d+0*t61*t62))
            t91 = -1.7121095002288222d-1*t10*t12*t45*t74*t8*t90
            t92 = 1/t53**2
            t93 = -1.3679488390277675d-1*t50*t52*t69*t8**2/t9**5.0d+0
            t94 = 1/t6**5.0d+0
            t95 = 1/t46**3.0d+0
            t96 = 2.473556743557577d-2*t56*t7*wght
            t97 = t59+t3
            t98 = t64+t60
            t99 = 3.333333333333333d-1*t67*t98+3.333333333333333d-1*t63*
     1         t97
            t100 = -3.4242190004576445d-1*t10*t13*t47*t8*t99
            t101 = 1.2128284535269115d+2*t44*t50*t99-4.042761511756372d+
     1         1*t13*(5.848223622634648d-1*t43*(2.564881401242048d+0*t66
     2         *t98+2.564881401242048d+0*t62*t97)+5.848223622634648d-1*t
     3         25*(-4*t34*t42*t89+t88+t87+t86+t85)+t82+t80)
            t102 = -1.7121095002288222d-1*t10*t101*t12*t45*t74*t8
            t103 = 1/t9**4.0d+0
            t104 = 2.473556743557577d-2*t1*t57*t7*(-1.7121095002288222d-
     1         1*t10*t12*t49*t8*(5.862637881547574d-2*t103*t50*t52*t8+1.
     2         7121095002288222d-1*t10*t12*t47)*t92+2.931318940773787d-2
     3         *t103*t47*t50*t54*t8+1.7121095002288222d-1*t10*t12*t49*t5
     4         4)*wght
            fnc(iq) = 2.473556743557577d-2*t1*t56*t7*wght+fnc(iq)
            Amat(iq,D1_RA) = 2.473556743557577d-2*t1*t57*t7*(-1.71210950
     1         02288222d-1*t10*t12*t49*t8*t92*(-5.862637881547574d-2*t45
     2         *t50*t51*t90*t95-1.172527576309515d-1*t51*t52*t68*t94+t93
     3         +t91+t73+t72)+1.7121095002288222d-1*t10*t12*t54*t8*(t91+t
     4         73+t72)-3.4242190004576445d-1*t10*t13*t49*t54*t68*t8+t71)
     5         *wght+7.420670230672731d-2*t1*t11*t56*t68*wght+t96+Amat(i
     6         q,D1_RA)
            Amat(iq,D1_RB) = 2.473556743557577d-2*t1*t57*t7*(-1.71210950
     1         02288222d-1*t10*t12*t49*t8*t92*(-1.172527576309515d-1*t51
     2         *t52*t94*t99-5.862637881547574d-2*t101*t45*t50*t51*t95+t9
     3         3+t73+t102+t100)-3.4242190004576445d-1*t10*t13*t49*t54*t8
     4         *t99+1.7121095002288222d-1*t10*t12*t54*(t73+t102+t100)*t8
     5         +t71)*wght+7.420670230672731d-2*t1*t11*t56*t99*wght+t96+A
     6         mat(iq,D1_RB)
            Cmat(iq,D1_GAA) = t104+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 2.473556743557577d-2*t1*t57*t7*(-1.7121095
     1         002288222d-1*t10*t12*t49*t8*(1.172527576309515d-1*t103*t5
     2         0*t52*t8+3.4242190004576445d-1*t10*t12*t47)*t92+5.8626378
     3         81547574d-2*t103*t47*t50*t54*t8+3.4242190004576445d-1*t10
     4         *t12*t49*t54)*wght+Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t104+Cmat(iq,D1_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1.530901310039024d-2*t5+1.0465751434d-1
            t7 = 7.876233178997433d-1*t5*t6+1.9269083139d-1
            t8 = 7.876233178997433d-1*t5*t7+4.3896648423d-1
            t9 = 1/t8
            t10 = 1.269642451250142d+0*t4*t9+1.0d+0
            t11 = log(t10)
            t12 = 1/t3
            t13 = 1.2746961887000874d-1*t12+1.0d+0
            t14 = 2.4141993114533214d-2*t5+1.0186556948d-1
            t15 = 7.876233178997433d-1*t14*t5+2.2308199064d-1
            t16 = 7.876233178997433d-1*t15*t5+4.7231125998d-1
            t17 = 1/t16
            t18 = 1.269642451250142d+0*t17*t4+1.0d+0
            t19 = log(t18)
            t20 = 1.325688999052018d-1*t12+1.0d+0
            t21 = 1.3212998810398843d-2*t5+2.9729725188d-2
            t22 = 7.876233178997433d-1*t21*t5+1.2236585478d-1
            t23 = 7.876233178997433d-1*t22*t5+3.497952466d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t24*t4+1.0d+0
            t26 = log(t25)
            t27 = 6.901399211255826d-2*t12+1.0d+0
            t28 = exp(-8.085523023512745d+1*(5.848223622634643d-1*(1.0d+
     1         0*(1.709920934161365d+0*(6.21814d-2*t19*t20-3.10907d-2*t1
     2         1*t13)-3.37738d-2*t26*t27)+3.37738d-2*t26*t27)-6.21814d-2
     3         *t19*t20))
            t29 = t28-1.0d+0
            t30 = 1/t29
            t31 = 2.7178044217479813d-1*gammaaa*t2*t30
            t32 = t31+1.0d+0
            t33 = (gammaaa*t2)**2.0d+0
            t34 = 1/t29**2.0d+0
            t35 = 7.38646087487288d-2*t33*t34+t31+1.0d+0
            t36 = 1/t35
            t37 = 2.7178044217479813d-1*gammaaa*t2*t32*t36+1.0d+0
            t38 = log(t37)
            t39 = 1/t37
            t40 = rhoa**1.6666666666666674d-1
            t41 = 1/t1**3.0d+0
            t42 = -6.34154365074529d-1*gammaaa*t30*t40*t41
            t43 = 1/rhoa**1.3333333333333333d+0
            t44 = 1/rhoa**1.3333333333333336d+0
            t45 = 1/t4**3
            t46 = 1/rhoa**6.666666666666667d-1
            t47 = 1/t18
            t48 = 2.11607075208357d-1*t17*t46*t5-1.269642451250142d+0*t4
     1         *(7.876233178997433d-1*(-1.3127055298329054d-1*t14*t45*t4
     2         6-3.169132786263567d-3*t44)*t5-1.3127055298329054d-1*t15*
     3         t45*t46)/t16**2
            t49 = 1/t25
            t50 = 2.11607075208357d-1*t24*t46*t5-1.269642451250142d+0*t4
     1         *(7.876233178997433d-1*(-1.3127055298329054d-1*t21*t45*t4
     2         6-1.7344776604086162d-3*t44)*t5-1.3127055298329054d-1*t22
     3         *t45*t46)/t23**2
            t51 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-3
     1         .10907d-2*t13*(2.11607075208357d-1*t46*t5*t9-1.2696424512
     2         50142d+0*t4*(7.876233178997433d-1*t5*(-1.3127055298329054
     3         d-1*t45*t46*t6-2.0096226153166658d-3*t44)-1.3127055298329
     4         054d-1*t45*t46*t7)/t8**2)/t10+6.21814d-2*t20*t47*t48-2.74
     5         7773264188438d-3*t19*t43+1.3210398931339265d-3*t11*t43)-3
     6         .37738d-2*t27*t49*t50+7.769549222703733d-4*t26*t43)+3.377
     7         38d-2*t27*t49*t50-7.769549222703733d-4*t26*t43)-6.21814d-
     8         2*t20*t47*t48+2.747773264188438d-3*t19*t43
            t52 = 2.1974870225448048d+1*gammaaa*t2*t28*t51/t29**2
            t53 = 1/t35**2
            t54 = 1/t1**4.0d+0
            fnc(iq) = 1.2367783717787881d-2*rhoa*t38*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.2367783717787881d-2*rhoa*t39*(-2.71780442
     1         17479813d-1*gammaaa*t2*t32*(t52+1.1944679893212153d+1*t28
     2         *t33*t51/t29**3.0d+0+t42-3.4470150749406775d-1*gammaaa**2
     3         *t34*t40/t1**5.0d+0)*t53+2.7178044217479813d-1*gammaaa*t2
     4         *t36*(t52+t42)-6.34154365074529d-1*gammaaa*t32*t36*t40*t4
     5         1)*wght+1.2367783717787881d-2*t38*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.2367783717787881d-2*rhoa*t39*(-2.7178044
     1         217479813d-1*gammaaa*t2*t32*t53*(1.477292174974576d-1*gam
     2         maaa*t34*t54+2.7178044217479813d-1*t2*t30)+7.386460874872
     3         879d-2*gammaaa*t30*t36*t54+2.7178044217479813d-1*t2*t32*t
     4         36)*wght+Cmat(iq,D1_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhob**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1.530901310039024d-2*t5+1.0465751434d-1
            t7 = 7.876233178997433d-1*t5*t6+1.9269083139d-1
            t8 = 7.876233178997433d-1*t5*t7+4.3896648423d-1
            t9 = 1/t8
            t10 = 1.269642451250142d+0*t4*t9+1.0d+0
            t11 = log(t10)
            t12 = 1/t3
            t13 = 1.2746961887000874d-1*t12+1.0d+0
            t14 = 2.4141993114533214d-2*t5+1.0186556948d-1
            t15 = 7.876233178997433d-1*t14*t5+2.2308199064d-1
            t16 = 7.876233178997433d-1*t15*t5+4.7231125998d-1
            t17 = 1/t16
            t18 = 1.269642451250142d+0*t17*t4+1.0d+0
            t19 = log(t18)
            t20 = 1.325688999052018d-1*t12+1.0d+0
            t21 = 1.3212998810398843d-2*t5+2.9729725188d-2
            t22 = 7.876233178997433d-1*t21*t5+1.2236585478d-1
            t23 = 7.876233178997433d-1*t22*t5+3.497952466d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t24*t4+1.0d+0
            t26 = log(t25)
            t27 = 6.901399211255826d-2*t12+1.0d+0
            t28 = exp(-8.085523023512745d+1*(5.848223622634643d-1*(1.0d+
     1         0*(1.709920934161365d+0*(6.21814d-2*t19*t20-3.10907d-2*t1
     2         1*t13)-3.37738d-2*t26*t27)+3.37738d-2*t26*t27)-6.21814d-2
     3         *t19*t20))
            t29 = t28-1.0d+0
            t30 = 1/t29
            t31 = 2.7178044217479813d-1*gammabb*t2*t30
            t32 = t31+1.0d+0
            t33 = (gammabb*t2)**2.0d+0
            t34 = 1/t29**2.0d+0
            t35 = 7.38646087487288d-2*t33*t34+t31+1.0d+0
            t36 = 1/t35
            t37 = 2.7178044217479813d-1*gammabb*t2*t32*t36+1.0d+0
            t38 = log(t37)
            t39 = 1/t37
            t40 = rhob**1.6666666666666674d-1
            t41 = 1/t1**3.0d+0
            t42 = -6.34154365074529d-1*gammabb*t30*t40*t41
            t43 = 1/rhob**1.3333333333333333d+0
            t44 = 1/rhob**1.3333333333333336d+0
            t45 = 1/t4**3
            t46 = 1/rhob**6.666666666666667d-1
            t47 = 1/t18
            t48 = 2.11607075208357d-1*t17*t46*t5-1.269642451250142d+0*t4
     1         *(7.876233178997433d-1*(-1.3127055298329054d-1*t14*t45*t4
     2         6-3.169132786263567d-3*t44)*t5-1.3127055298329054d-1*t15*
     3         t45*t46)/t16**2
            t49 = 1/t25
            t50 = 2.11607075208357d-1*t24*t46*t5-1.269642451250142d+0*t4
     1         *(7.876233178997433d-1*(-1.3127055298329054d-1*t21*t45*t4
     2         6-1.7344776604086162d-3*t44)*t5-1.3127055298329054d-1*t22
     3         *t45*t46)/t23**2
            t51 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-3
     1         .10907d-2*t13*(2.11607075208357d-1*t46*t5*t9-1.2696424512
     2         50142d+0*t4*(7.876233178997433d-1*t5*(-1.3127055298329054
     3         d-1*t45*t46*t6-2.0096226153166658d-3*t44)-1.3127055298329
     4         054d-1*t45*t46*t7)/t8**2)/t10+6.21814d-2*t20*t47*t48-2.74
     5         7773264188438d-3*t19*t43+1.3210398931339265d-3*t11*t43)-3
     6         .37738d-2*t27*t49*t50+7.769549222703733d-4*t26*t43)+3.377
     7         38d-2*t27*t49*t50-7.769549222703733d-4*t26*t43)-6.21814d-
     8         2*t20*t47*t48+2.747773264188438d-3*t19*t43
            t52 = 2.1974870225448048d+1*gammabb*t2*t28*t51/t29**2
            t53 = 1/t35**2
            t54 = 1/t1**4.0d+0
            fnc(iq) = 1.2367783717787881d-2*rhob*t38*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.2367783717787881d-2*rhob*t39*(-2.71780442
     1         17479813d-1*gammabb*t2*t32*(t52+1.1944679893212153d+1*t28
     2         *t33*t51/t29**3.0d+0+t42-3.4470150749406775d-1*gammabb**2
     3         *t34*t40/t1**5.0d+0)*t53+2.7178044217479813d-1*gammabb*t2
     4         *t36*(t52+t42)-6.34154365074529d-1*gammabb*t32*t36*t40*t4
     5         1)*wght+1.2367783717787881d-2*t38*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.2367783717787881d-2*rhob*t39*(-2.7178044
     1         217479813d-1*gammabb*t2*t32*t53*(1.477292174974576d-1*gam
     2         mabb*t34*t54+2.7178044217479813d-1*t2*t30)+7.386460874872
     3         879d-2*gammabb*t30*t36*t54+2.7178044217479813d-1*t2*t32*t
     4         36)*wght+Cmat(iq,D1_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_p91 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_4} &=& 1.0-{\it t_2}\,{\it t_3}\\\\ 
C>   {\it t_5} &=& {\it t_2}\,{\it t_3}+1.0\\\\ 
C>   {\it t_6} &=& 0.5\,{\it t_5}^{{{2}\over{3}}}+0.5\,{
C>    \it t_4}^{{{2}\over{3}}}\\\\ 
C>   {\it t_7} &=& {\it t_6}^{3.0}\\\\ 
C>   {\it t_8} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_6}^{2.0}}}\\\\ 
C>   {\it t_{10}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{11}} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{13}} &=& 0.1325688999052018\,{\it t_{12}}+1.0\\\\ 
C>   {\it t_{14}} &=& \sqrt{{\it t_{11}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{14}}}}\\\\ 
C>   {\it t_{16}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{14}}}\over{0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.02414199311453321\,{\it t_{15}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{17}} &=& 0.06901399211255826\,{\it t_{12}}+1.0\\\\ 
C>   {\it t_{18}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{14}}}\over{0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.01321299881039884\,{\it t_{15}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{19}} &=& {{1}\over{e^{{{40.42761511756372\,
C>    \left(0.5848223622634648\,\left(1.923661050931536\,{
C>    \it t_5}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_4}^{{{4}\over{3}}}-3.847322101863072\right)\,\left({{{
C>    \it t_2}^4\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_{13}}\,{\it t_{16}}-0.0310907\,\left(0.1274696188700087
C>    \,{\it t_{12}}+1.0\right)\,\log \left({{1.269642451250142\,{
C>    \it t_{14}}}\over{0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.01530901310039024\,{\it t_{15}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{17}}\,{\it t_{18}}\right)}\over{{
C>    \it t_1}^4}}+0.0337738\,{\it t_{17}}\,{\it t_{18}}\right)
C>    -0.0621814\,{\it t_{13}}\,{\it t_{16}}\right)}\over{{
C>    \it t_7}}}}}}-1.0\\\\ 
C>   {\it t_{20}} &=& {{0.1712109500228822\,{\it t_8}\,{\it t_9}
C>    \,{\it t_{10}}}\over{{\it t_{19}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{22}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{23}} &=& \sqrt{{\it t_{22}}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_{23}}}}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{{\it t_{22}}}}\\\\ 
C>   {\it t_{26}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{24}}+0.10186556948\right)
C>    \,{\it t_{24}}+0.22308199064\right)\,{\it t_{24}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{27}} &=& 0.1325688999052018\,{\it t_{25}}+1.0\\\\ 
C>   {\it t_{28}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{24}}
C>    +0.029729725188\right)\,{\it t_{24}}+0.12236585478\right)\,{
C>    \it t_{24}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{29}} &=& 0.06901399211255826\,{\it t_{25}}+1.0\\\\ 
C>   {\it t_{30}} &=& {{1}\over{e^{80.85523023512745\,
C>    \left(0.5848223622634643\,\left(0.0337738\,{\it t_{28}}\,{
C>    \it t_{29}}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_{26}}\,{\it t_{27}}-0.0310907\,\log 
C>    \left({{1.269642451250142\,{\it t_{23}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{24}}+0.10465751434\right)
C>    \,{\it t_{24}}+0.19269083139\right)\,{\it t_{24}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{25}}+1.0\right)\right)-0.0337738\,{\it t_{28}}\,{
C>    \it t_{29}}\right)\right)-0.0621814\,{\it t_{26}}\,{
C>    \it t_{27}}\right)}}}-1.0\\\\ 
C>   {\it t_{31}} &=& {{0.2717804421747981\,{\it t_{21}}\,
C>    \sigma_{ss}}\over{{\it t_{30}}}}\\\\ 
C>   f &=& 0.02473556743557577\,{\it t_1}\,{\it t_7}\,\log 
C>    \left({{0.1712109500228822\,{\it t_8}\,{\it t_9}\,{\it t_{10}}
C>    \,\left({\it t_{20}}+1.0\right)}\over{{{0.02931318940773787
C>    \,\left({\it t_8}\,{\it t_{10}}\right)^{2.0}}\over{{
C>    \it t_6}^{4.0}\,{\it t_{19}}^{2.0}}}+{\it t_{20}}+1.0}}
C>    +1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.01236778371778788\,\rho_s\,\log 
C>    \left({{0.2717804421747981\,{\it t_{21}}\,\sigma_{ss}\,
C>    \left({\it t_{31}}+1.0\right)}\over{{{0.0738646087487288
C>    \,\left({\it t_{21}}\,\sigma_{ss}\right)^{2.0}}\over{{
C>    \it t_{30}}^{2.0}}}+{\it t_{31}}+1.0}}+1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] JP Perdew, JA Chevary, SH Vosko, KA Jackson, MR Pederson
C>    , DJ Singh, C. Fiolhais, Phys.Rev. B 46, 6671 (1992)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/jp050536c "> 
C> 10.1021/jp050536c </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_p91_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Cmat,Cmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = exp(2.5138457066712766d+0*log(1.4251254664507676d+0*t4/
     1         (7.016926042943223d-1*t5*(7.016926042943223d-1*(2.1508070
     2         71909054d-2*t5+1.0186556948d-1)*t5+2.2308199064d-1)+4.723
     3         1125998d-1)+1.0d+0)*(1.0522000558389215d-1*t6+1.0d+0))-1.
     4         0d+0
            t8 = 1.35890221087399d-1*gammaaa*t2/t7
            t9 = (gammaaa*t2)**2.0d+0
            t10 = 2.1508070719090538d-2*t5+1.0186556948d-1
            t11 = 7.016926042943222d-1*t10*t5+2.2308199064d-1
            t12 = 7.016926042943222d-1*t11*t5+4.7231125998d-1
            t13 = 1/t12
            t14 = 1.425125466450768d+0*t13*t4+1.0d+0
            t15 = log(t14)
            t16 = 1.0522000558389213d-1*t6+1.0d+0
            t17 = exp(2.5138457066712766d+0*t15*t16)
            t18 = t17-1.0d+0
            t19 = 1/t18
            t20 = 1.3589022108739904d-1*gammaaa*t19*t2
            t21 = t20+1.0d+0
            t22 = 1/t18**2.0d+0
            t23 = 1.8466152187182186d-2*t22*t9+t20+1.0d+0
            t24 = 1/t23
            t25 = 1.3589022108739904d-1*gammaaa*t2*t21*t24+1.0d+0
            t26 = 1/t25
            t27 = rhoa**1.6666666666666674d-1
            t28 = 1/t1**3.0d+0
            t29 = -1.585385912686322d-1*gammaaa*t19*t27*t28
            t30 = 1/rhoa**1.3333333333333333d+0
            t31 = 1/t14
            t32 = 1/t12**2
            t33 = 1/rhoa**1.3333333333333336d+0
            t34 = 1/t4**3
            t35 = 1/rhoa**6.666666666666667d-1
            t36 = -5.847438369119352d-2*t10*t34*t35-1.2576711796854242d-
     1         3*t33
            t37 = 7.016926042943222d-1*t36*t5-5.847438369119352d-2*t11*t
     1         34*t35
            t38 = 1.1876045553756398d-1*t13*t35*t5-1.425125466450768d+0*
     1         t32*t37*t4
            t39 = 1.090454542535705d-3*t15*t30-6.21814d-2*t16*t31*t38
            t40 = 1/t18**2
            t41 = 5.493717556362009d+0*gammaaa*t17*t2*t39*t40
            t42 = t41+t29
            t43 = 1/t23**2
            t44 = gammaaa**2
            t45 = 1/t1**5.0d+0
            t46 = 1/t18**3.0d+0
            t47 = 1.4930849866515178d+0*t17*t39*t46*t9-4.308768843675843
     1         d-2*t22*t27*t44*t45+t41+t29
            t48 = -1.3589022108739904d-1*gammaaa*t2*t21*t43*t47+1.358902
     1         2108739904d-1*gammaaa*t2*t24*t42-1.585385912686322d-1*gam
     2         maaa*t21*t24*t27*t28
            t49 = log(t25)
            t50 = 1/t1**4.0d+0
            t51 = 9.233076093591093d-3*gammaaa*t22*t50+3.397255527184976
     1         d-2*t19*t2
            t52 = -1.3589022108739904d-1*gammaaa*t2*t21*t43*t51+4.616538
     1         0467955464d-3*gammaaa*t19*t24*t50+3.397255527184976d-2*t2
     2         *t21*t24
            t53 = 1.8466152187182186d-2*gammaaa*t22*t50+6.79451105436995
     1         2d-2*t19*t2
            t54 = -1.3589022108739904d-1*gammaaa*t2*t21*t43*t53+9.233076
     1         093591093d-3*gammaaa*t19*t24*t50+6.794511054369952d-2*t2*
     2         t21*t24
            t55 = 1/t25**2
            t56 = -4.947113487115154d-2*rhoa*t48**2*t55*wght
            t57 = 1/rhoa
            t58 = 4.947113487115154d-2*t48*wght
            t59 = rhoa**3.333333333333335d-1
            t60 = 2.774425347201063d-1*gammaaa*t21*t24*t50*t59
            t61 = 1/rhoa**8.333333333333333d-1
            t62 = -1.321154927238602d-2*gammaaa*t21*t24*t28*t61
            t63 = 1/rhoa**2
            t64 = -3.170771825372644d-1*gammaaa*t24*t27*t28*t42
            t65 = 3.170771825372644d-1*gammaaa*t21*t27*t28*t43*t47
            t66 = -2.717804421747981d-1*gammaaa*t2*t42*t43*t47
            t67 = 1/t23**3
            t68 = 2.717804421747981d-1*gammaaa*t2*t21*t47**2*t67
            t69 = 2.774425347201063d-1*gammaaa*t19*t50*t59
            t70 = -1.321154927238602d-2*gammaaa*t19*t28*t61
            t71 = 1.5098913454155444d-2*gammaaa*t19*t2*t63
            t72 = -1.281867429817802d+1*gammaaa*t17*t27*t28*t39*t40
            t73 = t39**2
            t74 = -2.2209789893320597d+2*gammaaa*t17*t2*t40*t73
            t75 = -7.269696950238034d-4*t15/rhoa**2.333333333333333d+0
            t76 = log(1.425125466450768d+0*t4/(7.016926042943222d-1*t5*(
     1         7.016926042943222d-1*(1.1771443702974158d-2*t5+2.97297251
     2         88d-2)*t5+1.2236585478d-1)+3.497952466d-1)+1.0d+0)
            t77 = 5.477644184000001d-2*t6+1.0d+0
            t78 = 2.18090908507141d-3*t30*t31*t38
            t79 = 6.21814d-2*t16*t38**2/t14**2
            t80 = 1/rhoa**1.6666666666666669d+0
            t81 = 1/t4**5
            t82 = -6.21814d-2*t16*t31*(-1.425125466450768d+0*t32*t4*(7.0
     1         16926042943222d-1*t5*(1.4618595922798375d-2*t10*t33*t81+1
     2         .949146123039784d-2*t10*t34*t80+9.432533847640683d-4/rhoa
     3         **2.3333333333333334d+0)+1.4618595922798375d-2*t11*t33*t8
     4         1+1.949146123039784d-2*t11*t34*t80-1.1694876738238703d-1*
     5         t34*t35*t36)-3.9586818512521327d-2*t13*t5*t80-2.375209110
     6         7512796d-1*t32*t35*t37*t5+2.850250932901536d+0*t37**2*t4/
     7         t12**3-9.896704628130328d-3*t13*t33*t34)
            t83 = 4.189742844452126d-1*t15*t16*t63-4.042761511756372d+1*
     1         (t82+t79+t78+8.443450000000001d-3*t63*t76*t77+t75)
            t84 = -1.3589022108739904d-1*gammaaa*t17*t2*t40*t83
            t85 = 1/t18**3
            t86 = exp(5.027691413342553d+0*t15*t16)
            t87 = 4.4419579786641195d+2*gammaaa*t2*t73*t85*t86
            t88 = 1/t1**6.0d+0
            t89 = 1.2567242460721215d-1*t22*t44*t59*t88
            t90 = -3.590640703063204d-3*t22*t44*t45*t61
            t91 = -6.967729937707083d+0*t17*t27*t39*t44*t45*t46
            t92 = 1.8108559553448098d+2*t73*t86*t9/t18**4.0d+0
            t93 = -1.509891345415545d-2*gammaaa*t19*t2*t63
            t94 = -2.2209789893320595d+2*gammaaa*t17*t2*t40*t73
            t95 = -4.042761511756372d+1*(t82+t79+t78-8.44345d-3*t63*t76*
     1         t77+t75)-4.1897428444521273d-1*t15*t16*t63
            t96 = -1.3589022108739904d-1*gammaaa*t17*t2*t40*t95
            t97 = 4.441957978664119d+2*gammaaa*t2*t73*t85*t86
            t98 = -3.9634647817158053d-2*t19*t27*t28
            t99 = 1.3734293890905022d+0*t17*t2*t39*t40
            t100 = t26*(4.947113487115154d-2*rhoa*(-1.3589022108739904d-
     1         1*gammaaa*t2*t21*t43*(t99+t98+7.465424933257588d-1*gammaa
     2         a*t17*t39*t46*t50-2.1543844218379216d-2*gammaaa*t22*t27*t
     3         45)+1.3589022108739904d-1*gammaaa*t2*t24*(t99+t98)+2.7178
     4         04421747981d-1*gammaaa*t2*t21*t47*t51*t67-1.3589022108739
     5         904d-1*gammaaa*t2*t42*t43*t51+1.585385912686322d-1*gammaa
     6         a*t21*t27*t28*t43*t51-4.6165380467955464d-3*gammaaa*t19*t
     7         43*t47*t50-3.397255527184976d-2*t2*t21*t43*t47-5.38596105
     8         4594804d-3*gammaaa*t19*t24*t27*t45+3.397255527184976d-2*t
     9         2*t24*t42-3.9634647817158053d-2*t21*t24*t27*t28)*wght+2.4
     :         73556743557577d-2*t52*wght)-4.947113487115154d-2*rhoa*t48
     ;         *t52*t55*wght
            t101 = -7.926929563431611d-2*t19*t27*t28
            t102 = 2.7468587781810044d+0*t17*t2*t39*t40
            t103 = -6.794511054369952d-2*t2*t21*t43*t51
            t104 = -9.233076093591093d-3*gammaaa*t19*t43*t50*t51
            t105 = 4.947113487115154d-2*rhoa*t26*(-3.136711879187181d-4*
     1         gammaaa*t21*t22*t43*t88+2.717804421747981d-1*gammaaa*t2*t
     2         21*t51**2*t67+2.3082690233977732d-3*t19*t24*t50+t104+t103
     3         )*wght-4.947113487115154d-2*rhoa*t52**2*t55*wght
            fnc(iq) = 4.947113487115154d-2*rhoa*log(1.35890221087399d-1*
     1         gammaaa*t2*(t8+1.0d+0)/(1.8466152187182178d-2*t9/t7**2.0d
     2         +0+t8+1.0d+0)+1.0d+0)*wght+fnc(iq)
            Amat(iq,D1_RA) = 2.473556743557577d-2*t49*wght+4.94711348711
     1         5154d-2*rhoa*t26*t48*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 4.947113487115154d-2*rhoa*t26*t52*wght+Cma
     1         t(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 4.947113487115154d-2*rhoa*t26*t54*wght+Cma
     1         t(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = t26*(4.947113487115154d-2*rhoa*(-1.3589
     1         022108739904d-1*gammaaa*t2*t21*t43*(t92+t91+t90-3.6932304
     2         37436437d-2*t17*t46*t83*t9-6.036186517816032d+1*t17*t46*t
     3         73*t9+4.1035893749293734d-3*t22*t63*t9+t89+t87+t84+t74+t7
     4         2+t71+t70+t69)+1.3589022108739904d-1*gammaaa*t2*t24*(t87+
     5         t84+t74+t72+t71+t70+t69)+t68+t66+t65+t64+1.50989134541554
     6         44d-2*gammaaa*t2*t21*t24*t63+t62+t60)*wght+t58)-8.2451891
     7         45191921d-3*t49*t57*wght+t56+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = t26*(4.947113487115154d-2*rhoa*(-1.3589
     1         022108739904d-1*gammaaa*t2*t21*t43*(t97+t96-3.69323043743
     2         6437d-2*t17*t46*t9*t95+t94+t93+t92+t91+t90-6.036186517816
     3         031d+1*t17*t46*t73*t9-4.1035893749293745d-3*t22*t63*t9+t8
     4         9+t72+t70+t69)+1.3589022108739904d-1*gammaaa*t2*t24*(t97+
     5         t96+t94+t93+t72+t70+t69)+t68+t66+t65+t64-1.50989134541554
     6         5d-2*gammaaa*t2*t21*t24*t63+t62+t60)*wght+t58)+8.24518914
     7         5191922d-3*t49*t57*wght+t56+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = t100+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = t26*(4.947113487115154d-2*rhoa*(2.7178
     1         04421747981d-1*gammaaa*t2*t21*t47*t53*t67-1.3589022108739
     2         904d-1*gammaaa*t2*t42*t43*t53+1.585385912686322d-1*gammaa
     3         a*t21*t27*t28*t43*t53-1.3589022108739904d-1*gammaaa*t2*t2
     4         1*t43*(1.4930849866515178d+0*gammaaa*t17*t39*t46*t50-4.30
     5         8768843675843d-2*gammaaa*t22*t27*t45+t102+t101)-9.2330760
     6         93591093d-3*gammaaa*t19*t43*t47*t50-6.794511054369952d-2*
     7         t2*t21*t43*t47-1.0771922109189608d-2*gammaaa*t19*t24*t27*
     8         t45+6.794511054369952d-2*t2*t24*t42-7.926929563431611d-2*
     9         t21*t24*t27*t28+1.3589022108739904d-1*gammaaa*(t102+t101)
     :         *t2*t24)*wght+2.473556743557577d-2*t54*wght)-4.9471134871
     ;         15154d-2*rhoa*t48*t54*t55*wght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t100+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = t105+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = 4.947113487115154d-2*rhoa*t26*(-6.273
     1         423758374362d-4*gammaaa*t21*t22*t43*t88+2.717804421747981
     2         d-1*gammaaa*t2*t21*t51*t53*t67-4.6165380467955464d-3*gamm
     3         aaa*t19*t43*t50*t53-3.397255527184976d-2*t2*t21*t43*t53+4
     4         .6165380467955464d-3*t19*t24*t50+t104+t103)*wght-4.947113
     5         487115154d-2*rhoa*t52*t54*t55*wght+Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t105+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 4.947113487115154d-2*rhoa*t26*(-1.254
     1         6847516748727d-3*gammaaa*t21*t22*t43*t88+2.71780442174798
     2         1d-1*gammaaa*t2*t21*t53**2*t67-1.8466152187182186d-2*gamm
     3         aaa*t19*t43*t50*t53-1.3589022108739904d-1*t2*t21*t43*t53+
     4         9.233076093591093d-3*t19*t24*t50)*wght-4.947113487115154d
     5         -2*rhoa*t54**2*t55*wght+Cmat2(iq,D2_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = rhoa-rhob
            t3 = 1/t1
            t4 = 1.0d+0-t2*t3
            t5 = t4**6.666666666666666d-1
            t6 = t2*t3+1.0d+0
            t7 = t6**6.666666666666666d-1
            t8 = 5.0d-1*t7+5.0d-1*t5
            t9 = t8**3.0d+0
            t10 = gammabb+2.0d+0*gammaab+gammaaa
            t11 = t1**1.1666666666666667d+0
            t12 = 1/t11**2.0d+0
            t13 = t8**2.0d+0
            t14 = 1/t13
            t15 = 1/t9
            t16 = t1**3.333333333333333d-1
            t17 = 1/t16
            t18 = 1.325688999052018d-1*t17+1.0d+0
            t19 = t16**5.0d-1
            t20 = 1/t19
            t21 = 2.4141993114533214d-2*t20+1.0186556948d-1
            t22 = 7.876233178997433d-1*t20*t21+2.2308199064d-1
            t23 = 7.876233178997433d-1*t20*t22+4.7231125998d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t19*t24+1.0d+0
            t26 = log(t25)
            t27 = t4**1.3333333333333333d+0
            t28 = t6**1.3333333333333333d+0
            t29 = 1.923661050931536d+0*t28+1.923661050931536d+0*t27-3.84
     1         7322101863072d+0
            t30 = 6.901399211255826d-2*t17+1.0d+0
            t31 = 1.3212998810398843d-2*t20+2.9729725188d-2
            t32 = 7.876233178997433d-1*t20*t31+1.2236585478d-1
            t33 = 7.876233178997433d-1*t20*t32+3.497952466d-1
            t34 = 1/t33
            t35 = 1.269642451250142d+0*t19*t34+1.0d+0
            t36 = log(t35)
            t37 = t2**4
            t38 = 1/t1**4
            t39 = 1.2746961887000874d-1*t17+1.0d+0
            t40 = 1.530901310039024d-2*t20+1.0465751434d-1
            t41 = 7.876233178997433d-1*t20*t40+1.9269083139d-1
            t42 = 7.876233178997433d-1*t20*t41+4.3896648423d-1
            t43 = 1/t42
            t44 = 1.269642451250142d+0*t19*t43+1.0d+0
            t45 = log(t44)
            t46 = 1.709920934161365d+0*(6.21814d-2*t18*t26-3.10907d-2*t3
     1         9*t45)-3.37738d-2*t30*t36
            t47 = t37*t38*t46+3.37738d-2*t30*t36
            t48 = 5.848223622634648d-1*t29*t47-6.21814d-2*t18*t26
            t49 = exp(-4.042761511756372d+1*t15*t48)
            t50 = t49-1.0d+0
            t51 = 1/t50
            t52 = 1.7121095002288222d-1*t10*t12*t14*t51
            t53 = t52+1.0d+0
            t54 = 1/t8**4.0d+0
            t55 = (t10*t12)**2.0d+0
            t56 = 1/t50**2.0d+0
            t57 = 2.931318940773787d-2*t54*t55*t56+t52+1.0d+0
            t58 = 1/t57
            t59 = 1.7121095002288222d-1*t10*t12*t14*t53*t58+1.0d+0
            t60 = log(t59)
            t61 = 1/t59
            t62 = 1/t1**2
            t63 = t2*t62
            t64 = -t3
            t65 = t64+t63
            t66 = t4**3.333333333333333d-1
            t67 = 1/t66
            t68 = -t2*t62
            t69 = t68+t3
            t70 = t6**3.333333333333333d-1
            t71 = 1/t70
            t72 = 3.333333333333333d-1*t69*t71+3.333333333333333d-1*t65*
     1         t67
            t73 = t1**1.6666666666666674d-1
            t74 = 1/t11**3.0d+0
            t75 = -3.994922167200585d-1*t10*t14*t53*t58*t73*t74
            t76 = -3.4242190004576445d-1*t10*t12*t15*t51*t72
            t77 = -3.994922167200585d-1*t10*t14*t51*t73*t74
            t78 = 1/t50**2
            t79 = 1/t1**1.3333333333333336d+0
            t80 = 1/t1**6.666666666666667d-1
            t81 = 1/t19**3
            t82 = -1.3127055298329054d-1*t21*t80*t81-3.169132786263567d-
     1         3*t79
            t83 = 7.876233178997433d-1*t20*t82-1.3127055298329054d-1*t22
     1         *t80*t81
            t84 = 1/t23**2
            t85 = 2.11607075208357d-1*t20*t24*t80-1.269642451250142d+0*t
     1         19*t83*t84
            t86 = 1/t25
            t87 = -6.21814d-2*t18*t85*t86
            t88 = 1/t1**1.3333333333333333d+0
            t89 = 2.747773264188438d-3*t26*t88
            t90 = -1.3127055298329054d-1*t31*t80*t81-1.7344776604086162d
     1         -3*t79
            t91 = 7.876233178997433d-1*t20*t90-1.3127055298329054d-1*t32
     1         *t80*t81
            t92 = 1/t33**2
            t93 = 2.11607075208357d-1*t20*t34*t80-1.269642451250142d+0*t
     1         19*t91*t92
            t94 = 1/t35
            t95 = 3.37738d-2*t30*t93*t94
            t96 = -7.769549222703733d-4*t36*t88
            t97 = -1.3127055298329054d-1*t40*t80*t81-2.0096226153166658d
     1         -3*t79
            t98 = 7.876233178997433d-1*t20*t97-1.3127055298329054d-1*t41
     1         *t80*t81
            t99 = 1/t42**2
            t100 = 2.11607075208357d-1*t20*t43*t80-1.269642451250142d+0*
     1         t19*t98*t99
            t101 = 1/t44
            t102 = -3.37738d-2*t30*t93*t94+1.709920934161365d+0*(1.32103
     1         98931339265d-3*t45*t88-2.747773264188438d-3*t26*t88+6.218
     2         14d-2*t18*t85*t86-3.10907d-2*t100*t101*t39)+7.76954922270
     3         3733d-4*t36*t88
            t103 = t102*t37*t38
            t104 = 1/t1**5
            t105 = -4*t104*t37*t46
            t106 = t2**3
            t107 = t96+t95+4*t106*t38*t46+t105+t103
            t108 = 2.564881401242048d+0*t69*t70+2.564881401242048d+0*t65
     1         *t66
            t109 = t89+t87+5.848223622634648d-1*t108*t47+5.8482236226346
     1         48d-1*t107*t29
            t110 = 1.2128284535269115d+2*t48*t54*t72-4.042761511756372d+
     1         1*t109*t15
            t111 = -1.7121095002288222d-1*t10*t110*t12*t14*t49*t78
            t112 = t77+t76+t111
            t113 = 1/t57**2
            t114 = t10**2
            t115 = 1/t11**5.0d+0
            t116 = -1.3679488390277675d-1*t114*t115*t54*t56*t73
            t117 = 1/t8**5.0d+0
            t118 = 1/t50**3.0d+0
            t119 = t77+t76-1.172527576309515d-1*t117*t55*t56*t72-5.86263
     1         7881547574d-2*t110*t118*t49*t54*t55+t116+t111
            t120 = t75-3.4242190004576445d-1*t10*t12*t15*t53*t58*t72+1.7
     1         121095002288222d-1*t10*t112*t12*t14*t58-1.712109500228822
     2         2d-1*t10*t113*t119*t12*t14*t53
            t121 = 2.473556743557577d-2*t60*t9*wght
            t122 = t63+t3
            t123 = t68+t64
            t124 = 3.333333333333333d-1*t123*t71+3.333333333333333d-1*t1
     1         22*t67
            t125 = -3.4242190004576445d-1*t10*t12*t124*t15*t51
            t126 = t96+t95-4*t106*t38*t46+t105+t103
            t127 = 2.564881401242048d+0*t123*t70+2.564881401242048d+0*t1
     1         22*t66
            t128 = t89+t87+5.848223622634648d-1*t127*t47+5.8482236226346
     1         48d-1*t126*t29
            t129 = 1.2128284535269115d+2*t124*t48*t54-4.042761511756372d
     1         +1*t128*t15
            t130 = -1.7121095002288222d-1*t10*t12*t129*t14*t49*t78
            t131 = t77+t130+t125
            t132 = t77-1.172527576309515d-1*t117*t124*t55*t56-5.86263788
     1         1547574d-2*t118*t129*t49*t54*t55+t130+t125+t116
            t133 = t75-3.4242190004576445d-1*t10*t12*t124*t15*t53*t58+1.
     1         7121095002288222d-1*t10*t12*t131*t14*t58-1.71210950022882
     2         22d-1*t10*t113*t12*t132*t14*t53
            t134 = 1/t11**4.0d+0
            t135 = 5.862637881547574d-2*t10*t134*t54*t56+1.7121095002288
     1         222d-1*t12*t14*t51
            t136 = 2.931318940773787d-2*t10*t134*t51*t54*t58+1.712109500
     1         2288222d-1*t12*t14*t53*t58-1.7121095002288222d-1*t10*t113
     2         *t12*t135*t14*t53
            t137 = 2.473556743557577d-2*t1*t136*t61*t9*wght
            t138 = 1.172527576309515d-1*t10*t134*t54*t56+3.4242190004576
     1         445d-1*t12*t14*t51
            t139 = 5.862637881547574d-2*t10*t134*t51*t54*t58+3.424219000
     1         4576445d-1*t12*t14*t53*t58-1.7121095002288222d-1*t10*t113
     2         *t12*t138*t14*t53
            t140 = 1/t59**2
            t141 = t72**2
            t142 = t65**2
            t143 = 1/t27
            t144 = 1/t1**3
            t145 = -2*t144*t2
            t146 = 2*t62
            t147 = t146+t145
            t148 = t69**2
            t149 = 1/t28
            t150 = 2*t144*t2
            t151 = -2*t62
            t152 = t151+t150
            t153 = 3.333333333333333d-1*t152*t71+3.333333333333333d-1*t1
     1         47*t67-1.111111111111111d-1*t148*t149-1.111111111111111d-
     2         1*t142*t143
            t154 = t1**3.333333333333335d-1
            t155 = 1.398222758520205d+0*t10*t134*t14*t154*t53*t58
            t156 = 1/t1**8.333333333333333d-1
            t157 = -6.658203612000978d-2*t10*t14*t156*t53*t58*t74
            t158 = 1.0272657001372934d+0*t10*t12*t141*t51*t54
            t159 = -3.4242190004576445d-1*t10*t12*t15*t153*t51
            t160 = 1.5979688668802342d+0*t10*t15*t51*t72*t73*t74
            t161 = 1.398222758520205d+0*t10*t134*t14*t154*t51
            t162 = -6.658203612000978d-2*t10*t14*t156*t51*t74
            t163 = t85**2
            t164 = 1/t25**2
            t165 = 6.21814d-2*t163*t164*t18
            t166 = 1/t1**2.3333333333333334d+0
            t167 = 1/t19**5
            t168 = 1/t1**1.6666666666666669d+0
            t169 = -4.23214150416714d-1*t20*t80*t83*t84-1.26964245125014
     1         2d+0*t19*(-2.625411059665811d-1*t80*t81*t82+7.87623317899
     2         7433d-1*t20*(8.751370198886037d-2*t168*t21*t81+6.56352764
     3         9164527d-2*t167*t21*t79+4.753699179395351d-3*t166)+8.7513
     4         70198886037d-2*t168*t22*t81+6.563527649164527d-2*t167*t22
     5         *t79)*t84+2.539284902500284d+0*t19*t83**2/t23**3-3.526784
     6         58680595d-2*t24*t79*t81-1.4107138347223802d-1*t168*t20*t2
     7         4
            t170 = -6.21814d-2*t169*t18*t86
            t171 = 5.495546528376876d-3*t85*t86*t88
            t172 = 1/t1**2.333333333333333d+0
            t173 = -3.663697685584584d-3*t172*t26
            t174 = t93**2
            t175 = 1/t35**2
            t176 = -3.37738d-2*t174*t175*t30
            t177 = -4.23214150416714d-1*t20*t80*t91*t92-1.26964245125014
     1         2d+0*t19*(-2.625411059665811d-1*t80*t81*t90+7.87623317899
     2         7433d-1*t20*(8.751370198886037d-2*t168*t31*t81+6.56352764
     3         9164527d-2*t167*t31*t79+2.601716490612924d-3*t166)+8.7513
     4         70198886037d-2*t168*t32*t81+6.563527649164527d-2*t167*t32
     5         *t79)*t92+2.539284902500284d+0*t19*t91**2/t33**3-3.526784
     6         58680595d-2*t34*t79*t81-1.4107138347223802d-1*t168*t20*t3
     7         4
            t178 = 3.37738d-2*t177*t30*t94
            t179 = -1.5539098445407465d-3*t88*t93*t94
            t180 = 1.0359398963604977d-3*t172*t36
            t181 = t37*t38*(1.709920934161365d+0*(-3.10907d-2*t101*t39*(
     1         -4.23214150416714d-1*t20*t80*t98*t99-1.269642451250142d+0
     2         *t19*(-2.625411059665811d-1*t80*t81*t97+7.876233178997433
     3         d-1*t20*(8.751370198886037d-2*t168*t40*t81+6.563527649164
     4         527d-2*t167*t40*t79+3.0144339229749983d-3*t166)+8.7513701
     5         98886037d-2*t168*t41*t81+6.563527649164527d-2*t167*t41*t7
     6         9)*t99+2.539284902500284d+0*t19*t98**2/t42**3-3.526784586
     7         80595d-2*t43*t79*t81-1.4107138347223802d-1*t168*t20*t43)-
     8         5.495546528376876d-3*t85*t86*t88+2.642079786267853d-3*t10
     9         0*t101*t88+6.21814d-2*t169*t18*t86-1.7613865241785687d-3*
     :         t172*t45+3.10907d-2*t100**2*t39/t44**2+3.663697685584584d
     ;         -3*t172*t26-6.21814d-2*t163*t164*t18)+1.5539098445407465d
     <         -3*t88*t93*t94-3.37738d-2*t177*t30*t94-1.0359398963604977
     =         d-3*t172*t36+3.37738d-2*t174*t175*t30)
            t182 = -8*t102*t104*t37
            t183 = 20*t37*t46/t1**6
            t184 = t2**2
            t185 = 12*t184*t38*t46
            t186 = 1/t5
            t187 = 1/t7
            t188 = 2.425656907053823d+2*t109*t54*t72-4.042761511756372d+
     1         1*t15*(5.848223622634648d-1*t47*(2.564881401242048d+0*t15
     2         2*t70+2.564881401242048d+0*t147*t66+8.549604670806825d-1*
     3         t148*t187+8.549604670806825d-1*t142*t186)+5.8482236226346
     4         48d-1*t29*(-32*t104*t106*t46+8*t102*t106*t38+t185+t183+t1
     5         82+t181+t180+t179+t178+t176)+t173+t171+t170+t165+1.169644
     6         7245269297d+0*t107*t108)+1.2128284535269115d+2*t153*t48*t
     7         54-4.851313814107646d+2*t117*t141*t48
            t189 = -1.7121095002288222d-1*t10*t12*t14*t188*t49*t78
            t190 = 6.848438000915289d-1*t10*t110*t12*t15*t49*t72*t78
            t191 = 7.98984433440117d-1*t10*t110*t14*t49*t73*t74*t78
            t192 = exp(-8.085523023512744d+1*t15*t48)
            t193 = 1/t50**3
            t194 = t110**2
            t195 = 3.4242190004576445d-1*t10*t12*t14*t192*t193*t194
            t196 = -1.7121095002288222d-1*t10*t12*t14*t194*t49*t78
            t197 = 1/t11**6.0d+0
            t198 = 7.979701560995311d-1*t114*t154*t197*t54*t56
            t199 = -2.2799147317129467d-2*t114*t115*t156*t54*t56
            t200 = 1/t8**6.0d+0
            t201 = 1/t50**4.0d+0
            t202 = 1/t57**3
            t203 = 6.666666666666666d-1*t144*t2*t71-1.111111111111111d-1
     1         *t123*t149*t69-6.666666666666666d-1*t144*t2*t67-1.1111111
     2         11111111d-1*t122*t143*t65
            t204 = 1.0272657001372934d+0*t10*t12*t124*t51*t54*t72
            t205 = -3.4242190004576445d-1*t10*t12*t15*t203*t51
            t206 = 7.98984433440117d-1*t10*t124*t15*t51*t73*t74
            t207 = 7.98984433440117d-1*t10*t15*t51*t72*t73*t74
            t208 = 1.2128284535269115d+2*t128*t54*t72-4.851313814107646d
     1         +2*t117*t124*t48*t72-4.042761511756372d+1*t15*(5.84822362
     2         2634648d-1*t47*(5.129762802484096d+0*t144*t2*t70+8.549604
     3         670806825d-1*t123*t187*t69-5.129762802484096d+0*t144*t2*t
     4         66+8.549604670806825d-1*t122*t186*t65)+5.848223622634648d
     5         -1*t29*(-12*t184*t38*t46+t183+t182+t181+t180+t179+t178+t1
     6         76)+t173+t171+t170+t165+5.848223622634648d-1*t107*t127+5.
     7         848223622634648d-1*t108*t126)+1.2128284535269115d+2*t203*
     8         t48*t54+1.2128284535269115d+2*t109*t124*t54
            t209 = -1.7121095002288222d-1*t10*t12*t14*t208*t49*t78
            t210 = 3.4242190004576445d-1*t10*t12*t129*t15*t49*t72*t78
            t211 = 3.994922167200585d-1*t10*t129*t14*t49*t73*t74*t78
            t212 = 3.4242190004576445d-1*t10*t110*t12*t124*t15*t49*t78
            t213 = 3.994922167200585d-1*t10*t110*t14*t49*t73*t74*t78
            t214 = 3.4242190004576445d-1*t10*t110*t12*t129*t14*t192*t193
            t215 = -1.7121095002288222d-1*t10*t110*t12*t129*t14*t49*t78
            t216 = t124**2
            t217 = t122**2
            t218 = t151+t145
            t219 = t123**2
            t220 = t150+t146
            t221 = 3.333333333333333d-1*t220*t71+3.333333333333333d-1*t2
     1         18*t67-1.111111111111111d-1*t149*t219-1.111111111111111d-
     2         1*t143*t217
            t222 = 1.0272657001372934d+0*t10*t12*t216*t51*t54
            t223 = -3.4242190004576445d-1*t10*t12*t15*t221*t51
            t224 = 1.5979688668802342d+0*t10*t124*t15*t51*t73*t74
            t225 = -4.042761511756372d+1*t15*(5.848223622634648d-1*t47*(
     1         2.564881401242048d+0*t220*t70+2.564881401242048d+0*t218*t
     2         66+8.549604670806825d-1*t187*t219+8.549604670806825d-1*t1
     3         86*t217)+5.848223622634648d-1*t29*(32*t104*t106*t46-8*t10
     4         2*t106*t38+t185+t183+t182+t181+t180+t179+t178+t176)+t173+
     5         t171+t170+t165+1.1696447245269297d+0*t126*t127)+1.2128284
     6         535269115d+2*t221*t48*t54+2.425656907053823d+2*t124*t128*
     7         t54-4.851313814107646d+2*t117*t216*t48
            t226 = -1.7121095002288222d-1*t10*t12*t14*t225*t49*t78
            t227 = 6.848438000915289d-1*t10*t12*t124*t129*t15*t49*t78
            t228 = 7.98984433440117d-1*t10*t129*t14*t49*t73*t74*t78
            t229 = t129**2
            t230 = 3.4242190004576445d-1*t10*t12*t14*t192*t193*t229
            t231 = -1.7121095002288222d-1*t10*t12*t14*t229*t49*t78
            t232 = 2.473556743557577d-2*t136*t9*wght
            t233 = 3.994922167200585d-1*t10*t113*t135*t14*t53*t73*t74
            t234 = -3.994922167200585d-1*t14*t53*t58*t73*t74
            t235 = -6.839744195138837d-2*t10*t115*t51*t54*t58*t73
            t236 = -3.4242190004576445d-1*t12*t15*t51*t72
            t237 = -3.994922167200585d-1*t14*t51*t73*t74
            t238 = -1.7121095002288222d-1*t110*t12*t14*t49*t78
            t239 = -2.735897678055535d-1*t10*t115*t54*t56*t73
            t240 = t61*(2.473556743557577d-2*t1*(-1.7121095002288222d-1*
     1         t10*t113*t12*t14*t53*(-2.34505515261903d-1*t10*t117*t134*
     2         t56*t72-1.172527576309515d-1*t10*t110*t118*t134*t49*t54+t
     3         239+t238+t237+t236)-3.4242190004576445d-1*t12*t15*t53*t58
     4         *t72-5.862637881547574d-2*t10*t117*t134*t51*t58*t72+3.424
     5         2190004576445d-1*t10*t113*t12*t135*t15*t53*t72+1.71210950
     6         02288222d-1*t10*t12*t14*(t238+t237+t236)*t58+1.7121095002
     7         288222d-1*t112*t12*t14*t58-2.931318940773787d-2*t10*t113*
     8         t119*t134*t51*t54+3.4242190004576445d-1*t10*t119*t12*t135
     9         *t14*t202*t53-1.7121095002288222d-1*t113*t119*t12*t14*t53
     :         +t235+t234+t233-1.7121095002288222d-1*t10*t112*t113*t12*t
     ;         135*t14)*t9*wght+7.420670230672731d-2*t1*t13*t136*t72*wgh
     <         t+t232)-2.473556743557577d-2*t1*t120*t136*t140*t9*wght
            t241 = 2.473556743557577d-2*t139*t9*wght
            t242 = 3.994922167200585d-1*t10*t113*t138*t14*t53*t73*t74
            t243 = -7.98984433440117d-1*t14*t53*t58*t73*t74
            t244 = -1.3679488390277675d-1*t10*t115*t51*t54*t58*t73
            t245 = -6.848438000915289d-1*t12*t15*t51*t72
            t246 = -7.98984433440117d-1*t14*t51*t73*t74
            t247 = -3.4242190004576445d-1*t110*t12*t14*t49*t78
            t248 = -5.47179535611107d-1*t10*t115*t54*t56*t73
            t249 = -3.4242190004576445d-1*t12*t124*t15*t51
            t250 = -1.7121095002288222d-1*t12*t129*t14*t49*t78
            t251 = t61*(2.473556743557577d-2*t1*(-3.4242190004576445d-1*
     1         t12*t124*t15*t53*t58-5.862637881547574d-2*t10*t117*t124*t
     2         134*t51*t58+1.7121095002288222d-1*t10*t12*t14*(t250+t249+
     3         t237)*t58+1.7121095002288222d-1*t12*t131*t14*t58-1.712109
     4         5002288222d-1*t10*t113*t12*t14*t53*(-2.34505515261903d-1*
     5         t10*t117*t124*t134*t56-1.172527576309515d-1*t10*t118*t129
     6         *t134*t49*t54+t250+t249+t239+t237)-2.931318940773787d-2*t
     7         10*t113*t132*t134*t51*t54+3.4242190004576445d-1*t10*t12*t
     8         132*t135*t14*t202*t53+3.4242190004576445d-1*t10*t113*t12*
     9         t124*t135*t15*t53-1.7121095002288222d-1*t113*t12*t132*t14
     :         *t53+t235+t234+t233-1.7121095002288222d-1*t10*t113*t12*t1
     ;         31*t135*t14)*t9*wght+7.420670230672731d-2*t1*t124*t13*t13
     <         6*wght+t232)-2.473556743557577d-2*t1*t133*t136*t140*t9*wg
     =         ht
            t252 = -6.848438000915289d-1*t12*t124*t15*t51
            t253 = -3.4242190004576445d-1*t12*t129*t14*t49*t78
            t254 = -3.4242190004576445d-1*t113*t12*t135*t14*t53
            t255 = -5.862637881547574d-2*t10*t113*t134*t135*t51*t54
            t256 = 2.473556743557577d-2*t1*(5.862637881547574d-2*t134*t5
     1         1*t54*t58-1.003747801339898d-2*t10*t113*t197*t200*t53*t56
     2         +3.4242190004576445d-1*t10*t12*t135**2*t14*t202*t53+t255+
     3         t254)*t61*t9*wght-2.473556743557577d-2*t1*t136**2*t140*t9
     4         *wght
            t257 = 2.473556743557577d-2*t1*(1.172527576309515d-1*t134*t5
     1         1*t54*t58-2.007495602679796d-2*t10*t113*t197*t200*t53*t56
     2         -2.931318940773787d-2*t10*t113*t134*t138*t51*t54+3.424219
     3         0004576445d-1*t10*t12*t135*t138*t14*t202*t53-1.7121095002
     4         288222d-1*t113*t12*t138*t14*t53+t255+t254)*t61*t9*wght-2.
     5         473556743557577d-2*t1*t136*t139*t140*t9*wght
            fnc(iq) = 2.473556743557577d-2*t1*t60*t9*wght+fnc(iq)
            Amat(iq,D1_RA) = 2.473556743557577d-2*t1*t120*t61*t9*wght+7.
     1         420670230672731d-2*t1*t13*t60*t72*wght+t121+Amat(iq,D1_RA
     2         )
            Amat(iq,D1_RB) = 2.473556743557577d-2*t1*t133*t61*t9*wght+7.
     1         420670230672731d-2*t1*t124*t13*t60*wght+t121+Amat(iq,D1_R
     2         B)
            Cmat(iq,D1_GAA) = t137+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 2.473556743557577d-2*t1*t139*t61*t9*wght+C
     1         mat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t137+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = t61*(2.473556743557577d-2*t1*(1.5979688
     1         668802342d+0*t10*t15*t53*t58*t72*t73*t74-7.98984433440117
     2         d-1*t10*t112*t14*t58*t73*t74+7.98984433440117d-1*t10*t113
     3         *t119*t14*t53*t73*t74-1.7121095002288222d-1*t10*t113*t12*
     4         t14*t53*(1.094359071222214d+0*t114*t115*t117*t56*t72*t73+
     5         5.47179535611107d-1*t110*t114*t115*t118*t49*t54*t73+4.690
     6         11030523806d-1*t110*t117*t118*t49*t55*t72+5.8626378815475
     7         74d-1*t141*t200*t55*t56-1.172527576309515d-1*t117*t153*t5
     8         5*t56-5.862637881547574d-2*t118*t194*t49*t54*t55-5.862637
     9         881547574d-2*t118*t188*t49*t54*t55+1.7587913644642725d-1*
     :         t192*t194*t201*t54*t55+t199+t198+t196+t195+t191+t190+t189
     ;         +t162+t161+t160+t159+t158)-6.848438000915289d-1*t10*t112*
     <         t12*t15*t58*t72+6.848438000915289d-1*t10*t113*t119*t12*t1
     =         5*t53*t72+1.0272657001372934d+0*t10*t12*t141*t53*t54*t58-
     >         3.4242190004576445d-1*t10*t12*t15*t153*t53*t58+1.71210950
     ?         02288222d-1*t10*t12*t14*(t196+t195+t191+t190+t189+t162+t1
     @         61+t160+t159+t158)*t58+3.4242190004576445d-1*t10*t119**2*
     1         t12*t14*t202*t53+t157+t155-3.4242190004576445d-1*t10*t112
     2         *t113*t119*t12*t14)*t9*wght+4.947113487115154d-2*t120*t9*
     3         wght+1.4841340461345462d-1*t1*t120*t13*t72*wght)-2.473556
     4         743557577d-2*t1*t120**2*t140*t9*wght+1.4841340461345462d-
     5         1*t1*t141*t60*t8*wght+1.4841340461345462d-1*t13*t60*t72*w
     6         ght+7.420670230672731d-2*t1*t13*t153*t60*wght+Amat2(iq,D2
     7         _RA_RA)
            Amat2(iq,D2_RA_RB) = t61*(2.473556743557577d-2*t1*(7.9898443
     1         3440117d-1*t10*t15*t53*t58*t72*t73*t74+7.98984433440117d-
     2         1*t10*t124*t15*t53*t58*t73*t74-3.994922167200585d-1*t10*t
     3         131*t14*t58*t73*t74-3.994922167200585d-1*t10*t112*t14*t58
     4         *t73*t74+3.994922167200585d-1*t10*t113*t132*t14*t53*t73*t
     5         74+3.994922167200585d-1*t10*t113*t119*t14*t53*t73*t74-1.7
     6         121095002288222d-1*t10*t113*t12*t14*t53*(5.47179535611107
     7         d-1*t114*t115*t117*t56*t72*t73+5.47179535611107d-1*t114*t
     8         115*t117*t124*t56*t73+2.735897678055535d-1*t114*t115*t118
     9         *t129*t49*t54*t73+2.735897678055535d-1*t110*t114*t115*t11
     :         8*t49*t54*t73+5.862637881547574d-1*t124*t200*t55*t56*t72+
     ;         2.34505515261903d-1*t117*t118*t129*t49*t55*t72-1.17252757
     <         6309515d-1*t117*t203*t55*t56-5.862637881547574d-2*t118*t2
     =         08*t49*t54*t55-5.862637881547574d-2*t110*t118*t129*t49*t5
     >         4*t55+1.7587913644642725d-1*t110*t129*t192*t201*t54*t55+2
     ?         .34505515261903d-1*t110*t117*t118*t124*t49*t55+t215+t214+
     @         t213+t212+t211+t210+t209+t207+t206+t205+t204+t199+t198+t1
     1         62+t161)+1.0272657001372934d+0*t10*t12*t124*t53*t54*t58*t
     2         72-3.4242190004576445d-1*t10*t12*t131*t15*t58*t72+3.42421
     3         90004576445d-1*t10*t113*t12*t132*t15*t53*t72-3.4242190004
     4         576445d-1*t10*t12*t15*t203*t53*t58+1.7121095002288222d-1*
     5         t10*t12*t14*(t215+t214+t213+t212+t211+t210+t209+t207+t206
     6         +t205+t204+t162+t161)*t58-3.4242190004576445d-1*t10*t112*
     7         t12*t124*t15*t58+3.4242190004576445d-1*t10*t119*t12*t132*
     8         t14*t202*t53+3.4242190004576445d-1*t10*t113*t119*t12*t124
     9         *t15*t53+t157+t155-1.7121095002288222d-1*t10*t112*t113*t1
     :         2*t132*t14-1.7121095002288222d-1*t10*t113*t119*t12*t131*t
     ;         14)*t9*wght+2.473556743557577d-2*t133*t9*wght+2.473556743
     <         557577d-2*t120*t9*wght+7.420670230672731d-2*t1*t13*t133*t
     =         72*wght+7.420670230672731d-2*t1*t120*t124*t13*wght)-2.473
     >         556743557577d-2*t1*t120*t133*t140*t9*wght+1.4841340461345
     ?         462d-1*t1*t124*t60*t72*t8*wght+7.420670230672731d-2*t13*t
     @         60*t72*wght+7.420670230672731d-2*t1*t13*t203*t60*wght+7.4
     1         20670230672731d-2*t124*t13*t60*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = t61*(2.473556743557577d-2*t1*(1.5979688
     1         668802342d+0*t10*t124*t15*t53*t58*t73*t74-7.9898443344011
     2         7d-1*t10*t131*t14*t58*t73*t74+7.98984433440117d-1*t10*t11
     3         3*t132*t14*t53*t73*t74-1.7121095002288222d-1*t10*t113*t12
     4         *t14*t53*(1.094359071222214d+0*t114*t115*t117*t124*t56*t7
     5         3+5.47179535611107d-1*t114*t115*t118*t129*t49*t54*t73-1.1
     6         72527576309515d-1*t117*t221*t55*t56+5.862637881547574d-1*
     7         t200*t216*t55*t56-5.862637881547574d-2*t118*t229*t49*t54*
     8         t55-5.862637881547574d-2*t118*t225*t49*t54*t55+1.75879136
     9         44642725d-1*t192*t201*t229*t54*t55+4.69011030523806d-1*t1
     :         17*t118*t124*t129*t49*t55+t231+t230+t228+t227+t226+t224+t
     ;         223+t222+t199+t198+t162+t161)+1.0272657001372934d+0*t10*t
     <         12*t216*t53*t54*t58-3.4242190004576445d-1*t10*t12*t15*t22
     =         1*t53*t58+1.7121095002288222d-1*t10*t12*t14*(t231+t230+t2
     >         28+t227+t226+t224+t223+t222+t162+t161)*t58-6.848438000915
     ?         289d-1*t10*t12*t124*t131*t15*t58+3.4242190004576445d-1*t1
     @         0*t12*t132**2*t14*t202*t53+6.848438000915289d-1*t10*t113*
     1         t12*t124*t132*t15*t53+t157+t155-3.4242190004576445d-1*t10
     2         *t113*t12*t131*t132*t14)*t9*wght+4.947113487115154d-2*t13
     3         3*t9*wght+1.4841340461345462d-1*t1*t124*t13*t133*wght)-2.
     4         473556743557577d-2*t1*t133**2*t140*t9*wght+1.484134046134
     5         5462d-1*t1*t216*t60*t8*wght+7.420670230672731d-2*t1*t13*t
     6         221*t60*wght+1.4841340461345462d-1*t124*t13*t60*wght+Amat
     7         2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = t240+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = t61*(2.473556743557577d-2*t1*(-1.71210
     1         95002288222d-1*t10*t113*t12*t14*t53*(-4.69011030523806d-1
     2         *t10*t117*t134*t56*t72-2.34505515261903d-1*t10*t110*t118*
     3         t134*t49*t54+t248+t247+t246+t245)-6.848438000915289d-1*t1
     4         2*t15*t53*t58*t72-1.172527576309515d-1*t10*t117*t134*t51*
     5         t58*t72+3.4242190004576445d-1*t10*t113*t12*t138*t15*t53*t
     6         72+1.7121095002288222d-1*t10*t12*t14*(t247+t246+t245)*t58
     7         +3.4242190004576445d-1*t112*t12*t14*t58-5.862637881547574
     8         d-2*t10*t113*t119*t134*t51*t54+3.4242190004576445d-1*t10*
     9         t119*t12*t138*t14*t202*t53-3.4242190004576445d-1*t113*t11
     :         9*t12*t14*t53+t244+t243+t242-1.7121095002288222d-1*t10*t1
     ;         12*t113*t12*t138*t14)*t9*wght+7.420670230672731d-2*t1*t13
     <         *t139*t72*wght+t241)-2.473556743557577d-2*t1*t120*t139*t1
     =         40*t9*wght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t240+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = t251+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = t61*(2.473556743557577d-2*t1*(-6.84843
     1         8000915289d-1*t12*t124*t15*t53*t58-1.172527576309515d-1*t
     2         10*t117*t124*t134*t51*t58+1.7121095002288222d-1*t10*t12*t
     3         14*(t253+t252+t246)*t58+3.4242190004576445d-1*t12*t131*t1
     4         4*t58-1.7121095002288222d-1*t10*t113*t12*t14*t53*(-4.6901
     5         1030523806d-1*t10*t117*t124*t134*t56-2.34505515261903d-1*
     6         t10*t118*t129*t134*t49*t54+t253+t252+t248+t246)-5.8626378
     7         81547574d-2*t10*t113*t132*t134*t51*t54+3.4242190004576445
     8         d-1*t10*t12*t132*t138*t14*t202*t53+3.4242190004576445d-1*
     9         t10*t113*t12*t124*t138*t15*t53-3.4242190004576445d-1*t113
     :         *t12*t132*t14*t53+t244+t243+t242-1.7121095002288222d-1*t1
     ;         0*t113*t12*t131*t138*t14)*t9*wght+7.420670230672731d-2*t1
     <         *t124*t13*t139*wght+t241)-2.473556743557577d-2*t1*t133*t1
     =         39*t140*t9*wght+Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = t251+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = t256+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = t257+Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t256+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 2.473556743557577d-2*t1*(2.3450551526
     1         1903d-1*t134*t51*t54*t58-4.014991205359592d-2*t10*t113*t1
     2         97*t200*t53*t56-1.172527576309515d-1*t10*t113*t134*t138*t
     3         51*t54+3.4242190004576445d-1*t10*t12*t138**2*t14*t202*t53
     4         -6.848438000915289d-1*t113*t12*t138*t14*t53)*t61*t9*wght-
     5         2.473556743557577d-2*t1*t139**2*t140*t9*wght+Cmat2(iq,D2_
     6         GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = t257+Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = t256+Cmat2(iq,D2_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1.530901310039024d-2*t5+1.0465751434d-1
            t7 = 7.876233178997433d-1*t5*t6+1.9269083139d-1
            t8 = 7.876233178997433d-1*t5*t7+4.3896648423d-1
            t9 = 1/t8
            t10 = 1.269642451250142d+0*t4*t9+1.0d+0
            t11 = log(t10)
            t12 = 1/t3
            t13 = 1.2746961887000874d-1*t12+1.0d+0
            t14 = 2.4141993114533214d-2*t5+1.0186556948d-1
            t15 = 7.876233178997433d-1*t14*t5+2.2308199064d-1
            t16 = 7.876233178997433d-1*t15*t5+4.7231125998d-1
            t17 = 1/t16
            t18 = 1.269642451250142d+0*t17*t4+1.0d+0
            t19 = log(t18)
            t20 = 1.325688999052018d-1*t12+1.0d+0
            t21 = 1.3212998810398843d-2*t5+2.9729725188d-2
            t22 = 7.876233178997433d-1*t21*t5+1.2236585478d-1
            t23 = 7.876233178997433d-1*t22*t5+3.497952466d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t24*t4+1.0d+0
            t26 = log(t25)
            t27 = 6.901399211255826d-2*t12+1.0d+0
            t28 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t19*t20-3.10907d-2*t11*t13)-3.37738d-2*t26*t27)+
     2         3.37738d-2*t26*t27)-6.21814d-2*t19*t20
            t29 = exp(-8.085523023512745d+1*t28)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.7178044217479813d-1*gammaaa*t2*t31
            t33 = t32+1.0d+0
            t34 = (gammaaa*t2)**2.0d+0
            t35 = 1/t30**2.0d+0
            t36 = 7.38646087487288d-2*t34*t35+t32+1.0d+0
            t37 = 1/t36
            t38 = 2.7178044217479813d-1*gammaaa*t2*t33*t37+1.0d+0
            t39 = log(t38)
            t40 = 1/t38
            t41 = rhoa**1.6666666666666674d-1
            t42 = 1/t1**3.0d+0
            t43 = -6.34154365074529d-1*gammaaa*t31*t41*t42
            t44 = 1/rhoa**1.3333333333333333d+0
            t45 = 1/t10
            t46 = 1/t8**2
            t47 = 1/rhoa**1.3333333333333336d+0
            t48 = 1/t4**3
            t49 = 1/rhoa**6.666666666666667d-1
            t50 = -1.3127055298329054d-1*t48*t49*t6-2.0096226153166658d-
     1         3*t47
            t51 = 7.876233178997433d-1*t5*t50-1.3127055298329054d-1*t48*
     1         t49*t7
            t52 = 2.11607075208357d-1*t49*t5*t9-1.269642451250142d+0*t4*
     1         t46*t51
            t53 = 1/t18
            t54 = 1/t16**2
            t55 = -1.3127055298329054d-1*t14*t48*t49-3.169132786263567d-
     1         3*t47
            t56 = 7.876233178997433d-1*t5*t55-1.3127055298329054d-1*t15*
     1         t48*t49
            t57 = 2.11607075208357d-1*t17*t49*t5-1.269642451250142d+0*t4
     1         *t54*t56
            t58 = 1/t25
            t59 = 1/t23**2
            t60 = -1.3127055298329054d-1*t21*t48*t49-1.7344776604086162d
     1         -3*t47
            t61 = 7.876233178997433d-1*t5*t60-1.3127055298329054d-1*t22*
     1         t48*t49
            t62 = 2.11607075208357d-1*t24*t49*t5-1.269642451250142d+0*t4
     1         *t59*t61
            t63 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t27*t58*t62+
     1         1.709920934161365d+0*(6.21814d-2*t20*t53*t57-3.10907d-2*t
     2         13*t45*t52-2.747773264188438d-3*t19*t44+1.321039893133926
     3         5d-3*t11*t44)+7.769549222703733d-4*t26*t44)+3.37738d-2*t2
     4         7*t58*t62-7.769549222703733d-4*t26*t44)-6.21814d-2*t20*t5
     5         3*t57+2.747773264188438d-3*t19*t44
            t64 = 1/t30**2
            t65 = 2.1974870225448048d+1*gammaaa*t2*t29*t63*t64
            t66 = t65+t43
            t67 = 1/t36**2
            t68 = gammaaa**2
            t69 = 1/t1**5.0d+0
            t70 = 1/t30**3.0d+0
            t71 = 1.1944679893212153d+1*t29*t34*t63*t70-3.44701507494067
     1         75d-1*t35*t41*t68*t69+t65+t43
            t72 = -2.7178044217479813d-1*gammaaa*t2*t33*t67*t71+2.717804
     1         4217479813d-1*gammaaa*t2*t37*t66-6.34154365074529d-1*gamm
     2         aaa*t33*t37*t41*t42
            t73 = 1/t1**4.0d+0
            t74 = 1.477292174974576d-1*gammaaa*t35*t73+2.717804421747981
     1         3d-1*t2*t31
            t75 = -2.7178044217479813d-1*gammaaa*t2*t33*t67*t74+7.386460
     1         874872879d-2*gammaaa*t31*t37*t73+2.7178044217479813d-1*t2
     2         *t33*t37
            t76 = 1/t38**2
            t77 = rhoa**3.333333333333335d-1
            t78 = 1/rhoa**8.333333333333333d-1
            t79 = t63**2
            t80 = exp(-1.617104604702549d+2*t28)
            t81 = 3.553566382931298d+3*gammaaa*t2*t79*t80/t30**3
            t82 = 2.2195402777608514d+0*gammaaa*t31*t73*t77
            t83 = -1.0569239417908823d-1*gammaaa*t31*t42*t78
            t84 = -1.0254939438542422d+2*gammaaa*t29*t41*t42*t63*t64
            t85 = -1.776783191465649d+3*gammaaa*t2*t29*t64*t79
            t86 = 1/rhoa**2.333333333333333d+0
            t87 = 1/rhoa**2.3333333333333334d+0
            t88 = 1/rhoa**1.6666666666666669d+0
            t89 = 1/t4**5
            t90 = 1/t18**2
            t91 = t57**2
            t92 = -1.269642451250142d+0*t4*t54*(7.876233178997433d-1*t5*
     1         (6.563527649164527d-2*t14*t47*t89+8.751370198886037d-2*t1
     2         4*t48*t88+4.753699179395351d-3*t87)+6.563527649164527d-2*
     3         t15*t47*t89+8.751370198886037d-2*t15*t48*t88-2.6254110596
     4         65811d-1*t48*t49*t55)-1.4107138347223802d-1*t17*t5*t88+2.
     5         539284902500284d+0*t4*t56**2/t16**3-4.23214150416714d-1*t
     6         49*t5*t54*t56-3.52678458680595d-2*t17*t47*t48
            t93 = 1/t25**2
            t94 = t62**2
            t95 = -1.269642451250142d+0*t4*t59*(7.876233178997433d-1*t5*
     1         (6.563527649164527d-2*t21*t47*t89+8.751370198886037d-2*t2
     2         1*t48*t88+2.601716490612924d-3*t87)+6.563527649164527d-2*
     3         t22*t47*t89+8.751370198886037d-2*t22*t48*t88-2.6254110596
     4         65811d-1*t48*t49*t60)-1.4107138347223802d-1*t24*t5*t88+2.
     5         539284902500284d+0*t4*t61**2/t23**3-4.23214150416714d-1*t
     6         49*t5*t59*t61-3.52678458680595d-2*t24*t47*t48
            t96 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t27*t58*t95+
     1         3.37738d-2*t27*t93*t94+1.709920934161365d+0*(6.21814d-2*t
     2         20*t53*t92-6.21814d-2*t20*t90*t91-3.10907d-2*t13*t45*(-1.
     3         4107138347223802d-1*t5*t88*t9-3.52678458680595d-2*t47*t48
     4         *t9-1.269642451250142d+0*t4*t46*(7.876233178997433d-1*t5*
     5         (6.563527649164527d-2*t47*t6*t89+8.751370198886037d-2*t48
     6         *t6*t88+3.0144339229749983d-3*t87)+6.563527649164527d-2*t
     7         47*t7*t89+8.751370198886037d-2*t48*t7*t88-2.6254110596658
     8         11d-1*t48*t49*t50)+2.539284902500284d+0*t4*t51**2/t8**3-4
     9         .23214150416714d-1*t46*t49*t5*t51)+3.663697685584584d-3*t
     :         19*t86-1.7613865241785687d-3*t11*t86-5.495546528376876d-3
     ;         *t44*t53*t57+3.10907d-2*t13*t52**2/t10**2+2.6420797862678
     <         53d-3*t44*t45*t52)-1.0359398963604977d-3*t26*t86+1.553909
     =         8445407465d-3*t44*t58*t62)+3.37738d-2*t27*t58*t95-3.37738
     >         d-2*t27*t93*t94+1.0359398963604977d-3*t26*t86-1.553909844
     ?         5407465d-3*t44*t58*t62)-6.21814d-2*t20*t53*t92+6.21814d-2
     @         *t20*t90*t91-3.663697685584584d-3*t19*t86+5.4955465283768
     1         76d-3*t44*t53*t57
            t97 = 2.1974870225448048d+1*gammaaa*t2*t29*t64*t96
            t98 = 1/t1**6.0d+0
            t99 = 1/t36**3
            t100 = -6.34154365074529d-1*t31*t41*t42
            t101 = 2.1974870225448048d+1*t2*t29*t63*t64
            fnc(iq) = 1.2367783717787881d-2*rhoa*t39*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.2367783717787881d-2*rhoa*t40*t72*wght+1.2
     1         367783717787881d-2*t39*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.2367783717787881d-2*rhoa*t40*t75*wght+Cm
     1         at(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = t40*(1.2367783717787881d-2*rhoa*(5.4356
     1         08843495963d-1*gammaaa*t2*t33*t71**2*t99-2.71780442174798
     2         13d-1*gammaaa*t2*t33*t67*(2.0107587937153953d+0*t35*t68*t
     3         77*t98+t97+1.1944679893212153d+1*t29*t34*t70*t96+t85+t84+
     4         t83+t82+t81+2.897369528551698d+3*t34*t79*t80/t30**4.0d+0-
     5         9.657898428505661d+2*t29*t34*t70*t79-5.745025124901132d-2
     6         *t35*t68*t69*t78-1.1148367900331342d+2*t29*t41*t63*t68*t6
     7         9*t70)+2.7178044217479813d-1*gammaaa*t2*t37*(t97+t85+t84+
     8         t83+t82+t81)-1.0569239417908823d-1*gammaaa*t33*t37*t42*t7
     9         8+2.2195402777608514d+0*gammaaa*t33*t37*t73*t77-5.4356088
     :         43495963d-1*gammaaa*t2*t66*t67*t71+1.268308730149058d+0*g
     ;         ammaaa*t33*t41*t42*t67*t71-1.268308730149058d+0*gammaaa*t
     <         37*t41*t42*t66)*wght+2.4735567435575762d-2*t72*wght)-1.23
     =         67783717787881d-2*rhoa*t72**2*t76*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = t40*(1.2367783717787881d-2*rhoa*(5.435
     1         608843495963d-1*gammaaa*t2*t33*t71*t74*t99-2.717804421747
     2         9813d-1*gammaaa*t2*t66*t67*t74+6.34154365074529d-1*gammaa
     3         a*t33*t41*t42*t67*t74-2.7178044217479813d-1*gammaaa*t2*t3
     4         3*t67*(2.3889359786424305d+1*gammaaa*t29*t63*t70*t73-6.89
     5         4030149881355d-1*gammaaa*t35*t41*t69+t101+t100)-7.3864608
     6         74872879d-2*gammaaa*t31*t67*t71*t73-2.7178044217479813d-1
     7         *t2*t33*t67*t71-1.7235075374703387d-1*gammaaa*t31*t37*t41
     8         *t69+2.7178044217479813d-1*t2*t37*t66-6.34154365074529d-1
     9         *t33*t37*t41*t42+2.7178044217479813d-1*gammaaa*(t101+t100
     :         )*t2*t37)*wght+1.2367783717787881d-2*t75*wght)-1.23677837
     ;         17787881d-2*rhoa*t72*t75*t76*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.2367783717787881d-2*rhoa*t40*(5.435
     1         608843495963d-1*gammaaa*t2*t33*t74**2*t99-4.0149912053595
     2         95d-2*gammaaa*t33*t35*t67*t98-1.4772921749745757d-1*gamma
     3         aa*t31*t67*t73*t74-5.435608843495963d-1*t2*t33*t67*t74+1.
     4         4772921749745757d-1*t31*t37*t73)*wght-1.2367783717787881d
     5         -2*rhoa*t75**2*t76*wght+Cmat2(iq,D2_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhob**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1.530901310039024d-2*t5+1.0465751434d-1
            t7 = 7.876233178997433d-1*t5*t6+1.9269083139d-1
            t8 = 7.876233178997433d-1*t5*t7+4.3896648423d-1
            t9 = 1/t8
            t10 = 1.269642451250142d+0*t4*t9+1.0d+0
            t11 = log(t10)
            t12 = 1/t3
            t13 = 1.2746961887000874d-1*t12+1.0d+0
            t14 = 2.4141993114533214d-2*t5+1.0186556948d-1
            t15 = 7.876233178997433d-1*t14*t5+2.2308199064d-1
            t16 = 7.876233178997433d-1*t15*t5+4.7231125998d-1
            t17 = 1/t16
            t18 = 1.269642451250142d+0*t17*t4+1.0d+0
            t19 = log(t18)
            t20 = 1.325688999052018d-1*t12+1.0d+0
            t21 = 1.3212998810398843d-2*t5+2.9729725188d-2
            t22 = 7.876233178997433d-1*t21*t5+1.2236585478d-1
            t23 = 7.876233178997433d-1*t22*t5+3.497952466d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t24*t4+1.0d+0
            t26 = log(t25)
            t27 = 6.901399211255826d-2*t12+1.0d+0
            t28 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t19*t20-3.10907d-2*t11*t13)-3.37738d-2*t26*t27)+
     2         3.37738d-2*t26*t27)-6.21814d-2*t19*t20
            t29 = exp(-8.085523023512745d+1*t28)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.7178044217479813d-1*gammabb*t2*t31
            t33 = t32+1.0d+0
            t34 = (gammabb*t2)**2.0d+0
            t35 = 1/t30**2.0d+0
            t36 = 7.38646087487288d-2*t34*t35+t32+1.0d+0
            t37 = 1/t36
            t38 = 2.7178044217479813d-1*gammabb*t2*t33*t37+1.0d+0
            t39 = log(t38)
            t40 = 1/t38
            t41 = rhob**1.6666666666666674d-1
            t42 = 1/t1**3.0d+0
            t43 = -6.34154365074529d-1*gammabb*t31*t41*t42
            t44 = 1/rhob**1.3333333333333333d+0
            t45 = 1/t10
            t46 = 1/t8**2
            t47 = 1/rhob**1.3333333333333336d+0
            t48 = 1/t4**3
            t49 = 1/rhob**6.666666666666667d-1
            t50 = -1.3127055298329054d-1*t48*t49*t6-2.0096226153166658d-
     1         3*t47
            t51 = 7.876233178997433d-1*t5*t50-1.3127055298329054d-1*t48*
     1         t49*t7
            t52 = 2.11607075208357d-1*t49*t5*t9-1.269642451250142d+0*t4*
     1         t46*t51
            t53 = 1/t18
            t54 = 1/t16**2
            t55 = -1.3127055298329054d-1*t14*t48*t49-3.169132786263567d-
     1         3*t47
            t56 = 7.876233178997433d-1*t5*t55-1.3127055298329054d-1*t15*
     1         t48*t49
            t57 = 2.11607075208357d-1*t17*t49*t5-1.269642451250142d+0*t4
     1         *t54*t56
            t58 = 1/t25
            t59 = 1/t23**2
            t60 = -1.3127055298329054d-1*t21*t48*t49-1.7344776604086162d
     1         -3*t47
            t61 = 7.876233178997433d-1*t5*t60-1.3127055298329054d-1*t22*
     1         t48*t49
            t62 = 2.11607075208357d-1*t24*t49*t5-1.269642451250142d+0*t4
     1         *t59*t61
            t63 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t27*t58*t62+
     1         1.709920934161365d+0*(6.21814d-2*t20*t53*t57-3.10907d-2*t
     2         13*t45*t52-2.747773264188438d-3*t19*t44+1.321039893133926
     3         5d-3*t11*t44)+7.769549222703733d-4*t26*t44)+3.37738d-2*t2
     4         7*t58*t62-7.769549222703733d-4*t26*t44)-6.21814d-2*t20*t5
     5         3*t57+2.747773264188438d-3*t19*t44
            t64 = 1/t30**2
            t65 = 2.1974870225448048d+1*gammabb*t2*t29*t63*t64
            t66 = t65+t43
            t67 = 1/t36**2
            t68 = gammabb**2
            t69 = 1/t1**5.0d+0
            t70 = 1/t30**3.0d+0
            t71 = 1.1944679893212153d+1*t29*t34*t63*t70-3.44701507494067
     1         75d-1*t35*t41*t68*t69+t65+t43
            t72 = -2.7178044217479813d-1*gammabb*t2*t33*t67*t71+2.717804
     1         4217479813d-1*gammabb*t2*t37*t66-6.34154365074529d-1*gamm
     2         abb*t33*t37*t41*t42
            t73 = 1/t1**4.0d+0
            t74 = 1.477292174974576d-1*gammabb*t35*t73+2.717804421747981
     1         3d-1*t2*t31
            t75 = -2.7178044217479813d-1*gammabb*t2*t33*t67*t74+7.386460
     1         874872879d-2*gammabb*t31*t37*t73+2.7178044217479813d-1*t2
     2         *t33*t37
            t76 = 1/t38**2
            t77 = rhob**3.333333333333335d-1
            t78 = 1/rhob**8.333333333333333d-1
            t79 = t63**2
            t80 = exp(-1.617104604702549d+2*t28)
            t81 = 3.553566382931298d+3*gammabb*t2*t79*t80/t30**3
            t82 = 2.2195402777608514d+0*gammabb*t31*t73*t77
            t83 = -1.0569239417908823d-1*gammabb*t31*t42*t78
            t84 = -1.0254939438542422d+2*gammabb*t29*t41*t42*t63*t64
            t85 = -1.776783191465649d+3*gammabb*t2*t29*t64*t79
            t86 = 1/rhob**2.333333333333333d+0
            t87 = 1/rhob**2.3333333333333334d+0
            t88 = 1/rhob**1.6666666666666669d+0
            t89 = 1/t4**5
            t90 = 1/t18**2
            t91 = t57**2
            t92 = -1.269642451250142d+0*t4*t54*(7.876233178997433d-1*t5*
     1         (6.563527649164527d-2*t14*t47*t89+8.751370198886037d-2*t1
     2         4*t48*t88+4.753699179395351d-3*t87)+6.563527649164527d-2*
     3         t15*t47*t89+8.751370198886037d-2*t15*t48*t88-2.6254110596
     4         65811d-1*t48*t49*t55)-1.4107138347223802d-1*t17*t5*t88+2.
     5         539284902500284d+0*t4*t56**2/t16**3-4.23214150416714d-1*t
     6         49*t5*t54*t56-3.52678458680595d-2*t17*t47*t48
            t93 = 1/t25**2
            t94 = t62**2
            t95 = -1.269642451250142d+0*t4*t59*(7.876233178997433d-1*t5*
     1         (6.563527649164527d-2*t21*t47*t89+8.751370198886037d-2*t2
     2         1*t48*t88+2.601716490612924d-3*t87)+6.563527649164527d-2*
     3         t22*t47*t89+8.751370198886037d-2*t22*t48*t88-2.6254110596
     4         65811d-1*t48*t49*t60)-1.4107138347223802d-1*t24*t5*t88+2.
     5         539284902500284d+0*t4*t61**2/t23**3-4.23214150416714d-1*t
     6         49*t5*t59*t61-3.52678458680595d-2*t24*t47*t48
            t96 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t27*t58*t95+
     1         3.37738d-2*t27*t93*t94+1.709920934161365d+0*(6.21814d-2*t
     2         20*t53*t92-6.21814d-2*t20*t90*t91-3.10907d-2*t13*t45*(-1.
     3         4107138347223802d-1*t5*t88*t9-3.52678458680595d-2*t47*t48
     4         *t9-1.269642451250142d+0*t4*t46*(7.876233178997433d-1*t5*
     5         (6.563527649164527d-2*t47*t6*t89+8.751370198886037d-2*t48
     6         *t6*t88+3.0144339229749983d-3*t87)+6.563527649164527d-2*t
     7         47*t7*t89+8.751370198886037d-2*t48*t7*t88-2.6254110596658
     8         11d-1*t48*t49*t50)+2.539284902500284d+0*t4*t51**2/t8**3-4
     9         .23214150416714d-1*t46*t49*t5*t51)+3.663697685584584d-3*t
     :         19*t86-1.7613865241785687d-3*t11*t86-5.495546528376876d-3
     ;         *t44*t53*t57+3.10907d-2*t13*t52**2/t10**2+2.6420797862678
     <         53d-3*t44*t45*t52)-1.0359398963604977d-3*t26*t86+1.553909
     =         8445407465d-3*t44*t58*t62)+3.37738d-2*t27*t58*t95-3.37738
     >         d-2*t27*t93*t94+1.0359398963604977d-3*t26*t86-1.553909844
     ?         5407465d-3*t44*t58*t62)-6.21814d-2*t20*t53*t92+6.21814d-2
     @         *t20*t90*t91-3.663697685584584d-3*t19*t86+5.4955465283768
     1         76d-3*t44*t53*t57
            t97 = 2.1974870225448048d+1*gammabb*t2*t29*t64*t96
            t98 = 1/t1**6.0d+0
            t99 = 1/t36**3
            t100 = -6.34154365074529d-1*t31*t41*t42
            t101 = 2.1974870225448048d+1*t2*t29*t63*t64
            fnc(iq) = 1.2367783717787881d-2*rhob*t39*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.2367783717787881d-2*rhob*t40*t72*wght+1.2
     1         367783717787881d-2*t39*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.2367783717787881d-2*rhob*t40*t75*wght+Cm
     1         at(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = t40*(1.2367783717787881d-2*rhob*(5.4356
     1         08843495963d-1*gammabb*t2*t33*t71**2*t99-2.71780442174798
     2         13d-1*gammabb*t2*t33*t67*(2.0107587937153953d+0*t35*t68*t
     3         77*t98+t97+1.1944679893212153d+1*t29*t34*t70*t96+t85+t84+
     4         t83+t82+t81+2.897369528551698d+3*t34*t79*t80/t30**4.0d+0-
     5         9.657898428505661d+2*t29*t34*t70*t79-5.745025124901132d-2
     6         *t35*t68*t69*t78-1.1148367900331342d+2*t29*t41*t63*t68*t6
     7         9*t70)+2.7178044217479813d-1*gammabb*t2*t37*(t97+t85+t84+
     8         t83+t82+t81)-1.0569239417908823d-1*gammabb*t33*t37*t42*t7
     9         8+2.2195402777608514d+0*gammabb*t33*t37*t73*t77-5.4356088
     :         43495963d-1*gammabb*t2*t66*t67*t71+1.268308730149058d+0*g
     ;         ammabb*t33*t41*t42*t67*t71-1.268308730149058d+0*gammabb*t
     <         37*t41*t42*t66)*wght+2.4735567435575762d-2*t72*wght)-1.23
     =         67783717787881d-2*rhob*t72**2*t76*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = t40*(1.2367783717787881d-2*rhob*(5.435
     1         608843495963d-1*gammabb*t2*t33*t71*t74*t99-2.717804421747
     2         9813d-1*gammabb*t2*t66*t67*t74+6.34154365074529d-1*gammab
     3         b*t33*t41*t42*t67*t74-2.7178044217479813d-1*gammabb*t2*t3
     4         3*t67*(2.3889359786424305d+1*gammabb*t29*t63*t70*t73-6.89
     5         4030149881355d-1*gammabb*t35*t41*t69+t101+t100)-7.3864608
     6         74872879d-2*gammabb*t31*t67*t71*t73-2.7178044217479813d-1
     7         *t2*t33*t67*t71-1.7235075374703387d-1*gammabb*t31*t37*t41
     8         *t69+2.7178044217479813d-1*t2*t37*t66-6.34154365074529d-1
     9         *t33*t37*t41*t42+2.7178044217479813d-1*gammabb*(t101+t100
     :         )*t2*t37)*wght+1.2367783717787881d-2*t75*wght)-1.23677837
     ;         17787881d-2*rhob*t72*t75*t76*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.2367783717787881d-2*rhob*t40*(5.435
     1         608843495963d-1*gammabb*t2*t33*t74**2*t99-4.0149912053595
     2         95d-2*gammabb*t33*t35*t67*t98-1.4772921749745757d-1*gamma
     3         bb*t31*t67*t73*t74-5.435608843495963d-1*t2*t33*t67*t74+1.
     4         4772921749745757d-1*t31*t37*t73)*wght-1.2367783717787881d
     5         -2*rhob*t75**2*t76*wght+Cmat2(iq,D2_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_p91 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_4} &=& 1.0-{\it t_2}\,{\it t_3}\\\\ 
C>   {\it t_5} &=& {\it t_2}\,{\it t_3}+1.0\\\\ 
C>   {\it t_6} &=& 0.5\,{\it t_5}^{{{2}\over{3}}}+0.5\,{
C>    \it t_4}^{{{2}\over{3}}}\\\\ 
C>   {\it t_7} &=& {\it t_6}^{3.0}\\\\ 
C>   {\it t_8} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_6}^{2.0}}}\\\\ 
C>   {\it t_{10}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{11}} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{13}} &=& 0.1325688999052018\,{\it t_{12}}+1.0\\\\ 
C>   {\it t_{14}} &=& \sqrt{{\it t_{11}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{14}}}}\\\\ 
C>   {\it t_{16}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{14}}}\over{0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.02414199311453321\,{\it t_{15}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{17}} &=& 0.06901399211255826\,{\it t_{12}}+1.0\\\\ 
C>   {\it t_{18}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{14}}}\over{0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.01321299881039884\,{\it t_{15}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{19}} &=& {{1}\over{e^{{{40.42761511756372\,
C>    \left(0.5848223622634648\,\left(1.923661050931536\,{
C>    \it t_5}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_4}^{{{4}\over{3}}}-3.847322101863072\right)\,\left({{{
C>    \it t_2}^4\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_{13}}\,{\it t_{16}}-0.0310907\,\left(0.1274696188700087
C>    \,{\it t_{12}}+1.0\right)\,\log \left({{1.269642451250142\,{
C>    \it t_{14}}}\over{0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.7876233178997433\,{\it t_{15}}\,
C>    \left(0.01530901310039024\,{\it t_{15}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{17}}\,{\it t_{18}}\right)}\over{{
C>    \it t_1}^4}}+0.0337738\,{\it t_{17}}\,{\it t_{18}}\right)
C>    -0.0621814\,{\it t_{13}}\,{\it t_{16}}\right)}\over{{
C>    \it t_7}}}}}}-1.0\\\\ 
C>   {\it t_{20}} &=& {{0.1712109500228822\,{\it t_8}\,{\it t_9}
C>    \,{\it t_{10}}}\over{{\it t_{19}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{22}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{23}} &=& \sqrt{{\it t_{22}}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_{23}}}}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{{\it t_{22}}}}\\\\ 
C>   {\it t_{26}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{24}}+0.10186556948\right)
C>    \,{\it t_{24}}+0.22308199064\right)\,{\it t_{24}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{27}} &=& 0.1325688999052018\,{\it t_{25}}+1.0\\\\ 
C>   {\it t_{28}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{23}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{24}}
C>    +0.029729725188\right)\,{\it t_{24}}+0.12236585478\right)\,{
C>    \it t_{24}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{29}} &=& 0.06901399211255826\,{\it t_{25}}+1.0\\\\ 
C>   {\it t_{30}} &=& {{1}\over{e^{80.85523023512745\,
C>    \left(0.5848223622634643\,\left(0.0337738\,{\it t_{28}}\,{
C>    \it t_{29}}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_{26}}\,{\it t_{27}}-0.0310907\,\log 
C>    \left({{1.269642451250142\,{\it t_{23}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{24}}+0.10465751434\right)
C>    \,{\it t_{24}}+0.19269083139\right)\,{\it t_{24}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{25}}+1.0\right)\right)-0.0337738\,{\it t_{28}}\,{
C>    \it t_{29}}\right)\right)-0.0621814\,{\it t_{26}}\,{
C>    \it t_{27}}\right)}}}-1.0\\\\ 
C>   {\it t_{31}} &=& {{0.2717804421747981\,{\it t_{21}}\,
C>    \sigma_{ss}}\over{{\it t_{30}}}}\\\\ 
C>   f &=& 0.02473556743557577\,{\it t_1}\,{\it t_7}\,\log 
C>    \left({{0.1712109500228822\,{\it t_8}\,{\it t_9}\,{\it t_{10}}
C>    \,\left({\it t_{20}}+1.0\right)}\over{{{0.02931318940773787
C>    \,\left({\it t_8}\,{\it t_{10}}\right)^{2.0}}\over{{
C>    \it t_6}^{4.0}\,{\it t_{19}}^{2.0}}}+{\it t_{20}}+1.0}}
C>    +1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.01236778371778788\,\rho_s\,\log 
C>    \left({{0.2717804421747981\,{\it t_{21}}\,\sigma_{ss}\,
C>    \left({\it t_{31}}+1.0\right)}\over{{{0.0738646087487288
C>    \,\left({\it t_{21}}\,\sigma_{ss}\right)^{2.0}}\over{{
C>    \it t_{30}}^{2.0}}}+{\it t_{31}}+1.0}}+1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] JP Perdew, JA Chevary, SH Vosko, KA Jackson, MR Pederson
C>    , DJ Singh, C. Fiolhais, Phys.Rev. B 46, 6671 (1992)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/jp050536c "> 
C> 10.1021/jp050536c </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_p91_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,*)  !< [Output] The 3rd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = exp(2.5138457066712766d+0*log(1.4251254664507676d+0*t4/
     1         (7.016926042943223d-1*t5*(7.016926042943223d-1*(2.1508070
     2         71909054d-2*t5+1.0186556948d-1)*t5+2.2308199064d-1)+4.723
     3         1125998d-1)+1.0d+0)*(1.0522000558389215d-1*t6+1.0d+0))-1.
     4         0d+0
            t8 = 1.35890221087399d-1*gammaaa*t2/t7
            t9 = (gammaaa*t2)**2.0d+0
            t10 = 2.1508070719090538d-2*t5+1.0186556948d-1
            t11 = 7.016926042943222d-1*t10*t5+2.2308199064d-1
            t12 = 7.016926042943222d-1*t11*t5+4.7231125998d-1
            t13 = 1/t12
            t14 = 1.425125466450768d+0*t13*t4+1.0d+0
            t15 = log(t14)
            t16 = 1.0522000558389213d-1*t6+1.0d+0
            t17 = exp(2.5138457066712766d+0*t15*t16)
            t18 = t17-1.0d+0
            t19 = 1/t18
            t20 = 1.3589022108739904d-1*gammaaa*t19*t2
            t21 = t20+1.0d+0
            t22 = 1/t18**2.0d+0
            t23 = 1.8466152187182186d-2*t22*t9+t20+1.0d+0
            t24 = 1/t23
            t25 = 1.3589022108739904d-1*gammaaa*t2*t21*t24+1.0d+0
            t26 = 1/t25
            t27 = rhoa**1.6666666666666674d-1
            t28 = 1/t1**3.0d+0
            t29 = -1.585385912686322d-1*gammaaa*t19*t27*t28
            t30 = 1/rhoa**1.3333333333333333d+0
            t31 = 1/t14
            t32 = 1/t12**2
            t33 = 1/rhoa**1.3333333333333336d+0
            t34 = 1/t4**3
            t35 = 1/rhoa**6.666666666666667d-1
            t36 = -5.847438369119352d-2*t10*t34*t35-1.2576711796854242d-
     1         3*t33
            t37 = 7.016926042943222d-1*t36*t5-5.847438369119352d-2*t11*t
     1         34*t35
            t38 = 1.1876045553756398d-1*t13*t35*t5-1.425125466450768d+0*
     1         t32*t37*t4
            t39 = 1.090454542535705d-3*t15*t30-6.21814d-2*t16*t31*t38
            t40 = 1/t18**2
            t41 = 5.493717556362009d+0*gammaaa*t17*t2*t39*t40
            t42 = t41+t29
            t43 = 1/t23**2
            t44 = gammaaa**2
            t45 = 1/t1**5.0d+0
            t46 = 1/t18**3.0d+0
            t47 = 1.4930849866515178d+0*t17*t39*t46*t9-4.308768843675843
     1         d-2*t22*t27*t44*t45+t41+t29
            t48 = -1.3589022108739904d-1*gammaaa*t2*t21*t43*t47+1.358902
     1         2108739904d-1*gammaaa*t2*t24*t42-1.585385912686322d-1*gam
     2         maaa*t21*t24*t27*t28
            t49 = log(t25)
            t50 = 1/t1**4.0d+0
            t51 = 9.233076093591093d-3*gammaaa*t22*t50+3.397255527184976
     1         d-2*t19*t2
            t52 = -1.3589022108739904d-1*gammaaa*t2*t21*t43*t51+4.616538
     1         0467955464d-3*gammaaa*t19*t24*t50+3.397255527184976d-2*t2
     2         *t21*t24
            t53 = 1.8466152187182186d-2*gammaaa*t22*t50+6.79451105436995
     1         2d-2*t19*t2
            t54 = -1.3589022108739904d-1*gammaaa*t2*t21*t43*t53+9.233076
     1         093591093d-3*gammaaa*t19*t24*t50+6.794511054369952d-2*t2*
     2         t21*t24
            t55 = 1/t25**2
            t56 = t48**2
            t57 = -4.947113487115154d-2*rhoa*t55*t56*wght
            t58 = 1/rhoa
            t59 = 4.947113487115154d-2*t48*wght
            t60 = rhoa**3.333333333333335d-1
            t61 = 2.774425347201063d-1*gammaaa*t21*t24*t50*t60
            t62 = 1/rhoa**8.333333333333333d-1
            t63 = -1.321154927238602d-2*gammaaa*t21*t24*t28*t62
            t64 = 1/rhoa**2
            t65 = -3.170771825372644d-1*gammaaa*t24*t27*t28*t42
            t66 = 3.170771825372644d-1*gammaaa*t21*t27*t28*t43*t47
            t67 = -2.717804421747981d-1*gammaaa*t2*t42*t43*t47
            t68 = 1/t23**3
            t69 = t47**2
            t70 = 2.717804421747981d-1*gammaaa*t2*t21*t68*t69
            t71 = 2.774425347201063d-1*gammaaa*t19*t50*t60
            t72 = -1.321154927238602d-2*gammaaa*t19*t28*t62
            t73 = 1.5098913454155444d-2*gammaaa*t19*t2*t64
            t74 = -1.281867429817802d+1*gammaaa*t17*t27*t28*t39*t40
            t75 = t39**2
            t76 = -2.2209789893320597d+2*gammaaa*t17*t2*t40*t75
            t77 = 1/rhoa**2.333333333333333d+0
            t78 = -7.269696950238034d-4*t15*t77
            t79 = 1.1771443702974158d-2*t5+2.9729725188d-2
            t80 = 7.016926042943222d-1*t5*t79+1.2236585478d-1
            t81 = 7.016926042943222d-1*t5*t80+3.497952466d-1
            t82 = 1/t81
            t83 = 1.425125466450768d+0*t4*t82+1.0d+0
            t84 = log(t83)
            t85 = 5.477644184000001d-2*t6+1.0d+0
            t86 = 2.18090908507141d-3*t30*t31*t38
            t87 = 1/t14**2
            t88 = t38**2
            t89 = 6.21814d-2*t16*t87*t88
            t90 = 1/t12**3
            t91 = t37**2
            t92 = 1/rhoa**2.3333333333333334d+0
            t93 = 1/rhoa**1.6666666666666669d+0
            t94 = 1/t4**5
            t95 = 1.4618595922798375d-2*t10*t33*t94+1.949146123039784d-2
     1         *t10*t34*t93+9.432533847640683d-4*t92
            t96 = 7.016926042943222d-1*t5*t95+1.4618595922798375d-2*t11*
     1         t33*t94+1.949146123039784d-2*t11*t34*t93-1.16948767382387
     2         03d-1*t34*t35*t36
            t97 = -1.425125466450768d+0*t32*t4*t96-3.9586818512521327d-2
     1         *t13*t5*t93+2.850250932901536d+0*t4*t90*t91-2.37520911075
     2         12796d-1*t32*t35*t37*t5-9.896704628130328d-3*t13*t33*t34
            t98 = -6.21814d-2*t16*t31*t97
            t99 = 4.189742844452126d-1*t15*t16*t64-4.042761511756372d+1*
     1         (t98+t89+t86+8.443450000000001d-3*t64*t84*t85+t78)
            t100 = -1.3589022108739904d-1*gammaaa*t17*t2*t40*t99
            t101 = 1/t18**3
            t102 = exp(5.027691413342553d+0*t15*t16)
            t103 = 4.4419579786641195d+2*gammaaa*t101*t102*t2*t75
            t104 = t76+t74+t73+t72+t71+t103+t100
            t105 = 1/t1**6.0d+0
            t106 = 1.2567242460721215d-1*t105*t22*t44*t60
            t107 = -3.590640703063204d-3*t22*t44*t45*t62
            t108 = -6.967729937707083d+0*t17*t27*t39*t44*t45*t46
            t109 = 1/t18**4.0d+0
            t110 = 1.8108559553448098d+2*t102*t109*t75*t9
            t111 = -3.693230437436437d-2*t17*t46*t9*t99-6.03618651781603
     1         2d+1*t17*t46*t75*t9+4.1035893749293734d-3*t22*t64*t9+t76+
     2         t74+t73+t72+t71+t110+t108+t107+t106+t103+t100
            t112 = t70+t67+t66+t65+1.5098913454155444d-2*gammaaa*t2*t21*
     1         t24*t64+t63+t61-1.3589022108739904d-1*gammaaa*t111*t2*t21
     2         *t43+1.3589022108739904d-1*gammaaa*t104*t2*t24
            t113 = 4.947113487115154d-2*rhoa*t112*wght+t59
            t114 = -1.509891345415545d-2*gammaaa*t19*t2*t64
            t115 = -2.2209789893320595d+2*gammaaa*t17*t2*t40*t75
            t116 = -4.042761511756372d+1*(t98+t89+t86-8.44345d-3*t64*t84
     1         *t85+t78)-4.1897428444521273d-1*t15*t16*t64
            t117 = -1.3589022108739904d-1*gammaaa*t116*t17*t2*t40
            t118 = 4.441957978664119d+2*gammaaa*t101*t102*t2*t75
            t119 = t74+t72+t71+t118+t117+t115+t114
            t120 = -6.036186517816031d+1*t17*t46*t75*t9-4.10358937492937
     1         45d-3*t22*t64*t9-3.693230437436437d-2*t116*t17*t46*t9+t74
     2         +t72+t71+t118+t117+t115+t114+t110+t108+t107+t106
            t121 = t70+t67+t66+t65-1.509891345415545d-2*gammaaa*t2*t21*t
     1         24*t64+t63+t61-1.3589022108739904d-1*gammaaa*t120*t2*t21*
     2         t43+1.3589022108739904d-1*gammaaa*t119*t2*t24
            t122 = 4.947113487115154d-2*rhoa*t121*wght+t59
            t123 = -3.9634647817158053d-2*t19*t27*t28
            t124 = 1.3734293890905022d+0*t17*t2*t39*t40
            t125 = t124+t123
            t126 = 7.465424933257588d-1*gammaaa*t17*t39*t46*t50-2.154384
     1         4218379216d-2*gammaaa*t22*t27*t45+t124+t123
            t127 = 2.717804421747981d-1*gammaaa*t2*t21*t47*t51*t68-1.358
     1         9022108739904d-1*gammaaa*t2*t42*t43*t51+1.585385912686322
     2         d-1*gammaaa*t21*t27*t28*t43*t51-4.6165380467955464d-3*gam
     3         maaa*t19*t43*t47*t50-3.397255527184976d-2*t2*t21*t43*t47-
     4         5.385961054594804d-3*gammaaa*t19*t24*t27*t45-1.3589022108
     5         739904d-1*gammaaa*t126*t2*t21*t43+3.397255527184976d-2*t2
     6         *t24*t42-3.9634647817158053d-2*t21*t24*t27*t28+1.35890221
     7         08739904d-1*gammaaa*t125*t2*t24
            t128 = 2.473556743557577d-2*t52*wght+4.947113487115154d-2*rh
     1         oa*t127*wght
            t129 = t128*t26-4.947113487115154d-2*rhoa*t48*t52*t55*wght
            t130 = -7.926929563431611d-2*t19*t27*t28
            t131 = 2.7468587781810044d+0*t17*t2*t39*t40
            t132 = t131+t130
            t133 = 1.4930849866515178d+0*gammaaa*t17*t39*t46*t50-4.30876
     1         8843675843d-2*gammaaa*t22*t27*t45+t131+t130
            t134 = 2.717804421747981d-1*gammaaa*t2*t21*t47*t53*t68-1.358
     1         9022108739904d-1*gammaaa*t2*t42*t43*t53+1.585385912686322
     2         d-1*gammaaa*t21*t27*t28*t43*t53-9.233076093591093d-3*gamm
     3         aaa*t19*t43*t47*t50-6.794511054369952d-2*t2*t21*t43*t47-1
     4         .0771922109189608d-2*gammaaa*t19*t24*t27*t45-1.3589022108
     5         739904d-1*gammaaa*t133*t2*t21*t43+6.794511054369952d-2*t2
     6         *t24*t42-7.926929563431611d-2*t21*t24*t27*t28+1.358902210
     7         8739904d-1*gammaaa*t132*t2*t24
            t135 = 2.473556743557577d-2*t54*wght+4.947113487115154d-2*rh
     1         oa*t134*wght
            t136 = t52**2
            t137 = t51**2
            t138 = -6.794511054369952d-2*t2*t21*t43*t51
            t139 = -9.233076093591093d-3*gammaaa*t19*t43*t50*t51
            t140 = 2.717804421747981d-1*gammaaa*t137*t2*t21*t68+2.308269
     1         0233977732d-3*t19*t24*t50-3.136711879187181d-4*gammaaa*t1
     2         05*t21*t22*t43+t139+t138
            t141 = 4.947113487115154d-2*rhoa*t140*t26*wght-4.94711348711
     1         5154d-2*rhoa*t136*t55*wght
            t142 = 2.717804421747981d-1*gammaaa*t2*t21*t51*t53*t68-4.616
     1         5380467955464d-3*gammaaa*t19*t43*t50*t53-3.39725552718497
     2         6d-2*t2*t21*t43*t53+4.6165380467955464d-3*t19*t24*t50-6.2
     3         73423758374362d-4*gammaaa*t105*t21*t22*t43+t139+t138
            t143 = t54**2
            t144 = t53**2
            t145 = 2.717804421747981d-1*gammaaa*t144*t2*t21*t68-1.846615
     1         2187182186d-2*gammaaa*t19*t43*t50*t53-1.3589022108739904d
     2         -1*t2*t21*t43*t53+9.233076093591093d-3*t19*t24*t50-1.2546
     3         847516748727d-3*gammaaa*t105*t21*t22*t43
            t146 = 1/t25**3
            t147 = 9.894226974230308d-2*rhoa*t146*t48**3*wght
            t148 = rhoa**5.000000000000002d-1
            t149 = -6.473659143469149d-1*gammaaa*t148*t21*t24*t45
            t150 = 1/rhoa**6.666666666666665d-1
            t151 = 6.936063368002663d-2*gammaaa*t150*t21*t24*t50
            t152 = 1/rhoa**1.8333333333333332d+0
            t153 = 1/rhoa**3
            t154 = -3.963464781715806d-2*gammaaa*t24*t28*t42*t62
            t155 = 3.963464781715806d-2*gammaaa*t21*t28*t43*t47*t62
            t156 = 9.512315476117932d-1*gammaaa*t27*t28*t42*t43*t47
            t157 = -9.512315476117932d-1*gammaaa*t21*t27*t28*t68*t69
            t158 = 1/t23**4
            t159 = -8.153413265243942d-1*gammaaa*t158*t2*t21*t47**3
            t160 = -6.473659143469149d-1*gammaaa*t148*t19*t45
            t161 = 6.936063368002663d-2*gammaaa*t150*t19*t50
            t162 = -4.734138489271654d-2*gammaaa*t152*t19*t28
            t163 = -4.529674036246635d-2*gammaaa*t153*t19*t2
            t164 = 3.3649020032717303d+1*gammaaa*t17*t39*t40*t50*t60
            t165 = -1.602334287272253d+0*gammaaa*t17*t28*t39*t40*t62
            t166 = 7.773426462662208d+2*gammaaa*t17*t27*t28*t40*t75
            t167 = 4.756157738058966d-1*gammaaa*t17*t27*t28*t40*t99
            t168 = t39**3
            t169 = 8.978888376491218d+3*gammaaa*t168*t17*t2*t40
            t170 = 1.8312391854540025d+0*gammaaa*t17*t2*t39*t40*t64
            t171 = 8.48131310861104d-4*t15/rhoa**3.333333333333333d+0
            t172 = -2.1809090850714105d-3*t31*t38*t77
            t173 = 3.37738d-2*(1.1876045553756398d-1*t35*t5*t82-1.425125
     1         466450768d+0*t4*(7.016926042943222d-1*t5*(-5.847438369119
     2         352d-2*t34*t35*t79-6.883279156869946d-4*t33)-5.8474383691
     3         19352d-2*t34*t35*t80)/t81**2)*t85/t83-3.083347652359653d-
     4         4*t30*t84
            t174 = -3.2713636276071156d-3*t30*t87*t88
            t175 = 3.2713636276071156d-3*t30*t31*t97
            t176 = -1.243628d-1*t16*t38**3/t14**3
            t177 = 1.865442d-1*t16*t38*t87*t97
            t178 = 1/rhoa**2.666666666666667d+0
            t179 = 1/t4**7
            t180 = 1/rhoa**2.0d+0
            t181 = -6.21814d-2*t16*t31*(8.550752798704606d+0*t37*t4*t90*
     1         t96-3.5628136661269194d-1*t32*t35*t5*t96-1.42512546645076
     2         8d+0*t32*t4*(-1.7542315107358056d-1*t34*t35*t95+7.0169260
     3         42943222d-1*t5*(-1.4618595922798375d-2*t10*t92*t94-1.6242
     4         884358664864d-2*t10*t178*t34-6.091081634499322d-3*t10*t17
     5         9*t180-1.161599075681677d-3/rhoa**3.3333333333333337d+0)-
     6         1.4618595922798375d-2*t11*t92*t94+4.385578776839513d-2*t3
     7         3*t36*t94+5.847438369119352d-2*t34*t36*t93-1.624288435866
     8         4864d-2*t11*t178*t34-6.091081634499322d-3*t11*t179*t180)+
     9         2.474176157032582d-3*t13*t180*t94+1.1876045553756398d-1*t
     :         32*t37*t5*t93+9.89670462813033d-3*t13*t34*t92+7.125627332
     ;         253839d-1*t35*t5*t90*t91+3.29890154271011d-2*t13*t178*t5-
     <         8.550752798704606d+0*t37**3*t4/t12**4+2.969011388439098d-
     =         2*t32*t33*t34*t37)
            t182 = -4.042761511756372d+1*(-2.533035d-2*t153*t84*t85+7.50
     1         0000000000002d-1*t173*t64+t181+t177+t176+t175+t174+t172+t
     2         171)-2.0213807558781852d+1*t39*t64-1.2569228533356386d+0*
     3         t15*t153*t16
            t183 = -1.3589022108739904d-1*gammaaa*t17*t182*t2*t40
            t184 = 1.6481152669086024d+1*gammaaa*t17*t2*t39*t40*t99
            t185 = -1.5546852925324417d+3*gammaaa*t101*t102*t27*t28*t75
            t186 = -5.38733302589473d+4*gammaaa*t101*t102*t168*t2
            t187 = -3.296230533817205d+1*gammaaa*t101*t102*t2*t39*t99
            t188 = exp(7.54153712001383d+0*t15*t16)
            t189 = 5.387333025894729d+4*gammaaa*t168*t188*t2/t18**4
            t190 = 1/t1**7.0d+0
            t191 = -4.398534861252425d-1*t148*t190*t22*t44
            t192 = 3.141810615180306d-2*t105*t150*t22*t44
            t193 = 2.4402862532009373d+3*t168*t17*t46*t9
            t194 = -2.1962576278808435d+4*t102*t109*t168*t9
            t195 = 2.928343503841125d+4*t168*t188*t9/t18**5.0d+0
            t196 = -2.473556743557577d-2*t56*wght
            t197 = -t113*t48
            t198 = 2.3120211226675536d-2*gammaaa*t152*t19*t28
            t199 = 1.5098913454155452d-2*gammaaa*t153*t19*t2
            t200 = -1.602334287272253d+0*gammaaa*t17*t28*t39*t40*t62
            t201 = 7.77342646266221d+2*gammaaa*t17*t27*t28*t40*t75
            t202 = 3.170771825372644d-1*gammaaa*t116*t17*t27*t28*t40
            t203 = 1.585385912686322d-1*gammaaa*t17*t27*t28*t40*t99
            t204 = -6.104130618180013d-1*gammaaa*t17*t2*t39*t40*t64
            t205 = -4.042761511756372d+1*(8.44345d-3*t153*t84*t85-2.4999
     1         999999999994d-1*t173*t64+t181+t177+t176+t175+t174+t172+t1
     2         71)+6.737935852927288d+0*t39*t64+4.189742844452128d-1*t15
     3         *t153*t16
            t206 = -1.3589022108739904d-1*gammaaa*t17*t2*t205*t40
            t207 = 1.0987435112724019d+1*gammaaa*t116*t17*t2*t39*t40
            t208 = 5.493717556362009d+0*gammaaa*t17*t2*t39*t40*t99
            t209 = -1.554685292532442d+3*gammaaa*t101*t102*t27*t28*t75
            t210 = -2.1974870225448037d+1*gammaaa*t101*t102*t116*t2*t39
            t211 = -1.0987435112724019d+1*gammaaa*t101*t102*t2*t39*t99
            t212 = 9.894226974230308d-2*rhoa*t146*t52*t56*wght
            t213 = 4.947113487115154d-2*t127*wght
            t214 = -2.774425347201063d-1*gammaaa*t21*t43*t50*t51*t60
            t215 = 1.321154927238602d-2*gammaaa*t21*t28*t43*t51*t62
            t216 = 6.936063368002658d-2*t21*t24*t50*t60
            t217 = -3.3028873180965046d-3*t21*t24*t28*t62
            t218 = 9.425431845540909d-3*gammaaa*t105*t19*t24*t60
            t219 = -4.488300878829006d-4*gammaaa*t19*t24*t45*t62
            t220 = -3.170771825372644d-1*gammaaa*t125*t24*t27*t28
            t221 = 3.170771825372644d-1*gammaaa*t126*t21*t27*t28*t43
            t222 = 3.170771825372644d-1*gammaaa*t27*t28*t42*t43*t51
            t223 = -7.926929563431611d-2*t24*t27*t28*t42
            t224 = -2.717804421747981d-1*gammaaa*t126*t2*t42*t43
            t225 = -6.341543650745288d-1*gammaaa*t21*t27*t28*t47*t51*t68
            t226 = 7.926929563431611d-2*t21*t27*t28*t43*t47
            t227 = 1.0771922109189608d-2*gammaaa*t19*t27*t43*t45*t47
            t228 = -2.717804421747981d-1*gammaaa*t125*t2*t43*t47
            t229 = 5.435608843495962d-1*gammaaa*t126*t2*t21*t47*t68
            t230 = 5.435608843495962d-1*gammaaa*t2*t42*t47*t51*t68
            t231 = -6.794511054369952d-2*t2*t42*t43*t47
            t232 = -8.153413265243942d-1*gammaaa*t158*t2*t21*t51*t69
            t233 = 6.794511054369952d-2*t2*t21*t68*t69
            t234 = 9.233076093591093d-3*gammaaa*t19*t50*t68*t69
            t235 = 6.936063368002658d-2*t19*t50*t60
            t236 = -3.3028873180965046d-3*t19*t28*t62
            t237 = 3.774728363538861d-3*t19*t2*t64
            t238 = -3.204668574544505d+0*t17*t27*t28*t39*t40
            t239 = -5.55244747333015d+1*t17*t2*t40*t75
            t240 = -3.397255527184976d-2*t17*t2*t40*t99
            t241 = 1.1104894946660299d+2*t101*t102*t2*t75
            t242 = 6.283621230360608d-2*gammaaa*t105*t22*t60
            t243 = -1.795320351531602d-3*gammaaa*t22*t45*t62
            t244 = -3.4838649688535417d+0*gammaaa*t17*t27*t39*t45*t46
            t245 = 9.054279776724049d+1*gammaaa*t102*t109*t50*t75
            t246 = -9.894226974230308d-2*rhoa*t127*t48*wght
            t247 = t26*(4.947113487115154d-2*rhoa*(-1.3589022108739904d-
     1         1*gammaaa*t2*t21*t43*(-1.8466152187182186d-2*gammaaa*t17*
     2         t46*t50*t99-3.018093258908016d+1*gammaaa*t17*t46*t50*t75+
     3         2.0517946874646867d-3*gammaaa*t22*t50*t64+t245+t244+t243+
     4         t242+t241+t240+t239+t238+t237+t236+t235)+2.71780442174798
     5         1d-1*gammaaa*t111*t2*t21*t51*t68-1.5098913454155444d-2*ga
     6         mmaaa*t2*t21*t43*t51*t64+5.129486718661717d-4*gammaaa*t19
     7         *t24*t50*t64+3.774728363538861d-3*t2*t21*t24*t64-1.358902
     8         2108739904d-1*gammaaa*t104*t2*t43*t51-4.6165380467955464d
     9         -3*gammaaa*t111*t19*t43*t50-3.397255527184976d-2*t111*t2*
     :         t21*t43+1.3589022108739904d-1*gammaaa*t2*t24*(t241+t240+t
     ;         239+t238+t237+t236+t235)+3.397255527184976d-2*t104*t2*t24
     <         +t234+t233+t232+t231+t230+t229+t228+t227+t226+t225+t224+t
     =         223+t222+t221+t220+t219+t218+t217+t216+t215+t214)*wght-8.
     >         245189145191921d-3*t52*t58*wght+t213)+(t246-t113*t52)*t55
     ?         +t212
            t248 = 9.894226974230308d-2*rhoa*t146*t54*t56*wght
            t249 = 4.947113487115154d-2*t134*wght
            t250 = -2.774425347201063d-1*gammaaa*t21*t43*t50*t53*t60
            t251 = 1.321154927238602d-2*gammaaa*t21*t28*t43*t53*t62
            t252 = 1.3872126736005316d-1*t21*t24*t50*t60
            t253 = -6.605774636193009d-3*t21*t24*t28*t62
            t254 = 1.885086369108182d-2*gammaaa*t105*t19*t24*t60
            t255 = -8.976601757658011d-4*gammaaa*t19*t24*t45*t62
            t256 = -3.170771825372644d-1*gammaaa*t132*t24*t27*t28
            t257 = 3.170771825372644d-1*gammaaa*t133*t21*t27*t28*t43
            t258 = 3.170771825372644d-1*gammaaa*t27*t28*t42*t43*t53
            t259 = -1.585385912686322d-1*t24*t27*t28*t42
            t260 = -2.717804421747981d-1*gammaaa*t133*t2*t42*t43
            t261 = -6.341543650745288d-1*gammaaa*t21*t27*t28*t47*t53*t68
            t262 = 1.585385912686322d-1*t21*t27*t28*t43*t47
            t263 = 2.1543844218379216d-2*gammaaa*t19*t27*t43*t45*t47
            t264 = -2.717804421747981d-1*gammaaa*t132*t2*t43*t47
            t265 = 5.435608843495962d-1*gammaaa*t133*t2*t21*t47*t68
            t266 = 5.435608843495962d-1*gammaaa*t2*t42*t47*t53*t68
            t267 = -1.3589022108739904d-1*t2*t42*t43*t47
            t268 = -8.153413265243942d-1*gammaaa*t158*t2*t21*t53*t69
            t269 = 1.3589022108739904d-1*t2*t21*t68*t69
            t270 = 1.8466152187182186d-2*gammaaa*t19*t50*t68*t69
            t271 = 1.3872126736005316d-1*t19*t50*t60
            t272 = -6.605774636193009d-3*t19*t28*t62
            t273 = 7.549456727077722d-3*t19*t2*t64
            t274 = -6.40933714908901d+0*t17*t27*t28*t39*t40
            t275 = -1.1104894946660299d+2*t17*t2*t40*t75
            t276 = -6.794511054369952d-2*t17*t2*t40*t99
            t277 = 2.2209789893320597d+2*t101*t102*t2*t75
            t278 = 1.2567242460721215d-1*gammaaa*t105*t22*t60
            t279 = -3.590640703063204d-3*gammaaa*t22*t45*t62
            t280 = -6.967729937707083d+0*gammaaa*t17*t27*t39*t45*t46
            t281 = 1.8108559553448098d+2*gammaaa*t102*t109*t50*t75
            t282 = -9.894226974230308d-2*rhoa*t134*t48*wght
            t283 = -3.774728363538862d-3*t19*t2*t64
            t284 = -5.552447473330149d+1*t17*t2*t40*t75
            t285 = -3.397255527184976d-2*t116*t17*t2*t40
            t286 = 1.1104894946660297d+2*t101*t102*t2*t75
            t287 = -7.549456727077724d-3*t19*t2*t64
            t288 = -1.1104894946660297d+2*t17*t2*t40*t75
            t289 = -6.794511054369952d-2*t116*t17*t2*t40
            t290 = 2.2209789893320595d+2*t101*t102*t2*t75
            t291 = 7.926929563431611d-2*t21*t27*t28*t43*t51
            t292 = 1.0771922109189608d-2*gammaaa*t19*t27*t43*t45*t51
            t293 = 6.794511054369952d-2*t125*t2*t24
            t294 = -6.794511054369952d-2*t126*t2*t21*t43
            t295 = -9.233076093591093d-3*gammaaa*t126*t19*t43*t50
            t296 = -6.794511054369952d-2*t2*t42*t43*t51
            t297 = 1.3589022108739904d-1*t2*t21*t47*t51*t68
            t298 = 1.8466152187182186d-2*gammaaa*t19*t47*t50*t51*t68
            t299 = t26*(4.947113487115154d-2*rhoa*(5.435608843495962d-1*
     1         gammaaa*t126*t2*t21*t51*t68+6.273423758374362d-4*gammaaa*
     2         t105*t21*t22*t47*t68+2.717804421747981d-1*gammaaa*t137*t2
     3         *t42*t68-3.170771825372644d-1*gammaaa*t137*t21*t27*t28*t6
     4         8-2.717804421747981d-1*gammaaa*t125*t2*t43*t51-1.35890221
     5         08739904d-1*gammaaa*t2*t21*t43*(1.866356233314397d-1*t17*
     6         t39*t46*t50-5.385961054594804d-3*t22*t27*t45)-2.308269023
     7         3977732d-3*t19*t43*t47*t50-8.153413265243942d-1*gammaaa*t
     8         137*t158*t2*t21*t47-2.692980527297402d-3*t19*t24*t27*t45-
     9         3.136711879187181d-4*gammaaa*t105*t22*t42*t43+3.659497192
     :         3850445d-4*gammaaa*t190*t21*t22*t27*t43+t298+t297+t296+t2
     ;         95+t294+t293+t292+t291)*wght+2.473556743557577d-2*t140*wg
     <         ht)+t55*(-4.947113487115154d-2*rhoa*t127*t52*wght-4.94711
     =         3487115154d-2*rhoa*t140*t48*wght-t128*t52)+9.894226974230
     >         308d-2*rhoa*t136*t146*t48*wght
            t300 = 9.894226974230308d-2*rhoa*t146*t48*t52*t54*wght
            t301 = t26*(4.947113487115154d-2*rhoa*(2.717804421747981d-1*
     1         gammaaa*t2*t42*t51*t53*t68-3.170771825372644d-1*gammaaa*t
     2         21*t27*t28*t51*t53*t68+9.233076093591093d-3*gammaaa*t19*t
     3         47*t50*t53*t68+6.794511054369952d-2*t2*t21*t47*t53*t68+2.
     4         717804421747981d-1*gammaaa*t126*t2*t21*t53*t68+2.71780442
     5         1747981d-1*gammaaa*t133*t2*t21*t51*t68+1.2546847516748727
     6         d-3*gammaaa*t105*t21*t22*t47*t68-8.153413265243942d-1*gam
     7         maaa*t158*t2*t21*t47*t51*t53+5.385961054594804d-3*gammaaa
     8         *t19*t27*t43*t45*t53-3.397255527184976d-2*t2*t42*t43*t53+
     9         3.9634647817158053d-2*t21*t27*t28*t43*t53-1.3589022108739
     :         904d-1*gammaaa*t125*t2*t43*t53-1.3589022108739904d-1*gamm
     ;         aaa*t132*t2*t43*t51-1.3589022108739904d-1*gammaaa*t2*t21*
     <         t43*(3.732712466628794d-1*t17*t39*t46*t50-1.0771922109189
     =         608d-2*t22*t27*t45)-4.6165380467955464d-3*t19*t43*t47*t50
     >         -4.6165380467955464d-3*gammaaa*t133*t19*t43*t50-5.3859610
     ?         54594804d-3*t19*t24*t27*t45-6.273423758374362d-4*gammaaa*
     @         t105*t22*t42*t43+7.318994384770089d-4*gammaaa*t190*t21*t2
     1         2*t27*t43-3.397255527184976d-2*t133*t2*t21*t43+t298+t297+
     2         t296+t295+t294+t293+t292+t291+3.397255527184976d-2*t132*t
     3         2*t24)*wght+2.473556743557577d-2*t142*wght)
            t302 = -4.947113487115154d-2*rhoa*t142*t48*wght
            t303 = 1/t1**8.0d+0
            t304 = 4.947113487115154d-2*rhoa*t26*(1.882027127512309d-3*g
     1         ammaaa*t105*t21*t22*t51*t68+2.769922828077328d-2*gammaaa*
     2         t137*t19*t50*t68+2.0383533163109854d-1*t137*t2*t21*t68-8.
     3         153413265243942d-1*gammaaa*t158*t2*t21*t51**3-6.924807070
     4         19332d-3*t19*t43*t50*t51-3.1968635306266263d-5*gammaaa*t3
     5         03*t43*t46-2.3525339093903863d-4*t105*t21*t22*t43)*wght-1
     6         .4841340461345462d-1*rhoa*t140*t52*t55*wght+9.89422697423
     7         0308d-2*rhoa*t146*t52**3*wght
            t305 = 2.5093695033497454d-3*gammaaa*t105*t21*t22*t51*t68
            t306 = -9.233076093591093d-3*t19*t43*t50*t51
            t307 = t55*(-4.947113487115154d-2*rhoa*t140*t54*wght-9.89422
     1         6974230308d-2*rhoa*t142*t52*wght)+4.947113487115154d-2*rh
     2         oa*t26*(1.8466152187182186d-2*gammaaa*t19*t50*t51*t53*t68
     3         +1.3589022108739904d-1*t2*t21*t51*t53*t68+6.2734237583743
     4         62d-4*gammaaa*t105*t21*t22*t53*t68+1.8466152187182186d-2*
     5         gammaaa*t137*t19*t50*t68+1.3589022108739904d-1*t137*t2*t2
     6         1*t68-2.3082690233977732d-3*t19*t43*t50*t53-8.15341326524
     7         3942d-1*gammaaa*t137*t158*t2*t21*t53-6.393727061253253d-5
     8         *gammaaa*t303*t43*t46-4.7050678187807726d-4*t105*t21*t22*
     9         t43+t306+t305)*wght+9.894226974230308d-2*rhoa*t136*t146*t
     :         54*wght
            fnc(iq) = 4.947113487115154d-2*rhoa*log(1.35890221087399d-1*
     1         gammaaa*t2*(t8+1.0d+0)/(1.8466152187182178d-2*t9/t7**2.0d
     2         +0+t8+1.0d+0)+1.0d+0)*wght+fnc(iq)
            Amat(iq,D1_RA) = 2.473556743557577d-2*t49*wght+4.94711348711
     1         5154d-2*rhoa*t26*t48*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 4.947113487115154d-2*rhoa*t26*t52*wght+Cma
     1         t(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 4.947113487115154d-2*rhoa*t26*t54*wght+Cma
     1         t(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = -8.245189145191921d-3*t49*t58*wght+t57+
     1         t113*t26+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 8.245189145191922d-3*t49*t58*wght+t57+t
     1         122*t26+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = t129+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = -4.947113487115154d-2*rhoa*t48*t54*t55
     1         *wght+t135*t26+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t129+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = t141+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = -4.947113487115154d-2*rhoa*t52*t54*t5
     1         5*wght+4.947113487115154d-2*rhoa*t142*t26*wght+Cmat2(iq,D
     2         2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t141+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = -4.947113487115154d-2*rhoa*t143*t55*w
     1         ght+4.947113487115154d-2*rhoa*t145*t26*wght+Cmat2(iq,D2_G
     2         AB_GAB)
            Amat3(iq,D3_RA_RA_RA) = t26*(4.947113487115154d-2*rhoa*(-1.3
     1         589022108739904d-1*gammaaa*t2*t21*t43*(4.4792549599545534
     2         d+0*t17*t39*t46*t9*t99-1.343776487986366d+1*t102*t109*t39
     3         *t9*t99+2.5852613062055063d-1*t17*t27*t44*t45*t46*t99+9.9
     4         53899911010116d-1*t17*t39*t46*t64*t9-3.693230437436437d-2
     5         *t17*t182*t46*t9-1.2310768124788125d-2*t153*t22*t9+4.2253
     6         305624712234d+2*t17*t27*t44*t45*t46*t75-1.267599168741366
     7         8d+3*t102*t109*t27*t44*t45*t75-8.709662422133856d-1*t17*t
     8         39*t44*t45*t46*t62+3.04838184774685d+1*t105*t17*t39*t44*t
     9         46*t60-2.722902533156262d-2*t152*t22*t44*t45+t195+t194+t1
     :         93+t192+t191+t189+t187+t186+t185+t184+t183+t170+t169+t167
     ;         +t166+t165+t164+t163+t162+t161+t160)+8.153413265243942d-1
     <         *gammaaa*t2*t42*t68*t69+8.153413265243942d-1*gammaaa*t111
     =         *t2*t21*t47*t68-4.529674036246633d-2*gammaaa*t2*t21*t43*t
     >         47*t64+4.529674036246633d-2*gammaaa*t2*t24*t42*t64-8.3232
     ?         7604160319d-1*gammaaa*t21*t43*t47*t50*t60+8.3232760416031
     @         9d-1*gammaaa*t24*t42*t50*t60-4.076706632621971d-1*gammaaa
     1         *t104*t2*t43*t47-4.076706632621971d-1*gammaaa*t111*t2*t42
     2         *t43+4.756157738058966d-1*gammaaa*t111*t21*t27*t28*t43-4.
     3         756157738058966d-1*gammaaa*t104*t24*t27*t28-4.73413848927
     4         1654d-2*gammaaa*t152*t21*t24*t28-4.529674036246635d-2*gam
     5         maaa*t153*t2*t21*t24+1.3589022108739904d-1*gammaaa*(t189+
     6         t187+t186+t185+t184+t183+t170+t169+t167+t166+t165+t164+t1
     7         63+t162+t161+t160)*t2*t24+t159+t157+t156+t155+t154+t151+t
     8         149)*wght-2.473556743557576d-2*t48*t58*wght+7.42067023067
     9         2731d-2*t112*wght)+t55*(-9.894226974230308d-2*rhoa*t112*t
     :         48*wght+t197+t196)+1.2367783717787893d-2*t49*t64*wght+t14
     ;         7+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = t26*(4.947113487115154d-2*rhoa*(-1.3
     1         589022108739904d-1*gammaaa*t2*t21*t43*(1.4930849866515178
     2         d+0*t17*t39*t46*t9*t99-4.4792549599545534d+0*t102*t109*t3
     3         9*t9*t99+8.617537687351686d-2*t17*t27*t44*t45*t46*t99-3.3
     4         17966637003373d-1*t17*t39*t46*t64*t9+2.9861699733030356d+
     5         0*t116*t17*t39*t46*t9-3.693230437436437d-2*t17*t205*t46*t
     6         9-8.958509919909107d+0*t102*t109*t116*t39*t9+4.1035893749
     7         29375d-3*t153*t22*t9+4.225330562471223d+2*t17*t27*t44*t45
     8         *t46*t75-1.267599168741367d+3*t102*t109*t27*t44*t45*t75-8
     9         .709662422133857d-1*t17*t39*t44*t45*t46*t62+3.04838184774
     :         68494d+1*t105*t17*t39*t44*t46*t60+1.7235075374703374d-1*t
     ;         116*t17*t27*t44*t45*t46+1.1071142167778211d-2*t152*t22*t4
     <         4*t45+t211+t210+t209+t208+t207+t206+t204+t203+t202+t201+t
     =         200+t199+t198+t195+t194+t193+t192+t191+t189+t186+t169+t16
     >         4+t161+t160)+8.153413265243943d-1*gammaaa*t2*t42*t68*t69+
     ?         5.435608843495962d-1*gammaaa*t120*t2*t21*t47*t68+2.717804
     @         421747981d-1*gammaaa*t111*t2*t21*t47*t68+1.50989134541554
     1         52d-2*gammaaa*t2*t21*t43*t47*t64-1.5098913454155452d-2*ga
     2         mmaaa*t2*t24*t42*t64-8.323276041603189d-1*gammaaa*t21*t43
     3         *t47*t50*t60+8.323276041603189d-1*gammaaa*t24*t42*t50*t60
     4         -2.717804421747981d-1*gammaaa*t119*t2*t43*t47-1.358902210
     5         8739904d-1*gammaaa*t104*t2*t43*t47-2.717804421747981d-1*g
     6         ammaaa*t120*t2*t42*t43-1.3589022108739904d-1*gammaaa*t111
     7         *t2*t42*t43+3.170771825372644d-1*gammaaa*t120*t21*t27*t28
     8         *t43+1.585385912686322d-1*gammaaa*t111*t21*t27*t28*t43-3.
     9         170771825372644d-1*gammaaa*t119*t24*t27*t28-1.58538591268
     :         6322d-1*gammaaa*t104*t24*t27*t28+2.3120211226675536d-2*ga
     ;         mmaaa*t152*t21*t24*t28+1.3589022108739904d-1*gammaaa*t2*(
     <         t211+t210+t209+t208+t207+t206+t204+t203+t202+t201+t200+t1
     =         99+t198+t189+t186+t169+t164+t161+t160)*t24+1.509891345415
     >         5452d-2*gammaaa*t153*t2*t21*t24+t159+t157+t156+t155+t154+
     ?         t151+t149)*wght+8.245189145191925d-3*t48*t58*wght+4.94711
     @         3487115154d-2*t121*wght+2.473556743557577d-2*t112*wght)+t
     1         55*(-9.894226974230308d-2*rhoa*t121*t48*wght+t197+t196)-4
     2         .1225945725959623d-3*t49*t64*wght+t147+Amat3(iq,D3_RA_RA_
     3         RB)
            Cmat3(iq,D3_RA_RA_GAA) = t247+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = t26*(4.947113487115154d-2*rhoa*(-1.
     1         3589022108739904d-1*gammaaa*t2*t21*t43*(-3.69323043743643
     2         7d-2*gammaaa*t17*t46*t50*t99-6.036186517816032d+1*gammaaa
     3         *t17*t46*t50*t75+4.1035893749293734d-3*gammaaa*t22*t50*t6
     4         4+t281+t280+t279+t278+t277+t276+t275+t274+t273+t272+t271)
     5         +2.717804421747981d-1*gammaaa*t111*t2*t21*t53*t68-1.50989
     6         13454155444d-2*gammaaa*t2*t21*t43*t53*t64+1.0258973437323
     7         433d-3*gammaaa*t19*t24*t50*t64+7.549456727077722d-3*t2*t2
     8         1*t24*t64-1.3589022108739904d-1*gammaaa*t104*t2*t43*t53-9
     9         .233076093591093d-3*gammaaa*t111*t19*t43*t50-6.7945110543
     :         69952d-2*t111*t2*t21*t43+1.3589022108739904d-1*gammaaa*t2
     ;         *t24*(t277+t276+t275+t274+t273+t272+t271)+t270+t269+t268+
     <         t267+t266+t265+t264+t263+t262+t261+t260+t259+t258+t257+t2
     =         56+t255+t254+t253+t252+t251+t250+6.794511054369952d-2*t10
     >         4*t2*t24)*wght-8.245189145191921d-3*t54*t58*wght+t249)+(t
     ?         282-t113*t54)*t55+t248+Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = t247+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = t26*(4.947113487115154d-2*rhoa*(-1.
     1         3589022108739904d-1*gammaaa*t2*t21*t43*(-3.01809325890801
     2         56d+1*gammaaa*t17*t46*t50*t75-2.0517946874646872d-3*gamma
     3         aa*t22*t50*t64-1.8466152187182186d-2*gammaaa*t116*t17*t46
     4         *t50+t286+t285+t284+t283+t245+t244+t243+t242+t238+t236+t2
     5         35)+2.717804421747981d-1*gammaaa*t120*t2*t21*t51*t68+1.50
     6         9891345415545d-2*gammaaa*t2*t21*t43*t51*t64-5.12948671866
     7         1718d-4*gammaaa*t19*t24*t50*t64-3.774728363538862d-3*t2*t
     8         21*t24*t64-1.3589022108739904d-1*gammaaa*t119*t2*t43*t51-
     9         4.6165380467955464d-3*gammaaa*t120*t19*t43*t50-3.39725552
     :         7184976d-2*t120*t2*t21*t43+1.3589022108739904d-1*gammaaa*
     ;         t2*t24*(t286+t285+t284+t283+t238+t236+t235)+3.39725552718
     <         4976d-2*t119*t2*t24+t234+t233+t232+t231+t230+t229+t228+t2
     =         27+t226+t225+t224+t223+t222+t221+t220+t219+t218+t217+t216
     >         +t215+t214)*wght+8.245189145191922d-3*t52*t58*wght+t213)+
     ?         (t246-t122*t52)*t55+t212+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = t26*(4.947113487115154d-2*rhoa*(-1.
     1         3589022108739904d-1*gammaaa*t2*t21*t43*(-6.03618651781603
     2         1d+1*gammaaa*t17*t46*t50*t75-4.1035893749293745d-3*gammaa
     3         a*t22*t50*t64-3.693230437436437d-2*gammaaa*t116*t17*t46*t
     4         50+t290+t289+t288+t287+t281+t280+t279+t278+t274+t272+t271
     5         )+2.717804421747981d-1*gammaaa*t120*t2*t21*t53*t68+1.5098
     6         91345415545d-2*gammaaa*t2*t21*t43*t53*t64-1.0258973437323
     7         436d-3*gammaaa*t19*t24*t50*t64-7.549456727077724d-3*t2*t2
     8         1*t24*t64-1.3589022108739904d-1*gammaaa*t119*t2*t43*t53-9
     9         .233076093591093d-3*gammaaa*t120*t19*t43*t50-6.7945110543
     :         69952d-2*t120*t2*t21*t43+1.3589022108739904d-1*gammaaa*t2
     ;         *t24*(t290+t289+t288+t287+t274+t272+t271)+t270+t269+t268+
     <         t267+t266+t265+t264+t263+t262+t261+t260+t259+t258+t257+t2
     =         56+t255+t254+t253+t252+t251+t250+6.794511054369952d-2*t11
     >         9*t2*t24)*wght+8.245189145191922d-3*t54*t58*wght+t249)+(t
     ?         282-t122*t54)*t55+t248+Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = t299+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = t55*(-4.947113487115154d-2*rhoa*t1
     1         34*t52*wght-t128*t54+t302)+t301+t300+Cmat3(iq,D3_RA_GAA_G
     2         AB)
            Cmat3(iq,D3_RA_GAA_GBB) = t299+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = t26*(4.947113487115154d-2*rhoa*(3.
     1         693230437436437d-2*gammaaa*t19*t47*t50*t53*t68+2.71780442
     2         1747981d-1*t2*t21*t47*t53*t68+5.435608843495962d-1*gammaa
     3         a*t133*t2*t21*t53*t68+2.5093695033497454d-3*gammaaa*t105*
     4         t21*t22*t47*t68+2.717804421747981d-1*gammaaa*t144*t2*t42*
     5         t68-3.170771825372644d-1*gammaaa*t144*t21*t27*t28*t68+2.1
     6         543844218379216d-2*gammaaa*t19*t27*t43*t45*t53-1.35890221
     7         08739904d-1*t2*t42*t43*t53+1.585385912686322d-1*t21*t27*t
     8         28*t43*t53-2.717804421747981d-1*gammaaa*t132*t2*t43*t53-1
     9         .3589022108739904d-1*gammaaa*t2*t21*t43*(7.46542493325758
     :         8d-1*t17*t39*t46*t50-2.1543844218379216d-2*t22*t27*t45)-9
     ;         .233076093591093d-3*t19*t43*t47*t50-1.8466152187182186d-2
     <         *gammaaa*t133*t19*t43*t50-8.153413265243942d-1*gammaaa*t1
     =         44*t158*t2*t21*t47-1.0771922109189608d-2*t19*t24*t27*t45-
     >         1.2546847516748727d-3*gammaaa*t105*t22*t42*t43+1.46379887
     ?         69540178d-3*gammaaa*t190*t21*t22*t27*t43-1.35890221087399
     @         04d-1*t133*t2*t21*t43+1.3589022108739904d-1*t132*t2*t24)*
     1         wght+2.473556743557577d-2*t145*wght)+t55*(-4.947113487115
     2         154d-2*rhoa*t134*t54*wght-4.947113487115154d-2*rhoa*t145*
     3         t48*wght-t135*t54)+9.894226974230308d-2*rhoa*t143*t146*t4
     4         8*wght+Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = t55*(-4.947113487115154d-2*rhoa*t1
     1         27*t54*wght-t135*t52+t302)+t301+t300+Cmat3(iq,D3_RA_GAB_G
     2         BB)
            Cmat3(iq,D3_RA_GBB_GBB) = t299+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = t304+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t307+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = t304+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = t55*(-9.894226974230308d-2*rhoa*t
     1         142*t54*wght-4.947113487115154d-2*rhoa*t145*t52*wght)+4.9
     2         47113487115154d-2*rhoa*t26*(3.693230437436437d-2*gammaaa*
     3         t19*t50*t51*t53*t68+2.717804421747981d-1*t2*t21*t51*t53*t
     4         68+2.5093695033497454d-3*gammaaa*t105*t21*t22*t53*t68+9.2
     5         33076093591093d-3*gammaaa*t144*t19*t50*t68+6.794511054369
     6         952d-2*t144*t2*t21*t68-9.233076093591093d-3*t19*t43*t50*t
     7         53-8.153413265243942d-1*gammaaa*t144*t158*t2*t21*t51-1.27
     8         87454122506506d-4*gammaaa*t303*t43*t46-9.410135637561545d
     9         -4*t105*t21*t22*t43+t306+t305)*wght+9.894226974230308d-2*
     :         rhoa*t143*t146*t52*wght+Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = t307+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = 4.947113487115154d-2*rhoa*t26*(7.
     1         528108510049236d-3*gammaaa*t105*t21*t22*t53*t68+5.5398456
     2         56154656d-2*gammaaa*t144*t19*t50*t68+4.076706632621971d-1
     3         *t144*t2*t21*t68-8.153413265243942d-1*gammaaa*t158*t2*t21
     4         *t53**3-2.769922828077328d-2*t19*t43*t50*t53-2.5574908245
     5         01301d-4*gammaaa*t303*t43*t46-1.882027127512309d-3*t105*t
     6         21*t22*t43)*wght-1.4841340461345462d-1*rhoa*t145*t54*t55*
     7         wght+9.894226974230308d-2*rhoa*t146*t54**3*wght+Cmat3(iq,
     8         D3_GAB_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = rhoa-rhob
            t3 = 1/t1
            t4 = 1.0d+0-t2*t3
            t5 = t4**6.666666666666666d-1
            t6 = t2*t3+1.0d+0
            t7 = t6**6.666666666666666d-1
            t8 = 5.0d-1*t7+5.0d-1*t5
            t9 = t8**3.0d+0
            t10 = gammabb+2.0d+0*gammaab+gammaaa
            t11 = t1**1.1666666666666667d+0
            t12 = 1/t11**2.0d+0
            t13 = t8**2.0d+0
            t14 = 1/t13
            t15 = 1/t9
            t16 = t1**3.333333333333333d-1
            t17 = 1/t16
            t18 = 1.325688999052018d-1*t17+1.0d+0
            t19 = t16**5.0d-1
            t20 = 1/t19
            t21 = 2.4141993114533214d-2*t20+1.0186556948d-1
            t22 = 7.876233178997433d-1*t20*t21+2.2308199064d-1
            t23 = 7.876233178997433d-1*t20*t22+4.7231125998d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t19*t24+1.0d+0
            t26 = log(t25)
            t27 = t4**1.3333333333333333d+0
            t28 = t6**1.3333333333333333d+0
            t29 = 1.923661050931536d+0*t28+1.923661050931536d+0*t27-3.84
     1         7322101863072d+0
            t30 = 6.901399211255826d-2*t17+1.0d+0
            t31 = 1.3212998810398843d-2*t20+2.9729725188d-2
            t32 = 7.876233178997433d-1*t20*t31+1.2236585478d-1
            t33 = 7.876233178997433d-1*t20*t32+3.497952466d-1
            t34 = 1/t33
            t35 = 1.269642451250142d+0*t19*t34+1.0d+0
            t36 = log(t35)
            t37 = t2**4
            t38 = 1/t1**4
            t39 = 1.2746961887000874d-1*t17+1.0d+0
            t40 = 1.530901310039024d-2*t20+1.0465751434d-1
            t41 = 7.876233178997433d-1*t20*t40+1.9269083139d-1
            t42 = 7.876233178997433d-1*t20*t41+4.3896648423d-1
            t43 = 1/t42
            t44 = 1.269642451250142d+0*t19*t43+1.0d+0
            t45 = log(t44)
            t46 = 1.709920934161365d+0*(6.21814d-2*t18*t26-3.10907d-2*t3
     1         9*t45)-3.37738d-2*t30*t36
            t47 = t37*t38*t46+3.37738d-2*t30*t36
            t48 = 5.848223622634648d-1*t29*t47-6.21814d-2*t18*t26
            t49 = exp(-4.042761511756372d+1*t15*t48)
            t50 = t49-1.0d+0
            t51 = 1/t50
            t52 = 1.7121095002288222d-1*t10*t12*t14*t51
            t53 = t52+1.0d+0
            t54 = 1/t8**4.0d+0
            t55 = (t10*t12)**2.0d+0
            t56 = 1/t50**2.0d+0
            t57 = 2.931318940773787d-2*t54*t55*t56+t52+1.0d+0
            t58 = 1/t57
            t59 = 1.7121095002288222d-1*t10*t12*t14*t53*t58+1.0d+0
            t60 = log(t59)
            t61 = 1/t59
            t62 = 1/t1**2
            t63 = t2*t62
            t64 = -t3
            t65 = t64+t63
            t66 = t4**3.333333333333333d-1
            t67 = 1/t66
            t68 = -t2*t62
            t69 = t68+t3
            t70 = t6**3.333333333333333d-1
            t71 = 1/t70
            t72 = 3.333333333333333d-1*t69*t71+3.333333333333333d-1*t65*
     1         t67
            t73 = t1**1.6666666666666674d-1
            t74 = 1/t11**3.0d+0
            t75 = -3.994922167200585d-1*t10*t14*t53*t58*t73*t74
            t76 = -3.4242190004576445d-1*t10*t12*t15*t51*t72
            t77 = -3.994922167200585d-1*t10*t14*t51*t73*t74
            t78 = 1/t50**2
            t79 = 1/t1**1.3333333333333336d+0
            t80 = 1/t1**6.666666666666667d-1
            t81 = 1/t19**3
            t82 = -1.3127055298329054d-1*t21*t80*t81-3.169132786263567d-
     1         3*t79
            t83 = 7.876233178997433d-1*t20*t82-1.3127055298329054d-1*t22
     1         *t80*t81
            t84 = 1/t23**2
            t85 = 2.11607075208357d-1*t20*t24*t80-1.269642451250142d+0*t
     1         19*t83*t84
            t86 = 1/t25
            t87 = -6.21814d-2*t18*t85*t86
            t88 = 1/t1**1.3333333333333333d+0
            t89 = 2.747773264188438d-3*t26*t88
            t90 = -1.3127055298329054d-1*t31*t80*t81-1.7344776604086162d
     1         -3*t79
            t91 = 7.876233178997433d-1*t20*t90-1.3127055298329054d-1*t32
     1         *t80*t81
            t92 = 1/t33**2
            t93 = 2.11607075208357d-1*t20*t34*t80-1.269642451250142d+0*t
     1         19*t91*t92
            t94 = 1/t35
            t95 = 3.37738d-2*t30*t93*t94
            t96 = -7.769549222703733d-4*t36*t88
            t97 = -1.3127055298329054d-1*t40*t80*t81-2.0096226153166658d
     1         -3*t79
            t98 = 7.876233178997433d-1*t20*t97-1.3127055298329054d-1*t41
     1         *t80*t81
            t99 = 1/t42**2
            t100 = 2.11607075208357d-1*t20*t43*t80-1.269642451250142d+0*
     1         t19*t98*t99
            t101 = 1/t44
            t102 = -3.37738d-2*t30*t93*t94+1.709920934161365d+0*(1.32103
     1         98931339265d-3*t45*t88-2.747773264188438d-3*t26*t88+6.218
     2         14d-2*t18*t85*t86-3.10907d-2*t100*t101*t39)+7.76954922270
     3         3733d-4*t36*t88
            t103 = t102*t37*t38
            t104 = 1/t1**5
            t105 = -4*t104*t37*t46
            t106 = t2**3
            t107 = t96+t95+4*t106*t38*t46+t105+t103
            t108 = 2.564881401242048d+0*t69*t70+2.564881401242048d+0*t65
     1         *t66
            t109 = t89+t87+5.848223622634648d-1*t108*t47+5.8482236226346
     1         48d-1*t107*t29
            t110 = 1.2128284535269115d+2*t48*t54*t72-4.042761511756372d+
     1         1*t109*t15
            t111 = -1.7121095002288222d-1*t10*t110*t12*t14*t49*t78
            t112 = t77+t76+t111
            t113 = 1/t57**2
            t114 = t10**2
            t115 = 1/t11**5.0d+0
            t116 = -1.3679488390277675d-1*t114*t115*t54*t56*t73
            t117 = 1/t8**5.0d+0
            t118 = 1/t50**3.0d+0
            t119 = t77+t76-1.172527576309515d-1*t117*t55*t56*t72-5.86263
     1         7881547574d-2*t110*t118*t49*t54*t55+t116+t111
            t120 = t75-3.4242190004576445d-1*t10*t12*t15*t53*t58*t72+1.7
     1         121095002288222d-1*t10*t112*t12*t14*t58-1.712109500228822
     2         2d-1*t10*t113*t119*t12*t14*t53
            t121 = 2.473556743557577d-2*t60*t9*wght
            t122 = t63+t3
            t123 = t68+t64
            t124 = 3.333333333333333d-1*t123*t71+3.333333333333333d-1*t1
     1         22*t67
            t125 = -3.4242190004576445d-1*t10*t12*t124*t15*t51
            t126 = t96+t95-4*t106*t38*t46+t105+t103
            t127 = 2.564881401242048d+0*t123*t70+2.564881401242048d+0*t1
     1         22*t66
            t128 = t89+t87+5.848223622634648d-1*t127*t47+5.8482236226346
     1         48d-1*t126*t29
            t129 = 1.2128284535269115d+2*t124*t48*t54-4.042761511756372d
     1         +1*t128*t15
            t130 = -1.7121095002288222d-1*t10*t12*t129*t14*t49*t78
            t131 = t77+t130+t125
            t132 = t77-1.172527576309515d-1*t117*t124*t55*t56-5.86263788
     1         1547574d-2*t118*t129*t49*t54*t55+t130+t125+t116
            t133 = t75-3.4242190004576445d-1*t10*t12*t124*t15*t53*t58+1.
     1         7121095002288222d-1*t10*t12*t131*t14*t58-1.71210950022882
     2         22d-1*t10*t113*t12*t132*t14*t53
            t134 = 1/t11**4.0d+0
            t135 = 5.862637881547574d-2*t10*t134*t54*t56+1.7121095002288
     1         222d-1*t12*t14*t51
            t136 = 2.931318940773787d-2*t10*t134*t51*t54*t58+1.712109500
     1         2288222d-1*t12*t14*t53*t58-1.7121095002288222d-1*t10*t113
     2         *t12*t135*t14*t53
            t137 = 2.473556743557577d-2*t1*t136*t61*t9*wght
            t138 = 1.172527576309515d-1*t10*t134*t54*t56+3.4242190004576
     1         445d-1*t12*t14*t51
            t139 = 5.862637881547574d-2*t10*t134*t51*t54*t58+3.424219000
     1         4576445d-1*t12*t14*t53*t58-1.7121095002288222d-1*t10*t113
     2         *t12*t138*t14*t53
            t140 = 1/t59**2
            t141 = t120**2
            t142 = t72**2
            t143 = t65**2
            t144 = 1/t27
            t145 = 1/t1**3
            t146 = -2*t145*t2
            t147 = 2*t62
            t148 = t147+t146
            t149 = t69**2
            t150 = 1/t28
            t151 = 2*t145*t2
            t152 = -2*t62
            t153 = t152+t151
            t154 = 3.333333333333333d-1*t153*t71+3.333333333333333d-1*t1
     1         48*t67-1.111111111111111d-1*t149*t150-1.111111111111111d-
     2         1*t143*t144
            t155 = t1**3.333333333333335d-1
            t156 = 1.398222758520205d+0*t10*t134*t14*t155*t53*t58
            t157 = 1/t1**8.333333333333333d-1
            t158 = -6.658203612000978d-2*t10*t14*t157*t53*t58*t74
            t159 = 1.0272657001372934d+0*t10*t12*t142*t51*t54
            t160 = -3.4242190004576445d-1*t10*t12*t15*t154*t51
            t161 = 1.5979688668802342d+0*t10*t15*t51*t72*t73*t74
            t162 = 1.398222758520205d+0*t10*t134*t14*t155*t51
            t163 = -6.658203612000978d-2*t10*t14*t157*t51*t74
            t164 = t85**2
            t165 = 1/t25**2
            t166 = 6.21814d-2*t164*t165*t18
            t167 = t83**2
            t168 = 1/t23**3
            t169 = 1/t1**2.3333333333333334d+0
            t170 = 1/t19**5
            t171 = 1/t1**1.6666666666666669d+0
            t172 = 8.751370198886037d-2*t171*t21*t81+6.563527649164527d-
     1         2*t170*t21*t79+4.753699179395351d-3*t169
            t173 = -2.625411059665811d-1*t80*t81*t82+8.751370198886037d-
     1         2*t171*t22*t81+6.563527649164527d-2*t170*t22*t79+7.876233
     2         178997433d-1*t172*t20
            t174 = -4.23214150416714d-1*t20*t80*t83*t84-1.26964245125014
     1         2d+0*t173*t19*t84-3.52678458680595d-2*t24*t79*t81-1.41071
     2         38347223802d-1*t171*t20*t24+2.539284902500284d+0*t167*t16
     3         8*t19
            t175 = -6.21814d-2*t174*t18*t86
            t176 = 5.495546528376876d-3*t85*t86*t88
            t177 = 1/t1**2.333333333333333d+0
            t178 = -3.663697685584584d-3*t177*t26
            t179 = t93**2
            t180 = 1/t35**2
            t181 = -3.37738d-2*t179*t180*t30
            t182 = t91**2
            t183 = 1/t33**3
            t184 = 8.751370198886037d-2*t171*t31*t81+6.563527649164527d-
     1         2*t170*t31*t79+2.601716490612924d-3*t169
            t185 = -2.625411059665811d-1*t80*t81*t90+8.751370198886037d-
     1         2*t171*t32*t81+6.563527649164527d-2*t170*t32*t79+7.876233
     2         178997433d-1*t184*t20
            t186 = -4.23214150416714d-1*t20*t80*t91*t92-1.26964245125014
     1         2d+0*t185*t19*t92-3.52678458680595d-2*t34*t79*t81-1.41071
     2         38347223802d-1*t171*t20*t34+2.539284902500284d+0*t182*t18
     3         3*t19
            t187 = 3.37738d-2*t186*t30*t94
            t188 = -1.5539098445407465d-3*t88*t93*t94
            t189 = 1.0359398963604977d-3*t177*t36
            t190 = t100**2
            t191 = 1/t44**2
            t192 = t98**2
            t193 = 1/t42**3
            t194 = 8.751370198886037d-2*t171*t40*t81+6.563527649164527d-
     1         2*t170*t40*t79+3.0144339229749983d-3*t169
            t195 = -2.625411059665811d-1*t80*t81*t97+8.751370198886037d-
     1         2*t171*t41*t81+6.563527649164527d-2*t170*t41*t79+7.876233
     2         178997433d-1*t194*t20
            t196 = -4.23214150416714d-1*t20*t80*t98*t99-1.26964245125014
     1         2d+0*t19*t195*t99-3.52678458680595d-2*t43*t79*t81-1.41071
     2         38347223802d-1*t171*t20*t43+2.539284902500284d+0*t19*t192
     3         *t193
            t197 = 1.5539098445407465d-3*t88*t93*t94-3.37738d-2*t186*t30
     1         *t94+1.709920934161365d+0*(-5.495546528376876d-3*t85*t86*
     2         t88+2.642079786267853d-3*t100*t101*t88+6.21814d-2*t174*t1
     3         8*t86-1.7613865241785687d-3*t177*t45-3.10907d-2*t101*t196
     4         *t39+3.10907d-2*t190*t191*t39+3.663697685584584d-3*t177*t
     5         26-6.21814d-2*t164*t165*t18)-1.0359398963604977d-3*t177*t
     6         36+3.37738d-2*t179*t180*t30
            t198 = t197*t37*t38
            t199 = -8*t102*t104*t37
            t200 = 1/t1**6
            t201 = 20*t200*t37*t46
            t202 = t2**2
            t203 = 12*t202*t38*t46
            t204 = -32*t104*t106*t46+8*t102*t106*t38+t203+t201+t199+t198
     1         +t189+t188+t187+t181
            t205 = 1/t5
            t206 = 1/t7
            t207 = 2.564881401242048d+0*t153*t70+2.564881401242048d+0*t1
     1         48*t66+8.549604670806825d-1*t149*t206+8.549604670806825d-
     2         1*t143*t205
            t208 = 5.848223622634648d-1*t207*t47+5.848223622634648d-1*t2
     1         04*t29+t178+t176+t175+t166+1.1696447245269297d+0*t107*t10
     2         8
            t209 = 2.425656907053823d+2*t109*t54*t72+1.2128284535269115d
     1         +2*t154*t48*t54-4.851313814107646d+2*t117*t142*t48-4.0427
     2         61511756372d+1*t15*t208
            t210 = -1.7121095002288222d-1*t10*t12*t14*t209*t49*t78
            t211 = 6.848438000915289d-1*t10*t110*t12*t15*t49*t72*t78
            t212 = 7.98984433440117d-1*t10*t110*t14*t49*t73*t74*t78
            t213 = exp(-8.085523023512744d+1*t15*t48)
            t214 = 1/t50**3
            t215 = t110**2
            t216 = 3.4242190004576445d-1*t10*t12*t14*t213*t214*t215
            t217 = -1.7121095002288222d-1*t10*t12*t14*t215*t49*t78
            t218 = t217+t216+t212+t211+t210+t163+t162+t161+t160+t159
            t219 = 1/t11**6.0d+0
            t220 = 7.979701560995311d-1*t114*t155*t219*t54*t56
            t221 = -2.2799147317129467d-2*t114*t115*t157*t54*t56
            t222 = 1/t8**6.0d+0
            t223 = 1/t50**4.0d+0
            t224 = 1.094359071222214d+0*t114*t115*t117*t56*t72*t73+5.471
     1         79535611107d-1*t110*t114*t115*t118*t49*t54*t73+4.69011030
     2         523806d-1*t110*t117*t118*t49*t55*t72+5.862637881547574d-1
     3         *t142*t222*t55*t56-1.172527576309515d-1*t117*t154*t55*t56
     4         -5.862637881547574d-2*t118*t215*t49*t54*t55-5.86263788154
     5         7574d-2*t118*t209*t49*t54*t55+1.7587913644642725d-1*t213*
     6         t215*t223*t54*t55+t221+t220+t217+t216+t212+t211+t210+t163
     7         +t162+t161+t160+t159
            t225 = 1/t57**3
            t226 = t119**2
            t227 = 1.5979688668802342d+0*t10*t15*t53*t58*t72*t73*t74-7.9
     1         8984433440117d-1*t10*t112*t14*t58*t73*t74+7.9898443344011
     2         7d-1*t10*t113*t119*t14*t53*t73*t74-6.848438000915289d-1*t
     3         10*t112*t12*t15*t58*t72+6.848438000915289d-1*t10*t113*t11
     4         9*t12*t15*t53*t72+1.0272657001372934d+0*t10*t12*t142*t53*
     5         t54*t58-3.4242190004576445d-1*t10*t12*t15*t154*t53*t58+1.
     6         7121095002288222d-1*t10*t12*t14*t218*t58+3.42421900045764
     7         45d-1*t10*t12*t14*t225*t226*t53-1.7121095002288222d-1*t10
     8         *t113*t12*t14*t224*t53+t158+t156-3.4242190004576445d-1*t1
     9         0*t112*t113*t119*t12*t14
            t228 = 2.473556743557577d-2*t1*t227*t9*wght+4.94711348711515
     1         4d-2*t120*t9*wght+1.4841340461345462d-1*t1*t120*t13*t72*w
     2         ght
            t229 = 6.666666666666666d-1*t145*t2*t71-1.111111111111111d-1
     1         *t123*t150*t69-6.666666666666666d-1*t145*t2*t67-1.1111111
     2         11111111d-1*t122*t144*t65
            t230 = 1.0272657001372934d+0*t10*t12*t124*t51*t54*t72
            t231 = -3.4242190004576445d-1*t10*t12*t15*t229*t51
            t232 = 7.98984433440117d-1*t10*t124*t15*t51*t73*t74
            t233 = 7.98984433440117d-1*t10*t15*t51*t72*t73*t74
            t234 = -12*t202*t38*t46+t201+t199+t198+t189+t188+t187+t181
            t235 = 5.129762802484096d+0*t145*t2*t70+8.549604670806825d-1
     1         *t123*t206*t69-5.129762802484096d+0*t145*t2*t66+8.5496046
     2         70806825d-1*t122*t205*t65
            t236 = 5.848223622634648d-1*t235*t47+5.848223622634648d-1*t2
     1         34*t29+t178+t176+t175+t166+5.848223622634648d-1*t107*t127
     2         +5.848223622634648d-1*t108*t126
            t237 = 1.2128284535269115d+2*t128*t54*t72-4.851313814107646d
     1         +2*t117*t124*t48*t72+1.2128284535269115d+2*t229*t48*t54+1
     2         .2128284535269115d+2*t109*t124*t54-4.042761511756372d+1*t
     3         15*t236
            t238 = -1.7121095002288222d-1*t10*t12*t14*t237*t49*t78
            t239 = 3.4242190004576445d-1*t10*t12*t129*t15*t49*t72*t78
            t240 = 3.994922167200585d-1*t10*t129*t14*t49*t73*t74*t78
            t241 = 3.4242190004576445d-1*t10*t110*t12*t124*t15*t49*t78
            t242 = 3.994922167200585d-1*t10*t110*t14*t49*t73*t74*t78
            t243 = 3.4242190004576445d-1*t10*t110*t12*t129*t14*t213*t214
            t244 = -1.7121095002288222d-1*t10*t110*t12*t129*t14*t49*t78
            t245 = t244+t243+t242+t241+t240+t239+t238+t233+t232+t231+t23
     1         0+t163+t162
            t246 = 5.47179535611107d-1*t114*t115*t117*t56*t72*t73+5.4717
     1         9535611107d-1*t114*t115*t117*t124*t56*t73+2.7358976780555
     2         35d-1*t114*t115*t118*t129*t49*t54*t73+2.735897678055535d-
     3         1*t110*t114*t115*t118*t49*t54*t73+5.862637881547574d-1*t1
     4         24*t222*t55*t56*t72+2.34505515261903d-1*t117*t118*t129*t4
     5         9*t55*t72-1.172527576309515d-1*t117*t229*t55*t56-5.862637
     6         881547574d-2*t118*t237*t49*t54*t55-5.862637881547574d-2*t
     7         110*t118*t129*t49*t54*t55+1.7587913644642725d-1*t110*t129
     8         *t213*t223*t54*t55+2.34505515261903d-1*t110*t117*t118*t12
     9         4*t49*t55+t244+t243+t242+t241+t240+t239+t238+t233+t232+t2
     :         31+t230+t221+t220+t163+t162
            t247 = 7.98984433440117d-1*t10*t15*t53*t58*t72*t73*t74+7.989
     1         84433440117d-1*t10*t124*t15*t53*t58*t73*t74-3.99492216720
     2         0585d-1*t10*t131*t14*t58*t73*t74-3.994922167200585d-1*t10
     3         *t112*t14*t58*t73*t74+3.994922167200585d-1*t10*t113*t132*
     4         t14*t53*t73*t74+3.994922167200585d-1*t10*t113*t119*t14*t5
     5         3*t73*t74+1.0272657001372934d+0*t10*t12*t124*t53*t54*t58*
     6         t72-3.4242190004576445d-1*t10*t12*t131*t15*t58*t72+3.4242
     7         190004576445d-1*t10*t113*t12*t132*t15*t53*t72-3.424219000
     8         4576445d-1*t10*t12*t15*t229*t53*t58+1.7121095002288222d-1
     9         *t10*t12*t14*t245*t58-3.4242190004576445d-1*t10*t112*t12*
     :         t124*t15*t58-1.7121095002288222d-1*t10*t113*t12*t14*t246*
     ;         t53+3.4242190004576445d-1*t10*t119*t12*t132*t14*t225*t53+
     <         3.4242190004576445d-1*t10*t113*t119*t12*t124*t15*t53+t158
     =         +t156-1.7121095002288222d-1*t10*t112*t113*t12*t132*t14-1.
     >         7121095002288222d-1*t10*t113*t119*t12*t131*t14
            t248 = 2.473556743557577d-2*t1*t247*t9*wght+2.47355674355757
     1         7d-2*t133*t9*wght+2.473556743557577d-2*t120*t9*wght+7.420
     2         670230672731d-2*t1*t13*t133*t72*wght+7.420670230672731d-2
     3         *t1*t120*t124*t13*wght
            t249 = t133**2
            t250 = t124**2
            t251 = t122**2
            t252 = t152+t146
            t253 = t123**2
            t254 = t151+t147
            t255 = 3.333333333333333d-1*t254*t71+3.333333333333333d-1*t2
     1         52*t67-1.111111111111111d-1*t150*t253-1.111111111111111d-
     2         1*t144*t251
            t256 = 1.0272657001372934d+0*t10*t12*t250*t51*t54
            t257 = -3.4242190004576445d-1*t10*t12*t15*t255*t51
            t258 = 1.5979688668802342d+0*t10*t124*t15*t51*t73*t74
            t259 = 32*t104*t106*t46-8*t102*t106*t38+t203+t201+t199+t198+
     1         t189+t188+t187+t181
            t260 = 2.564881401242048d+0*t254*t70+2.564881401242048d+0*t2
     1         52*t66+8.549604670806825d-1*t206*t253+8.549604670806825d-
     2         1*t205*t251
            t261 = 5.848223622634648d-1*t260*t47+5.848223622634648d-1*t2
     1         59*t29+t178+t176+t175+t166+1.1696447245269297d+0*t126*t12
     2         7
            t262 = 1.2128284535269115d+2*t255*t48*t54+2.425656907053823d
     1         +2*t124*t128*t54-4.851313814107646d+2*t117*t250*t48-4.042
     2         761511756372d+1*t15*t261
            t263 = -1.7121095002288222d-1*t10*t12*t14*t262*t49*t78
            t264 = 6.848438000915289d-1*t10*t12*t124*t129*t15*t49*t78
            t265 = 7.98984433440117d-1*t10*t129*t14*t49*t73*t74*t78
            t266 = t129**2
            t267 = 3.4242190004576445d-1*t10*t12*t14*t213*t214*t266
            t268 = -1.7121095002288222d-1*t10*t12*t14*t266*t49*t78
            t269 = t268+t267+t265+t264+t263+t258+t257+t256+t163+t162
            t270 = 1.094359071222214d+0*t114*t115*t117*t124*t56*t73+5.47
     1         179535611107d-1*t114*t115*t118*t129*t49*t54*t73-1.1725275
     2         76309515d-1*t117*t255*t55*t56+5.862637881547574d-1*t222*t
     3         250*t55*t56-5.862637881547574d-2*t118*t266*t49*t54*t55-5.
     4         862637881547574d-2*t118*t262*t49*t54*t55+1.75879136446427
     5         25d-1*t213*t223*t266*t54*t55+4.69011030523806d-1*t117*t11
     6         8*t124*t129*t49*t55+t268+t267+t265+t264+t263+t258+t257+t2
     7         56+t221+t220+t163+t162
            t271 = t132**2
            t272 = 1.5979688668802342d+0*t10*t124*t15*t53*t58*t73*t74-7.
     1         98984433440117d-1*t10*t131*t14*t58*t73*t74+7.989844334401
     2         17d-1*t10*t113*t132*t14*t53*t73*t74+1.0272657001372934d+0
     3         *t10*t12*t250*t53*t54*t58-3.4242190004576445d-1*t10*t12*t
     4         15*t255*t53*t58+1.7121095002288222d-1*t10*t12*t14*t269*t5
     5         8-6.848438000915289d-1*t10*t12*t124*t131*t15*t58+3.424219
     6         0004576445d-1*t10*t12*t14*t225*t271*t53-1.712109500228822
     7         2d-1*t10*t113*t12*t14*t270*t53+6.848438000915289d-1*t10*t
     8         113*t12*t124*t132*t15*t53+t158+t156-3.4242190004576445d-1
     9         *t10*t113*t12*t131*t132*t14
            t273 = 2.473556743557577d-2*t1*t272*t9*wght+4.94711348711515
     1         4d-2*t133*t9*wght+1.4841340461345462d-1*t1*t124*t13*t133*
     2         wght
            t274 = 2.473556743557577d-2*t136*t9*wght
            t275 = 3.994922167200585d-1*t10*t113*t135*t14*t53*t73*t74
            t276 = -3.994922167200585d-1*t14*t53*t58*t73*t74
            t277 = -6.839744195138837d-2*t10*t115*t51*t54*t58*t73
            t278 = -3.4242190004576445d-1*t12*t15*t51*t72
            t279 = -3.994922167200585d-1*t14*t51*t73*t74
            t280 = -1.7121095002288222d-1*t110*t12*t14*t49*t78
            t281 = t280+t279+t278
            t282 = -2.735897678055535d-1*t10*t115*t54*t56*t73
            t283 = -2.34505515261903d-1*t10*t117*t134*t56*t72-1.17252757
     1         6309515d-1*t10*t110*t118*t134*t49*t54+t282+t280+t279+t278
            t284 = -3.4242190004576445d-1*t12*t15*t53*t58*t72-5.86263788
     1         1547574d-2*t10*t117*t134*t51*t58*t72+3.4242190004576445d-
     2         1*t10*t113*t12*t135*t15*t53*t72+1.7121095002288222d-1*t10
     3         *t12*t14*t281*t58+1.7121095002288222d-1*t112*t12*t14*t58-
     4         2.931318940773787d-2*t10*t113*t119*t134*t51*t54-1.7121095
     5         002288222d-1*t10*t113*t12*t14*t283*t53+3.4242190004576445
     6         d-1*t10*t119*t12*t135*t14*t225*t53-1.7121095002288222d-1*
     7         t113*t119*t12*t14*t53+t277+t276+t275-1.7121095002288222d-
     8         1*t10*t112*t113*t12*t135*t14
            t285 = 2.473556743557577d-2*t1*t284*t9*wght+7.42067023067273
     1         1d-2*t1*t13*t136*t72*wght+t274
            t286 = t285*t61-2.473556743557577d-2*t1*t120*t136*t140*t9*wg
     1         ht
            t287 = 2.473556743557577d-2*t139*t9*wght
            t288 = 3.994922167200585d-1*t10*t113*t138*t14*t53*t73*t74
            t289 = -7.98984433440117d-1*t14*t53*t58*t73*t74
            t290 = -1.3679488390277675d-1*t10*t115*t51*t54*t58*t73
            t291 = -6.848438000915289d-1*t12*t15*t51*t72
            t292 = -7.98984433440117d-1*t14*t51*t73*t74
            t293 = -3.4242190004576445d-1*t110*t12*t14*t49*t78
            t294 = t293+t292+t291
            t295 = -5.47179535611107d-1*t10*t115*t54*t56*t73
            t296 = -4.69011030523806d-1*t10*t117*t134*t56*t72-2.34505515
     1         261903d-1*t10*t110*t118*t134*t49*t54+t295+t293+t292+t291
            t297 = -6.848438000915289d-1*t12*t15*t53*t58*t72-1.172527576
     1         309515d-1*t10*t117*t134*t51*t58*t72+3.4242190004576445d-1
     2         *t10*t113*t12*t138*t15*t53*t72+1.7121095002288222d-1*t10*
     3         t12*t14*t294*t58+3.4242190004576445d-1*t112*t12*t14*t58-5
     4         .862637881547574d-2*t10*t113*t119*t134*t51*t54-1.71210950
     5         02288222d-1*t10*t113*t12*t14*t296*t53+3.4242190004576445d
     6         -1*t10*t119*t12*t138*t14*t225*t53-3.4242190004576445d-1*t
     7         113*t119*t12*t14*t53+t290+t289+t288-1.7121095002288222d-1
     8         *t10*t112*t113*t12*t138*t14
            t298 = 2.473556743557577d-2*t1*t297*t9*wght+7.42067023067273
     1         1d-2*t1*t13*t139*t72*wght+t287
            t299 = -3.4242190004576445d-1*t12*t124*t15*t51
            t300 = -1.7121095002288222d-1*t12*t129*t14*t49*t78
            t301 = t300+t299+t279
            t302 = -2.34505515261903d-1*t10*t117*t124*t134*t56-1.1725275
     1         76309515d-1*t10*t118*t129*t134*t49*t54+t300+t299+t282+t27
     2         9
            t303 = -3.4242190004576445d-1*t12*t124*t15*t53*t58-5.8626378
     1         81547574d-2*t10*t117*t124*t134*t51*t58+1.7121095002288222
     2         d-1*t10*t12*t14*t301*t58+1.7121095002288222d-1*t12*t131*t
     3         14*t58-2.931318940773787d-2*t10*t113*t132*t134*t51*t54-1.
     4         7121095002288222d-1*t10*t113*t12*t14*t302*t53+3.424219000
     5         4576445d-1*t10*t12*t132*t135*t14*t225*t53+3.4242190004576
     6         445d-1*t10*t113*t12*t124*t135*t15*t53-1.7121095002288222d
     7         -1*t113*t12*t132*t14*t53+t277+t276+t275-1.712109500228822
     8         2d-1*t10*t113*t12*t131*t135*t14
            t304 = 2.473556743557577d-2*t1*t303*t9*wght+7.42067023067273
     1         1d-2*t1*t124*t13*t136*wght+t274
            t305 = t304*t61-2.473556743557577d-2*t1*t133*t136*t140*t9*wg
     1         ht
            t306 = -6.848438000915289d-1*t12*t124*t15*t51
            t307 = -3.4242190004576445d-1*t12*t129*t14*t49*t78
            t308 = t307+t306+t292
            t309 = -4.69011030523806d-1*t10*t117*t124*t134*t56-2.3450551
     1         5261903d-1*t10*t118*t129*t134*t49*t54+t307+t306+t295+t292
            t310 = -6.848438000915289d-1*t12*t124*t15*t53*t58-1.17252757
     1         6309515d-1*t10*t117*t124*t134*t51*t58+1.7121095002288222d
     2         -1*t10*t12*t14*t308*t58+3.4242190004576445d-1*t12*t131*t1
     3         4*t58-5.862637881547574d-2*t10*t113*t132*t134*t51*t54-1.7
     4         121095002288222d-1*t10*t113*t12*t14*t309*t53+3.4242190004
     5         576445d-1*t10*t12*t132*t138*t14*t225*t53+3.42421900045764
     6         45d-1*t10*t113*t12*t124*t138*t15*t53-3.4242190004576445d-
     7         1*t113*t12*t132*t14*t53+t290+t289+t288-1.7121095002288222
     8         d-1*t10*t113*t12*t131*t138*t14
            t311 = 2.473556743557577d-2*t1*t310*t9*wght+7.42067023067273
     1         1d-2*t1*t124*t13*t139*wght+t287
            t312 = t136**2
            t313 = t135**2
            t314 = -3.4242190004576445d-1*t113*t12*t135*t14*t53
            t315 = -5.862637881547574d-2*t10*t113*t134*t135*t51*t54
            t316 = 5.862637881547574d-2*t134*t51*t54*t58-1.0037478013398
     1         98d-2*t10*t113*t219*t222*t53*t56+3.4242190004576445d-1*t1
     2         0*t12*t14*t225*t313*t53+t315+t314
            t317 = 2.473556743557577d-2*t1*t316*t61*t9*wght-2.4735567435
     1         57577d-2*t1*t140*t312*t9*wght
            t318 = 1.172527576309515d-1*t134*t51*t54*t58-2.0074956026797
     1         96d-2*t10*t113*t219*t222*t53*t56-2.931318940773787d-2*t10
     2         *t113*t134*t138*t51*t54+3.4242190004576445d-1*t10*t12*t13
     3         5*t138*t14*t225*t53-1.7121095002288222d-1*t113*t12*t138*t
     4         14*t53+t315+t314
            t319 = 2.473556743557577d-2*t1*t318*t61*t9*wght-2.4735567435
     1         57577d-2*t1*t136*t139*t140*t9*wght
            t320 = t139**2
            t321 = t138**2
            t322 = 2.34505515261903d-1*t134*t51*t54*t58-4.01499120535959
     1         2d-2*t10*t113*t219*t222*t53*t56-1.172527576309515d-1*t10*
     2         t113*t134*t138*t51*t54+3.4242190004576445d-1*t10*t12*t14*
     3         t225*t321*t53-6.848438000915289d-1*t113*t12*t138*t14*t53
            t323 = 1/t59**3
            t324 = t72**3
            t325 = t65**3
            t326 = 1/t4**2.3333333333333334d+0
            t327 = 6*t2*t38
            t328 = -6*t145
            t329 = t328+t327
            t330 = t69**3
            t331 = 1/t6**2.3333333333333334d+0
            t332 = -6*t2*t38
            t333 = 6*t145
            t334 = t333+t332
            t335 = 3.333333333333333d-1*t334*t71-3.333333333333333d-1*t1
     1         50*t153*t69+3.333333333333333d-1*t329*t67-3.3333333333333
     2         33d-1*t144*t148*t65+1.4814814814814814d-1*t330*t331+1.481
     3         4814814814814d-1*t325*t326
            t336 = t1**5.000000000000002d-1
            t337 = -6.525039539760956d+0*t10*t115*t14*t336*t53*t58
            t338 = 1/t1**6.666666666666665d-1
            t339 = 6.991113792601027d-1*t10*t134*t14*t338*t53*t58
            t340 = 1/t1**1.8333333333333332d+0
            t341 = 5.548503010000815d-2*t10*t14*t340*t53*t58*t74
            t342 = -4.1090628005491736d+0*t10*t117*t12*t324*t51
            t343 = 3.08179710041188d+0*t10*t12*t154*t51*t54*t72
            t344 = -7.190859900961053d+0*t10*t142*t51*t54*t73*t74
            t345 = -3.4242190004576445d-1*t10*t12*t15*t335*t51
            t346 = 2.396953300320351d+0*t10*t15*t154*t51*t73*t74
            t347 = -8.389336551121229d+0*t10*t134*t15*t155*t51*t72
            t348 = 3.9949221672005863d-1*t10*t15*t157*t51*t72*t74
            t349 = -6.525039539760956d+0*t10*t115*t14*t336*t51
            t350 = 6.991113792601027d-1*t10*t134*t14*t338*t51
            t351 = 5.548503010000815d-2*t10*t14*t340*t51*t74
            t352 = 1.0272657001372934d+0*t10*t12*t15*t209*t49*t72*t78
            t353 = 1.1984766501601755d+0*t10*t14*t209*t49*t73*t74*t78
            t354 = -3.08179710041188d+0*t10*t110*t12*t142*t49*t54*t78
            t355 = 1.0272657001372934d+0*t10*t110*t12*t15*t154*t49*t78
            t356 = -4.793906600640702d+0*t10*t110*t15*t49*t72*t73*t74*t7
     1         8
            t357 = -4.1946682755606146d+0*t10*t110*t134*t14*t155*t49*t78
            t358 = 1.9974610836002932d-1*t10*t110*t14*t157*t49*t74*t78
            t359 = 1.0272657001372934d+0*t10*t110*t12*t14*t209*t213*t214
            t360 = -5.136328500686467d-1*t10*t110*t12*t14*t209*t49*t78
            t361 = 2.425656907053823d+2*t48*t54*t72-8.085523023512744d+1
     1         *t109*t15
            t362 = 3.4242190004576445d-1*t10*t12*t14*t213*t214*t215*t361
            t363 = t85**3
            t364 = 1/t25**3
            t365 = -1.243628d-1*t18*t363*t364
            t366 = 1.865442d-1*t165*t174*t18*t85
            t367 = -8.243319792565315d-3*t164*t165*t88
            t368 = 1/t1**3.3333333333333337d+0
            t369 = 1/t1**2.0d+0
            t370 = 1/t19**7
            t371 = 1/t1**2.666666666666667d+0
            t372 = 1.0580353760417849d-1*t79*t81*t83*t84+4.2321415041671
     1         406d-1*t171*t20*t83*t84-1.269642451250142d+0*t19*(2.62541
     2         1059665811d-1*t171*t81*t82+1.9690582947493582d-1*t170*t79
     3         *t82+7.876233178997433d-1*t20*(-1.4585616998143394d-1*t21
     4         *t371*t81-5.469606374303773d-2*t21*t369*t370-1.1708185015
     5         918181d-2*t368-1.3127055298329054d-1*t169*t170*t21)-3.938
     6         1165894987163d-1*t172*t80*t81-1.4585616998143394d-1*t22*t
     7         371*t81-5.469606374303773d-2*t22*t369*t370-1.312705529832
     8         9054d-1*t169*t170*t22)*t84-6.34821225625071d-1*t173*t20*t
     9         80*t84-7.617854707500852d+0*t19*t83**3/t23**4+7.617854707
     :         500852d+0*t168*t173*t19*t83+7.053569173611901d-2*t169*t24
     ;         *t81+1.269642451250142d+0*t167*t168*t20*t80+2.35118972453
     <         73004d-1*t20*t24*t371+1.763392293402975d-2*t170*t24*t369
            t373 = -6.21814d-2*t18*t372*t86
            t374 = 8.243319792565315d-3*t174*t86*t88
            t375 = -1.0991093056753751d-2*t177*t85*t86
            t376 = 1/t1**3.333333333333333d+0
            t377 = 8.548627933030694d-3*t26*t376
            t378 = 1/t4**1.6666666666666669d+0
            t379 = 1/t6**1.6666666666666669d+0
            t380 = t93**3
            t381 = 1/t35**3
            t382 = 6.75476d-2*t30*t380*t381
            t383 = -1.013214d-1*t180*t186*t30*t93
            t384 = 2.33086476681112d-3*t179*t180*t88
            t385 = 1.0580353760417849d-1*t79*t81*t91*t92+4.2321415041671
     1         406d-1*t171*t20*t91*t92-1.269642451250142d+0*t19*(2.62541
     2         1059665811d-1*t171*t81*t90+1.9690582947493582d-1*t170*t79
     3         *t90+7.876233178997433d-1*t20*(-1.4585616998143394d-1*t31
     4         *t371*t81-5.469606374303773d-2*t31*t369*t370-6.4079313565
     5         09611d-3*t368-1.3127055298329054d-1*t169*t170*t31)-3.9381
     6         165894987163d-1*t184*t80*t81-1.4585616998143394d-1*t32*t3
     7         71*t81-5.469606374303773d-2*t32*t369*t370-1.3127055298329
     8         054d-1*t169*t170*t32)*t92-6.34821225625071d-1*t185*t20*t8
     9         0*t92-7.617854707500852d+0*t19*t91**3/t33**4+7.6178547075
     :         00852d+0*t183*t185*t19*t91+7.053569173611901d-2*t169*t34*
     ;         t81+1.269642451250142d+0*t182*t183*t20*t80+2.351189724537
     <         3004d-1*t20*t34*t371+1.763392293402975d-2*t170*t34*t369
            t386 = 3.37738d-2*t30*t385*t94
            t387 = -2.33086476681112d-3*t186*t88*t94
            t388 = 3.107819689081493d-3*t177*t93*t94
            t389 = -2.4171930915078277d-3*t36*t376
            t390 = t37*t38*(1.709920934161365d+0*(-3.10907d-2*t101*t39*(
     1         1.0580353760417849d-1*t79*t81*t98*t99+4.2321415041671406d
     2         -1*t171*t20*t98*t99-1.269642451250142d+0*t19*(2.625411059
     3         665811d-1*t171*t81*t97+1.9690582947493582d-1*t170*t79*t97
     4         +7.876233178997433d-1*t20*(-1.4585616998143394d-1*t371*t4
     5         0*t81-5.469606374303773d-2*t369*t370*t40-1.31270552983290
     6         54d-1*t169*t170*t40-7.424439106586571d-3*t368)-3.93811658
     7         94987163d-1*t194*t80*t81-1.4585616998143394d-1*t371*t41*t
     8         81-5.469606374303773d-2*t369*t370*t41-1.3127055298329054d
     9         -1*t169*t170*t41)*t99-6.34821225625071d-1*t195*t20*t80*t9
     :         9-7.617854707500852d+0*t19*t98**3/t42**4+7.61785470750085
     ;         2d+0*t19*t193*t195*t98+7.053569173611901d-2*t169*t43*t81+
     <         1.269642451250142d+0*t192*t193*t20*t80+2.3511897245373004
     =         d-1*t20*t371*t43+1.763392293402975d-2*t170*t369*t43)-8.24
     >         3319792565315d-3*t174*t86*t88+3.96311967940178d-3*t101*t1
     ?         96*t88-3.96311967940178d-3*t190*t191*t88+8.24331979256531
     @         5d-3*t164*t165*t88+1.0991093056753751d-2*t177*t85*t86+6.2
     1         1814d-2*t18*t372*t86-1.865442d-1*t165*t174*t18*t85+4.1099
     2         018897499934d-3*t376*t45-6.21814d-2*t100**3*t39/t44**3+9.
     3         327209999999999d-2*t100*t191*t196*t39-8.548627933030694d-
     4         3*t26*t376+1.243628d-1*t18*t363*t364-5.284159572535706d-3
     5         *t100*t101*t177)-3.107819689081493d-3*t177*t93*t94+2.3308
     6         6476681112d-3*t186*t88*t94-3.37738d-2*t30*t385*t94+1.0132
     7         14d-1*t180*t186*t30*t93-2.33086476681112d-3*t179*t180*t88
     8         -6.75476d-2*t30*t380*t381+2.4171930915078277d-3*t36*t376)
            t391 = -12*t104*t197*t37
            t392 = 60*t102*t200*t37
            t393 = 36*t102*t202*t38
            t394 = -120*t37*t46/t1**7
            t395 = -144*t104*t202*t46
            t396 = 24*t2*t38*t46
            t397 = 3.638485360580735d+2*t208*t54*t72-1.455394144232294d+
     1         3*t117*t154*t48*t72-4.042761511756372d+1*t15*(5.848223622
     2         634648d-1*t47*(2.564881401242048d+0*t334*t70+2.5648814012
     3         420473d+0*t153*t206*t69+2.564881401242048d+0*t329*t66+2.5
     4         648814012420473d+0*t148*t205*t65-5.69973644720455d-1*t330
     5         *t379-5.69973644720455d-1*t325*t378)+5.848223622634648d-1
     6         *t29*(240*t106*t200*t46+t396+t395+t394+t393+t392+t391+t39
     7         0+t389+t388+t387+t386+t384+t383+t382+12*t106*t197*t38-96*
     8         t102*t104*t106)+t377+t375+t374+t373+t367+t366+t365+1.7544
     9         670867903944d+0*t107*t207+1.7544670867903944d+0*t108*t204
     :         )+1.2128284535269115d+2*t335*t48*t54+3.638485360580735d+2
     ;         *t109*t154*t54+2.425656907053823d+3*t222*t324*t48-1.45539
     <         4144232294d+3*t109*t117*t142
            t398 = -1.7121095002288222d-1*t10*t12*t14*t397*t49*t78
            t399 = -2.0545314002745868d+0*t10*t12*t15*t213*t214*t215*t72
            t400 = -2.396953300320351d+0*t10*t14*t213*t214*t215*t73*t74
            t401 = 1.0272657001372934d+0*t10*t12*t15*t215*t49*t72*t78
            t402 = 1.1984766501601755d+0*t10*t14*t215*t49*t73*t74*t78
            t403 = exp(-1.2128284535269115d+2*t15*t48)
            t404 = 1/t50**4
            t405 = t110**3
            t406 = -1.0272657001372934d+0*t10*t12*t14*t403*t404*t405
            t407 = 3.4242190004576445d-1*t10*t12*t14*t213*t214*t405
            t408 = -1.7121095002288222d-1*t10*t12*t14*t405*t49*t78
            t409 = 1/t11**7.0d+0
            t410 = -5.585791092696718d+0*t114*t336*t409*t54*t56
            t411 = 3.9898507804976574d-1*t114*t219*t338*t54*t56
            t412 = 1.8999289430941224d-2*t114*t115*t340*t54*t56
            t413 = 1/t8**7.0d+0
            t414 = 1/t50**5.0d+0
            t415 = 1/t57**4
            t416 = -2.473556743557577d-2*t141*t9*wght
            t417 = 2.9682680922690924d-1*t124*t60*t72*t8*wght
            t418 = 1.4841340461345462d-1*t13*t229*t60*wght
            t419 = t327-2*t145
            t420 = t332+2*t145
            t421 = 3.333333333333333d-1*t420*t71-4.444444444444444d-1*t1
     1         45*t150*t2*t69+3.333333333333333d-1*t419*t67+4.4444444444
     2         44444d-1*t144*t145*t2*t65+1.4814814814814814d-1*t123*t149
     3         *t331+1.4814814814814814d-1*t122*t143*t326-1.111111111111
     4         111d-1*t123*t150*t153-1.111111111111111d-1*t122*t144*t148
            t422 = 1.4841340461345462d-1*t13*t133*t72*wght
            t423 = 1.4841340461345462d-1*t120*t124*t13*wght
            t424 = 4.947113487115154d-2*t247*t9*wght
            t425 = -4.793906600640702d+0*t10*t124*t53*t54*t58*t72*t73*t7
     1         4
            t426 = 1.5979688668802342d+0*t10*t15*t229*t53*t58*t73*t74
            t427 = 1.5979688668802342d+0*t10*t131*t15*t58*t72*t73*t74
            t428 = -1.5979688668802342d+0*t10*t113*t132*t15*t53*t72*t73*
     1         t74
            t429 = 1.5979688668802342d+0*t10*t112*t124*t15*t58*t73*t74
            t430 = 7.98984433440117d-1*t10*t112*t113*t132*t14*t73*t74
            t431 = -1.5979688668802342d+0*t10*t113*t119*t124*t15*t53*t73
     1         *t74
            t432 = 7.98984433440117d-1*t10*t113*t119*t131*t14*t73*t74
            t433 = -1.5979688668802342d+0*t10*t119*t132*t14*t225*t53*t73
     1         *t74
            t434 = -7.98984433440117d-1*t10*t14*t245*t58*t73*t74
            t435 = 7.98984433440117d-1*t10*t113*t14*t246*t53*t73*t74
            t436 = -4.1090628005491736d+0*t10*t117*t12*t124*t142*t51
            t437 = 1.0272657001372934d+0*t10*t12*t124*t154*t51*t54
            t438 = 2.0545314002745868d+0*t10*t12*t229*t51*t54*t72
            t439 = -4.793906600640702d+0*t10*t124*t51*t54*t72*t73*t74
            t440 = -2.396953300320351d+0*t10*t142*t51*t54*t73*t74
            t441 = 1.5979688668802342d+0*t10*t15*t229*t51*t73*t74
            t442 = -3.4242190004576445d-1*t10*t12*t15*t421*t51
            t443 = 7.98984433440117d-1*t10*t15*t154*t51*t73*t74
            t444 = -2.79644551704041d+0*t10*t124*t134*t15*t155*t51
            t445 = 1.3316407224001955d-1*t10*t124*t15*t157*t51*t74
            t446 = -5.59289103408082d+0*t10*t134*t15*t155*t51*t72
            t447 = 2.663281444800391d-1*t10*t15*t157*t51*t72*t74
            t448 = 6.848438000915289d-1*t10*t12*t15*t237*t49*t72*t78
            t449 = 7.98984433440117d-1*t10*t14*t237*t49*t73*t74*t78
            t450 = 3.4242190004576445d-1*t10*t12*t124*t15*t209*t49*t78
            t451 = 3.994922167200585d-1*t10*t14*t209*t49*t73*t74*t78
            t452 = -1.0272657001372934d+0*t10*t12*t129*t142*t49*t54*t78
            t453 = 3.4242190004576445d-1*t10*t12*t129*t15*t154*t49*t78
            t454 = -1.5979688668802342d+0*t10*t129*t15*t49*t72*t73*t74*t
     1         78
            t455 = -1.398222758520205d+0*t10*t129*t134*t14*t155*t49*t78
            t456 = 6.658203612000978d-2*t10*t129*t14*t157*t49*t74*t78
            t457 = 3.4242190004576445d-1*t10*t12*t129*t14*t209*t213*t214
            t458 = -1.7121095002288222d-1*t10*t12*t129*t14*t209*t49*t78
            t459 = -2.0545314002745868d+0*t10*t110*t12*t124*t49*t54*t72*
     1         t78
            t460 = 6.848438000915289d-1*t10*t110*t12*t15*t229*t49*t78
            t461 = -1.5979688668802342d+0*t10*t110*t124*t15*t49*t73*t74*
     1         t78
            t462 = -1.5979688668802342d+0*t10*t110*t15*t49*t72*t73*t74*t
     1         78
            t463 = -2.79644551704041d+0*t10*t110*t134*t14*t155*t49*t78
            t464 = 1.3316407224001955d-1*t10*t110*t14*t157*t49*t74*t78
            t465 = 6.848438000915289d-1*t10*t110*t12*t14*t213*t214*t237
            t466 = -3.4242190004576445d-1*t10*t110*t12*t14*t237*t49*t78
            t467 = -1.3696876001830577d+0*t10*t110*t12*t129*t15*t213*t21
     1         4*t72
            t468 = -1.5979688668802342d+0*t10*t110*t129*t14*t213*t214*t7
     1         3*t74
            t469 = 6.848438000915289d-1*t10*t110*t12*t129*t15*t49*t72*t7
     1         8
            t470 = 7.98984433440117d-1*t10*t110*t129*t14*t49*t73*t74*t78
            t471 = -12*t102*t202*t38
            t472 = 48*t104*t202*t46
            t473 = -24*t2*t38*t46
            t474 = 2.425656907053823d+2*t236*t54*t72-9.702627628215292d+
     1         2*t117*t229*t48*t72-9.702627628215292d+2*t109*t117*t124*t
     2         72-4.042761511756372d+1*t15*(5.848223622634648d-1*t47*(2.
     3         564881401242048d+0*t420*t70+3.41984186832273d+0*t145*t2*t
     4         206*t69+2.564881401242048d+0*t419*t66-3.41984186832273d+0
     5         *t145*t2*t205*t65-5.69973644720455d-1*t123*t149*t379-5.69
     6         973644720455d-1*t122*t143*t378+8.549604670806825d-1*t123*
     7         t153*t206+8.549604670806825d-1*t122*t148*t205)+5.84822362
     8         2634648d-1*t29*(t473+t472+t471+80*t106*t200*t46+t394+t392
     9         +t391+t390+t389+t388+t387+t386+t384+t383+t382+4*t106*t197
     :         *t38-32*t102*t104*t106)+t377+t375+t374+t373+t367+t366+t36
     ;         5+1.1696447245269297d+0*t107*t235+1.1696447245269297d+0*t
     <         108*t234+5.848223622634648d-1*t126*t207+5.848223622634648
     =         d-1*t127*t204)+1.2128284535269115d+2*t421*t48*t54+2.42565
     >         6907053823d+2*t109*t229*t54+1.2128284535269115d+2*t124*t2
     ?         08*t54+1.2128284535269115d+2*t128*t154*t54+2.425656907053
     @         823d+3*t124*t142*t222*t48-4.851313814107646d+2*t117*t124*
     1         t154*t48-4.851313814107646d+2*t117*t128*t142
            t475 = -1.7121095002288222d-1*t10*t12*t14*t474*t49*t78
            t476 = -6.848438000915289d-1*t10*t12*t124*t15*t213*t214*t215
            t477 = -7.98984433440117d-1*t10*t14*t213*t214*t215*t73*t74
            t478 = 3.4242190004576445d-1*t10*t12*t124*t15*t215*t49*t78
            t479 = 3.994922167200585d-1*t10*t14*t215*t49*t73*t74*t78
            t480 = -1.0272657001372934d+0*t10*t12*t129*t14*t215*t403*t40
     1         4
            t481 = 3.4242190004576445d-1*t10*t12*t129*t14*t213*t214*t215
            t482 = -1.7121095002288222d-1*t10*t12*t129*t14*t215*t49*t78
            t483 = 2.425656907053823d+2*t124*t48*t54-8.085523023512744d+
     1         1*t128*t15
            t484 = 3.4242190004576445d-1*t10*t12*t14*t213*t214*t215*t483
            t485 = -5.47179535611107d+0*t114*t115*t124*t222*t56*t72*t73
            t486 = 1.094359071222214d+0*t114*t115*t117*t229*t56*t73
            t487 = 5.47179535611107d-1*t114*t115*t118*t237*t49*t54*t73
            t488 = -2.188718142444428d+0*t114*t115*t117*t118*t129*t49*t7
     1         2*t73
            t489 = -2.188718142444428d+0*t110*t114*t115*t117*t118*t124*t
     1         49*t73
            t490 = -1.641538606833321d+0*t110*t114*t115*t129*t213*t223*t
     1         54*t73
            t491 = 5.47179535611107d-1*t110*t114*t115*t118*t129*t49*t54*
     1         t73
            t492 = -2.0d+0*t2*t38*t71-6.666666666666666d-1*t145*t71+1.48
     1         14814814814814d-1*t253*t331*t69-1.111111111111111d-1*t150
     2         *t254*t69+2.0d+0*t2*t38*t67+6.666666666666666d-1*t145*t67
     3         +1.4814814814814814d-1*t251*t326*t65-1.111111111111111d-1
     4         *t144*t252*t65-4.444444444444444d-1*t123*t145*t150*t2+4.4
     5         44444444444444d-1*t122*t144*t145*t2
            t493 = -4.1090628005491736d+0*t10*t117*t12*t250*t51*t72
            t494 = 2.0545314002745868d+0*t10*t12*t124*t229*t51*t54
            t495 = 1.0272657001372934d+0*t10*t12*t255*t51*t54*t72
            t496 = -2.396953300320351d+0*t10*t250*t51*t54*t73*t74
            t497 = -3.4242190004576445d-1*t10*t12*t15*t492*t51
            t498 = 7.98984433440117d-1*t10*t15*t255*t51*t73*t74
            t499 = -5.59289103408082d+0*t10*t124*t134*t15*t155*t51
            t500 = 2.663281444800391d-1*t10*t124*t15*t157*t51*t74
            t501 = -2.79644551704041d+0*t10*t134*t15*t155*t51*t72
            t502 = 1.3316407224001955d-1*t10*t15*t157*t51*t72*t74
            t503 = 6.848438000915289d-1*t10*t12*t124*t15*t237*t49*t78
            t504 = 3.4242190004576445d-1*t10*t12*t15*t262*t49*t72*t78
            t505 = 3.994922167200585d-1*t10*t14*t262*t49*t73*t74*t78
            t506 = -2.0545314002745868d+0*t10*t12*t124*t129*t49*t54*t72*
     1         t78
            t507 = 6.848438000915289d-1*t10*t12*t129*t15*t229*t49*t78
            t508 = -1.5979688668802342d+0*t10*t124*t129*t15*t49*t73*t74*
     1         t78
            t509 = -2.79644551704041d+0*t10*t129*t134*t14*t155*t49*t78
            t510 = 1.3316407224001955d-1*t10*t129*t14*t157*t49*t74*t78
            t511 = 6.848438000915289d-1*t10*t12*t129*t14*t213*t214*t237
            t512 = -3.4242190004576445d-1*t10*t12*t129*t14*t237*t49*t78
            t513 = -1.0272657001372934d+0*t10*t110*t12*t250*t49*t54*t78
            t514 = 3.4242190004576445d-1*t10*t110*t12*t15*t255*t49*t78
            t515 = -1.398222758520205d+0*t10*t110*t134*t14*t155*t49*t78
            t516 = 6.658203612000978d-2*t10*t110*t14*t157*t49*t74*t78
            t517 = 3.4242190004576445d-1*t10*t110*t12*t14*t213*t214*t262
            t518 = -1.7121095002288222d-1*t10*t110*t12*t14*t262*t49*t78
            t519 = -1.3696876001830577d+0*t10*t110*t12*t124*t129*t15*t21
     1         3*t214
            t520 = 6.848438000915289d-1*t10*t110*t12*t124*t129*t15*t49*t
     1         78
            t521 = 3.4242190004576445d-1*t10*t110*t12*t129*t14*t213*t214
     1         *t483
            t522 = -1.0272657001372934d+0*t10*t110*t12*t14*t266*t403*t40
     1         4
            t523 = 3.4242190004576445d-1*t10*t110*t12*t14*t213*t214*t266
            t524 = -1.7121095002288222d-1*t10*t110*t12*t14*t266*t49*t78
            t525 = 1.2128284535269115d+2*t261*t54*t72-4.851313814107646d
     1         +2*t117*t255*t48*t72+2.425656907053823d+3*t222*t250*t48*t
     2         72-9.702627628215292d+2*t117*t124*t128*t72-4.042761511756
     3         372d+1*t15*(5.848223622634648d-1*t47*(-1.5389288407452287
     4         d+1*t2*t38*t70-5.129762802484096d+0*t145*t70-5.6997364472
     5         0455d-1*t253*t379*t69+8.549604670806825d-1*t206*t254*t69+
     6         1.5389288407452287d+1*t2*t38*t66+5.129762802484096d+0*t14
     7         5*t66-5.69973644720455d-1*t251*t378*t65+8.549604670806825
     8         d-1*t205*t252*t65+3.41984186832273d+0*t123*t145*t2*t206-3
     9         .41984186832273d+0*t122*t145*t2*t205)+5.848223622634648d-
     :         1*t29*(t472+t471-80*t106*t200*t46+t396+t394+t392+t391+t39
     ;         0+t389+t388+t387+t386+t384+t383+t382-4*t106*t197*t38+32*t
     <         102*t104*t106)+t377+t375+t374+t373+t367+t366+t365+5.84822
     =         3622634648d-1*t107*t260+5.848223622634648d-1*t108*t259+1.
     >         1696447245269297d+0*t126*t235+1.1696447245269297d+0*t127*
     ?         t234)+1.2128284535269115d+2*t48*t492*t54+1.21282845352691
     @         15d+2*t109*t255*t54+2.425656907053823d+2*t124*t236*t54+2.
     1         425656907053823d+2*t128*t229*t54-9.702627628215292d+2*t11
     2         7*t124*t229*t48-4.851313814107646d+2*t109*t117*t250
            t526 = -1.7121095002288222d-1*t10*t12*t14*t49*t525*t78
            t527 = -6.848438000915289d-1*t10*t12*t15*t213*t214*t266*t72
            t528 = -7.98984433440117d-1*t10*t14*t213*t214*t266*t73*t74
            t529 = 3.4242190004576445d-1*t10*t12*t15*t266*t49*t72*t78
            t530 = 3.994922167200585d-1*t10*t14*t266*t49*t73*t74*t78
            t531 = t124**3
            t532 = t122**3
            t533 = t333+t327
            t534 = t123**3
            t535 = t332+t328
            t536 = 3.333333333333333d-1*t535*t71+3.333333333333333d-1*t5
     1         33*t67+1.4814814814814814d-1*t331*t534+1.4814814814814814
     2         d-1*t326*t532-3.333333333333333d-1*t123*t150*t254-3.33333
     3         3333333333d-1*t122*t144*t252
            t537 = -4.1090628005491736d+0*t10*t117*t12*t51*t531
            t538 = 3.08179710041188d+0*t10*t12*t124*t255*t51*t54
            t539 = -7.190859900961053d+0*t10*t250*t51*t54*t73*t74
            t540 = -3.4242190004576445d-1*t10*t12*t15*t51*t536
            t541 = 2.396953300320351d+0*t10*t15*t255*t51*t73*t74
            t542 = -8.389336551121229d+0*t10*t124*t134*t15*t155*t51
            t543 = 3.9949221672005863d-1*t10*t124*t15*t157*t51*t74
            t544 = 1.0272657001372934d+0*t10*t12*t124*t15*t262*t49*t78
            t545 = 1.1984766501601755d+0*t10*t14*t262*t49*t73*t74*t78
            t546 = -3.08179710041188d+0*t10*t12*t129*t250*t49*t54*t78
            t547 = 1.0272657001372934d+0*t10*t12*t129*t15*t255*t49*t78
            t548 = -4.793906600640702d+0*t10*t124*t129*t15*t49*t73*t74*t
     1         78
            t549 = -4.1946682755606146d+0*t10*t129*t134*t14*t155*t49*t78
            t550 = 1.9974610836002932d-1*t10*t129*t14*t157*t49*t74*t78
            t551 = 1.0272657001372934d+0*t10*t12*t129*t14*t213*t214*t262
            t552 = -5.136328500686467d-1*t10*t12*t129*t14*t262*t49*t78
            t553 = 3.4242190004576445d-1*t10*t12*t14*t213*t214*t266*t483
            t554 = -4.042761511756372d+1*t15*(5.848223622634648d-1*t47*(
     1         2.564881401242048d+0*t535*t70+2.564881401242048d+0*t533*t
     2         66-5.69973644720455d-1*t379*t534-5.69973644720455d-1*t378
     3         *t532+2.5648814012420473d+0*t123*t206*t254+2.564881401242
     4         0473d+0*t122*t205*t252)+5.848223622634648d-1*t29*(t473-24
     5         0*t106*t200*t46+t395+t394+t393+t392+t391+t390+t389+t388+t
     6         387+t386+t384+t383+t382-12*t106*t197*t38+96*t102*t104*t10
     7         6)+t377+t375+t374+t373+t367+t366+t365+1.7544670867903944d
     8         +0*t126*t260+1.7544670867903944d+0*t127*t259)+1.212828453
     9         5269115d+2*t48*t536*t54+3.638485360580735d+2*t124*t261*t5
     :         4+3.638485360580735d+2*t128*t255*t54+2.425656907053823d+3
     ;         *t222*t48*t531-1.455394144232294d+3*t117*t124*t255*t48-1.
     <         455394144232294d+3*t117*t128*t250
            t555 = -1.7121095002288222d-1*t10*t12*t14*t49*t554*t78
            t556 = -2.0545314002745868d+0*t10*t12*t124*t15*t213*t214*t26
     1         6
            t557 = -2.396953300320351d+0*t10*t14*t213*t214*t266*t73*t74
            t558 = 1.0272657001372934d+0*t10*t12*t124*t15*t266*t49*t78
            t559 = 1.1984766501601755d+0*t10*t14*t266*t49*t73*t74*t78
            t560 = t129**3
            t561 = -1.0272657001372934d+0*t10*t12*t14*t403*t404*t560
            t562 = 3.4242190004576445d-1*t10*t12*t14*t213*t214*t560
            t563 = -1.7121095002288222d-1*t10*t12*t14*t49*t560*t78
            t564 = -1.398222758520205d+0*t10*t113*t134*t135*t14*t155*t53
            t565 = 6.658203612000978d-2*t10*t113*t135*t14*t157*t53*t74
            t566 = 1.5979688668802342d+0*t15*t53*t58*t72*t73*t74
            t567 = 1.398222758520205d+0*t134*t14*t155*t53*t58
            t568 = -6.658203612000978d-2*t14*t157*t53*t58*t74
            t569 = 2.735897678055535d-1*t10*t115*t117*t51*t58*t72*t73
            t570 = 2.3939104682985932d-1*t10*t155*t219*t51*t54*t58
            t571 = -1.1399573658564734d-2*t10*t115*t157*t51*t54*t58
            t572 = -7.98984433440117d-1*t112*t14*t58*t73*t74
            t573 = 7.98984433440117d-1*t113*t119*t14*t53*t73*t74
            t574 = 1.3679488390277675d-1*t10*t113*t115*t119*t51*t54*t73
            t575 = 1.0272657001372934d+0*t12*t142*t51*t54
            t576 = -3.4242190004576445d-1*t12*t15*t154*t51
            t577 = 1.5979688668802342d+0*t15*t51*t72*t73*t74
            t578 = 1.398222758520205d+0*t134*t14*t155*t51
            t579 = -6.658203612000978d-2*t14*t157*t51*t74
            t580 = -1.7121095002288222d-1*t12*t14*t209*t49*t78
            t581 = 6.848438000915289d-1*t110*t12*t15*t49*t72*t78
            t582 = 7.98984433440117d-1*t110*t14*t49*t73*t74*t78
            t583 = 3.4242190004576445d-1*t12*t14*t213*t214*t215
            t584 = -1.7121095002288222d-1*t12*t14*t215*t49*t78
            t585 = 2.188718142444428d+0*t10*t115*t117*t56*t72*t73
            t586 = 1.5959403121990623d+0*t10*t155*t219*t54*t56
            t587 = -4.5598294634258935d-2*t10*t115*t157*t54*t56
            t588 = 1.094359071222214d+0*t10*t110*t115*t118*t49*t54*t73
            t589 = t61*(2.473556743557577d-2*t1*(-1.5979688668802342d+0*
     1         t10*t113*t135*t15*t53*t72*t73*t74-7.98984433440117d-1*t10
     2         *t14*t281*t58*t73*t74+7.98984433440117d-1*t10*t113*t14*t2
     3         83*t53*t73*t74-1.5979688668802342d+0*t10*t119*t135*t14*t2
     4         25*t53*t73*t74+7.98984433440117d-1*t10*t112*t113*t135*t14
     5         *t73*t74-1.7121095002288222d-1*t10*t113*t12*t14*t53*(9.38
     6         022061047612d-1*t10*t110*t117*t118*t134*t49*t72+t588+t587
     7         +t586+t585+t584+t583+t582+t581+t580+t579+t578+t577+t576+t
     8         575+1.1725275763095148d+0*t10*t134*t142*t222*t56-2.345055
     9         15261903d-1*t10*t117*t134*t154*t56-1.172527576309515d-1*t
     :         10*t118*t134*t215*t49*t54-1.172527576309515d-1*t10*t118*t
     ;         134*t209*t49*t54+3.517582728928545d-1*t10*t134*t213*t215*
     <         t223*t54)-6.848438000915289d-1*t10*t12*t15*t281*t58*t72-6
     =         .848438000915289d-1*t112*t12*t15*t58*t72+6.84843800091528
     >         9d-1*t10*t113*t12*t15*t283*t53*t72-1.3696876001830577d+0*
     ?         t10*t119*t12*t135*t15*t225*t53*t72+6.848438000915289d-1*t
     @         113*t119*t12*t15*t53*t72+1.172527576309515d-1*t10*t113*t1
     1         17*t119*t134*t51*t72+6.848438000915289d-1*t10*t112*t113*t
     2         12*t135*t15*t72+1.7121095002288222d-1*t10*t12*t14*t58*(t5
     3         84+t583+t582+t581+t580+t579+t578+t577+t576+t575)+1.027265
     4         7001372934d+0*t12*t142*t53*t54*t58-3.4242190004576445d-1*
     5         t12*t15*t154*t53*t58+1.7587913644642725d-1*t10*t134*t142*
     6         t222*t51*t58-5.862637881547574d-2*t10*t117*t134*t154*t51*
     7         t58+1.7121095002288222d-1*t12*t14*t218*t58+t574+t573+t572
     8         +t571+t570+t569+t568+t567+t566+t565+t564-1.02726570013729
     9         34d+0*t10*t113*t12*t135*t142*t53*t54+5.862637881547574d-2
     :         *t10*t134*t225*t226*t51*t54-2.931318940773787d-2*t10*t113
     ;         *t134*t224*t51*t54-1.0272657001372934d+0*t10*t12*t135*t14
     <         *t226*t415*t53+6.848438000915289d-1*t10*t119*t12*t14*t225
     =         *t283*t53+3.4242190004576445d-1*t12*t14*t225*t226*t53+3.4
     >         242190004576445d-1*t10*t12*t135*t14*t224*t225*t53-1.71210
     ?         95002288222d-1*t113*t12*t14*t224*t53+3.4242190004576445d-
     @         1*t10*t113*t12*t135*t15*t154*t53-3.4242190004576445d-1*t1
     1         0*t112*t113*t12*t14*t283-3.4242190004576445d-1*t10*t113*t
     2         119*t12*t14*t281+6.848438000915289d-1*t10*t112*t119*t12*t
     3         135*t14*t225-1.7121095002288222d-1*t10*t113*t12*t135*t14*
     4         t218-3.4242190004576445d-1*t112*t113*t119*t12*t14)*t9*wgh
     5         t+4.947113487115154d-2*t284*t9*wght+1.4841340461345462d-1
     6         *t1*t136*t142*t8*wght+1.4841340461345462d-1*t1*t13*t284*t
     7         72*wght+1.4841340461345462d-1*t13*t136*t72*wght+7.4206702
     8         30672731d-2*t1*t13*t136*t154*wght)+t140*(-4.9471134871151
     9         54d-2*t1*t120*t284*t9*wght-t136*t228)+4.947113487115154d-
     :         2*t1*t136*t141*t323*t9*wght
            t590 = -1.398222758520205d+0*t10*t113*t134*t138*t14*t155*t53
            t591 = 6.658203612000978d-2*t10*t113*t138*t14*t157*t53*t74
            t592 = 2.79644551704041d+0*t134*t14*t155*t53*t58
            t593 = -1.3316407224001955d-1*t14*t157*t53*t58*t74
            t594 = 4.7878209365971863d-1*t10*t155*t219*t51*t54*t58
            t595 = -2.2799147317129467d-2*t10*t115*t157*t51*t54*t58
            t596 = 2.0545314002745868d+0*t12*t142*t51*t54
            t597 = -6.848438000915289d-1*t12*t15*t154*t51
            t598 = 3.1959377337604683d+0*t15*t51*t72*t73*t74
            t599 = 2.79644551704041d+0*t134*t14*t155*t51
            t600 = -1.3316407224001955d-1*t14*t157*t51*t74
            t601 = -3.4242190004576445d-1*t12*t14*t209*t49*t78
            t602 = 1.3696876001830577d+0*t110*t12*t15*t49*t72*t78
            t603 = 1.5979688668802342d+0*t110*t14*t49*t73*t74*t78
            t604 = 6.848438000915289d-1*t12*t14*t213*t214*t215
            t605 = -3.4242190004576445d-1*t12*t14*t215*t49*t78
            t606 = 3.1918806243981246d+0*t10*t155*t219*t54*t56
            t607 = -9.119658926851787d-2*t10*t115*t157*t54*t56
            t608 = 1.0272657001372934d+0*t12*t124*t51*t54*t72
            t609 = -3.4242190004576445d-1*t12*t15*t229*t51
            t610 = 7.98984433440117d-1*t124*t15*t51*t73*t74
            t611 = 7.98984433440117d-1*t15*t51*t72*t73*t74
            t612 = -1.7121095002288222d-1*t12*t14*t237*t49*t78
            t613 = 3.4242190004576445d-1*t12*t129*t15*t49*t72*t78
            t614 = 3.994922167200585d-1*t129*t14*t49*t73*t74*t78
            t615 = 3.4242190004576445d-1*t110*t12*t124*t15*t49*t78
            t616 = 3.994922167200585d-1*t110*t14*t49*t73*t74*t78
            t617 = 3.4242190004576445d-1*t110*t12*t129*t14*t213*t214
            t618 = -1.7121095002288222d-1*t110*t12*t129*t14*t49*t78
            t619 = t61*(2.473556743557577d-2*t1*(7.98984433440117d-1*t15
     1         *t53*t58*t72*t73*t74-7.98984433440117d-1*t10*t113*t135*t1
     2         5*t53*t72*t73*t74+7.98984433440117d-1*t124*t15*t53*t58*t7
     3         3*t74-3.994922167200585d-1*t10*t14*t301*t58*t73*t74-3.994
     4         922167200585d-1*t10*t14*t281*t58*t73*t74-3.99492216720058
     5         5d-1*t131*t14*t58*t73*t74-3.994922167200585d-1*t112*t14*t
     6         58*t73*t74+3.994922167200585d-1*t10*t113*t14*t302*t53*t73
     7         *t74+3.994922167200585d-1*t10*t113*t14*t283*t53*t73*t74-7
     8         .98984433440117d-1*t10*t132*t135*t14*t225*t53*t73*t74-7.9
     9         8984433440117d-1*t10*t119*t135*t14*t225*t53*t73*t74-7.989
     :         84433440117d-1*t10*t113*t124*t135*t15*t53*t73*t74+3.99492
     ;         2167200585d-1*t113*t132*t14*t53*t73*t74+3.994922167200585
     <         d-1*t113*t119*t14*t53*t73*t74+3.994922167200585d-1*t10*t1
     =         13*t131*t135*t14*t73*t74+3.994922167200585d-1*t10*t112*t1
     >         13*t135*t14*t73*t74-1.7121095002288222d-1*t10*t113*t12*t1
     ?         4*t53*(1.094359071222214d+0*t10*t115*t117*t56*t72*t73+1.0
     @         94359071222214d+0*t10*t115*t117*t124*t56*t73+5.4717953561
     1         1107d-1*t10*t115*t118*t129*t49*t54*t73+5.47179535611107d-
     2         1*t10*t110*t115*t118*t49*t54*t73+1.1725275763095148d+0*t1
     3         0*t124*t134*t222*t56*t72+4.69011030523806d-1*t10*t117*t11
     4         8*t129*t134*t49*t72+t618+t617+t616+t615+t614+t613+t612+t6
     5         11+t610+t609+t608+t587+t586+t579+t578-2.34505515261903d-1
     6         *t10*t117*t134*t229*t56-1.172527576309515d-1*t10*t118*t13
     7         4*t237*t49*t54-1.172527576309515d-1*t10*t110*t118*t129*t1
     8         34*t49*t54+3.517582728928545d-1*t10*t110*t129*t134*t213*t
     9         223*t54+4.69011030523806d-1*t10*t110*t117*t118*t124*t134*
     :         t49)+1.3679488390277675d-1*t10*t115*t117*t51*t58*t72*t73+
     ;         1.3679488390277675d-1*t10*t115*t117*t124*t51*t58*t73+6.83
     <         9744195138837d-2*t10*t113*t115*t132*t51*t54*t73+6.8397441
     =         95138837d-2*t10*t113*t115*t119*t51*t54*t73+1.027265700137
     >         2934d+0*t12*t124*t53*t54*t58*t72+1.7587913644642725d-1*t1
     ?         0*t124*t134*t222*t51*t58*t72-3.4242190004576445d-1*t10*t1
     @         2*t15*t301*t58*t72-3.4242190004576445d-1*t12*t131*t15*t58
     1         *t72-1.0272657001372934d+0*t10*t113*t12*t124*t135*t53*t54
     2         *t72+3.4242190004576445d-1*t10*t113*t12*t15*t302*t53*t72-
     3         6.848438000915289d-1*t10*t12*t132*t135*t15*t225*t53*t72+3
     4         .4242190004576445d-1*t113*t12*t132*t15*t53*t72+5.86263788
     5         1547574d-2*t10*t113*t117*t132*t134*t51*t72+3.424219000457
     6         6445d-1*t10*t113*t12*t131*t135*t15*t72+1.7121095002288222
     7         d-1*t10*t12*t14*t58*(t618+t617+t616+t615+t614+t613+t612+t
     8         611+t610+t609+t608+t579+t578)-3.4242190004576445d-1*t12*t
     9         15*t229*t53*t58-5.862637881547574d-2*t10*t117*t134*t229*t
     :         51*t58-3.4242190004576445d-1*t10*t12*t124*t15*t281*t58+1.
     ;         7121095002288222d-1*t12*t14*t245*t58-3.4242190004576445d-
     <         1*t112*t12*t124*t15*t58+t571+t570+t568+t567+t565+t564-2.9
     =         31318940773787d-2*t10*t113*t134*t246*t51*t54+5.8626378815
     >         47574d-2*t10*t119*t132*t134*t225*t51*t54-1.02726570013729
     ?         34d+0*t10*t119*t12*t132*t135*t14*t415*t53+3.4242190004576
     @         445d-1*t10*t119*t12*t14*t225*t302*t53+3.4242190004576445d
     1         -1*t10*t12*t132*t14*t225*t283*t53+3.4242190004576445d-1*t
     2         10*t113*t12*t124*t15*t283*t53+3.4242190004576445d-1*t10*t
     3         12*t135*t14*t225*t246*t53-1.7121095002288222d-1*t113*t12*
     4         t14*t246*t53+3.4242190004576445d-1*t10*t113*t12*t135*t15*
     5         t229*t53-6.848438000915289d-1*t10*t119*t12*t124*t135*t15*
     6         t225*t53+3.4242190004576445d-1*t119*t12*t132*t14*t225*t53
     7         +3.4242190004576445d-1*t113*t119*t12*t124*t15*t53+5.86263
     8         7881547574d-2*t10*t113*t117*t119*t124*t134*t51-1.71210950
     9         02288222d-1*t10*t112*t113*t12*t14*t302-1.7121095002288222
     :         d-1*t10*t113*t119*t12*t14*t301-1.7121095002288222d-1*t10*
     ;         t113*t12*t131*t14*t283-1.7121095002288222d-1*t10*t113*t12
     <         *t132*t14*t281-1.7121095002288222d-1*t10*t113*t12*t135*t1
     =         4*t245+3.4242190004576445d-1*t10*t112*t12*t132*t135*t14*t
     >         225+3.4242190004576445d-1*t10*t119*t12*t131*t135*t14*t225
     ?         +3.4242190004576445d-1*t10*t112*t113*t12*t124*t135*t15-1.
     @         7121095002288222d-1*t112*t113*t12*t132*t14-1.712109500228
     1         8222d-1*t113*t119*t12*t131*t14)*t9*wght+2.473556743557577
     2         d-2*t303*t9*wght+2.473556743557577d-2*t284*t9*wght+1.4841
     3         340461345462d-1*t1*t124*t136*t72*t8*wght+7.42067023067273
     4         1d-2*t1*t13*t303*t72*wght+7.420670230672731d-2*t13*t136*t
     5         72*wght+7.420670230672731d-2*t1*t124*t13*t284*wght+7.4206
     6         70230672731d-2*t1*t13*t136*t229*wght+7.420670230672731d-2
     7         *t124*t13*t136*wght)+t140*(-2.473556743557577d-2*t1*t120*
     8         t303*t9*wght-2.473556743557577d-2*t1*t133*t284*t9*wght-t1
     9         36*t248)+4.947113487115154d-2*t1*t120*t133*t136*t323*t9*w
     :         ght
            t620 = 1.5979688668802342d+0*t124*t15*t53*t58*t73*t74
            t621 = 2.735897678055535d-1*t10*t115*t117*t124*t51*t58*t73
            t622 = -7.98984433440117d-1*t131*t14*t58*t73*t74
            t623 = 7.98984433440117d-1*t113*t132*t14*t53*t73*t74
            t624 = 1.3679488390277675d-1*t10*t113*t115*t132*t51*t54*t73
            t625 = 2.0545314002745868d+0*t12*t124*t51*t54*t72
            t626 = -6.848438000915289d-1*t12*t15*t229*t51
            t627 = 1.5979688668802342d+0*t124*t15*t51*t73*t74
            t628 = -3.4242190004576445d-1*t12*t14*t237*t49*t78
            t629 = 6.848438000915289d-1*t12*t129*t15*t49*t72*t78
            t630 = 7.98984433440117d-1*t129*t14*t49*t73*t74*t78
            t631 = 6.848438000915289d-1*t110*t12*t124*t15*t49*t78
            t632 = 6.848438000915289d-1*t110*t12*t129*t14*t213*t214
            t633 = -3.4242190004576445d-1*t110*t12*t129*t14*t49*t78
            t634 = 2.188718142444428d+0*t10*t115*t117*t124*t56*t73
            t635 = 1.094359071222214d+0*t10*t115*t118*t129*t49*t54*t73
            t636 = 1.0272657001372934d+0*t12*t250*t51*t54
            t637 = -3.4242190004576445d-1*t12*t15*t255*t51
            t638 = -1.7121095002288222d-1*t12*t14*t262*t49*t78
            t639 = 6.848438000915289d-1*t12*t124*t129*t15*t49*t78
            t640 = 3.4242190004576445d-1*t12*t14*t213*t214*t266
            t641 = -1.7121095002288222d-1*t12*t14*t266*t49*t78
            t642 = t61*(2.473556743557577d-2*t1*(-7.98984433440117d-1*t1
     1         0*t14*t301*t58*t73*t74+7.98984433440117d-1*t10*t113*t14*t
     2         302*t53*t73*t74-1.5979688668802342d+0*t10*t132*t135*t14*t
     3         225*t53*t73*t74-1.5979688668802342d+0*t10*t113*t124*t135*
     4         t15*t53*t73*t74+7.98984433440117d-1*t10*t113*t131*t135*t1
     5         4*t73*t74-1.7121095002288222d-1*t10*t113*t12*t14*t53*(t64
     6         1+t640+t639+t638+t637+t636+t635+t634+t630+t627+t587+t586+
     7         t579+t578-2.34505515261903d-1*t10*t117*t134*t255*t56+1.17
     8         25275763095148d+0*t10*t134*t222*t250*t56-1.17252757630951
     9         5d-1*t10*t118*t134*t266*t49*t54-1.172527576309515d-1*t10*
     :         t118*t134*t262*t49*t54+3.517582728928545d-1*t10*t134*t213
     ;         *t223*t266*t54+9.38022061047612d-1*t10*t117*t118*t124*t12
     <         9*t134*t49)+1.7121095002288222d-1*t10*t12*t14*t58*(t641+t
     =         640+t639+t638+t637+t636+t630+t627+t579+t578)+t624+t623+t6
     >         22+t621+t620+1.0272657001372934d+0*t12*t250*t53*t54*t58-3
     ?         .4242190004576445d-1*t12*t15*t255*t53*t58-5.8626378815475
     @         74d-2*t10*t117*t134*t255*t51*t58+1.7587913644642725d-1*t1
     1         0*t134*t222*t250*t51*t58-6.848438000915289d-1*t10*t12*t12
     2         4*t15*t301*t58+1.7121095002288222d-1*t12*t14*t269*t58-6.8
     3         48438000915289d-1*t12*t124*t131*t15*t58+t571+t570+t568+t5
     4         67+t565+t564-1.0272657001372934d+0*t10*t113*t12*t135*t250
     5         *t53*t54+5.862637881547574d-2*t10*t134*t225*t271*t51*t54-
     6         2.931318940773787d-2*t10*t113*t134*t270*t51*t54-1.0272657
     7         001372934d+0*t10*t12*t135*t14*t271*t415*t53+6.84843800091
     8         5289d-1*t10*t12*t132*t14*t225*t302*t53+6.848438000915289d
     9         -1*t10*t113*t12*t124*t15*t302*t53+3.4242190004576445d-1*t
     :         12*t14*t225*t271*t53+3.4242190004576445d-1*t10*t12*t135*t
     ;         14*t225*t270*t53-1.7121095002288222d-1*t113*t12*t14*t270*
     <         t53+3.4242190004576445d-1*t10*t113*t12*t135*t15*t255*t53-
     =         1.3696876001830577d+0*t10*t12*t124*t132*t135*t15*t225*t53
     >         +6.848438000915289d-1*t113*t12*t124*t132*t15*t53+1.172527
     ?         576309515d-1*t10*t113*t117*t124*t132*t134*t51-3.424219000
     @         4576445d-1*t10*t113*t12*t131*t14*t302-3.4242190004576445d
     1         -1*t10*t113*t12*t132*t14*t301-1.7121095002288222d-1*t10*t
     2         113*t12*t135*t14*t269+6.848438000915289d-1*t10*t12*t131*t
     3         132*t135*t14*t225+6.848438000915289d-1*t10*t113*t12*t124*
     4         t131*t135*t15-3.4242190004576445d-1*t113*t12*t131*t132*t1
     5         4)*t9*wght+4.947113487115154d-2*t303*t9*wght+1.4841340461
     6         345462d-1*t1*t136*t250*t8*wght+1.4841340461345462d-1*t1*t
     7         124*t13*t303*wght+7.420670230672731d-2*t1*t13*t136*t255*w
     8         ght+1.4841340461345462d-1*t124*t13*t136*wght)+t140*(-4.94
     9         7113487115154d-2*t1*t133*t303*t9*wght-t136*t273)+4.947113
     :         487115154d-2*t1*t136*t249*t323*t9*wght
            t643 = 2.0545314002745868d+0*t12*t250*t51*t54
            t644 = -6.848438000915289d-1*t12*t15*t255*t51
            t645 = 3.1959377337604683d+0*t124*t15*t51*t73*t74
            t646 = -3.4242190004576445d-1*t12*t14*t262*t49*t78
            t647 = 1.3696876001830577d+0*t12*t124*t129*t15*t49*t78
            t648 = 1.5979688668802342d+0*t129*t14*t49*t73*t74*t78
            t649 = 6.848438000915289d-1*t12*t14*t213*t214*t266
            t650 = -3.4242190004576445d-1*t12*t14*t266*t49*t78
            t651 = 2.473556743557577d-2*t316*t9*wght
            t652 = -7.98984433440117d-1*t10*t14*t225*t313*t53*t73*t74
            t653 = 6.848438000915289d-1*t113*t12*t135*t15*t53*t72
            t654 = 7.98984433440117d-1*t113*t135*t14*t53*t73*t74
            t655 = 2.3420782031264287d-2*t10*t113*t222*t409*t53*t56*t73
            t656 = 1.172527576309515d-1*t10*t113*t117*t134*t135*t51*t72
            t657 = 1.3679488390277675d-1*t10*t113*t115*t135*t51*t54*t73
            t658 = -1.3679488390277675d-1*t115*t51*t54*t58*t73
            t659 = -2.735897678055535d-1*t115*t54*t56*t73
            t660 = 3.4242190004576445d-1*t12*t14*t281*t58
            t661 = -3.4242190004576445d-1*t113*t12*t14*t283*t53
            t662 = -5.862637881547574d-2*t10*t113*t134*t283*t51*t54
            t663 = -3.4242190004576445d-1*t112*t113*t12*t135*t14
            t664 = 6.848438000915289d-1*t119*t12*t135*t14*t225*t53
            t665 = 1.172527576309515d-1*t10*t119*t134*t135*t225*t51*t54
            t666 = t61*(2.473556743557577d-2*t1*(-1.7121095002288222d-1*
     1         t10*t113*t12*t14*t53*(-2.34505515261903d-1*t117*t134*t56*
     2         t72+t659-1.172527576309515d-1*t110*t118*t134*t49*t54)-1.1
     3         72527576309515d-1*t117*t134*t51*t58*t72+2.007495602679796
     4         d-2*t10*t113*t219*t413*t53*t56*t72-6.848438000915289d-1*t
     5         10*t12*t15*t225*t313*t53*t72+t665+t664+t663+t662+t661+t66
     6         0+t658+t657+t656+t655+t654+t653+t652+2.007495602679796d-2
     7         *t10*t119*t219*t222*t225*t53*t56-1.003747801339898d-2*t10
     8         *t112*t113*t219*t222*t56-5.862637881547574d-2*t113*t119*t
     9         134*t51*t54-1.0272657001372934d+0*t10*t119*t12*t14*t313*t
     :         415*t53+6.848438000915289d-1*t10*t12*t135*t14*t225*t283*t
     ;         53+3.4242190004576445d-1*t10*t112*t12*t14*t225*t313-3.424
     <         2190004576445d-1*t10*t113*t12*t135*t14*t281)*t9*wght+7.42
     =         0670230672731d-2*t1*t13*t316*t72*wght+t651)+t140*(-2.4735
     >         56743557577d-2*t1*t120*t316*t9*wght-2.473556743557577d-2*
     ?         t1*t136*t284*t9*wght-t136*t285)+4.947113487115154d-2*t1*t
     @         120*t312*t323*t9*wght
            t667 = 4.947113487115154d-2*t1*t120*t136*t139*t323*t9*wght
            t668 = 2.473556743557577d-2*t318*t9*wght
            t669 = -7.98984433440117d-1*t10*t135*t138*t14*t225*t53*t73*t
     1         74
            t670 = 3.994922167200585d-1*t113*t138*t14*t53*t73*t74
            t671 = 4.6841564062528573d-2*t10*t113*t222*t409*t53*t56*t73
            t672 = 6.839744195138837d-2*t10*t113*t115*t138*t51*t54*t73
            t673 = -2.735897678055535d-1*t115*t51*t54*t58*t73
            t674 = -5.47179535611107d-1*t115*t54*t56*t73
            t675 = t61*(2.473556743557577d-2*t1*(-1.7121095002288222d-1*
     1         t10*t113*t12*t14*t53*(-4.69011030523806d-1*t117*t134*t56*
     2         t72+t674-2.34505515261903d-1*t110*t118*t134*t49*t54)-2.34
     3         505515261903d-1*t117*t134*t51*t58*t72+4.014991205359592d-
     4         2*t10*t113*t219*t413*t53*t56*t72-6.848438000915289d-1*t10
     5         *t12*t135*t138*t15*t225*t53*t72+3.4242190004576445d-1*t11
     6         3*t12*t138*t15*t53*t72+5.862637881547574d-2*t10*t113*t117
     7         *t134*t138*t51*t72+t673+t672+t671+t670+t669+t665+t664+t66
     8         3+t662+t661+t660+t657+t656+t654+t653+1.7121095002288222d-
     9         1*t12*t14*t294*t58+4.014991205359592d-2*t10*t119*t219*t22
     :         2*t225*t53*t56-2.007495602679796d-2*t10*t112*t113*t219*t2
     ;         22*t56-2.931318940773787d-2*t10*t113*t134*t296*t51*t54+5.
     <         862637881547574d-2*t10*t119*t134*t138*t225*t51*t54-1.1725
     =         27576309515d-1*t113*t119*t134*t51*t54-1.0272657001372934d
     >         +0*t10*t119*t12*t135*t138*t14*t415*t53+3.4242190004576445
     ?         d-1*t10*t12*t135*t14*t225*t296*t53-1.7121095002288222d-1*
     @         t113*t12*t14*t296*t53+3.4242190004576445d-1*t10*t12*t138*
     1         t14*t225*t283*t53+3.4242190004576445d-1*t119*t12*t138*t14
     2         *t225*t53-1.7121095002288222d-1*t10*t113*t12*t135*t14*t29
     3         4-1.7121095002288222d-1*t10*t113*t12*t138*t14*t281+3.4242
     4         190004576445d-1*t10*t112*t12*t135*t138*t14*t225-1.7121095
     5         002288222d-1*t112*t113*t12*t138*t14)*t9*wght+7.4206702306
     6         72731d-2*t1*t13*t318*t72*wght+t668)
            t676 = -2.473556743557577d-2*t1*t120*t318*t9*wght
            t677 = 2.473556743557577d-2*t322*t9*wght
            t678 = -7.98984433440117d-1*t10*t14*t225*t321*t53*t73*t74
            t679 = 1.5979688668802342d+0*t113*t138*t14*t53*t73*t74
            t680 = 9.368312812505715d-2*t10*t113*t222*t409*t53*t56*t73
            t681 = 2.735897678055535d-1*t10*t113*t115*t138*t51*t54*t73
            t682 = -5.47179535611107d-1*t115*t51*t54*t58*t73
            t683 = -1.094359071222214d+0*t115*t54*t56*t73
            t684 = 6.848438000915289d-1*t113*t12*t124*t135*t15*t53
            t685 = 1.172527576309515d-1*t10*t113*t117*t124*t134*t135*t51
            t686 = 3.4242190004576445d-1*t12*t14*t301*t58
            t687 = -3.4242190004576445d-1*t113*t12*t14*t302*t53
            t688 = -5.862637881547574d-2*t10*t113*t134*t302*t51*t54
            t689 = -3.4242190004576445d-1*t113*t12*t131*t135*t14
            t690 = 6.848438000915289d-1*t12*t132*t135*t14*t225*t53
            t691 = 1.172527576309515d-1*t10*t132*t134*t135*t225*t51*t54
            t692 = t61*(2.473556743557577d-2*t1*(t691+t690+t689+t688+t68
     1         7+t686+t685+t684-1.7121095002288222d-1*t10*t113*t12*t14*t
     2         53*(t659-2.34505515261903d-1*t117*t124*t134*t56-1.1725275
     3         76309515d-1*t118*t129*t134*t49*t54)+t658+t657+t655+t654+t
     4         652-1.172527576309515d-1*t117*t124*t134*t51*t58+2.0074956
     5         02679796d-2*t10*t113*t124*t219*t413*t53*t56+2.00749560267
     6         9796d-2*t10*t132*t219*t222*t225*t53*t56-1.003747801339898
     7         d-2*t10*t113*t131*t219*t222*t56-5.862637881547574d-2*t113
     8         *t132*t134*t51*t54-1.0272657001372934d+0*t10*t12*t132*t14
     9         *t313*t415*t53-6.848438000915289d-1*t10*t12*t124*t15*t225
     :         *t313*t53+6.848438000915289d-1*t10*t12*t135*t14*t225*t302
     ;         *t53+3.4242190004576445d-1*t10*t12*t131*t14*t225*t313-3.4
     <         242190004576445d-1*t10*t113*t12*t135*t14*t301)*t9*wght+7.
     =         420670230672731d-2*t1*t124*t13*t316*wght+t651)+t140*(-2.4
     >         73556743557577d-2*t1*t133*t316*t9*wght-2.473556743557577d
     ?         -2*t1*t136*t303*t9*wght-t136*t304)+4.947113487115154d-2*t
     @         1*t133*t312*t323*t9*wght
            t693 = 4.947113487115154d-2*t1*t133*t136*t139*t323*t9*wght
            t694 = t61*(2.473556743557577d-2*t1*(t691+t690+t689+t688+t68
     1         7+t686+t685+t684-1.7121095002288222d-1*t10*t113*t12*t14*t
     2         53*(t674-4.69011030523806d-1*t117*t124*t134*t56-2.3450551
     3         5261903d-1*t118*t129*t134*t49*t54)+t673+t672+t671+t670+t6
     4         69+t657+t654-2.34505515261903d-1*t117*t124*t134*t51*t58+1
     5         .7121095002288222d-1*t12*t14*t308*t58+4.014991205359592d-
     6         2*t10*t113*t124*t219*t413*t53*t56+4.014991205359592d-2*t1
     7         0*t132*t219*t222*t225*t53*t56-2.007495602679796d-2*t10*t1
     8         13*t131*t219*t222*t56-2.931318940773787d-2*t10*t113*t134*
     9         t309*t51*t54+5.862637881547574d-2*t10*t132*t134*t138*t225
     :         *t51*t54-1.172527576309515d-1*t113*t132*t134*t51*t54-1.02
     ;         72657001372934d+0*t10*t12*t132*t135*t138*t14*t415*t53+3.4
     <         242190004576445d-1*t10*t12*t135*t14*t225*t309*t53-1.71210
     =         95002288222d-1*t113*t12*t14*t309*t53+3.4242190004576445d-
     >         1*t10*t12*t138*t14*t225*t302*t53-6.848438000915289d-1*t10
     ?         *t12*t124*t135*t138*t15*t225*t53+3.4242190004576445d-1*t1
     @         2*t132*t138*t14*t225*t53+3.4242190004576445d-1*t113*t12*t
     1         124*t138*t15*t53+5.862637881547574d-2*t10*t113*t117*t124*
     2         t134*t138*t51-1.7121095002288222d-1*t10*t113*t12*t135*t14
     3         *t308-1.7121095002288222d-1*t10*t113*t12*t138*t14*t301+3.
     4         4242190004576445d-1*t10*t12*t131*t135*t138*t14*t225-1.712
     5         1095002288222d-1*t113*t12*t131*t138*t14)*t9*wght+7.420670
     6         230672731d-2*t1*t124*t13*t318*wght+t668)
            t695 = -2.473556743557577d-2*t1*t133*t318*t9*wght
            t696 = 1/t11**8.0d+0
            t697 = 1/t8**8.0d+0
            t698 = 2.473556743557577d-2*t1*t61*(-5.155578439523496d-3*t1
     1         0*t113*t118*t696*t697+6.022486808039389d-2*t10*t135*t219*
     2         t222*t225*t53*t56-3.0112434040196945d-2*t113*t219*t222*t5
     3         3*t56+1.7587913644642725d-1*t10*t134*t225*t313*t51*t54-1.
     4         7587913644642725d-1*t113*t134*t135*t51*t54-1.027265700137
     5         2934d+0*t10*t12*t135**3*t14*t415*t53+1.0272657001372934d+
     6         0*t12*t14*t225*t313*t53)*t9*wght+4.947113487115154d-2*t1*
     7         t136**3*t323*t9*wght-7.420670230672731d-2*t1*t136*t140*t3
     8         16*t9*wght
            t699 = 8.029982410719184d-2*t10*t135*t219*t222*t225*t53*t56
            t700 = -2.34505515261903d-1*t113*t134*t135*t51*t54
            t701 = t140*(-4.947113487115154d-2*t1*t136*t318*t9*wght-2.47
     1         3556743557577d-2*t1*t139*t316*t9*wght)+2.473556743557577d
     2         -2*t1*t61*(t700+t699-1.0311156879046991d-2*t10*t113*t118*
     3         t696*t697+2.007495602679796d-2*t10*t138*t219*t222*t225*t5
     4         3*t56-6.022486808039389d-2*t113*t219*t222*t53*t56+1.17252
     5         7576309515d-1*t10*t134*t225*t313*t51*t54+1.17252757630951
     6         5d-1*t10*t134*t135*t138*t225*t51*t54-5.862637881547574d-2
     7         *t113*t134*t138*t51*t54-1.0272657001372934d+0*t10*t12*t13
     8         8*t14*t313*t415*t53+6.848438000915289d-1*t12*t14*t225*t31
     9         3*t53+6.848438000915289d-1*t12*t135*t138*t14*t225*t53)*t9
     :         *wght+4.947113487115154d-2*t1*t139*t312*t323*t9*wght
            t702 = t140*(-2.473556743557577d-2*t1*t136*t322*t9*wght-4.94
     1         7113487115154d-2*t1*t139*t318*t9*wght)+2.473556743557577d
     2         -2*t1*t61*(t700+t699-2.0622313758093982d-2*t10*t113*t118*
     3         t696*t697+8.029982410719184d-2*t10*t138*t219*t222*t225*t5
     4         3*t56-1.2044973616078777d-1*t113*t219*t222*t53*t56+5.8626
     5         37881547574d-2*t10*t134*t225*t321*t51*t54+2.3450551526190
     6         3d-1*t10*t134*t135*t138*t225*t51*t54-2.34505515261903d-1*
     7         t113*t134*t138*t51*t54-1.0272657001372934d+0*t10*t12*t135
     8         *t14*t321*t415*t53+3.4242190004576445d-1*t12*t14*t225*t32
     9         1*t53+1.3696876001830577d+0*t12*t135*t138*t14*t225*t53)*t
     :         9*wght+4.947113487115154d-2*t1*t136*t320*t323*t9*wght
            fnc(iq) = 2.473556743557577d-2*t1*t60*t9*wght+fnc(iq)
            Amat(iq,D1_RA) = 2.473556743557577d-2*t1*t120*t61*t9*wght+7.
     1         420670230672731d-2*t1*t13*t60*t72*wght+t121+Amat(iq,D1_RA
     2         )
            Amat(iq,D1_RB) = 2.473556743557577d-2*t1*t133*t61*t9*wght+7.
     1         420670230672731d-2*t1*t124*t13*t60*wght+t121+Amat(iq,D1_R
     2         B)
            Cmat(iq,D1_GAA) = t137+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 2.473556743557577d-2*t1*t139*t61*t9*wght+C
     1         mat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t137+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = -2.473556743557577d-2*t1*t140*t141*t9*w
     1         ght+1.4841340461345462d-1*t1*t142*t60*t8*wght+1.484134046
     2         1345462d-1*t13*t60*t72*wght+7.420670230672731d-2*t1*t13*t
     3         154*t60*wght+t228*t61+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = -2.473556743557577d-2*t1*t120*t133*t140
     1         *t9*wght+1.4841340461345462d-1*t1*t124*t60*t72*t8*wght+7.
     2         420670230672731d-2*t13*t60*t72*wght+7.420670230672731d-2*
     3         t1*t13*t229*t60*wght+7.420670230672731d-2*t124*t13*t60*wg
     4         ht+t248*t61+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = -2.473556743557577d-2*t1*t140*t249*t9*w
     1         ght+1.4841340461345462d-1*t1*t250*t60*t8*wght+7.420670230
     2         672731d-2*t1*t13*t255*t60*wght+1.4841340461345462d-1*t124
     3         *t13*t60*wght+t273*t61+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = t286+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = -2.473556743557577d-2*t1*t120*t139*t14
     1         0*t9*wght+t298*t61+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t286+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = t305+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = -2.473556743557577d-2*t1*t133*t139*t14
     1         0*t9*wght+t311*t61+Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = t305+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = t317+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = t319+Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t317+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 2.473556743557577d-2*t1*t322*t61*t9*w
     1         ght-2.473556743557577d-2*t1*t140*t320*t9*wght+Cmat2(iq,D2
     2         _GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = t319+Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = t317+Cmat2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RA_RA_RA) = t61*(2.473556743557577d-2*t1*(4.7939
     1         06600640702d+0*t10*t112*t15*t58*t72*t73*t74-4.79390660064
     2         0702d+0*t10*t113*t119*t15*t53*t72*t73*t74-7.1908599009610
     3         53d+0*t10*t142*t53*t54*t58*t73*t74+2.396953300320351d+0*t
     4         10*t15*t154*t53*t58*t73*t74-1.1984766501601755d+0*t10*t14
     5         *t218*t58*t73*t74-2.396953300320351d+0*t10*t14*t225*t226*
     6         t53*t73*t74+1.1984766501601755d+0*t10*t113*t14*t224*t53*t
     7         73*t74+2.396953300320351d+0*t10*t112*t113*t119*t14*t73*t7
     8         4+3.9949221672005863d-1*t10*t15*t157*t53*t58*t72*t74-1.99
     9         74610836002932d-1*t10*t112*t14*t157*t58*t74+1.99746108360
     :         02932d-1*t10*t113*t119*t14*t157*t53*t74-1.712109500228822
     ;         2d-1*t10*t113*t12*t14*t53*(-6.566154427333284d+0*t110*t11
     <         4*t115*t117*t118*t49*t72*t73-8.207693034166604d+0*t114*t1
     =         15*t142*t222*t56*t73+1.641538606833321d+0*t114*t115*t117*
     >         t154*t56*t73+8.207693034166605d-1*t114*t115*t118*t215*t49
     ?         *t54*t73+8.207693034166605d-1*t114*t115*t118*t209*t49*t54
     @         *t73-2.4623079102499817d+0*t114*t115*t213*t215*t223*t54*t
     1         73+1.7587913644642722d+0*t154*t222*t55*t56*t72-9.57564187
     2         3194375d+0*t114*t117*t155*t219*t56*t72+2.735897678055536d
     3         -1*t114*t115*t117*t157*t56*t72+7.03516545785709d-1*t117*t
     4         118*t215*t49*t55*t72+7.03516545785709d-1*t117*t118*t209*t
     5         49*t55*t72-2.110549637357127d+0*t117*t213*t215*t223*t55*t
     6         72-3.5175827289285444d+0*t324*t413*t55*t56-1.172527576309
     7         515d-1*t117*t335*t55*t56-5.862637881547574d-2*t118*t405*t
     8         49*t54*t55-5.862637881547574d-2*t118*t397*t49*t54*t55-1.7
     9         587913644642725d-1*t110*t118*t209*t49*t54*t55-7.035165457
     :         85709d-1*t403*t405*t414*t54*t55+1.7587913644642725d-1*t21
     ;         3*t223*t405*t54*t55+1.7587913644642725d-1*t213*t215*t223*
     <         t361*t54*t55+5.276374093392817d-1*t110*t209*t213*t223*t54
     =         *t55-3.5175827289285444d+0*t110*t118*t142*t222*t49*t55+7.
     >         03516545785709d-1*t110*t117*t118*t154*t49*t55-4.787820936
     ?         5971874d+0*t110*t114*t118*t155*t219*t49*t54+1.36794883902
     @         7768d-1*t110*t114*t115*t118*t157*t49*t54+t412+t411+t410+t
     1         408+t407+t406+t402+t401+t400+t399+t398+t362+t360+t359+t35
     2         8+t357+t356+t355+t354+t353+t352+t351+t350+t349+t348+t347+
     3         t346+t345+t344+t343+t342)+3.08179710041188d+0*t10*t12*t15
     4         4*t53*t54*t58*t72-8.389336551121229d+0*t10*t134*t15*t155*
     5         t53*t58*t72-1.0272657001372934d+0*t10*t12*t15*t218*t58*t7
     6         2-2.0545314002745868d+0*t10*t12*t15*t225*t226*t53*t72+1.0
     7         272657001372934d+0*t10*t113*t12*t15*t224*t53*t72+2.054531
     8         4002745868d+0*t10*t112*t113*t119*t12*t15*t72+3.0817971004
     9         1188d+0*t10*t112*t12*t142*t54*t58-3.4242190004576445d-1*t
     :         10*t12*t15*t335*t53*t58-4.1090628005491736d+0*t10*t117*t1
     ;         2*t324*t53*t58+1.7121095002288222d-1*t10*t12*t14*(t408+t4
     <         07+t406+t402+t401+t400+t399+t398+t362+t360+t359+t358+t357
     =         +t356+t355+t354+t353+t352+t351+t350+t349+t348+t347+t346+t
     >         345+t344+t343+t342)*t58+4.1946682755606146d+0*t10*t112*t1
     ?         34*t14*t155*t58-1.0272657001372934d+0*t10*t112*t12*t15*t1
     @         54*t58-3.08179710041188d+0*t10*t113*t119*t12*t142*t53*t54
     1         -1.0272657001372934d+0*t10*t119**3*t12*t14*t415*t53+1.027
     2         2657001372934d+0*t10*t119*t12*t14*t224*t225*t53-4.1946682
     3         755606146d+0*t10*t113*t119*t134*t14*t155*t53+1.0272657001
     4         372934d+0*t10*t113*t119*t12*t15*t154*t53+t341+t339+t337+1
     5         .0272657001372934d+0*t10*t112*t12*t14*t225*t226-5.1363285
     6         00686467d-1*t10*t112*t113*t12*t14*t224-5.136328500686467d
     7         -1*t10*t113*t119*t12*t14*t218)*t9*wght+7.420670230672731d
     8         -2*t227*t9*wght+4.4524021384036383d-1*t1*t120*t142*t8*wgh
     9         t+2.2262010692018191d-1*t1*t13*t227*t72*wght+4.4524021384
     :         036383d-1*t120*t13*t72*wght+2.2262010692018191d-1*t1*t120
     ;         *t13*t154*wght)+t140*(-4.947113487115154d-2*t1*t120*t227*
     <         t9*wght-7.420670230672731d-2*t1*t13*t141*t72*wght+t416-t1
     =         20*t228)+4.947113487115154d-2*t1*t120**3*t323*t9*wght+4.4
     >         524021384036383d-1*t1*t154*t60*t72*t8*wght+4.452402138403
     ?         6383d-1*t142*t60*t8*wght+7.420670230672731d-2*t1*t13*t335
     @         *t60*wght+1.4841340461345462d-1*t1*t324*t60*wght+2.226201
     1         0692018191d-1*t13*t154*t60*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = t61*(2.473556743557577d-2*t1*(1.5979
     1         688668802342d+0*t10*t112*t15*t58*t72*t73*t74-1.5979688668
     2         802342d+0*t10*t113*t119*t15*t53*t72*t73*t74-2.39695330032
     3         0351d+0*t10*t142*t53*t54*t58*t73*t74+7.98984433440117d-1*
     4         t10*t15*t154*t53*t58*t73*t74-3.994922167200585d-1*t10*t14
     5         *t218*t58*t73*t74-7.98984433440117d-1*t10*t14*t225*t226*t
     6         53*t73*t74+3.994922167200585d-1*t10*t113*t14*t224*t53*t73
     7         *t74+7.98984433440117d-1*t10*t112*t113*t119*t14*t73*t74+2
     8         .663281444800391d-1*t10*t15*t157*t53*t58*t72*t74+1.331640
     9         7224001955d-1*t10*t124*t15*t157*t53*t58*t74-6.65820361200
     :         0978d-2*t10*t131*t14*t157*t58*t74-1.3316407224001955d-1*t
     ;         10*t112*t14*t157*t58*t74+6.658203612000978d-2*t10*t113*t1
     <         32*t14*t157*t53*t74+1.3316407224001955d-1*t10*t113*t119*t
     =         14*t157*t53*t74-1.7121095002288222d-1*t10*t113*t12*t14*t5
     >         3*(-2.188718142444428d+0*t110*t114*t115*t117*t118*t49*t72
     ?         *t73-2.735897678055535d+0*t114*t115*t142*t222*t56*t73+5.4
     @         7179535611107d-1*t114*t115*t117*t154*t56*t73+2.7358976780
     1         55535d-1*t114*t115*t118*t215*t49*t54*t73+2.73589767805553
     2         5d-1*t114*t115*t118*t209*t49*t54*t73-8.207693034166605d-1
     3         *t114*t115*t213*t215*t223*t54*t73+1.1725275763095148d+0*t
     4         222*t229*t55*t56*t72-6.383761248796249d+0*t114*t117*t155*
     5         t219*t56*t72+1.8239317853703574d-1*t114*t115*t117*t157*t5
     6         6*t72+4.69011030523806d-1*t117*t118*t237*t49*t55*t72-2.34
     7         50551526190297d+0*t110*t118*t124*t222*t49*t55*t72+4.69011
     8         030523806d-1*t110*t117*t118*t129*t49*t55*t72-1.4070330915
     9         71418d+0*t110*t117*t129*t213*t223*t55*t72-1.1725275763095
     :         15d-1*t117*t421*t55*t56-3.5175827289285444d+0*t124*t142*t
     ;         413*t55*t56+5.862637881547574d-1*t124*t154*t222*t55*t56-3
     <         .1918806243981246d+0*t114*t117*t124*t155*t219*t56+9.11965
     =         8926851787d-2*t114*t115*t117*t124*t157*t56-5.862637881547
     >         574d-2*t118*t474*t49*t54*t55-1.172527576309515d-1*t110*t1
     ?         18*t237*t49*t54*t55-5.862637881547574d-2*t118*t129*t215*t
     @         49*t54*t55-5.862637881547574d-2*t118*t129*t209*t49*t54*t5
     1         5+1.7587913644642725d-1*t213*t215*t223*t483*t54*t55-7.035
     2         16545785709d-1*t129*t215*t403*t414*t54*t55+3.517582728928
     3         545d-1*t110*t213*t223*t237*t54*t55+1.7587913644642725d-1*
     4         t129*t213*t215*t223*t54*t55+1.7587913644642725d-1*t129*t2
     5         09*t213*t223*t54*t55+4.69011030523806d-1*t110*t117*t118*t
     6         229*t49*t55-1.1725275763095148d+0*t118*t129*t142*t222*t49
     7         *t55+2.34505515261903d-1*t117*t118*t124*t215*t49*t55+2.34
     8         505515261903d-1*t117*t118*t124*t209*t49*t55+2.34505515261
     9         903d-1*t117*t118*t129*t154*t49*t55-7.03516545785709d-1*t1
     :         17*t124*t213*t215*t223*t55-1.5959403121990623d+0*t114*t11
     ;         8*t129*t155*t219*t49*t54-3.1918806243981246d+0*t110*t114*
     <         t118*t155*t219*t49*t54+4.5598294634258935d-2*t114*t115*t1
     =         18*t129*t157*t49*t54+9.119658926851787d-2*t110*t114*t115*
     >         t118*t157*t49*t54+t491+t490+t489+t488+t487+t486+t485+t484
     ?         +t482+t481+t480+t479+t478+t477+t476+t475+t470+t469+t468+t
     @         467+t466+t465+t464+t463+t462+t461+t460+t459+t458+t457+t45
     1         6+t455+t454+t453+t452+t451+t450+t449+t448+t447+t446+t445+
     2         t444+t443+t442+t441+t440+t439+t438+t437+t436+t412+t411+t4
     3         10+t351+t350+t349)+2.0545314002745868d+0*t10*t12*t229*t53
     4         *t54*t58*t72+2.0545314002745868d+0*t10*t112*t12*t124*t54*
     5         t58*t72-5.59289103408082d+0*t10*t134*t15*t155*t53*t58*t72
     6         -6.848438000915289d-1*t10*t12*t15*t245*t58*t72-2.05453140
     7         02745868d+0*t10*t113*t119*t12*t124*t53*t54*t72+6.84843800
     8         0915289d-1*t10*t113*t12*t15*t246*t53*t72-1.36968760018305
     9         77d+0*t10*t119*t12*t132*t15*t225*t53*t72+6.84843800091528
     :         9d-1*t10*t112*t113*t12*t132*t15*t72+6.848438000915289d-1*
     ;         t10*t113*t119*t12*t131*t15*t72+1.0272657001372934d+0*t10*
     <         t12*t124*t154*t53*t54*t58+1.0272657001372934d+0*t10*t12*t
     =         131*t142*t54*t58-3.4242190004576445d-1*t10*t12*t15*t421*t
     >         53*t58-2.79644551704041d+0*t10*t124*t134*t15*t155*t53*t58
     ?         -4.1090628005491736d+0*t10*t117*t12*t124*t142*t53*t58+1.7
     @         121095002288222d-1*t10*t12*t14*(t484+t482+t481+t480+t479+
     1         t478+t477+t476+t475+t470+t469+t468+t467+t466+t465+t464+t4
     2         63+t462+t461+t460+t459+t458+t457+t456+t455+t454+t453+t452
     3         +t451+t450+t449+t448+t447+t446+t445+t444+t443+t442+t441+t
     4         440+t439+t438+t437+t436+t351+t350+t349)*t58-6.84843800091
     5         5289d-1*t10*t112*t12*t15*t229*t58-3.4242190004576445d-1*t
     6         10*t12*t124*t15*t218*t58+1.398222758520205d+0*t10*t131*t1
     7         34*t14*t155*t58+2.79644551704041d+0*t10*t112*t134*t14*t15
     8         5*t58-3.4242190004576445d-1*t10*t12*t131*t15*t154*t58-1.0
     9         272657001372934d+0*t10*t113*t12*t132*t142*t53*t54-1.02726
     :         57001372934d+0*t10*t12*t132*t14*t226*t415*t53+6.848438000
     ;         915289d-1*t10*t119*t12*t14*t225*t246*t53+6.84843800091528
     <         9d-1*t10*t113*t119*t12*t15*t229*t53-6.848438000915289d-1*
     =         t10*t12*t124*t15*t225*t226*t53+3.4242190004576445d-1*t10*
     >         t12*t132*t14*t224*t225*t53+3.4242190004576445d-1*t10*t113
     ?         *t12*t124*t15*t224*t53-1.398222758520205d+0*t10*t113*t132
     @         *t134*t14*t155*t53-2.79644551704041d+0*t10*t113*t119*t134
     1         *t14*t155*t53+3.4242190004576445d-1*t10*t113*t12*t132*t15
     2         *t154*t53+t435+t434+t433+t432+t431+t430+t429+t428+t427+t4
     3         26+t425+t341+t339+t337-3.4242190004576445d-1*t10*t112*t11
     4         3*t12*t14*t246-3.4242190004576445d-1*t10*t113*t119*t12*t1
     5         4*t245+3.4242190004576445d-1*t10*t12*t131*t14*t225*t226+6
     6         .848438000915289d-1*t10*t112*t119*t12*t132*t14*t225-1.712
     7         1095002288222d-1*t10*t113*t12*t131*t14*t224-1.71210950022
     8         88222d-1*t10*t113*t12*t132*t14*t218+6.848438000915289d-1*
     9         t10*t112*t113*t119*t12*t124*t15)*t9*wght+2.47355674355757
     :         7d-2*t227*t9*wght+2.9682680922690924d-1*t1*t120*t124*t72*
     ;         t8*wght+1.4841340461345462d-1*t1*t133*t142*t8*wght+1.4841
     <         340461345462d-1*t1*t13*t247*t72*wght+1.4841340461345462d-
     =         1*t120*t13*t72*wght+1.4841340461345462d-1*t1*t120*t13*t22
     >         9*wght+7.420670230672731d-2*t1*t124*t13*t227*wght+7.42067
     ?         0230672731d-2*t1*t13*t133*t154*wght+t424+t423+t422)+t140*
     @         (-4.947113487115154d-2*t1*t120*t247*t9*wght-7.42067023067
     1         2731d-2*t1*t124*t13*t141*wght+t416-t133*t228)+4.947113487
     2         115154d-2*t1*t133*t141*t323*t9*wght+2.9682680922690924d-1
     3         *t1*t229*t60*t72*t8*wght+1.4841340461345462d-1*t1*t124*t1
     4         54*t60*t8*wght+1.4841340461345462d-1*t142*t60*t8*wght+7.4
     5         20670230672731d-2*t1*t13*t421*t60*wght+7.420670230672731d
     6         -2*t13*t154*t60*wght+1.4841340461345462d-1*t1*t124*t142*t
     7         60*wght+t418+t417+Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = t61*(2.473556743557577d-2*t1*(-2.396
     1         953300320351d+0*t10*t250*t53*t54*t58*t73*t74+7.9898443344
     2         0117d-1*t10*t15*t255*t53*t58*t73*t74-3.994922167200585d-1
     3         *t10*t14*t269*t58*t73*t74+1.5979688668802342d+0*t10*t124*
     4         t131*t15*t58*t73*t74-7.98984433440117d-1*t10*t14*t225*t27
     5         1*t53*t73*t74+3.994922167200585d-1*t10*t113*t14*t270*t53*
     6         t73*t74-1.5979688668802342d+0*t10*t113*t124*t132*t15*t53*
     7         t73*t74+7.98984433440117d-1*t10*t113*t131*t132*t14*t73*t7
     8         4+1.3316407224001955d-1*t10*t15*t157*t53*t58*t72*t74+2.66
     9         3281444800391d-1*t10*t124*t15*t157*t53*t58*t74-1.33164072
     :         24001955d-1*t10*t131*t14*t157*t58*t74-6.658203612000978d-
     ;         2*t10*t112*t14*t157*t58*t74+1.3316407224001955d-1*t10*t11
     <         3*t132*t14*t157*t53*t74+6.658203612000978d-2*t10*t113*t11
     =         9*t14*t157*t53*t74-1.7121095002288222d-1*t10*t113*t12*t14
     >         *t53*(5.47179535611107d-1*t114*t115*t117*t255*t56*t73-2.7
     ?         35897678055535d+0*t114*t115*t222*t250*t56*t73+2.735897678
     @         055535d-1*t114*t115*t118*t266*t49*t54*t73+2.7358976780555
     1         35d-1*t114*t115*t118*t262*t49*t54*t73-8.207693034166605d-
     2         1*t114*t115*t213*t223*t266*t54*t73-2.188718142444428d+0*t
     3         114*t115*t117*t118*t124*t129*t49*t73-3.5175827289285444d+
     4         0*t250*t413*t55*t56*t72+5.862637881547574d-1*t222*t255*t5
     5         5*t56*t72-3.1918806243981246d+0*t114*t117*t155*t219*t56*t
     6         72+9.119658926851787d-2*t114*t115*t117*t157*t56*t72+2.345
     7         05515261903d-1*t117*t118*t266*t49*t55*t72+2.3450551526190
     8         3d-1*t117*t118*t262*t49*t55*t72-2.3450551526190297d+0*t11
     9         8*t124*t129*t222*t49*t55*t72-7.03516545785709d-1*t117*t21
     :         3*t223*t266*t55*t72-1.172527576309515d-1*t117*t492*t55*t5
     ;         6+1.1725275763095148d+0*t124*t222*t229*t55*t56-6.38376124
     <         8796249d+0*t114*t117*t124*t155*t219*t56+1.823931785370357
     =         4d-1*t114*t115*t117*t124*t157*t56-5.862637881547574d-2*t1
     >         18*t49*t525*t54*t55-5.862637881547574d-2*t110*t118*t266*t
     ?         49*t54*t55-5.862637881547574d-2*t110*t118*t262*t49*t54*t5
     @         5-1.172527576309515d-1*t118*t129*t237*t49*t54*t55+1.75879
     1         13644642725d-1*t110*t129*t213*t223*t483*t54*t55-7.0351654
     2         5785709d-1*t110*t266*t403*t414*t54*t55+1.7587913644642725
     3         d-1*t110*t213*t223*t266*t54*t55+1.7587913644642725d-1*t11
     4         0*t213*t223*t262*t54*t55+3.517582728928545d-1*t129*t213*t
     5         223*t237*t54*t55+2.34505515261903d-1*t110*t117*t118*t255*
     6         t49*t55-1.1725275763095148d+0*t110*t118*t222*t250*t49*t55
     7         +4.69011030523806d-1*t117*t118*t124*t237*t49*t55+4.690110
     8         30523806d-1*t117*t118*t129*t229*t49*t55+4.69011030523806d
     9         -1*t110*t117*t118*t124*t129*t49*t55-1.407033091571418d+0*
     :         t110*t117*t124*t129*t213*t223*t55-3.1918806243981246d+0*t
     ;         114*t118*t129*t155*t219*t49*t54-1.5959403121990623d+0*t11
     <         0*t114*t118*t155*t219*t49*t54+9.119658926851787d-2*t114*t
     =         115*t118*t129*t157*t49*t54+4.5598294634258935d-2*t110*t11
     >         4*t115*t118*t157*t49*t54+t530+t529+t528+t527+t526+t524+t5
     ?         23+t522+t521+t520+t519+t518+t517+t516+t515+t514+t513+t512
     @         +t511+t510+t509+t508+t507+t506+t505+t504+t503+t502+t501+t
     1         500+t499+t498+t497+t496+t495+t494+t493+t491+t490+t489+t48
     2         8+t487+t486+t485+t470+t468+t461+t454+t449+t441+t439+t412+
     3         t411+t410+t351+t350+t349)+1.0272657001372934d+0*t10*t12*t
     4         255*t53*t54*t58*t72+2.0545314002745868d+0*t10*t12*t124*t1
     5         31*t54*t58*t72-4.1090628005491736d+0*t10*t117*t12*t250*t5
     6         3*t58*t72-2.79644551704041d+0*t10*t134*t15*t155*t53*t58*t
     7         72-3.4242190004576445d-1*t10*t12*t15*t269*t58*t72-2.05453
     8         14002745868d+0*t10*t113*t12*t124*t132*t53*t54*t72-6.84843
     9         8000915289d-1*t10*t12*t15*t225*t271*t53*t72+3.42421900045
     :         76445d-1*t10*t113*t12*t15*t270*t53*t72+6.848438000915289d
     ;         -1*t10*t113*t12*t131*t132*t15*t72+2.0545314002745868d+0*t
     <         10*t12*t124*t229*t53*t54*t58+1.0272657001372934d+0*t10*t1
     =         12*t12*t250*t54*t58+1.7121095002288222d-1*t10*t12*t14*(t5
     >         30+t529+t528+t527+t526+t524+t523+t522+t521+t520+t519+t518
     ?         +t517+t516+t515+t514+t513+t512+t511+t510+t509+t508+t507+t
     @         506+t505+t504+t503+t502+t501+t500+t499+t498+t497+t496+t49
     1         5+t494+t493+t470+t468+t461+t454+t449+t441+t439+t351+t350+
     2         t349)*t58-3.4242190004576445d-1*t10*t12*t15*t492*t53*t58-
     3         5.59289103408082d+0*t10*t124*t134*t15*t155*t53*t58-3.4242
     4         190004576445d-1*t10*t112*t12*t15*t255*t58-6.8484380009152
     5         89d-1*t10*t12*t124*t15*t245*t58-6.848438000915289d-1*t10*
     6         t12*t131*t15*t229*t58+2.79644551704041d+0*t10*t131*t134*t
     7         14*t155*t58+1.398222758520205d+0*t10*t112*t134*t14*t155*t
     8         58-1.0272657001372934d+0*t10*t113*t119*t12*t250*t53*t54-1
     9         .0272657001372934d+0*t10*t119*t12*t14*t271*t415*t53+3.424
     :         2190004576445d-1*t10*t119*t12*t14*t225*t270*t53+3.4242190
     ;         004576445d-1*t10*t113*t119*t12*t15*t255*t53+6.84843800091
     <         5289d-1*t10*t12*t132*t14*t225*t246*t53+6.848438000915289d
     =         -1*t10*t113*t12*t124*t15*t246*t53+6.848438000915289d-1*t1
     >         0*t113*t12*t132*t15*t229*t53-1.3696876001830577d+0*t10*t1
     ?         19*t12*t124*t132*t15*t225*t53-2.79644551704041d+0*t10*t11
     @         3*t132*t134*t14*t155*t53-1.398222758520205d+0*t10*t113*t1
     1         19*t134*t14*t155*t53+t435+t434+t433+t432+t431+t430+t429+t
     2         428+t427+t426+t425+t341+t339+t337+3.4242190004576445d-1*t
     3         10*t112*t12*t14*t225*t271-1.7121095002288222d-1*t10*t112*
     4         t113*t12*t14*t270-1.7121095002288222d-1*t10*t113*t119*t12
     5         *t14*t269-3.4242190004576445d-1*t10*t113*t12*t131*t14*t24
     6         6-3.4242190004576445d-1*t10*t113*t12*t132*t14*t245+6.8484
     7         38000915289d-1*t10*t119*t12*t131*t132*t14*t225+6.84843800
     8         0915289d-1*t10*t112*t113*t12*t124*t132*t15+6.848438000915
     9         289d-1*t10*t113*t119*t12*t124*t131*t15)*t9*wght+2.4735567
     :         43557577d-2*t272*t9*wght+2.9682680922690924d-1*t1*t124*t1
     ;         33*t72*t8*wght+1.4841340461345462d-1*t1*t120*t250*t8*wght
     <         +7.420670230672731d-2*t1*t13*t272*t72*wght+7.420670230672
     =         731d-2*t1*t120*t13*t255*wght+1.4841340461345462d-1*t1*t12
     >         4*t13*t247*wght+1.4841340461345462d-1*t1*t13*t133*t229*wg
     ?         ht+1.4841340461345462d-1*t124*t13*t133*wght+t424+t423+t42
     @         2)+t140*(-2.473556743557577d-2*t1*t120*t272*t9*wght-2.473
     1         556743557577d-2*t1*t133*t247*t9*wght-2.473556743557577d-2
     2         *t120*t133*t9*wght-7.420670230672731d-2*t1*t120*t124*t13*
     3         t133*wght-t133*t248)+4.947113487115154d-2*t1*t120*t249*t3
     4         23*t9*wght+1.4841340461345462d-1*t1*t255*t60*t72*t8*wght+
     5         1.4841340461345462d-1*t250*t60*t8*wght+2.9682680922690924
     6         d-1*t1*t124*t229*t60*t8*wght+1.4841340461345462d-1*t1*t25
     7         0*t60*t72*wght+7.420670230672731d-2*t1*t13*t492*t60*wght+
     8         7.420670230672731d-2*t13*t255*t60*wght+t418+t417+Amat3(iq
     9         ,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = t61*(2.473556743557577d-2*t1*(-7.190
     1         859900961053d+0*t10*t250*t53*t54*t58*t73*t74+2.3969533003
     2         20351d+0*t10*t15*t255*t53*t58*t73*t74-1.1984766501601755d
     3         +0*t10*t14*t269*t58*t73*t74+4.793906600640702d+0*t10*t124
     4         *t131*t15*t58*t73*t74-2.396953300320351d+0*t10*t14*t225*t
     5         271*t53*t73*t74+1.1984766501601755d+0*t10*t113*t14*t270*t
     6         53*t73*t74-4.793906600640702d+0*t10*t113*t124*t132*t15*t5
     7         3*t73*t74+2.396953300320351d+0*t10*t113*t131*t132*t14*t73
     8         *t74+3.9949221672005863d-1*t10*t124*t15*t157*t53*t58*t74-
     9         1.9974610836002932d-1*t10*t131*t14*t157*t58*t74+1.9974610
     :         836002932d-1*t10*t113*t132*t14*t157*t53*t74-1.71210950022
     ;         88222d-1*t10*t113*t12*t14*t53*(1.641538606833321d+0*t114*
     <         t115*t117*t255*t56*t73-8.207693034166604d+0*t114*t115*t22
     =         2*t250*t56*t73+8.207693034166605d-1*t114*t115*t118*t266*t
     >         49*t54*t73+8.207693034166605d-1*t114*t115*t118*t262*t49*t
     ?         54*t73-2.4623079102499817d+0*t114*t115*t213*t223*t266*t54
     @         *t73-6.566154427333284d+0*t114*t115*t117*t118*t124*t129*t
     1         49*t73+t563+t562+t561-5.862637881547574d-2*t118*t49*t54*t
     2         55*t560-7.03516545785709d-1*t403*t414*t54*t55*t560+1.7587
     3         913644642725d-1*t213*t223*t54*t55*t560-1.172527576309515d
     4         -1*t117*t536*t55*t56-3.5175827289285444d+0*t413*t531*t55*
     5         t56+1.7587913644642722d+0*t124*t222*t255*t55*t56-9.575641
     6         873194375d+0*t114*t117*t124*t155*t219*t56+2.7358976780555
     7         36d-1*t114*t115*t117*t124*t157*t56+t559+t558+t557+t556+t5
     8         55-5.862637881547574d-2*t118*t49*t54*t55*t554+t553+t552+t
     9         551+t550-1.7587913644642725d-1*t118*t129*t262*t49*t54*t55
     :         +1.7587913644642725d-1*t213*t223*t266*t483*t54*t55+5.2763
     ;         74093392817d-1*t129*t213*t223*t262*t54*t55+7.035165457857
     <         09d-1*t117*t118*t124*t266*t49*t55+7.03516545785709d-1*t11
     =         7*t118*t124*t262*t49*t55+7.03516545785709d-1*t117*t118*t1
     >         29*t255*t49*t55-3.5175827289285444d+0*t118*t129*t222*t250
     ?         *t49*t55-2.110549637357127d+0*t117*t124*t213*t223*t266*t5
     @         5+t549+t548+t547+t546+t545+t544+t543+t542+t541+t540-4.787
     1         8209365971874d+0*t114*t118*t129*t155*t219*t49*t54+1.36794
     2         8839027768d-1*t114*t115*t118*t129*t157*t49*t54+t539+t538+
     3         t537+t412+t411+t410+t351+t350+t349)+1.7121095002288222d-1
     4         *t10*t12*t14*(t563+t562+t561+t559+t558+t557+t556+t555+t55
     5         3+t552+t551+t550+t549+t548+t547+t546+t545+t544+t543+t542+
     6         t541+t540+t539+t538+t537+t351+t350+t349)*t58+3.0817971004
     7         1188d+0*t10*t12*t124*t255*t53*t54*t58+3.08179710041188d+0
     8         *t10*t12*t131*t250*t54*t58-3.4242190004576445d-1*t10*t12*
     9         t15*t53*t536*t58-4.1090628005491736d+0*t10*t117*t12*t53*t
     :         531*t58-8.389336551121229d+0*t10*t124*t134*t15*t155*t53*t
     ;         58-1.0272657001372934d+0*t10*t12*t124*t15*t269*t58-1.0272
     <         657001372934d+0*t10*t12*t131*t15*t255*t58+4.1946682755606
     =         146d+0*t10*t131*t134*t14*t155*t58-3.08179710041188d+0*t10
     >         *t113*t12*t132*t250*t53*t54-1.0272657001372934d+0*t10*t12
     ?         *t132**3*t14*t415*t53-2.0545314002745868d+0*t10*t12*t124*
     @         t15*t225*t271*t53+1.0272657001372934d+0*t10*t12*t132*t14*
     1         t225*t270*t53+1.0272657001372934d+0*t10*t113*t12*t124*t15
     2         *t270*t53+1.0272657001372934d+0*t10*t113*t12*t132*t15*t25
     3         5*t53-4.1946682755606146d+0*t10*t113*t132*t134*t14*t155*t
     4         53+t341+t339+t337+1.0272657001372934d+0*t10*t12*t131*t14*
     5         t225*t271-5.136328500686467d-1*t10*t113*t12*t131*t14*t270
     6         -5.136328500686467d-1*t10*t113*t12*t132*t14*t269+2.054531
     7         4002745868d+0*t10*t113*t12*t124*t131*t132*t15)*t9*wght+7.
     8         420670230672731d-2*t272*t9*wght+4.4524021384036383d-1*t1*
     9         t133*t250*t8*wght+2.2262010692018191d-1*t1*t124*t13*t272*
     :         wght+2.2262010692018191d-1*t1*t13*t133*t255*wght+4.452402
     ;         1384036383d-1*t124*t13*t133*wght)+t140*(-4.94711348711515
     <         4d-2*t1*t133*t272*t9*wght-2.473556743557577d-2*t249*t9*wg
     =         ht-7.420670230672731d-2*t1*t124*t13*t249*wght-t133*t273)+
     >         4.947113487115154d-2*t1*t133**3*t323*t9*wght+4.4524021384
     ?         036383d-1*t1*t124*t255*t60*t8*wght+4.4524021384036383d-1*
     @         t250*t60*t8*wght+7.420670230672731d-2*t1*t13*t536*t60*wgh
     1         t+1.4841340461345462d-1*t1*t531*t60*wght+2.22620106920181
     2         91d-1*t13*t255*t60*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = t589+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = t61*(2.473556743557577d-2*t1*(3.195
     1         9377337604683d+0*t15*t53*t58*t72*t73*t74-1.59796886688023
     2         42d+0*t10*t113*t138*t15*t53*t72*t73*t74-7.98984433440117d
     3         -1*t10*t14*t294*t58*t73*t74-1.5979688668802342d+0*t112*t1
     4         4*t58*t73*t74+7.98984433440117d-1*t10*t113*t14*t296*t53*t
     5         73*t74-1.5979688668802342d+0*t10*t119*t138*t14*t225*t53*t
     6         73*t74+1.5979688668802342d+0*t113*t119*t14*t53*t73*t74+7.
     7         98984433440117d-1*t10*t112*t113*t138*t14*t73*t74-1.712109
     8         5002288222d-1*t10*t113*t12*t14*t53*(4.377436284888856d+0*
     9         t10*t115*t117*t56*t72*t73+2.188718142444428d+0*t10*t110*t
     :         115*t118*t49*t54*t73+1.876044122095224d+0*t10*t110*t117*t
     ;         118*t134*t49*t72+t607+t606+t605+t604+t603+t602+t601+t600+
     <         t599+t598+t597+t596+2.3450551526190297d+0*t10*t134*t142*t
     =         222*t56-4.69011030523806d-1*t10*t117*t134*t154*t56-2.3450
     >         5515261903d-1*t10*t118*t134*t215*t49*t54-2.34505515261903
     ?         d-1*t10*t118*t134*t209*t49*t54+7.03516545785709d-1*t10*t1
     @         34*t213*t215*t223*t54)+5.47179535611107d-1*t10*t115*t117*
     1         t51*t58*t72*t73+2.735897678055535d-1*t10*t113*t115*t119*t
     2         51*t54*t73-6.848438000915289d-1*t10*t12*t15*t294*t58*t72-
     3         1.3696876001830577d+0*t112*t12*t15*t58*t72+6.848438000915
     4         289d-1*t10*t113*t12*t15*t296*t53*t72-1.3696876001830577d+
     5         0*t10*t119*t12*t138*t15*t225*t53*t72+1.3696876001830577d+
     6         0*t113*t119*t12*t15*t53*t72+2.34505515261903d-1*t10*t113*
     7         t117*t119*t134*t51*t72+6.848438000915289d-1*t10*t112*t113
     8         *t12*t138*t15*t72+1.7121095002288222d-1*t10*t12*t14*t58*(
     9         t605+t604+t603+t602+t601+t600+t599+t598+t597+t596)+t595+t
     :         594+t593+t592+t591+t590+2.0545314002745868d+0*t12*t142*t5
     ;         3*t54*t58-6.848438000915289d-1*t12*t15*t154*t53*t58+3.517
     <         582728928545d-1*t10*t134*t142*t222*t51*t58-1.172527576309
     =         515d-1*t10*t117*t134*t154*t51*t58+3.4242190004576445d-1*t
     >         12*t14*t218*t58-1.0272657001372934d+0*t10*t113*t12*t138*t
     ?         142*t53*t54+1.172527576309515d-1*t10*t134*t225*t226*t51*t
     @         54-5.862637881547574d-2*t10*t113*t134*t224*t51*t54-1.0272
     1         657001372934d+0*t10*t12*t138*t14*t226*t415*t53+6.84843800
     2         0915289d-1*t10*t119*t12*t14*t225*t296*t53+6.8484380009152
     3         89d-1*t12*t14*t225*t226*t53+3.4242190004576445d-1*t10*t12
     4         *t138*t14*t224*t225*t53-3.4242190004576445d-1*t113*t12*t1
     5         4*t224*t53+3.4242190004576445d-1*t10*t113*t12*t138*t15*t1
     6         54*t53-3.4242190004576445d-1*t10*t112*t113*t12*t14*t296-3
     7         .4242190004576445d-1*t10*t113*t119*t12*t14*t294+6.8484380
     8         00915289d-1*t10*t112*t119*t12*t138*t14*t225-1.71210950022
     9         88222d-1*t10*t113*t12*t138*t14*t218-6.848438000915289d-1*
     :         t112*t113*t119*t12*t14)*t9*wght+4.947113487115154d-2*t297
     ;         *t9*wght+1.4841340461345462d-1*t1*t139*t142*t8*wght+1.484
     <         1340461345462d-1*t1*t13*t297*t72*wght+1.4841340461345462d
     =         -1*t13*t139*t72*wght+7.420670230672731d-2*t1*t13*t139*t15
     >         4*wght)+t140*(-4.947113487115154d-2*t1*t120*t297*t9*wght-
     ?         t139*t228)+4.947113487115154d-2*t1*t139*t141*t323*t9*wght
     @         +Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = t589+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = t619+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = t61*(2.473556743557577d-2*t1*(-7.98
     1         984433440117d-1*t10*t113*t138*t15*t53*t72*t73*t74-3.99492
     2         2167200585d-1*t10*t14*t308*t58*t73*t74-3.994922167200585d
     3         -1*t10*t14*t294*t58*t73*t74+3.994922167200585d-1*t10*t113
     4         *t14*t309*t53*t73*t74+3.994922167200585d-1*t10*t113*t14*t
     5         296*t53*t73*t74-7.98984433440117d-1*t10*t132*t138*t14*t22
     6         5*t53*t73*t74-7.98984433440117d-1*t10*t119*t138*t14*t225*
     7         t53*t73*t74-7.98984433440117d-1*t10*t113*t124*t138*t15*t5
     8         3*t73*t74+3.994922167200585d-1*t10*t113*t131*t138*t14*t73
     9         *t74+3.994922167200585d-1*t10*t112*t113*t138*t14*t73*t74-
     :         1.7121095002288222d-1*t10*t113*t12*t14*t53*(2.34505515261
     ;         90297d+0*t10*t124*t134*t222*t56*t72+9.38022061047612d-1*t
     <         10*t117*t118*t129*t134*t49*t72+t635+t634+t633+t632+t631+t
     =         630+t629+t628+t627+t626+t625+t607+t606+t600+t599+t588+t58
     >         5+t582+t577-4.69011030523806d-1*t10*t117*t134*t229*t56-2.
     ?         34505515261903d-1*t10*t118*t134*t237*t49*t54-2.3450551526
     @         1903d-1*t10*t110*t118*t129*t134*t49*t54+7.03516545785709d
     1         -1*t10*t110*t129*t134*t213*t223*t54+9.38022061047612d-1*t
     2         10*t110*t117*t118*t124*t134*t49)+2.0545314002745868d+0*t1
     3         2*t124*t53*t54*t58*t72+3.517582728928545d-1*t10*t124*t134
     4         *t222*t51*t58*t72-3.4242190004576445d-1*t10*t12*t15*t308*
     5         t58*t72-6.848438000915289d-1*t12*t131*t15*t58*t72-1.02726
     6         57001372934d+0*t10*t113*t12*t124*t138*t53*t54*t72+3.42421
     7         90004576445d-1*t10*t113*t12*t15*t309*t53*t72-6.8484380009
     8         15289d-1*t10*t12*t132*t138*t15*t225*t53*t72+6.84843800091
     9         5289d-1*t113*t12*t132*t15*t53*t72+1.172527576309515d-1*t1
     :         0*t113*t117*t132*t134*t51*t72+3.4242190004576445d-1*t10*t
     ;         113*t12*t131*t138*t15*t72+1.7121095002288222d-1*t10*t12*t
     <         14*t58*(t633+t632+t631+t630+t629+t628+t627+t626+t625+t600
     =         +t599+t582+t577)+t624+t623+t622+t621+t620+t595+t594+t593+
     >         t592+t591+t590-6.848438000915289d-1*t12*t15*t229*t53*t58-
     ?         1.172527576309515d-1*t10*t117*t134*t229*t51*t58-3.4242190
     @         004576445d-1*t10*t12*t124*t15*t294*t58+3.4242190004576445
     1         d-1*t12*t14*t245*t58-6.848438000915289d-1*t112*t12*t124*t
     2         15*t58+t574+t573+t572+t569+t566-5.862637881547574d-2*t10*
     3         t113*t134*t246*t51*t54+1.172527576309515d-1*t10*t119*t132
     4         *t134*t225*t51*t54-1.0272657001372934d+0*t10*t119*t12*t13
     5         2*t138*t14*t415*t53+3.4242190004576445d-1*t10*t119*t12*t1
     6         4*t225*t309*t53+3.4242190004576445d-1*t10*t12*t132*t14*t2
     7         25*t296*t53+3.4242190004576445d-1*t10*t113*t12*t124*t15*t
     8         296*t53+3.4242190004576445d-1*t10*t12*t138*t14*t225*t246*
     9         t53-3.4242190004576445d-1*t113*t12*t14*t246*t53+3.4242190
     :         004576445d-1*t10*t113*t12*t138*t15*t229*t53-6.84843800091
     ;         5289d-1*t10*t119*t12*t124*t138*t15*t225*t53+6.84843800091
     <         5289d-1*t119*t12*t132*t14*t225*t53+6.848438000915289d-1*t
     =         113*t119*t12*t124*t15*t53+1.172527576309515d-1*t10*t113*t
     >         117*t119*t124*t134*t51-1.7121095002288222d-1*t10*t112*t11
     ?         3*t12*t14*t309-1.7121095002288222d-1*t10*t113*t119*t12*t1
     @         4*t308-1.7121095002288222d-1*t10*t113*t12*t131*t14*t296-1
     1         .7121095002288222d-1*t10*t113*t12*t132*t14*t294-1.7121095
     2         002288222d-1*t10*t113*t12*t138*t14*t245+3.424219000457644
     3         5d-1*t10*t112*t12*t132*t138*t14*t225+3.4242190004576445d-
     4         1*t10*t119*t12*t131*t138*t14*t225+3.4242190004576445d-1*t
     5         10*t112*t113*t12*t124*t138*t15-3.4242190004576445d-1*t112
     6         *t113*t12*t132*t14-3.4242190004576445d-1*t113*t119*t12*t1
     7         31*t14)*t9*wght+2.473556743557577d-2*t310*t9*wght+2.47355
     8         6743557577d-2*t297*t9*wght+1.4841340461345462d-1*t1*t124*
     9         t139*t72*t8*wght+7.420670230672731d-2*t1*t13*t310*t72*wgh
     :         t+7.420670230672731d-2*t13*t139*t72*wght+7.42067023067273
     ;         1d-2*t1*t124*t13*t297*wght+7.420670230672731d-2*t1*t13*t1
     <         39*t229*wght+7.420670230672731d-2*t124*t13*t139*wght)+t14
     =         0*(-2.473556743557577d-2*t1*t120*t310*t9*wght-2.473556743
     >         557577d-2*t1*t133*t297*t9*wght-t139*t248)+4.9471134871151
     ?         54d-2*t1*t120*t133*t139*t323*t9*wght+Cmat3(iq,D3_RA_RB_GA
     @         B)
            Cmat3(iq,D3_RA_RB_GBB) = t619+Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = t642+Cmat3(iq,D3_RB_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = t61*(2.473556743557577d-2*t1*(3.195
     1         9377337604683d+0*t124*t15*t53*t58*t73*t74-7.9898443344011
     2         7d-1*t10*t14*t308*t58*t73*t74-1.5979688668802342d+0*t131*
     3         t14*t58*t73*t74+7.98984433440117d-1*t10*t113*t14*t309*t53
     4         *t73*t74-1.5979688668802342d+0*t10*t132*t138*t14*t225*t53
     5         *t73*t74-1.5979688668802342d+0*t10*t113*t124*t138*t15*t53
     6         *t73*t74+1.5979688668802342d+0*t113*t132*t14*t53*t73*t74+
     7         7.98984433440117d-1*t10*t113*t131*t138*t14*t73*t74-1.7121
     8         095002288222d-1*t10*t113*t12*t14*t53*(4.377436284888856d+
     9         0*t10*t115*t117*t124*t56*t73+2.188718142444428d+0*t10*t11
     :         5*t118*t129*t49*t54*t73+t650+t649+t648+t647+t646+t645+t64
     ;         4+t643+t607+t606+t600+t599-4.69011030523806d-1*t10*t117*t
     <         134*t255*t56+2.3450551526190297d+0*t10*t134*t222*t250*t56
     =         -2.34505515261903d-1*t10*t118*t134*t266*t49*t54-2.3450551
     >         5261903d-1*t10*t118*t134*t262*t49*t54+7.03516545785709d-1
     ?         *t10*t134*t213*t223*t266*t54+1.876044122095224d+0*t10*t11
     @         7*t118*t124*t129*t134*t49)+5.47179535611107d-1*t10*t115*t
     1         117*t124*t51*t58*t73+2.735897678055535d-1*t10*t113*t115*t
     2         132*t51*t54*t73+1.7121095002288222d-1*t10*t12*t14*t58*(t6
     3         50+t649+t648+t647+t646+t645+t644+t643+t600+t599)+t595+t59
     4         4+t593+t592+t591+t590+2.0545314002745868d+0*t12*t250*t53*
     5         t54*t58-6.848438000915289d-1*t12*t15*t255*t53*t58-1.17252
     6         7576309515d-1*t10*t117*t134*t255*t51*t58+3.51758272892854
     7         5d-1*t10*t134*t222*t250*t51*t58-6.848438000915289d-1*t10*
     8         t12*t124*t15*t308*t58+3.4242190004576445d-1*t12*t14*t269*
     9         t58-1.3696876001830577d+0*t12*t124*t131*t15*t58-1.0272657
     :         001372934d+0*t10*t113*t12*t138*t250*t53*t54+1.17252757630
     ;         9515d-1*t10*t134*t225*t271*t51*t54-5.862637881547574d-2*t
     <         10*t113*t134*t270*t51*t54-1.0272657001372934d+0*t10*t12*t
     =         138*t14*t271*t415*t53+6.848438000915289d-1*t10*t12*t132*t
     >         14*t225*t309*t53+6.848438000915289d-1*t10*t113*t12*t124*t
     ?         15*t309*t53+6.848438000915289d-1*t12*t14*t225*t271*t53+3.
     @         4242190004576445d-1*t10*t12*t138*t14*t225*t270*t53-3.4242
     1         190004576445d-1*t113*t12*t14*t270*t53+3.4242190004576445d
     2         -1*t10*t113*t12*t138*t15*t255*t53-1.3696876001830577d+0*t
     3         10*t12*t124*t132*t138*t15*t225*t53+1.3696876001830577d+0*
     4         t113*t12*t124*t132*t15*t53+2.34505515261903d-1*t10*t113*t
     5         117*t124*t132*t134*t51-3.4242190004576445d-1*t10*t113*t12
     6         *t131*t14*t309-3.4242190004576445d-1*t10*t113*t12*t132*t1
     7         4*t308-1.7121095002288222d-1*t10*t113*t12*t138*t14*t269+6
     8         .848438000915289d-1*t10*t12*t131*t132*t138*t14*t225+6.848
     9         438000915289d-1*t10*t113*t12*t124*t131*t138*t15-6.8484380
     :         00915289d-1*t113*t12*t131*t132*t14)*t9*wght+4.94711348711
     ;         5154d-2*t310*t9*wght+1.4841340461345462d-1*t1*t139*t250*t
     <         8*wght+1.4841340461345462d-1*t1*t124*t13*t310*wght+7.4206
     =         70230672731d-2*t1*t13*t139*t255*wght+1.4841340461345462d-
     >         1*t124*t13*t139*wght)+t140*(-4.947113487115154d-2*t1*t133
     ?         *t310*t9*wght-t139*t273)+4.947113487115154d-2*t1*t139*t24
     @         9*t323*t9*wght+Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = t642+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = t666+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = t140*(-2.473556743557577d-2*t1*t13
     1         6*t297*t9*wght+t676-t139*t285)+t675+t667+Cmat3(iq,D3_RA_G
     2         AA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = t666+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = t61*(2.473556743557577d-2*t1*(-1.7
     1         121095002288222d-1*t10*t113*t12*t14*t53*(-9.3802206104761
     2         2d-1*t117*t134*t56*t72+t683-4.69011030523806d-1*t110*t118
     3         *t134*t49*t54)-4.69011030523806d-1*t117*t134*t51*t58*t72+
     4         8.029982410719184d-2*t10*t113*t219*t413*t53*t56*t72-6.848
     5         438000915289d-1*t10*t12*t15*t225*t321*t53*t72+1.369687600
     6         1830577d+0*t113*t12*t138*t15*t53*t72+2.34505515261903d-1*
     7         t10*t113*t117*t134*t138*t51*t72+t682+t681+t680+t679+t678+
     8         6.848438000915289d-1*t12*t14*t294*t58+8.029982410719184d-
     9         2*t10*t119*t219*t222*t225*t53*t56-4.014991205359592d-2*t1
     :         0*t112*t113*t219*t222*t56-1.172527576309515d-1*t10*t113*t
     ;         134*t296*t51*t54+2.34505515261903d-1*t10*t119*t134*t138*t
     <         225*t51*t54-2.34505515261903d-1*t113*t119*t134*t51*t54-1.
     =         0272657001372934d+0*t10*t119*t12*t14*t321*t415*t53+6.8484
     >         38000915289d-1*t10*t12*t138*t14*t225*t296*t53-6.848438000
     ?         915289d-1*t113*t12*t14*t296*t53+1.3696876001830577d+0*t11
     @         9*t12*t138*t14*t225*t53+3.4242190004576445d-1*t10*t112*t1
     1         2*t14*t225*t321-3.4242190004576445d-1*t10*t113*t12*t138*t
     2         14*t294-6.848438000915289d-1*t112*t113*t12*t138*t14)*t9*w
     3         ght+7.420670230672731d-2*t1*t13*t322*t72*wght+t677)+t140*
     4         (-2.473556743557577d-2*t1*t120*t322*t9*wght-2.47355674355
     5         7577d-2*t1*t139*t297*t9*wght-t139*t298)+4.947113487115154
     6         d-2*t1*t120*t320*t323*t9*wght+Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = t140*(-2.473556743557577d-2*t1*t13
     1         9*t284*t9*wght+t676-t136*t298)+t675+t667+Cmat3(iq,D3_RA_G
     2         AB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = t666+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = t692+Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = t140*(-2.473556743557577d-2*t1*t13
     1         6*t310*t9*wght+t695-t139*t304)+t694+t693+Cmat3(iq,D3_RB_G
     2         AA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = t692+Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = t61*(2.473556743557577d-2*t1*(-1.7
     1         121095002288222d-1*t10*t113*t12*t14*t53*(t683-9.380220610
     2         47612d-1*t117*t124*t134*t56-4.69011030523806d-1*t118*t129
     3         *t134*t49*t54)+t682+t681+t680+t679+t678-4.69011030523806d
     4         -1*t117*t124*t134*t51*t58+6.848438000915289d-1*t12*t14*t3
     5         08*t58+8.029982410719184d-2*t10*t113*t124*t219*t413*t53*t
     6         56+8.029982410719184d-2*t10*t132*t219*t222*t225*t53*t56-4
     7         .014991205359592d-2*t10*t113*t131*t219*t222*t56-1.1725275
     8         76309515d-1*t10*t113*t134*t309*t51*t54+2.34505515261903d-
     9         1*t10*t132*t134*t138*t225*t51*t54-2.34505515261903d-1*t11
     :         3*t132*t134*t51*t54-1.0272657001372934d+0*t10*t12*t132*t1
     ;         4*t321*t415*t53-6.848438000915289d-1*t10*t12*t124*t15*t22
     <         5*t321*t53+6.848438000915289d-1*t10*t12*t138*t14*t225*t30
     =         9*t53-6.848438000915289d-1*t113*t12*t14*t309*t53+1.369687
     >         6001830577d+0*t12*t132*t138*t14*t225*t53+1.36968760018305
     ?         77d+0*t113*t12*t124*t138*t15*t53+2.34505515261903d-1*t10*
     @         t113*t117*t124*t134*t138*t51+3.4242190004576445d-1*t10*t1
     1         2*t131*t14*t225*t321-3.4242190004576445d-1*t10*t113*t12*t
     2         138*t14*t308-6.848438000915289d-1*t113*t12*t131*t138*t14)
     3         *t9*wght+7.420670230672731d-2*t1*t124*t13*t322*wght+t677)
     4         +t140*(-2.473556743557577d-2*t1*t133*t322*t9*wght-2.47355
     5         6743557577d-2*t1*t139*t310*t9*wght-t139*t311)+4.947113487
     6         115154d-2*t1*t133*t320*t323*t9*wght+Cmat3(iq,D3_RB_GAB_GA
     7         B)
            Cmat3(iq,D3_RB_GAB_GBB) = t140*(-2.473556743557577d-2*t1*t13
     1         9*t303*t9*wght+t695-t136*t311)+t694+t693+Cmat3(iq,D3_RB_G
     2         AB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = t692+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = t698+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t701+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = t698+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = t702+Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = t701+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = t698+Cmat3(iq,D3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = 2.473556743557577d-2*t1*t61*(-4.1
     1         244627516187965d-2*t10*t113*t118*t696*t697+2.408994723215
     2         7555d-1*t10*t138*t219*t222*t225*t53*t56-2.408994723215755
     3         5d-1*t113*t219*t222*t53*t56+3.517582728928545d-1*t10*t134
     4         *t225*t321*t51*t54-7.03516545785709d-1*t113*t134*t138*t51
     5         *t54-1.0272657001372934d+0*t10*t12*t138**3*t14*t415*t53+2
     6         .0545314002745868d+0*t12*t14*t225*t321*t53)*t9*wght+4.947
     7         113487115154d-2*t1*t139**3*t323*t9*wght-7.420670230672731
     8         d-2*t1*t139*t140*t322*t9*wght+Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = t702+Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = t701+Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = t698+Cmat3(iq,D3_GBB_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1.530901310039024d-2*t5+1.0465751434d-1
            t7 = 7.876233178997433d-1*t5*t6+1.9269083139d-1
            t8 = 7.876233178997433d-1*t5*t7+4.3896648423d-1
            t9 = 1/t8
            t10 = 1.269642451250142d+0*t4*t9+1.0d+0
            t11 = log(t10)
            t12 = 1/t3
            t13 = 1.2746961887000874d-1*t12+1.0d+0
            t14 = 2.4141993114533214d-2*t5+1.0186556948d-1
            t15 = 7.876233178997433d-1*t14*t5+2.2308199064d-1
            t16 = 7.876233178997433d-1*t15*t5+4.7231125998d-1
            t17 = 1/t16
            t18 = 1.269642451250142d+0*t17*t4+1.0d+0
            t19 = log(t18)
            t20 = 1.325688999052018d-1*t12+1.0d+0
            t21 = 1.3212998810398843d-2*t5+2.9729725188d-2
            t22 = 7.876233178997433d-1*t21*t5+1.2236585478d-1
            t23 = 7.876233178997433d-1*t22*t5+3.497952466d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t24*t4+1.0d+0
            t26 = log(t25)
            t27 = 6.901399211255826d-2*t12+1.0d+0
            t28 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t19*t20-3.10907d-2*t11*t13)-3.37738d-2*t26*t27)+
     2         3.37738d-2*t26*t27)-6.21814d-2*t19*t20
            t29 = exp(-8.085523023512745d+1*t28)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.7178044217479813d-1*gammaaa*t2*t31
            t33 = t32+1.0d+0
            t34 = (gammaaa*t2)**2.0d+0
            t35 = 1/t30**2.0d+0
            t36 = 7.38646087487288d-2*t34*t35+t32+1.0d+0
            t37 = 1/t36
            t38 = 2.7178044217479813d-1*gammaaa*t2*t33*t37+1.0d+0
            t39 = log(t38)
            t40 = 1/t38
            t41 = rhoa**1.6666666666666674d-1
            t42 = 1/t1**3.0d+0
            t43 = -6.34154365074529d-1*gammaaa*t31*t41*t42
            t44 = 1/rhoa**1.3333333333333333d+0
            t45 = 1/t10
            t46 = 1/t8**2
            t47 = 1/rhoa**1.3333333333333336d+0
            t48 = 1/t4**3
            t49 = 1/rhoa**6.666666666666667d-1
            t50 = -1.3127055298329054d-1*t48*t49*t6-2.0096226153166658d-
     1         3*t47
            t51 = 7.876233178997433d-1*t5*t50-1.3127055298329054d-1*t48*
     1         t49*t7
            t52 = 2.11607075208357d-1*t49*t5*t9-1.269642451250142d+0*t4*
     1         t46*t51
            t53 = 1/t18
            t54 = 1/t16**2
            t55 = -1.3127055298329054d-1*t14*t48*t49-3.169132786263567d-
     1         3*t47
            t56 = 7.876233178997433d-1*t5*t55-1.3127055298329054d-1*t15*
     1         t48*t49
            t57 = 2.11607075208357d-1*t17*t49*t5-1.269642451250142d+0*t4
     1         *t54*t56
            t58 = 1/t25
            t59 = 1/t23**2
            t60 = -1.3127055298329054d-1*t21*t48*t49-1.7344776604086162d
     1         -3*t47
            t61 = 7.876233178997433d-1*t5*t60-1.3127055298329054d-1*t22*
     1         t48*t49
            t62 = 2.11607075208357d-1*t24*t49*t5-1.269642451250142d+0*t4
     1         *t59*t61
            t63 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t27*t58*t62+
     1         1.709920934161365d+0*(6.21814d-2*t20*t53*t57-3.10907d-2*t
     2         13*t45*t52-2.747773264188438d-3*t19*t44+1.321039893133926
     3         5d-3*t11*t44)+7.769549222703733d-4*t26*t44)+3.37738d-2*t2
     4         7*t58*t62-7.769549222703733d-4*t26*t44)-6.21814d-2*t20*t5
     5         3*t57+2.747773264188438d-3*t19*t44
            t64 = 1/t30**2
            t65 = 2.1974870225448048d+1*gammaaa*t2*t29*t63*t64
            t66 = t65+t43
            t67 = 1/t36**2
            t68 = gammaaa**2
            t69 = 1/t1**5.0d+0
            t70 = 1/t30**3.0d+0
            t71 = 1.1944679893212153d+1*t29*t34*t63*t70-3.44701507494067
     1         75d-1*t35*t41*t68*t69+t65+t43
            t72 = -2.7178044217479813d-1*gammaaa*t2*t33*t67*t71+2.717804
     1         4217479813d-1*gammaaa*t2*t37*t66-6.34154365074529d-1*gamm
     2         aaa*t33*t37*t41*t42
            t73 = 1/t1**4.0d+0
            t74 = 1.477292174974576d-1*gammaaa*t35*t73+2.717804421747981
     1         3d-1*t2*t31
            t75 = -2.7178044217479813d-1*gammaaa*t2*t33*t67*t74+7.386460
     1         874872879d-2*gammaaa*t31*t37*t73+2.7178044217479813d-1*t2
     2         *t33*t37
            t76 = 1/t38**2
            t77 = t72**2
            t78 = rhoa**3.333333333333335d-1
            t79 = 1/rhoa**8.333333333333333d-1
            t80 = t63**2
            t81 = exp(-1.617104604702549d+2*t28)
            t82 = 1/t30**3
            t83 = 3.553566382931298d+3*gammaaa*t2*t80*t81*t82
            t84 = 2.2195402777608514d+0*gammaaa*t31*t73*t78
            t85 = -1.0569239417908823d-1*gammaaa*t31*t42*t79
            t86 = -1.0254939438542422d+2*gammaaa*t29*t41*t42*t63*t64
            t87 = -1.776783191465649d+3*gammaaa*t2*t29*t64*t80
            t88 = 1/rhoa**2.333333333333333d+0
            t89 = 1/t10**2
            t90 = t52**2
            t91 = 1/t8**3
            t92 = t51**2
            t93 = 1/rhoa**2.3333333333333334d+0
            t94 = 1/rhoa**1.6666666666666669d+0
            t95 = 1/t4**5
            t96 = 6.563527649164527d-2*t47*t6*t95+8.751370198886037d-2*t
     1         48*t6*t94+3.0144339229749983d-3*t93
            t97 = 7.876233178997433d-1*t5*t96+6.563527649164527d-2*t47*t
     1         7*t95+8.751370198886037d-2*t48*t7*t94-2.625411059665811d-
     2         1*t48*t49*t50
            t98 = -1.269642451250142d+0*t4*t46*t97-1.4107138347223802d-1
     1         *t5*t9*t94+2.539284902500284d+0*t4*t91*t92-3.526784586805
     2         95d-2*t47*t48*t9-4.23214150416714d-1*t46*t49*t5*t51
            t99 = 1/t18**2
            t100 = t57**2
            t101 = 1/t16**3
            t102 = t56**2
            t103 = 6.563527649164527d-2*t14*t47*t95+8.751370198886037d-2
     1         *t14*t48*t94+4.753699179395351d-3*t93
            t104 = 6.563527649164527d-2*t15*t47*t95+8.751370198886037d-2
     1         *t15*t48*t94-2.625411059665811d-1*t48*t49*t55+7.876233178
     2         997433d-1*t103*t5
            t105 = -1.4107138347223802d-1*t17*t5*t94-4.23214150416714d-1
     1         *t49*t5*t54*t56-1.269642451250142d+0*t104*t4*t54-3.526784
     2         58680595d-2*t17*t47*t48+2.539284902500284d+0*t101*t102*t4
            t106 = 1/t25**2
            t107 = t62**2
            t108 = 1/t23**3
            t109 = t61**2
            t110 = 6.563527649164527d-2*t21*t47*t95+8.751370198886037d-2
     1         *t21*t48*t94+2.601716490612924d-3*t93
            t111 = 6.563527649164527d-2*t22*t47*t95+8.751370198886037d-2
     1         *t22*t48*t94-2.625411059665811d-1*t48*t49*t60+7.876233178
     2         997433d-1*t110*t5
            t112 = -1.4107138347223802d-1*t24*t5*t94-4.23214150416714d-1
     1         *t49*t5*t59*t61-1.269642451250142d+0*t111*t4*t59-3.526784
     2         58680595d-2*t24*t47*t48+2.539284902500284d+0*t108*t109*t4
            t113 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         6.21814d-2*t100*t20*t99-3.10907d-2*t13*t45*t98+3.10907d-2
     2         *t13*t89*t90+3.663697685584584d-3*t19*t88-1.7613865241785
     3         687d-3*t11*t88-5.495546528376876d-3*t44*t53*t57+6.21814d-
     4         2*t105*t20*t53+2.642079786267853d-3*t44*t45*t52)-1.035939
     5         8963604977d-3*t26*t88+1.5539098445407465d-3*t44*t58*t62-3
     6         .37738d-2*t112*t27*t58+3.37738d-2*t106*t107*t27)+1.035939
     7         8963604977d-3*t26*t88-1.5539098445407465d-3*t44*t58*t62+3
     8         .37738d-2*t112*t27*t58-3.37738d-2*t106*t107*t27)+6.21814d
     9         -2*t100*t20*t99-3.663697685584584d-3*t19*t88+5.4955465283
     :         76876d-3*t44*t53*t57-6.21814d-2*t105*t20*t53
            t114 = 2.1974870225448048d+1*gammaaa*t113*t2*t29*t64
            t115 = t87+t86+t85+t84+t83+t114
            t116 = 1/t30**4.0d+0
            t117 = 1/t1**6.0d+0
            t118 = t87+t86+t85+t84+t83+2.897369528551698d+3*t116*t34*t80
     1         *t81-9.657898428505661d+2*t29*t34*t70*t80-5.7450251249011
     2         32d-2*t35*t68*t69*t79+2.0107587937153953d+0*t117*t35*t68*
     3         t78-1.1148367900331342d+2*t29*t41*t63*t68*t69*t70+1.19446
     4         79893212153d+1*t113*t29*t34*t70+t114
            t119 = 1/t36**3
            t120 = t71**2
            t121 = -1.0569239417908823d-1*gammaaa*t33*t37*t42*t79+2.2195
     1         402777608514d+0*gammaaa*t33*t37*t73*t78-5.435608843495963
     2         d-1*gammaaa*t2*t66*t67*t71+1.268308730149058d+0*gammaaa*t
     3         33*t41*t42*t67*t71-2.7178044217479813d-1*gammaaa*t118*t2*
     4         t33*t67-1.268308730149058d+0*gammaaa*t37*t41*t42*t66+2.71
     5         78044217479813d-1*gammaaa*t115*t2*t37+5.435608843495963d-
     6         1*gammaaa*t119*t120*t2*t33
            t122 = 2.4735567435575762d-2*t72*wght+1.2367783717787881d-2*
     1         rhoa*t121*wght
            t123 = -6.34154365074529d-1*t31*t41*t42
            t124 = 2.1974870225448048d+1*t2*t29*t63*t64
            t125 = t124+t123
            t126 = 2.3889359786424305d+1*gammaaa*t29*t63*t70*t73-6.89403
     1         0149881355d-1*gammaaa*t35*t41*t69+t124+t123
            t127 = 5.435608843495963d-1*gammaaa*t119*t2*t33*t71*t74-2.71
     1         78044217479813d-1*gammaaa*t2*t66*t67*t74+6.34154365074529
     2         d-1*gammaaa*t33*t41*t42*t67*t74-7.386460874872879d-2*gamm
     3         aaa*t31*t67*t71*t73-2.7178044217479813d-1*t2*t33*t67*t71-
     4         1.7235075374703387d-1*gammaaa*t31*t37*t41*t69-2.717804421
     5         7479813d-1*gammaaa*t126*t2*t33*t67+2.7178044217479813d-1*
     6         t2*t37*t66-6.34154365074529d-1*t33*t37*t41*t42+2.71780442
     7         17479813d-1*gammaaa*t125*t2*t37
            t128 = 1.2367783717787881d-2*t75*wght+1.2367783717787881d-2*
     1         rhoa*t127*wght
            t129 = t75**2
            t130 = t74**2
            t131 = -1.4772921749745757d-1*gammaaa*t31*t67*t73*t74-5.4356
     1         08843495963d-1*t2*t33*t67*t74+1.4772921749745757d-1*t31*t
     2         37*t73-4.014991205359595d-2*gammaaa*t117*t33*t35*t67+5.43
     3         5608843495963d-1*gammaaa*t119*t130*t2*t33
            t132 = 1/t38**3
            t133 = rhoa**5.000000000000002d-1
            t134 = 1/rhoa**6.666666666666665d-1
            t135 = 1/rhoa**1.8333333333333332d+0
            t136 = t63**3
            t137 = exp(-2.4256569070538234d+2*t28)
            t138 = 8.619732841431575d+5*gammaaa*t136*t137*t2/t30**4
            t139 = -2.4874964680519085d+4*gammaaa*t41*t42*t80*t81*t82
            t140 = -8.619732841431575d+5*gammaaa*t136*t2*t81*t82
            t141 = 1.0660699148793894d+4*gammaaa*t113*t2*t63*t81*t82
            t142 = -1.035785462955064d+1*gammaaa*t133*t31*t69
            t143 = 1.1097701388804264d+0*gammaaa*t134*t31*t73
            t144 = 8.807699514924018d-2*gammaaa*t135*t31*t42
            t145 = 5.383843205234772d+2*gammaaa*t29*t63*t64*t73*t78
            t146 = -2.563734859635607d+1*gammaaa*t29*t42*t63*t64*t79
            t147 = 1.2437482340259542d+4*gammaaa*t29*t41*t42*t64*t80
            t148 = -1.5382409157813634d+2*gammaaa*t113*t29*t41*t42*t64
            t149 = 1.436622140238596d+5*gammaaa*t136*t2*t29*t64
            t150 = -5.330349574396946d+3*gammaaa*t113*t2*t29*t63*t64
            t151 = 1/rhoa**3.333333333333333d+0
            t152 = 1/rhoa**3.3333333333333337d+0
            t153 = 1/rhoa**2.666666666666667d+0
            t154 = 1/t4**7
            t155 = 1/rhoa**2.0d+0
            t156 = 1/t18**3
            t157 = t57**3
            t158 = -1.269642451250142d+0*t4*t54*(7.876233178997433d-1*t5
     1         *(-1.3127055298329054d-1*t14*t93*t95-1.4585616998143394d-
     2         1*t14*t153*t48-5.469606374303773d-2*t14*t154*t155-1.17081
     3         85015918181d-2*t152)-1.3127055298329054d-1*t15*t93*t95+1.
     4         9690582947493582d-1*t47*t55*t95+2.625411059665811d-1*t48*
     5         t55*t94-3.9381165894987163d-1*t103*t48*t49-1.458561699814
     6         3394d-1*t15*t153*t48-5.469606374303773d-2*t15*t154*t155)+
     7         1.763392293402975d-2*t155*t17*t95+4.2321415041671406d-1*t
     8         5*t54*t56*t94+7.053569173611901d-2*t17*t48*t93-7.61785470
     9         7500852d+0*t4*t56**3/t16**4+1.0580353760417849d-1*t47*t48
     :         *t54*t56+7.617854707500852d+0*t101*t104*t4*t56-6.34821225
     ;         625071d-1*t104*t49*t5*t54+1.269642451250142d+0*t101*t102*
     <         t49*t5+2.3511897245373004d-1*t153*t17*t5
            t159 = 1/t25**3
            t160 = t62**3
            t161 = -1.269642451250142d+0*t4*t59*(7.876233178997433d-1*t5
     1         *(-1.3127055298329054d-1*t21*t93*t95-1.4585616998143394d-
     2         1*t153*t21*t48-5.469606374303773d-2*t154*t155*t21-6.40793
     3         1356509611d-3*t152)-1.3127055298329054d-1*t22*t93*t95+1.9
     4         690582947493582d-1*t47*t60*t95+2.625411059665811d-1*t48*t
     5         60*t94-3.9381165894987163d-1*t110*t48*t49-1.4585616998143
     6         394d-1*t153*t22*t48-5.469606374303773d-2*t154*t155*t22)+1
     7         .763392293402975d-2*t155*t24*t95+4.2321415041671406d-1*t5
     8         *t59*t61*t94+7.053569173611901d-2*t24*t48*t93-7.617854707
     9         500852d+0*t4*t61**3/t23**4+1.0580353760417849d-1*t47*t48*
     :         t59*t61+7.617854707500852d+0*t108*t111*t4*t61-6.348212256
     ;         25071d-1*t111*t49*t5*t59+1.269642451250142d+0*t108*t109*t
     <         49*t5+2.3511897245373004d-1*t153*t24*t5
            t162 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         1.865442d-1*t105*t20*t57*t99+8.243319792565315d-3*t100*t4
     2         4*t99+9.327209999999999d-2*t13*t52*t89*t98+3.963119679401
     3         78d-3*t44*t45*t98-3.10907d-2*t13*t45*(7.617854707500852d+
     4         0*t4*t51*t91*t97-6.34821225625071d-1*t46*t49*t5*t97-1.269
     5         642451250142d+0*t4*t46*(-3.9381165894987163d-1*t48*t49*t9
     6         6+7.876233178997433d-1*t5*(-1.3127055298329054d-1*t6*t93*
     7         t95-1.4585616998143394d-1*t153*t48*t6-5.469606374303773d-
     8         2*t154*t155*t6-7.424439106586571d-3*t152)-1.3127055298329
     9         054d-1*t7*t93*t95+1.9690582947493582d-1*t47*t50*t95+2.625
     :         411059665811d-1*t48*t50*t94-1.4585616998143394d-1*t153*t4
     ;         8*t7-5.469606374303773d-2*t154*t155*t7)+1.763392293402975
     <         d-2*t155*t9*t95+4.2321415041671406d-1*t46*t5*t51*t94+7.05
     =         3569173611901d-2*t48*t9*t93+1.269642451250142d+0*t49*t5*t
     >         91*t92+2.3511897245373004d-1*t153*t5*t9-7.617854707500852
     ?         d+0*t4*t51**3/t8**4+1.0580353760417849d-1*t46*t47*t48*t51
     @         )-3.96311967940178d-3*t44*t89*t90+1.0991093056753751d-2*t
     1         53*t57*t88-5.284159572535706d-3*t45*t52*t88-8.24331979256
     2         5315d-3*t105*t44*t53+6.21814d-2*t158*t20*t53-6.21814d-2*t
     3         13*t52**3/t10**3+1.243628d-1*t156*t157*t20-8.548627933030
     4         694d-3*t151*t19+4.1099018897499934d-3*t11*t151)-3.1078196
     5         89081493d-3*t58*t62*t88+1.013214d-1*t106*t112*t27*t62+2.3
     6         3086476681112d-3*t112*t44*t58-3.37738d-2*t161*t27*t58-2.3
     7         3086476681112d-3*t106*t107*t44-6.75476d-2*t159*t160*t27+2
     8         .4171930915078277d-3*t151*t26)+3.107819689081493d-3*t58*t
     9         62*t88-1.013214d-1*t106*t112*t27*t62-2.33086476681112d-3*
     :         t112*t44*t58+3.37738d-2*t161*t27*t58+2.33086476681112d-3*
     ;         t106*t107*t44+6.75476d-2*t159*t160*t27-2.4171930915078277
     <         d-3*t151*t26)+1.865442d-1*t105*t20*t57*t99-8.243319792565
     =         315d-3*t100*t44*t99-1.0991093056753751d-2*t53*t57*t88+8.2
     >         43319792565315d-3*t105*t44*t53-6.21814d-2*t158*t20*t53-1.
     ?         243628d-1*t156*t157*t20+8.548627933030694d-3*t151*t19
            t163 = 2.1974870225448048d+1*gammaaa*t162*t2*t29*t64
            t164 = 1/t1**7.0d+0
            t165 = 1/t36**4
            t166 = 3.553566382931298d+3*t2*t80*t81*t82
            t167 = 2.2195402777608514d+0*t31*t73*t78
            t168 = -1.0569239417908823d-1*t31*t42*t79
            t169 = -1.0254939438542422d+2*t29*t41*t42*t63*t64
            t170 = -1.776783191465649d+3*t2*t29*t64*t80
            t171 = 2.1974870225448048d+1*t113*t2*t29*t64
            fnc(iq) = 1.2367783717787881d-2*rhoa*t39*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.2367783717787881d-2*rhoa*t40*t72*wght+1.2
     1         367783717787881d-2*t39*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.2367783717787881d-2*rhoa*t40*t75*wght+Cm
     1         at(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = -1.2367783717787881d-2*rhoa*t76*t77*wgh
     1         t+t122*t40+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = -1.2367783717787881d-2*rhoa*t72*t75*t7
     1         6*wght+t128*t40+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = -1.2367783717787881d-2*rhoa*t129*t76*
     1         wght+1.2367783717787881d-2*rhoa*t131*t40*wght+Cmat2(iq,D2
     2         _GAA_GAA)
            Amat3(iq,D3_RA_RA_RA) = t40*(1.2367783717787881d-2*rhoa*(-2.
     1         7178044217479813d-1*gammaaa*t2*t33*t67*(-4.05631733997237
     2         73d+4*t116*t41*t68*t69*t80*t81+8.692108585655094d+3*t113*
     3         t116*t34*t63*t81-7.028024409218707d+5*t116*t136*t34*t81+1
     4         .3521057799907926d+4*t29*t41*t68*t69*t70*t80-2.7870919750
     5         82837d+1*t29*t63*t68*t69*t70*t79+9.754821912789926d+2*t11
     6         7*t29*t63*t68*t70*t78-1.6722551850497014d+2*t113*t29*t41*
     7         t68*t69*t70-2.8973695285516987d+3*t113*t29*t34*t63*t70+1.
     8         1944679893212153d+1*t162*t29*t34*t70+7.808916010243009d+4
     9         *t136*t29*t34*t70+4.78752093741761d-2*t135*t35*t68*t69-1.
     :         4075311556007766d+1*t133*t164*t35*t68+1.0053793968576981d
     ;         +0*t117*t134*t35*t68+9.37069921229161d+5*t136*t137*t34/t3
     <         0**5.0d+0+t163+t150+t149+t148+t147+t146+t145+t144+t143+t1
     =         42+t141+t140+t139+t138)+3.170771825372647d-1*gammaaa*t33*
     >         t42*t67*t71*t79-3.170771825372647d-1*gammaaa*t37*t42*t66*
     ?         t79-6.658620833282555d+0*gammaaa*t33*t67*t71*t73*t78+6.65
     @         8620833282555d+0*gammaaa*t37*t66*t73*t78+1.10977013888042
     1         64d+0*gammaaa*t134*t33*t37*t73-1.630682653048789d+0*gamma
     2         aa*t165*t2*t33*t71**3+3.8049261904471743d+0*gammaaa*t41*t
     3         42*t66*t67*t71-8.153413265243944d-1*gammaaa*t115*t2*t67*t
     4         71+1.630682653048789d+0*gammaaa*t118*t119*t2*t33*t71-1.03
     5         5785462955064d+1*gammaaa*t133*t33*t37*t69-8.1534132652439
     6         44d-1*gammaaa*t118*t2*t66*t67+1.9024630952235871d+0*gamma
     7         aa*t118*t33*t41*t42*t67+1.630682653048789d+0*gammaaa*t119
     8         *t120*t2*t66-1.9024630952235871d+0*gammaaa*t115*t37*t41*t
     9         42-3.8049261904471743d+0*gammaaa*t119*t120*t33*t41*t42+8.
     :         807699514924018d-2*gammaaa*t135*t33*t37*t42+2.71780442174
     ;         79813d-1*gammaaa*(t163+t150+t149+t148+t147+t146+t145+t144
     <         +t143+t142+t141+t140+t139+t138)*t2*t37)*wght+3.7103351153
     =         36365d-2*t121*wght)+t76*(-1.2367783717787881d-2*t77*wght-
     >         2.4735567435575762d-2*rhoa*t121*t72*wght-t122*t72)+2.4735
     ?         567435575762d-2*rhoa*t132*t72**3*wght+Amat3(iq,D3_RA_RA_R
     @         A)
            Cmat3(iq,D3_RA_RA_GAA) = t40*(1.2367783717787881d-2*rhoa*(-2
     1         .7178044217479813d-1*gammaaa*t2*t33*t67*(5.79473905710339
     2         6d+3*gammaaa*t116*t73*t80*t81-1.9315796857011325d+3*gamma
     3         aa*t29*t70*t73*t80-1.1490050249802264d-1*gammaaa*t35*t69*
     4         t79+4.0215175874307907d+0*gammaaa*t117*t35*t78+2.38893597
     5         86424305d+1*gammaaa*t113*t29*t70*t73-2.2296735800662684d+
     6         2*gammaaa*t29*t41*t63*t69*t70+t171+t170+t169+t168+t167+t1
     7         66)+1.0569239417908823d-1*gammaaa*t33*t42*t67*t74*t79-2.8
     8         72512562450566d-2*gammaaa*t31*t37*t69*t79-1.0569239417908
     9         823d-1*t33*t37*t42*t79-2.2195402777608514d+0*gammaaa*t33*
     :         t67*t73*t74*t78+2.2195402777608514d+0*t33*t37*t73*t78+6.0
     ;         32276381146184d-1*gammaaa*t117*t31*t37*t78+1.087121768699
     <         1926d+0*gammaaa*t119*t2*t66*t71*t74-2.536617460298116d+0*
     =         gammaaa*t119*t33*t41*t42*t71*t74+1.268308730149058d+0*gam
     >         maaa*t41*t42*t66*t67*t74-2.7178044217479813d-1*gammaaa*t1
     ?         15*t2*t67*t74-1.630682653048789d+0*gammaaa*t120*t165*t2*t
     @         33*t74+5.435608843495963d-1*gammaaa*t118*t119*t2*t33*t74-
     1         7.386460874872879d-2*gammaaa*t118*t31*t67*t73+1.477292174
     2         9745757d-1*gammaaa*t119*t120*t31*t73+3.4470150749406775d-
     3         1*gammaaa*t31*t41*t67*t69*t71-5.435608843495963d-1*t2*t66
     4         *t67*t71+1.268308730149058d+0*t33*t41*t42*t67*t71-5.43560
     5         8843495963d-1*gammaaa*t125*t2*t67*t71+1.0871217686991926d
     6         +0*gammaaa*t119*t126*t2*t33*t71-5.435608843495963d-1*gamm
     7         aaa*t126*t2*t66*t67+1.268308730149058d+0*gammaaa*t126*t33
     8         *t41*t42*t67-2.7178044217479813d-1*t118*t2*t33*t67-1.2683
     9         08730149058d+0*t37*t41*t42*t66-1.268308730149058d+0*gamma
     :         aa*t125*t37*t41*t42+2.7178044217479813d-1*gammaaa*(t171+t
     ;         170+t169+t168+t167+t166)*t2*t37+2.7178044217479813d-1*t11
     <         5*t2*t37+5.435608843495963d-1*t119*t120*t2*t33)*wght+2.47
     =         35567435575762d-2*t127*wght)+t76*(-2.4735567435575762d-2*
     >         rhoa*t127*t72*wght-t122*t75)+2.4735567435575762d-2*rhoa*t
     ?         132*t75*t77*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = t76*(-1.2367783717787881d-2*rhoa*t
     1         127*t75*wght-1.2367783717787881d-2*rhoa*t131*t72*wght-t12
     2         8*t75)+t40*(1.2367783717787881d-2*rhoa*(2.954584349949151
     3         4d-1*gammaaa*t119*t31*t71*t73*t74+1.0871217686991926d+0*t
     4         119*t2*t33*t71*t74+3.4470150749406775d-1*gammaaa*t31*t41*
     5         t67*t69*t74-5.435608843495963d-1*t2*t66*t67*t74+1.2683087
     6         30149058d+0*t33*t41*t42*t67*t74-5.435608843495963d-1*gamm
     7         aaa*t125*t2*t67*t74+1.0871217686991926d+0*gammaaa*t119*t1
     8         26*t2*t33*t74-2.7178044217479813d-1*gammaaa*t2*t33*t67*(2
     9         .3889359786424305d+1*t29*t63*t70*t73-6.894030149881355d-1
     :         *t35*t41*t69)-1.4772921749745757d-1*t31*t67*t71*t73-1.477
     ;         2921749745757d-1*gammaaa*t126*t31*t67*t73+8.0299824107191
     <         9d-2*gammaaa*t117*t119*t33*t35*t71-1.630682653048789d+0*g
     =         ammaaa*t130*t165*t2*t33*t71-3.4470150749406775d-1*t31*t37
     >         *t41*t69-4.014991205359595d-2*gammaaa*t117*t35*t66*t67+9.
     ?         368312812505724d-2*gammaaa*t164*t33*t35*t41*t67-5.4356088
     @         43495963d-1*t126*t2*t33*t67+5.435608843495963d-1*gammaaa*
     1         t119*t130*t2*t66-1.268308730149058d+0*gammaaa*t119*t130*t
     2         33*t41*t42+5.435608843495963d-1*t125*t2*t37)*wght+1.23677
     3         83717787881d-2*t131*wght)+2.4735567435575762d-2*rhoa*t129
     4         *t132*t72*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = -3.710335115336365d-2*rhoa*t131*t
     1         75*t76*wght+2.4735567435575762d-2*rhoa*t132*t75**3*wght+1
     2         .2367783717787881d-2*rhoa*t40*(-1.630682653048789d+0*gamm
     3         aaa*t165*t2*t33*t74**3-4.431876524923727d-1*t31*t67*t73*t
     4         74+2.4089947232157571d-1*gammaaa*t117*t119*t33*t35*t74+4.
     5         431876524923727d-1*gammaaa*t119*t130*t31*t73-3.2735882553
     6         616696d-2*gammaaa*t67*t70/t1**8.0d+0-1.2044973616078786d-
     7         1*t117*t33*t35*t67+1.630682653048789d+0*t119*t130*t2*t33)
     8         *wght+Cmat3(iq,D3_GAA_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhob**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1.530901310039024d-2*t5+1.0465751434d-1
            t7 = 7.876233178997433d-1*t5*t6+1.9269083139d-1
            t8 = 7.876233178997433d-1*t5*t7+4.3896648423d-1
            t9 = 1/t8
            t10 = 1.269642451250142d+0*t4*t9+1.0d+0
            t11 = log(t10)
            t12 = 1/t3
            t13 = 1.2746961887000874d-1*t12+1.0d+0
            t14 = 2.4141993114533214d-2*t5+1.0186556948d-1
            t15 = 7.876233178997433d-1*t14*t5+2.2308199064d-1
            t16 = 7.876233178997433d-1*t15*t5+4.7231125998d-1
            t17 = 1/t16
            t18 = 1.269642451250142d+0*t17*t4+1.0d+0
            t19 = log(t18)
            t20 = 1.325688999052018d-1*t12+1.0d+0
            t21 = 1.3212998810398843d-2*t5+2.9729725188d-2
            t22 = 7.876233178997433d-1*t21*t5+1.2236585478d-1
            t23 = 7.876233178997433d-1*t22*t5+3.497952466d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t24*t4+1.0d+0
            t26 = log(t25)
            t27 = 6.901399211255826d-2*t12+1.0d+0
            t28 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t19*t20-3.10907d-2*t11*t13)-3.37738d-2*t26*t27)+
     2         3.37738d-2*t26*t27)-6.21814d-2*t19*t20
            t29 = exp(-8.085523023512745d+1*t28)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.7178044217479813d-1*gammabb*t2*t31
            t33 = t32+1.0d+0
            t34 = (gammabb*t2)**2.0d+0
            t35 = 1/t30**2.0d+0
            t36 = 7.38646087487288d-2*t34*t35+t32+1.0d+0
            t37 = 1/t36
            t38 = 2.7178044217479813d-1*gammabb*t2*t33*t37+1.0d+0
            t39 = log(t38)
            t40 = 1/t38
            t41 = rhob**1.6666666666666674d-1
            t42 = 1/t1**3.0d+0
            t43 = -6.34154365074529d-1*gammabb*t31*t41*t42
            t44 = 1/rhob**1.3333333333333333d+0
            t45 = 1/t10
            t46 = 1/t8**2
            t47 = 1/rhob**1.3333333333333336d+0
            t48 = 1/t4**3
            t49 = 1/rhob**6.666666666666667d-1
            t50 = -1.3127055298329054d-1*t48*t49*t6-2.0096226153166658d-
     1         3*t47
            t51 = 7.876233178997433d-1*t5*t50-1.3127055298329054d-1*t48*
     1         t49*t7
            t52 = 2.11607075208357d-1*t49*t5*t9-1.269642451250142d+0*t4*
     1         t46*t51
            t53 = 1/t18
            t54 = 1/t16**2
            t55 = -1.3127055298329054d-1*t14*t48*t49-3.169132786263567d-
     1         3*t47
            t56 = 7.876233178997433d-1*t5*t55-1.3127055298329054d-1*t15*
     1         t48*t49
            t57 = 2.11607075208357d-1*t17*t49*t5-1.269642451250142d+0*t4
     1         *t54*t56
            t58 = 1/t25
            t59 = 1/t23**2
            t60 = -1.3127055298329054d-1*t21*t48*t49-1.7344776604086162d
     1         -3*t47
            t61 = 7.876233178997433d-1*t5*t60-1.3127055298329054d-1*t22*
     1         t48*t49
            t62 = 2.11607075208357d-1*t24*t49*t5-1.269642451250142d+0*t4
     1         *t59*t61
            t63 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t27*t58*t62+
     1         1.709920934161365d+0*(6.21814d-2*t20*t53*t57-3.10907d-2*t
     2         13*t45*t52-2.747773264188438d-3*t19*t44+1.321039893133926
     3         5d-3*t11*t44)+7.769549222703733d-4*t26*t44)+3.37738d-2*t2
     4         7*t58*t62-7.769549222703733d-4*t26*t44)-6.21814d-2*t20*t5
     5         3*t57+2.747773264188438d-3*t19*t44
            t64 = 1/t30**2
            t65 = 2.1974870225448048d+1*gammabb*t2*t29*t63*t64
            t66 = t65+t43
            t67 = 1/t36**2
            t68 = gammabb**2
            t69 = 1/t1**5.0d+0
            t70 = 1/t30**3.0d+0
            t71 = 1.1944679893212153d+1*t29*t34*t63*t70-3.44701507494067
     1         75d-1*t35*t41*t68*t69+t65+t43
            t72 = -2.7178044217479813d-1*gammabb*t2*t33*t67*t71+2.717804
     1         4217479813d-1*gammabb*t2*t37*t66-6.34154365074529d-1*gamm
     2         abb*t33*t37*t41*t42
            t73 = 1/t1**4.0d+0
            t74 = 1.477292174974576d-1*gammabb*t35*t73+2.717804421747981
     1         3d-1*t2*t31
            t75 = -2.7178044217479813d-1*gammabb*t2*t33*t67*t74+7.386460
     1         874872879d-2*gammabb*t31*t37*t73+2.7178044217479813d-1*t2
     2         *t33*t37
            t76 = 1/t38**2
            t77 = t72**2
            t78 = rhob**3.333333333333335d-1
            t79 = 1/rhob**8.333333333333333d-1
            t80 = t63**2
            t81 = exp(-1.617104604702549d+2*t28)
            t82 = 1/t30**3
            t83 = 3.553566382931298d+3*gammabb*t2*t80*t81*t82
            t84 = 2.2195402777608514d+0*gammabb*t31*t73*t78
            t85 = -1.0569239417908823d-1*gammabb*t31*t42*t79
            t86 = -1.0254939438542422d+2*gammabb*t29*t41*t42*t63*t64
            t87 = -1.776783191465649d+3*gammabb*t2*t29*t64*t80
            t88 = 1/rhob**2.333333333333333d+0
            t89 = 1/t10**2
            t90 = t52**2
            t91 = 1/t8**3
            t92 = t51**2
            t93 = 1/rhob**2.3333333333333334d+0
            t94 = 1/rhob**1.6666666666666669d+0
            t95 = 1/t4**5
            t96 = 6.563527649164527d-2*t47*t6*t95+8.751370198886037d-2*t
     1         48*t6*t94+3.0144339229749983d-3*t93
            t97 = 7.876233178997433d-1*t5*t96+6.563527649164527d-2*t47*t
     1         7*t95+8.751370198886037d-2*t48*t7*t94-2.625411059665811d-
     2         1*t48*t49*t50
            t98 = -1.269642451250142d+0*t4*t46*t97-1.4107138347223802d-1
     1         *t5*t9*t94+2.539284902500284d+0*t4*t91*t92-3.526784586805
     2         95d-2*t47*t48*t9-4.23214150416714d-1*t46*t49*t5*t51
            t99 = 1/t18**2
            t100 = t57**2
            t101 = 1/t16**3
            t102 = t56**2
            t103 = 6.563527649164527d-2*t14*t47*t95+8.751370198886037d-2
     1         *t14*t48*t94+4.753699179395351d-3*t93
            t104 = 6.563527649164527d-2*t15*t47*t95+8.751370198886037d-2
     1         *t15*t48*t94-2.625411059665811d-1*t48*t49*t55+7.876233178
     2         997433d-1*t103*t5
            t105 = -1.4107138347223802d-1*t17*t5*t94-4.23214150416714d-1
     1         *t49*t5*t54*t56-1.269642451250142d+0*t104*t4*t54-3.526784
     2         58680595d-2*t17*t47*t48+2.539284902500284d+0*t101*t102*t4
            t106 = 1/t25**2
            t107 = t62**2
            t108 = 1/t23**3
            t109 = t61**2
            t110 = 6.563527649164527d-2*t21*t47*t95+8.751370198886037d-2
     1         *t21*t48*t94+2.601716490612924d-3*t93
            t111 = 6.563527649164527d-2*t22*t47*t95+8.751370198886037d-2
     1         *t22*t48*t94-2.625411059665811d-1*t48*t49*t60+7.876233178
     2         997433d-1*t110*t5
            t112 = -1.4107138347223802d-1*t24*t5*t94-4.23214150416714d-1
     1         *t49*t5*t59*t61-1.269642451250142d+0*t111*t4*t59-3.526784
     2         58680595d-2*t24*t47*t48+2.539284902500284d+0*t108*t109*t4
            t113 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         6.21814d-2*t100*t20*t99-3.10907d-2*t13*t45*t98+3.10907d-2
     2         *t13*t89*t90+3.663697685584584d-3*t19*t88-1.7613865241785
     3         687d-3*t11*t88-5.495546528376876d-3*t44*t53*t57+6.21814d-
     4         2*t105*t20*t53+2.642079786267853d-3*t44*t45*t52)-1.035939
     5         8963604977d-3*t26*t88+1.5539098445407465d-3*t44*t58*t62-3
     6         .37738d-2*t112*t27*t58+3.37738d-2*t106*t107*t27)+1.035939
     7         8963604977d-3*t26*t88-1.5539098445407465d-3*t44*t58*t62+3
     8         .37738d-2*t112*t27*t58-3.37738d-2*t106*t107*t27)+6.21814d
     9         -2*t100*t20*t99-3.663697685584584d-3*t19*t88+5.4955465283
     :         76876d-3*t44*t53*t57-6.21814d-2*t105*t20*t53
            t114 = 2.1974870225448048d+1*gammabb*t113*t2*t29*t64
            t115 = t87+t86+t85+t84+t83+t114
            t116 = 1/t30**4.0d+0
            t117 = 1/t1**6.0d+0
            t118 = t87+t86+t85+t84+t83+2.897369528551698d+3*t116*t34*t80
     1         *t81-9.657898428505661d+2*t29*t34*t70*t80-5.7450251249011
     2         32d-2*t35*t68*t69*t79+2.0107587937153953d+0*t117*t35*t68*
     3         t78-1.1148367900331342d+2*t29*t41*t63*t68*t69*t70+1.19446
     4         79893212153d+1*t113*t29*t34*t70+t114
            t119 = 1/t36**3
            t120 = t71**2
            t121 = -1.0569239417908823d-1*gammabb*t33*t37*t42*t79+2.2195
     1         402777608514d+0*gammabb*t33*t37*t73*t78-5.435608843495963
     2         d-1*gammabb*t2*t66*t67*t71+1.268308730149058d+0*gammabb*t
     3         33*t41*t42*t67*t71-2.7178044217479813d-1*gammabb*t118*t2*
     4         t33*t67-1.268308730149058d+0*gammabb*t37*t41*t42*t66+2.71
     5         78044217479813d-1*gammabb*t115*t2*t37+5.435608843495963d-
     6         1*gammabb*t119*t120*t2*t33
            t122 = 2.4735567435575762d-2*t72*wght+1.2367783717787881d-2*
     1         rhob*t121*wght
            t123 = -6.34154365074529d-1*t31*t41*t42
            t124 = 2.1974870225448048d+1*t2*t29*t63*t64
            t125 = t124+t123
            t126 = 2.3889359786424305d+1*gammabb*t29*t63*t70*t73-6.89403
     1         0149881355d-1*gammabb*t35*t41*t69+t124+t123
            t127 = 5.435608843495963d-1*gammabb*t119*t2*t33*t71*t74-2.71
     1         78044217479813d-1*gammabb*t2*t66*t67*t74+6.34154365074529
     2         d-1*gammabb*t33*t41*t42*t67*t74-7.386460874872879d-2*gamm
     3         abb*t31*t67*t71*t73-2.7178044217479813d-1*t2*t33*t67*t71-
     4         1.7235075374703387d-1*gammabb*t31*t37*t41*t69-2.717804421
     5         7479813d-1*gammabb*t126*t2*t33*t67+2.7178044217479813d-1*
     6         t2*t37*t66-6.34154365074529d-1*t33*t37*t41*t42+2.71780442
     7         17479813d-1*gammabb*t125*t2*t37
            t128 = 1.2367783717787881d-2*t75*wght+1.2367783717787881d-2*
     1         rhob*t127*wght
            t129 = t75**2
            t130 = t74**2
            t131 = -1.4772921749745757d-1*gammabb*t31*t67*t73*t74-5.4356
     1         08843495963d-1*t2*t33*t67*t74+1.4772921749745757d-1*t31*t
     2         37*t73-4.014991205359595d-2*gammabb*t117*t33*t35*t67+5.43
     3         5608843495963d-1*gammabb*t119*t130*t2*t33
            t132 = 1/t38**3
            t133 = rhob**5.000000000000002d-1
            t134 = 1/rhob**6.666666666666665d-1
            t135 = 1/rhob**1.8333333333333332d+0
            t136 = t63**3
            t137 = exp(-2.4256569070538234d+2*t28)
            t138 = 8.619732841431575d+5*gammabb*t136*t137*t2/t30**4
            t139 = -2.4874964680519085d+4*gammabb*t41*t42*t80*t81*t82
            t140 = -8.619732841431575d+5*gammabb*t136*t2*t81*t82
            t141 = 1.0660699148793894d+4*gammabb*t113*t2*t63*t81*t82
            t142 = -1.035785462955064d+1*gammabb*t133*t31*t69
            t143 = 1.1097701388804264d+0*gammabb*t134*t31*t73
            t144 = 8.807699514924018d-2*gammabb*t135*t31*t42
            t145 = 5.383843205234772d+2*gammabb*t29*t63*t64*t73*t78
            t146 = -2.563734859635607d+1*gammabb*t29*t42*t63*t64*t79
            t147 = 1.2437482340259542d+4*gammabb*t29*t41*t42*t64*t80
            t148 = -1.5382409157813634d+2*gammabb*t113*t29*t41*t42*t64
            t149 = 1.436622140238596d+5*gammabb*t136*t2*t29*t64
            t150 = -5.330349574396946d+3*gammabb*t113*t2*t29*t63*t64
            t151 = 1/rhob**3.333333333333333d+0
            t152 = 1/rhob**3.3333333333333337d+0
            t153 = 1/rhob**2.666666666666667d+0
            t154 = 1/t4**7
            t155 = 1/rhob**2.0d+0
            t156 = 1/t18**3
            t157 = t57**3
            t158 = -1.269642451250142d+0*t4*t54*(7.876233178997433d-1*t5
     1         *(-1.3127055298329054d-1*t14*t93*t95-1.4585616998143394d-
     2         1*t14*t153*t48-5.469606374303773d-2*t14*t154*t155-1.17081
     3         85015918181d-2*t152)-1.3127055298329054d-1*t15*t93*t95+1.
     4         9690582947493582d-1*t47*t55*t95+2.625411059665811d-1*t48*
     5         t55*t94-3.9381165894987163d-1*t103*t48*t49-1.458561699814
     6         3394d-1*t15*t153*t48-5.469606374303773d-2*t15*t154*t155)+
     7         1.763392293402975d-2*t155*t17*t95+4.2321415041671406d-1*t
     8         5*t54*t56*t94+7.053569173611901d-2*t17*t48*t93-7.61785470
     9         7500852d+0*t4*t56**3/t16**4+1.0580353760417849d-1*t47*t48
     :         *t54*t56+7.617854707500852d+0*t101*t104*t4*t56-6.34821225
     ;         625071d-1*t104*t49*t5*t54+1.269642451250142d+0*t101*t102*
     <         t49*t5+2.3511897245373004d-1*t153*t17*t5
            t159 = 1/t25**3
            t160 = t62**3
            t161 = -1.269642451250142d+0*t4*t59*(7.876233178997433d-1*t5
     1         *(-1.3127055298329054d-1*t21*t93*t95-1.4585616998143394d-
     2         1*t153*t21*t48-5.469606374303773d-2*t154*t155*t21-6.40793
     3         1356509611d-3*t152)-1.3127055298329054d-1*t22*t93*t95+1.9
     4         690582947493582d-1*t47*t60*t95+2.625411059665811d-1*t48*t
     5         60*t94-3.9381165894987163d-1*t110*t48*t49-1.4585616998143
     6         394d-1*t153*t22*t48-5.469606374303773d-2*t154*t155*t22)+1
     7         .763392293402975d-2*t155*t24*t95+4.2321415041671406d-1*t5
     8         *t59*t61*t94+7.053569173611901d-2*t24*t48*t93-7.617854707
     9         500852d+0*t4*t61**3/t23**4+1.0580353760417849d-1*t47*t48*
     :         t59*t61+7.617854707500852d+0*t108*t111*t4*t61-6.348212256
     ;         25071d-1*t111*t49*t5*t59+1.269642451250142d+0*t108*t109*t
     <         49*t5+2.3511897245373004d-1*t153*t24*t5
            t162 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         1.865442d-1*t105*t20*t57*t99+8.243319792565315d-3*t100*t4
     2         4*t99+9.327209999999999d-2*t13*t52*t89*t98+3.963119679401
     3         78d-3*t44*t45*t98-3.10907d-2*t13*t45*(7.617854707500852d+
     4         0*t4*t51*t91*t97-6.34821225625071d-1*t46*t49*t5*t97-1.269
     5         642451250142d+0*t4*t46*(-3.9381165894987163d-1*t48*t49*t9
     6         6+7.876233178997433d-1*t5*(-1.3127055298329054d-1*t6*t93*
     7         t95-1.4585616998143394d-1*t153*t48*t6-5.469606374303773d-
     8         2*t154*t155*t6-7.424439106586571d-3*t152)-1.3127055298329
     9         054d-1*t7*t93*t95+1.9690582947493582d-1*t47*t50*t95+2.625
     :         411059665811d-1*t48*t50*t94-1.4585616998143394d-1*t153*t4
     ;         8*t7-5.469606374303773d-2*t154*t155*t7)+1.763392293402975
     <         d-2*t155*t9*t95+4.2321415041671406d-1*t46*t5*t51*t94+7.05
     =         3569173611901d-2*t48*t9*t93+1.269642451250142d+0*t49*t5*t
     >         91*t92+2.3511897245373004d-1*t153*t5*t9-7.617854707500852
     ?         d+0*t4*t51**3/t8**4+1.0580353760417849d-1*t46*t47*t48*t51
     @         )-3.96311967940178d-3*t44*t89*t90+1.0991093056753751d-2*t
     1         53*t57*t88-5.284159572535706d-3*t45*t52*t88-8.24331979256
     2         5315d-3*t105*t44*t53+6.21814d-2*t158*t20*t53-6.21814d-2*t
     3         13*t52**3/t10**3+1.243628d-1*t156*t157*t20-8.548627933030
     4         694d-3*t151*t19+4.1099018897499934d-3*t11*t151)-3.1078196
     5         89081493d-3*t58*t62*t88+1.013214d-1*t106*t112*t27*t62+2.3
     6         3086476681112d-3*t112*t44*t58-3.37738d-2*t161*t27*t58-2.3
     7         3086476681112d-3*t106*t107*t44-6.75476d-2*t159*t160*t27+2
     8         .4171930915078277d-3*t151*t26)+3.107819689081493d-3*t58*t
     9         62*t88-1.013214d-1*t106*t112*t27*t62-2.33086476681112d-3*
     :         t112*t44*t58+3.37738d-2*t161*t27*t58+2.33086476681112d-3*
     ;         t106*t107*t44+6.75476d-2*t159*t160*t27-2.4171930915078277
     <         d-3*t151*t26)+1.865442d-1*t105*t20*t57*t99-8.243319792565
     =         315d-3*t100*t44*t99-1.0991093056753751d-2*t53*t57*t88+8.2
     >         43319792565315d-3*t105*t44*t53-6.21814d-2*t158*t20*t53-1.
     ?         243628d-1*t156*t157*t20+8.548627933030694d-3*t151*t19
            t163 = 2.1974870225448048d+1*gammabb*t162*t2*t29*t64
            t164 = 1/t1**7.0d+0
            t165 = 1/t36**4
            t166 = 3.553566382931298d+3*t2*t80*t81*t82
            t167 = 2.2195402777608514d+0*t31*t73*t78
            t168 = -1.0569239417908823d-1*t31*t42*t79
            t169 = -1.0254939438542422d+2*t29*t41*t42*t63*t64
            t170 = -1.776783191465649d+3*t2*t29*t64*t80
            t171 = 2.1974870225448048d+1*t113*t2*t29*t64
            fnc(iq) = 1.2367783717787881d-2*rhob*t39*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.2367783717787881d-2*rhob*t40*t72*wght+1.2
     1         367783717787881d-2*t39*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.2367783717787881d-2*rhob*t40*t75*wght+Cm
     1         at(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = -1.2367783717787881d-2*rhob*t76*t77*wgh
     1         t+t122*t40+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = -1.2367783717787881d-2*rhob*t72*t75*t7
     1         6*wght+t128*t40+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = -1.2367783717787881d-2*rhob*t129*t76*
     1         wght+1.2367783717787881d-2*rhob*t131*t40*wght+Cmat2(iq,D2
     2         _GBB_GBB)
            Amat3(iq,D3_RB_RB_RB) = t40*(1.2367783717787881d-2*rhob*(-2.
     1         7178044217479813d-1*gammabb*t2*t33*t67*(-4.05631733997237
     2         73d+4*t116*t41*t68*t69*t80*t81+8.692108585655094d+3*t113*
     3         t116*t34*t63*t81-7.028024409218707d+5*t116*t136*t34*t81+1
     4         .3521057799907926d+4*t29*t41*t68*t69*t70*t80-2.7870919750
     5         82837d+1*t29*t63*t68*t69*t70*t79+9.754821912789926d+2*t11
     6         7*t29*t63*t68*t70*t78-1.6722551850497014d+2*t113*t29*t41*
     7         t68*t69*t70-2.8973695285516987d+3*t113*t29*t34*t63*t70+1.
     8         1944679893212153d+1*t162*t29*t34*t70+7.808916010243009d+4
     9         *t136*t29*t34*t70+4.78752093741761d-2*t135*t35*t68*t69-1.
     :         4075311556007766d+1*t133*t164*t35*t68+1.0053793968576981d
     ;         +0*t117*t134*t35*t68+9.37069921229161d+5*t136*t137*t34/t3
     <         0**5.0d+0+t163+t150+t149+t148+t147+t146+t145+t144+t143+t1
     =         42+t141+t140+t139+t138)+3.170771825372647d-1*gammabb*t33*
     >         t42*t67*t71*t79-3.170771825372647d-1*gammabb*t37*t42*t66*
     ?         t79-6.658620833282555d+0*gammabb*t33*t67*t71*t73*t78+6.65
     @         8620833282555d+0*gammabb*t37*t66*t73*t78+1.10977013888042
     1         64d+0*gammabb*t134*t33*t37*t73-1.630682653048789d+0*gamma
     2         bb*t165*t2*t33*t71**3+3.8049261904471743d+0*gammabb*t41*t
     3         42*t66*t67*t71-8.153413265243944d-1*gammabb*t115*t2*t67*t
     4         71+1.630682653048789d+0*gammabb*t118*t119*t2*t33*t71-1.03
     5         5785462955064d+1*gammabb*t133*t33*t37*t69-8.1534132652439
     6         44d-1*gammabb*t118*t2*t66*t67+1.9024630952235871d+0*gamma
     7         bb*t118*t33*t41*t42*t67+1.630682653048789d+0*gammabb*t119
     8         *t120*t2*t66-1.9024630952235871d+0*gammabb*t115*t37*t41*t
     9         42-3.8049261904471743d+0*gammabb*t119*t120*t33*t41*t42+8.
     :         807699514924018d-2*gammabb*t135*t33*t37*t42+2.71780442174
     ;         79813d-1*gammabb*(t163+t150+t149+t148+t147+t146+t145+t144
     <         +t143+t142+t141+t140+t139+t138)*t2*t37)*wght+3.7103351153
     =         36365d-2*t121*wght)+t76*(-1.2367783717787881d-2*t77*wght-
     >         2.4735567435575762d-2*rhob*t121*t72*wght-t122*t72)+2.4735
     ?         567435575762d-2*rhob*t132*t72**3*wght+Amat3(iq,D3_RB_RB_R
     @         B)
            Cmat3(iq,D3_RB_RB_GBB) = t40*(1.2367783717787881d-2*rhob*(-2
     1         .7178044217479813d-1*gammabb*t2*t33*t67*(5.79473905710339
     2         6d+3*gammabb*t116*t73*t80*t81-1.9315796857011325d+3*gamma
     3         bb*t29*t70*t73*t80-1.1490050249802264d-1*gammabb*t35*t69*
     4         t79+4.0215175874307907d+0*gammabb*t117*t35*t78+2.38893597
     5         86424305d+1*gammabb*t113*t29*t70*t73-2.2296735800662684d+
     6         2*gammabb*t29*t41*t63*t69*t70+t171+t170+t169+t168+t167+t1
     7         66)+1.0569239417908823d-1*gammabb*t33*t42*t67*t74*t79-2.8
     8         72512562450566d-2*gammabb*t31*t37*t69*t79-1.0569239417908
     9         823d-1*t33*t37*t42*t79-2.2195402777608514d+0*gammabb*t33*
     :         t67*t73*t74*t78+2.2195402777608514d+0*t33*t37*t73*t78+6.0
     ;         32276381146184d-1*gammabb*t117*t31*t37*t78+1.087121768699
     <         1926d+0*gammabb*t119*t2*t66*t71*t74-2.536617460298116d+0*
     =         gammabb*t119*t33*t41*t42*t71*t74+1.268308730149058d+0*gam
     >         mabb*t41*t42*t66*t67*t74-2.7178044217479813d-1*gammabb*t1
     ?         15*t2*t67*t74-1.630682653048789d+0*gammabb*t120*t165*t2*t
     @         33*t74+5.435608843495963d-1*gammabb*t118*t119*t2*t33*t74-
     1         7.386460874872879d-2*gammabb*t118*t31*t67*t73+1.477292174
     2         9745757d-1*gammabb*t119*t120*t31*t73+3.4470150749406775d-
     3         1*gammabb*t31*t41*t67*t69*t71-5.435608843495963d-1*t2*t66
     4         *t67*t71+1.268308730149058d+0*t33*t41*t42*t67*t71-5.43560
     5         8843495963d-1*gammabb*t125*t2*t67*t71+1.0871217686991926d
     6         +0*gammabb*t119*t126*t2*t33*t71-5.435608843495963d-1*gamm
     7         abb*t126*t2*t66*t67+1.268308730149058d+0*gammabb*t126*t33
     8         *t41*t42*t67-2.7178044217479813d-1*t118*t2*t33*t67-1.2683
     9         08730149058d+0*t37*t41*t42*t66-1.268308730149058d+0*gamma
     :         bb*t125*t37*t41*t42+2.7178044217479813d-1*gammabb*(t171+t
     ;         170+t169+t168+t167+t166)*t2*t37+2.7178044217479813d-1*t11
     <         5*t2*t37+5.435608843495963d-1*t119*t120*t2*t33)*wght+2.47
     =         35567435575762d-2*t127*wght)+t76*(-2.4735567435575762d-2*
     >         rhob*t127*t72*wght-t122*t75)+2.4735567435575762d-2*rhob*t
     ?         132*t75*t77*wght+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = t76*(-1.2367783717787881d-2*rhob*t
     1         127*t75*wght-1.2367783717787881d-2*rhob*t131*t72*wght-t12
     2         8*t75)+t40*(1.2367783717787881d-2*rhob*(2.954584349949151
     3         4d-1*gammabb*t119*t31*t71*t73*t74+1.0871217686991926d+0*t
     4         119*t2*t33*t71*t74+3.4470150749406775d-1*gammabb*t31*t41*
     5         t67*t69*t74-5.435608843495963d-1*t2*t66*t67*t74+1.2683087
     6         30149058d+0*t33*t41*t42*t67*t74-5.435608843495963d-1*gamm
     7         abb*t125*t2*t67*t74+1.0871217686991926d+0*gammabb*t119*t1
     8         26*t2*t33*t74-2.7178044217479813d-1*gammabb*t2*t33*t67*(2
     9         .3889359786424305d+1*t29*t63*t70*t73-6.894030149881355d-1
     :         *t35*t41*t69)-1.4772921749745757d-1*t31*t67*t71*t73-1.477
     ;         2921749745757d-1*gammabb*t126*t31*t67*t73+8.0299824107191
     <         9d-2*gammabb*t117*t119*t33*t35*t71-1.630682653048789d+0*g
     =         ammabb*t130*t165*t2*t33*t71-3.4470150749406775d-1*t31*t37
     >         *t41*t69-4.014991205359595d-2*gammabb*t117*t35*t66*t67+9.
     ?         368312812505724d-2*gammabb*t164*t33*t35*t41*t67-5.4356088
     @         43495963d-1*t126*t2*t33*t67+5.435608843495963d-1*gammabb*
     1         t119*t130*t2*t66-1.268308730149058d+0*gammabb*t119*t130*t
     2         33*t41*t42+5.435608843495963d-1*t125*t2*t37)*wght+1.23677
     3         83717787881d-2*t131*wght)+2.4735567435575762d-2*rhob*t129
     4         *t132*t72*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = -3.710335115336365d-2*rhob*t131*t
     1         75*t76*wght+2.4735567435575762d-2*rhob*t132*t75**3*wght+1
     2         .2367783717787881d-2*rhob*t40*(-1.630682653048789d+0*gamm
     3         abb*t165*t2*t33*t74**3-4.431876524923727d-1*t31*t67*t73*t
     4         74+2.4089947232157571d-1*gammabb*t117*t119*t33*t35*t74+4.
     5         431876524923727d-1*gammabb*t119*t130*t31*t73-3.2735882553
     6         616696d-2*gammabb*t67*t70/t1**8.0d+0-1.2044973616078786d-
     7         1*t117*t33*t35*t67+1.630682653048789d+0*t119*t130*t2*t33)
     8         *wght+Cmat3(iq,D3_GBB_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
