const ver = require('../lib/version-from-tgz.js')
const t = require('tap')

t.strictSame(ver('asdf-foo', 'asdf-foo-1.2.3.tgz'), { name: 'asdf-foo', version: '1.2.3' })
t.strictSame(ver('asdf-foo', '/path/to/asdf-foo-1.2.3.tgz'), { name: 'asdf-foo', version: '1.2.3' })
t.strictSame(ver('asdf-foo', 'https://x.y/p/a/t/h/asdf-foo-1.2.3.tgz'), { name: 'asdf-foo', version: '1.2.3' })
t.strictSame(ver('@asdf/foo', 'https://x.y/p/a/t/h/@asdf%2ffoo/-/foo-1.2.3.tgz'), { name: '@asdf/foo', version: '1.2.3' })
t.strictSame(ver('blorg', 'https://x.y/p/a/t/h/@asdf%2ffoo/-/foo-1.2.3.tgz'), { name: '@asdf/foo', version: '1.2.3' })
t.strictSame(ver('@asdf/foo', 'https://x.y/p/a/t/h/@asdf%2Ffoo/-/foo-1.2.3.tgz'), { name: '@asdf/foo', version: '1.2.3' })
t.strictSame(ver('blorg', 'https://x.y/p/a/t/h/@asdf%2Ffoo/-/foo-1.2.3.tgz'), { name: '@asdf/foo', version: '1.2.3' })
t.strictSame(ver('@asdf/foo', 'https://x.y/p/a/t/h/@asdf/foo/-/foo-1.2.3.tgz'), { name: '@asdf/foo', version: '1.2.3' })
t.strictSame(ver('blorg', 'https://x.y/p/a/t/h/@asdf/foo/-/foo-1.2.3.tgz'), { name: '@asdf/foo', version: '1.2.3' })
t.strictSame(ver('x', 'https://x.y/p/a/t/h/-/@foo/$bar/-/@asdf/foo/-/foo-1.2.3.tgz'), { name: '@asdf/foo', version: '1.2.3' })
t.strictSame(ver('x', 'https://x.y/p/a/t/h/-/@foo/$bar/-/@asdf/foo/foo-1.2.3.tgz'), null)
t.strictSame(ver('x', 'https://x.y/-/-/foo-1.2.3.tgz'), null)
t.strictSame(ver('x', 'https://host.com/api/v1/tar.gz/master'), null)
t.strictSame(ver('x', '/path/to/x.tgz'), null)
t.strictSame(ver('x', '/path/to/x-a3wasf.tgz'), null)
