/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Round a single-precision floating-point number toward zero.
*
* @module @stdlib/math/base/special/truncf
*
* @example
* var truncf = require( '@stdlib/math/base/special/truncf' );
*
* var v = truncf( -4.2 );
* // returns -4.0
*
* v = truncf( 9.99999 );
* // returns 9.0
*
* v = truncf( 0.0 );
* // returns 0.0
*
* v = truncf( -0.0 );
* // returns -0.0
*
* v = truncf( NaN );
* // returns NaN
*
* v = truncf( Infinity );
* // returns Infinity
*
* v = truncf( -Infinity );
* // returns -Infinity
*/

// MODULES //

var truncf = require( './main.js' );


// EXPORTS //

module.exports = truncf;
