/* moonshot-identities-manager.c generated by valac 0.24.0, the Vala compiler
 * generated from moonshot-identities-manager.vala, do not modify */

/*
 * Copyright (c) 2011-2014, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-keyring-memory.h>
#include <gee.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PASSWORD (password_get_type ())
#define PASSWORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PASSWORD, Password))
#define PASSWORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PASSWORD, PasswordClass))
#define IS_PASSWORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PASSWORD))
#define IS_PASSWORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PASSWORD))
#define PASSWORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PASSWORD, PasswordClass))

typedef struct _Password Password;
typedef struct _PasswordClass PasswordClass;
typedef struct _PasswordPrivate PasswordPrivate;
typedef struct _ParamSpecPassword ParamSpecPassword;

#define TYPE_PASSWORD_HASH_TABLE (password_hash_table_get_type ())
#define PASSWORD_HASH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PASSWORD_HASH_TABLE, PasswordHashTable))
#define PASSWORD_HASH_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PASSWORD_HASH_TABLE, PasswordHashTableClass))
#define IS_PASSWORD_HASH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PASSWORD_HASH_TABLE))
#define IS_PASSWORD_HASH_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PASSWORD_HASH_TABLE))
#define PASSWORD_HASH_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PASSWORD_HASH_TABLE, PasswordHashTableClass))

typedef struct _PasswordHashTable PasswordHashTable;
typedef struct _PasswordHashTableClass PasswordHashTableClass;
typedef struct _PasswordHashTablePrivate PasswordHashTablePrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define TYPE_IIDENTITY_CARD_STORE (iidentity_card_store_get_type ())
#define IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStore))
#define IS_IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IIDENTITY_CARD_STORE))
#define IIDENTITY_CARD_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStoreIface))

typedef struct _IIdentityCardStore IIdentityCardStore;
typedef struct _IIdentityCardStoreIface IIdentityCardStoreIface;

#define IIDENTITY_CARD_STORE_TYPE_STORE_TYPE (iidentity_card_store_store_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_IDENTITY_MANAGER_MODEL (identity_manager_model_get_type ())
#define IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModel))
#define IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))
#define IS_IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_MODEL))
#define IS_IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_MODEL))
#define IDENTITY_MANAGER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))

typedef struct _IdentityManagerModel IdentityManagerModel;
typedef struct _IdentityManagerModelClass IdentityManagerModelClass;
typedef struct _IdentityManagerModelPrivate IdentityManagerModelPrivate;

#define TYPE_IDENTITY_MANAGER_APP (identity_manager_app_get_type ())
#define IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerApp))
#define IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))
#define IS_IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_APP))
#define IS_IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_APP))
#define IDENTITY_MANAGER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))

typedef struct _IdentityManagerApp IdentityManagerApp;
typedef struct _IdentityManagerAppClass IdentityManagerAppClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _identity_manager_app_unref0(var) ((var == NULL) ? NULL : (var = (identity_manager_app_unref (var), NULL)))

#define TYPE_KEYRING_STORE (keyring_store_get_type ())
#define KEYRING_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYRING_STORE, KeyringStore))
#define KEYRING_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYRING_STORE, KeyringStoreClass))
#define IS_KEYRING_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYRING_STORE))
#define IS_KEYRING_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYRING_STORE))
#define KEYRING_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYRING_STORE, KeyringStoreClass))

typedef struct _KeyringStore KeyringStore;
typedef struct _KeyringStoreClass KeyringStoreClass;

#define TYPE_LOCAL_FLAT_FILE_STORE (local_flat_file_store_get_type ())
#define LOCAL_FLAT_FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStore))
#define LOCAL_FLAT_FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStoreClass))
#define IS_LOCAL_FLAT_FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCAL_FLAT_FILE_STORE))
#define IS_LOCAL_FLAT_FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCAL_FLAT_FILE_STORE))
#define LOCAL_FLAT_FILE_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStoreClass))

typedef struct _LocalFlatFileStore LocalFlatFileStore;
typedef struct _LocalFlatFileStoreClass LocalFlatFileStoreClass;

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

struct _Password {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PasswordPrivate * priv;
};

struct _PasswordClass {
	GTypeClass parent_class;
	void (*finalize) (Password *self);
};

struct _PasswordPrivate {
	const gchar* _password;
};

struct _ParamSpecPassword {
	GParamSpec parent_instance;
};

struct _PasswordHashTable {
	GObject parent_instance;
	PasswordHashTablePrivate * priv;
};

struct _PasswordHashTableClass {
	GObjectClass parent_class;
};

struct _PasswordHashTablePrivate {
	GHashTable* password_table;
};

typedef enum  {
	IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE,
	IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING
} IIdentityCardStoreStoreType;

struct _IIdentityCardStoreIface {
	GTypeInterface parent_iface;
	void (*add_card) (IIdentityCardStore* self, IdCard* card);
	gboolean (*remove_card) (IIdentityCardStore* self, IdCard* card);
	IdCard* (*update_card) (IIdentityCardStore* self, IdCard* card);
	IIdentityCardStoreStoreType (*get_store_type) (IIdentityCardStore* self);
	GeeLinkedList* (*get_card_list) (IIdentityCardStore* self);
};

struct _IdentityManagerModel {
	GObject parent_instance;
	IdentityManagerModelPrivate * priv;
};

struct _IdentityManagerModelClass {
	GObjectClass parent_class;
};

struct _IdentityManagerModelPrivate {
	PasswordHashTable* password_table;
	IIdentityCardStore* store;
	IdentityManagerApp* parent;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};


static gpointer password_parent_class = NULL;
static gpointer password_hash_table_parent_class = NULL;
static gpointer identity_manager_model_parent_class = NULL;

gpointer password_ref (gpointer instance);
void password_unref (gpointer instance);
GParamSpec* param_spec_password (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_password (GValue* value, gpointer v_object);
void value_take_password (GValue* value, gpointer v_object);
gpointer value_get_password (const GValue* value);
GType password_get_type (void) G_GNUC_CONST;
#define PASSWORD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PASSWORD, PasswordPrivate))
enum  {
	PASSWORD_DUMMY_PROPERTY
};
void password_set_password (Password* self, const gchar* value);
Password* password_new (const gchar* in_password);
Password* password_construct (GType object_type, const gchar* in_password);
const gchar* password_get_password (Password* self);
static void password_finalize (Password* obj);
GType password_hash_table_get_type (void) G_GNUC_CONST;
#define PASSWORD_HASH_TABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PASSWORD_HASH_TABLE, PasswordHashTablePrivate))
enum  {
	PASSWORD_HASH_TABLE_DUMMY_PROPERTY
};
GType id_card_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_store_type_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_get_type (void) G_GNUC_CONST;
static gchar* password_hash_table_ComputeHashKey (IdCard* card, IIdentityCardStore* store);
const gchar* id_card_get_display_name (IdCard* self);
IIdentityCardStoreStoreType iidentity_card_store_get_store_type (IIdentityCardStore* self);
void password_hash_table_CachePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store);
const gchar* id_card_get_password (IdCard* self);
void password_hash_table_RemovePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store);
void password_hash_table_RetrievePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store);
void id_card_set_password (IdCard* self, const gchar* value);
PasswordHashTable* password_hash_table_new (void);
PasswordHashTable* password_hash_table_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _password_unref0_ (gpointer var);
static void password_hash_table_finalize (GObject* obj);
GType identity_manager_model_get_type (void) G_GNUC_CONST;
gpointer identity_manager_app_ref (gpointer instance);
void identity_manager_app_unref (gpointer instance);
GParamSpec* param_spec_identity_manager_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_identity_manager_app (GValue* value, gpointer v_object);
void value_take_identity_manager_app (GValue* value, gpointer v_object);
gpointer value_get_identity_manager_app (const GValue* value);
GType identity_manager_app_get_type (void) G_GNUC_CONST;
#define IDENTITY_MANAGER_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelPrivate))
enum  {
	IDENTITY_MANAGER_MODEL_DUMMY_PROPERTY
};
#define IDENTITY_MANAGER_MODEL_FILE_NAME "identities.txt"
GeeLinkedList* identity_manager_model_get_card_list (IdentityManagerModel* self);
GeeLinkedList* iidentity_card_store_get_card_list (IIdentityCardStore* self);
static gint __lambda3_ (gconstpointer a, gconstpointer b);
gboolean id_card_IsNoIdentity (IdCard* self);
static gint ___lambda3__gcompare_func (gconstpointer a, gconstpointer b);
IdCard* id_card_NewNoIdentity (void);
gboolean id_card_get_store_password (IdCard* self);
gboolean identity_manager_model_display_name_is_valid (IdentityManagerModel* self, const gchar* name, gchar** candidate);
static gboolean identity_manager_model_remove_duplicates (IdentityManagerModel* self, IdCard* card);
const gchar* id_card_get_nai (IdCard* self);
static gboolean identity_manager_model_remove_card_internal (IdentityManagerModel* self, IdCard* card);
IdCard* identity_manager_model_find_id_card (IdentityManagerModel* self, const gchar* nai, gboolean force_flat_file_store);
IIdentityCardStoreStoreType identity_manager_model_get_store_type (IdentityManagerModel* self);
void identity_manager_model_set_store_type (IdentityManagerModel* self, IIdentityCardStoreStoreType type);
void identity_manager_model_add_card (IdentityManagerModel* self, IdCard* card, gboolean force_flat_file_store);
gboolean id_card_get_temporary (IdCard* self);
void id_card_set_display_name (IdCard* self, const gchar* value);
void iidentity_card_store_add_card (IIdentityCardStore* self, IdCard* card);
IdCard* identity_manager_model_update_card (IdentityManagerModel* self, IdCard* card);
IdCard* iidentity_card_store_update_card (IIdentityCardStore* self, IdCard* card);
gboolean iidentity_card_store_remove_card (IIdentityCardStore* self, IdCard* card);
gboolean identity_manager_model_remove_card (IdentityManagerModel* self, IdCard* card);
KeyringStore* keyring_store_new (void);
KeyringStore* keyring_store_construct (GType object_type);
GType keyring_store_get_type (void) G_GNUC_CONST;
LocalFlatFileStore* local_flat_file_store_new (void);
LocalFlatFileStore* local_flat_file_store_construct (GType object_type);
GType local_flat_file_store_get_type (void) G_GNUC_CONST;
gboolean identity_manager_model_HasNonTrivialIdentities (IdentityManagerModel* self);
gchar** id_card_get_services (IdCard* self, int* result_length1);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
IdentityManagerModel* identity_manager_model_new (IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type);
IdentityManagerModel* identity_manager_model_construct (GType object_type, IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type);
static void identity_manager_model_finalize (GObject* obj);


Password* password_construct (GType object_type, const gchar* in_password) {
	Password* self = NULL;
	const gchar* _tmp0_ = NULL;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (in_password != NULL, NULL);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = (Password*) g_type_create_instance (object_type);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = in_password;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password_set_password (self, _tmp0_);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return self;
#line 313 "moonshot-identities-manager.c"
}


Password* password_new (const gchar* in_password) {
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return password_construct (TYPE_PASSWORD, in_password);
#line 320 "moonshot-identities-manager.c"
}


const gchar* password_get_password (Password* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 38 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->_password;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = _tmp0_;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 335 "moonshot-identities-manager.c"
}


void password_set_password (Password* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->_password;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp0_ != NULL) {
#line 348 "moonshot-identities-manager.c"
		const gchar* _tmp1_ = NULL;
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp1_ = self->priv->_password;
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		gnome_keyring_memory_free ((void*) _tmp1_);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		self->priv->_password = NULL;
#line 356 "moonshot-identities-manager.c"
	}
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = value;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp2_ != NULL) {
#line 362 "moonshot-identities-manager.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = value;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = gnome_keyring_memory_strdup (_tmp3_);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		self->priv->_password = _tmp4_;
#line 371 "moonshot-identities-manager.c"
	}
}


static void value_password_init (GValue* value) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	value->data[0].v_pointer = NULL;
#line 379 "moonshot-identities-manager.c"
}


static void value_password_free_value (GValue* value) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (value->data[0].v_pointer) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_unref (value->data[0].v_pointer);
#line 388 "moonshot-identities-manager.c"
	}
}


static void value_password_copy_value (const GValue* src_value, GValue* dest_value) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (src_value->data[0].v_pointer) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		dest_value->data[0].v_pointer = password_ref (src_value->data[0].v_pointer);
#line 398 "moonshot-identities-manager.c"
	} else {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		dest_value->data[0].v_pointer = NULL;
#line 402 "moonshot-identities-manager.c"
	}
}


static gpointer value_password_peek_pointer (const GValue* value) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return value->data[0].v_pointer;
#line 410 "moonshot-identities-manager.c"
}


static gchar* value_password_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (collect_values[0].v_pointer) {
#line 417 "moonshot-identities-manager.c"
		Password* object;
		object = collect_values[0].v_pointer;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		if (object->parent_instance.g_class == NULL) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 424 "moonshot-identities-manager.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 428 "moonshot-identities-manager.c"
		}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = password_ref (object);
#line 432 "moonshot-identities-manager.c"
	} else {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = NULL;
#line 436 "moonshot-identities-manager.c"
	}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return NULL;
#line 440 "moonshot-identities-manager.c"
}


static gchar* value_password_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Password** object_p;
	object_p = collect_values[0].v_pointer;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (!object_p) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 451 "moonshot-identities-manager.c"
	}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (!value->data[0].v_pointer) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		*object_p = NULL;
#line 457 "moonshot-identities-manager.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		*object_p = value->data[0].v_pointer;
#line 461 "moonshot-identities-manager.c"
	} else {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		*object_p = password_ref (value->data[0].v_pointer);
#line 465 "moonshot-identities-manager.c"
	}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return NULL;
#line 469 "moonshot-identities-manager.c"
}


GParamSpec* param_spec_password (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPassword* spec;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PASSWORD), NULL);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return G_PARAM_SPEC (spec);
#line 483 "moonshot-identities-manager.c"
}


gpointer value_get_password (const GValue* value) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PASSWORD), NULL);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return value->data[0].v_pointer;
#line 492 "moonshot-identities-manager.c"
}


void value_set_password (GValue* value, gpointer v_object) {
	Password* old;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PASSWORD));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	old = value->data[0].v_pointer;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (v_object) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PASSWORD));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = v_object;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_ref (value->data[0].v_pointer);
#line 512 "moonshot-identities-manager.c"
	} else {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = NULL;
#line 516 "moonshot-identities-manager.c"
	}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (old) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_unref (old);
#line 522 "moonshot-identities-manager.c"
	}
}


void value_take_password (GValue* value, gpointer v_object) {
	Password* old;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PASSWORD));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	old = value->data[0].v_pointer;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (v_object) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PASSWORD));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = v_object;
#line 541 "moonshot-identities-manager.c"
	} else {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		value->data[0].v_pointer = NULL;
#line 545 "moonshot-identities-manager.c"
	}
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (old) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_unref (old);
#line 551 "moonshot-identities-manager.c"
	}
}


static void password_class_init (PasswordClass * klass) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	PASSWORD_CLASS (klass)->finalize = password_finalize;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_type_class_add_private (klass, sizeof (PasswordPrivate));
#line 563 "moonshot-identities-manager.c"
}


static void password_instance_init (Password * self) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv = PASSWORD_GET_PRIVATE (self);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->ref_count = 1;
#line 572 "moonshot-identities-manager.c"
}


static void password_finalize (Password* obj) {
	Password * self;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PASSWORD, Password);
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password_set_password (self, NULL);
#line 582 "moonshot-identities-manager.c"
}


GType password_get_type (void) {
	static volatile gsize password_type_id__volatile = 0;
	if (g_once_init_enter (&password_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_password_init, value_password_free_value, value_password_copy_value, value_password_peek_pointer, "p", value_password_collect_value, "p", value_password_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PasswordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) password_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Password), 0, (GInstanceInitFunc) password_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType password_type_id;
		password_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Password", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&password_type_id__volatile, password_type_id);
	}
	return password_type_id__volatile;
}


gpointer password_ref (gpointer instance) {
	Password* self;
	self = instance;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_atomic_int_inc (&self->ref_count);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return instance;
#line 607 "moonshot-identities-manager.c"
}


void password_unref (gpointer instance) {
	Password* self;
	self = instance;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		PASSWORD_GET_CLASS (self)->finalize (self);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 620 "moonshot-identities-manager.c"
	}
}


static gchar* password_hash_table_ComputeHashKey (IdCard* card, IIdentityCardStore* store) {
	gchar* result = NULL;
	IdCard* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	IIdentityCardStore* _tmp3_ = NULL;
	IIdentityCardStoreStoreType _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
#line 66 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (card != NULL, NULL);
#line 66 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (store != NULL, NULL);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = card;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = id_card_get_display_name (_tmp0_);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = _tmp1_;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = store;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = iidentity_card_store_get_store_type (_tmp3_);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = g_strdup_printf ("%s_store_%d", _tmp2_, (gint) _tmp4_);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = _tmp5_;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 653 "moonshot-identities-manager.c"
}


void password_hash_table_CachePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store) {
	GHashTable* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IIdentityCardStore* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	IdCard* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	Password* _tmp7_ = NULL;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (card != NULL);
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (store != NULL);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->password_table;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = card;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = store;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = password_hash_table_ComputeHashKey (_tmp1_, _tmp2_);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = card;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = id_card_get_password (_tmp4_);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = _tmp5_;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp7_ = password_new (_tmp6_);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_hash_table_replace (_tmp0_, _tmp3_, _tmp7_);
#line 690 "moonshot-identities-manager.c"
}


void password_hash_table_RemovePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store) {
	GHashTable* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IIdentityCardStore* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (card != NULL);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (store != NULL);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->password_table;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = card;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = store;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = password_hash_table_ComputeHashKey (_tmp1_, _tmp2_);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = _tmp3_;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_hash_table_remove (_tmp0_, _tmp4_);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (_tmp4_);
#line 720 "moonshot-identities-manager.c"
}


void password_hash_table_RetrievePassword (PasswordHashTable* self, IdCard* card, IIdentityCardStore* store) {
	Password* password = NULL;
	GHashTable* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IIdentityCardStore* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	Password* _tmp6_ = NULL;
	Password* _tmp7_ = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (card != NULL);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (store != NULL);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->password_table;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = card;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = store;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = password_hash_table_ComputeHashKey (_tmp1_, _tmp2_);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = _tmp3_;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = g_hash_table_lookup (_tmp0_, _tmp4_);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = (Password*) _tmp5_;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (_tmp4_);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password = _tmp6_;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp7_ = password;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp7_ != NULL) {
#line 762 "moonshot-identities-manager.c"
		IdCard* _tmp8_ = NULL;
		Password* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp8_ = card;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp9_ = password;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp10_ = password_get_password (_tmp9_);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp11_ = _tmp10_;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		id_card_set_password (_tmp8_, _tmp11_);
#line 777 "moonshot-identities-manager.c"
	}
}


static void _g_free0_ (gpointer var) {
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	var = (g_free (var), NULL);
#line 785 "moonshot-identities-manager.c"
}


static void _password_unref0_ (gpointer var) {
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	(var == NULL) ? NULL : (var = (password_unref (var), NULL));
#line 792 "moonshot-identities-manager.c"
}


PasswordHashTable* password_hash_table_construct (GType object_type) {
	PasswordHashTable * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = (PasswordHashTable*) g_object_new (object_type, NULL);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = g_str_hash;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = g_str_equal;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _password_unref0_);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_hash_table_unref0 (self->priv->password_table);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv->password_table = _tmp2_;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return self;
#line 815 "moonshot-identities-manager.c"
}


PasswordHashTable* password_hash_table_new (void) {
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return password_hash_table_construct (TYPE_PASSWORD_HASH_TABLE);
#line 822 "moonshot-identities-manager.c"
}


static void password_hash_table_class_init (PasswordHashTableClass * klass) {
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password_hash_table_parent_class = g_type_class_peek_parent (klass);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_type_class_add_private (klass, sizeof (PasswordHashTablePrivate));
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	G_OBJECT_CLASS (klass)->finalize = password_hash_table_finalize;
#line 833 "moonshot-identities-manager.c"
}


static void password_hash_table_instance_init (PasswordHashTable * self) {
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv = PASSWORD_HASH_TABLE_GET_PRIVATE (self);
#line 840 "moonshot-identities-manager.c"
}


static void password_hash_table_finalize (GObject* obj) {
	PasswordHashTable * self;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PASSWORD_HASH_TABLE, PasswordHashTable);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_hash_table_unref0 (self->priv->password_table);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	G_OBJECT_CLASS (password_hash_table_parent_class)->finalize (obj);
#line 852 "moonshot-identities-manager.c"
}


GType password_hash_table_get_type (void) {
	static volatile gsize password_hash_table_type_id__volatile = 0;
	if (g_once_init_enter (&password_hash_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasswordHashTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) password_hash_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasswordHashTable), 0, (GInstanceInitFunc) password_hash_table_instance_init, NULL };
		GType password_hash_table_type_id;
		password_hash_table_type_id = g_type_register_static (G_TYPE_OBJECT, "PasswordHashTable", &g_define_type_info, 0);
		g_once_init_leave (&password_hash_table_type_id__volatile, password_hash_table_type_id);
	}
	return password_hash_table_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return self ? g_object_ref (self) : NULL;
#line 871 "moonshot-identities-manager.c"
}


static gint __lambda3_ (gconstpointer a, gconstpointer b) {
	gint result = 0;
	IdCard* id_a = NULL;
	gconstpointer _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IdCard* id_b = NULL;
	gconstpointer _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	IdCard* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GCompareFunc _tmp14_ = NULL;
	IdCard* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	IdCard* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = a;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ID_CARD, IdCard));
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	id_a = _tmp1_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = b;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_ID_CARD, IdCard));
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	id_b = _tmp3_;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = id_a;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = id_card_IsNoIdentity (_tmp5_);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp6_) {
#line 912 "moonshot-identities-manager.c"
		IdCard* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp7_ = id_b;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp8_ = id_card_IsNoIdentity (_tmp7_);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = !_tmp8_;
#line 921 "moonshot-identities-manager.c"
	} else {
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = FALSE;
#line 925 "moonshot-identities-manager.c"
	}
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp4_) {
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		result = -1;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (id_b);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (id_a);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return result;
#line 937 "moonshot-identities-manager.c"
	} else {
		gboolean _tmp9_ = FALSE;
		IdCard* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp10_ = id_b;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp11_ = id_card_IsNoIdentity (_tmp10_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		if (_tmp11_) {
#line 948 "moonshot-identities-manager.c"
			IdCard* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp12_ = id_a;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp13_ = id_card_IsNoIdentity (_tmp12_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = !_tmp13_;
#line 957 "moonshot-identities-manager.c"
		} else {
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = FALSE;
#line 961 "moonshot-identities-manager.c"
		}
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		if (_tmp9_) {
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			result = 1;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id_b);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id_a);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			return result;
#line 973 "moonshot-identities-manager.c"
		}
	}
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp14_ = g_strcmp0;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp15_ = id_a;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp16_ = id_card_get_display_name (_tmp15_);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp17_ = _tmp16_;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp18_ = id_b;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp19_ = id_card_get_display_name (_tmp18_);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp20_ = _tmp19_;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp21_ = _tmp14_ (_tmp17_, _tmp20_);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = _tmp21_;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (id_b);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (id_a);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1000 "moonshot-identities-manager.c"
}


static gint ___lambda3__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda3_ (a, b);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1009 "moonshot-identities-manager.c"
}


GeeLinkedList* identity_manager_model_get_card_list (IdentityManagerModel* self) {
	GeeLinkedList* result = NULL;
	GeeLinkedList* identities = NULL;
	IIdentityCardStore* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeLinkedList* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->store;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = iidentity_card_store_get_card_list (_tmp0_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identities = _tmp1_;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = identities;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	gee_list_sort ((GeeList*) _tmp2_, ___lambda3__gcompare_func);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = identities;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) _tmp4_);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = _tmp5_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp6_) {
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = TRUE;
#line 1045 "moonshot-identities-manager.c"
	} else {
		GeeLinkedList* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		IdCard* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp7_ = identities;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, 0);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp9_ = (IdCard*) _tmp8_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp10_ = id_card_IsNoIdentity (_tmp9_);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = !_tmp10_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_tmp9_);
#line 1063 "moonshot-identities-manager.c"
	}
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp3_) {
#line 1067 "moonshot-identities-manager.c"
		GeeLinkedList* _tmp11_ = NULL;
		IdCard* _tmp12_ = NULL;
		IdCard* _tmp13_ = NULL;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp11_ = identities;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp12_ = id_card_NewNoIdentity ();
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp13_ = _tmp12_;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		gee_abstract_list_insert ((GeeAbstractList*) _tmp11_, 0, _tmp13_);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_tmp13_);
#line 1081 "moonshot-identities-manager.c"
	}
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp14_ = NULL;
		GeeLinkedList* _tmp15_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _id_card_index = 0;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp14_ = identities;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_list = _tmp15_;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp16_ = _id_card_list;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp17_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp16_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp18_ = _tmp17_;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_size = _tmp18_;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_index = -1;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 1110 "moonshot-identities-manager.c"
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gpointer _tmp24_ = NULL;
			IdCard* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp19_ = _id_card_index;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_id_card_index = _tmp19_ + 1;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp20_ = _id_card_index;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp21_ = _id_card_size;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp20_ < _tmp21_)) {
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 1133 "moonshot-identities-manager.c"
			}
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp22_ = _id_card_list;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp23_ = _id_card_index;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _tmp23_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			id_card = (IdCard*) _tmp24_;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp25_ = id_card;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp26_ = id_card_get_store_password (_tmp25_);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp27_ = _tmp26_;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!_tmp27_) {
#line 1151 "moonshot-identities-manager.c"
				PasswordHashTable* _tmp28_ = NULL;
				IdCard* _tmp29_ = NULL;
				IIdentityCardStore* _tmp30_ = NULL;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp28_ = self->priv->password_table;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp29_ = id_card;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp30_ = self->priv->store;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				password_hash_table_RetrievePassword (_tmp28_, _tmp29_, _tmp30_);
#line 1163 "moonshot-identities-manager.c"
			}
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id_card);
#line 1167 "moonshot-identities-manager.c"
		}
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_id_card_list);
#line 1171 "moonshot-identities-manager.c"
	}
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = identities;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1177 "moonshot-identities-manager.c"
}


gboolean identity_manager_model_display_name_is_valid (IdentityManagerModel* self, const gchar* name, gchar** candidate) {
	gchar* _vala_candidate = NULL;
	gboolean result = FALSE;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if ((&_vala_candidate) != NULL) {
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_free0 (_vala_candidate);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_vala_candidate = NULL;
#line 1194 "moonshot-identities-manager.c"
	}
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _id_card_index = 0;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp0_ = identity_manager_model_get_card_list (self);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_list = _tmp0_;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp1_ = _id_card_list;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = _tmp2_;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_size = _tmp3_;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_card_index = -1;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 1220 "moonshot-identities-manager.c"
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gpointer _tmp9_ = NULL;
			IdCard* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp4_ = _id_card_index;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_id_card_index = _tmp4_ + 1;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp5_ = _id_card_index;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp6_ = _id_card_size;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp5_ < _tmp6_)) {
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 1244 "moonshot-identities-manager.c"
			}
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp7_ = _id_card_list;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp8_ = _id_card_index;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			id_card = (IdCard*) _tmp9_;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp10_ = id_card;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp11_ = id_card_get_display_name (_tmp10_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp12_ = _tmp11_;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp13_ = name;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				if ((&_vala_candidate) != NULL) {
#line 1266 "moonshot-identities-manager.c"
					{
						gint i = 0;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						i = 0;
#line 1271 "moonshot-identities-manager.c"
						{
							gboolean _tmp14_ = FALSE;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
							_tmp14_ = TRUE;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
							while (TRUE) {
#line 1278 "moonshot-identities-manager.c"
								gint _tmp16_ = 0;
								gchar* tmp = NULL;
								const gchar* _tmp17_ = NULL;
								gint _tmp18_ = 0;
								gchar* _tmp19_ = NULL;
								const gchar* _tmp20_ = NULL;
								gboolean _tmp21_ = FALSE;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								if (!_tmp14_) {
#line 1288 "moonshot-identities-manager.c"
									gint _tmp15_ = 0;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_tmp15_ = i;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									i = _tmp15_ + 1;
#line 1294 "moonshot-identities-manager.c"
								}
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp14_ = FALSE;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp16_ = i;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								if (!(_tmp16_ < 1000)) {
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									break;
#line 1304 "moonshot-identities-manager.c"
								}
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp17_ = name;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp18_ = i;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp19_ = g_strdup_printf ("%s %d", _tmp17_, _tmp18_);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								tmp = _tmp19_;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp20_ = tmp;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_tmp21_ = identity_manager_model_display_name_is_valid (self, _tmp20_, NULL);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								if (_tmp21_) {
#line 1320 "moonshot-identities-manager.c"
									const gchar* _tmp22_ = NULL;
									gchar* _tmp23_ = NULL;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_tmp22_ = tmp;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_tmp23_ = g_strdup (_tmp22_);
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_g_free0 (_vala_candidate);
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_vala_candidate = _tmp23_;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									_g_free0 (tmp);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
									break;
#line 1335 "moonshot-identities-manager.c"
								}
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
								_g_free0 (tmp);
#line 1339 "moonshot-identities-manager.c"
							}
						}
					}
				}
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				result = FALSE;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (id_card);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (_id_card_list);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				if (candidate) {
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					*candidate = _vala_candidate;
#line 1354 "moonshot-identities-manager.c"
				} else {
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_g_free0 (_vala_candidate);
#line 1358 "moonshot-identities-manager.c"
				}
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				return result;
#line 1362 "moonshot-identities-manager.c"
			}
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id_card);
#line 1366 "moonshot-identities-manager.c"
		}
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_id_card_list);
#line 1370 "moonshot-identities-manager.c"
	}
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = TRUE;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (candidate) {
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		*candidate = _vala_candidate;
#line 1378 "moonshot-identities-manager.c"
	} else {
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_free0 (_vala_candidate);
#line 1382 "moonshot-identities-manager.c"
	}
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1386 "moonshot-identities-manager.c"
}


static gboolean identity_manager_model_remove_duplicates (IdentityManagerModel* self, IdCard* card) {
	gboolean result = FALSE;
	gboolean duplicate_found = FALSE;
	gboolean found = FALSE;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (card != NULL, FALSE);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	duplicate_found = FALSE;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	found = FALSE;
#line 1402 "moonshot-identities-manager.c"
	{
		gboolean _tmp0_ = FALSE;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp0_ = TRUE;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 1409 "moonshot-identities-manager.c"
			GeeLinkedList* cards = NULL;
			GeeLinkedList* _tmp2_ = NULL;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!_tmp0_) {
#line 1414 "moonshot-identities-manager.c"
				gboolean _tmp1_ = FALSE;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp1_ = found;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				if (!_tmp1_) {
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					break;
#line 1422 "moonshot-identities-manager.c"
				}
			}
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp0_ = FALSE;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp2_ = identity_manager_model_get_card_list (self);
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			cards = _tmp2_;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			found = FALSE;
#line 1433 "moonshot-identities-manager.c"
			{
				GeeLinkedList* _id_card_list = NULL;
				GeeLinkedList* _tmp3_ = NULL;
				GeeLinkedList* _tmp4_ = NULL;
				gint _id_card_size = 0;
				GeeLinkedList* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _id_card_index = 0;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp3_ = cards;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp4_ = _g_object_ref0 (_tmp3_);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_id_card_list = _tmp4_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp5_ = _id_card_list;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp7_ = _tmp6_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_id_card_size = _tmp7_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_id_card_index = -1;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				while (TRUE) {
#line 1461 "moonshot-identities-manager.c"
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					IdCard* id_card = NULL;
					GeeLinkedList* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gpointer _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					IdCard* _tmp15_ = NULL;
					IdCard* _tmp16_ = NULL;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_tmp8_ = _id_card_index;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_id_card_index = _tmp8_ + 1;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_tmp9_ = _id_card_index;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_tmp10_ = _id_card_size;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					if (!(_tmp9_ < _tmp10_)) {
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						break;
#line 1484 "moonshot-identities-manager.c"
					}
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_tmp11_ = _id_card_list;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_tmp12_ = _id_card_index;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					id_card = (IdCard*) _tmp13_;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_tmp15_ = card;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_tmp16_ = id_card;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					if (_tmp15_ != _tmp16_) {
#line 1500 "moonshot-identities-manager.c"
						IdCard* _tmp17_ = NULL;
						const gchar* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
						IdCard* _tmp20_ = NULL;
						const gchar* _tmp21_ = NULL;
						const gchar* _tmp22_ = NULL;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp17_ = id_card;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp18_ = id_card_get_nai (_tmp17_);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp19_ = _tmp18_;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp20_ = card;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp21_ = id_card_get_nai (_tmp20_);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp22_ = _tmp21_;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp14_ = g_strcmp0 (_tmp19_, _tmp22_) == 0;
#line 1521 "moonshot-identities-manager.c"
					} else {
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp14_ = FALSE;
#line 1525 "moonshot-identities-manager.c"
					}
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					if (_tmp14_) {
#line 1529 "moonshot-identities-manager.c"
						FILE* _tmp23_ = NULL;
						IdCard* _tmp24_ = NULL;
						const gchar* _tmp25_ = NULL;
						const gchar* _tmp26_ = NULL;
						IdCard* _tmp27_ = NULL;
						gboolean _tmp28_ = FALSE;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp23_ = stdout;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp24_ = card;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp25_ = id_card_get_nai (_tmp24_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp26_ = _tmp25_;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						fprintf (_tmp23_, "removing duplicate id for '%s'\n", _tmp26_);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp27_ = id_card;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						identity_manager_model_remove_card_internal (self, _tmp27_);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						duplicate_found = TRUE;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_tmp28_ = duplicate_found;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						found = _tmp28_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						_g_object_unref0 (id_card);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
						break;
#line 1560 "moonshot-identities-manager.c"
					}
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
					_g_object_unref0 (id_card);
#line 1564 "moonshot-identities-manager.c"
				}
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (_id_card_list);
#line 1568 "moonshot-identities-manager.c"
			}
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (cards);
#line 1572 "moonshot-identities-manager.c"
		}
	}
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = duplicate_found;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1579 "moonshot-identities-manager.c"
}


IdCard* identity_manager_model_find_id_card (IdentityManagerModel* self, const gchar* nai, gboolean force_flat_file_store) {
	IdCard* result = NULL;
	IdCard* retval = NULL;
	IIdentityCardStoreStoreType saved_store_type = 0;
	IIdentityCardStoreStoreType _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	IIdentityCardStoreStoreType _tmp18_ = 0;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (nai != NULL, NULL);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	retval = NULL;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = identity_manager_model_get_store_type (self);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	saved_store_type = _tmp0_;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = force_flat_file_store;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp1_) {
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		identity_manager_model_set_store_type (self, IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE);
#line 1608 "moonshot-identities-manager.c"
	}
	{
		GeeLinkedList* _id_list = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _id_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _id_index = 0;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp2_ = identity_manager_model_get_card_list (self);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_list = _tmp2_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = _id_list;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp5_ = _tmp4_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_size = _tmp5_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_id_index = -1;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 1634 "moonshot-identities-manager.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			IdCard* id = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			IdCard* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp6_ = _id_index;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_id_index = _tmp6_ + 1;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp7_ = _id_index;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp8_ = _id_size;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 1658 "moonshot-identities-manager.c"
			}
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = _id_list;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp10_ = _id_index;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			id = (IdCard*) _tmp11_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp12_ = id;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp13_ = id_card_get_nai (_tmp12_);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp14_ = _tmp13_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp15_ = nai;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
#line 1678 "moonshot-identities-manager.c"
				IdCard* _tmp16_ = NULL;
				IdCard* _tmp17_ = NULL;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp16_ = id;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp17_ = _g_object_ref0 (_tmp16_);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (retval);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				retval = _tmp17_;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (id);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 1693 "moonshot-identities-manager.c"
			}
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (id);
#line 1697 "moonshot-identities-manager.c"
		}
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_id_list);
#line 1701 "moonshot-identities-manager.c"
	}
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp18_ = saved_store_type;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identity_manager_model_set_store_type (self, _tmp18_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp20_ = force_flat_file_store;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp20_) {
#line 1711 "moonshot-identities-manager.c"
		IIdentityCardStoreStoreType _tmp21_ = 0;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp21_ = saved_store_type;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp19_ = _tmp21_ != IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE;
#line 1717 "moonshot-identities-manager.c"
	} else {
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp19_ = FALSE;
#line 1721 "moonshot-identities-manager.c"
	}
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp19_) {
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_signal_emit_by_name (self, "card-list-changed");
#line 1727 "moonshot-identities-manager.c"
	}
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = retval;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1733 "moonshot-identities-manager.c"
}


void identity_manager_model_add_card (IdentityManagerModel* self, IdCard* card, gboolean force_flat_file_store) {
	IdCard* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* candidate = NULL;
	IIdentityCardStoreStoreType saved_store_type = 0;
	IIdentityCardStoreStoreType _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	IdCard* _tmp5_ = NULL;
	IdCard* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	IdCard* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	IIdentityCardStore* _tmp19_ = NULL;
	IdCard* _tmp20_ = NULL;
	IIdentityCardStoreStoreType _tmp21_ = 0;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (card != NULL);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = card;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = id_card_get_temporary (_tmp0_);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = _tmp1_;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp2_) {
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return;
#line 1771 "moonshot-identities-manager.c"
	}
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = identity_manager_model_get_store_type (self);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	saved_store_type = _tmp3_;
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = force_flat_file_store;
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp4_) {
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		identity_manager_model_set_store_type (self, IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE);
#line 1783 "moonshot-identities-manager.c"
	}
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = card;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identity_manager_model_remove_duplicates (self, _tmp5_);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = card;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp7_ = id_card_get_display_name (_tmp6_);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp8_ = _tmp7_;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp10_ = identity_manager_model_display_name_is_valid (self, _tmp8_, &_tmp9_);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (candidate);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	candidate = _tmp9_;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (!_tmp10_) {
#line 1803 "moonshot-identities-manager.c"
		IdCard* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp11_ = card;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp12_ = candidate;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		id_card_set_display_name (_tmp11_, _tmp12_);
#line 1812 "moonshot-identities-manager.c"
	}
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp13_ = card;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp14_ = id_card_get_store_password (_tmp13_);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp15_ = _tmp14_;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (!_tmp15_) {
#line 1822 "moonshot-identities-manager.c"
		PasswordHashTable* _tmp16_ = NULL;
		IdCard* _tmp17_ = NULL;
		IIdentityCardStore* _tmp18_ = NULL;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp16_ = self->priv->password_table;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp17_ = card;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp18_ = self->priv->store;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_hash_table_CachePassword (_tmp16_, _tmp17_, _tmp18_);
#line 1834 "moonshot-identities-manager.c"
	}
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp19_ = self->priv->store;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp20_ = card;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	iidentity_card_store_add_card (_tmp19_, _tmp20_);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp21_ = saved_store_type;
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identity_manager_model_set_store_type (self, _tmp21_);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_signal_emit_by_name (self, "card-list-changed");
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_free0 (candidate);
#line 1850 "moonshot-identities-manager.c"
}


IdCard* identity_manager_model_update_card (IdentityManagerModel* self, IdCard* card) {
	IdCard* result = NULL;
	IdCard* retval = NULL;
	IdCard* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	IdCard* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	IIdentityCardStore* _tmp14_ = NULL;
	IdCard* _tmp15_ = NULL;
	IdCard* _tmp16_ = NULL;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (card != NULL, NULL);
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = card;
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = id_card_get_temporary (_tmp0_);
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = _tmp1_;
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp2_) {
#line 1878 "moonshot-identities-manager.c"
		IdCard* _tmp3_ = NULL;
		IdCard* _tmp4_ = NULL;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = card;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (retval);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		retval = _tmp4_;
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		result = retval;
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return result;
#line 1893 "moonshot-identities-manager.c"
	}
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = card;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = id_card_get_store_password (_tmp5_);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp7_ = _tmp6_;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (!_tmp7_) {
#line 1903 "moonshot-identities-manager.c"
		PasswordHashTable* _tmp8_ = NULL;
		IdCard* _tmp9_ = NULL;
		IIdentityCardStore* _tmp10_ = NULL;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp8_ = self->priv->password_table;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp9_ = card;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp10_ = self->priv->store;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_hash_table_CachePassword (_tmp8_, _tmp9_, _tmp10_);
#line 1915 "moonshot-identities-manager.c"
	} else {
		PasswordHashTable* _tmp11_ = NULL;
		IdCard* _tmp12_ = NULL;
		IIdentityCardStore* _tmp13_ = NULL;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp11_ = self->priv->password_table;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp12_ = card;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp13_ = self->priv->store;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		password_hash_table_RemovePassword (_tmp11_, _tmp12_, _tmp13_);
#line 1928 "moonshot-identities-manager.c"
	}
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp14_ = self->priv->store;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp15_ = card;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp16_ = iidentity_card_store_update_card (_tmp14_, _tmp15_);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (retval);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	retval = _tmp16_;
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_signal_emit_by_name (self, "card-list-changed");
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = retval;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1946 "moonshot-identities-manager.c"
}


static gboolean identity_manager_model_remove_card_internal (IdentityManagerModel* self, IdCard* card) {
	gboolean result = FALSE;
	IdCard* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	PasswordHashTable* _tmp3_ = NULL;
	IdCard* _tmp4_ = NULL;
	IIdentityCardStore* _tmp5_ = NULL;
	IIdentityCardStore* _tmp6_ = NULL;
	IdCard* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (card != NULL, FALSE);
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = card;
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = id_card_get_temporary (_tmp0_);
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = _tmp1_;
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp2_) {
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		result = FALSE;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return result;
#line 1977 "moonshot-identities-manager.c"
	}
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = self->priv->password_table;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp4_ = card;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = self->priv->store;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	password_hash_table_RemovePassword (_tmp3_, _tmp4_, _tmp5_);
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp6_ = self->priv->store;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp7_ = card;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp8_ = iidentity_card_store_remove_card (_tmp6_, _tmp7_);
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = _tmp8_;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 1997 "moonshot-identities-manager.c"
}


gboolean identity_manager_model_remove_card (IdentityManagerModel* self, IdCard* card) {
	gboolean result = FALSE;
	IdCard* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (card != NULL, FALSE);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = card;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = identity_manager_model_remove_card_internal (self, _tmp0_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp1_) {
#line 230 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		g_signal_emit_by_name (self, "card-list-changed");
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		result = TRUE;
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return result;
#line 2021 "moonshot-identities-manager.c"
	}
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = FALSE;
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 2027 "moonshot-identities-manager.c"
}


void identity_manager_model_set_store_type (IdentityManagerModel* self, IIdentityCardStoreStoreType type) {
	gboolean _tmp0_ = FALSE;
	IIdentityCardStore* _tmp1_ = NULL;
	IIdentityCardStoreStoreType _tmp5_ = 0;
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_if_fail (self != NULL);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = self->priv->store;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp1_ != NULL) {
#line 2041 "moonshot-identities-manager.c"
		IIdentityCardStore* _tmp2_ = NULL;
		IIdentityCardStoreStoreType _tmp3_ = 0;
		IIdentityCardStoreStoreType _tmp4_ = 0;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp2_ = self->priv->store;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = iidentity_card_store_get_store_type (_tmp2_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = type;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp0_ = _tmp3_ == _tmp4_;
#line 2053 "moonshot-identities-manager.c"
	} else {
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp0_ = FALSE;
#line 2057 "moonshot-identities-manager.c"
	}
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	if (_tmp0_) {
#line 238 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		return;
#line 2063 "moonshot-identities-manager.c"
	}
#line 239 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp5_ = type;
#line 239 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	switch (_tmp5_) {
#line 239 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		case IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING:
#line 2071 "moonshot-identities-manager.c"
		{
			KeyringStore* _tmp6_ = NULL;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp6_ = keyring_store_new ();
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (self->priv->store);
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			self->priv->store = (IIdentityCardStore*) _tmp6_;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			break;
#line 2082 "moonshot-identities-manager.c"
		}
		default:
#line 239 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		case IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE:
#line 2087 "moonshot-identities-manager.c"
		{
			LocalFlatFileStore* _tmp7_ = NULL;
#line 247 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp7_ = local_flat_file_store_new ();
#line 247 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (self->priv->store);
#line 247 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			self->priv->store = (IIdentityCardStore*) _tmp7_;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			break;
#line 2098 "moonshot-identities-manager.c"
		}
	}
}


IIdentityCardStoreStoreType identity_manager_model_get_store_type (IdentityManagerModel* self) {
	IIdentityCardStoreStoreType result = 0;
	IIdentityCardStore* _tmp0_ = NULL;
	IIdentityCardStoreStoreType _tmp1_ = 0;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = self->priv->store;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = iidentity_card_store_get_store_type (_tmp0_);
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = _tmp1_;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 2118 "moonshot-identities-manager.c"
}


gboolean identity_manager_model_HasNonTrivialIdentities (IdentityManagerModel* self) {
	gboolean result = FALSE;
#line 256 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2126 "moonshot-identities-manager.c"
	{
		GeeLinkedList* _card_list = NULL;
		IIdentityCardStore* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _card_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _card_index = 0;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp0_ = self->priv->store;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp1_ = iidentity_card_store_get_card_list (_tmp0_);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_card_list = _tmp1_;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp2_ = _card_list;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_tmp4_ = _tmp3_;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_card_size = _tmp4_;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_card_index = -1;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		while (TRUE) {
#line 2154 "moonshot-identities-manager.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			IdCard* card = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			IdCard* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp5_ = _card_index;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_card_index = _tmp5_ + 1;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp6_ = _card_index;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp7_ = _card_size;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				break;
#line 2178 "moonshot-identities-manager.c"
			}
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp8_ = _card_list;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp9_ = _card_index;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			card = (IdCard*) _tmp10_;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp13_ = card;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_tmp14_ = id_card_IsNoIdentity (_tmp13_);
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (!_tmp14_) {
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp12_ = TRUE;
#line 2196 "moonshot-identities-manager.c"
			} else {
				IdCard* _tmp15_ = NULL;
				gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gchar** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp15_ = card;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp16_ = id_card_get_services (_tmp15_, &_tmp16__length1);
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp17_ = _tmp16_;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp17__length1 = _tmp16__length1;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp12_ = _tmp17__length1 > 0;
#line 2213 "moonshot-identities-manager.c"
			}
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (_tmp12_) {
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp11_ = TRUE;
#line 2219 "moonshot-identities-manager.c"
			} else {
				IdCard* _tmp18_ = NULL;
				Rule* _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				Rule* _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp18_ = card;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp19_ = id_card_get_rules (_tmp18_, &_tmp19__length1);
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp20_ = _tmp19_;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp20__length1 = _tmp19__length1;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_tmp11_ = _tmp20__length1 > 0;
#line 2236 "moonshot-identities-manager.c"
			}
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			if (_tmp11_) {
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				result = TRUE;
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (card);
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				_g_object_unref0 (_card_list);
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
				return result;
#line 2248 "moonshot-identities-manager.c"
			}
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
			_g_object_unref0 (card);
#line 2252 "moonshot-identities-manager.c"
		}
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
		_g_object_unref0 (_card_list);
#line 2256 "moonshot-identities-manager.c"
	}
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	result = FALSE;
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return result;
#line 2262 "moonshot-identities-manager.c"
}


static gpointer _identity_manager_app_ref0 (gpointer self) {
#line 273 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return self ? identity_manager_app_ref (self) : NULL;
#line 2269 "moonshot-identities-manager.c"
}


IdentityManagerModel* identity_manager_model_construct (GType object_type, IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type) {
	IdentityManagerModel * self = NULL;
	IdentityManagerApp* _tmp0_ = NULL;
	IdentityManagerApp* _tmp1_ = NULL;
	PasswordHashTable* _tmp2_ = NULL;
	IIdentityCardStoreStoreType _tmp3_ = 0;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_return_val_if_fail (parent_app != NULL, NULL);
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = (IdentityManagerModel*) g_object_new (object_type, NULL);
#line 273 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp0_ = parent_app;
#line 273 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp1_ = _identity_manager_app_ref0 (_tmp0_);
#line 273 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_identity_manager_app_unref0 (self->priv->parent);
#line 273 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv->parent = _tmp1_;
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp2_ = password_hash_table_new ();
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (self->priv->password_table);
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv->password_table = _tmp2_;
#line 275 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_tmp3_ = store_type;
#line 275 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identity_manager_model_set_store_type (self, _tmp3_);
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return self;
#line 2303 "moonshot-identities-manager.c"
}


IdentityManagerModel* identity_manager_model_new (IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type) {
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	return identity_manager_model_construct (TYPE_IDENTITY_MANAGER_MODEL, parent_app, store_type);
#line 2310 "moonshot-identities-manager.c"
}


static void identity_manager_model_class_init (IdentityManagerModelClass * klass) {
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	identity_manager_model_parent_class = g_type_class_peek_parent (klass);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_type_class_add_private (klass, sizeof (IdentityManagerModelPrivate));
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	G_OBJECT_CLASS (klass)->finalize = identity_manager_model_finalize;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	g_signal_new ("card_list_changed", TYPE_IDENTITY_MANAGER_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2323 "moonshot-identities-manager.c"
}


static void identity_manager_model_instance_init (IdentityManagerModel * self) {
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self->priv = IDENTITY_MANAGER_MODEL_GET_PRIVATE (self);
#line 2330 "moonshot-identities-manager.c"
}


static void identity_manager_model_finalize (GObject* obj) {
	IdentityManagerModel * self;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModel);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (self->priv->password_table);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_g_object_unref0 (self->priv->store);
#line 270 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	_identity_manager_app_unref0 (self->priv->parent);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identities-manager.vala"
	G_OBJECT_CLASS (identity_manager_model_parent_class)->finalize (obj);
#line 2346 "moonshot-identities-manager.c"
}


GType identity_manager_model_get_type (void) {
	static volatile gsize identity_manager_model_type_id__volatile = 0;
	if (g_once_init_enter (&identity_manager_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IdentityManagerModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) identity_manager_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdentityManagerModel), 0, (GInstanceInitFunc) identity_manager_model_instance_init, NULL };
		GType identity_manager_model_type_id;
		identity_manager_model_type_id = g_type_register_static (G_TYPE_OBJECT, "IdentityManagerModel", &g_define_type_info, 0);
		g_once_init_leave (&identity_manager_model_type_id__volatile, identity_manager_model_type_id);
	}
	return identity_manager_model_type_id__volatile;
}



