# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class WebApplication(Object):
    r"""
    WebApplication - defines para_view_web application interface.
    
    Superclass: Object
    
    WebApplication defines the core interface for a para_view_web
    application. This exposes methods that make it easier to manage views
    and rendered images from views.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkWebApplication, obj, update, **traits)
    
    def get_has_images_being_processed(self, *args):
        """
        get_has_images_being_processed(self, __a:RenderWindow) -> bool
        C++: bool get_has_images_being_processed(RenderWindow *)
        still_render_to_string() need not necessary returns the most
        recently rendered image. Use this method to get whether there are
        any pending images being processed concurrently.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetHasImagesBeingProcessed, *my_args)
        return ret

    def _get_image_compression(self):
        return self._vtk_obj.GetImageCompression()
    image_compression = traits.Property(_get_image_compression, desc=\
        r"""
        
        """
    )

    def _get_image_compression_max_value(self):
        return self._vtk_obj.GetImageCompressionMaxValue()
    image_compression_max_value = traits.Property(_get_image_compression_max_value, desc=\
        r"""
        
        """
    )

    def _get_image_compression_min_value(self):
        return self._vtk_obj.GetImageCompressionMinValue()
    image_compression_min_value = traits.Property(_get_image_compression_min_value, desc=\
        r"""
        
        """
    )

    def _get_image_encoding(self):
        return self._vtk_obj.GetImageEncoding()
    image_encoding = traits.Property(_get_image_encoding, desc=\
        r"""
        
        """
    )

    def _get_image_encoding_max_value(self):
        return self._vtk_obj.GetImageEncodingMaxValue()
    image_encoding_max_value = traits.Property(_get_image_encoding_max_value, desc=\
        r"""
        
        """
    )

    def _get_image_encoding_min_value(self):
        return self._vtk_obj.GetImageEncodingMinValue()
    image_encoding_min_value = traits.Property(_get_image_encoding_min_value, desc=\
        r"""
        
        """
    )

    def _get_last_still_render_to_m_time(self):
        return self._vtk_obj.GetLastStillRenderToMTime()
    last_still_render_to_m_time = traits.Property(_get_last_still_render_to_m_time, desc=\
        r"""
        Return the MTime of the last array exported by
        still_render_to_string.
        """
    )

    def _get_number_of_encoder_threads(self):
        return self._vtk_obj.GetNumberOfEncoderThreads()
    number_of_encoder_threads = traits.Property(_get_number_of_encoder_threads, desc=\
        r"""
        
        """
    )

    def get_object_id(self, *args):
        """
        get_object_id(obj:Object) -> str
        C++: static std::string get_object_id(Object *obj)
        Return a hexadecimal formatted string of the VTK object's memory
        address, useful for uniquely identifying the object when
        exporting data.
        
        e.g. 0x8f05a90
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetObjectId, *my_args)
        return ret

    def _get_object_id_map(self):
        return wrap_vtk(self._vtk_obj.GetObjectIdMap())
    object_id_map = traits.Property(_get_object_id_map, desc=\
        r"""
        
        """
    )

    def get_web_gl_binary_data(self, *args):
        """
        get_web_gl_binary_data(self, view:RenderWindow, id:str,
            partIndex:int) -> str
        C++: const char *get_web_gl_binary_data(RenderWindow *view,
            const char *id, int partIndex)
        Return the binary data given the part index and the webGL object
        piece id in the scene.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetWebGLBinaryData, *my_args)
        return ret

    def get_web_gl_scene_meta_data(self, *args):
        """
        get_web_gl_scene_meta_data(self, view:RenderWindow) -> str
        C++: const char *get_web_gl_scene_meta_data(RenderWindow *view)
        Return the Meta data description of the input scene in JSON
        format. This is using the WebGLExporter to parse the scene.
        NOTE: This should be called before getting the webGL binary data.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetWebGLSceneMetaData, *my_args)
        return ret

    def handle_interaction_event(self, *args):
        """
        handle_interaction_event(self, view:RenderWindow,
            event:WebInteractionEvent) -> bool
        C++: bool handle_interaction_event(RenderWindow *view,
            WebInteractionEvent *event)
        Communicate mouse interaction to a view. Returns true if the
        interaction changed the view state, otherwise returns false.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HandleInteractionEvent, *my_args)
        return ret

    def interactive_render(self, *args):
        """
        interactive_render(self, view:RenderWindow, quality:int=50)
            -> UnsignedCharArray
        C++: UnsignedCharArray *interactive_render(
            RenderWindow *view, int quality=50)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InteractiveRender, *my_args)
        return wrap_vtk(ret)

    def invalidate_cache(self, *args):
        """
        invalidate_cache(self, view:RenderWindow) -> None
        C++: void invalidate_cache(RenderWindow *view)
        Invalidate view cache
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InvalidateCache, *my_args)
        return ret

    def set_image_compression(self, *args):
        """
        set_image_compression(self, _arg:int) -> None
        C++: virtual void set_image_compression(int _arg)"""
        ret = self._wrap_call(self._vtk_obj.SetImageCompression, *args)
        return ret

    def set_image_encoding(self, *args):
        """
        set_image_encoding(self, _arg:int) -> None
        C++: virtual void set_image_encoding(int _arg)"""
        ret = self._wrap_call(self._vtk_obj.SetImageEncoding, *args)
        return ret

    def set_number_of_encoder_threads(self, *args):
        """
        set_number_of_encoder_threads(self, __a:int) -> None
        C++: void set_number_of_encoder_threads(TypeUInt32)
        Set the number of worker threads to use for image encoding. 
        Calling this method with a number greater than 32 or less than
        zero will have no effect.
        """
        ret = self._wrap_call(self._vtk_obj.SetNumberOfEncoderThreads, *args)
        return ret

    def still_render(self, *args):
        """
        still_render(self, view:RenderWindow, quality:int=100)
            -> UnsignedCharArray
        C++: UnsignedCharArray *still_render(RenderWindow *view,
            int quality=100)
        Render a view and obtain the rendered image.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.StillRender, *my_args)
        return wrap_vtk(ret)

    def still_render_to_buffer(self, *args):
        """
        still_render_to_buffer(self, view:RenderWindow, time:int=0,
            quality:int=100) -> UnsignedCharArray
        C++: UnsignedCharArray *still_render_to_buffer(
            RenderWindow *view, MTimeType time=0, int quality=100)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.StillRenderToBuffer, *my_args)
        return wrap_vtk(ret)

    def still_render_to_string(self, *args):
        """
        still_render_to_string(self, view:RenderWindow, time:int=0,
            quality:int=100) -> str
        C++: const char *still_render_to_string(RenderWindow *view,
            MTimeType time=0, int quality=100)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.StillRenderToString, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(WebApplication, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit WebApplication properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit WebApplication properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit WebApplication properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

