# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.widget_representation import WidgetRepresentation


class DisplaySizedImplicitPlaneRepresentation(WidgetRepresentation):
    r"""
    DisplaySizedImplicitPlaneRepresentation - a class defining the
    representation for a DisplaySizedImplicitPlaneWidget
    
    Superclass: WidgetRepresentation
    
    This class is a concrete representation for the
    DisplaySizedImplicitPlaneWidget. It represents an display sized
    disk plane defined by a normal and point. Through interaction with
    the widget, the plane can be manipulated by adjusting the plane
    normal, disk radius or moving/picking the origin point.
    
    To use this representation, you normally define a (plane) origin and
    (plane) normal. The place_widget() method is also used to initially
    position the representation.
    
    @warning
    This class, and DisplaySizedImplicitPlaneWidget, are next
    generation VTK widgets.
    
    @sa
    DisplaySizedImplicitPlaneWidget ImplicitPlaneWidget2
    ImplicitPlaneWidget ImplicitImageRepresentation
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDisplaySizedImplicitPlaneRepresentation, obj, update, **traits)
    
    constrain_maximum_size_to_widget_bounds = tvtk_base.false_bool_trait(desc=\
        r"""
        Turn on/off whether the maximum widget size should be constrained
        to the widget bounds. If on, the radius of the disk plane and
        plane normal arrow will not be allowed to be larger than the half
        diagonal of the bounding box formed by the widget bounds. If off,
        the radius of the disk plane and plane normal arrow can be
        arbitrary big The default behaviour is off.
        """
    )

    def _constrain_maximum_size_to_widget_bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConstrainMaximumSizeToWidgetBounds,
                        self.constrain_maximum_size_to_widget_bounds_)

    constrain_to_widget_bounds = tvtk_base.false_bool_trait(desc=\
        r"""
        Turn on/off whether the plane should be constrained to the widget
        bounds. If on, the origin will not be allowed to move outside the
        set widget bounds. The default behaviour is off. If off, the
        origin can be freely moved and the widget outline will change
        accordingly.
        """
    )

    def _constrain_to_widget_bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConstrainToWidgetBounds,
                        self.constrain_to_widget_bounds_)

    draw_intersection_edges = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable/disable the drawing of the intersection edges. Default is
        off.
        
        Note: drawing the intersection edges requires draw_outline to be
        on.
        """
    )

    def _draw_intersection_edges_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDrawIntersectionEdges,
                        self.draw_intersection_edges_)

    draw_outline = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable/disable the drawing of the outline. Default is off.
        """
    )

    def _draw_outline_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDrawOutline,
                        self.draw_outline_)

    draw_plane = tvtk_base.true_bool_trait(desc=\
        r"""
        Enable/disable the drawing of the plane. In some cases the plane
        interferes with the object that it is operating on (i.e., the
        plane interferes with the cut surface it produces producing
        z-buffer artifacts.)
        """
    )

    def _draw_plane_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDrawPlane,
                        self.draw_plane_)

    lock_normal_to_camera = tvtk_base.false_bool_trait(desc=\
        r"""
        If enabled, and a Camera is available through the renderer,
        then lock_normal_to_camera will cause the normal to follow the
        camera's normal.
        """
    )

    def _lock_normal_to_camera_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLockNormalToCamera,
                        self.lock_normal_to_camera_)

    normal_to_x_axis = tvtk_base.false_bool_trait(desc=\
        r"""
        Force the plane widget to be aligned with one of the x-y-z axes.
        If one axis is set on, the other two will be set off. Remember
        that when the state changes, a modified_event is invoked. This can
        be used to snap the plane to the axes if it is originally not
        aligned.
        """
    )

    def _normal_to_x_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalToXAxis,
                        self.normal_to_x_axis_)

    normal_to_y_axis = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _normal_to_y_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalToYAxis,
                        self.normal_to_y_axis_)

    normal_to_z_axis = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _normal_to_z_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalToZAxis,
                        self.normal_to_z_axis_)

    outline_translation = tvtk_base.true_bool_trait(desc=\
        r"""
        Turn on/off the ability to translate the bounding box by grabbing
        it with the left mouse button. Default is off.
        """
    )

    def _outline_translation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutlineTranslation,
                        self.outline_translation_)

    outside_bounds = tvtk_base.true_bool_trait(desc=\
        r"""
        Turn on/off the ability to move the widget outside of the bounds
        specified in the initial place_widget() invocation.
        """
    )

    def _outside_bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutsideBounds,
                        self.outside_bounds_)

    pick_camera_focal_info = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _pick_camera_focal_info_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPickCameraFocalInfo,
                        self.pick_camera_focal_info_)

    scale_enabled = tvtk_base.true_bool_trait(desc=\
        r"""
        Turn on/off the ability to scale the widget with the mouse.
        """
    )

    def _scale_enabled_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScaleEnabled,
                        self.scale_enabled_)

    snap_to_axes = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _snap_to_axes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSnapToAxes,
                        self.snap_to_axes_)

    normal = tvtk_base.RevPrefixMap({'camera': (1.0, 0.0, 0.0)}, default_value='camera', desc=\
        r"""
        Set/Get the normal to the plane.
        """
    )

    def _normal_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormal,
                        self.normal_)

    always_snap_to_nearest_axis = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _always_snap_to_nearest_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAlwaysSnapToNearestAxis,
                        self.always_snap_to_nearest_axis)

    bump_distance = traits.Trait(0.01, traits.Range(1e-06, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Specify a translation distance used by the bump_plane() method.
        Note that the distance is normalized; it is the fraction of the
        length of the bounding box of the wire outline.
        """
    )

    def _bump_distance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBumpDistance,
                        self.bump_distance)

    interaction_state = traits.Trait(0, traits.Range(0, 7, enter_set=True, auto_set=False), desc=\
        r"""
        The interaction state may be set from a widget (e.g.,
        DisplaySizedImplicitPlaneWidget) or other object. This
        controls how the interaction with the widget proceeds. Normally
        this method is used as part of a handshaking process with the
        widget: First compute_interaction_state() is invoked that returns a
        state based on geometric considerations (i.e., cursor near a
        widget feature), then based on events, the widget may modify this
        further.
        """
    )

    def _interaction_state_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInteractionState,
                        self.interaction_state)

    origin = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/Get the origin of the plane.
        """
    )

    def _origin_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOrigin,
                        self.origin)

    def get_plane(self, *args):
        """
        get_plane(self, plane:Plane) -> None
        C++: void get_plane(Plane *plane)
        Get the implicit function for the plane by copying the origin and
        normal of the cut plane into the provided Plane. The user must
        provide the instance of the class Plane. Note that Plane is
        a subclass of ImplicitFunction, meaning that it can be used by
        a variety of filters to perform clipping, cutting, and selection
        of data.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetPlane, *my_args)
        return ret

    def set_plane(self, *args):
        """
        set_plane(self, plane:Plane) -> None
        C++: void set_plane(Plane *plane)
        Alternative way to define the cutting plane. The normal and
        origin of the plane provided is copied into the internal instance
        of the class cutting Plane.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetPlane, *my_args)
        return ret

    radius_multiplier = traits.Trait(1.0, traits.Range(1e-06, 1e+299, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the Radius Multiplier value. Default is 1.0.
        """
    )

    def _radius_multiplier_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadiusMultiplier,
                        self.radius_multiplier)

    representation_state = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Sets the visual appearance of the representation based on the
        state it is in. This state is usually the same as
        interaction_state.
        """
    )

    def _representation_state_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRepresentationState,
                        self.representation_state)

    widget_bounds = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="float", value=(-0.25, 0.25, -0.25, 0.25, -0.25, 0.25), cols=3, desc=\
        r"""
        Set/Get the bounds of the widget representation. place_widget can
        also be used to set the bounds of the widget but it may also have
        other effects on the internal state of the representation. Use
        this function when only the widget bounds need to be modified.
        """
    )

    def _widget_bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWidgetBounds,
                        self.widget_bounds)

    def _get_edges_property(self):
        return wrap_vtk(self._vtk_obj.GetEdgesProperty())
    edges_property = traits.Property(_get_edges_property, desc=\
        r"""
        Get the property of the disk edges. The properties of the edges
        when selected and unselected can be manipulated.
        """
    )

    def _get_intersection_edges_property(self):
        return wrap_vtk(self._vtk_obj.GetIntersectionEdgesProperty())
    intersection_edges_property = traits.Property(_get_intersection_edges_property, desc=\
        r"""
        Get the property of the intersection edges of the plane with the
        outline.
        """
    )

    def _get_normal_property(self):
        return wrap_vtk(self._vtk_obj.GetNormalProperty())
    normal_property = traits.Property(_get_normal_property, desc=\
        r"""
        Get the properties on the normal (line and cone). The properties
        of the normal when selected and unselected can be manipulated.
        """
    )

    def _get_outline_property(self):
        return wrap_vtk(self._vtk_obj.GetOutlineProperty())
    outline_property = traits.Property(_get_outline_property, desc=\
        r"""
        Get the property of the outline.
        """
    )

    def _get_plane_property(self):
        return wrap_vtk(self._vtk_obj.GetPlaneProperty())
    plane_property = traits.Property(_get_plane_property, desc=\
        r"""
        Get the plane properties. The properties of the plane when
        selected and unselected can be manipulated.
        """
    )

    def get_poly_data(self, *args):
        """
        get_poly_data(self, pd:PolyData) -> None
        C++: void get_poly_data(PolyData *pd)
        Grab the polydata that defines the plane. The polydata contains a
        single polygon that is clipped by the bounding box.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetPolyData, *my_args)
        return ret

    def _get_poly_data_algorithm(self):
        return wrap_vtk(self._vtk_obj.GetPolyDataAlgorithm())
    poly_data_algorithm = traits.Property(_get_poly_data_algorithm, desc=\
        r"""
        Satisfies superclass API.  This returns a pointer to the
        underlying poly_data (which represents the plane).
        """
    )

    def _get_selected_edges_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedEdgesProperty())
    selected_edges_property = traits.Property(_get_selected_edges_property, desc=\
        r"""
        
        """
    )

    def _get_selected_normal_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedNormalProperty())
    selected_normal_property = traits.Property(_get_selected_normal_property, desc=\
        r"""
        
        """
    )

    def _get_selected_outline_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedOutlineProperty())
    selected_outline_property = traits.Property(_get_selected_outline_property, desc=\
        r"""
        
        """
    )

    def _get_selected_plane_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedPlaneProperty())
    selected_plane_property = traits.Property(_get_selected_plane_property, desc=\
        r"""
        
        """
    )

    def _get_selected_sphere_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedSphereProperty())
    selected_sphere_property = traits.Property(_get_selected_sphere_property, desc=\
        r"""
        
        """
    )

    def _get_sphere_property(self):
        return wrap_vtk(self._vtk_obj.GetSphereProperty())
    sphere_property = traits.Property(_get_sphere_property, desc=\
        r"""
        Get the properties on the sphere. The properties of the sphere
        when selected and unselected can be manipulated.
        """
    )

    def _get_underlying_plane(self):
        return wrap_vtk(self._vtk_obj.GetUnderlyingPlane())
    underlying_plane = traits.Property(_get_underlying_plane, desc=\
        r"""
        
        """
    )

    def bump_plane(self, *args):
        """
        bump_plane(self, dir:int, factor:float) -> None
        C++: void bump_plane(int dir, double factor)
        Translate the plane in the direction of the normal by the
        specified bump_distance.  The dir parameter controls which
        direction the pushing occurs, either in the same direction as the
        normal, or when negative, in the opposite direction. The factor
        controls whether what percentage of the bump is used.
        """
        ret = self._wrap_call(self._vtk_obj.BumpPlane, *args)
        return ret

    def is_translation_constrained(self):
        """
        is_translation_constrained(self) -> bool
        C++: bool is_translation_constrained()
        Returns true if contrained_axis
        """
        ret = self._vtk_obj.IsTranslationConstrained()
        return ret
        

    def pick_normal(self, *args):
        """
        pick_normal(self, X:int, Y:int, snapToMeshPoint:bool=False) -> bool
        C++: bool pick_normal(int X, int Y, bool snapToMeshPoint=false)
        Given the X, Y display coordinates, pick a new normal for the
        plane from a point that is on the objects rendered by the
        renderer.
        
        Note: if a normal from a rendered object is not picked, the
        camera plane normal can optionally be set.
        """
        ret = self._wrap_call(self._vtk_obj.PickNormal, *args)
        return ret

    def pick_origin(self, *args):
        """
        pick_origin(self, X:int, Y:int, snapToMeshPoint:bool=False) -> bool
        C++: bool pick_origin(int X, int Y, bool snapToMeshPoint=false)
        Given the X, Y display coordinates, pick a new origin for the
        plane from a point that is on the objects rendered by the
        renderer.
        
        Note: if a point from a rendered object is not picked, the camera
        focal point can optionally be set.
        """
        ret = self._wrap_call(self._vtk_obj.PickOrigin, *args)
        return ret

    def push_plane(self, *args):
        """
        push_plane(self, distance:float) -> None
        C++: void push_plane(double distance)
        Push the plane the distance specified along the normal. Positive
        values are in the direction of the normal; negative values are in
        the opposite direction of the normal. The distance value is
        expressed in world coordinates.
        """
        ret = self._wrap_call(self._vtk_obj.PushPlane, *args)
        return ret

    def set_selected_widget_color(self, *args):
        """
        set_selected_widget_color(self, __a:float, __b:float, __c:float)
            -> None
        C++: void set_selected_widget_color(double, double, double)
        set_selected_widget_color(self, c:[float, float, float]) -> None
        C++: void set_selected_widget_color(double c[3])
        Set the color of all the widgets objects (edges, cone1, cone2,
        line, sphere, except plane) when unselected or selected.
        """
        ret = self._wrap_call(self._vtk_obj.SetSelectedWidgetColor, *args)
        return ret

    def set_translation_axis_off(self):
        """
        set_translation_axis_off(self) -> None
        C++: void set_translation_axis_off()"""
        ret = self._vtk_obj.SetTranslationAxisOff()
        return ret
        

    def set_unselected_widget_color(self, *args):
        """
        set_unselected_widget_color(self, __a:float, __b:float, __c:float)
            -> None
        C++: void set_unselected_widget_color(double, double, double)
        set_unselected_widget_color(self, c:[float, float, float]) -> None
        C++: void set_unselected_widget_color(double c[3])"""
        ret = self._wrap_call(self._vtk_obj.SetUnselectedWidgetColor, *args)
        return ret

    def set_x_translation_axis_on(self):
        """
        set_x_translation_axis_on(self) -> None
        C++: void set_x_translation_axis_on()
        Toggles constraint translation axis on/off.
        """
        ret = self._vtk_obj.SetXTranslationAxisOn()
        return ret
        

    def set_y_translation_axis_on(self):
        """
        set_y_translation_axis_on(self) -> None
        C++: void set_y_translation_axis_on()"""
        ret = self._vtk_obj.SetYTranslationAxisOn()
        return ret
        

    def set_z_translation_axis_on(self):
        """
        set_z_translation_axis_on(self) -> None
        C++: void set_z_translation_axis_on()"""
        ret = self._vtk_obj.SetZTranslationAxisOn()
        return ret
        

    def update_placement(self):
        """
        update_placement(self) -> None
        C++: void update_placement()
        Satisfies the superclass API.  This will change the state of the
        widget to match changes that have been made to the underlying
        poly_data_source
        """
        ret = self._vtk_obj.UpdatePlacement()
        return ret
        

    _updateable_traits_ = \
    (('constrain_maximum_size_to_widget_bounds',
    'GetConstrainMaximumSizeToWidgetBounds'),
    ('constrain_to_widget_bounds', 'GetConstrainToWidgetBounds'),
    ('draw_intersection_edges', 'GetDrawIntersectionEdges'),
    ('draw_outline', 'GetDrawOutline'), ('draw_plane', 'GetDrawPlane'),
    ('lock_normal_to_camera', 'GetLockNormalToCamera'),
    ('normal_to_x_axis', 'GetNormalToXAxis'), ('normal_to_y_axis',
    'GetNormalToYAxis'), ('normal_to_z_axis', 'GetNormalToZAxis'),
    ('outline_translation', 'GetOutlineTranslation'), ('outside_bounds',
    'GetOutsideBounds'), ('pick_camera_focal_info',
    'GetPickCameraFocalInfo'), ('scale_enabled', 'GetScaleEnabled'),
    ('snap_to_axes', 'GetSnapToAxes'), ('need_to_render',
    'GetNeedToRender'), ('picking_managed', 'GetPickingManaged'),
    ('dragable', 'GetDragable'), ('pickable', 'GetPickable'),
    ('use_bounds', 'GetUseBounds'), ('visibility', 'GetVisibility'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('normal', 'GetNormal'),
    ('always_snap_to_nearest_axis', 'GetAlwaysSnapToNearestAxis'),
    ('bump_distance', 'GetBumpDistance'), ('interaction_state',
    'GetInteractionState'), ('origin', 'GetOrigin'), ('radius_multiplier',
    'GetRadiusMultiplier'), ('representation_state',
    'GetRepresentationState'), ('widget_bounds', 'GetWidgetBounds'),
    ('handle_size', 'GetHandleSize'), ('place_factor', 'GetPlaceFactor'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['constrain_maximum_size_to_widget_bounds',
    'constrain_to_widget_bounds', 'debug', 'dragable',
    'draw_intersection_edges', 'draw_outline', 'draw_plane',
    'global_warning_display', 'lock_normal_to_camera', 'need_to_render',
    'normal_to_x_axis', 'normal_to_y_axis', 'normal_to_z_axis',
    'outline_translation', 'outside_bounds', 'pick_camera_focal_info',
    'pickable', 'picking_managed', 'scale_enabled', 'snap_to_axes',
    'use_bounds', 'visibility', 'normal', 'always_snap_to_nearest_axis',
    'bump_distance', 'estimated_render_time', 'handle_size',
    'interaction_state', 'object_name', 'origin', 'place_factor',
    'radius_multiplier', 'render_time_multiplier', 'representation_state',
    'widget_bounds'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DisplaySizedImplicitPlaneRepresentation, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DisplaySizedImplicitPlaneRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['constrain_maximum_size_to_widget_bounds',
            'constrain_to_widget_bounds', 'draw_intersection_edges',
            'draw_outline', 'draw_plane', 'lock_normal_to_camera',
            'need_to_render', 'normal_to_x_axis', 'normal_to_y_axis',
            'normal_to_z_axis', 'outline_translation', 'outside_bounds',
            'pick_camera_focal_info', 'picking_managed', 'scale_enabled',
            'snap_to_axes', 'use_bounds', 'visibility'], ['normal'],
            ['always_snap_to_nearest_axis', 'bump_distance',
            'estimated_render_time', 'handle_size', 'interaction_state',
            'object_name', 'origin', 'place_factor', 'radius_multiplier',
            'render_time_multiplier', 'representation_state', 'widget_bounds']),
            title='Edit DisplaySizedImplicitPlaneRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DisplaySizedImplicitPlaneRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

