#
# @file    TestASTNode.py
# @brief   ASTNode unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/math/test/TestASTNode.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml

DBL_EPSILON =  2.2204460492503131e-16


class TestASTNode(unittest.TestCase):


  def test_ASTNode_addChild1(self):
    node = libsbml.ASTNode()
    c1 = libsbml.ASTNode()
    c2 = libsbml.ASTNode()
    c1_1 = libsbml.ASTNode()
    i = 0
    node.setType(libsbml.AST_LOGICAL_AND)
    c1.setName( "a")
    c2.setName( "b")
    node.addChild(c1)
    node.addChild(c2)
    self.assertTrue( node.getNumChildren() == 2 )
    self.assertTrue((  "and(a, b)" == libsbml.formulaToString(node) ))
    c1_1.setName( "d")
    i = node.addChild(c1_1)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( node.getNumChildren() == 3 )
    self.assertTrue((  "and(a, b, d)" == libsbml.formulaToString(node) ))
    self.assertTrue((  "a" == node.getChild(0).getName() ))
    self.assertTrue((  "b" == node.getChild(1).getName() ))
    self.assertTrue((  "d" == node.getChild(2).getName() ))
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_addSemanticsAnnotation(self):
    ann = libsbml.XMLNode()
    node = libsbml.ASTNode()
    i = 0
    i = node.addSemanticsAnnotation(ann)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( node.getNumSemanticsAnnotations() == 1 )
    i = node.addSemanticsAnnotation(None)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_FAILED )
    self.assertTrue( node.getNumSemanticsAnnotations() == 1 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_avogadro(self):
    n = libsbml.ASTNode()
    n.setType(libsbml.AST_NAME_AVOGADRO)
    n.setName( "NA")
    self.assertTrue((  "NA" == n.getName() ))
    val = n.getReal()
    self.assertTrue( val == 6.02214179e23 )
    self.assertTrue( n.isConstant() == 1 )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_avogadro_bug(self):
    n = libsbml.ASTNode()
    n.setName( "NA")
    n.setType(libsbml.AST_NAME_AVOGADRO)
    self.assertTrue((  "NA" == n.getName() ))
    val = n.getReal()
    self.assertTrue( val == 6.02214179e23 )
    self.assertTrue( n.isConstant() == 1 )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_canonicalizeConstants(self):
    n = libsbml.ASTNode()
    n.setName( "ExponentialE")
    self.assertEqual( True, n.isName() )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_CONSTANT_E )
    n.setType(libsbml.AST_NAME)
    n.setName( "False")
    self.assertEqual( True, n.isName() )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_CONSTANT_FALSE )
    n.setType(libsbml.AST_NAME)
    n.setName( "Pi")
    self.assertEqual( True, n.isName() )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_CONSTANT_PI )
    n.setType(libsbml.AST_NAME)
    n.setName( "True")
    self.assertEqual( True, n.isName() )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_CONSTANT_TRUE )
    n.setType(libsbml.AST_NAME)
    n.setName( "Foo")
    self.assertEqual( True, n.isName() )
    n.canonicalize()
    self.assertEqual( True, n.isName() )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_canonicalizeFunctions(self):
    n = libsbml.ASTNode(libsbml.AST_FUNCTION)
    n.setName( "abs")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ABS )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arccos")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCCOS )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arccosh")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCCOSH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arccot")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCCOT )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arccoth")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCCOTH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arccsc")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCCSC )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arccsch")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCCSCH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arcsec")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCSEC )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arcsech")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCSECH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arcsin")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCSIN )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arcsinh")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCSINH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arctan")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCTAN )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "arctanh")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCTANH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "ceiling")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_CEILING )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "cos")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_COS )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "cosh")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_COSH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "cot")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_COT )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "coth")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_COTH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "csc")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_CSC )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "csch")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_CSCH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "exp")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_EXP )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "factorial")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_FACTORIAL )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "floor")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_FLOOR )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "lambda")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_LAMBDA )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "ln")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_LN )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "log")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_LOG )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "piecewise")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_PIECEWISE )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "power")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_POWER )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "root")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ROOT )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "sec")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_SEC )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "sech")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_SECH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "sin")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_SIN )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "sinh")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_SINH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "tan")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_TAN )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "tanh")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_TANH )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "Foo")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_canonicalizeFunctionsL1(self):
    n = libsbml.ASTNode(libsbml.AST_FUNCTION)
    n.setName( "acos")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCCOS )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "asin")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCSIN )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "atan")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCTAN )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "ceil")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_CEILING )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "pow")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_POWER )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    n = libsbml.ASTNode(libsbml.AST_FUNCTION)
    n.setName( "log")
    c = libsbml.ASTNode()
    c.setName( "x")
    n.addChild(c)
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    self.assertTrue( n.getNumChildren() == 1 )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_LN )
    self.assertTrue( n.getNumChildren() == 1 )
    n.setType(libsbml.AST_FUNCTION)
    c = libsbml.ASTNode()
    c.setName( "y")
    n.addChild(c)
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    self.assertTrue( n.getNumChildren() == 2 )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_LOG )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    n = libsbml.ASTNode(libsbml.AST_FUNCTION)
    n.setName( "log10")
    c = libsbml.ASTNode()
    c.setName( "x")
    n.addChild(c)
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    self.assertTrue( n.getNumChildren() == 1 )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_LOG )
    self.assertTrue( n.getNumChildren() == 2 )
    c = n.getLeftChild()
    self.assertTrue( c.getType() == libsbml.AST_INTEGER )
    self.assertTrue( c.getInteger() == 10 )
    c = n.getRightChild()
    self.assertTrue( c.getType() == libsbml.AST_NAME )
    self.assertTrue((  "x" == c.getName() ))
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    n = libsbml.ASTNode(libsbml.AST_FUNCTION)
    n.setName( "sqr")
    c = libsbml.ASTNode()
    c.setName( "x")
    n.addChild(c)
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    self.assertTrue( n.getNumChildren() == 1 )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_POWER )
    self.assertTrue( n.getNumChildren() == 2 )
    c = n.getLeftChild()
    self.assertTrue( c.getType() == libsbml.AST_NAME )
    self.assertTrue((  "x" == c.getName() ))
    c = n.getRightChild()
    self.assertTrue( c.getType() == libsbml.AST_INTEGER )
    self.assertTrue( c.getInteger() == 2 )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    n = libsbml.ASTNode(libsbml.AST_FUNCTION)
    n.setName( "sqrt")
    c = libsbml.ASTNode()
    c.setName( "x")
    n.addChild(c)
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    self.assertTrue( n.getNumChildren() == 1 )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION_ROOT )
    self.assertTrue( n.getNumChildren() == 2 )
    c = n.getLeftChild()
    self.assertTrue( c.getType() == libsbml.AST_INTEGER )
    self.assertTrue( c.getInteger() == 2 )
    c = n.getRightChild()
    self.assertTrue( c.getType() == libsbml.AST_NAME )
    self.assertTrue((  "x" == c.getName() ))
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_canonicalizeLogical(self):
    n = libsbml.ASTNode(libsbml.AST_FUNCTION)
    n.setName( "and")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_LOGICAL_AND )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "not")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_LOGICAL_NOT )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "or")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_LOGICAL_OR )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "xor")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_LOGICAL_XOR )
    n.setType(libsbml.AST_FUNCTION)
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_canonicalizeRelational(self):
    n = libsbml.ASTNode(libsbml.AST_FUNCTION)
    n.setName( "eq")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_RELATIONAL_EQ )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "geq")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_RELATIONAL_GEQ )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "gt")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_RELATIONAL_GT )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "leq")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_RELATIONAL_LEQ )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "lt")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_RELATIONAL_LT )
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "neq")
    self.assertTrue( n.getType() == libsbml.AST_FUNCTION )
    n.canonicalize()
    self.assertTrue( n.getType() == libsbml.AST_RELATIONAL_NEQ )
    n.setType(libsbml.AST_FUNCTION)
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_children(self):
    parent = libsbml.ASTNode()
    left = libsbml.ASTNode()
    right = libsbml.ASTNode()
    right2 = libsbml.ASTNode()
    parent.setType(libsbml.AST_PLUS)
    left.setValue(1)
    right.setValue(2)
    right2.setValue(3)
    parent.addChild(left)
    parent.addChild(right)
    self.assertTrue( parent.getNumChildren() == 2 )
    self.assertTrue( left.getNumChildren() == 0 )
    self.assertTrue( right.getNumChildren() == 0 )
    self.assertTrue( parent.getLeftChild() == left )
    self.assertTrue( parent.getRightChild() == right )
    self.assertTrue( parent.getChild(0) == left )
    self.assertTrue( parent.getChild(1) == right )
    self.assertTrue( parent.getChild(2) == None )
    parent.addChild(right2)
    self.assertTrue( parent.getNumChildren() == 3 )
    self.assertTrue( left.getNumChildren() == 0 )
    self.assertTrue( right.getNumChildren() == 0 )
    self.assertTrue( right2.getNumChildren() == 0 )
    self.assertTrue( parent.getLeftChild() == left )
    self.assertTrue( parent.getRightChild() == right2 )
    self.assertTrue( parent.getChild(0) == left )
    self.assertTrue( parent.getChild(1) == right )
    self.assertTrue( parent.getChild(2) == right2 )
    self.assertTrue( parent.getChild(3) == None )
    _dummyList = [ parent ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_create(self):
    n = libsbml.ASTNode()
    ea = libsbml.EventAssignment(2,4)
    self.assertTrue( n.getType() == libsbml.AST_UNKNOWN )
    self.assertTrue( n.getCharacter() == "\0" )
    self.assertTrue( n.getName() == None )
    self.assertTrue( n.getInteger() == 0 )
    self.assertTrue( n.getExponent() == 0 )
    self.assertTrue( n.getNumChildren() == 0 )
    self.assertTrue( n.getParentSBMLObject() == None )
    _dummyList = [ ea ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_deepCopy_1(self):
    node = libsbml.ASTNode()
    node.setCharacter( '+')
    node.addChild(libsbml.ASTNode())
    node.addChild(libsbml.ASTNode())
    node.getLeftChild().setValue(1)
    node.getRightChild().setValue(2)
    self.assertTrue( node.getType() == libsbml.AST_PLUS )
    self.assertTrue( node.getCharacter() == '+' )
    self.assertTrue( node.getNumChildren() == 2 )
    child = node.getLeftChild()
    self.assertTrue( child.getType() == libsbml.AST_INTEGER )
    self.assertTrue( child.getInteger() == 1 )
    self.assertTrue( child.getNumChildren() == 0 )
    child = node.getRightChild()
    self.assertTrue( child.getType() == libsbml.AST_INTEGER )
    self.assertTrue( child.getInteger() == 2 )
    self.assertTrue( child.getNumChildren() == 0 )
    copy = node.deepCopy()
    self.assertTrue( copy != node )
    self.assertTrue( copy.getType() == libsbml.AST_PLUS )
    self.assertTrue( copy.getCharacter() == '+' )
    self.assertTrue( copy.getNumChildren() == 2 )
    child = copy.getLeftChild()
    self.assertTrue( child != node.getLeftChild() )
    self.assertTrue( child.getType() == libsbml.AST_INTEGER )
    self.assertTrue( child.getInteger() == 1 )
    self.assertTrue( child.getNumChildren() == 0 )
    child = copy.getRightChild()
    self.assertTrue( child != node.getRightChild() )
    self.assertTrue( child.getType() == libsbml.AST_INTEGER )
    self.assertTrue( child.getInteger() == 2 )
    self.assertTrue( child.getNumChildren() == 0 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ copy ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_deepCopy_2(self):
    node = libsbml.ASTNode()
    node.setName( "Foo")
    self.assertTrue( node.getType() == libsbml.AST_NAME )
    self.assertTrue((  "Foo" == node.getName() ))
    self.assertTrue( node.getNumChildren() == 0 )
    copy = node.deepCopy()
    self.assertTrue( copy != node )
    self.assertTrue( copy.getType() == libsbml.AST_NAME )
    self.assertTrue((  "Foo" == copy.getName() ))
    self.assertTrue( copy.getNumChildren() == 0 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ copy ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_deepCopy_3(self):
    node = libsbml.ASTNode(libsbml.AST_FUNCTION)
    node.setName( "Foo")
    self.assertTrue( node.getType() == libsbml.AST_FUNCTION )
    self.assertTrue((  "Foo" == node.getName() ))
    self.assertTrue( node.getNumChildren() == 0 )
    copy = node.deepCopy()
    self.assertTrue( copy != node )
    self.assertTrue( copy.getType() == libsbml.AST_FUNCTION )
    self.assertTrue((  "Foo" == copy.getName() ))
    self.assertTrue( copy.getNumChildren() == 0 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ copy ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_deepCopy_4(self):
    node = libsbml.ASTNode(libsbml.AST_FUNCTION_ABS)
    node.setName( "ABS")
    self.assertTrue( node.getType() == libsbml.AST_FUNCTION_ABS )
    self.assertTrue((  "ABS" == node.getName() ))
    self.assertTrue( node.getNumChildren() == 0 )
    copy = node.deepCopy()
    self.assertTrue( copy != node )
    self.assertTrue( copy.getType() == libsbml.AST_FUNCTION_ABS )
    self.assertTrue((  "ABS" == copy.getName() ))
    self.assertTrue( copy.getNumChildren() == 0 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ copy ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_freeName(self):
    node = libsbml.ASTNode()
    i = 0
    i = node.setName( "a")
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue((  "a" == libsbml.formulaToString(node) ))
    self.assertTrue((  "a" == node.getName() ))
    i = node.freeName()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( node.getName() == None )
    i = node.freeName()
    self.assertTrue( i == libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE )
    self.assertTrue( node.getName() == None )
    node.setType(libsbml.AST_UNKNOWN)
    i = node.freeName()
    self.assertTrue( i == libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE )
    self.assertTrue( node.getName() == None )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_free_NULL(self):
    _dummyList = [ None ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_getName(self):
    n = libsbml.ASTNode()
    n.setName( "foo")
    self.assertTrue((  "foo" == n.getName() ))
    n.setType(libsbml.AST_NAME_TIME)
    self.assertTrue((  "foo" == n.getName() ))
    n.setName(None)
    self.assertTrue( n.getName() == None )
    n.setType(libsbml.AST_CONSTANT_E)
    self.assertTrue((  "exponentiale" == n.getName() ))
    n.setType(libsbml.AST_CONSTANT_FALSE)
    self.assertTrue((  "false" == n.getName() ))
    n.setType(libsbml.AST_CONSTANT_PI)
    self.assertTrue((  "pi" == n.getName() ))
    n.setType(libsbml.AST_CONSTANT_TRUE)
    self.assertTrue((  "true" == n.getName() ))
    n.setType(libsbml.AST_LAMBDA)
    self.assertTrue((  "lambda" == n.getName() ))
    n.setType(libsbml.AST_FUNCTION)
    n.setName( "f")
    self.assertTrue((  "f" == n.getName() ))
    n.setType(libsbml.AST_FUNCTION_DELAY)
    self.assertTrue((  "f" == n.getName() ))
    n.setName(None)
    self.assertTrue((  "delay" == n.getName() ))
    n.setType(libsbml.AST_FUNCTION)
    self.assertTrue( n.getName() == None )
    n.setType(libsbml.AST_FUNCTION_ABS)
    self.assertTrue((  "abs" == n.getName() ))
    n.setType(libsbml.AST_FUNCTION_ARCCOS)
    self.assertTrue((  "arccos" == n.getName() ))
    n.setType(libsbml.AST_FUNCTION_TAN)
    self.assertTrue((  "tan" == n.getName() ))
    n.setType(libsbml.AST_FUNCTION_TANH)
    self.assertTrue((  "tanh" == n.getName() ))
    n.setType(libsbml.AST_LOGICAL_AND)
    self.assertTrue((  "and" == n.getName() ))
    n.setType(libsbml.AST_LOGICAL_NOT)
    self.assertTrue((  "not" == n.getName() ))
    n.setType(libsbml.AST_LOGICAL_OR)
    self.assertTrue((  "or" == n.getName() ))
    n.setType(libsbml.AST_LOGICAL_XOR)
    self.assertTrue((  "xor" == n.getName() ))
    n.setType(libsbml.AST_RELATIONAL_EQ)
    self.assertTrue((  "eq" == n.getName() ))
    n.setType(libsbml.AST_RELATIONAL_GEQ)
    self.assertTrue((  "geq" == n.getName() ))
    n.setType(libsbml.AST_RELATIONAL_LT)
    self.assertTrue((  "lt" == n.getName() ))
    n.setType(libsbml.AST_RELATIONAL_NEQ)
    self.assertTrue((  "neq" == n.getName() ))
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_getPrecedence(self):
    n = libsbml.ASTNode()
    n.setType(libsbml.AST_PLUS)
    self.assertTrue( n.getPrecedence() == 2 )
    n.setType(libsbml.AST_MINUS)
    self.assertTrue( n.getPrecedence() == 2 )
    n.setType(libsbml.AST_TIMES)
    self.assertTrue( n.getPrecedence() == 3 )
    n.setType(libsbml.AST_DIVIDE)
    self.assertTrue( n.getPrecedence() == 3 )
    n.setType(libsbml.AST_POWER)
    self.assertTrue( n.getPrecedence() == 4 )
    n.setType(libsbml.AST_MINUS)
    n.addChild(libsbml.ASTNode(libsbml.AST_NAME))
    self.assertTrue( n.isUMinus() == True )
    self.assertTrue( n.getPrecedence() == 5 )
    n.setType(libsbml.AST_NAME)
    self.assertTrue( n.getPrecedence() == 6 )
    n.setType(libsbml.AST_FUNCTION)
    self.assertTrue( n.getPrecedence() == 6 )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_getReal(self):
    n = libsbml.ASTNode()
    n.setType(libsbml.AST_REAL)
    n.setValue(1.6)
    self.assertTrue( n.getReal() == 1.6 )
    n.setType(libsbml.AST_REAL_E)
    n.setValue(12.3,3)
    val = abs(n.getReal() - 12300.0)
    self.assertTrue( val < DBL_EPSILON )
    n.setType(libsbml.AST_RATIONAL)
    n.setValue(1,2)
    self.assertTrue( n.getReal() == 0.5 )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_insertChild(self):
    node = libsbml.ASTNode()
    c1 = libsbml.ASTNode()
    c2 = libsbml.ASTNode()
    c3 = libsbml.ASTNode()
    newc = libsbml.ASTNode()
    newc1 = libsbml.ASTNode()
    i = 0
    node.setType(libsbml.AST_LOGICAL_AND)
    c1.setName( "a")
    c2.setName( "b")
    c3.setName( "c")
    node.addChild(c1)
    node.addChild(c2)
    node.addChild(c3)
    self.assertTrue( node.getNumChildren() == 3 )
    self.assertTrue((  "and(a, b, c)" == libsbml.formulaToString(node) ))
    newc.setName( "d")
    newc1.setName( "e")
    i = node.insertChild(1,newc)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( node.getNumChildren() == 4 )
    self.assertTrue((  "and(a, d, b, c)" == libsbml.formulaToString(node) ))
    i = node.insertChild(5,newc)
    self.assertTrue( i == libsbml.LIBSBML_INDEX_EXCEEDS_SIZE )
    self.assertTrue( node.getNumChildren() == 4 )
    self.assertTrue((  "and(a, d, b, c)" == libsbml.formulaToString(node) ))
    i = node.insertChild(2,newc1)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( node.getNumChildren() == 5 )
    self.assertTrue((  "and(a, d, e, b, c)" == libsbml.formulaToString(node) ))
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_isLog10(self):
    n = libsbml.ASTNode()
    n.setType(libsbml.AST_FUNCTION)
    self.assertTrue( n.isLog10() == False )
    n.setType(libsbml.AST_FUNCTION_LOG)
    self.assertTrue( n.isLog10() == False )
    c = libsbml.ASTNode()
    n.addChild(c)
    c.setValue(10)
    self.assertTrue( n.isLog10() == False )
    n.addChild(libsbml.ASTNode())
    self.assertTrue( n.isLog10() == True )
    c.setValue(2)
    self.assertTrue( n.isLog10() == False )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_isSqrt(self):
    n = libsbml.ASTNode()
    n.setType(libsbml.AST_FUNCTION)
    self.assertTrue( n.isSqrt() == False )
    n.setType(libsbml.AST_FUNCTION_ROOT)
    self.assertTrue( n.isSqrt() == False )
    c = libsbml.ASTNode()
    n.addChild(c)
    c.setValue(2)
    self.assertTrue( n.isSqrt() == False )
    n.addChild(libsbml.ASTNode())
    self.assertTrue( n.isSqrt() == True )
    c.setValue(3)
    self.assertTrue( n.isSqrt() == False )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_isUMinus(self):
    n = libsbml.ASTNode()
    n.setType(libsbml.AST_MINUS)
    self.assertTrue( n.isUMinus() == False )
    n.addChild(libsbml.ASTNode(libsbml.AST_NAME))
    self.assertTrue( n.isUMinus() == True )
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_no_children(self):
    node = libsbml.ASTNode()
    self.assertTrue( node.getNumChildren() == 0 )
    self.assertTrue( node.getLeftChild() == None )
    self.assertTrue( node.getRightChild() == None )
    self.assertTrue( node.getChild(0) == None )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_one_child(self):
    node = libsbml.ASTNode()
    child = libsbml.ASTNode()
    node.addChild(child)
    self.assertTrue( node.getNumChildren() == 1 )
    self.assertTrue( node.getLeftChild() == child )
    self.assertTrue( node.getRightChild() == None )
    self.assertTrue( node.getChild(0) == child )
    self.assertTrue( node.getChild(1) == None )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_prependChild1(self):
    node = libsbml.ASTNode()
    c1 = libsbml.ASTNode()
    c2 = libsbml.ASTNode()
    c1_1 = libsbml.ASTNode()
    i = 0
    node.setType(libsbml.AST_LOGICAL_AND)
    c1.setName( "a")
    c2.setName( "b")
    node.addChild(c1)
    node.addChild(c2)
    self.assertTrue( node.getNumChildren() == 2 )
    self.assertTrue((  "and(a, b)" == libsbml.formulaToString(node) ))
    c1_1.setName( "d")
    i = node.prependChild(c1_1)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( node.getNumChildren() == 3 )
    self.assertTrue((  "and(d, a, b)" == libsbml.formulaToString(node) ))
    self.assertTrue((  "d" == node.getChild(0).getName() ))
    self.assertTrue((  "a" == node.getChild(1).getName() ))
    self.assertTrue((  "b" == node.getChild(2).getName() ))
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_removeChild(self):
    node = libsbml.ASTNode()
    c1 = libsbml.ASTNode()
    c2 = libsbml.ASTNode()
    i = 0
    node.setType(libsbml.AST_PLUS)
    c1.setName( "foo")
    c2.setName( "foo2")
    node.addChild(c1)
    node.addChild(c2)
    self.assertTrue( node.getNumChildren() == 2 )
    i = node.removeChild(0)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( node.getNumChildren() == 1 )
    i = node.removeChild(1)
    self.assertTrue( i == libsbml.LIBSBML_INDEX_EXCEEDS_SIZE )
    self.assertTrue( node.getNumChildren() == 1 )
    i = node.removeChild(0)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( node.getNumChildren() == 0 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_replaceChild(self):
    node = libsbml.ASTNode()
    c1 = libsbml.ASTNode()
    c2 = libsbml.ASTNode()
    c3 = libsbml.ASTNode()
    newc = libsbml.ASTNode()
    i = 0
    node.setType(libsbml.AST_LOGICAL_AND)
    c1.setName( "a")
    c2.setName( "b")
    c3.setName( "c")
    node.addChild(c1)
    node.addChild(c2)
    node.addChild(c3)
    self.assertTrue( node.getNumChildren() == 3 )
    self.assertTrue((  "and(a, b, c)" == libsbml.formulaToString(node) ))
    newc.setName( "d")
    i = node.replaceChild(0,newc)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( node.getNumChildren() == 3 )
    self.assertTrue((  "and(d, b, c)" == libsbml.formulaToString(node) ))
    i = node.replaceChild(3,newc)
    self.assertTrue( i == libsbml.LIBSBML_INDEX_EXCEEDS_SIZE )
    self.assertTrue( node.getNumChildren() == 3 )
    self.assertTrue((  "and(d, b, c)" == libsbml.formulaToString(node) ))
    i = node.replaceChild(1,c1)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( node.getNumChildren() == 3 )
    self.assertTrue((  "and(d, a, c)" == libsbml.formulaToString(node) ))
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_setCharacter(self):
    node = libsbml.ASTNode()
    node.setName( "foo")
    self.assertTrue( node.getType() == libsbml.AST_NAME )
    self.assertTrue( node.getCharacter() == "\0" )
    self.assertTrue((  "foo" == node.getName() ))
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    node.setCharacter( '+')
    self.assertTrue( node.getType() == libsbml.AST_PLUS )
    self.assertTrue( node.getCharacter() == '+' )
    self.assertTrue( node.getName() == None )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    node.setCharacter( '-')
    self.assertTrue( node.getType() == libsbml.AST_MINUS )
    self.assertTrue( node.getCharacter() == '-' )
    self.assertTrue( node.getName() == None )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    node.setCharacter( '*')
    self.assertTrue( node.getType() == libsbml.AST_TIMES )
    self.assertTrue( node.getCharacter() == '*' )
    self.assertTrue( node.getName() == None )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    node.setCharacter( '/')
    self.assertTrue( node.getType() == libsbml.AST_DIVIDE )
    self.assertTrue( node.getCharacter() == '/' )
    self.assertTrue( node.getName() == None )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    node.setCharacter( '^')
    self.assertTrue( node.getType() == libsbml.AST_POWER )
    self.assertTrue( node.getCharacter() == '^' )
    self.assertTrue( node.getName() == None )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    node.setCharacter( '$')
    self.assertTrue( node.getType() == libsbml.AST_UNKNOWN )
    self.assertTrue( node.getCharacter() == '$' )
    self.assertTrue( node.getName() == None )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_setInteger(self):
    node = libsbml.ASTNode()
    node.setName( "foo")
    self.assertTrue( node.getType() == libsbml.AST_NAME )
    self.assertTrue((  "foo" == node.getName() ))
    self.assertTrue( node.getCharacter() == "\0" )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    node.setValue(3.2)
    self.assertTrue( node.getType() == libsbml.AST_REAL )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getName() == None )
    self.assertTrue( node.getCharacter() == "\0" )
    self.assertTrue( node.getReal() == 3.2 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    node.setValue(321)
    self.assertTrue( node.getType() == libsbml.AST_INTEGER )
    self.assertTrue( node.getInteger() == 321 )
    self.assertTrue( node.getName() == None )
    self.assertTrue( node.getCharacter() == "\0" )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_setName(self):
    name =  "foo";
    node = libsbml.ASTNode()
    self.assertTrue( node.getType() == libsbml.AST_UNKNOWN )
    node.setName(name)
    self.assertTrue( node.getType() == libsbml.AST_NAME )
    self.assertTrue(( name == node.getName() ))
    self.assertTrue( node.getCharacter() == "\0" )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    if (node.getName() == name):
      pass    
    node.setName(None)
    self.assertTrue( node.getType() == libsbml.AST_NAME )
    if (node.getName() != None):
      pass    
    node.setType(libsbml.AST_FUNCTION_COS)
    self.assertTrue( node.getType() == libsbml.AST_FUNCTION_COS )
    self.assertTrue((  "cos" == node.getName() ))
    self.assertTrue( node.getCharacter() == "\0" )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    node.setType(libsbml.AST_PLUS)
    node.setName(name)
    self.assertTrue( node.getType() == libsbml.AST_NAME )
    self.assertTrue(( name == node.getName() ))
    self.assertTrue( node.getCharacter() == '+' )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getReal() == 0 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_setName_override(self):
    node = libsbml.ASTNode(libsbml.AST_FUNCTION_SIN)
    self.assertTrue((  "sin" == node.getName() ))
    self.assertTrue( node.getType() == libsbml.AST_FUNCTION_SIN )
    node.setName( "MySinFunc")
    self.assertTrue((  "MySinFunc" == node.getName() ))
    self.assertTrue( node.getType() == libsbml.AST_FUNCTION_SIN )
    node.setName(None)
    self.assertTrue((  "sin" == node.getName() ))
    self.assertTrue( node.getType() == libsbml.AST_FUNCTION_SIN )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_setReal(self):
    node = libsbml.ASTNode()
    node.setName( "foo")
    self.assertTrue( node.getType() == libsbml.AST_NAME )
    node.setValue(32.1)
    self.assertTrue( node.getType() == libsbml.AST_REAL )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getName() == None )
    self.assertTrue( node.getCharacter() == "\0" )
    self.assertTrue( node.getReal() == 32.1 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 1 )
    self.assertTrue( node.getMantissa() == 32.1 )
    node.setValue(45,90)
    self.assertTrue( node.getType() == libsbml.AST_RATIONAL )
    self.assertTrue( node.getInteger() == 45 )
    self.assertTrue( node.getName() == None )
    self.assertTrue( node.getCharacter() == "\0" )
    self.assertTrue( node.getReal() == 0.5 )
    self.assertTrue( node.getExponent() == 0 )
    self.assertTrue( node.getDenominator() == 90 )
    self.assertTrue( node.getMantissa() == 0 )
    node.setValue(32.0,4)
    self.assertTrue( node.getType() == libsbml.AST_REAL_E )
    self.assertTrue( node.getInteger() == 0 )
    self.assertTrue( node.getName() == None )
    self.assertTrue( node.getCharacter() == "\0" )
    self.assertTrue( node.getReal() == 320000 )
    self.assertTrue( node.getExponent() == 4 )
    self.assertTrue( node.getDenominator() == 1 )
    self.assertTrue( node.getMantissa() == 32 )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_setType(self):
    node = libsbml.ASTNode()
    node.setName( "foo")
    self.assertTrue( node.getType() == libsbml.AST_NAME )
    node.setType(libsbml.AST_FUNCTION)
    self.assertTrue( node.getType() == libsbml.AST_FUNCTION )
    self.assertTrue((  "foo" == node.getName() ))
    node.setType(libsbml.AST_NAME)
    self.assertTrue( node.getType() == libsbml.AST_NAME )
    self.assertTrue((  "foo" == node.getName() ))
    node.setType(libsbml.AST_INTEGER)
    self.assertTrue( node.getType() == libsbml.AST_INTEGER )
    node.setType(libsbml.AST_REAL)
    self.assertTrue( node.getType() == libsbml.AST_REAL )
    node.setType(libsbml.AST_UNKNOWN)
    self.assertTrue( node.getType() == libsbml.AST_UNKNOWN )
    node.setType(libsbml.AST_PLUS)
    self.assertTrue( node.getType() == libsbml.AST_PLUS )
    self.assertTrue( node.getCharacter() == '+' )
    node.setType(libsbml.AST_MINUS)
    self.assertTrue( node.getType() == libsbml.AST_MINUS )
    self.assertTrue( node.getCharacter() == '-' )
    node.setType(libsbml.AST_TIMES)
    self.assertTrue( node.getType() == libsbml.AST_TIMES )
    self.assertTrue( node.getCharacter() == '*' )
    node.setType(libsbml.AST_DIVIDE)
    self.assertTrue( node.getType() == libsbml.AST_DIVIDE )
    self.assertTrue( node.getCharacter() == '/' )
    node.setType(libsbml.AST_POWER)
    self.assertTrue( node.getType() == libsbml.AST_POWER )
    self.assertTrue( node.getCharacter() == '^' )
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_swapChildren(self):
    node = libsbml.ASTNode()
    c1 = libsbml.ASTNode()
    c2 = libsbml.ASTNode()
    node_1 = libsbml.ASTNode()
    c1_1 = libsbml.ASTNode()
    c2_1 = libsbml.ASTNode()
    i = 0
    node.setType(libsbml.AST_LOGICAL_AND)
    c1.setName( "a")
    c2.setName( "b")
    node.addChild(c1)
    node.addChild(c2)
    self.assertTrue( node.getNumChildren() == 2 )
    self.assertTrue((  "and(a, b)" == libsbml.formulaToString(node) ))
    node_1.setType(libsbml.AST_LOGICAL_AND)
    c1_1.setName( "d")
    c2_1.setName( "f")
    node_1.addChild(c1_1)
    node_1.addChild(c2_1)
    self.assertTrue( node_1.getNumChildren() == 2 )
    self.assertTrue((  "and(d, f)" == libsbml.formulaToString(node_1) ))
    i = node.swapChildren(node_1)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( node.getNumChildren() == 2 )
    self.assertTrue((  "and(d, f)" == libsbml.formulaToString(node) ))
    self.assertTrue( node_1.getNumChildren() == 2 )
    self.assertTrue((  "and(a, b)" == libsbml.formulaToString(node_1) ))
    _dummyList = [ node_1 ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ node ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ASTNode_units(self):
    n = libsbml.ASTNode()
    n.setType(libsbml.AST_REAL)
    n.setValue(1.6)
    i = n.setUnits( "mole")
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( n.isSetUnits() == True )
    self.assertTrue((  "mole" == n.getUnits() ))
    i = n.unsetUnits()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( n.isSetUnits() == False )
    self.assertTrue((  "" == n.getUnits() ))
    i = n.setUnits( "1mole")
    self.assertTrue( i == libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE )
    self.assertTrue( n.isSetUnits() == False )
    n.setType(libsbml.AST_FUNCTION)
    i = n.setUnits( "mole")
    self.assertTrue( i == libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE )
    self.assertTrue( n.isSetUnits() == False )
    self.assertTrue((  "" == n.getUnits() ))
    _dummyList = [ n ]; _dummyList[:] = []; del _dummyList
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestASTNode))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
