#################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
#################################################################################

AC_DEFUN([SHOW_COPYRIGHT],
	[
	echo "#################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################
"
	]
)

AC_DEFUN([CHECK_CIMSERVER],
	[
	AC_MSG_CHECKING(for CIM servers)
	
	if test x"$CIMSERVER" == x
	then
		AC_MSG_ERROR([[please define the CIMSERVER variable (see ./configure --help)]])
	fi
	
	if test "$CIMSERVER" != pegasus && test "$CIMSERVER" != sfcb && test "$CIMSERVER" != openwbem
	then
		AC_MSG_ERROR([[please define the CIMSERVER variable (see ./configure --help)]])
	fi
	
	if test "$CIMSERVER" == pegasus
	then
		if test x"$prefix" == xNONE
		then
			if test "$HW" == X86_64 || test "$HW" == IA64
			then
				COMMONLIBDIR=/usr/lib64
			else
				COMMONLIBDIR=/usr/lib
			fi
			CMPIINCLUDEDIR=/usr/include/Pegasus/Provider/CMPI
			OPENDRIMCOMMONINCLUDE=/usr/include/OpenDRIM
		else
			if test "$HW" == X86_64 || test "$HW" == IA64
			then
				COMMONLIBDIR=$prefix/lib64
			else
				COMMONLIBDIR=$prefix/lib
			fi
			CMPIINCLUDEDIR=$prefix/include/Pegasus/Provider/CMPI
			OPENDRIMCOMMONINCLUDE=$prefix/include/OpenDRIM
		fi

		if test x"$PEGASUS_HOME" != x
		then
			COMMONLIBDIR=$PEGASUS_HOME/lib
			CMPIINCLUDEDIR=$PEGASUS_ROOT/src/Pegasus/Provider/CMPI
			OPENDRIMCOMMONINCLUDE=$PEGASUS_HOME/include/OpenDRIM
		fi
	fi
	
	if test "$CIMSERVER" == sfcb
	then
		if test x"$prefix" == xNONE
		then
			COMMONLIBDIR=$ac_default_prefix/lib
			CMPIINCLUDEDIR=/usr/include/cmpi
			OPENDRIMCOMMONINCLUDE=$ac_default_prefix/include/OpenDRIM
		else
			COMMONLIBDIR=$prefix/lib
			CMPIINCLUDEDIR=/usr/include/cmpi
			OPENDRIMCOMMONINCLUDE=$prefix/include/OpenDRIM
		fi
	fi
	
	if test "$CIMSERVER" == openwbem
	then
		if test x"$prefix" == xNONE
		then
			if test "$HW" == X86_64 || test "$HW" == IA64
			then
				COMMONLIBDIR=/usr/lib64
			else
				COMMONLIBDIR=/usr/lib
			fi
			CMPIINCLUDEDIR=/usr/local/include/openwbem
			OPENDRIMCOMMONINCLUDE=/usr/include/OpenDRIM
		else
			COMMONLIBDIR=$prefix/lib
			CMPIINCLUDEDIR=$prefix/include/openwbem
			OPENDRIMCOMMONINCLUDE=$prefix/include/OpenDRIM
		fi
	fi
	
	AC_MSG_RESULT(yes)
	]
)
