% SVMOCAS_LBP Train linear SVM classifier for images represented by LBP features. 
%
% Synopsis:
%  [W,W0,stat]= svmocas_lbp(Images,imSize,Wins,winSize,height_of_pyramid,X0,y,C)
%
%  [W,W0,stat]= svmocas_lbp(Images,imSize,Wins,winSize,height_of_pyramid,...
%                  X0,y,C,Method,TolRel,TolAbs,QPBound,BufSize,MaxTime,verb)
%
% Desription:
%  SVMOCAS_LBP applies SVMOCAS solver (see HELP SVMOCAS) for training 
%  two-class image classifier. The images are represented a by pyramid of 
%  LBP features. For description of the used image features see HELP LBPPYR.
%
%  SVMOCAS_LBP allows to define virtual examples which are generated by
%  shifting a base window along x- and y-axis of the input images.
%  SVMOCAS_LBP implements the COFFIN framework, i.e., the virtual examples 
%  are computed on demand which leads to substantial memory savings. 
%
%  References:
%   - S. Sonnenburg, V. Franc. COFFIN: A Computational Framework for Linear SVMs.
%     In Proc. of ICML 2010. Haifa. 
%   - V. Franc, S. Sonnenburg. Optimized Cutting Plane Algorithm for Large-Scale 
%     Risk Minimization.  The Journal of Machine Learning Research (JMLR), 
%     vol. 10, pp. 2157--2192. October 2009. 
%
% Input:
%   Images [(im_H*im_W) x nImages (uint8)] Input grey-scale images stored
%      as column vectors.
%   imSize [2 x 1] Size of the input images: imSize = [ImHeight x ImgWidth].
%   Wins [4 x nExamples (uint32)] Defines windows (boxes) cropped from Images.
%     Each window represents a single virtual example described by
%     [image_index; top_left_col; top_left_row; mirror] where
%     image_index points at column of Image; top_left_col and top_left_row
%     are coordinates of the top left corner of the window and mirror
%     is 0 (no mirroring) or 1 (swap window along the vertical axis).
%   winSize [2 x 1] Size of the base window cropped from the Images.
%   height_of_pyramid [1 x 1] See HELP LBPPYR.
%
%   X0 [1x1] constant coordinate (implicitly) added to all examples;
%     this allows training biased decision rule.
%   y [nExamples x 1] labels (+1/-1).
%   C [1x1]  or [nExamples x 1] C [1x1] is a regularization constant common for all examples;
%     if C is a vector [nExamples x 1] then each example has its own (possibly different) 
%     regularization constant.
%   Method [1x1] 0..cutting plane; 1..OCAS  (default 1)
%   TolRel [1x1] halts if Q_P-Q_D <= abs(Q_P)*TolRel  (default 0.01)
%   TolAbs [1x1] halts if Q_P-Q_D <= TolAbs  (default 0)
%   QPValue [1x1] halts if Q_P <= QPBpound  (default 0)
%   BufSize [1x1] Initial size of active constrains buffer (default 2000)
%   nExaples [1x1] Number of examples used for training; must be >0 and <= size(X,2).
%     If nExamples = inf then nExamples is set to size(X,2).
%   MaxTime [1x1] halts if time used by solver (data loading time is not counted) exceeds
%    MaxTime given in seconds. Use MaxTime=inf (default) to switch off this stopping condition. 
%
% Output:
%   W [nDim x 1] Paramater vectors of decision rule sign(W'*X+W0) where X
%     is LBPPYR feature representation of image to be classified.
%   W0 [1x1] Bias term of the decision rule.
%   stat [struct] Optimizer statistics (field names are self-explaining).
%
% Example:
%   See SVMOCAS_LBP_EXAMPLE
%

%
% Copyright (C) 2008, 2009, 2010 Vojtech Franc, xfrancv@cmp.felk.cvut.cz
%                          Soeren Sonnenburg, soeren.sonnenburg@first.fraunhofer.de
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public 
% License as published by the Free Software Foundation; 
