/* ----- encode/953x2115, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_953x2115_checksums[] = {
  "d71ba40baea7dc3af48fd849985de05aaee87f3037871db8dec7cc901b40c8a8",
  "b47986841715d5eef14df6916c2ab184f33a698537113c3bf4d2ea8f99428c70",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_953x2115_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_953x2115_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_953x2115_ITEMBYTES

static void *storage_encode_953x2115_s;
static unsigned char *test_encode_953x2115_s;
static void *storage_encode_953x2115_x;
static unsigned char *test_encode_953x2115_x;
static void *storage_encode_953x2115_s2;
static unsigned char *test_encode_953x2115_s2;
static void *storage_encode_953x2115_x2;
static unsigned char *test_encode_953x2115_x2;

#define precomputed_encode_953x2115_NUM 4

static const unsigned char precomputed_encode_953x2115_s[precomputed_encode_953x2115_NUM][crypto_encode_STRBYTES] = {
  {100,76,181,84,250,217,215,153,21,226,193,101,2,163,43,180,170,132,16,239,115,0,8,190,137,208,185,198,213,46,151,97,219,8,206,120,188,69,203,123,95,132,182,114,145,27,106,254,38,40,242,18,167,156,224,205,167,105,237,234,116,63,190,198,180,125,236,254,171,27,7,146,87,112,86,73,121,113,181,201,178,241,110,102,22,170,129,19,180,247,130,102,41,193,228,8,156,176,61,157,208,44,178,95,155,95,138,105,251,232,249,99,249,158,243,95,176,21,154,238,40,217,115,129,226,206,159,48,45,171,95,205,38,227,206,79,157,202,10,84,234,255,206,102,174,241,133,21,125,173,33,22,162,34,112,126,99,225,4,27,120,1,219,189,128,156,250,45,92,62,172,186,8,5,78,84,97,16,240,164,78,97,136,170,24,99,167,71,105,182,2,118,174,131,62,154,65,197,241,116,202,169,28,15,61,165,38,229,53,175,163,196,53,113,7,181,34,98,135,181,214,11,50,78,191,199,118,147,18,0,125,176,117,237,13,35,155,234,224,164,166,47,69,193,83,57,241,154,114,78,169,51,243,36,45,21,162,214,251,233,26,5,151,150,180,94,66,251,194,64,45,67,138,128,119,226,43,242,161,83,241,155,142,130,181,178,36,197,52,251,21,217,99,189,129,125,134,24,213,124,209,221,22,132,41,88,38,46,174,35,181,52,88,22,224,159,63,68,233,47,201,164,94,118,198,13,171,112,213,31,34,51,235,10,108,54,72,227,61,118,30,254,6,198,181,173,122,142,77,219,87,107,225,92,171,156,11,41,145,166,203,118,193,171,250,87,160,121,140,104,252,192,121,5,186,42,248,181,146,78,138,26,232,44,236,200,11,81,78,139,10,232,238,124,140,158,181,53,15,38,155,252,190,43,42,71,195,186,50,56,160,6,77,119,193,79,175,135,54,224,6,142,132,207,40,63,180,39,96,222,241,253,149,184,156,155,224,192,65,189,252,255,147,62,91,223,97,235,144,58,81,205,49,78,163,21,132,181,83,130,122,141,74,36,232,192,4,202,92,16,185,254,208,55,169,59,86,182,90,13,226,228,77,144,173,122,7,95,210,223,188,191,37,16,87,199,222,146,163,128,170,47,174,16,28,170,201,12,112,224,204,226,180,186,49,217,190,119,72,6,217,145,16,187,37,207,67,195,10,164,246,93,214,190,157,186,79,25,143,140,255,29,240,123,23,18,244,152,135,205,43,142,202,166,8,131,19,153,188,249,249,87,247,170,205,40,218,159,15,161,222,228,4,152,192,135,237,247,173,15,60,178,44,176,213,29,82,41,46,54,83,103,36,27,49,33,215,3,177,210,107,30,193,86,127,217,168,253,116,161,4,178,99,86,132,62,69,150,73,47,97,214,83,122,35,132,59,206,110,59,142,11,229,5,149,219,106,228,160,6,247,85,217,118,186,234,39,245,13,169,254,8,45,25,27,119,222,181,24,24,237,151,30,185,0,197,82,153,27,244,17,78,5,113,254,169,183,251,249,23,237,180,215,35,163,105,7,224,189,189,238,18,21,70,121,235,193,45,180,22,220,73,190,192,191,141,99,217,248,64,189,235,47,73,218,152,191,6,253,62,111,146,3,99,69,40,177,33,202,119,128,199,210,129,43,247,168,13,43,224,239,150,223,217,136,107,236,26,57,11,30,30,217,132,161,70,208,190,34,241,104,140,170,194,57,149,44,195,47,129,1,110,47,30,74,42,203,230,85,203,177,252,86,167,34,70,85,30,82,196,139,141,73,69,249,71,87,130,134,227,89,122,231,5,117,12,99,20,233,246,242,217,185,140,117,39,227,173,74,151,27,55,182,172,72,82,219,150,67,254,165,133,59,31,66,114,87,22,8,160,227,36,52,184,156,206,14,198,24,89,184,67,203,146,68,130,81,26,4,156,68,220,88,39,94,240,125,142,70,169,8,83,43,9,40,5,167,178,169,208,125,33,46,117,194,39,228,180,198,210,242,176,242,107,96,211,215,131,178,143,65,174,49,239,119,254,86,173,10,235,133,126,125,226,112,233,38,36,175,51,135,241,209,9,251,245,73,247,107,224,69,173,8,127,187,142,199,57,100,74,184,232,185,139,53,178,63,193,65,29,44,90,238,248,236,198,176,100,2,33,254,87,162,235,204,40,233,181,161,58,22,251,50,210,194,88,14,82,249,242,142,198,130,122,156,163,16,77,152,253,162,67,232,142,157,58,241,143,21,84,179,32,236,224,80,37,240,121,227,13,130,235,31,112,96,113,203,83,82,55,248,27,24,178,156,76,211,231,224,79,15,18,221,89,253,180,208,144,190,85,250,66,145,148,114,201,165,221,158,32,58,43,66,32,220,163,18,173,244,86,165,99,205,78,157,52,195,38,46,58,19,162,33,8,27,70,195,173,244,155,101,129,6,47,190,193,234,91,43,45,59,17,19,142,130,162,159,240,25,112,194,15,66,142,220,185,9,26,43,159,67,74,238,121,59,47,152,159,194,217,175,247,85,114,50,211,251,246,104,176,248,28,14,181,102,157,84,200,14,179,169,75,130,227,12,228,235,229,22,62,56,231,185,68,134,151,164,104,127,157,106,213,206,115,218,239,70,251,17,63,151,30,47,120,233,184,229,77,124,117,213,140,17,65,79,63,55,48,246,139,29,116,44,254,168,35,39,70,133,83,154,220,238,102,215,82,213,224,115,239,175,138,49,195,187,48,207,245,133,176,151,30,222,6,97,46,117,169,33,117,56,176,47,57,241,144,246,137,186,221,235,37,1,157,226,188,102,170,109,155,108,224,196,213,37,177,137,113,165,111,101,16,59,183,23,24,8,199,246,254,190,239,131,84,253,29,218,218,163,106,116,137,195,177,220,79,14,108,58,175,85,219,232,68,208,113,45,155,101,215,80,154,246,26,98,230,121,97,23,174,5,218,231,136,240,75,249},
  {41,87,66,167,222,240,108,104,108,251,12,248,106,182,145,150,14,81,231,45,22,127,165,174,206,104,30,145,173,139,30,172,253,150,129,229,235,233,200,170,114,245,227,97,194,197,71,104,186,24,201,118,78,170,168,79,153,29,117,57,157,200,146,215,27,79,239,26,156,17,51,139,142,4,20,11,2,104,99,113,120,160,45,135,46,201,33,55,241,213,246,197,197,98,98,114,164,13,52,35,238,109,178,150,150,79,113,98,107,113,166,58,88,25,39,123,167,27,28,34,187,10,91,20,146,47,101,33,61,228,176,178,124,57,209,44,86,108,57,149,14,113,12,132,128,70,227,165,162,233,84,87,84,183,5,39,120,254,91,5,229,17,212,75,76,35,252,171,9,161,58,44,57,78,154,200,15,168,51,112,77,87,228,63,195,50,17,166,235,193,195,235,67,51,174,149,68,95,102,223,125,11,11,26,176,139,177,151,153,96,244,247,28,56,190,85,237,168,71,140,185,220,240,249,245,209,156,143,3,101,26,55,36,14,56,121,194,159,190,212,170,78,112,79,255,51,96,63,206,46,15,232,154,213,165,125,145,95,87,22,147,34,57,105,61,92,3,112,99,73,201,167,74,197,208,121,151,79,80,152,121,241,71,177,68,18,122,241,25,242,108,217,134,47,174,13,23,109,243,61,134,231,185,149,123,159,237,219,149,109,63,162,141,23,178,14,50,41,27,107,79,99,204,145,69,129,35,38,23,77,117,113,156,72,65,170,218,135,100,189,88,41,249,136,232,203,65,172,237,227,32,40,25,245,217,176,112,140,65,13,152,208,222,239,170,127,132,214,26,220,210,165,45,18,127,14,207,92,218,212,125,245,20,248,240,177,155,37,25,184,188,158,19,198,28,124,138,214,169,185,83,238,255,178,96,64,42,94,173,178,93,66,79,128,167,47,185,207,167,249,166,62,227,223,117,18,63,207,245,237,188,59,56,134,246,130,28,88,110,180,52,217,97,116,18,118,225,48,53,9,149,233,216,232,165,245,2,178,35,87,229,183,178,17,16,204,212,40,4,194,107,39,12,230,9,163,14,123,125,53,107,158,39,208,66,209,180,222,98,163,130,216,85,156,46,139,71,183,152,214,0,92,17,98,180,130,158,78,17,124,55,55,224,159,136,221,147,244,236,255,253,52,182,48,114,136,163,5,144,26,30,162,126,177,44,154,109,153,124,183,86,64,86,5,219,181,152,205,231,27,103,180,115,51,48,168,199,3,66,95,107,245,229,105,85,142,173,56,89,193,155,62,165,182,248,44,74,250,106,192,60,219,125,120,181,121,120,53,81,214,71,216,230,150,8,20,48,71,143,219,194,96,40,42,142,136,247,105,207,15,96,247,244,150,45,2,155,5,190,171,89,229,125,216,153,66,158,141,112,37,239,244,138,211,207,90,17,143,167,205,51,143,117,99,76,114,41,50,174,174,119,126,212,148,121,184,54,33,177,81,45,42,55,22,232,169,185,47,92,213,132,111,78,187,226,179,9,125,158,95,73,189,86,213,211,190,134,64,72,4,106,244,17,224,254,197,192,148,49,243,27,60,122,179,213,133,83,172,21,179,66,201,78,25,252,97,159,114,209,71,96,101,2,144,205,117,153,3,68,240,143,115,163,71,115,227,135,108,93,243,80,199,65,211,16,239,113,160,111,169,234,40,156,116,27,33,220,64,215,235,13,53,153,53,202,101,95,202,162,169,89,140,140,243,171,218,80,3,177,249,94,190,35,131,140,10,120,67,111,189,215,208,191,197,128,79,69,248,61,9,186,243,204,163,183,23,180,32,158,194,93,226,6,29,228,126,25,237,190,224,155,73,105,37,155,179,157,176,161,195,18,230,226,94,28,158,122,145,4,173,51,235,159,99,186,211,72,38,205,10,41,169,249,165,241,175,243,196,99,196,89,200,100,71,225,78,80,120,126,63,208,214,173,175,22,61,204,96,171,31,23,237,152,249,32,211,139,194,201,178,242,172,23,84,60,55,227,121,254,71,161,127,70,87,195,159,242,158,117,46,116,9,133,186,181,183,155,6,29,253,34,137,16,60,161,2,41,27,127,162,13,42,173,229,95,41,98,26,50,101,164,145,186,177,216,217,225,99,31,214,121,228,97,80,253,9,62,105,89,231,235,170,123,3,83,156,164,219,48,62,172,155,170,228,22,177,142,164,9,191,2,156,213,188,13,59,64,55,86,118,131,120,176,249,42,132,74,45,225,203,3,91,241,236,159,237,24,19,222,26,228,66,36,145,149,109,157,225,38,50,69,180,136,132,81,112,165,179,179,34,229,152,137,198,167,30,206,13,226,227,146,150,21,157,181,115,147,67,132,209,18,229,151,243,151,236,104,149,152,56,71,189,59,147,133,34,229,205,203,199,218,198,25,174,67,6,187,244,176,185,206,238,0,224,115,21,86,133,68,212,161,92,233,40,244,117,49,199,114,39,1,2,87,71,103,53,124,0,24,91,33,33,38,208,225,95,125,120,215,146,48,126,219,2,210,185,185,60,77,214,192,65,80,126,162,62,179,77,29,94,141,103,144,39,55,59,126,14,150,91,8,16,35,177,185,218,148,110,11,13,65,196,202,234,44,53,120,157,183,227,26,228,208,174,42,16,222,10,13,76,52,116,188,50,200,136,56,75,65,209,10,93,10,186,235,198,57,44,64,167,178,145,228,20,252,186,186,192,178,157,193,143,2,9,116,2,253,178,102,235,110,145,89,249,174,210,32,42,1,64,32,113,129,230,57,250,96,131,17,133,8,25,19,27,3,212,140,131,182,14,203,73,137,116,16,73,28,79,143,104,243,161,228,182,191,59,123,191,67,13,203,97,194,152,57,34,8,17,36,249,218,186,8,44,197,234,41,41,5,151,172,138,186,89,73,225,115,192,120,33,5,43,87,238,144,226,92,48,182,44,214,45,129,93,120,39,42},
  {122,84,189,60,193,6,58,159,62,176,194,43,56,228,78,5,236,176,2,241,97,246,81,56,163,241,112,86,227,74,66,217,234,133,159,28,5,16,65,222,28,18,187,240,243,101,40,20,214,68,5,195,234,207,131,67,174,252,175,143,130,149,104,77,156,43,152,163,104,248,2,202,121,61,24,76,142,3,136,26,58,200,225,172,253,135,211,253,30,196,223,119,67,233,190,149,255,104,5,108,118,57,185,11,53,107,209,230,227,63,90,212,169,143,240,182,66,136,25,157,183,252,119,213,86,22,177,131,186,181,31,2,46,229,193,188,183,162,64,239,75,133,142,244,40,52,96,73,85,32,109,82,205,133,196,8,56,102,254,147,189,64,210,45,145,103,134,153,117,254,163,114,195,183,225,156,169,68,25,247,28,69,9,98,137,52,63,185,255,76,124,30,8,133,151,189,76,164,253,139,225,30,145,218,208,194,41,96,252,134,137,60,110,198,208,123,201,24,140,155,129,55,243,90,193,127,108,45,73,212,77,49,95,204,171,27,90,110,254,89,24,22,159,223,184,137,82,150,6,62,255,158,178,167,167,127,161,24,186,49,82,192,234,250,127,242,14,121,87,104,43,167,211,193,204,35,249,209,84,202,204,137,22,138,46,33,113,30,198,137,127,99,83,191,233,226,208,48,208,200,63,23,247,27,164,55,162,103,207,138,22,10,191,124,100,234,41,164,43,134,229,14,127,72,199,95,229,170,101,159,132,46,65,49,91,76,6,216,208,31,189,25,122,213,180,62,28,18,112,58,70,194,199,125,21,200,30,70,175,126,231,92,46,132,140,133,35,210,68,35,149,115,50,49,6,215,71,250,72,77,39,48,78,196,212,231,218,33,31,52,180,125,129,4,246,94,55,36,151,23,216,81,119,186,252,37,238,23,46,37,58,218,142,245,120,79,86,126,97,234,251,47,113,0,145,51,38,237,165,207,252,170,11,32,71,167,40,229,80,152,207,245,188,146,18,164,142,193,224,139,14,131,91,7,22,158,175,233,217,80,169,91,117,195,161,87,59,67,98,208,9,156,129,139,54,3,146,100,151,219,148,41,66,58,221,55,160,215,14,226,228,84,215,157,121,183,93,213,133,237,136,213,92,188,214,245,214,206,240,64,126,216,233,71,8,46,97,183,85,212,22,85,50,159,193,134,217,198,50,127,248,238,36,221,193,93,75,152,99,40,232,35,2,147,70,67,16,226,196,105,146,143,96,213,247,156,195,110,193,139,81,170,147,205,75,150,119,44,177,219,67,208,134,143,56,41,10,207,149,3,151,124,105,240,254,43,17,34,72,104,184,85,235,18,75,40,238,140,240,46,132,38,184,53,49,194,32,108,236,180,52,0,53,130,219,116,82,99,86,52,220,43,53,2,247,20,206,89,193,91,221,239,248,233,240,113,71,226,56,87,45,234,0,1,166,56,207,240,198,211,166,52,98,155,179,37,187,124,111,6,120,43,85,222,171,117,197,125,106,183,149,240,252,195,78,36,49,253,147,88,70,110,174,221,194,7,185,11,49,69,132,86,201,213,36,229,188,48,140,209,71,72,173,176,186,58,194,67,91,94,77,80,146,206,33,191,166,224,201,113,39,136,188,229,146,223,100,86,122,106,18,80,247,202,76,172,162,153,57,202,62,227,99,0,132,69,154,166,10,143,149,223,144,157,75,39,13,104,173,69,240,27,37,167,204,202,14,128,173,56,140,9,200,86,189,27,173,143,139,40,133,198,107,43,224,201,146,11,228,34,53,6,53,11,56,169,125,77,16,37,107,111,240,182,16,112,16,44,86,48,167,229,43,186,170,47,14,28,159,2,30,164,148,103,114,203,148,135,6,151,64,153,153,135,117,110,172,140,156,235,105,133,174,96,29,101,155,176,125,140,255,3,205,131,158,192,250,133,220,4,109,38,138,175,123,158,249,79,123,156,56,209,5,21,12,215,81,218,206,80,62,213,24,11,75,60,218,114,144,64,240,143,214,201,25,162,111,111,40,3,148,189,164,185,93,243,194,245,244,142,206,202,106,202,76,80,167,249,116,63,57,35,137,32,163,170,64,105,197,25,136,254,43,10,255,53,249,45,40,9,251,39,222,208,77,231,191,62,245,192,132,194,137,57,195,119,117,105,235,88,39,7,53,183,124,249,206,116,245,246,114,150,185,112,133,213,87,153,249,205,99,226,23,79,64,6,192,0,86,27,82,50,135,60,216,9,105,42,187,130,125,25,25,136,6,161,198,251,177,176,25,233,227,130,168,248,204,242,19,139,248,163,88,0,168,7,82,54,125,160,187,250,205,123,83,160,141,216,54,66,73,9,205,235,87,88,224,107,220,251,156,28,81,74,209,118,199,181,153,212,154,28,119,156,90,69,154,9,210,12,240,145,17,126,167,97,47,72,188,175,180,200,15,85,50,220,226,245,86,208,147,28,110,144,146,208,197,76,15,26,155,50,225,243,233,217,87,187,19,6,75,24,193,83,60,54,29,254,31,80,238,156,55,102,104,215,46,55,47,110,112,157,165,175,222,237,46,194,202,22,212,216,129,164,117,140,39,67,28,145,26,140,28,162,11,231,112,92,47,253,182,90,163,142,43,9,151,222,138,136,172,87,36,166,24,38,192,108,40,56,97,58,195,161,0,166,148,11,152,99,224,21,136,82,59,251,69,8,94,19,190,57,192,71,171,86,230,200,13,130,172,19,79,198,50,90,210,24,16,52,127,84,40,38,102,118,170,47,135,58,95,184,199,77,195,228,99,43,124,14,239,189,167,82,153,172,98,231,196,40,174,248,73,218,246,233,192,47,171,157,59,113,203,135,236,238,215,123,225,39,142,14,82,76,99,164,13,63,89,237,201,91,61,133,144,164,72,129,28,38,21,226,114,70,205,211,187,19,160,41,71,39,109,4,13,152,249,166,159,186,245,20,169,142,100,5,120},
  {240,41,63,59,108,55,150,76,229,248,187,249,211,96,116,227,207,45,21,127,121,74,127,58,30,199,13,169,11,66,59,84,76,213,94,190,253,175,68,169,246,94,121,155,134,239,58,102,63,65,48,1,69,48,144,126,162,72,1,84,39,204,25,7,211,35,221,236,241,232,188,175,246,168,15,85,134,23,205,121,246,235,38,25,21,206,146,130,87,207,243,253,10,56,224,72,176,238,102,193,48,147,17,163,122,14,28,34,73,204,17,170,240,249,196,164,255,111,29,196,197,233,183,34,230,39,47,164,183,241,112,110,221,129,85,173,155,65,160,40,144,143,113,234,98,45,119,73,44,126,65,157,240,178,175,27,137,239,39,119,107,92,58,208,42,228,79,204,31,82,227,199,40,37,181,19,2,253,190,39,136,97,229,177,133,236,155,71,145,104,33,189,201,119,34,254,49,58,91,176,90,102,126,70,44,109,6,52,22,92,69,177,199,15,81,227,92,55,50,197,106,10,110,20,215,192,96,21,155,109,242,132,123,148,40,30,183,229,13,4,109,74,11,37,95,101,236,254,23,192,240,7,175,38,168,203,66,74,163,197,99,222,111,45,16,120,182,99,180,71,141,182,101,249,34,151,240,147,60,147,216,198,176,139,245,6,77,2,111,31,82,10,236,144,59,96,147,232,113,155,55,166,232,38,18,88,69,129,100,50,85,23,200,210,138,82,123,21,155,148,47,132,29,56,119,93,120,157,84,171,35,245,63,167,22,233,133,1,14,58,52,111,144,198,85,141,56,204,220,89,74,54,0,58,26,15,228,223,135,12,202,43,79,20,129,236,223,155,182,144,168,141,55,13,60,150,142,70,36,147,97,210,30,234,133,94,15,225,35,69,175,113,9,77,12,219,172,122,197,85,120,219,57,201,164,137,250,93,168,205,188,145,168,90,144,66,142,242,36,13,188,69,71,147,118,238,198,92,130,233,57,183,65,238,66,246,176,93,83,135,230,22,29,143,3,87,180,195,177,95,245,14,120,15,195,22,199,32,175,38,29,175,1,135,75,205,202,128,237,7,16,131,238,54,108,241,76,142,244,36,154,65,12,230,81,78,28,96,125,65,24,208,150,9,0,84,206,165,157,70,170,111,175,17,61,61,94,200,245,150,33,97,193,116,56,241,123,253,95,190,76,193,40,215,196,208,134,255,163,252,154,241,26,187,111,86,192,248,164,205,3,95,29,110,144,168,98,165,130,45,135,196,114,127,224,243,219,196,216,215,231,42,200,2,150,238,100,164,0,37,186,130,252,56,120,220,198,209,100,249,100,43,219,243,134,210,190,36,40,179,165,49,48,140,83,179,240,38,103,113,213,31,194,181,230,173,90,232,57,48,161,238,197,230,111,165,237,236,184,226,141,3,187,236,65,219,213,142,222,80,119,236,160,115,88,51,172,59,230,43,154,0,58,230,217,179,240,253,245,248,76,18,186,70,62,88,97,25,172,238,155,238,194,144,175,109,176,199,70,60,194,169,131,43,68,151,92,141,193,205,161,77,203,232,59,70,106,214,169,200,208,117,23,122,252,190,121,71,233,212,142,16,218,53,162,103,2,189,65,183,148,175,96,170,190,137,162,209,44,72,238,82,216,123,126,126,78,39,230,204,55,13,243,155,185,245,104,211,46,56,33,136,2,34,193,155,214,132,36,224,218,205,126,119,151,33,242,47,41,219,115,31,98,115,2,119,163,32,99,141,3,171,18,69,152,133,153,1,129,19,99,172,122,22,21,153,227,195,251,171,240,135,168,116,250,205,165,186,213,10,24,113,133,1,70,169,73,220,179,60,253,64,87,81,167,27,52,154,21,222,110,51,172,106,102,170,48,61,197,196,98,167,45,229,94,18,111,247,141,81,170,156,132,24,160,0,245,93,144,139,4,239,78,99,169,127,20,53,237,211,126,121,107,130,183,109,171,113,232,251,231,128,212,126,46,158,180,17,80,126,174,91,121,29,166,253,248,138,155,95,69,85,153,224,64,43,138,187,193,111,167,55,215,13,118,37,92,6,214,84,0,188,229,8,41,36,82,136,71,218,222,198,15,14,35,143,19,38,179,66,28,150,202,120,185,227,223,179,190,143,124,135,203,83,40,16,168,143,151,6,175,115,223,133,45,38,64,4,176,126,73,111,86,117,122,95,166,13,85,40,121,105,20,59,208,199,208,180,41,47,129,3,59,4,212,213,239,66,196,201,149,204,25,25,45,0,183,47,214,156,44,159,33,122,120,69,70,48,119,80,208,102,69,215,167,201,214,129,160,110,203,89,215,125,13,152,10,136,116,135,45,165,180,151,27,158,23,221,39,158,238,116,204,137,56,255,217,42,63,70,71,211,15,134,138,200,34,141,106,243,7,159,82,3,19,72,45,53,191,212,126,113,116,113,31,70,61,1,45,209,25,119,77,16,165,65,155,232,119,142,223,221,78,246,133,0,208,154,53,204,55,126,148,67,37,241,246,36,68,194,14,177,86,19,149,119,4,84,168,252,195,42,83,101,42,115,155,170,236,80,89,234,230,92,73,107,64,248,196,71,221,117,42,236,226,124,159,81,2,205,95,116,98,189,81,205,181,198,111,22,145,150,11,78,101,29,214,25,19,218,226,115,13,217,166,190,217,131,2,52,192,72,100,96,92,181,181,121,154,61,246,131,95,95,213,38,121,70,145,99,167,16,19,54,234,211,6,139,77,151,57,109,39,244,171,160,14,150,251,135,58,198,184,215,61,161,194,11,171,141,18,231,46,16,100,224,218,25,221,243,236,151,179,101,253,49,244,68,131,85,64,35,5,134,4,246,217,107,20,189,27,188,10,49,174,45,249,247,67,119,222,195,26,17,15,183,122,5,167,191,106,116,121,65,119,69,65,77,225,66,133,206,18,139,113,45,87,210,227,34,52,49,156,209,153,63,194,24,141,153,25,219,10,79,8,223,57},
} ;

static const int16_t precomputed_encode_953x2115_x[precomputed_encode_953x2115_NUM][crypto_encode_ITEMS] = {
  {-21081,-29781,3214,-17854,-28387,-4605,-21570,-705,11749,13383,-5466,-18873,-17964,142,-26564,22293,-7112,-28459,-12321,25475,-19135,26692,-2302,-23228,31550,-22755,-23432,-18930,277,27638,-7626,19565,-23488,30338,-11261,15392,-13979,664,-26227,-26045,-20676,17437,-14462,30194,-6990,32020,17553,-28319,-6281,2044,20014,11893,13002,-26313,-11386,7962,1041,-28280,31479,-21352,32609,14631,-26026,-32523,-8897,23667,-3881,-3295,6595,-23662,20183,-8815,20734,22825,15638,6988,2965,18458,-20282,26480,21163,26871,-21425,20774,9935,23589,29399,-23669,30691,9189,-12462,28771,-21358,30220,27159,9561,30162,15230,-10401,-15505,8811,23636,31812,-27538,-13760,-8274,8076,10434,-20072,1647,3204,-18869,-2167,27401,-18014,-10224,-25986,27162,2927,-6455,14230,-28236,-24661,2914,25295,-2171,-6474,-7180,4688,23312,-32071,28532,6907,26214,4837,32318,-30101,-8606,-23213,11542,-20535,17018,-28874,-10504,3475,31078,-24984,-23199,-23607,4044,11558,22418,-16086,24381,-3903,-23442,8511,23052,17880,-32304,8548,12629,2093,14302,8187,-4909,-11109,-27558,-15393,-23088,22015,-20907,-28176,13002,17456,-9113,17447,31741,21145,8507,-28317,-8832,23104,-18940,-30934,14641,-31073,9774,13541,-2917,30081,-20929,-14996,-11234,8027,3015,-8099,27318,-13893,-4177,30922,15599,-25390,11517,-10080,-32443,-19806,-20989,-15896,1169,-3870,15510,23222,27660,2516,-5827,-13814,-29306,-25861,15878,-28419,5291,13071,-13397,-1884,10288,-28211,-31612,4703,2033,31274,27501,23130,-11477,20483,-12109,-24734,1186,-4716,-24917,-32298,-21049,-18723,28623,16733,-16932,6393,-1445,-1943,-1098,-12399,-5130,7901,8551,-27419,21491,-12565,2855,8418,-9343,-26382,27526,-12995,-4630,16152,13246,29779,32293,-3284,-1295,21688,18626,-19411,23671,11777,4063,31311,-28787,-20134,-24852,1245,4880,31905,-16534,7259,-12800,-10698,58,4097,31451,20774,-21733,1385,31060,9328,-20839,-23114,-6352,-1610,19114,1941,-5625,19394,-19415,11336,-26523,2188,25034,-20535,-29890,1925,-8848,-32605,21215,7915,-8626,-25335,-15538,-23834,2885,8820,-12341,6456,9139,15358,15448,-12912,7651,14188,-14802,29446,17502,-17173,-29520,-23958,-14798,5019,-1605,-3245,25056,-21045,-16679,-9330,22483,25972,-12618,30017,-27892,17443,-29912,14893,-24187,31562,-29584,-18664,2464,2877,20105,14400,10275,-778,-5939,-1121,16435,-18135,32510,-11159,-26416,28490,14917,7969,17369,6242,-11563,23072,-24958,18850,-2176,2670,17236,22553,18238,-17150,-5596,2593,16073,-29068,-30984,-5494,8029,-15628,23242,-17056,-24181,9163,14940,11298,-27653,1797,25588,16518,-19092,-23393,-3835,16754,4011,14620,-499,-10215,22248,-32423,21673,24695,-31625,-21549,-19741,3599,-706,-1693,-22936,24410,6545,26296,-28712,9515,24385,-12794,-14522,-24660,-4976,-25624,11233,5418,-22396,-5133,-32078,-6938,-26671,-24880,14394,22150,-31946,32282,-18509,31641,1745,24921,8066,32329,-15071,-470,6572,25717,16582,-13116,7712,29274,-26118,25075,-29761,-6254,3846,-25635,-7554,608,-14372,26250,32361,3218,-29335,1845,-19186,23477,-28206,-5981,-18980,-20636,-15034,-27170,21582,9371,-7765,-1964,12314,9424,2724,-28320,-17478,31035,25938,-30021,-10841,10521,25391,-27486,-23692,26049,-14394,-10989,21529,-32288,-4664,-13884,-5142,-557,14483,8732,-31383,-13114,-18453,6636,9828,27951,28705,18688,-9810,13389,-32734,7994,-12771,-32232,-28636,-5151,12973,-18061,9362,-27395,15233,-3356,22096,-28717,-4372,29958,20348,12286,-28070,-24338,11987,14423,18842,2915,-14990,20867,-30506,17283,16938,11472,-18112,4296,-7957,-19278,-2004,-3768,-24357,23444,-11051,-31027,18379,4266,-12310,1454,-6511,-12201,513,2604,-28953,-21471,-19037,18166,24891,28445,31719,-556,-6021,-10996,-2567,-29797,-2804,-23384,19441,-1618,-874,-22590,-11224,97,-18893,-17028,933,-25712,19642,-19478,7000,22406,-30262,-9450,32488,-1445,-27850,7305,9451,-4887,32111,31818,14268,10269,28252,-24619,19529,-88,10831,10637,-10199,5716,-28753,32493,-28388,-18891,-21753,24230,-12849,8845,-2726,-30053,9608,-4479,-24928,7273,22208,-8601,-25975,-3651,-23114,-11907,23439,-28193,6110,3803,-15755,12694,31637,-29980,-16365,29681,-19814,27633,27795,-26117,-21445,22054,13736,-13183,27344,18543,-20964,-29741,6631,-27165,1169,-25698,5664,30844,-27797,27092,-1623,-6120,8608,-3945,-5284,-2232,-9984,-19146,22630,11223,-346,-3083,17088,27909,21107,25443,26602,-10634,16623,-7596,-9692,-10060,12387,8865,31161,-9007,-3873,-9198,8080,-20540,4006,-17067,-2341,27919,-11271,7821,-22269,29513,-10238,-8513,893,24888,12586,-1884,14035,1864,10888,-14693,-30648,16123,-19644,17165,-23149,-16897,-16857,-32078,-5868,6199,5337,25011,-21498,17097,12182,-685,-24492,-25473,19017,28662,-31040,18512,-23157,30715,-24044,-23286,8077,-26056,-15573,7312,-31704,1784,-8694,23044,16409,4208,30256,-30104,32575,-5291,15913,25193,14558,-31423,9309,-9480,7119,-7865,12809,20912,-30593,-29774,-25087,6086,17355,-29552,1082,-10825,31406,-26556,-13847,29179,-18620,18561,12274,5709,-25446,-4551,-17815,8359,-7475,-25115,-32164,-27720,28110,-26737,-20872,16911,28064,-32319,-32078,12916,-23372,13285,-24385,-24672,-12726,2851,7693,19467,25618,7522,26970,23377,-23017,22440,29695,-20496,16363,-27970,4529,-32081,-16623,-10027,31468,2071,-20819,9755,5525,23978,3445,13161,-20080,21115,24860,-32215,8223,31302,-16024,5159,19116,40,15082,-18645,8305,-21572,-26175,-5036,30206,32111,-2694,-5247,-2832,16129,-32145,31499,-24527,-21065,-26153,25666,-11170,14251,24143,-17563,6731,15597,-23660,12601,22746,8054,-23036,-24768,-22358,-30921,-3853,-18858,-18574,4437,28796,25526,-18787,-10866,-30918,-24254,-23856,4692,22665,-20242,8984,-8440,31651,-28608,-12544,28698,29304,3199,-13450,18800,24350,-2261,15136,-14706,-1089,22574,14030,26670,-23440,-10722,-29105,365,517,-16211,-16588,28890,22316,10086,-29839,4968,-4786,5249,-12819,-30183,348,-14118,-26374,-28865,14989,-6732,28380,23992,23709,-16807,-7652,-4143,12809,-28995,-23394,21804,9177,-8865,-1160,-23298,-16910,-29675,5618,-28255,-23835,16710,23092,-25840,7601,-22949,-23252,31985,11767,-15516,-14374,-7266,24096,2190,-12273,-6600},
  {15043,-10971,-16963,-30209,13754,20552,3229,-31627,-12479,-20140,-14102,-18352,28403,-14848,17759,-9275,7538,-18692,9132,1023,28928,-22977,2230,15228,-31253,-22702,2926,24140,5441,-25388,20930,-15311,-32021,17728,-16268,5465,14587,-12033,24415,-22960,-27537,-10080,124,-17288,17847,21465,-7537,-24193,7556,5666,19084,16321,21265,-3599,12547,-2034,-2606,-16198,-32068,-3640,9825,21648,-23618,30694,-1523,15379,-22649,4734,17776,-26358,10293,-14583,-2121,-19763,-32128,-14531,-23693,8110,2022,9791,17371,-30676,8945,-58,29422,25456,-21855,6697,8323,-5353,-24899,-4429,-17153,7556,1060,-1922,27252,-16580,-18340,-28675,-452,-13565,21164,-12811,28609,21417,-3846,-26148,840,13903,-30364,21505,32277,-24774,4923,17532,12492,-6817,-4407,-24128,112,2130,-5493,5289,-1144,32588,-8772,-17222,10614,6761,13067,-28629,17191,-20115,-26036,2699,-6756,30282,-32506,-15969,-8879,26821,15535,1061,22414,-12190,-22846,26932,30144,-27765,32248,-4928,-15314,-9172,4456,-16010,-24858,-19094,-16926,5198,26082,-11838,-1002,2526,3587,28189,-20599,-19615,20926,12315,2365,-25885,-31413,8755,20646,-18740,4549,11295,11987,14550,5988,14077,10693,-15819,5128,2514,32662,24243,5199,-21278,-1592,15250,734,-31924,14647,19310,-1895,22266,7593,-26753,-25125,-8120,13385,-21520,18358,20699,-21140,20235,-28427,-9298,-24915,5559,5059,23363,11474,27274,18387,-8433,-11439,8405,-30884,26305,28543,2585,-21855,-4611,-11833,-11605,-10386,-14222,-31876,-5777,-2136,554,-10955,-20187,32602,-13641,-28311,-15762,-26034,-22621,-17478,-17573,2690,-645,25631,24850,21332,-19751,18462,21848,24974,3688,27049,29824,31973,21334,-7966,-29987,-30335,15268,28567,-10599,17988,22820,18222,-23909,-5700,-14793,24899,23217,-30716,10843,5802,22272,32127,-20758,22922,-22966,-21026,-13523,-445,3865,-5618,-29058,9478,-4320,27831,-3088,-17725,-12503,13150,-21147,-31528,-6259,24583,6440,22547,13417,7756,-17429,2199,-4071,27471,-21944,31009,15990,21313,19942,-9346,-5741,16261,-653,-19886,12073,32369,7348,7812,-1557,13854,26265,16613,27581,-32020,10634,23368,-22265,24171,-8655,-11256,16133,-6912,25413,-30180,-7967,12335,-3127,13021,-3411,-13531,13598,25050,-7890,5400,22300,11692,-32442,-9395,19985,20204,25125,6261,28078,-29715,-226,7764,-10864,-24896,-30082,-13211,-4236,21593,18131,-2299,31782,19592,-29355,20925,-26194,-5729,-6671,-18559,27070,-28111,-32403,19209,5598,3147,18493,17476,3983,-28299,25663,27837,-1533,-7718,8271,-13239,-1153,2342,12780,-25328,22112,-30154,-28367,-4732,-8422,-18744,12794,-24314,-12593,10698,-32626,30354,8193,31773,30002,-28921,-32343,24538,-11077,4019,32337,-29680,-14241,-16659,-8045,5415,9558,11120,-20119,-23226,-18829,-11557,19817,-31326,-3493,22381,-10270,31046,-5961,-25175,-25390,17480,-11514,-1909,-32747,17321,30963,-27149,-29728,9449,27473,-3457,-30790,32541,16299,23758,-104,-11404,-22379,29973,4536,-25644,4444,-31086,-14193,-4524,30831,-28823,-2177,26369,13680,-25589,-2637,10706,-24032,14978,14678,-2633,24663,-32759,-10362,-5868,7573,-29660,-29761,28813,10506,-31535,-9460,13320,-1886,13471,-1141,-30828,-18452,-16985,-26583,11779,-30102,-27829,1251,14314,-8162,-15000,54,24438,-1702,4814,-13574,-178,6346,29271,28778,-15857,26347,-29322,-22511,-10185,5026,4446,30674,9373,-23407,28594,4905,-20791,-15472,11524,11064,-30351,10509,28117,27943,21708,-10447,15524,-23380,-25902,13547,-18064,12140,-26529,30857,-22063,32249,-23234,5070,-4919,23270,9617,-15282,-2759,-6289,-31626,31065,-13082,22423,-12695,-7594,-27113,18898,-28368,-18381,-30178,-9050,-765,30654,-24867,10206,-7511,-6507,9921,-18393,-31967,-11170,-26614,10002,-2468,-9586,-13404,4608,30234,-830,-963,10119,-2636,-18091,12302,-5258,-23979,1609,13585,24599,30145,-19744,24739,20910,-12693,20726,26794,4501,-13647,180,28680,4842,1866,18589,-16692,15014,-8749,-19659,-4653,-21114,-18582,24592,-7588,29784,-1895,25110,-5149,3664,-10501,-30272,2427,25392,-18911,-8059,6954,14408,-6627,11591,-4,-15720,15055,9431,3503,16479,25397,18224,9698,7591,3636,19471,-20025,-14024,-23422,-22856,17141,8499,14489,-23446,-7225,-29861,25648,-21609,6600,979,-26262,-23811,6211,-9094,26765,-11405,21588,24750,11239,1036,4967,2420,-16147,-28122,21220,28889,-26320,14992,22351,6292,10145,-3253,-4866,32075,-27826,23409,10367,20039,-11148,28490,15342,-31966,31770,160,30551,-6286,3790,1684,5232,11700,-14985,-13612,3944,29676,-2098,9080,25151,-2284,14235,5563,-21159,3258,16937,30590,-12301,20418,-10373,16061,-17712,29454,-18928,5454,-24340,-4399,29917,25521,8799,19944,17337,27088,17353,24218,-18127,31044,8376,32610,-28401,-27480,-7040,14040,3006,29731,-22557,17046,-12197,6205,-14873,-10036,14535,12163,395,-25269,7308,-13255,18446,11231,-20851,20330,-10773,20895,81,6604,18545,-1272,-9870,23260,-27855,-8845,12893,20172,-25970,18993,-26936,13695,-28267,11178,-10863,-5077,26236,-32628,-21945,-23809,25116,17387,22166,10850,-898,-22087,19134,28825,-17118,-15024,-20934,7097,-3554,8726,24786,-828,16150,58,-5198,-22204,-17629,-24804,5118,-10606,22831,-32226,-6984,14140,14122,-26647,-21668,23956,23770,21399,-15218,21869,4793,15326,-22109,31161,11545,28092,2916,13142,23985,3696,21885,18961,-8757,-4565,18298,1768,-921,-10100,11816,10551,-16649,-4425,7156,-11202,16110,3836,13552,-21751,29064,4406,20577,-30579,-2031,-27116,-26800,-24936,8709,25183,29696,-8572,30242,14613,23176,19406,-615,24708,3662,31146,-15891,21835,24187,-19209,9541,14953,-11757,-9958,5345,-1751,-2650,-25855,-7395,-23929,-3826,-9164,-2901,-4431,24226,1308,30577,17059,-24405,-22266,15552,31913,-27483,9652,-20860,-1892,-24392,24993,-847,15138,-5907,25356,14419,-6044,14866,-16653,15028,-9565,-7814,19091,-5324,-18119,6478,27092,-27626,-2931,4422,3948,-795,12092,17858,-9979,30465,23043,-20799,2653,-28963,-8028,26807,-9335,26309,498,-2153,-18788,13225,22138,-29248,31184,-9065,-5836,9563,20566,18458,3511,17607,-17402,10212,27346,-10687,-23357,-32653,-11974,10414,-26584,-12794,-27030,-13860,-1836,19812,-13531,6283,-18361,15432},
  {32672,1879,20050,15092,-25712,-1777,-2750,21453,2321,-9546,24045,17222,-23207,-31677,-16525,-18437,31619,30311,-12218,26962,-30909,27060,-28421,24293,-5726,30144,-5942,12566,-31707,-449,4097,21098,16702,-24643,-31084,1580,-3260,-10261,19879,9457,4219,13404,-11381,19062,-7577,-16454,-5813,15075,26259,12280,2834,-8237,31253,3039,19772,-11816,-23281,913,-14205,-15787,10728,26183,-23609,-9863,18541,16201,-9347,4971,25014,11882,30714,-10837,12571,-13032,-13279,28298,-27559,-18812,-1225,-13409,-14075,-19786,26722,9063,26730,-10494,-20401,31542,29363,4980,8574,17715,14686,-22282,-24729,-3516,15618,5883,24807,-11062,-7242,-29045,-28333,-27664,21577,-31442,-32074,-17242,-20424,31565,22279,31530,17146,-23897,-18393,3402,-27785,28227,-14952,12410,-9909,30150,-9632,31531,-26186,-4864,-2775,19211,-2857,26480,-26757,9097,2825,18687,13448,25554,-10545,5530,9689,-13153,-1462,-6865,16152,-11752,26486,-4483,-29313,9309,25429,26700,-16841,-9022,23401,-15512,30240,19725,-898,20128,-6204,-14022,-4437,6701,-23442,23914,-13121,-25585,5994,-11787,1904,13303,13725,18647,-2856,-11401,-18334,25449,-9590,1869,4150,25200,12347,-22905,-7813,26910,-16499,19181,-8970,-30762,-27317,-6238,-9266,-2699,-2100,26370,8755,13741,-13151,-13548,-26647,130,-23962,18982,-17710,-18360,-17539,28621,29999,768,26653,21531,-6355,-17865,-7366,-12051,13992,-13654,-20817,1014,7020,-20828,22197,-10707,-23114,3551,30189,-614,-18569,-830,3750,7780,-8729,-10988,-12794,1455,9286,-3376,19301,-436,-5464,-31356,-19584,-12118,-8618,-26752,25882,8216,23399,877,-4789,-21141,29747,28330,-3241,1809,21713,-21579,18476,21029,19927,-6246,32398,-23413,20421,-20697,17094,1935,28293,-20470,32633,-2112,12907,24795,-15419,18768,-30351,32675,19142,-9441,7408,-30292,32427,14842,-14942,-29198,-7371,-2512,4119,-25519,23148,-11978,-9027,32232,12858,-24815,20074,15895,28181,-9039,-7624,22949,-19743,5382,19129,32672,7919,19922,-5240,-17570,-32599,-27245,31515,3062,-11721,-23254,-23773,-9621,-9527,-20359,32418,18654,-23990,9845,30420,-24756,26360,-15994,13471,17646,28455,2922,10381,6974,6748,-26443,3487,4942,5670,2017,15305,-16010,2156,12268,19223,9732,-32202,3636,-29593,30904,12067,-14984,-14639,18301,4416,3844,-13740,15330,-9778,-13118,11110,20597,-579,18916,14682,18466,-17478,-7049,-1281,30604,-22245,4366,27916,-24562,19962,-13498,-16433,-32236,16980,-7939,26405,5497,-28518,24475,-22075,-31969,-28787,-22750,-14256,-4207,-23303,-3831,-3335,8117,-7413,24272,389,-22799,4297,-27748,4158,-24407,-14071,3923,-26072,-12613,11573,15080,-23309,-6629,-30944,-31094,-11550,11499,28386,12714,-16336,27558,-16931,-6774,-12352,-11105,11159,-9038,16587,-9238,-29278,14531,-8484,-29349,-19411,-11948,-31709,10649,-20022,32111,3525,14572,24834,9829,4886,11570,-26471,31450,32417,-26962,32520,-26397,20523,-4056,23977,21625,-312,6450,5426,23625,-23094,-11974,20231,21289,1456,-21968,-13138,20588,16434,-18462,4326,-259,-20822,-24021,-12666,-18551,6438,-19804,20562,-24178,-19750,-23487,-32584,-31535,417,13385,22631,16943,6192,17135,11830,15924,23657,23141,-1657,-18637,-13463,-17389,10963,19214,-17293,-6940,-23578,-13532,-22320,-15385,-8632,4524,28531,-10104,-27064,-10266,3910,-22853,17527,11631,-22392,20536,-29737,-30989,30777,-3364,14286,13465,-28807,-8790,-155,9222,-29626,-1257,26390,21624,-18608,26301,-1281,11097,-3531,29560,-28647,-24893,11033,13984,-26673,-29288,17720,-18332,-14405,-15919,-32740,28791,-1140,18816,31371,-12130,17862,-12267,21521,-19041,-27303,63,8290,21353,275,19110,-20481,-16257,12715,-5183,-4749,7402,-2924,27864,-5228,20847,-18062,-674,11269,-13165,22866,25811,25214,11063,26110,13469,-27115,-22091,16502,-32082,2674,30891,19351,22431,-22551,29698,26808,-16268,24459,-31821,-31588,-8673,31684,563,7628,-706,-4895,22519,20889,16293,-26761,4002,28065,14392,13241,4213,-30857,-5267,8104,5285,31633,6636,8509,-3899,-8552,-17572,-7966,-25700,3387,21873,4770,10491,32394,4272,24807,10709,-12026,26259,-22005,9366,15231,10485,-21976,-8737,-28530,28353,-17940,-10693,-26717,19337,12456,-31482,-27202,16484,11227,9645,27741,22393,26355,-17496,-29862,19031,2050,-30906,-1166,2173,16235,-10721,-19039,-4759,6080,23144,-31106,-9475,7717,-32458,17004,17370,13453,30243,13050,21178,10269,-4115,2136,25575,-14463,-13296,12329,2997,6621,5644,25425,-29061,12171,19998,27408,-28205,-25822,2806,24157,21095,-6810,1834,14125,-24023,23246,-23782,-8734,10703,-13035,-26673,25536,-4852,11570,-6801,-10029,-6510,-9953,-11348,-31137,-17807,13363,-11954,-16693,-30837,26101,25056,-18341,-27151,-2573,-14636,-21567,-7303,-21662,-27732,10282,-14316,29156,21229,-9189,26391,14549,-15122,-29648,7760,13364,-9627,-25703,26119,-17174,-14999,12924,-29972,-13987,-17544,-28829,4965,26984,-23034,-19762,-9185,-15116,27171,-15006,2814,22049,-2871,14330,31002,23542,-31793,-10699,-18462,-9174,-13657,23265,28661,14717,19446,-14455,8385,8041,24003,-19090,12593,10833,24750,24522,-1430,-11427,26613,-6539,32269,18178,-24967,19321,-17778,-32662,-20784,27378,-11934,-1776,12230,-16637,-6512,-28430,5672,-5695,31676,25939,14205,22871,20314,27324,30350,23478,31192,23833,30513,27811,14855,29956,-14704,988,18243,-31066,7334,12739,22469,-11205,11922,8179,2569,22759,26181,-16913,-30027,30728,-26587,22434,19767,-5394,4578,381,-9557,-13843,-8503,22927,17440,14183,23753,17943,211,6253,-29835,6064,7381,17147,-13697,16125,23394,-2578,-4426,-19399,14563,-29695,-8678,16027,-20959,30290,20993,-21922,-29286,6433,11543,24208,11848,29165,-23598,31039,12547,-13209,-22106,11771,-21828,-20302,22160,28699,32178,-10256,2778,-4974,-3154,30790,24875,32231,-3264,-4807,27483,10236,12607,-31056,25819,19783,32703,10982,21016,18432,20902,-29749,7028,-2199,12536,5730,-10359,-22983,-10955,10037,-32711,-5864,15605,24109,10426,-7488,22222,12085,28660,-27406,3067,26985,2040,-600,28521,19726,-14686,-6637,4177,11163,7420,-15833,-31567,22176,30449,-24543,-23936,12115,-14818,-14491,13506,32421,2575,-5760,18870,-26341,-18978,9851,28894,-10974,-1801,19332},
  {-5169,-14060,-10481,-7731,-32500,27921,4442,-21876,18619,-17607,-22686,-4967,-9693,-28006,-31791,19245,-27878,15086,1596,1149,10467,-6890,8893,-27929,3729,29761,-8893,-14198,-23815,-12193,5973,-30798,103,-1049,-24559,-4246,-17726,13369,-11946,-27141,-11473,5133,-27451,-9461,-1494,8629,-28527,14642,27416,24478,-181,24555,-435,-16750,-11619,13721,23967,-28479,16014,1787,-6103,-8704,-28056,-15372,-18204,-2320,-27529,-3575,-13549,28540,20842,-2645,32361,26940,30944,20589,-19885,-20228,-16246,-20836,-15661,10113,-1071,-31095,-5926,-23693,9570,-7336,8640,12051,11934,-26650,917,11350,-839,23093,17206,-27300,-27086,29756,-4137,29436,-31694,13736,12714,12072,29798,-28490,-29072,-15113,-30580,1909,13760,-4777,-23011,26190,16213,4214,12803,21550,-12731,21569,9571,11711,-1915,-24861,447,-10664,7578,-25257,5413,20129,3994,-31897,-18214,25267,7312,5586,-17996,-14985,2079,23767,-1308,-28510,5421,27728,-2032,-31078,-7841,6539,-31650,12874,-2389,-25461,-6911,29208,-31724,-855,-10187,3284,-32588,-31444,-22391,-19020,30293,16736,27221,-25551,-18113,-14691,23483,-15582,-21234,-4766,19219,16194,-3172,-28790,7870,10877,-16371,-3903,23100,-6109,-25097,9924,4531,-9677,-11565,32328,-20284,32540,30929,-10774,-10037,-17699,-23153,-12567,30749,-18375,5717,26726,2457,24393,-12297,-5481,-30847,-25790,18741,21889,1544,-24257,-27830,-8491,3045,-15848,-23848,-30531,30406,-24061,9949,-11469,1128,2228,-19140,28714,2639,17775,29150,25145,-12894,-28829,-21524,8404,20111,23820,-6027,-24520,9231,7238,-8810,15374,15668,20663,24915,-9856,-3881,-3294,2231,13165,-22203,-7380,-11142,15641,24283,26203,30474,-30148,25408,-19487,22419,6852,-31998,-6805,-24487,24966,-2477,-13010,-11169,22438,8997,30868,-26419,-24417,30408,4787,12134,-9376,-27259,23116,-2832,3782,25661,-13096,-19523,-7094,12934,18226,14922,23637,9001,-20138,10171,16234,-16052,-2486,-25946,-31954,-10912,32718,9050,-27795,31823,-3551,-11201,-26800,28953,-4826,29398,-32209,28002,-16207,11382,-17997,-31225,5317,31913,-20778,-12345,9431,-1003,1338,-26234,28567,-16530,-13851,-23307,20515,-22662,8040,-24736,9836,-20322,-23801,-1995,29868,-9090,-15934,11855,24477,19519,-16356,1565,31619,1243,-332,-1051,-10093,21287,7735,-10727,-21141,1031,12837,-16910,-16760,-2717,-28886,-26670,3987,10556,-18615,-28860,15543,-31104,25941,30219,25262,28301,-28176,-247,-31239,5847,-18345,3290,-4814,-21662,-20394,-14246,-29286,15900,-19201,11475,-22103,-16073,9692,-5594,-19200,-13408,-3264,-2703,8304,-4817,26806,-8739,18772,-20127,15667,28140,-22157,-4946,12241,20949,14213,18868,25252,20980,30650,16356,32367,-9946,-21481,12383,7173,31946,-8096,3799,31448,-20290,4450,25300,7260,15667,-26125,-9732,31817,-14364,-16734,-23667,22311,-18616,-22113,-14942,27614,-25956,-27487,-17570,29817,25176,7005,-4752,-193,11299,-12445,-3925,-19066,9970,-15306,22720,-21779,23824,-11839,-18287,24561,-641,-747,-257,7067,18756,2327,27655,9901,10800,-5009,31416,-15668,5594,-4544,11687,-24972,-8336,-2476,21326,15740,26957,20453,9808,30852,-29463,-16476,5742,-25507,7404,-18266,29943,-261,-5121,-19920,3221,-22904,-29893,-4330,30267,13588,31438,19194,-27340,-24263,-21617,12374,30349,15949,21307,25860,25984,13115,-5447,10653,4284,-12065,-24806,-5953,30169,-28831,5372,9463,9667,17761,26777,19411,-18864,31619,-12337,19423,32518,-13996,-12717,-23299,10497,-203,6975,1281,7093,10650,2446,23932,-12699,20274,-30554,-28802,-1830,5603,4200,11554,28969,9897,8504,14476,-3383,19730,31463,16631,21219,30757,3675,-9708,-18392,-15113,-14761,-583,-21073,18986,-12470,5101,7270,14875,-1822,-14846,31839,27634,18436,-3125,29978,25690,-17559,6206,18032,-8419,4607,-22557,-9355,-31558,6190,29962,-12502,-587,-23634,7062,31590,-10194,16218,-25509,22738,6823,22022,28984,-32464,-11640,16338,5236,13231,2604,13462,10189,-5870,-6670,-7742,-4137,4658,-15449,-22172,8529,-15292,-1323,22572,7391,15505,22223,-14405,-31583,-22000,14789,17264,10580,-22274,-10091,20694,30391,2261,-29590,7369,-22564,-3514,23196,-1732,-22442,7446,7351,2374,22989,-13889,27993,29484,-27032,-10344,-3783,-29703,2033,-29888,28082,-12109,-2888,898,9867,-10890,31764,13315,-28771,14244,-14542,-25844,-3947,-27240,14284,-5554,20499,7989,32455,30603,30548,21466,14944,-27390,26240,-14385,-25752,-26208,-8816,-12256,18397,9860,-17207,-22917,-21452,-5873,29130,-22771,-13534,-3831,25549,-17649,-13004,16671,-17931,-23465,14300,31983,-27269,32046,22679,-1411,-14621,-14794,2052,-26757,4301,17732,-27970,-14073,12604,20451,-5177,-30696,-7316,29467,4401,-28712,-4329,-15326,-12278,189,23467,-3198,6442,19872,-10959,-12319,-15360,-32336,-1518,32699,-28405,-18518,18105,3529,24734,18248,2297,17321,27828,21106,-17928,32239,-8015,28001,23583,-13414,4404,-20608,-24245,-31963,28811,16067,29732,-23453,-21708,-24588,3721,-32600,20077,-21611,-15830,22207,585,20997,14461,24969,11058,3633,13541,32282,12323,-9629,-7355,31014,26461,-4519,9188,32578,-29890,-7804,-3021,11819,-3565,10000,23116,-21102,29360,17003,-18007,-30374,23951,10108,29821,8987,-5819,-27239,5166,27953,-22463,14795,6631,29896,30528,21524,-11501,-29217,-8602,-8490,17321,-19592,12371,14744,-8650,-12406,21494,4871,-423,-6756,-30006,6330,8558,27333,24681,20653,-16427,-22416,21876,1747,-12420,17989,328,21716,-19591,27319,13215,-6067,-23490,2351,-29126,8488,11290,31990,-25146,15161,-23947,12134,-22618,-32194,22093,30014,25944,23593,-16920,-20472,20131,-651,-19351,-12735,7595,-31983,-2569,30844,17259,-5087,13246,-28782,1143,23530,-6826,-9393,20041,25523,-341,30426,26935,-28172,19445,2049,16417,-13209,-12087,2685,17591,10312,23990,-17391,-16250,-14632,-7343,-12389,14543,-3137,28075,26177,14525,-1005,29271,2516,1143,-18977,24388,-24097,2315,25983,7155,15046,6870,-24857,7174,29469,-21005,1139,32294,-25125,8178,-19257,-26035,18566,7596,22520,-24993,-20634,-20415,-6546,21905,26721,91,-31832,-26249,1986,-702,-26093,-19049,20960,15618,1721,-29090,30375,-4070,24342,-24738,-16308,-15250,8270,-4959,-5805,28318,1370,30155,31079,8863,16198},
} ;

static void test_encode_953x2115_impl(long long impl)
{
  unsigned char *s = test_encode_953x2115_s;
  unsigned char *x = test_encode_953x2115_x;
  unsigned char *s2 = test_encode_953x2115_s2;
  unsigned char *x2 = test_encode_953x2115_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_953x2115_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_953x2115(impl);
    printf("encode_953x2115 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953x2115_implementation(impl),ntruprime_dispatch_encode_953x2115_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_953x2115;
    printf("encode_953x2115 selected implementation %s compiler %s\n",ntruprime_encode_953x2115_implementation(),ntruprime_encode_953x2115_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_953x2115_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_953x2115_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_953x2115_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_953x2115_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_953x2115_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_953x2115_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_953x2115(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953x2115")) return;
  storage_encode_953x2115_s = callocplus(crypto_encode_STRBYTES);
  test_encode_953x2115_s = aligned(storage_encode_953x2115_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_953x2115_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_953x2115_x = aligned(storage_encode_953x2115_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_953x2115_s2 = callocplus(maxalloc);
  test_encode_953x2115_s2 = aligned(storage_encode_953x2115_s2,crypto_encode_STRBYTES);
  storage_encode_953x2115_x2 = callocplus(maxalloc);
  test_encode_953x2115_x2 = aligned(storage_encode_953x2115_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_953x2115 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_953x2115();++impl)
      forked(test_encode_953x2115_impl,impl);
    ++test_encode_953x2115_s;
    ++test_encode_953x2115_x;
    ++test_encode_953x2115_s2;
    ++test_encode_953x2115_x2;
  }
  free(storage_encode_953x2115_x2);
  free(storage_encode_953x2115_s2);
  free(storage_encode_953x2115_x);
  free(storage_encode_953x2115_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

