/* netlinknotifier.c generated by valac 0.16.1, the Vala compiler
 * generated from netlinknotifier.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <netlink/netlink.h>
#include <unistd.h>
#include <linux/netlink.h>
#include <sys/socket.h>
#include <linux/rtnetlink.h>
#include <netlink/object.h>
#include <netlink/route/link.h>
#include <netlink/route/route.h>
#include <netlink/route/neighbour.h>
#include <netlink/route/rule.h>
#include <netlink/addr.h>
#include <netlink/utils.h>
#include <netlink/route/rtnl.h>
#include <netlink/route/qdisc.h>

typedef struct _NetlinkDelegateHolder NetlinkDelegateHolder;

#define FSO_FRAMEWORK_TYPE_BASE_NETLINK_NOTIFIER (fso_framework_base_netlink_notifier_get_type ())
#define FSO_FRAMEWORK_BASE_NETLINK_NOTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_BASE_NETLINK_NOTIFIER, FsoFrameworkBaseNetlinkNotifier))
#define FSO_FRAMEWORK_BASE_NETLINK_NOTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_BASE_NETLINK_NOTIFIER, FsoFrameworkBaseNetlinkNotifierClass))
#define FSO_FRAMEWORK_IS_BASE_NETLINK_NOTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_BASE_NETLINK_NOTIFIER))
#define FSO_FRAMEWORK_IS_BASE_NETLINK_NOTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_BASE_NETLINK_NOTIFIER))
#define FSO_FRAMEWORK_BASE_NETLINK_NOTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_BASE_NETLINK_NOTIFIER, FsoFrameworkBaseNetlinkNotifierClass))

typedef struct _FsoFrameworkBaseNetlinkNotifier FsoFrameworkBaseNetlinkNotifier;
typedef struct _FsoFrameworkBaseNetlinkNotifierClass FsoFrameworkBaseNetlinkNotifierClass;
typedef struct _FsoFrameworkBaseNetlinkNotifierPrivate FsoFrameworkBaseNetlinkNotifierPrivate;
#define _nl_cache_free0(var) ((var == NULL) ? NULL : (var = (nl_cache_free (var), NULL)))
#define _nl_socket_free0(var) ((var == NULL) ? NULL : (var = (nl_socket_free (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define FSO_FRAMEWORK_TYPE_LOGGER (fso_framework_logger_get_type ())
#define FSO_FRAMEWORK_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_LOGGER, FsoFrameworkLogger))
#define FSO_FRAMEWORK_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_LOGGER))
#define FSO_FRAMEWORK_LOGGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FSO_FRAMEWORK_TYPE_LOGGER, FsoFrameworkLoggerIface))

typedef struct _FsoFrameworkLogger FsoFrameworkLogger;
typedef struct _FsoFrameworkLoggerIface FsoFrameworkLoggerIface;
typedef struct _Block1Data Block1Data;
#define _0(var) ((var == NULL) ? NULL : (var = ( (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__netlink_delegate_holder_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__netlink_delegate_holder_free0_ (var), NULL)))

typedef void (*FsoFrameworkNetlinkNotifierFunc) (GHashTable* properties, void* user_data);
struct _NetlinkDelegateHolder {
	FsoFrameworkNetlinkNotifierFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _FsoFrameworkBaseNetlinkNotifier {
	GObject parent_instance;
	FsoFrameworkBaseNetlinkNotifierPrivate * priv;
	struct nl_cache* cache;
	struct nl_sock* socket;
};

struct _FsoFrameworkBaseNetlinkNotifierClass {
	GObjectClass parent_class;
};

struct _FsoFrameworkBaseNetlinkNotifierPrivate {
	gint fd;
	guint watch;
	GIOChannel* channel;
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	GHashTable* map;
};

typedef gchar* (*ReprDelegate) (void* user_data);
struct _FsoFrameworkLoggerIface {
	GTypeInterface parent_iface;
	void (*setLevel) (FsoFrameworkLogger* self, GLogLevelFlags level);
	void (*setDestination) (FsoFrameworkLogger* self, const gchar* destination);
	void (*setReprDelegate) (FsoFrameworkLogger* self, ReprDelegate repr, void* repr_target);
	GLogLevelFlags (*getLevel) (FsoFrameworkLogger* self);
	gchar* (*getDestination) (FsoFrameworkLogger* self);
	gboolean (*debug) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*info) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*warning) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*error) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*critical) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*data) (FsoFrameworkLogger* self, guint8* message, int message_length1, gboolean in, GLogLevelFlags when);
};

struct _Block1Data {
	int _ref_count_;
	FsoFrameworkBaseNetlinkNotifier * self;
	struct nlmsghdr* hdr;
};


static gpointer fso_framework_base_netlink_notifier_parent_class = NULL;
extern FsoFrameworkBaseNetlinkNotifier* fso_framework_base_netlink_notifier_instance;
FsoFrameworkBaseNetlinkNotifier* fso_framework_base_netlink_notifier_instance = NULL;
extern FsoFrameworkLogger* fso_framework_theLogger;

void netlink_delegate_holder_free (NetlinkDelegateHolder* self);
static void netlink_delegate_holder_instance_init (NetlinkDelegateHolder * self);
NetlinkDelegateHolder* netlink_delegate_holder_new (FsoFrameworkNetlinkNotifierFunc func, void* func_target);
NetlinkDelegateHolder* netlink_delegate_holder_new (FsoFrameworkNetlinkNotifierFunc func, void* func_target);
GType fso_framework_base_netlink_notifier_get_type (void) G_GNUC_CONST;
#define FSO_FRAMEWORK_BASE_NETLINK_NOTIFIER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_BASE_NETLINK_NOTIFIER, FsoFrameworkBaseNetlinkNotifierPrivate))
enum  {
	FSO_FRAMEWORK_BASE_NETLINK_NOTIFIER_DUMMY_PROPERTY
};
#define FSO_FRAMEWORK_BASE_NETLINK_NOTIFIER_BUFFER_LENGTH ((gssize) 4096)
FsoFrameworkBaseNetlinkNotifier* fso_framework_base_netlink_notifier_new (void);
FsoFrameworkBaseNetlinkNotifier* fso_framework_base_netlink_notifier_construct (GType object_type);
static void _netlink_delegate_holder_free0_ (gpointer var);
static void _g_list_free__netlink_delegate_holder_free0_ (GList* self);
static void __g_list_free__netlink_delegate_holder_free0_0_ (gpointer var);
gint fso_framework_base_netlink_notifier_handleNetlinkMessage (FsoFrameworkBaseNetlinkNotifier* self, struct nl_msg* msg);
static gint _fso_framework_base_netlink_notifier_handleNetlinkMessage_nl_recmsg_msg_cb_t (struct nl_msg* msg, gpointer self);
gboolean fso_framework_base_netlink_notifier_onActionFromSocket (FsoFrameworkBaseNetlinkNotifier* self, GIOChannel* source, GIOCondition condition);
static gboolean _fso_framework_base_netlink_notifier_onActionFromSocket_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
GType fso_framework_logger_get_type (void) G_GNUC_CONST;
gboolean fso_framework_logger_error (FsoFrameworkLogger* self, const gchar* message);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda2_ (Block1Data* _data1_, struct nl_object* obj);
void fso_framework_base_netlink_notifier_handleMessage (FsoFrameworkBaseNetlinkNotifier* self, guint16 type, struct nl_object* obj);
static void ___lambda2__netlink_callback_func (struct nl_object* obj, gpointer self);
static void _g_free0_ (gpointer var);
void fso_framework_base_netlink_notifier_fillLinkProperties (FsoFrameworkBaseNetlinkNotifier* self, struct rtnl_link* lnk, GHashTable** properties);
void fso_framework_base_netlink_notifier_fillRouteProperties (FsoFrameworkBaseNetlinkNotifier* self, struct rtnl_route* route, GHashTable** properties);
void fso_framework_base_netlink_notifier_fillAddressProperties (FsoFrameworkBaseNetlinkNotifier* self, struct nl_addr* addr, GHashTable** properties);
void fso_framework_base_netlink_notifier_fillNeighbourProperties (FsoFrameworkBaseNetlinkNotifier* self, struct rtnl_neigh* neigh, GHashTable** properties);
void fso_framework_base_netlink_notifier_fillRuleProperties (FsoFrameworkBaseNetlinkNotifier* self, struct rtnl_rule* rule, GHashTable** properties);
gboolean fso_framework_logger_warning (FsoFrameworkLogger* self, const gchar* message);
void fso_framework_base_netlink_notifier_fillQdiscProperties (FsoFrameworkBaseNetlinkNotifier* self, struct rtnl_qdisc* qdisc, GHashTable** properties);
void _fso_framework_base_netlink_notifier_addMatch (FsoFrameworkBaseNetlinkNotifier* self, guint16 type, FsoFrameworkNetlinkNotifierFunc callback, void* callback_target);
void fso_framework_base_netlink_notifier_addMatch (guint16 action, FsoFrameworkNetlinkNotifierFunc callback, void* callback_target);
static void fso_framework_base_netlink_notifier_finalize (GObject* obj);


NetlinkDelegateHolder* netlink_delegate_holder_new (FsoFrameworkNetlinkNotifierFunc func, void* func_target) {
	NetlinkDelegateHolder* self;
	FsoFrameworkNetlinkNotifierFunc _tmp0_;
	void* _tmp0__target;
	self = g_slice_new0 (NetlinkDelegateHolder);
	netlink_delegate_holder_instance_init (self);
	_tmp0_ = func;
	_tmp0__target = func_target;
	(self->func_target_destroy_notify == NULL) ? NULL : (self->func_target_destroy_notify (self->func_target), NULL);
	self->func = NULL;
	self->func_target = NULL;
	self->func_target_destroy_notify = NULL;
	self->func = _tmp0_;
	self->func_target = _tmp0__target;
	self->func_target_destroy_notify = NULL;
	return self;
}


static void netlink_delegate_holder_instance_init (NetlinkDelegateHolder * self) {
}


void netlink_delegate_holder_free (NetlinkDelegateHolder* self) {
	(self->func_target_destroy_notify == NULL) ? NULL : (self->func_target_destroy_notify (self->func_target), NULL);
	self->func = NULL;
	self->func_target = NULL;
	self->func_target_destroy_notify = NULL;
	g_slice_free (NetlinkDelegateHolder, self);
}


static void _netlink_delegate_holder_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (netlink_delegate_holder_free (var), NULL));
}


static void _g_list_free__netlink_delegate_holder_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _netlink_delegate_holder_free0_, NULL);
	g_list_free (self);
}


static void __g_list_free__netlink_delegate_holder_free0_0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_g_list_free__netlink_delegate_holder_free0_ (var), NULL));
}


static gint _fso_framework_base_netlink_notifier_handleNetlinkMessage_nl_recmsg_msg_cb_t (struct nl_msg* msg, gpointer self) {
	gint result;
	result = fso_framework_base_netlink_notifier_handleNetlinkMessage (self, msg);
	return result;
}


static gboolean _fso_framework_base_netlink_notifier_onActionFromSocket_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = fso_framework_base_netlink_notifier_onActionFromSocket (self, source, condition);
	return result;
}


FsoFrameworkBaseNetlinkNotifier* fso_framework_base_netlink_notifier_construct (GType object_type) {
	FsoFrameworkBaseNetlinkNotifier * self = NULL;
	gchar* _tmp0_ = NULL;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	struct nl_sock* _tmp4_;
	struct nl_sock* _tmp5_;
	struct nl_sock* _tmp6_;
	struct nl_sock* _tmp7_;
	struct nl_sock* _tmp8_;
	struct nl_cache* _tmp9_ = NULL;
	struct nl_cache* _tmp10_;
	struct nl_sock* _tmp11_;
	gint _tmp12_ = 0;
	gint res;
	struct nl_sock* _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_;
	gint _tmp16_;
	GIOChannel* _tmp17_;
	GIOChannel* _tmp18_;
	guint _tmp19_ = 0U;
	self = (FsoFrameworkBaseNetlinkNotifier*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (gchar, FSO_FRAMEWORK_BASE_NETLINK_NOTIFIER_BUFFER_LENGTH);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = _tmp0_;
	self->priv->buffer_length1 = FSO_FRAMEWORK_BASE_NETLINK_NOTIFIER_BUFFER_LENGTH;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, __g_list_free__netlink_delegate_holder_free0_0_);
	_g_hash_table_unref0 (self->priv->map);
	self->priv->map = _tmp3_;
	_tmp4_ = nl_socket_alloc ();
	_nl_socket_free0 (self->socket);
	self->socket = _tmp4_;
	_tmp5_ = self->socket;
	nl_socket_disable_seq_check (_tmp5_);
	_tmp6_ = self->socket;
	nl_socket_modify_cb (_tmp6_, NL_CB_VALID, NL_CB_CUSTOM, _fso_framework_base_netlink_notifier_handleNetlinkMessage_nl_recmsg_msg_cb_t, self);
	_tmp7_ = self->socket;
	nl_connect (_tmp7_, NETLINK_ROUTE);
	_tmp8_ = self->socket;
	rtnl_link_alloc_cache (_tmp8_, AF_UNSPEC, &_tmp9_);
	_nl_cache_free0 (self->cache);
	self->cache = _tmp9_;
	_tmp10_ = self->cache;
	nl_cache_mngt_provide (_tmp10_);
	_tmp11_ = self->socket;
	_tmp12_ = nl_socket_add_memberships (_tmp11_, RTNLGRP_LINK, RTNLGRP_IPV4_IFADDR, RTNLGRP_IPV4_ROUTE, NULL);
	res = _tmp12_;
	g_assert (res != (-1));
	_tmp13_ = self->socket;
	_tmp14_ = nl_socket_get_fd (_tmp13_);
	self->priv->fd = _tmp14_;
	_tmp15_ = self->priv->fd;
	g_assert (_tmp15_ != (-1));
	_tmp16_ = self->priv->fd;
	_tmp17_ = g_io_channel_unix_new (_tmp16_);
	_g_io_channel_unref0 (self->priv->channel);
	self->priv->channel = _tmp17_;
	_tmp18_ = self->priv->channel;
	_tmp19_ = g_io_add_watch (_tmp18_, G_IO_IN | G_IO_HUP, _fso_framework_base_netlink_notifier_onActionFromSocket_gio_func, self);
	self->priv->watch = _tmp19_;
	return self;
}


FsoFrameworkBaseNetlinkNotifier* fso_framework_base_netlink_notifier_new (void) {
	return fso_framework_base_netlink_notifier_construct (FSO_FRAMEWORK_TYPE_BASE_NETLINK_NOTIFIER);
}


gboolean fso_framework_base_netlink_notifier_onActionFromSocket (FsoFrameworkBaseNetlinkNotifier* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	GIOCondition _tmp0_;
	GIOCondition _tmp2_;
	GIOCondition _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = condition;
	if ((_tmp0_ & G_IO_HUP) == G_IO_HUP) {
		FsoFrameworkLogger* _tmp1_;
		_tmp1_ = fso_framework_theLogger;
		fso_framework_logger_error (_tmp1_, "HUP on netlink route socket, will no longer get any notifications");
		result = FALSE;
		return result;
	}
	_tmp2_ = condition;
	if ((_tmp2_ & G_IO_IN) == G_IO_IN) {
		gint _tmp3_;
		struct nl_sock* _tmp4_;
		_tmp3_ = self->priv->fd;
		g_assert (_tmp3_ != (-1));
		_tmp4_ = self->socket;
		nl_recvmsgs_default (_tmp4_);
		result = TRUE;
		return result;
	}
	_tmp5_ = condition;
	g_critical ("netlinknotifier.vala:101: Unsupported IOCondition %u", (guint) ((gint) _tmp5_));
	result = TRUE;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FsoFrameworkBaseNetlinkNotifier * self;
		self = _data1_->self;
		_0 (_data1_->hdr);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda2_ (Block1Data* _data1_, struct nl_object* obj) {
	FsoFrameworkBaseNetlinkNotifier * self;
	guint16 _tmp0_;
	struct nl_object* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (obj != NULL);
	_tmp0_ = _data1_->hdr->nlmsg_type;
	_tmp1_ = obj;
	fso_framework_base_netlink_notifier_handleMessage (self, _tmp0_, _tmp1_);
}


static void ___lambda2__netlink_callback_func (struct nl_object* obj, gpointer self) {
	__lambda2_ (self, obj);
}


gint fso_framework_base_netlink_notifier_handleNetlinkMessage (FsoFrameworkBaseNetlinkNotifier* self, struct nl_msg* msg) {
	gint result = 0;
	Block1Data* _data1_;
	struct nl_msg* _tmp0_;
	struct nlmsghdr* _tmp1_ = NULL;
	struct nl_msg* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (msg != NULL, 0);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = msg;
	_tmp1_ = nlmsg_hdr (_tmp0_);
	_data1_->hdr = _tmp1_;
	_tmp2_ = msg;
	nl_msg_parse (_tmp2_, ___lambda2__netlink_callback_func, _data1_);
	result = (gint) NL_STOP;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


void fso_framework_base_netlink_notifier_handleMessage (FsoFrameworkBaseNetlinkNotifier* self, guint16 type, struct nl_object* obj) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* properties;
	guint16 _tmp3_;
	GHashTable* _tmp15_;
	guint16 _tmp16_;
	gconstpointer _tmp17_ = NULL;
	GList* list;
	GList* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	properties = _tmp2_;
	_tmp3_ = type;
	switch (_tmp3_) {
		case RTM_NEWLINK:
		case RTM_DELLINK:
		case RTM_GETLINK:
		case RTM_SETLINK:
		{
			struct nl_object* _tmp4_;
			_tmp4_ = obj;
			fso_framework_base_netlink_notifier_fillLinkProperties (self, (struct rtnl_link*) _tmp4_, &properties);
			break;
		}
		case RTM_NEWROUTE:
		case RTM_DELROUTE:
		case RTM_GETROUTE:
		{
			struct nl_object* _tmp5_;
			_tmp5_ = obj;
			fso_framework_base_netlink_notifier_fillRouteProperties (self, (struct rtnl_route*) _tmp5_, &properties);
			break;
		}
		case RTM_NEWADDR:
		case RTM_DELADDR:
		case RTM_GETADDR:
		{
			struct nl_object* _tmp6_;
			_tmp6_ = obj;
			fso_framework_base_netlink_notifier_fillAddressProperties (self, (struct nl_addr*) _tmp6_, &properties);
			break;
		}
		case RTM_NEWNEIGH:
		case RTM_DELNEIGH:
		case RTM_GETNEIGH:
		{
			struct nl_object* _tmp7_;
			_tmp7_ = obj;
			fso_framework_base_netlink_notifier_fillNeighbourProperties (self, (struct rtnl_neigh*) _tmp7_, &properties);
			break;
		}
		case RTM_NEWRULE:
		case RTM_DELRULE:
		case RTM_GETRULE:
		{
			struct nl_object* _tmp8_;
			_tmp8_ = obj;
			fso_framework_base_netlink_notifier_fillRuleProperties (self, (struct rtnl_rule*) _tmp8_, &properties);
			break;
		}
		default:
		case RTM_NEWNEIGHTBL:
		case RTM_GETNEIGHTBL:
		case RTM_SETNEIGHTBL:
		case RTM_NEWQDISC:
		case RTM_DELQDISC:
		case RTM_GETQDISC:
		case RTM_NEWTCLASS:
		case RTM_DELTCLASS:
		case RTM_GETTCLASS:
		case RTM_NEWTFILTER:
		case RTM_DELTFILTER:
		case RTM_GETTFILTER:
		case RTM_NEWACTION:
		case RTM_DELACTION:
		case RTM_GETACTION:
		case RTM_NEWPREFIX:
		case RTM_GETMULTICAST:
		case RTM_GETANYCAST:
		{
			FsoFrameworkLogger* _tmp9_;
			guint16 _tmp10_;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp9_ = fso_framework_theLogger;
			_tmp10_ = type;
			_tmp11_ = g_strdup_printf ("%hu", _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat ("missing fillProperties for netlink message type ", _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			fso_framework_logger_warning (_tmp9_, _tmp14_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
			break;
		}
	}
	_tmp15_ = self->priv->map;
	_tmp16_ = type;
	_tmp17_ = g_hash_table_lookup (_tmp15_, GUINT_TO_POINTER (_tmp16_));
	list = (GList*) _tmp17_;
	_tmp18_ = list;
	if (_tmp18_ != NULL) {
		GList* _tmp19_;
		_tmp19_ = list;
		{
			GList* delegateholder_collection = NULL;
			GList* delegateholder_it = NULL;
			delegateholder_collection = _tmp19_;
			for (delegateholder_it = delegateholder_collection; delegateholder_it != NULL; delegateholder_it = delegateholder_it->next) {
				NetlinkDelegateHolder* delegateholder = NULL;
				delegateholder = (NetlinkDelegateHolder*) delegateholder_it->data;
				{
					NetlinkDelegateHolder* _tmp20_;
					FsoFrameworkNetlinkNotifierFunc _tmp21_;
					void* _tmp21__target;
					GHashTable* _tmp22_;
					_tmp20_ = delegateholder;
					_tmp21_ = _tmp20_->func;
					_tmp21__target = _tmp20_->func_target;
					_tmp22_ = properties;
					_tmp21_ (_tmp22_, _tmp21__target);
				}
			}
		}
	}
	_g_hash_table_unref0 (properties);
}


static gchar* rtnl_addr_to_string (struct nl_addr* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* buf;
	gint buf_length1;
	gint _buf_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 256);
	buf = _tmp0_;
	buf_length1 = 256;
	_buf_size_ = buf_length1;
	_tmp1_ = buf;
	_tmp1__length1 = buf_length1;
	_tmp2_ = nl_addr2str (self, _tmp1_, _tmp1__length1);
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	buf = (g_free (buf), NULL);
	return result;
}


void fso_framework_base_netlink_notifier_fillLinkProperties (FsoFrameworkBaseNetlinkNotifier* self, struct rtnl_link* lnk, GHashTable** properties) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	struct rtnl_link* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GHashTable* _tmp5_;
	gchar* _tmp6_;
	struct rtnl_link* _tmp7_;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	GHashTable* _tmp10_;
	gchar* _tmp11_;
	struct rtnl_link* _tmp12_;
	gint _tmp13_ = 0;
	gchar* _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	GHashTable* _tmp17_;
	gchar* _tmp18_;
	struct rtnl_link* _tmp19_;
	guint _tmp20_ = 0U;
	gchar* _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	struct rtnl_link* _tmp24_;
	struct nl_addr* _tmp25_ = NULL;
	struct nl_addr* addr;
	struct nl_addr* _tmp26_;
	struct rtnl_link* _tmp31_;
	struct nl_addr* _tmp32_ = NULL;
	struct nl_addr* bcast;
	struct nl_addr* _tmp33_;
	GHashTable* _tmp38_;
	gchar* _tmp39_;
	struct rtnl_link* _tmp40_;
	guint _tmp41_ = 0U;
	gchar* _tmp42_ = NULL;
	GHashTable* _tmp43_;
	gchar* _tmp44_;
	struct rtnl_link* _tmp45_;
	guint _tmp46_ = 0U;
	gchar* _tmp47_ = NULL;
	GHashTable* _tmp48_;
	gchar* _tmp49_;
	struct rtnl_link* _tmp50_;
	guint _tmp51_ = 0U;
	gchar* _tmp52_ = NULL;
	GHashTable* _tmp53_;
	gchar* _tmp54_;
	struct rtnl_link* _tmp55_;
	guint _tmp56_ = 0U;
	gchar* _tmp57_;
	gint _tmp57__length1;
	const gchar* _tmp58_ = NULL;
	gchar* _tmp59_;
	struct rtnl_link* _tmp60_;
	const gchar* _tmp61_ = NULL;
	gchar* _tmp62_;
	gchar* qdisc;
	const gchar* _tmp63_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lnk != NULL);
	g_return_if_fail (*properties != NULL);
	_tmp0_ = *properties;
	_tmp1_ = g_strdup ("LINK_NAME");
	_tmp2_ = lnk;
	_tmp3_ = rtnl_link_get_name (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp4_);
	_tmp5_ = *properties;
	_tmp6_ = g_strdup ("LINK_IFINDEX");
	_tmp7_ = lnk;
	_tmp8_ = rtnl_link_get_ifindex (_tmp7_);
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
	g_hash_table_insert (_tmp5_, _tmp6_, _tmp9_);
	_tmp10_ = *properties;
	_tmp11_ = g_strdup ("LINK_FAMILY");
	_tmp12_ = lnk;
	_tmp13_ = rtnl_link_get_family (_tmp12_);
	_tmp14_ = self->priv->buffer;
	_tmp14__length1 = self->priv->buffer_length1;
	_tmp15_ = nl_af2str (_tmp13_, _tmp14_, _tmp14__length1);
	_tmp16_ = g_strdup (_tmp15_);
	g_hash_table_insert (_tmp10_, _tmp11_, _tmp16_);
	_tmp17_ = *properties;
	_tmp18_ = g_strdup ("LINK_TYPE");
	_tmp19_ = lnk;
	_tmp20_ = rtnl_link_get_arptype (_tmp19_);
	_tmp21_ = self->priv->buffer;
	_tmp21__length1 = self->priv->buffer_length1;
	_tmp22_ = nl_llproto2str (_tmp20_, _tmp21_, _tmp21__length1);
	_tmp23_ = g_strdup (_tmp22_);
	g_hash_table_insert (_tmp17_, _tmp18_, _tmp23_);
	_tmp24_ = lnk;
	_tmp25_ = rtnl_link_get_addr (_tmp24_);
	addr = _tmp25_;
	_tmp26_ = addr;
	if (_tmp26_ != NULL) {
		GHashTable* _tmp27_;
		gchar* _tmp28_;
		struct nl_addr* _tmp29_;
		gchar* _tmp30_ = NULL;
		_tmp27_ = *properties;
		_tmp28_ = g_strdup ("LINK_ADDRESS");
		_tmp29_ = addr;
		_tmp30_ = rtnl_addr_to_string (_tmp29_);
		g_hash_table_insert (_tmp27_, _tmp28_, _tmp30_);
	}
	_tmp31_ = lnk;
	_tmp32_ = rtnl_link_get_broadcast (_tmp31_);
	bcast = _tmp32_;
	_tmp33_ = bcast;
	if (_tmp33_ != NULL) {
		GHashTable* _tmp34_;
		gchar* _tmp35_;
		struct nl_addr* _tmp36_;
		gchar* _tmp37_ = NULL;
		_tmp34_ = *properties;
		_tmp35_ = g_strdup ("LINK_BROADCAST");
		_tmp36_ = bcast;
		_tmp37_ = rtnl_addr_to_string (_tmp36_);
		g_hash_table_insert (_tmp34_, _tmp35_, _tmp37_);
	}
	_tmp38_ = *properties;
	_tmp39_ = g_strdup ("LINK_MTU");
	_tmp40_ = lnk;
	_tmp41_ = rtnl_link_get_mtu (_tmp40_);
	_tmp42_ = g_strdup_printf ("%u", _tmp41_);
	g_hash_table_insert (_tmp38_, _tmp39_, _tmp42_);
	_tmp43_ = *properties;
	_tmp44_ = g_strdup ("LINK_TXQUEUELEN");
	_tmp45_ = lnk;
	_tmp46_ = rtnl_link_get_txqlen (_tmp45_);
	_tmp47_ = g_strdup_printf ("%u", _tmp46_);
	g_hash_table_insert (_tmp43_, _tmp44_, _tmp47_);
	_tmp48_ = *properties;
	_tmp49_ = g_strdup ("LINK_WEIGHT");
	_tmp50_ = lnk;
	_tmp51_ = rtnl_link_get_weight (_tmp50_);
	_tmp52_ = g_strdup_printf ("%u", _tmp51_);
	g_hash_table_insert (_tmp48_, _tmp49_, _tmp52_);
	_tmp53_ = *properties;
	_tmp54_ = g_strdup ("LINK_FLAGS");
	_tmp55_ = lnk;
	_tmp56_ = rtnl_link_get_flags (_tmp55_);
	_tmp57_ = self->priv->buffer;
	_tmp57__length1 = self->priv->buffer_length1;
	_tmp58_ = rtnl_link_flags2str (_tmp56_, _tmp57_, _tmp57__length1);
	_tmp59_ = g_strdup (_tmp58_);
	g_hash_table_insert (_tmp53_, _tmp54_, _tmp59_);
	_tmp60_ = lnk;
	_tmp61_ = rtnl_link_get_qdisc (_tmp60_);
	_tmp62_ = g_strdup (_tmp61_);
	qdisc = _tmp62_;
	_tmp63_ = qdisc;
	if (_tmp63_ != NULL) {
		GHashTable* _tmp64_;
		gchar* _tmp65_;
		const gchar* _tmp66_;
		gchar* _tmp67_;
		_tmp64_ = *properties;
		_tmp65_ = g_strdup ("LINK_QDISC");
		_tmp66_ = qdisc;
		_tmp67_ = g_strdup (_tmp66_);
		g_hash_table_insert (_tmp64_, _tmp65_, _tmp67_);
	}
	_g_free0 (qdisc);
	_0 (bcast);
	_0 (addr);
}


void fso_framework_base_netlink_notifier_fillRouteProperties (FsoFrameworkBaseNetlinkNotifier* self, struct rtnl_route* route, GHashTable** properties) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	struct rtnl_route* _tmp2_;
	guint8 _tmp3_ = 0U;
	gchar* _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	struct rtnl_route* _tmp7_;
	struct nl_addr* _tmp8_ = NULL;
	struct nl_addr* dst;
	struct nl_addr* _tmp9_;
	struct rtnl_route* _tmp14_;
	struct nl_addr* _tmp15_ = NULL;
	struct nl_addr* src;
	struct nl_addr* _tmp16_;
	struct rtnl_route* _tmp21_;
	struct nl_addr* _tmp22_ = NULL;
	struct nl_addr* prefsrc;
	struct nl_addr* _tmp23_;
	struct nl_cache* _tmp28_;
	struct rtnl_route* _tmp29_;
	gint _tmp30_ = 0;
	gchar* _tmp31_;
	gint _tmp31__length1;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	gchar* iif;
	const gchar* _tmp34_;
	GHashTable* _tmp39_;
	gchar* _tmp40_;
	struct rtnl_route* _tmp41_;
	guint8 _tmp42_ = 0U;
	gchar* _tmp43_ = NULL;
	GHashTable* _tmp44_;
	gchar* _tmp45_;
	struct rtnl_route* _tmp46_;
	guint32 _tmp47_ = 0U;
	gchar* _tmp48_ = NULL;
	GHashTable* _tmp49_;
	gchar* _tmp50_;
	struct rtnl_route* _tmp51_;
	guint8 _tmp52_ = 0U;
	gchar* _tmp53_;
	gint _tmp53__length1;
	const gchar* _tmp54_ = NULL;
	gchar* _tmp55_;
	GHashTable* _tmp56_;
	gchar* _tmp57_;
	struct rtnl_route* _tmp58_;
	guint32 _tmp59_ = 0U;
	gchar* _tmp60_ = NULL;
	GHashTable* _tmp61_;
	gchar* _tmp62_;
	struct rtnl_route* _tmp63_;
	guint8 _tmp64_ = 0U;
	gchar* _tmp65_;
	gint _tmp65__length1;
	const gchar* _tmp66_ = NULL;
	gchar* _tmp67_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (route != NULL);
	g_return_if_fail (*properties != NULL);
	_tmp0_ = *properties;
	_tmp1_ = g_strdup ("ROUTE_FAMILY");
	_tmp2_ = route;
	_tmp3_ = rtnl_route_get_family (_tmp2_);
	_tmp4_ = self->priv->buffer;
	_tmp4__length1 = self->priv->buffer_length1;
	_tmp5_ = nl_af2str ((gint) _tmp3_, _tmp4_, _tmp4__length1);
	_tmp6_ = g_strdup (_tmp5_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp6_);
	_tmp7_ = route;
	_tmp8_ = rtnl_route_get_dst (_tmp7_);
	dst = _tmp8_;
	_tmp9_ = dst;
	if (_tmp9_ != NULL) {
		GHashTable* _tmp10_;
		gchar* _tmp11_;
		struct nl_addr* _tmp12_;
		gchar* _tmp13_ = NULL;
		_tmp10_ = *properties;
		_tmp11_ = g_strdup ("ROUTE_DST");
		_tmp12_ = dst;
		_tmp13_ = rtnl_addr_to_string (_tmp12_);
		g_hash_table_insert (_tmp10_, _tmp11_, _tmp13_);
	}
	_tmp14_ = route;
	_tmp15_ = rtnl_route_get_src (_tmp14_);
	src = _tmp15_;
	_tmp16_ = src;
	if (_tmp16_ != NULL) {
		GHashTable* _tmp17_;
		gchar* _tmp18_;
		struct nl_addr* _tmp19_;
		gchar* _tmp20_ = NULL;
		_tmp17_ = *properties;
		_tmp18_ = g_strdup ("ROUTE_SRC");
		_tmp19_ = src;
		_tmp20_ = rtnl_addr_to_string (_tmp19_);
		g_hash_table_insert (_tmp17_, _tmp18_, _tmp20_);
	}
	_tmp21_ = route;
	_tmp22_ = rtnl_route_get_pref_src (_tmp21_);
	prefsrc = _tmp22_;
	_tmp23_ = prefsrc;
	if (_tmp23_ != NULL) {
		GHashTable* _tmp24_;
		gchar* _tmp25_;
		struct nl_addr* _tmp26_;
		gchar* _tmp27_ = NULL;
		_tmp24_ = *properties;
		_tmp25_ = g_strdup ("ROUTE_PREFSRC");
		_tmp26_ = prefsrc;
		_tmp27_ = rtnl_addr_to_string (_tmp26_);
		g_hash_table_insert (_tmp24_, _tmp25_, _tmp27_);
	}
	_tmp28_ = self->cache;
	_tmp29_ = route;
	_tmp30_ = rtnl_route_get_iif (_tmp29_);
	_tmp31_ = self->priv->buffer;
	_tmp31__length1 = self->priv->buffer_length1;
	_tmp32_ = rtnl_link_i2name (_tmp28_, _tmp30_, _tmp31_, _tmp31__length1);
	_tmp33_ = g_strdup (_tmp32_);
	iif = _tmp33_;
	_tmp34_ = iif;
	if (_tmp34_ != NULL) {
		GHashTable* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp35_ = *properties;
		_tmp36_ = g_strdup ("ROUTE_IIF");
		_tmp37_ = iif;
		_tmp38_ = g_strdup (_tmp37_);
		g_hash_table_insert (_tmp35_, _tmp36_, _tmp38_);
	}
	_tmp39_ = *properties;
	_tmp40_ = g_strdup ("ROUTE_TOS");
	_tmp41_ = route;
	_tmp42_ = rtnl_route_get_tos (_tmp41_);
	_tmp43_ = g_strdup_printf ("%hhu", _tmp42_);
	g_hash_table_insert (_tmp39_, _tmp40_, _tmp43_);
	_tmp44_ = *properties;
	_tmp45_ = g_strdup ("ROUTE_TABLE");
	_tmp46_ = route;
	_tmp47_ = rtnl_route_get_table (_tmp46_);
	_tmp48_ = g_strdup_printf ("%u", _tmp47_);
	g_hash_table_insert (_tmp44_, _tmp45_, _tmp48_);
	_tmp49_ = *properties;
	_tmp50_ = g_strdup ("ROUTE_SCOPE");
	_tmp51_ = route;
	_tmp52_ = rtnl_route_get_scope (_tmp51_);
	_tmp53_ = self->priv->buffer;
	_tmp53__length1 = self->priv->buffer_length1;
	_tmp54_ = rtnl_scope2str ((gint) _tmp52_, _tmp53_, _tmp53__length1);
	_tmp55_ = g_strdup (_tmp54_);
	g_hash_table_insert (_tmp49_, _tmp50_, _tmp55_);
	_tmp56_ = *properties;
	_tmp57_ = g_strdup ("ROUTE_PRIORITY");
	_tmp58_ = route;
	_tmp59_ = rtnl_route_get_priority (_tmp58_);
	_tmp60_ = g_strdup_printf ("%u", _tmp59_);
	g_hash_table_insert (_tmp56_, _tmp57_, _tmp60_);
	_tmp61_ = *properties;
	_tmp62_ = g_strdup ("ROUTE_TYPE");
	_tmp63_ = route;
	_tmp64_ = rtnl_route_get_type (_tmp63_);
	_tmp65_ = self->priv->buffer;
	_tmp65__length1 = self->priv->buffer_length1;
	_tmp66_ = nl_rtntype2str ((gint) _tmp64_, _tmp65_, _tmp65__length1);
	_tmp67_ = g_strdup (_tmp66_);
	g_hash_table_insert (_tmp61_, _tmp62_, _tmp67_);
	_g_free0 (iif);
	_0 (prefsrc);
	_0 (src);
	_0 (dst);
}


void fso_framework_base_netlink_notifier_fillAddressProperties (FsoFrameworkBaseNetlinkNotifier* self, struct nl_addr* addr, GHashTable** properties) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	struct nl_addr* _tmp2_;
	gint _tmp3_ = 0;
	gchar* _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	struct nl_addr* _tmp7_;
	struct nl_addr* _tmp8_ = NULL;
	struct nl_addr* local;
	struct nl_addr* _tmp9_;
	struct nl_addr* _tmp14_;
	struct nl_addr* _tmp15_ = NULL;
	struct nl_addr* peer;
	struct nl_addr* _tmp16_;
	struct nl_addr* _tmp21_;
	struct nl_addr* _tmp22_ = NULL;
	struct nl_addr* bcast;
	struct nl_addr* _tmp23_;
	struct nl_addr* _tmp28_;
	struct nl_addr* _tmp29_ = NULL;
	struct nl_addr* a;
	struct nl_addr* _tmp30_;
	struct nl_addr* _tmp35_;
	struct nl_addr* _tmp36_ = NULL;
	struct nl_addr* _tmp37_;
	GHashTable* _tmp42_;
	gchar* _tmp43_;
	struct nl_addr* _tmp44_;
	gint _tmp45_ = 0;
	gchar* _tmp46_ = NULL;
	GHashTable* _tmp47_;
	gchar* _tmp48_;
	struct nl_addr* _tmp49_;
	gint _tmp50_ = 0;
	gchar* _tmp51_ = NULL;
	GHashTable* _tmp52_;
	gchar* _tmp53_;
	struct nl_cache* _tmp54_;
	struct nl_addr* _tmp55_;
	gint _tmp56_ = 0;
	gchar* _tmp57_;
	gint _tmp57__length1;
	const gchar* _tmp58_ = NULL;
	gchar* _tmp59_;
	GHashTable* _tmp60_;
	gchar* _tmp61_;
	struct nl_addr* _tmp62_;
	gint _tmp63_ = 0;
	gchar* _tmp64_;
	gint _tmp64__length1;
	const gchar* _tmp65_ = NULL;
	gchar* _tmp66_;
	GHashTable* _tmp67_;
	gchar* _tmp68_;
	struct nl_addr* _tmp69_;
	gchar* _tmp70_ = NULL;
	GHashTable* _tmp71_;
	gchar* _tmp72_;
	struct nl_addr* _tmp73_;
	gint _tmp74_ = 0;
	gchar* _tmp75_;
	gint _tmp75__length1;
	const gchar* _tmp76_ = NULL;
	gchar* _tmp77_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (addr != NULL);
	g_return_if_fail (*properties != NULL);
	_tmp0_ = *properties;
	_tmp1_ = g_strdup ("ADDR_FAMILY");
	_tmp2_ = addr;
	_tmp3_ = rtnl_addr_get_family (_tmp2_);
	_tmp4_ = self->priv->buffer;
	_tmp4__length1 = self->priv->buffer_length1;
	_tmp5_ = nl_af2str (_tmp3_, _tmp4_, _tmp4__length1);
	_tmp6_ = g_strdup (_tmp5_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp6_);
	_tmp7_ = addr;
	_tmp8_ = rtnl_addr_get_local (_tmp7_);
	local = _tmp8_;
	_tmp9_ = local;
	if (_tmp9_ != NULL) {
		GHashTable* _tmp10_;
		gchar* _tmp11_;
		struct nl_addr* _tmp12_;
		gchar* _tmp13_ = NULL;
		_tmp10_ = *properties;
		_tmp11_ = g_strdup ("ADDR_LOCAL");
		_tmp12_ = local;
		_tmp13_ = rtnl_addr_to_string (_tmp12_);
		g_hash_table_insert (_tmp10_, _tmp11_, _tmp13_);
	}
	_tmp14_ = addr;
	_tmp15_ = rtnl_addr_get_peer (_tmp14_);
	peer = _tmp15_;
	_tmp16_ = peer;
	if (_tmp16_ != NULL) {
		GHashTable* _tmp17_;
		gchar* _tmp18_;
		struct nl_addr* _tmp19_;
		gchar* _tmp20_ = NULL;
		_tmp17_ = *properties;
		_tmp18_ = g_strdup ("ADDR_PEER");
		_tmp19_ = peer;
		_tmp20_ = rtnl_addr_to_string (_tmp19_);
		g_hash_table_insert (_tmp17_, _tmp18_, _tmp20_);
	}
	_tmp21_ = addr;
	_tmp22_ = rtnl_addr_get_broadcast (_tmp21_);
	bcast = _tmp22_;
	_tmp23_ = bcast;
	if (_tmp23_ != NULL) {
		GHashTable* _tmp24_;
		gchar* _tmp25_;
		struct nl_addr* _tmp26_;
		gchar* _tmp27_ = NULL;
		_tmp24_ = *properties;
		_tmp25_ = g_strdup ("ADDR_BROADCAST");
		_tmp26_ = bcast;
		_tmp27_ = rtnl_addr_to_string (_tmp26_);
		g_hash_table_insert (_tmp24_, _tmp25_, _tmp27_);
	}
	_tmp28_ = addr;
	_tmp29_ = rtnl_addr_get_anycast (_tmp28_);
	a = _tmp29_;
	_tmp30_ = a;
	if (_tmp30_ != NULL) {
		GHashTable* _tmp31_;
		gchar* _tmp32_;
		struct nl_addr* _tmp33_;
		gchar* _tmp34_ = NULL;
		_tmp31_ = *properties;
		_tmp32_ = g_strdup ("ADDR_ANYCAST");
		_tmp33_ = a;
		_tmp34_ = rtnl_addr_to_string (_tmp33_);
		g_hash_table_insert (_tmp31_, _tmp32_, _tmp34_);
	}
	_tmp35_ = addr;
	_tmp36_ = rtnl_addr_get_multicast (_tmp35_);
	_0 (a);
	a = _tmp36_;
	_tmp37_ = a;
	if (_tmp37_ != NULL) {
		GHashTable* _tmp38_;
		gchar* _tmp39_;
		struct nl_addr* _tmp40_;
		gchar* _tmp41_ = NULL;
		_tmp38_ = *properties;
		_tmp39_ = g_strdup ("ADDR_MULTICAST");
		_tmp40_ = a;
		_tmp41_ = rtnl_addr_to_string (_tmp40_);
		g_hash_table_insert (_tmp38_, _tmp39_, _tmp41_);
	}
	_tmp42_ = *properties;
	_tmp43_ = g_strdup ("ADDR_PREFIXLEN");
	_tmp44_ = addr;
	_tmp45_ = rtnl_addr_get_prefixlen (_tmp44_);
	_tmp46_ = g_strdup_printf ("%i", _tmp45_);
	g_hash_table_insert (_tmp42_, _tmp43_, _tmp46_);
	_tmp47_ = *properties;
	_tmp48_ = g_strdup ("ADDR_IFINDEX");
	_tmp49_ = addr;
	_tmp50_ = rtnl_addr_get_ifindex (_tmp49_);
	_tmp51_ = g_strdup_printf ("%i", _tmp50_);
	g_hash_table_insert (_tmp47_, _tmp48_, _tmp51_);
	_tmp52_ = *properties;
	_tmp53_ = g_strdup ("ADDR_IFNAME");
	_tmp54_ = self->cache;
	_tmp55_ = addr;
	_tmp56_ = rtnl_addr_get_ifindex (_tmp55_);
	_tmp57_ = self->priv->buffer;
	_tmp57__length1 = self->priv->buffer_length1;
	_tmp58_ = rtnl_link_i2name (_tmp54_, _tmp56_, _tmp57_, _tmp57__length1);
	_tmp59_ = g_strdup (_tmp58_);
	g_hash_table_insert (_tmp52_, _tmp53_, _tmp59_);
	_tmp60_ = *properties;
	_tmp61_ = g_strdup ("ADDR_SCOPE");
	_tmp62_ = addr;
	_tmp63_ = rtnl_addr_get_scope (_tmp62_);
	_tmp64_ = self->priv->buffer;
	_tmp64__length1 = self->priv->buffer_length1;
	_tmp65_ = rtnl_scope2str (_tmp63_, _tmp64_, _tmp64__length1);
	_tmp66_ = g_strdup (_tmp65_);
	g_hash_table_insert (_tmp60_, _tmp61_, _tmp66_);
	_tmp67_ = *properties;
	_tmp68_ = g_strdup ("ADDR_LABEL");
	_tmp69_ = addr;
	_tmp70_ = rtnl_addr_get_label (_tmp69_);
	g_hash_table_insert (_tmp67_, _tmp68_, _tmp70_);
	_tmp71_ = *properties;
	_tmp72_ = g_strdup ("ADDR_FLAGS");
	_tmp73_ = addr;
	_tmp74_ = rtnl_addr_get_flags (_tmp73_);
	_tmp75_ = self->priv->buffer;
	_tmp75__length1 = self->priv->buffer_length1;
	_tmp76_ = rtnl_addr_flags2str (_tmp74_, _tmp75_, _tmp75__length1);
	_tmp77_ = g_strdup (_tmp76_);
	g_hash_table_insert (_tmp71_, _tmp72_, _tmp77_);
	_0 (a);
	_0 (bcast);
	_0 (peer);
	_0 (local);
}


void fso_framework_base_netlink_notifier_fillNeighbourProperties (FsoFrameworkBaseNetlinkNotifier* self, struct rtnl_neigh* neigh, GHashTable** properties) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	struct rtnl_neigh* _tmp2_;
	gint _tmp3_ = 0;
	gchar* _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	struct rtnl_neigh* _tmp7_;
	struct nl_addr* _tmp8_ = NULL;
	struct nl_addr* a;
	struct nl_addr* _tmp9_;
	struct rtnl_neigh* _tmp14_;
	struct nl_addr* _tmp15_ = NULL;
	struct nl_addr* _tmp16_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	struct rtnl_neigh* _tmp23_;
	gint _tmp24_ = 0;
	gchar* _tmp25_ = NULL;
	GHashTable* _tmp26_;
	gchar* _tmp27_;
	struct nl_cache* _tmp28_;
	struct rtnl_neigh* _tmp29_;
	gint _tmp30_ = 0;
	gchar* _tmp31_;
	gint _tmp31__length1;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	GHashTable* _tmp34_;
	gchar* _tmp35_;
	struct rtnl_neigh* _tmp36_;
	gint _tmp37_ = 0;
	gchar* _tmp38_;
	gint _tmp38__length1;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	GHashTable* _tmp41_;
	gchar* _tmp42_;
	struct rtnl_neigh* _tmp43_;
	guint _tmp44_ = 0U;
	gchar* _tmp45_;
	gint _tmp45__length1;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_;
	GHashTable* _tmp48_;
	gchar* _tmp49_;
	struct rtnl_neigh* _tmp50_;
	gint _tmp51_ = 0;
	gchar* _tmp52_;
	gint _tmp52__length1;
	const gchar* _tmp53_ = NULL;
	gchar* _tmp54_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (neigh != NULL);
	g_return_if_fail (*properties != NULL);
	_tmp0_ = *properties;
	_tmp1_ = g_strdup ("NEIGH_FAMILY");
	_tmp2_ = neigh;
	_tmp3_ = rtnl_neigh_get_family (_tmp2_);
	_tmp4_ = self->priv->buffer;
	_tmp4__length1 = self->priv->buffer_length1;
	_tmp5_ = nl_af2str (_tmp3_, _tmp4_, _tmp4__length1);
	_tmp6_ = g_strdup (_tmp5_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp6_);
	_tmp7_ = neigh;
	_tmp8_ = rtnl_neigh_get_lladdr (_tmp7_);
	a = _tmp8_;
	_tmp9_ = a;
	if (_tmp9_ != NULL) {
		GHashTable* _tmp10_;
		gchar* _tmp11_;
		struct nl_addr* _tmp12_;
		gchar* _tmp13_ = NULL;
		_tmp10_ = *properties;
		_tmp11_ = g_strdup ("NEIGH_LLADDR");
		_tmp12_ = a;
		_tmp13_ = rtnl_addr_to_string (_tmp12_);
		g_hash_table_insert (_tmp10_, _tmp11_, _tmp13_);
	}
	_tmp14_ = neigh;
	_tmp15_ = rtnl_neigh_get_dst (_tmp14_);
	_0 (a);
	a = _tmp15_;
	_tmp16_ = a;
	if (_tmp16_ != NULL) {
		GHashTable* _tmp17_;
		gchar* _tmp18_;
		struct nl_addr* _tmp19_;
		gchar* _tmp20_ = NULL;
		_tmp17_ = *properties;
		_tmp18_ = g_strdup ("NEIGH_DST");
		_tmp19_ = a;
		_tmp20_ = rtnl_addr_to_string (_tmp19_);
		g_hash_table_insert (_tmp17_, _tmp18_, _tmp20_);
	}
	_tmp21_ = *properties;
	_tmp22_ = g_strdup ("NEIGH_IFINDEX");
	_tmp23_ = neigh;
	_tmp24_ = rtnl_neigh_get_ifindex (_tmp23_);
	_tmp25_ = g_strdup_printf ("%i", _tmp24_);
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp25_);
	_tmp26_ = *properties;
	_tmp27_ = g_strdup ("NEIGH_IFNAME");
	_tmp28_ = self->cache;
	_tmp29_ = neigh;
	_tmp30_ = rtnl_neigh_get_ifindex (_tmp29_);
	_tmp31_ = self->priv->buffer;
	_tmp31__length1 = self->priv->buffer_length1;
	_tmp32_ = rtnl_link_i2name (_tmp28_, _tmp30_, _tmp31_, _tmp31__length1);
	_tmp33_ = g_strdup (_tmp32_);
	g_hash_table_insert (_tmp26_, _tmp27_, _tmp33_);
	_tmp34_ = *properties;
	_tmp35_ = g_strdup ("NEIGH_TYPE");
	_tmp36_ = neigh;
	_tmp37_ = rtnl_neigh_get_type (_tmp36_);
	_tmp38_ = self->priv->buffer;
	_tmp38__length1 = self->priv->buffer_length1;
	_tmp39_ = nl_rtntype2str (_tmp37_, _tmp38_, _tmp38__length1);
	_tmp40_ = g_strdup (_tmp39_);
	g_hash_table_insert (_tmp34_, _tmp35_, _tmp40_);
	_tmp41_ = *properties;
	_tmp42_ = g_strdup ("NEIGH_FLAGS");
	_tmp43_ = neigh;
	_tmp44_ = rtnl_neigh_get_flags (_tmp43_);
	_tmp45_ = self->priv->buffer;
	_tmp45__length1 = self->priv->buffer_length1;
	_tmp46_ = rtnl_neigh_flags2str (_tmp44_, _tmp45_, _tmp45__length1);
	_tmp47_ = g_strdup (_tmp46_);
	g_hash_table_insert (_tmp41_, _tmp42_, _tmp47_);
	_tmp48_ = *properties;
	_tmp49_ = g_strdup ("NEIGH_STATE");
	_tmp50_ = neigh;
	_tmp51_ = rtnl_neigh_get_state (_tmp50_);
	_tmp52_ = self->priv->buffer;
	_tmp52__length1 = self->priv->buffer_length1;
	_tmp53_ = rtnl_neigh_state2str (_tmp51_, _tmp52_, _tmp52__length1);
	_tmp54_ = g_strdup (_tmp53_);
	g_hash_table_insert (_tmp48_, _tmp49_, _tmp54_);
	_0 (a);
}


void fso_framework_base_netlink_notifier_fillRuleProperties (FsoFrameworkBaseNetlinkNotifier* self, struct rtnl_rule* rule, GHashTable** properties) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	struct rtnl_rule* _tmp2_;
	guint32 _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	GHashTable* _tmp5_;
	gchar* _tmp6_;
	struct rtnl_rule* _tmp7_;
	gint _tmp8_ = 0;
	gchar* _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	struct rtnl_rule* _tmp12_;
	struct nl_addr* _tmp13_ = NULL;
	struct nl_addr* a;
	struct nl_addr* _tmp14_;
	struct rtnl_rule* _tmp19_;
	struct nl_addr* _tmp20_ = NULL;
	struct nl_addr* _tmp21_;
	GHashTable* _tmp26_;
	gchar* _tmp27_;
	struct rtnl_rule* _tmp28_;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	GHashTable* _tmp31_;
	gchar* _tmp32_;
	struct rtnl_rule* _tmp33_;
	guint32 _tmp34_ = 0U;
	gchar* _tmp35_ = NULL;
	GHashTable* _tmp36_;
	gchar* _tmp37_;
	struct rtnl_rule* _tmp38_;
	guint32 _tmp39_ = 0U;
	gchar* _tmp40_ = NULL;
	GHashTable* _tmp41_;
	gchar* _tmp42_;
	struct rtnl_rule* _tmp43_;
	guint8 _tmp44_ = 0U;
	gchar* _tmp45_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rule != NULL);
	g_return_if_fail (*properties != NULL);
	_tmp0_ = *properties;
	_tmp1_ = g_strdup ("RULE_PRIORITY");
	_tmp2_ = rule;
	_tmp3_ = rtnl_rule_get_prio (_tmp2_);
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp4_);
	_tmp5_ = *properties;
	_tmp6_ = g_strdup ("RULE_FAMILY");
	_tmp7_ = rule;
	_tmp8_ = rtnl_rule_get_family (_tmp7_);
	_tmp9_ = self->priv->buffer;
	_tmp9__length1 = self->priv->buffer_length1;
	_tmp10_ = nl_af2str (_tmp8_, _tmp9_, _tmp9__length1);
	_tmp11_ = g_strdup (_tmp10_);
	g_hash_table_insert (_tmp5_, _tmp6_, _tmp11_);
	_tmp12_ = rule;
	_tmp13_ = rtnl_rule_get_dst (_tmp12_);
	a = _tmp13_;
	_tmp14_ = a;
	if (_tmp14_ != NULL) {
		GHashTable* _tmp15_;
		gchar* _tmp16_;
		struct nl_addr* _tmp17_;
		gchar* _tmp18_ = NULL;
		_tmp15_ = *properties;
		_tmp16_ = g_strdup ("RULE_DST");
		_tmp17_ = a;
		_tmp18_ = rtnl_addr_to_string (_tmp17_);
		g_hash_table_insert (_tmp15_, _tmp16_, _tmp18_);
	}
	_tmp19_ = rule;
	_tmp20_ = rtnl_rule_get_src (_tmp19_);
	_0 (a);
	a = _tmp20_;
	_tmp21_ = a;
	if (_tmp21_ != NULL) {
		GHashTable* _tmp22_;
		gchar* _tmp23_;
		struct nl_addr* _tmp24_;
		gchar* _tmp25_ = NULL;
		_tmp22_ = *properties;
		_tmp23_ = g_strdup ("RULE_SRC");
		_tmp24_ = a;
		_tmp25_ = rtnl_addr_to_string (_tmp24_);
		g_hash_table_insert (_tmp22_, _tmp23_, _tmp25_);
	}
	_tmp26_ = *properties;
	_tmp27_ = g_strdup ("RULE_IIF");
	_tmp28_ = rule;
	_tmp29_ = rtnl_rule_get_iif (_tmp28_);
	_tmp30_ = g_strdup (_tmp29_);
	g_hash_table_insert (_tmp26_, _tmp27_, _tmp30_);
	_tmp31_ = *properties;
	_tmp32_ = g_strdup ("RULE_REALM");
	_tmp33_ = rule;
	_tmp34_ = rtnl_rule_get_realms (_tmp33_);
	_tmp35_ = g_strdup_printf ("%u", _tmp34_);
	g_hash_table_insert (_tmp31_, _tmp32_, _tmp35_);
	_tmp36_ = *properties;
	_tmp37_ = g_strdup ("RULE_MARK");
	_tmp38_ = rule;
	_tmp39_ = rtnl_rule_get_mark (_tmp38_);
	_tmp40_ = g_strdup_printf ("0x%llx", _tmp39_);
	g_hash_table_insert (_tmp36_, _tmp37_, _tmp40_);
	_tmp41_ = *properties;
	_tmp42_ = g_strdup ("RULE_DSFIELD");
	_tmp43_ = rule;
	_tmp44_ = rtnl_rule_get_dsfield (_tmp43_);
	_tmp45_ = g_strdup_printf ("%hhu", _tmp44_);
	g_hash_table_insert (_tmp41_, _tmp42_, _tmp45_);
	_0 (a);
}


void fso_framework_base_netlink_notifier_fillQdiscProperties (FsoFrameworkBaseNetlinkNotifier* self, struct rtnl_qdisc* qdisc, GHashTable** properties) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (qdisc != NULL);
	g_return_if_fail (*properties != NULL);
}


void _fso_framework_base_netlink_notifier_addMatch (FsoFrameworkBaseNetlinkNotifier* self, guint16 type, FsoFrameworkNetlinkNotifierFunc callback, void* callback_target) {
	GHashTable* _tmp0_;
	guint16 _tmp1_;
	gconstpointer _tmp2_ = NULL;
	GList* list;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = type;
	_tmp2_ = g_hash_table_lookup (_tmp0_, GUINT_TO_POINTER (_tmp1_));
	list = (GList*) _tmp2_;
	_tmp3_ = list;
	if (_tmp3_ == NULL) {
		GList* newlist;
		FsoFrameworkNetlinkNotifierFunc _tmp4_;
		void* _tmp4__target;
		NetlinkDelegateHolder* _tmp5_;
		GHashTable* _tmp6_;
		guint16 _tmp7_;
		GList* _tmp8_;
		newlist = NULL;
		_tmp4_ = callback;
		_tmp4__target = callback_target;
		_tmp5_ = netlink_delegate_holder_new (_tmp4_, _tmp4__target);
		newlist = g_list_append (newlist, _tmp5_);
		_tmp6_ = self->priv->map;
		_tmp7_ = type;
		_tmp8_ = newlist;
		newlist = NULL;
		g_hash_table_insert (_tmp6_, GUINT_TO_POINTER (_tmp7_), _tmp8_);
		__g_list_free__netlink_delegate_holder_free0_0 (newlist);
	} else {
		FsoFrameworkNetlinkNotifierFunc _tmp9_;
		void* _tmp9__target;
		NetlinkDelegateHolder* _tmp10_;
		_tmp9_ = callback;
		_tmp9__target = callback_target;
		_tmp10_ = netlink_delegate_holder_new (_tmp9_, _tmp9__target);
		list = g_list_append (list, _tmp10_);
	}
}


void fso_framework_base_netlink_notifier_addMatch (guint16 action, FsoFrameworkNetlinkNotifierFunc callback, void* callback_target) {
	FsoFrameworkBaseNetlinkNotifier* _tmp0_;
	FsoFrameworkBaseNetlinkNotifier* _tmp2_;
	guint16 _tmp3_;
	FsoFrameworkNetlinkNotifierFunc _tmp4_;
	void* _tmp4__target;
	_tmp0_ = fso_framework_base_netlink_notifier_instance;
	if (_tmp0_ == NULL) {
		FsoFrameworkBaseNetlinkNotifier* _tmp1_;
		_tmp1_ = fso_framework_base_netlink_notifier_new ();
		_g_object_unref0 (fso_framework_base_netlink_notifier_instance);
		fso_framework_base_netlink_notifier_instance = _tmp1_;
	}
	_tmp2_ = fso_framework_base_netlink_notifier_instance;
	_tmp3_ = action;
	_tmp4_ = callback;
	_tmp4__target = callback_target;
	_fso_framework_base_netlink_notifier_addMatch (_tmp2_, (guint16) _tmp3_, _tmp4_, _tmp4__target);
}


static void fso_framework_base_netlink_notifier_class_init (FsoFrameworkBaseNetlinkNotifierClass * klass) {
	fso_framework_base_netlink_notifier_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkBaseNetlinkNotifierPrivate));
	G_OBJECT_CLASS (klass)->finalize = fso_framework_base_netlink_notifier_finalize;
}


static void fso_framework_base_netlink_notifier_instance_init (FsoFrameworkBaseNetlinkNotifier * self) {
	self->priv = FSO_FRAMEWORK_BASE_NETLINK_NOTIFIER_GET_PRIVATE (self);
	self->priv->fd = -1;
}


static void fso_framework_base_netlink_notifier_finalize (GObject* obj) {
	FsoFrameworkBaseNetlinkNotifier * self;
	guint _tmp0_;
	gint _tmp2_;
	self = FSO_FRAMEWORK_BASE_NETLINK_NOTIFIER (obj);
	_tmp0_ = self->priv->watch;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->watch;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = self->priv->fd;
	if (_tmp2_ != (-1)) {
		gint _tmp3_;
		_tmp3_ = self->priv->fd;
		close (_tmp3_);
	}
	_nl_cache_free0 (self->cache);
	_nl_socket_free0 (self->socket);
	_g_io_channel_unref0 (self->priv->channel);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	_g_hash_table_unref0 (self->priv->map);
	G_OBJECT_CLASS (fso_framework_base_netlink_notifier_parent_class)->finalize (obj);
}


/**
 * @class FsoFramework.BaseNetlinkNotifier
 **/
GType fso_framework_base_netlink_notifier_get_type (void) {
	static volatile gsize fso_framework_base_netlink_notifier_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_base_netlink_notifier_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkBaseNetlinkNotifierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_base_netlink_notifier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkBaseNetlinkNotifier), 0, (GInstanceInitFunc) fso_framework_base_netlink_notifier_instance_init, NULL };
		GType fso_framework_base_netlink_notifier_type_id;
		fso_framework_base_netlink_notifier_type_id = g_type_register_static (G_TYPE_OBJECT, "FsoFrameworkBaseNetlinkNotifier", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_base_netlink_notifier_type_id__volatile, fso_framework_base_netlink_notifier_type_id);
	}
	return fso_framework_base_netlink_notifier_type_id__volatile;
}



