/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;

public class SingletonIterator
implements AxisIterator,
ReversibleIterator,
LastPositionFinder {
    private Item value;
    private boolean gone;

    private SingletonIterator(Item item) {
        this.value = item;
        this.gone = item == null;
    }

    public static AxisIterator makeIterator(Item item) {
        if (item == null) {
            return EmptyIterator.getInstance();
        }
        return new SingletonIterator(item);
    }

    public Item next() {
        if (this.gone) {
            return null;
        }
        this.gone = true;
        return this.value;
    }

    public Item current() {
        return this.value;
    }

    public int position() {
        return 1;
    }

    public int getLastPosition() {
        return 1;
    }

    public SequenceIterator getAnother() {
        return new SingletonIterator(this.value);
    }

    public SequenceIterator getReverseIterator() {
        return new SingletonIterator(this.value);
    }

    public Item getValue() {
        return this.value;
    }
}

