//
//  Lynkeos
//  $Id: MyDocument.h,v 1.13 2005/01/27 23:00:30 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Thu Jul 29 2004.
//  Copyright (c) 2003-2005. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef __MYDOCUMENT_H
#define __MYDOCUMENT_H

#ifdef GNUSTEP
#else
#import <Cocoa/Cocoa.h>
#endif

#include "MyImageListItem.h"
#include "MyImageList.h"
#include "MyObjectImageList.h"
#include "MySizeLock.h"
#include "MyListProcessing.h"
#include "MyPostProcessing.h"
#include "MyImageListWindow.h"

/*!
 * @class MyDocument
 * @abstract The document controler
 * @discussion This class controls the actions on the document.
 *   It dialogs with MyImageListWindow for GUI interactions and
 *   the Models classes for document contents change.
 * @ingroup Controlers
 */
@interface MyDocument : NSDocument <MyListProcessingDelegate>
{
@private
   // Document data
   MyImageList*		_darkFrameList;   // Thermal noise images
   MyImageList*		_flatFieldList;   // Optical attenuations
   MyObjectImageList*   _imageList;       // Images to be processed
   BOOL                 _monochromeFlat;  // Wether to stack a monochrome flat

   MyAnalysisMethod      _analysisMethod;   // Selected image analysis method
   MySizeLock*          _sizeLock;        // Enforces sizes restrictions
   u_long               _stackedImageNb;  // Counter of stacked images
   NSImage*		_stackedImage;    // Processed image to display
   NSBitmapImageRep*	_stackedRep;      // Image associated representation
   long			_stack_sequence;  // Counter of stack data modif
   REAL                 _minLevel, _maxLevel;
   NSString*            _windowFrame;     // Used only upon loading

   /// Processing helper class
   MyPostProcessing*	_postProcess;

   /// Multithread control 
   NSMutableArray      *_threads;
   NSEnumerator        *_threadImageList;
   NSLock              *_alignLock;
   FFT_DATA             _alignSpectrum;

#ifdef GNUSTEP
#else
   // Sleep control
   io_connect_t         _rootPort;
#endif

   /// Window controller
   MyImageListWindow*	_myWindow;
}

/// \name Accessors
/// Read accessors to the class attributes
//@{
- (MyObjectImageList*) imageList ;      ///< Images to be processed
- (MyImageList*) darkFrameList;         ///< Thermal noise images
- (MyImageList*) flatFieldList;         ///< Optical attenuations
- (BOOL) monochromeFlat ;

- (MyAnalysisMethod) analysisMethod ;
- (MyIntegerSize) lockedSize ;
- (NSImage*) stackedImage ;
- (REAL) minLevel;
- (REAL) maxLevel;
- (NSString*) windowFrame;
//@}

/// \name GUIActions
/// Coming from window controllers
//@{
   // List
/*!
 * @method addEntry:
 * @abstract Add the item to the current list
 * @param item item to add to the list
 * @discussion The undo manager is updated for undoing the add
 */
- (void) addEntry :(MyImageListItem*)item ;
/*!
 * @method deleteEntry:
 * @abstract Remove the item from the current list
 * @param item item to remove from the list
 * @discussion The undo manager is updated for undoing the remove
 */
- (void) deleteEntry :(MyImageListItem*)item ;
- (void) changeEntrySelection :(MyImageListItem*)entry value:(BOOL)v ;
   // Align
- (void) changeReferenceEntry :(MyImageListItem*)entry ;
- (void) changeSearchSquareOrigin :(MyIntegerPoint)o ;
- (void) changeSearchSquareSide :(u_short)side ;
- (void) align ;
   // Analyze
- (void) changeAnalyzeSquareOrigin :(MyIntegerPoint)o ;
- (void) changeAnalyzeSquareSide : (u_short)side ;
- (void) changeAnalysisMethod :(MyAnalysisMethod )method;
- (void) autoChangeSelection :(double)selectThreshold;
- (void) analyzeQuality ;
   // Stack
- (void) changeCropRectangle :(MyIntegerRect)rect ;
- (void) setDoubleSize :(BOOL)ds ;
- (void) setMonochromeFlat :(BOOL)mono ;
- (void) stack ;
- (void) invalidateStackedImage ;
   // Process
- (void) postProcess :(double)dRadius :(double)dThreshold 
                     :(double)uRadius :(double) uGain ;
  // Display
- (void) adjustLevels :(REAL)minV :(REAL)maxV ;
   // Input output
- (void) saveStackedImage :(id)sender ;
- (void) exportMovie :(id)sender ;
//@}

/// Threads management
- (void)createConnectedThread :(Class)c ;

@end

#endif
