/*
    SPDX-FileCopyrightText: 2022-2024 Igor Mironchik <igor.mironchik@gmail.com>
    SPDX-License-Identifier: MIT
*/

// This file is autogenerated.

#ifndef MD4QT_ENTITIES_MAP_H_INCLUDED
#define MD4QT_ENTITIES_MAP_H_INCLUDED

#include <map>

namespace MD
{

template<class Trait>
static const std::map<typename Trait::String, const char16_t *> s_entityMap = {{Trait::latin1ToString("&AElig"), u"\x00C6"},
                                                                               {Trait::latin1ToString("&AElig;"), u"\x00C6"},
                                                                               {Trait::latin1ToString("&AMP"), u"\x0026"},
                                                                               {Trait::latin1ToString("&AMP;"), u"\x0026"},
                                                                               {Trait::latin1ToString("&Aacute"), u"\x00C1"},
                                                                               {Trait::latin1ToString("&Aacute;"), u"\x00C1"},
                                                                               {Trait::latin1ToString("&Abreve;"), u"\x0102"},
                                                                               {Trait::latin1ToString("&Acirc"), u"\x00C2"},
                                                                               {Trait::latin1ToString("&Acirc;"), u"\x00C2"},
                                                                               {Trait::latin1ToString("&Acy;"), u"\x0410"},
                                                                               {Trait::latin1ToString("&Afr;"), u"\xD835\xDD04"},
                                                                               {Trait::latin1ToString("&Agrave"), u"\x00C0"},
                                                                               {Trait::latin1ToString("&Agrave;"), u"\x00C0"},
                                                                               {Trait::latin1ToString("&Alpha;"), u"\x0391"},
                                                                               {Trait::latin1ToString("&Amacr;"), u"\x0100"},
                                                                               {Trait::latin1ToString("&And;"), u"\x2A53"},
                                                                               {Trait::latin1ToString("&Aogon;"), u"\x0104"},
                                                                               {Trait::latin1ToString("&Aopf;"), u"\xD835\xDD38"},
                                                                               {Trait::latin1ToString("&ApplyFunction;"), u"\x2061"},
                                                                               {Trait::latin1ToString("&Aring"), u"\x00C5"},
                                                                               {Trait::latin1ToString("&Aring;"), u"\x00C5"},
                                                                               {Trait::latin1ToString("&Ascr;"), u"\xD835\xDC9C"},
                                                                               {Trait::latin1ToString("&Assign;"), u"\x2254"},
                                                                               {Trait::latin1ToString("&Atilde"), u"\x00C3"},
                                                                               {Trait::latin1ToString("&Atilde;"), u"\x00C3"},
                                                                               {Trait::latin1ToString("&Auml"), u"\x00C4"},
                                                                               {Trait::latin1ToString("&Auml;"), u"\x00C4"},
                                                                               {Trait::latin1ToString("&Backslash;"), u"\x2216"},
                                                                               {Trait::latin1ToString("&Barv;"), u"\x2AE7"},
                                                                               {Trait::latin1ToString("&Barwed;"), u"\x2306"},
                                                                               {Trait::latin1ToString("&Bcy;"), u"\x0411"},
                                                                               {Trait::latin1ToString("&Because;"), u"\x2235"},
                                                                               {Trait::latin1ToString("&Bernoullis;"), u"\x212C"},
                                                                               {Trait::latin1ToString("&Beta;"), u"\x0392"},
                                                                               {Trait::latin1ToString("&Bfr;"), u"\xD835\xDD05"},
                                                                               {Trait::latin1ToString("&Bopf;"), u"\xD835\xDD39"},
                                                                               {Trait::latin1ToString("&Breve;"), u"\x02D8"},
                                                                               {Trait::latin1ToString("&Bscr;"), u"\x212C"},
                                                                               {Trait::latin1ToString("&Bumpeq;"), u"\x224E"},
                                                                               {Trait::latin1ToString("&CHcy;"), u"\x0427"},
                                                                               {Trait::latin1ToString("&COPY"), u"\x00A9"},
                                                                               {Trait::latin1ToString("&COPY;"), u"\x00A9"},
                                                                               {Trait::latin1ToString("&Cacute;"), u"\x0106"},
                                                                               {Trait::latin1ToString("&Cap;"), u"\x22D2"},
                                                                               {Trait::latin1ToString("&CapitalDifferentialD;"), u"\x2145"},
                                                                               {Trait::latin1ToString("&Cayleys;"), u"\x212D"},
                                                                               {Trait::latin1ToString("&Ccaron;"), u"\x010C"},
                                                                               {Trait::latin1ToString("&Ccedil"), u"\x00C7"},
                                                                               {Trait::latin1ToString("&Ccedil;"), u"\x00C7"},
                                                                               {Trait::latin1ToString("&Ccirc;"), u"\x0108"},
                                                                               {Trait::latin1ToString("&Cconint;"), u"\x2230"},
                                                                               {Trait::latin1ToString("&Cdot;"), u"\x010A"},
                                                                               {Trait::latin1ToString("&Cedilla;"), u"\x00B8"},
                                                                               {Trait::latin1ToString("&CenterDot;"), u"\x00B7"},
                                                                               {Trait::latin1ToString("&Cfr;"), u"\x212D"},
                                                                               {Trait::latin1ToString("&Chi;"), u"\x03A7"},
                                                                               {Trait::latin1ToString("&CircleDot;"), u"\x2299"},
                                                                               {Trait::latin1ToString("&CircleMinus;"), u"\x2296"},
                                                                               {Trait::latin1ToString("&CirclePlus;"), u"\x2295"},
                                                                               {Trait::latin1ToString("&CircleTimes;"), u"\x2297"},
                                                                               {Trait::latin1ToString("&ClockwiseContourIntegral;"), u"\x2232"},
                                                                               {Trait::latin1ToString("&CloseCurlyDoubleQuote;"), u"\x201D"},
                                                                               {Trait::latin1ToString("&CloseCurlyQuote;"), u"\x2019"},
                                                                               {Trait::latin1ToString("&Colon;"), u"\x2237"},
                                                                               {Trait::latin1ToString("&Colone;"), u"\x2A74"},
                                                                               {Trait::latin1ToString("&Congruent;"), u"\x2261"},
                                                                               {Trait::latin1ToString("&Conint;"), u"\x222F"},
                                                                               {Trait::latin1ToString("&ContourIntegral;"), u"\x222E"},
                                                                               {Trait::latin1ToString("&Copf;"), u"\x2102"},
                                                                               {Trait::latin1ToString("&Coproduct;"), u"\x2210"},
                                                                               {Trait::latin1ToString("&CounterClockwiseContourIntegral;"), u"\x2233"},
                                                                               {Trait::latin1ToString("&Cross;"), u"\x2A2F"},
                                                                               {Trait::latin1ToString("&Cscr;"), u"\xD835\xDC9E"},
                                                                               {Trait::latin1ToString("&Cup;"), u"\x22D3"},
                                                                               {Trait::latin1ToString("&CupCap;"), u"\x224D"},
                                                                               {Trait::latin1ToString("&DD;"), u"\x2145"},
                                                                               {Trait::latin1ToString("&DDotrahd;"), u"\x2911"},
                                                                               {Trait::latin1ToString("&DJcy;"), u"\x0402"},
                                                                               {Trait::latin1ToString("&DScy;"), u"\x0405"},
                                                                               {Trait::latin1ToString("&DZcy;"), u"\x040F"},
                                                                               {Trait::latin1ToString("&Dagger;"), u"\x2021"},
                                                                               {Trait::latin1ToString("&Darr;"), u"\x21A1"},
                                                                               {Trait::latin1ToString("&Dashv;"), u"\x2AE4"},
                                                                               {Trait::latin1ToString("&Dcaron;"), u"\x010E"},
                                                                               {Trait::latin1ToString("&Dcy;"), u"\x0414"},
                                                                               {Trait::latin1ToString("&Del;"), u"\x2207"},
                                                                               {Trait::latin1ToString("&Delta;"), u"\x0394"},
                                                                               {Trait::latin1ToString("&Dfr;"), u"\xD835\xDD07"},
                                                                               {Trait::latin1ToString("&DiacriticalAcute;"), u"\x00B4"},
                                                                               {Trait::latin1ToString("&DiacriticalDot;"), u"\x02D9"},
                                                                               {Trait::latin1ToString("&DiacriticalDoubleAcute;"), u"\x02DD"},
                                                                               {Trait::latin1ToString("&DiacriticalGrave;"), u"\x0060"},
                                                                               {Trait::latin1ToString("&DiacriticalTilde;"), u"\x02DC"},
                                                                               {Trait::latin1ToString("&Diamond;"), u"\x22C4"},
                                                                               {Trait::latin1ToString("&DifferentialD;"), u"\x2146"},
                                                                               {Trait::latin1ToString("&Dopf;"), u"\xD835\xDD3B"},
                                                                               {Trait::latin1ToString("&Dot;"), u"\x00A8"},
                                                                               {Trait::latin1ToString("&DotDot;"), u"\x20DC"},
                                                                               {Trait::latin1ToString("&DotEqual;"), u"\x2250"},
                                                                               {Trait::latin1ToString("&DoubleContourIntegral;"), u"\x222F"},
                                                                               {Trait::latin1ToString("&DoubleDot;"), u"\x00A8"},
                                                                               {Trait::latin1ToString("&DoubleDownArrow;"), u"\x21D3"},
                                                                               {Trait::latin1ToString("&DoubleLeftArrow;"), u"\x21D0"},
                                                                               {Trait::latin1ToString("&DoubleLeftRightArrow;"), u"\x21D4"},
                                                                               {Trait::latin1ToString("&DoubleLeftTee;"), u"\x2AE4"},
                                                                               {Trait::latin1ToString("&DoubleLongLeftArrow;"), u"\x27F8"},
                                                                               {Trait::latin1ToString("&DoubleLongLeftRightArrow;"), u"\x27FA"},
                                                                               {Trait::latin1ToString("&DoubleLongRightArrow;"), u"\x27F9"},
                                                                               {Trait::latin1ToString("&DoubleRightArrow;"), u"\x21D2"},
                                                                               {Trait::latin1ToString("&DoubleRightTee;"), u"\x22A8"},
                                                                               {Trait::latin1ToString("&DoubleUpArrow;"), u"\x21D1"},
                                                                               {Trait::latin1ToString("&DoubleUpDownArrow;"), u"\x21D5"},
                                                                               {Trait::latin1ToString("&DoubleVerticalBar;"), u"\x2225"},
                                                                               {Trait::latin1ToString("&DownArrow;"), u"\x2193"},
                                                                               {Trait::latin1ToString("&DownArrowBar;"), u"\x2913"},
                                                                               {Trait::latin1ToString("&DownArrowUpArrow;"), u"\x21F5"},
                                                                               {Trait::latin1ToString("&DownBreve;"), u"\x0311"},
                                                                               {Trait::latin1ToString("&DownLeftRightVector;"), u"\x2950"},
                                                                               {Trait::latin1ToString("&DownLeftTeeVector;"), u"\x295E"},
                                                                               {Trait::latin1ToString("&DownLeftVector;"), u"\x21BD"},
                                                                               {Trait::latin1ToString("&DownLeftVectorBar;"), u"\x2956"},
                                                                               {Trait::latin1ToString("&DownRightTeeVector;"), u"\x295F"},
                                                                               {Trait::latin1ToString("&DownRightVector;"), u"\x21C1"},
                                                                               {Trait::latin1ToString("&DownRightVectorBar;"), u"\x2957"},
                                                                               {Trait::latin1ToString("&DownTee;"), u"\x22A4"},
                                                                               {Trait::latin1ToString("&DownTeeArrow;"), u"\x21A7"},
                                                                               {Trait::latin1ToString("&Downarrow;"), u"\x21D3"},
                                                                               {Trait::latin1ToString("&Dscr;"), u"\xD835\xDC9F"},
                                                                               {Trait::latin1ToString("&Dstrok;"), u"\x0110"},
                                                                               {Trait::latin1ToString("&ENG;"), u"\x014A"},
                                                                               {Trait::latin1ToString("&ETH"), u"\x00D0"},
                                                                               {Trait::latin1ToString("&ETH;"), u"\x00D0"},
                                                                               {Trait::latin1ToString("&Eacute"), u"\x00C9"},
                                                                               {Trait::latin1ToString("&Eacute;"), u"\x00C9"},
                                                                               {Trait::latin1ToString("&Ecaron;"), u"\x011A"},
                                                                               {Trait::latin1ToString("&Ecirc"), u"\x00CA"},
                                                                               {Trait::latin1ToString("&Ecirc;"), u"\x00CA"},
                                                                               {Trait::latin1ToString("&Ecy;"), u"\x042D"},
                                                                               {Trait::latin1ToString("&Edot;"), u"\x0116"},
                                                                               {Trait::latin1ToString("&Efr;"), u"\xD835\xDD08"},
                                                                               {Trait::latin1ToString("&Egrave"), u"\x00C8"},
                                                                               {Trait::latin1ToString("&Egrave;"), u"\x00C8"},
                                                                               {Trait::latin1ToString("&Element;"), u"\x2208"},
                                                                               {Trait::latin1ToString("&Emacr;"), u"\x0112"},
                                                                               {Trait::latin1ToString("&EmptySmallSquare;"), u"\x25FB"},
                                                                               {Trait::latin1ToString("&EmptyVerySmallSquare;"), u"\x25AB"},
                                                                               {Trait::latin1ToString("&Eogon;"), u"\x0118"},
                                                                               {Trait::latin1ToString("&Eopf;"), u"\xD835\xDD3C"},
                                                                               {Trait::latin1ToString("&Epsilon;"), u"\x0395"},
                                                                               {Trait::latin1ToString("&Equal;"), u"\x2A75"},
                                                                               {Trait::latin1ToString("&EqualTilde;"), u"\x2242"},
                                                                               {Trait::latin1ToString("&Equilibrium;"), u"\x21CC"},
                                                                               {Trait::latin1ToString("&Escr;"), u"\x2130"},
                                                                               {Trait::latin1ToString("&Esim;"), u"\x2A73"},
                                                                               {Trait::latin1ToString("&Eta;"), u"\x0397"},
                                                                               {Trait::latin1ToString("&Euml"), u"\x00CB"},
                                                                               {Trait::latin1ToString("&Euml;"), u"\x00CB"},
                                                                               {Trait::latin1ToString("&Exists;"), u"\x2203"},
                                                                               {Trait::latin1ToString("&ExponentialE;"), u"\x2147"},
                                                                               {Trait::latin1ToString("&Fcy;"), u"\x0424"},
                                                                               {Trait::latin1ToString("&Ffr;"), u"\xD835\xDD09"},
                                                                               {Trait::latin1ToString("&FilledSmallSquare;"), u"\x25FC"},
                                                                               {Trait::latin1ToString("&FilledVerySmallSquare;"), u"\x25AA"},
                                                                               {Trait::latin1ToString("&Fopf;"), u"\xD835\xDD3D"},
                                                                               {Trait::latin1ToString("&ForAll;"), u"\x2200"},
                                                                               {Trait::latin1ToString("&Fouriertrf;"), u"\x2131"},
                                                                               {Trait::latin1ToString("&Fscr;"), u"\x2131"},
                                                                               {Trait::latin1ToString("&GJcy;"), u"\x0403"},
                                                                               {Trait::latin1ToString("&GT"), u"\x003E"},
                                                                               {Trait::latin1ToString("&GT;"), u"\x003E"},
                                                                               {Trait::latin1ToString("&Gamma;"), u"\x0393"},
                                                                               {Trait::latin1ToString("&Gammad;"), u"\x03DC"},
                                                                               {Trait::latin1ToString("&Gbreve;"), u"\x011E"},
                                                                               {Trait::latin1ToString("&Gcedil;"), u"\x0122"},
                                                                               {Trait::latin1ToString("&Gcirc;"), u"\x011C"},
                                                                               {Trait::latin1ToString("&Gcy;"), u"\x0413"},
                                                                               {Trait::latin1ToString("&Gdot;"), u"\x0120"},
                                                                               {Trait::latin1ToString("&Gfr;"), u"\xD835\xDD0A"},
                                                                               {Trait::latin1ToString("&Gg;"), u"\x22D9"},
                                                                               {Trait::latin1ToString("&Gopf;"), u"\xD835\xDD3E"},
                                                                               {Trait::latin1ToString("&GreaterEqual;"), u"\x2265"},
                                                                               {Trait::latin1ToString("&GreaterEqualLess;"), u"\x22DB"},
                                                                               {Trait::latin1ToString("&GreaterFullEqual;"), u"\x2267"},
                                                                               {Trait::latin1ToString("&GreaterGreater;"), u"\x2AA2"},
                                                                               {Trait::latin1ToString("&GreaterLess;"), u"\x2277"},
                                                                               {Trait::latin1ToString("&GreaterSlantEqual;"), u"\x2A7E"},
                                                                               {Trait::latin1ToString("&GreaterTilde;"), u"\x2273"},
                                                                               {Trait::latin1ToString("&Gscr;"), u"\xD835\xDCA2"},
                                                                               {Trait::latin1ToString("&Gt;"), u"\x226B"},
                                                                               {Trait::latin1ToString("&HARDcy;"), u"\x042A"},
                                                                               {Trait::latin1ToString("&Hacek;"), u"\x02C7"},
                                                                               {Trait::latin1ToString("&Hat;"), u"\x005E"},
                                                                               {Trait::latin1ToString("&Hcirc;"), u"\x0124"},
                                                                               {Trait::latin1ToString("&Hfr;"), u"\x210C"},
                                                                               {Trait::latin1ToString("&HilbertSpace;"), u"\x210B"},
                                                                               {Trait::latin1ToString("&Hopf;"), u"\x210D"},
                                                                               {Trait::latin1ToString("&HorizontalLine;"), u"\x2500"},
                                                                               {Trait::latin1ToString("&Hscr;"), u"\x210B"},
                                                                               {Trait::latin1ToString("&Hstrok;"), u"\x0126"},
                                                                               {Trait::latin1ToString("&HumpDownHump;"), u"\x224E"},
                                                                               {Trait::latin1ToString("&HumpEqual;"), u"\x224F"},
                                                                               {Trait::latin1ToString("&IEcy;"), u"\x0415"},
                                                                               {Trait::latin1ToString("&IJlig;"), u"\x0132"},
                                                                               {Trait::latin1ToString("&IOcy;"), u"\x0401"},
                                                                               {Trait::latin1ToString("&Iacute"), u"\x00CD"},
                                                                               {Trait::latin1ToString("&Iacute;"), u"\x00CD"},
                                                                               {Trait::latin1ToString("&Icirc"), u"\x00CE"},
                                                                               {Trait::latin1ToString("&Icirc;"), u"\x00CE"},
                                                                               {Trait::latin1ToString("&Icy;"), u"\x0418"},
                                                                               {Trait::latin1ToString("&Idot;"), u"\x0130"},
                                                                               {Trait::latin1ToString("&Ifr;"), u"\x2111"},
                                                                               {Trait::latin1ToString("&Igrave"), u"\x00CC"},
                                                                               {Trait::latin1ToString("&Igrave;"), u"\x00CC"},
                                                                               {Trait::latin1ToString("&Im;"), u"\x2111"},
                                                                               {Trait::latin1ToString("&Imacr;"), u"\x012A"},
                                                                               {Trait::latin1ToString("&ImaginaryI;"), u"\x2148"},
                                                                               {Trait::latin1ToString("&Implies;"), u"\x21D2"},
                                                                               {Trait::latin1ToString("&Int;"), u"\x222C"},
                                                                               {Trait::latin1ToString("&Integral;"), u"\x222B"},
                                                                               {Trait::latin1ToString("&Intersection;"), u"\x22C2"},
                                                                               {Trait::latin1ToString("&InvisibleComma;"), u"\x2063"},
                                                                               {Trait::latin1ToString("&InvisibleTimes;"), u"\x2062"},
                                                                               {Trait::latin1ToString("&Iogon;"), u"\x012E"},
                                                                               {Trait::latin1ToString("&Iopf;"), u"\xD835\xDD40"},
                                                                               {Trait::latin1ToString("&Iota;"), u"\x0399"},
                                                                               {Trait::latin1ToString("&Iscr;"), u"\x2110"},
                                                                               {Trait::latin1ToString("&Itilde;"), u"\x0128"},
                                                                               {Trait::latin1ToString("&Iukcy;"), u"\x0406"},
                                                                               {Trait::latin1ToString("&Iuml"), u"\x00CF"},
                                                                               {Trait::latin1ToString("&Iuml;"), u"\x00CF"},
                                                                               {Trait::latin1ToString("&Jcirc;"), u"\x0134"},
                                                                               {Trait::latin1ToString("&Jcy;"), u"\x0419"},
                                                                               {Trait::latin1ToString("&Jfr;"), u"\xD835\xDD0D"},
                                                                               {Trait::latin1ToString("&Jopf;"), u"\xD835\xDD41"},
                                                                               {Trait::latin1ToString("&Jscr;"), u"\xD835\xDCA5"},
                                                                               {Trait::latin1ToString("&Jsercy;"), u"\x0408"},
                                                                               {Trait::latin1ToString("&Jukcy;"), u"\x0404"},
                                                                               {Trait::latin1ToString("&KHcy;"), u"\x0425"},
                                                                               {Trait::latin1ToString("&KJcy;"), u"\x040C"},
                                                                               {Trait::latin1ToString("&Kappa;"), u"\x039A"},
                                                                               {Trait::latin1ToString("&Kcedil;"), u"\x0136"},
                                                                               {Trait::latin1ToString("&Kcy;"), u"\x041A"},
                                                                               {Trait::latin1ToString("&Kfr;"), u"\xD835\xDD0E"},
                                                                               {Trait::latin1ToString("&Kopf;"), u"\xD835\xDD42"},
                                                                               {Trait::latin1ToString("&Kscr;"), u"\xD835\xDCA6"},
                                                                               {Trait::latin1ToString("&LJcy;"), u"\x0409"},
                                                                               {Trait::latin1ToString("&LT"), u"\x003C"},
                                                                               {Trait::latin1ToString("&LT;"), u"\x003C"},
                                                                               {Trait::latin1ToString("&Lacute;"), u"\x0139"},
                                                                               {Trait::latin1ToString("&Lambda;"), u"\x039B"},
                                                                               {Trait::latin1ToString("&Lang;"), u"\x27EA"},
                                                                               {Trait::latin1ToString("&Laplacetrf;"), u"\x2112"},
                                                                               {Trait::latin1ToString("&Larr;"), u"\x219E"},
                                                                               {Trait::latin1ToString("&Lcaron;"), u"\x013D"},
                                                                               {Trait::latin1ToString("&Lcedil;"), u"\x013B"},
                                                                               {Trait::latin1ToString("&Lcy;"), u"\x041B"},
                                                                               {Trait::latin1ToString("&LeftAngleBracket;"), u"\x27E8"},
                                                                               {Trait::latin1ToString("&LeftArrow;"), u"\x2190"},
                                                                               {Trait::latin1ToString("&LeftArrowBar;"), u"\x21E4"},
                                                                               {Trait::latin1ToString("&LeftArrowRightArrow;"), u"\x21C6"},
                                                                               {Trait::latin1ToString("&LeftCeiling;"), u"\x2308"},
                                                                               {Trait::latin1ToString("&LeftDoubleBracket;"), u"\x27E6"},
                                                                               {Trait::latin1ToString("&LeftDownTeeVector;"), u"\x2961"},
                                                                               {Trait::latin1ToString("&LeftDownVector;"), u"\x21C3"},
                                                                               {Trait::latin1ToString("&LeftDownVectorBar;"), u"\x2959"},
                                                                               {Trait::latin1ToString("&LeftFloor;"), u"\x230A"},
                                                                               {Trait::latin1ToString("&LeftRightArrow;"), u"\x2194"},
                                                                               {Trait::latin1ToString("&LeftRightVector;"), u"\x294E"},
                                                                               {Trait::latin1ToString("&LeftTee;"), u"\x22A3"},
                                                                               {Trait::latin1ToString("&LeftTeeArrow;"), u"\x21A4"},
                                                                               {Trait::latin1ToString("&LeftTeeVector;"), u"\x295A"},
                                                                               {Trait::latin1ToString("&LeftTriangle;"), u"\x22B2"},
                                                                               {Trait::latin1ToString("&LeftTriangleBar;"), u"\x29CF"},
                                                                               {Trait::latin1ToString("&LeftTriangleEqual;"), u"\x22B4"},
                                                                               {Trait::latin1ToString("&LeftUpDownVector;"), u"\x2951"},
                                                                               {Trait::latin1ToString("&LeftUpTeeVector;"), u"\x2960"},
                                                                               {Trait::latin1ToString("&LeftUpVector;"), u"\x21BF"},
                                                                               {Trait::latin1ToString("&LeftUpVectorBar;"), u"\x2958"},
                                                                               {Trait::latin1ToString("&LeftVector;"), u"\x21BC"},
                                                                               {Trait::latin1ToString("&LeftVectorBar;"), u"\x2952"},
                                                                               {Trait::latin1ToString("&Leftarrow;"), u"\x21D0"},
                                                                               {Trait::latin1ToString("&Leftrightarrow;"), u"\x21D4"},
                                                                               {Trait::latin1ToString("&LessEqualGreater;"), u"\x22DA"},
                                                                               {Trait::latin1ToString("&LessFullEqual;"), u"\x2266"},
                                                                               {Trait::latin1ToString("&LessGreater;"), u"\x2276"},
                                                                               {Trait::latin1ToString("&LessLess;"), u"\x2AA1"},
                                                                               {Trait::latin1ToString("&LessSlantEqual;"), u"\x2A7D"},
                                                                               {Trait::latin1ToString("&LessTilde;"), u"\x2272"},
                                                                               {Trait::latin1ToString("&Lfr;"), u"\xD835\xDD0F"},
                                                                               {Trait::latin1ToString("&Ll;"), u"\x22D8"},
                                                                               {Trait::latin1ToString("&Lleftarrow;"), u"\x21DA"},
                                                                               {Trait::latin1ToString("&Lmidot;"), u"\x013F"},
                                                                               {Trait::latin1ToString("&LongLeftArrow;"), u"\x27F5"},
                                                                               {Trait::latin1ToString("&LongLeftRightArrow;"), u"\x27F7"},
                                                                               {Trait::latin1ToString("&LongRightArrow;"), u"\x27F6"},
                                                                               {Trait::latin1ToString("&Longleftarrow;"), u"\x27F8"},
                                                                               {Trait::latin1ToString("&Longleftrightarrow;"), u"\x27FA"},
                                                                               {Trait::latin1ToString("&Longrightarrow;"), u"\x27F9"},
                                                                               {Trait::latin1ToString("&Lopf;"), u"\xD835\xDD43"},
                                                                               {Trait::latin1ToString("&LowerLeftArrow;"), u"\x2199"},
                                                                               {Trait::latin1ToString("&LowerRightArrow;"), u"\x2198"},
                                                                               {Trait::latin1ToString("&Lscr;"), u"\x2112"},
                                                                               {Trait::latin1ToString("&Lsh;"), u"\x21B0"},
                                                                               {Trait::latin1ToString("&Lstrok;"), u"\x0141"},
                                                                               {Trait::latin1ToString("&Lt;"), u"\x226A"},
                                                                               {Trait::latin1ToString("&Map;"), u"\x2905"},
                                                                               {Trait::latin1ToString("&Mcy;"), u"\x041C"},
                                                                               {Trait::latin1ToString("&MediumSpace;"), u"\x205F"},
                                                                               {Trait::latin1ToString("&Mellintrf;"), u"\x2133"},
                                                                               {Trait::latin1ToString("&Mfr;"), u"\xD835\xDD10"},
                                                                               {Trait::latin1ToString("&MinusPlus;"), u"\x2213"},
                                                                               {Trait::latin1ToString("&Mopf;"), u"\xD835\xDD44"},
                                                                               {Trait::latin1ToString("&Mscr;"), u"\x2133"},
                                                                               {Trait::latin1ToString("&Mu;"), u"\x039C"},
                                                                               {Trait::latin1ToString("&NJcy;"), u"\x040A"},
                                                                               {Trait::latin1ToString("&Nacute;"), u"\x0143"},
                                                                               {Trait::latin1ToString("&Ncaron;"), u"\x0147"},
                                                                               {Trait::latin1ToString("&Ncedil;"), u"\x0145"},
                                                                               {Trait::latin1ToString("&Ncy;"), u"\x041D"},
                                                                               {Trait::latin1ToString("&NegativeMediumSpace;"), u"\x200B"},
                                                                               {Trait::latin1ToString("&NegativeThickSpace;"), u"\x200B"},
                                                                               {Trait::latin1ToString("&NegativeThinSpace;"), u"\x200B"},
                                                                               {Trait::latin1ToString("&NegativeVeryThinSpace;"), u"\x200B"},
                                                                               {Trait::latin1ToString("&NestedGreaterGreater;"), u"\x226B"},
                                                                               {Trait::latin1ToString("&NestedLessLess;"), u"\x226A"},
                                                                               {Trait::latin1ToString("&NewLine;"), u"\x000A"},
                                                                               {Trait::latin1ToString("&Nfr;"), u"\xD835\xDD11"},
                                                                               {Trait::latin1ToString("&NoBreak;"), u"\x2060"},
                                                                               {Trait::latin1ToString("&NonBreakingSpace;"), u"\x00A0"},
                                                                               {Trait::latin1ToString("&Nopf;"), u"\x2115"},
                                                                               {Trait::latin1ToString("&Not;"), u"\x2AEC"},
                                                                               {Trait::latin1ToString("&NotCongruent;"), u"\x2262"},
                                                                               {Trait::latin1ToString("&NotCupCap;"), u"\x226D"},
                                                                               {Trait::latin1ToString("&NotDoubleVerticalBar;"), u"\x2226"},
                                                                               {Trait::latin1ToString("&NotElement;"), u"\x2209"},
                                                                               {Trait::latin1ToString("&NotEqual;"), u"\x2260"},
                                                                               {Trait::latin1ToString("&NotEqualTilde;"), u"\x2242\x0338"},
                                                                               {Trait::latin1ToString("&NotExists;"), u"\x2204"},
                                                                               {Trait::latin1ToString("&NotGreater;"), u"\x226F"},
                                                                               {Trait::latin1ToString("&NotGreaterEqual;"), u"\x2271"},
                                                                               {Trait::latin1ToString("&NotGreaterFullEqual;"), u"\x2267\x0338"},
                                                                               {Trait::latin1ToString("&NotGreaterGreater;"), u"\x226B\x0338"},
                                                                               {Trait::latin1ToString("&NotGreaterLess;"), u"\x2279"},
                                                                               {Trait::latin1ToString("&NotGreaterSlantEqual;"), u"\x2A7E\x0338"},
                                                                               {Trait::latin1ToString("&NotGreaterTilde;"), u"\x2275"},
                                                                               {Trait::latin1ToString("&NotHumpDownHump;"), u"\x224E\x0338"},
                                                                               {Trait::latin1ToString("&NotHumpEqual;"), u"\x224F\x0338"},
                                                                               {Trait::latin1ToString("&NotLeftTriangle;"), u"\x22EA"},
                                                                               {Trait::latin1ToString("&NotLeftTriangleBar;"), u"\x29CF\x0338"},
                                                                               {Trait::latin1ToString("&NotLeftTriangleEqual;"), u"\x22EC"},
                                                                               {Trait::latin1ToString("&NotLess;"), u"\x226E"},
                                                                               {Trait::latin1ToString("&NotLessEqual;"), u"\x2270"},
                                                                               {Trait::latin1ToString("&NotLessGreater;"), u"\x2278"},
                                                                               {Trait::latin1ToString("&NotLessLess;"), u"\x226A\x0338"},
                                                                               {Trait::latin1ToString("&NotLessSlantEqual;"), u"\x2A7D\x0338"},
                                                                               {Trait::latin1ToString("&NotLessTilde;"), u"\x2274"},
                                                                               {Trait::latin1ToString("&NotNestedGreaterGreater;"), u"\x2AA2\x0338"},
                                                                               {Trait::latin1ToString("&NotNestedLessLess;"), u"\x2AA1\x0338"},
                                                                               {Trait::latin1ToString("&NotPrecedes;"), u"\x2280"},
                                                                               {Trait::latin1ToString("&NotPrecedesEqual;"), u"\x2AAF\x0338"},
                                                                               {Trait::latin1ToString("&NotPrecedesSlantEqual;"), u"\x22E0"},
                                                                               {Trait::latin1ToString("&NotReverseElement;"), u"\x220C"},
                                                                               {Trait::latin1ToString("&NotRightTriangle;"), u"\x22EB"},
                                                                               {Trait::latin1ToString("&NotRightTriangleBar;"), u"\x29D0\x0338"},
                                                                               {Trait::latin1ToString("&NotRightTriangleEqual;"), u"\x22ED"},
                                                                               {Trait::latin1ToString("&NotSquareSubset;"), u"\x228F\x0338"},
                                                                               {Trait::latin1ToString("&NotSquareSubsetEqual;"), u"\x22E2"},
                                                                               {Trait::latin1ToString("&NotSquareSuperset;"), u"\x2290\x0338"},
                                                                               {Trait::latin1ToString("&NotSquareSupersetEqual;"), u"\x22E3"},
                                                                               {Trait::latin1ToString("&NotSubset;"), u"\x2282\x20D2"},
                                                                               {Trait::latin1ToString("&NotSubsetEqual;"), u"\x2288"},
                                                                               {Trait::latin1ToString("&NotSucceeds;"), u"\x2281"},
                                                                               {Trait::latin1ToString("&NotSucceedsEqual;"), u"\x2AB0\x0338"},
                                                                               {Trait::latin1ToString("&NotSucceedsSlantEqual;"), u"\x22E1"},
                                                                               {Trait::latin1ToString("&NotSucceedsTilde;"), u"\x227F\x0338"},
                                                                               {Trait::latin1ToString("&NotSuperset;"), u"\x2283\x20D2"},
                                                                               {Trait::latin1ToString("&NotSupersetEqual;"), u"\x2289"},
                                                                               {Trait::latin1ToString("&NotTilde;"), u"\x2241"},
                                                                               {Trait::latin1ToString("&NotTildeEqual;"), u"\x2244"},
                                                                               {Trait::latin1ToString("&NotTildeFullEqual;"), u"\x2247"},
                                                                               {Trait::latin1ToString("&NotTildeTilde;"), u"\x2249"},
                                                                               {Trait::latin1ToString("&NotVerticalBar;"), u"\x2224"},
                                                                               {Trait::latin1ToString("&Nscr;"), u"\xD835\xDCA9"},
                                                                               {Trait::latin1ToString("&Ntilde"), u"\x00D1"},
                                                                               {Trait::latin1ToString("&Ntilde;"), u"\x00D1"},
                                                                               {Trait::latin1ToString("&Nu;"), u"\x039D"},
                                                                               {Trait::latin1ToString("&OElig;"), u"\x0152"},
                                                                               {Trait::latin1ToString("&Oacute"), u"\x00D3"},
                                                                               {Trait::latin1ToString("&Oacute;"), u"\x00D3"},
                                                                               {Trait::latin1ToString("&Ocirc"), u"\x00D4"},
                                                                               {Trait::latin1ToString("&Ocirc;"), u"\x00D4"},
                                                                               {Trait::latin1ToString("&Ocy;"), u"\x041E"},
                                                                               {Trait::latin1ToString("&Odblac;"), u"\x0150"},
                                                                               {Trait::latin1ToString("&Ofr;"), u"\xD835\xDD12"},
                                                                               {Trait::latin1ToString("&Ograve"), u"\x00D2"},
                                                                               {Trait::latin1ToString("&Ograve;"), u"\x00D2"},
                                                                               {Trait::latin1ToString("&Omacr;"), u"\x014C"},
                                                                               {Trait::latin1ToString("&Omega;"), u"\x03A9"},
                                                                               {Trait::latin1ToString("&Omicron;"), u"\x039F"},
                                                                               {Trait::latin1ToString("&Oopf;"), u"\xD835\xDD46"},
                                                                               {Trait::latin1ToString("&OpenCurlyDoubleQuote;"), u"\x201C"},
                                                                               {Trait::latin1ToString("&OpenCurlyQuote;"), u"\x2018"},
                                                                               {Trait::latin1ToString("&Or;"), u"\x2A54"},
                                                                               {Trait::latin1ToString("&Oscr;"), u"\xD835\xDCAA"},
                                                                               {Trait::latin1ToString("&Oslash"), u"\x00D8"},
                                                                               {Trait::latin1ToString("&Oslash;"), u"\x00D8"},
                                                                               {Trait::latin1ToString("&Otilde"), u"\x00D5"},
                                                                               {Trait::latin1ToString("&Otilde;"), u"\x00D5"},
                                                                               {Trait::latin1ToString("&Otimes;"), u"\x2A37"},
                                                                               {Trait::latin1ToString("&Ouml"), u"\x00D6"},
                                                                               {Trait::latin1ToString("&Ouml;"), u"\x00D6"},
                                                                               {Trait::latin1ToString("&OverBar;"), u"\x203E"},
                                                                               {Trait::latin1ToString("&OverBrace;"), u"\x23DE"},
                                                                               {Trait::latin1ToString("&OverBracket;"), u"\x23B4"},
                                                                               {Trait::latin1ToString("&OverParenthesis;"), u"\x23DC"},
                                                                               {Trait::latin1ToString("&PartialD;"), u"\x2202"},
                                                                               {Trait::latin1ToString("&Pcy;"), u"\x041F"},
                                                                               {Trait::latin1ToString("&Pfr;"), u"\xD835\xDD13"},
                                                                               {Trait::latin1ToString("&Phi;"), u"\x03A6"},
                                                                               {Trait::latin1ToString("&Pi;"), u"\x03A0"},
                                                                               {Trait::latin1ToString("&PlusMinus;"), u"\x00B1"},
                                                                               {Trait::latin1ToString("&Poincareplane;"), u"\x210C"},
                                                                               {Trait::latin1ToString("&Popf;"), u"\x2119"},
                                                                               {Trait::latin1ToString("&Pr;"), u"\x2ABB"},
                                                                               {Trait::latin1ToString("&Precedes;"), u"\x227A"},
                                                                               {Trait::latin1ToString("&PrecedesEqual;"), u"\x2AAF"},
                                                                               {Trait::latin1ToString("&PrecedesSlantEqual;"), u"\x227C"},
                                                                               {Trait::latin1ToString("&PrecedesTilde;"), u"\x227E"},
                                                                               {Trait::latin1ToString("&Prime;"), u"\x2033"},
                                                                               {Trait::latin1ToString("&Product;"), u"\x220F"},
                                                                               {Trait::latin1ToString("&Proportion;"), u"\x2237"},
                                                                               {Trait::latin1ToString("&Proportional;"), u"\x221D"},
                                                                               {Trait::latin1ToString("&Pscr;"), u"\xD835\xDCAB"},
                                                                               {Trait::latin1ToString("&Psi;"), u"\x03A8"},
                                                                               {Trait::latin1ToString("&QUOT"), u"\x0022"},
                                                                               {Trait::latin1ToString("&QUOT;"), u"\x0022"},
                                                                               {Trait::latin1ToString("&Qfr;"), u"\xD835\xDD14"},
                                                                               {Trait::latin1ToString("&Qopf;"), u"\x211A"},
                                                                               {Trait::latin1ToString("&Qscr;"), u"\xD835\xDCAC"},
                                                                               {Trait::latin1ToString("&RBarr;"), u"\x2910"},
                                                                               {Trait::latin1ToString("&REG"), u"\x00AE"},
                                                                               {Trait::latin1ToString("&REG;"), u"\x00AE"},
                                                                               {Trait::latin1ToString("&Racute;"), u"\x0154"},
                                                                               {Trait::latin1ToString("&Rang;"), u"\x27EB"},
                                                                               {Trait::latin1ToString("&Rarr;"), u"\x21A0"},
                                                                               {Trait::latin1ToString("&Rarrtl;"), u"\x2916"},
                                                                               {Trait::latin1ToString("&Rcaron;"), u"\x0158"},
                                                                               {Trait::latin1ToString("&Rcedil;"), u"\x0156"},
                                                                               {Trait::latin1ToString("&Rcy;"), u"\x0420"},
                                                                               {Trait::latin1ToString("&Re;"), u"\x211C"},
                                                                               {Trait::latin1ToString("&ReverseElement;"), u"\x220B"},
                                                                               {Trait::latin1ToString("&ReverseEquilibrium;"), u"\x21CB"},
                                                                               {Trait::latin1ToString("&ReverseUpEquilibrium;"), u"\x296F"},
                                                                               {Trait::latin1ToString("&Rfr;"), u"\x211C"},
                                                                               {Trait::latin1ToString("&Rho;"), u"\x03A1"},
                                                                               {Trait::latin1ToString("&RightAngleBracket;"), u"\x27E9"},
                                                                               {Trait::latin1ToString("&RightArrow;"), u"\x2192"},
                                                                               {Trait::latin1ToString("&RightArrowBar;"), u"\x21E5"},
                                                                               {Trait::latin1ToString("&RightArrowLeftArrow;"), u"\x21C4"},
                                                                               {Trait::latin1ToString("&RightCeiling;"), u"\x2309"},
                                                                               {Trait::latin1ToString("&RightDoubleBracket;"), u"\x27E7"},
                                                                               {Trait::latin1ToString("&RightDownTeeVector;"), u"\x295D"},
                                                                               {Trait::latin1ToString("&RightDownVector;"), u"\x21C2"},
                                                                               {Trait::latin1ToString("&RightDownVectorBar;"), u"\x2955"},
                                                                               {Trait::latin1ToString("&RightFloor;"), u"\x230B"},
                                                                               {Trait::latin1ToString("&RightTee;"), u"\x22A2"},
                                                                               {Trait::latin1ToString("&RightTeeArrow;"), u"\x21A6"},
                                                                               {Trait::latin1ToString("&RightTeeVector;"), u"\x295B"},
                                                                               {Trait::latin1ToString("&RightTriangle;"), u"\x22B3"},
                                                                               {Trait::latin1ToString("&RightTriangleBar;"), u"\x29D0"},
                                                                               {Trait::latin1ToString("&RightTriangleEqual;"), u"\x22B5"},
                                                                               {Trait::latin1ToString("&RightUpDownVector;"), u"\x294F"},
                                                                               {Trait::latin1ToString("&RightUpTeeVector;"), u"\x295C"},
                                                                               {Trait::latin1ToString("&RightUpVector;"), u"\x21BE"},
                                                                               {Trait::latin1ToString("&RightUpVectorBar;"), u"\x2954"},
                                                                               {Trait::latin1ToString("&RightVector;"), u"\x21C0"},
                                                                               {Trait::latin1ToString("&RightVectorBar;"), u"\x2953"},
                                                                               {Trait::latin1ToString("&Rightarrow;"), u"\x21D2"},
                                                                               {Trait::latin1ToString("&Ropf;"), u"\x211D"},
                                                                               {Trait::latin1ToString("&RoundImplies;"), u"\x2970"},
                                                                               {Trait::latin1ToString("&Rrightarrow;"), u"\x21DB"},
                                                                               {Trait::latin1ToString("&Rscr;"), u"\x211B"},
                                                                               {Trait::latin1ToString("&Rsh;"), u"\x21B1"},
                                                                               {Trait::latin1ToString("&RuleDelayed;"), u"\x29F4"},
                                                                               {Trait::latin1ToString("&SHCHcy;"), u"\x0429"},
                                                                               {Trait::latin1ToString("&SHcy;"), u"\x0428"},
                                                                               {Trait::latin1ToString("&SOFTcy;"), u"\x042C"},
                                                                               {Trait::latin1ToString("&Sacute;"), u"\x015A"},
                                                                               {Trait::latin1ToString("&Sc;"), u"\x2ABC"},
                                                                               {Trait::latin1ToString("&Scaron;"), u"\x0160"},
                                                                               {Trait::latin1ToString("&Scedil;"), u"\x015E"},
                                                                               {Trait::latin1ToString("&Scirc;"), u"\x015C"},
                                                                               {Trait::latin1ToString("&Scy;"), u"\x0421"},
                                                                               {Trait::latin1ToString("&Sfr;"), u"\xD835\xDD16"},
                                                                               {Trait::latin1ToString("&ShortDownArrow;"), u"\x2193"},
                                                                               {Trait::latin1ToString("&ShortLeftArrow;"), u"\x2190"},
                                                                               {Trait::latin1ToString("&ShortRightArrow;"), u"\x2192"},
                                                                               {Trait::latin1ToString("&ShortUpArrow;"), u"\x2191"},
                                                                               {Trait::latin1ToString("&Sigma;"), u"\x03A3"},
                                                                               {Trait::latin1ToString("&SmallCircle;"), u"\x2218"},
                                                                               {Trait::latin1ToString("&Sopf;"), u"\xD835\xDD4A"},
                                                                               {Trait::latin1ToString("&Sqrt;"), u"\x221A"},
                                                                               {Trait::latin1ToString("&Square;"), u"\x25A1"},
                                                                               {Trait::latin1ToString("&SquareIntersection;"), u"\x2293"},
                                                                               {Trait::latin1ToString("&SquareSubset;"), u"\x228F"},
                                                                               {Trait::latin1ToString("&SquareSubsetEqual;"), u"\x2291"},
                                                                               {Trait::latin1ToString("&SquareSuperset;"), u"\x2290"},
                                                                               {Trait::latin1ToString("&SquareSupersetEqual;"), u"\x2292"},
                                                                               {Trait::latin1ToString("&SquareUnion;"), u"\x2294"},
                                                                               {Trait::latin1ToString("&Sscr;"), u"\xD835\xDCAE"},
                                                                               {Trait::latin1ToString("&Star;"), u"\x22C6"},
                                                                               {Trait::latin1ToString("&Sub;"), u"\x22D0"},
                                                                               {Trait::latin1ToString("&Subset;"), u"\x22D0"},
                                                                               {Trait::latin1ToString("&SubsetEqual;"), u"\x2286"},
                                                                               {Trait::latin1ToString("&Succeeds;"), u"\x227B"},
                                                                               {Trait::latin1ToString("&SucceedsEqual;"), u"\x2AB0"},
                                                                               {Trait::latin1ToString("&SucceedsSlantEqual;"), u"\x227D"},
                                                                               {Trait::latin1ToString("&SucceedsTilde;"), u"\x227F"},
                                                                               {Trait::latin1ToString("&SuchThat;"), u"\x220B"},
                                                                               {Trait::latin1ToString("&Sum;"), u"\x2211"},
                                                                               {Trait::latin1ToString("&Sup;"), u"\x22D1"},
                                                                               {Trait::latin1ToString("&Superset;"), u"\x2283"},
                                                                               {Trait::latin1ToString("&SupersetEqual;"), u"\x2287"},
                                                                               {Trait::latin1ToString("&Supset;"), u"\x22D1"},
                                                                               {Trait::latin1ToString("&THORN"), u"\x00DE"},
                                                                               {Trait::latin1ToString("&THORN;"), u"\x00DE"},
                                                                               {Trait::latin1ToString("&TRADE;"), u"\x2122"},
                                                                               {Trait::latin1ToString("&TSHcy;"), u"\x040B"},
                                                                               {Trait::latin1ToString("&TScy;"), u"\x0426"},
                                                                               {Trait::latin1ToString("&Tab;"), u"\x0009"},
                                                                               {Trait::latin1ToString("&Tau;"), u"\x03A4"},
                                                                               {Trait::latin1ToString("&Tcaron;"), u"\x0164"},
                                                                               {Trait::latin1ToString("&Tcedil;"), u"\x0162"},
                                                                               {Trait::latin1ToString("&Tcy;"), u"\x0422"},
                                                                               {Trait::latin1ToString("&Tfr;"), u"\xD835\xDD17"},
                                                                               {Trait::latin1ToString("&Therefore;"), u"\x2234"},
                                                                               {Trait::latin1ToString("&Theta;"), u"\x0398"},
                                                                               {Trait::latin1ToString("&ThickSpace;"), u"\x205F\x200A"},
                                                                               {Trait::latin1ToString("&ThinSpace;"), u"\x2009"},
                                                                               {Trait::latin1ToString("&Tilde;"), u"\x223C"},
                                                                               {Trait::latin1ToString("&TildeEqual;"), u"\x2243"},
                                                                               {Trait::latin1ToString("&TildeFullEqual;"), u"\x2245"},
                                                                               {Trait::latin1ToString("&TildeTilde;"), u"\x2248"},
                                                                               {Trait::latin1ToString("&Topf;"), u"\xD835\xDD4B"},
                                                                               {Trait::latin1ToString("&TripleDot;"), u"\x20DB"},
                                                                               {Trait::latin1ToString("&Tscr;"), u"\xD835\xDCAF"},
                                                                               {Trait::latin1ToString("&Tstrok;"), u"\x0166"},
                                                                               {Trait::latin1ToString("&Uacute"), u"\x00DA"},
                                                                               {Trait::latin1ToString("&Uacute;"), u"\x00DA"},
                                                                               {Trait::latin1ToString("&Uarr;"), u"\x219F"},
                                                                               {Trait::latin1ToString("&Uarrocir;"), u"\x2949"},
                                                                               {Trait::latin1ToString("&Ubrcy;"), u"\x040E"},
                                                                               {Trait::latin1ToString("&Ubreve;"), u"\x016C"},
                                                                               {Trait::latin1ToString("&Ucirc"), u"\x00DB"},
                                                                               {Trait::latin1ToString("&Ucirc;"), u"\x00DB"},
                                                                               {Trait::latin1ToString("&Ucy;"), u"\x0423"},
                                                                               {Trait::latin1ToString("&Udblac;"), u"\x0170"},
                                                                               {Trait::latin1ToString("&Ufr;"), u"\xD835\xDD18"},
                                                                               {Trait::latin1ToString("&Ugrave"), u"\x00D9"},
                                                                               {Trait::latin1ToString("&Ugrave;"), u"\x00D9"},
                                                                               {Trait::latin1ToString("&Umacr;"), u"\x016A"},
                                                                               {Trait::latin1ToString("&UnderBar;"), u"\x005F"},
                                                                               {Trait::latin1ToString("&UnderBrace;"), u"\x23DF"},
                                                                               {Trait::latin1ToString("&UnderBracket;"), u"\x23B5"},
                                                                               {Trait::latin1ToString("&UnderParenthesis;"), u"\x23DD"},
                                                                               {Trait::latin1ToString("&Union;"), u"\x22C3"},
                                                                               {Trait::latin1ToString("&UnionPlus;"), u"\x228E"},
                                                                               {Trait::latin1ToString("&Uogon;"), u"\x0172"},
                                                                               {Trait::latin1ToString("&Uopf;"), u"\xD835\xDD4C"},
                                                                               {Trait::latin1ToString("&UpArrow;"), u"\x2191"},
                                                                               {Trait::latin1ToString("&UpArrowBar;"), u"\x2912"},
                                                                               {Trait::latin1ToString("&UpArrowDownArrow;"), u"\x21C5"},
                                                                               {Trait::latin1ToString("&UpDownArrow;"), u"\x2195"},
                                                                               {Trait::latin1ToString("&UpEquilibrium;"), u"\x296E"},
                                                                               {Trait::latin1ToString("&UpTee;"), u"\x22A5"},
                                                                               {Trait::latin1ToString("&UpTeeArrow;"), u"\x21A5"},
                                                                               {Trait::latin1ToString("&Uparrow;"), u"\x21D1"},
                                                                               {Trait::latin1ToString("&Updownarrow;"), u"\x21D5"},
                                                                               {Trait::latin1ToString("&UpperLeftArrow;"), u"\x2196"},
                                                                               {Trait::latin1ToString("&UpperRightArrow;"), u"\x2197"},
                                                                               {Trait::latin1ToString("&Upsi;"), u"\x03D2"},
                                                                               {Trait::latin1ToString("&Upsilon;"), u"\x03A5"},
                                                                               {Trait::latin1ToString("&Uring;"), u"\x016E"},
                                                                               {Trait::latin1ToString("&Uscr;"), u"\xD835\xDCB0"},
                                                                               {Trait::latin1ToString("&Utilde;"), u"\x0168"},
                                                                               {Trait::latin1ToString("&Uuml"), u"\x00DC"},
                                                                               {Trait::latin1ToString("&Uuml;"), u"\x00DC"},
                                                                               {Trait::latin1ToString("&VDash;"), u"\x22AB"},
                                                                               {Trait::latin1ToString("&Vbar;"), u"\x2AEB"},
                                                                               {Trait::latin1ToString("&Vcy;"), u"\x0412"},
                                                                               {Trait::latin1ToString("&Vdash;"), u"\x22A9"},
                                                                               {Trait::latin1ToString("&Vdashl;"), u"\x2AE6"},
                                                                               {Trait::latin1ToString("&Vee;"), u"\x22C1"},
                                                                               {Trait::latin1ToString("&Verbar;"), u"\x2016"},
                                                                               {Trait::latin1ToString("&Vert;"), u"\x2016"},
                                                                               {Trait::latin1ToString("&VerticalBar;"), u"\x2223"},
                                                                               {Trait::latin1ToString("&VerticalLine;"), u"\x007C"},
                                                                               {Trait::latin1ToString("&VerticalSeparator;"), u"\x2758"},
                                                                               {Trait::latin1ToString("&VerticalTilde;"), u"\x2240"},
                                                                               {Trait::latin1ToString("&VeryThinSpace;"), u"\x200A"},
                                                                               {Trait::latin1ToString("&Vfr;"), u"\xD835\xDD19"},
                                                                               {Trait::latin1ToString("&Vopf;"), u"\xD835\xDD4D"},
                                                                               {Trait::latin1ToString("&Vscr;"), u"\xD835\xDCB1"},
                                                                               {Trait::latin1ToString("&Vvdash;"), u"\x22AA"},
                                                                               {Trait::latin1ToString("&Wcirc;"), u"\x0174"},
                                                                               {Trait::latin1ToString("&Wedge;"), u"\x22C0"},
                                                                               {Trait::latin1ToString("&Wfr;"), u"\xD835\xDD1A"},
                                                                               {Trait::latin1ToString("&Wopf;"), u"\xD835\xDD4E"},
                                                                               {Trait::latin1ToString("&Wscr;"), u"\xD835\xDCB2"},
                                                                               {Trait::latin1ToString("&Xfr;"), u"\xD835\xDD1B"},
                                                                               {Trait::latin1ToString("&Xi;"), u"\x039E"},
                                                                               {Trait::latin1ToString("&Xopf;"), u"\xD835\xDD4F"},
                                                                               {Trait::latin1ToString("&Xscr;"), u"\xD835\xDCB3"},
                                                                               {Trait::latin1ToString("&YAcy;"), u"\x042F"},
                                                                               {Trait::latin1ToString("&YIcy;"), u"\x0407"},
                                                                               {Trait::latin1ToString("&YUcy;"), u"\x042E"},
                                                                               {Trait::latin1ToString("&Yacute"), u"\x00DD"},
                                                                               {Trait::latin1ToString("&Yacute;"), u"\x00DD"},
                                                                               {Trait::latin1ToString("&Ycirc;"), u"\x0176"},
                                                                               {Trait::latin1ToString("&Ycy;"), u"\x042B"},
                                                                               {Trait::latin1ToString("&Yfr;"), u"\xD835\xDD1C"},
                                                                               {Trait::latin1ToString("&Yopf;"), u"\xD835\xDD50"},
                                                                               {Trait::latin1ToString("&Yscr;"), u"\xD835\xDCB4"},
                                                                               {Trait::latin1ToString("&Yuml;"), u"\x0178"},
                                                                               {Trait::latin1ToString("&ZHcy;"), u"\x0416"},
                                                                               {Trait::latin1ToString("&Zacute;"), u"\x0179"},
                                                                               {Trait::latin1ToString("&Zcaron;"), u"\x017D"},
                                                                               {Trait::latin1ToString("&Zcy;"), u"\x0417"},
                                                                               {Trait::latin1ToString("&Zdot;"), u"\x017B"},
                                                                               {Trait::latin1ToString("&ZeroWidthSpace;"), u"\x200B"},
                                                                               {Trait::latin1ToString("&Zeta;"), u"\x0396"},
                                                                               {Trait::latin1ToString("&Zfr;"), u"\x2128"},
                                                                               {Trait::latin1ToString("&Zopf;"), u"\x2124"},
                                                                               {Trait::latin1ToString("&Zscr;"), u"\xD835\xDCB5"},
                                                                               {Trait::latin1ToString("&aacute"), u"\x00E1"},
                                                                               {Trait::latin1ToString("&aacute;"), u"\x00E1"},
                                                                               {Trait::latin1ToString("&abreve;"), u"\x0103"},
                                                                               {Trait::latin1ToString("&ac;"), u"\x223E"},
                                                                               {Trait::latin1ToString("&acE;"), u"\x223E\x0333"},
                                                                               {Trait::latin1ToString("&acd;"), u"\x223F"},
                                                                               {Trait::latin1ToString("&acirc"), u"\x00E2"},
                                                                               {Trait::latin1ToString("&acirc;"), u"\x00E2"},
                                                                               {Trait::latin1ToString("&acute"), u"\x00B4"},
                                                                               {Trait::latin1ToString("&acute;"), u"\x00B4"},
                                                                               {Trait::latin1ToString("&acy;"), u"\x0430"},
                                                                               {Trait::latin1ToString("&aelig"), u"\x00E6"},
                                                                               {Trait::latin1ToString("&aelig;"), u"\x00E6"},
                                                                               {Trait::latin1ToString("&af;"), u"\x2061"},
                                                                               {Trait::latin1ToString("&afr;"), u"\xD835\xDD1E"},
                                                                               {Trait::latin1ToString("&agrave"), u"\x00E0"},
                                                                               {Trait::latin1ToString("&agrave;"), u"\x00E0"},
                                                                               {Trait::latin1ToString("&alefsym;"), u"\x2135"},
                                                                               {Trait::latin1ToString("&aleph;"), u"\x2135"},
                                                                               {Trait::latin1ToString("&alpha;"), u"\x03B1"},
                                                                               {Trait::latin1ToString("&amacr;"), u"\x0101"},
                                                                               {Trait::latin1ToString("&amalg;"), u"\x2A3F"},
                                                                               {Trait::latin1ToString("&amp"), u"\x0026"},
                                                                               {Trait::latin1ToString("&amp;"), u"\x0026"},
                                                                               {Trait::latin1ToString("&and;"), u"\x2227"},
                                                                               {Trait::latin1ToString("&andand;"), u"\x2A55"},
                                                                               {Trait::latin1ToString("&andd;"), u"\x2A5C"},
                                                                               {Trait::latin1ToString("&andslope;"), u"\x2A58"},
                                                                               {Trait::latin1ToString("&andv;"), u"\x2A5A"},
                                                                               {Trait::latin1ToString("&ang;"), u"\x2220"},
                                                                               {Trait::latin1ToString("&ange;"), u"\x29A4"},
                                                                               {Trait::latin1ToString("&angle;"), u"\x2220"},
                                                                               {Trait::latin1ToString("&angmsd;"), u"\x2221"},
                                                                               {Trait::latin1ToString("&angmsdaa;"), u"\x29A8"},
                                                                               {Trait::latin1ToString("&angmsdab;"), u"\x29A9"},
                                                                               {Trait::latin1ToString("&angmsdac;"), u"\x29AA"},
                                                                               {Trait::latin1ToString("&angmsdad;"), u"\x29AB"},
                                                                               {Trait::latin1ToString("&angmsdae;"), u"\x29AC"},
                                                                               {Trait::latin1ToString("&angmsdaf;"), u"\x29AD"},
                                                                               {Trait::latin1ToString("&angmsdag;"), u"\x29AE"},
                                                                               {Trait::latin1ToString("&angmsdah;"), u"\x29AF"},
                                                                               {Trait::latin1ToString("&angrt;"), u"\x221F"},
                                                                               {Trait::latin1ToString("&angrtvb;"), u"\x22BE"},
                                                                               {Trait::latin1ToString("&angrtvbd;"), u"\x299D"},
                                                                               {Trait::latin1ToString("&angsph;"), u"\x2222"},
                                                                               {Trait::latin1ToString("&angst;"), u"\x00C5"},
                                                                               {Trait::latin1ToString("&angzarr;"), u"\x237C"},
                                                                               {Trait::latin1ToString("&aogon;"), u"\x0105"},
                                                                               {Trait::latin1ToString("&aopf;"), u"\xD835\xDD52"},
                                                                               {Trait::latin1ToString("&ap;"), u"\x2248"},
                                                                               {Trait::latin1ToString("&apE;"), u"\x2A70"},
                                                                               {Trait::latin1ToString("&apacir;"), u"\x2A6F"},
                                                                               {Trait::latin1ToString("&ape;"), u"\x224A"},
                                                                               {Trait::latin1ToString("&apid;"), u"\x224B"},
                                                                               {Trait::latin1ToString("&apos;"), u"\x0027"},
                                                                               {Trait::latin1ToString("&approx;"), u"\x2248"},
                                                                               {Trait::latin1ToString("&approxeq;"), u"\x224A"},
                                                                               {Trait::latin1ToString("&aring"), u"\x00E5"},
                                                                               {Trait::latin1ToString("&aring;"), u"\x00E5"},
                                                                               {Trait::latin1ToString("&ascr;"), u"\xD835\xDCB6"},
                                                                               {Trait::latin1ToString("&ast;"), u"\x002A"},
                                                                               {Trait::latin1ToString("&asymp;"), u"\x2248"},
                                                                               {Trait::latin1ToString("&asympeq;"), u"\x224D"},
                                                                               {Trait::latin1ToString("&atilde"), u"\x00E3"},
                                                                               {Trait::latin1ToString("&atilde;"), u"\x00E3"},
                                                                               {Trait::latin1ToString("&auml"), u"\x00E4"},
                                                                               {Trait::latin1ToString("&auml;"), u"\x00E4"},
                                                                               {Trait::latin1ToString("&awconint;"), u"\x2233"},
                                                                               {Trait::latin1ToString("&awint;"), u"\x2A11"},
                                                                               {Trait::latin1ToString("&bNot;"), u"\x2AED"},
                                                                               {Trait::latin1ToString("&backcong;"), u"\x224C"},
                                                                               {Trait::latin1ToString("&backepsilon;"), u"\x03F6"},
                                                                               {Trait::latin1ToString("&backprime;"), u"\x2035"},
                                                                               {Trait::latin1ToString("&backsim;"), u"\x223D"},
                                                                               {Trait::latin1ToString("&backsimeq;"), u"\x22CD"},
                                                                               {Trait::latin1ToString("&barvee;"), u"\x22BD"},
                                                                               {Trait::latin1ToString("&barwed;"), u"\x2305"},
                                                                               {Trait::latin1ToString("&barwedge;"), u"\x2305"},
                                                                               {Trait::latin1ToString("&bbrk;"), u"\x23B5"},
                                                                               {Trait::latin1ToString("&bbrktbrk;"), u"\x23B6"},
                                                                               {Trait::latin1ToString("&bcong;"), u"\x224C"},
                                                                               {Trait::latin1ToString("&bcy;"), u"\x0431"},
                                                                               {Trait::latin1ToString("&bdquo;"), u"\x201E"},
                                                                               {Trait::latin1ToString("&becaus;"), u"\x2235"},
                                                                               {Trait::latin1ToString("&because;"), u"\x2235"},
                                                                               {Trait::latin1ToString("&bemptyv;"), u"\x29B0"},
                                                                               {Trait::latin1ToString("&bepsi;"), u"\x03F6"},
                                                                               {Trait::latin1ToString("&bernou;"), u"\x212C"},
                                                                               {Trait::latin1ToString("&beta;"), u"\x03B2"},
                                                                               {Trait::latin1ToString("&beth;"), u"\x2136"},
                                                                               {Trait::latin1ToString("&between;"), u"\x226C"},
                                                                               {Trait::latin1ToString("&bfr;"), u"\xD835\xDD1F"},
                                                                               {Trait::latin1ToString("&bigcap;"), u"\x22C2"},
                                                                               {Trait::latin1ToString("&bigcirc;"), u"\x25EF"},
                                                                               {Trait::latin1ToString("&bigcup;"), u"\x22C3"},
                                                                               {Trait::latin1ToString("&bigodot;"), u"\x2A00"},
                                                                               {Trait::latin1ToString("&bigoplus;"), u"\x2A01"},
                                                                               {Trait::latin1ToString("&bigotimes;"), u"\x2A02"},
                                                                               {Trait::latin1ToString("&bigsqcup;"), u"\x2A06"},
                                                                               {Trait::latin1ToString("&bigstar;"), u"\x2605"},
                                                                               {Trait::latin1ToString("&bigtriangledown;"), u"\x25BD"},
                                                                               {Trait::latin1ToString("&bigtriangleup;"), u"\x25B3"},
                                                                               {Trait::latin1ToString("&biguplus;"), u"\x2A04"},
                                                                               {Trait::latin1ToString("&bigvee;"), u"\x22C1"},
                                                                               {Trait::latin1ToString("&bigwedge;"), u"\x22C0"},
                                                                               {Trait::latin1ToString("&bkarow;"), u"\x290D"},
                                                                               {Trait::latin1ToString("&blacklozenge;"), u"\x29EB"},
                                                                               {Trait::latin1ToString("&blacksquare;"), u"\x25AA"},
                                                                               {Trait::latin1ToString("&blacktriangle;"), u"\x25B4"},
                                                                               {Trait::latin1ToString("&blacktriangledown;"), u"\x25BE"},
                                                                               {Trait::latin1ToString("&blacktriangleleft;"), u"\x25C2"},
                                                                               {Trait::latin1ToString("&blacktriangleright;"), u"\x25B8"},
                                                                               {Trait::latin1ToString("&blank;"), u"\x2423"},
                                                                               {Trait::latin1ToString("&blk12;"), u"\x2592"},
                                                                               {Trait::latin1ToString("&blk14;"), u"\x2591"},
                                                                               {Trait::latin1ToString("&blk34;"), u"\x2593"},
                                                                               {Trait::latin1ToString("&block;"), u"\x2588"},
                                                                               {Trait::latin1ToString("&bne;"), u"\x003D\x20E5"},
                                                                               {Trait::latin1ToString("&bnequiv;"), u"\x2261\x20E5"},
                                                                               {Trait::latin1ToString("&bnot;"), u"\x2310"},
                                                                               {Trait::latin1ToString("&bopf;"), u"\xD835\xDD53"},
                                                                               {Trait::latin1ToString("&bot;"), u"\x22A5"},
                                                                               {Trait::latin1ToString("&bottom;"), u"\x22A5"},
                                                                               {Trait::latin1ToString("&bowtie;"), u"\x22C8"},
                                                                               {Trait::latin1ToString("&boxDL;"), u"\x2557"},
                                                                               {Trait::latin1ToString("&boxDR;"), u"\x2554"},
                                                                               {Trait::latin1ToString("&boxDl;"), u"\x2556"},
                                                                               {Trait::latin1ToString("&boxDr;"), u"\x2553"},
                                                                               {Trait::latin1ToString("&boxH;"), u"\x2550"},
                                                                               {Trait::latin1ToString("&boxHD;"), u"\x2566"},
                                                                               {Trait::latin1ToString("&boxHU;"), u"\x2569"},
                                                                               {Trait::latin1ToString("&boxHd;"), u"\x2564"},
                                                                               {Trait::latin1ToString("&boxHu;"), u"\x2567"},
                                                                               {Trait::latin1ToString("&boxUL;"), u"\x255D"},
                                                                               {Trait::latin1ToString("&boxUR;"), u"\x255A"},
                                                                               {Trait::latin1ToString("&boxUl;"), u"\x255C"},
                                                                               {Trait::latin1ToString("&boxUr;"), u"\x2559"},
                                                                               {Trait::latin1ToString("&boxV;"), u"\x2551"},
                                                                               {Trait::latin1ToString("&boxVH;"), u"\x256C"},
                                                                               {Trait::latin1ToString("&boxVL;"), u"\x2563"},
                                                                               {Trait::latin1ToString("&boxVR;"), u"\x2560"},
                                                                               {Trait::latin1ToString("&boxVh;"), u"\x256B"},
                                                                               {Trait::latin1ToString("&boxVl;"), u"\x2562"},
                                                                               {Trait::latin1ToString("&boxVr;"), u"\x255F"},
                                                                               {Trait::latin1ToString("&boxbox;"), u"\x29C9"},
                                                                               {Trait::latin1ToString("&boxdL;"), u"\x2555"},
                                                                               {Trait::latin1ToString("&boxdR;"), u"\x2552"},
                                                                               {Trait::latin1ToString("&boxdl;"), u"\x2510"},
                                                                               {Trait::latin1ToString("&boxdr;"), u"\x250C"},
                                                                               {Trait::latin1ToString("&boxh;"), u"\x2500"},
                                                                               {Trait::latin1ToString("&boxhD;"), u"\x2565"},
                                                                               {Trait::latin1ToString("&boxhU;"), u"\x2568"},
                                                                               {Trait::latin1ToString("&boxhd;"), u"\x252C"},
                                                                               {Trait::latin1ToString("&boxhu;"), u"\x2534"},
                                                                               {Trait::latin1ToString("&boxminus;"), u"\x229F"},
                                                                               {Trait::latin1ToString("&boxplus;"), u"\x229E"},
                                                                               {Trait::latin1ToString("&boxtimes;"), u"\x22A0"},
                                                                               {Trait::latin1ToString("&boxuL;"), u"\x255B"},
                                                                               {Trait::latin1ToString("&boxuR;"), u"\x2558"},
                                                                               {Trait::latin1ToString("&boxul;"), u"\x2518"},
                                                                               {Trait::latin1ToString("&boxur;"), u"\x2514"},
                                                                               {Trait::latin1ToString("&boxv;"), u"\x2502"},
                                                                               {Trait::latin1ToString("&boxvH;"), u"\x256A"},
                                                                               {Trait::latin1ToString("&boxvL;"), u"\x2561"},
                                                                               {Trait::latin1ToString("&boxvR;"), u"\x255E"},
                                                                               {Trait::latin1ToString("&boxvh;"), u"\x253C"},
                                                                               {Trait::latin1ToString("&boxvl;"), u"\x2524"},
                                                                               {Trait::latin1ToString("&boxvr;"), u"\x251C"},
                                                                               {Trait::latin1ToString("&bprime;"), u"\x2035"},
                                                                               {Trait::latin1ToString("&breve;"), u"\x02D8"},
                                                                               {Trait::latin1ToString("&brvbar"), u"\x00A6"},
                                                                               {Trait::latin1ToString("&brvbar;"), u"\x00A6"},
                                                                               {Trait::latin1ToString("&bscr;"), u"\xD835\xDCB7"},
                                                                               {Trait::latin1ToString("&bsemi;"), u"\x204F"},
                                                                               {Trait::latin1ToString("&bsim;"), u"\x223D"},
                                                                               {Trait::latin1ToString("&bsime;"), u"\x22CD"},
                                                                               {Trait::latin1ToString("&bsol;"), u"\x005C"},
                                                                               {Trait::latin1ToString("&bsolb;"), u"\x29C5"},
                                                                               {Trait::latin1ToString("&bsolhsub;"), u"\x27C8"},
                                                                               {Trait::latin1ToString("&bull;"), u"\x2022"},
                                                                               {Trait::latin1ToString("&bullet;"), u"\x2022"},
                                                                               {Trait::latin1ToString("&bump;"), u"\x224E"},
                                                                               {Trait::latin1ToString("&bumpE;"), u"\x2AAE"},
                                                                               {Trait::latin1ToString("&bumpe;"), u"\x224F"},
                                                                               {Trait::latin1ToString("&bumpeq;"), u"\x224F"},
                                                                               {Trait::latin1ToString("&cacute;"), u"\x0107"},
                                                                               {Trait::latin1ToString("&cap;"), u"\x2229"},
                                                                               {Trait::latin1ToString("&capand;"), u"\x2A44"},
                                                                               {Trait::latin1ToString("&capbrcup;"), u"\x2A49"},
                                                                               {Trait::latin1ToString("&capcap;"), u"\x2A4B"},
                                                                               {Trait::latin1ToString("&capcup;"), u"\x2A47"},
                                                                               {Trait::latin1ToString("&capdot;"), u"\x2A40"},
                                                                               {Trait::latin1ToString("&caps;"), u"\x2229\xFE00"},
                                                                               {Trait::latin1ToString("&caret;"), u"\x2041"},
                                                                               {Trait::latin1ToString("&caron;"), u"\x02C7"},
                                                                               {Trait::latin1ToString("&ccaps;"), u"\x2A4D"},
                                                                               {Trait::latin1ToString("&ccaron;"), u"\x010D"},
                                                                               {Trait::latin1ToString("&ccedil"), u"\x00E7"},
                                                                               {Trait::latin1ToString("&ccedil;"), u"\x00E7"},
                                                                               {Trait::latin1ToString("&ccirc;"), u"\x0109"},
                                                                               {Trait::latin1ToString("&ccups;"), u"\x2A4C"},
                                                                               {Trait::latin1ToString("&ccupssm;"), u"\x2A50"},
                                                                               {Trait::latin1ToString("&cdot;"), u"\x010B"},
                                                                               {Trait::latin1ToString("&cedil"), u"\x00B8"},
                                                                               {Trait::latin1ToString("&cedil;"), u"\x00B8"},
                                                                               {Trait::latin1ToString("&cemptyv;"), u"\x29B2"},
                                                                               {Trait::latin1ToString("&cent"), u"\x00A2"},
                                                                               {Trait::latin1ToString("&cent;"), u"\x00A2"},
                                                                               {Trait::latin1ToString("&centerdot;"), u"\x00B7"},
                                                                               {Trait::latin1ToString("&cfr;"), u"\xD835\xDD20"},
                                                                               {Trait::latin1ToString("&chcy;"), u"\x0447"},
                                                                               {Trait::latin1ToString("&check;"), u"\x2713"},
                                                                               {Trait::latin1ToString("&checkmark;"), u"\x2713"},
                                                                               {Trait::latin1ToString("&chi;"), u"\x03C7"},
                                                                               {Trait::latin1ToString("&cir;"), u"\x25CB"},
                                                                               {Trait::latin1ToString("&cirE;"), u"\x29C3"},
                                                                               {Trait::latin1ToString("&circ;"), u"\x02C6"},
                                                                               {Trait::latin1ToString("&circeq;"), u"\x2257"},
                                                                               {Trait::latin1ToString("&circlearrowleft;"), u"\x21BA"},
                                                                               {Trait::latin1ToString("&circlearrowright;"), u"\x21BB"},
                                                                               {Trait::latin1ToString("&circledR;"), u"\x00AE"},
                                                                               {Trait::latin1ToString("&circledS;"), u"\x24C8"},
                                                                               {Trait::latin1ToString("&circledast;"), u"\x229B"},
                                                                               {Trait::latin1ToString("&circledcirc;"), u"\x229A"},
                                                                               {Trait::latin1ToString("&circleddash;"), u"\x229D"},
                                                                               {Trait::latin1ToString("&cire;"), u"\x2257"},
                                                                               {Trait::latin1ToString("&cirfnint;"), u"\x2A10"},
                                                                               {Trait::latin1ToString("&cirmid;"), u"\x2AEF"},
                                                                               {Trait::latin1ToString("&cirscir;"), u"\x29C2"},
                                                                               {Trait::latin1ToString("&clubs;"), u"\x2663"},
                                                                               {Trait::latin1ToString("&clubsuit;"), u"\x2663"},
                                                                               {Trait::latin1ToString("&colon;"), u"\x003A"},
                                                                               {Trait::latin1ToString("&colone;"), u"\x2254"},
                                                                               {Trait::latin1ToString("&coloneq;"), u"\x2254"},
                                                                               {Trait::latin1ToString("&comma;"), u"\x002C"},
                                                                               {Trait::latin1ToString("&commat;"), u"\x0040"},
                                                                               {Trait::latin1ToString("&comp;"), u"\x2201"},
                                                                               {Trait::latin1ToString("&compfn;"), u"\x2218"},
                                                                               {Trait::latin1ToString("&complement;"), u"\x2201"},
                                                                               {Trait::latin1ToString("&complexes;"), u"\x2102"},
                                                                               {Trait::latin1ToString("&cong;"), u"\x2245"},
                                                                               {Trait::latin1ToString("&congdot;"), u"\x2A6D"},
                                                                               {Trait::latin1ToString("&conint;"), u"\x222E"},
                                                                               {Trait::latin1ToString("&copf;"), u"\xD835\xDD54"},
                                                                               {Trait::latin1ToString("&coprod;"), u"\x2210"},
                                                                               {Trait::latin1ToString("&copy"), u"\x00A9"},
                                                                               {Trait::latin1ToString("&copy;"), u"\x00A9"},
                                                                               {Trait::latin1ToString("&copysr;"), u"\x2117"},
                                                                               {Trait::latin1ToString("&crarr;"), u"\x21B5"},
                                                                               {Trait::latin1ToString("&cross;"), u"\x2717"},
                                                                               {Trait::latin1ToString("&cscr;"), u"\xD835\xDCB8"},
                                                                               {Trait::latin1ToString("&csub;"), u"\x2ACF"},
                                                                               {Trait::latin1ToString("&csube;"), u"\x2AD1"},
                                                                               {Trait::latin1ToString("&csup;"), u"\x2AD0"},
                                                                               {Trait::latin1ToString("&csupe;"), u"\x2AD2"},
                                                                               {Trait::latin1ToString("&ctdot;"), u"\x22EF"},
                                                                               {Trait::latin1ToString("&cudarrl;"), u"\x2938"},
                                                                               {Trait::latin1ToString("&cudarrr;"), u"\x2935"},
                                                                               {Trait::latin1ToString("&cuepr;"), u"\x22DE"},
                                                                               {Trait::latin1ToString("&cuesc;"), u"\x22DF"},
                                                                               {Trait::latin1ToString("&cularr;"), u"\x21B6"},
                                                                               {Trait::latin1ToString("&cularrp;"), u"\x293D"},
                                                                               {Trait::latin1ToString("&cup;"), u"\x222A"},
                                                                               {Trait::latin1ToString("&cupbrcap;"), u"\x2A48"},
                                                                               {Trait::latin1ToString("&cupcap;"), u"\x2A46"},
                                                                               {Trait::latin1ToString("&cupcup;"), u"\x2A4A"},
                                                                               {Trait::latin1ToString("&cupdot;"), u"\x228D"},
                                                                               {Trait::latin1ToString("&cupor;"), u"\x2A45"},
                                                                               {Trait::latin1ToString("&cups;"), u"\x222A\xFE00"},
                                                                               {Trait::latin1ToString("&curarr;"), u"\x21B7"},
                                                                               {Trait::latin1ToString("&curarrm;"), u"\x293C"},
                                                                               {Trait::latin1ToString("&curlyeqprec;"), u"\x22DE"},
                                                                               {Trait::latin1ToString("&curlyeqsucc;"), u"\x22DF"},
                                                                               {Trait::latin1ToString("&curlyvee;"), u"\x22CE"},
                                                                               {Trait::latin1ToString("&curlywedge;"), u"\x22CF"},
                                                                               {Trait::latin1ToString("&curren"), u"\x00A4"},
                                                                               {Trait::latin1ToString("&curren;"), u"\x00A4"},
                                                                               {Trait::latin1ToString("&curvearrowleft;"), u"\x21B6"},
                                                                               {Trait::latin1ToString("&curvearrowright;"), u"\x21B7"},
                                                                               {Trait::latin1ToString("&cuvee;"), u"\x22CE"},
                                                                               {Trait::latin1ToString("&cuwed;"), u"\x22CF"},
                                                                               {Trait::latin1ToString("&cwconint;"), u"\x2232"},
                                                                               {Trait::latin1ToString("&cwint;"), u"\x2231"},
                                                                               {Trait::latin1ToString("&cylcty;"), u"\x232D"},
                                                                               {Trait::latin1ToString("&dArr;"), u"\x21D3"},
                                                                               {Trait::latin1ToString("&dHar;"), u"\x2965"},
                                                                               {Trait::latin1ToString("&dagger;"), u"\x2020"},
                                                                               {Trait::latin1ToString("&daleth;"), u"\x2138"},
                                                                               {Trait::latin1ToString("&darr;"), u"\x2193"},
                                                                               {Trait::latin1ToString("&dash;"), u"\x2010"},
                                                                               {Trait::latin1ToString("&dashv;"), u"\x22A3"},
                                                                               {Trait::latin1ToString("&dbkarow;"), u"\x290F"},
                                                                               {Trait::latin1ToString("&dblac;"), u"\x02DD"},
                                                                               {Trait::latin1ToString("&dcaron;"), u"\x010F"},
                                                                               {Trait::latin1ToString("&dcy;"), u"\x0434"},
                                                                               {Trait::latin1ToString("&dd;"), u"\x2146"},
                                                                               {Trait::latin1ToString("&ddagger;"), u"\x2021"},
                                                                               {Trait::latin1ToString("&ddarr;"), u"\x21CA"},
                                                                               {Trait::latin1ToString("&ddotseq;"), u"\x2A77"},
                                                                               {Trait::latin1ToString("&deg"), u"\x00B0"},
                                                                               {Trait::latin1ToString("&deg;"), u"\x00B0"},
                                                                               {Trait::latin1ToString("&delta;"), u"\x03B4"},
                                                                               {Trait::latin1ToString("&demptyv;"), u"\x29B1"},
                                                                               {Trait::latin1ToString("&dfisht;"), u"\x297F"},
                                                                               {Trait::latin1ToString("&dfr;"), u"\xD835\xDD21"},
                                                                               {Trait::latin1ToString("&dharl;"), u"\x21C3"},
                                                                               {Trait::latin1ToString("&dharr;"), u"\x21C2"},
                                                                               {Trait::latin1ToString("&diam;"), u"\x22C4"},
                                                                               {Trait::latin1ToString("&diamond;"), u"\x22C4"},
                                                                               {Trait::latin1ToString("&diamondsuit;"), u"\x2666"},
                                                                               {Trait::latin1ToString("&diams;"), u"\x2666"},
                                                                               {Trait::latin1ToString("&die;"), u"\x00A8"},
                                                                               {Trait::latin1ToString("&digamma;"), u"\x03DD"},
                                                                               {Trait::latin1ToString("&disin;"), u"\x22F2"},
                                                                               {Trait::latin1ToString("&div;"), u"\x00F7"},
                                                                               {Trait::latin1ToString("&divide"), u"\x00F7"},
                                                                               {Trait::latin1ToString("&divide;"), u"\x00F7"},
                                                                               {Trait::latin1ToString("&divideontimes;"), u"\x22C7"},
                                                                               {Trait::latin1ToString("&divonx;"), u"\x22C7"},
                                                                               {Trait::latin1ToString("&djcy;"), u"\x0452"},
                                                                               {Trait::latin1ToString("&dlcorn;"), u"\x231E"},
                                                                               {Trait::latin1ToString("&dlcrop;"), u"\x230D"},
                                                                               {Trait::latin1ToString("&dollar;"), u"\x0024"},
                                                                               {Trait::latin1ToString("&dopf;"), u"\xD835\xDD55"},
                                                                               {Trait::latin1ToString("&dot;"), u"\x02D9"},
                                                                               {Trait::latin1ToString("&doteq;"), u"\x2250"},
                                                                               {Trait::latin1ToString("&doteqdot;"), u"\x2251"},
                                                                               {Trait::latin1ToString("&dotminus;"), u"\x2238"},
                                                                               {Trait::latin1ToString("&dotplus;"), u"\x2214"},
                                                                               {Trait::latin1ToString("&dotsquare;"), u"\x22A1"},
                                                                               {Trait::latin1ToString("&doublebarwedge;"), u"\x2306"},
                                                                               {Trait::latin1ToString("&downarrow;"), u"\x2193"},
                                                                               {Trait::latin1ToString("&downdownarrows;"), u"\x21CA"},
                                                                               {Trait::latin1ToString("&downharpoonleft;"), u"\x21C3"},
                                                                               {Trait::latin1ToString("&downharpoonright;"), u"\x21C2"},
                                                                               {Trait::latin1ToString("&drbkarow;"), u"\x2910"},
                                                                               {Trait::latin1ToString("&drcorn;"), u"\x231F"},
                                                                               {Trait::latin1ToString("&drcrop;"), u"\x230C"},
                                                                               {Trait::latin1ToString("&dscr;"), u"\xD835\xDCB9"},
                                                                               {Trait::latin1ToString("&dscy;"), u"\x0455"},
                                                                               {Trait::latin1ToString("&dsol;"), u"\x29F6"},
                                                                               {Trait::latin1ToString("&dstrok;"), u"\x0111"},
                                                                               {Trait::latin1ToString("&dtdot;"), u"\x22F1"},
                                                                               {Trait::latin1ToString("&dtri;"), u"\x25BF"},
                                                                               {Trait::latin1ToString("&dtrif;"), u"\x25BE"},
                                                                               {Trait::latin1ToString("&duarr;"), u"\x21F5"},
                                                                               {Trait::latin1ToString("&duhar;"), u"\x296F"},
                                                                               {Trait::latin1ToString("&dwangle;"), u"\x29A6"},
                                                                               {Trait::latin1ToString("&dzcy;"), u"\x045F"},
                                                                               {Trait::latin1ToString("&dzigrarr;"), u"\x27FF"},
                                                                               {Trait::latin1ToString("&eDDot;"), u"\x2A77"},
                                                                               {Trait::latin1ToString("&eDot;"), u"\x2251"},
                                                                               {Trait::latin1ToString("&eacute"), u"\x00E9"},
                                                                               {Trait::latin1ToString("&eacute;"), u"\x00E9"},
                                                                               {Trait::latin1ToString("&easter;"), u"\x2A6E"},
                                                                               {Trait::latin1ToString("&ecaron;"), u"\x011B"},
                                                                               {Trait::latin1ToString("&ecir;"), u"\x2256"},
                                                                               {Trait::latin1ToString("&ecirc"), u"\x00EA"},
                                                                               {Trait::latin1ToString("&ecirc;"), u"\x00EA"},
                                                                               {Trait::latin1ToString("&ecolon;"), u"\x2255"},
                                                                               {Trait::latin1ToString("&ecy;"), u"\x044D"},
                                                                               {Trait::latin1ToString("&edot;"), u"\x0117"},
                                                                               {Trait::latin1ToString("&ee;"), u"\x2147"},
                                                                               {Trait::latin1ToString("&efDot;"), u"\x2252"},
                                                                               {Trait::latin1ToString("&efr;"), u"\xD835\xDD22"},
                                                                               {Trait::latin1ToString("&eg;"), u"\x2A9A"},
                                                                               {Trait::latin1ToString("&egrave"), u"\x00E8"},
                                                                               {Trait::latin1ToString("&egrave;"), u"\x00E8"},
                                                                               {Trait::latin1ToString("&egs;"), u"\x2A96"},
                                                                               {Trait::latin1ToString("&egsdot;"), u"\x2A98"},
                                                                               {Trait::latin1ToString("&el;"), u"\x2A99"},
                                                                               {Trait::latin1ToString("&elinters;"), u"\x23E7"},
                                                                               {Trait::latin1ToString("&ell;"), u"\x2113"},
                                                                               {Trait::latin1ToString("&els;"), u"\x2A95"},
                                                                               {Trait::latin1ToString("&elsdot;"), u"\x2A97"},
                                                                               {Trait::latin1ToString("&emacr;"), u"\x0113"},
                                                                               {Trait::latin1ToString("&empty;"), u"\x2205"},
                                                                               {Trait::latin1ToString("&emptyset;"), u"\x2205"},
                                                                               {Trait::latin1ToString("&emptyv;"), u"\x2205"},
                                                                               {Trait::latin1ToString("&emsp13;"), u"\x2004"},
                                                                               {Trait::latin1ToString("&emsp14;"), u"\x2005"},
                                                                               {Trait::latin1ToString("&emsp;"), u"\x2003"},
                                                                               {Trait::latin1ToString("&eng;"), u"\x014B"},
                                                                               {Trait::latin1ToString("&ensp;"), u"\x2002"},
                                                                               {Trait::latin1ToString("&eogon;"), u"\x0119"},
                                                                               {Trait::latin1ToString("&eopf;"), u"\xD835\xDD56"},
                                                                               {Trait::latin1ToString("&epar;"), u"\x22D5"},
                                                                               {Trait::latin1ToString("&eparsl;"), u"\x29E3"},
                                                                               {Trait::latin1ToString("&eplus;"), u"\x2A71"},
                                                                               {Trait::latin1ToString("&epsi;"), u"\x03B5"},
                                                                               {Trait::latin1ToString("&epsilon;"), u"\x03B5"},
                                                                               {Trait::latin1ToString("&epsiv;"), u"\x03F5"},
                                                                               {Trait::latin1ToString("&eqcirc;"), u"\x2256"},
                                                                               {Trait::latin1ToString("&eqcolon;"), u"\x2255"},
                                                                               {Trait::latin1ToString("&eqsim;"), u"\x2242"},
                                                                               {Trait::latin1ToString("&eqslantgtr;"), u"\x2A96"},
                                                                               {Trait::latin1ToString("&eqslantless;"), u"\x2A95"},
                                                                               {Trait::latin1ToString("&equals;"), u"\x003D"},
                                                                               {Trait::latin1ToString("&equest;"), u"\x225F"},
                                                                               {Trait::latin1ToString("&equiv;"), u"\x2261"},
                                                                               {Trait::latin1ToString("&equivDD;"), u"\x2A78"},
                                                                               {Trait::latin1ToString("&eqvparsl;"), u"\x29E5"},
                                                                               {Trait::latin1ToString("&erDot;"), u"\x2253"},
                                                                               {Trait::latin1ToString("&erarr;"), u"\x2971"},
                                                                               {Trait::latin1ToString("&escr;"), u"\x212F"},
                                                                               {Trait::latin1ToString("&esdot;"), u"\x2250"},
                                                                               {Trait::latin1ToString("&esim;"), u"\x2242"},
                                                                               {Trait::latin1ToString("&eta;"), u"\x03B7"},
                                                                               {Trait::latin1ToString("&eth"), u"\x00F0"},
                                                                               {Trait::latin1ToString("&eth;"), u"\x00F0"},
                                                                               {Trait::latin1ToString("&euml"), u"\x00EB"},
                                                                               {Trait::latin1ToString("&euml;"), u"\x00EB"},
                                                                               {Trait::latin1ToString("&euro;"), u"\x20AC"},
                                                                               {Trait::latin1ToString("&excl;"), u"\x0021"},
                                                                               {Trait::latin1ToString("&exist;"), u"\x2203"},
                                                                               {Trait::latin1ToString("&expectation;"), u"\x2130"},
                                                                               {Trait::latin1ToString("&exponentiale;"), u"\x2147"},
                                                                               {Trait::latin1ToString("&fallingdotseq;"), u"\x2252"},
                                                                               {Trait::latin1ToString("&fcy;"), u"\x0444"},
                                                                               {Trait::latin1ToString("&female;"), u"\x2640"},
                                                                               {Trait::latin1ToString("&ffilig;"), u"\xFB03"},
                                                                               {Trait::latin1ToString("&fflig;"), u"\xFB00"},
                                                                               {Trait::latin1ToString("&ffllig;"), u"\xFB04"},
                                                                               {Trait::latin1ToString("&ffr;"), u"\xD835\xDD23"},
                                                                               {Trait::latin1ToString("&filig;"), u"\xFB01"},
                                                                               {Trait::latin1ToString("&fjlig;"), u"\x0066\x006A"},
                                                                               {Trait::latin1ToString("&flat;"), u"\x266D"},
                                                                               {Trait::latin1ToString("&fllig;"), u"\xFB02"},
                                                                               {Trait::latin1ToString("&fltns;"), u"\x25B1"},
                                                                               {Trait::latin1ToString("&fnof;"), u"\x0192"},
                                                                               {Trait::latin1ToString("&fopf;"), u"\xD835\xDD57"},
                                                                               {Trait::latin1ToString("&forall;"), u"\x2200"},
                                                                               {Trait::latin1ToString("&fork;"), u"\x22D4"},
                                                                               {Trait::latin1ToString("&forkv;"), u"\x2AD9"},
                                                                               {Trait::latin1ToString("&fpartint;"), u"\x2A0D"},
                                                                               {Trait::latin1ToString("&frac12"), u"\x00BD"},
                                                                               {Trait::latin1ToString("&frac12;"), u"\x00BD"},
                                                                               {Trait::latin1ToString("&frac13;"), u"\x2153"},
                                                                               {Trait::latin1ToString("&frac14"), u"\x00BC"},
                                                                               {Trait::latin1ToString("&frac14;"), u"\x00BC"},
                                                                               {Trait::latin1ToString("&frac15;"), u"\x2155"},
                                                                               {Trait::latin1ToString("&frac16;"), u"\x2159"},
                                                                               {Trait::latin1ToString("&frac18;"), u"\x215B"},
                                                                               {Trait::latin1ToString("&frac23;"), u"\x2154"},
                                                                               {Trait::latin1ToString("&frac25;"), u"\x2156"},
                                                                               {Trait::latin1ToString("&frac34"), u"\x00BE"},
                                                                               {Trait::latin1ToString("&frac34;"), u"\x00BE"},
                                                                               {Trait::latin1ToString("&frac35;"), u"\x2157"},
                                                                               {Trait::latin1ToString("&frac38;"), u"\x215C"},
                                                                               {Trait::latin1ToString("&frac45;"), u"\x2158"},
                                                                               {Trait::latin1ToString("&frac56;"), u"\x215A"},
                                                                               {Trait::latin1ToString("&frac58;"), u"\x215D"},
                                                                               {Trait::latin1ToString("&frac78;"), u"\x215E"},
                                                                               {Trait::latin1ToString("&frasl;"), u"\x2044"},
                                                                               {Trait::latin1ToString("&frown;"), u"\x2322"},
                                                                               {Trait::latin1ToString("&fscr;"), u"\xD835\xDCBB"},
                                                                               {Trait::latin1ToString("&gE;"), u"\x2267"},
                                                                               {Trait::latin1ToString("&gEl;"), u"\x2A8C"},
                                                                               {Trait::latin1ToString("&gacute;"), u"\x01F5"},
                                                                               {Trait::latin1ToString("&gamma;"), u"\x03B3"},
                                                                               {Trait::latin1ToString("&gammad;"), u"\x03DD"},
                                                                               {Trait::latin1ToString("&gap;"), u"\x2A86"},
                                                                               {Trait::latin1ToString("&gbreve;"), u"\x011F"},
                                                                               {Trait::latin1ToString("&gcirc;"), u"\x011D"},
                                                                               {Trait::latin1ToString("&gcy;"), u"\x0433"},
                                                                               {Trait::latin1ToString("&gdot;"), u"\x0121"},
                                                                               {Trait::latin1ToString("&ge;"), u"\x2265"},
                                                                               {Trait::latin1ToString("&gel;"), u"\x22DB"},
                                                                               {Trait::latin1ToString("&geq;"), u"\x2265"},
                                                                               {Trait::latin1ToString("&geqq;"), u"\x2267"},
                                                                               {Trait::latin1ToString("&geqslant;"), u"\x2A7E"},
                                                                               {Trait::latin1ToString("&ges;"), u"\x2A7E"},
                                                                               {Trait::latin1ToString("&gescc;"), u"\x2AA9"},
                                                                               {Trait::latin1ToString("&gesdot;"), u"\x2A80"},
                                                                               {Trait::latin1ToString("&gesdoto;"), u"\x2A82"},
                                                                               {Trait::latin1ToString("&gesdotol;"), u"\x2A84"},
                                                                               {Trait::latin1ToString("&gesl;"), u"\x22DB\xFE00"},
                                                                               {Trait::latin1ToString("&gesles;"), u"\x2A94"},
                                                                               {Trait::latin1ToString("&gfr;"), u"\xD835\xDD24"},
                                                                               {Trait::latin1ToString("&gg;"), u"\x226B"},
                                                                               {Trait::latin1ToString("&ggg;"), u"\x22D9"},
                                                                               {Trait::latin1ToString("&gimel;"), u"\x2137"},
                                                                               {Trait::latin1ToString("&gjcy;"), u"\x0453"},
                                                                               {Trait::latin1ToString("&gl;"), u"\x2277"},
                                                                               {Trait::latin1ToString("&glE;"), u"\x2A92"},
                                                                               {Trait::latin1ToString("&gla;"), u"\x2AA5"},
                                                                               {Trait::latin1ToString("&glj;"), u"\x2AA4"},
                                                                               {Trait::latin1ToString("&gnE;"), u"\x2269"},
                                                                               {Trait::latin1ToString("&gnap;"), u"\x2A8A"},
                                                                               {Trait::latin1ToString("&gnapprox;"), u"\x2A8A"},
                                                                               {Trait::latin1ToString("&gne;"), u"\x2A88"},
                                                                               {Trait::latin1ToString("&gneq;"), u"\x2A88"},
                                                                               {Trait::latin1ToString("&gneqq;"), u"\x2269"},
                                                                               {Trait::latin1ToString("&gnsim;"), u"\x22E7"},
                                                                               {Trait::latin1ToString("&gopf;"), u"\xD835\xDD58"},
                                                                               {Trait::latin1ToString("&grave;"), u"\x0060"},
                                                                               {Trait::latin1ToString("&gscr;"), u"\x210A"},
                                                                               {Trait::latin1ToString("&gsim;"), u"\x2273"},
                                                                               {Trait::latin1ToString("&gsime;"), u"\x2A8E"},
                                                                               {Trait::latin1ToString("&gsiml;"), u"\x2A90"},
                                                                               {Trait::latin1ToString("&gt"), u"\x003E"},
                                                                               {Trait::latin1ToString("&gt;"), u"\x003E"},
                                                                               {Trait::latin1ToString("&gtcc;"), u"\x2AA7"},
                                                                               {Trait::latin1ToString("&gtcir;"), u"\x2A7A"},
                                                                               {Trait::latin1ToString("&gtdot;"), u"\x22D7"},
                                                                               {Trait::latin1ToString("&gtlPar;"), u"\x2995"},
                                                                               {Trait::latin1ToString("&gtquest;"), u"\x2A7C"},
                                                                               {Trait::latin1ToString("&gtrapprox;"), u"\x2A86"},
                                                                               {Trait::latin1ToString("&gtrarr;"), u"\x2978"},
                                                                               {Trait::latin1ToString("&gtrdot;"), u"\x22D7"},
                                                                               {Trait::latin1ToString("&gtreqless;"), u"\x22DB"},
                                                                               {Trait::latin1ToString("&gtreqqless;"), u"\x2A8C"},
                                                                               {Trait::latin1ToString("&gtrless;"), u"\x2277"},
                                                                               {Trait::latin1ToString("&gtrsim;"), u"\x2273"},
                                                                               {Trait::latin1ToString("&gvertneqq;"), u"\x2269\xFE00"},
                                                                               {Trait::latin1ToString("&gvnE;"), u"\x2269\xFE00"},
                                                                               {Trait::latin1ToString("&hArr;"), u"\x21D4"},
                                                                               {Trait::latin1ToString("&hairsp;"), u"\x200A"},
                                                                               {Trait::latin1ToString("&half;"), u"\x00BD"},
                                                                               {Trait::latin1ToString("&hamilt;"), u"\x210B"},
                                                                               {Trait::latin1ToString("&hardcy;"), u"\x044A"},
                                                                               {Trait::latin1ToString("&harr;"), u"\x2194"},
                                                                               {Trait::latin1ToString("&harrcir;"), u"\x2948"},
                                                                               {Trait::latin1ToString("&harrw;"), u"\x21AD"},
                                                                               {Trait::latin1ToString("&hbar;"), u"\x210F"},
                                                                               {Trait::latin1ToString("&hcirc;"), u"\x0125"},
                                                                               {Trait::latin1ToString("&hearts;"), u"\x2665"},
                                                                               {Trait::latin1ToString("&heartsuit;"), u"\x2665"},
                                                                               {Trait::latin1ToString("&hellip;"), u"\x2026"},
                                                                               {Trait::latin1ToString("&hercon;"), u"\x22B9"},
                                                                               {Trait::latin1ToString("&hfr;"), u"\xD835\xDD25"},
                                                                               {Trait::latin1ToString("&hksearow;"), u"\x2925"},
                                                                               {Trait::latin1ToString("&hkswarow;"), u"\x2926"},
                                                                               {Trait::latin1ToString("&hoarr;"), u"\x21FF"},
                                                                               {Trait::latin1ToString("&homtht;"), u"\x223B"},
                                                                               {Trait::latin1ToString("&hookleftarrow;"), u"\x21A9"},
                                                                               {Trait::latin1ToString("&hookrightarrow;"), u"\x21AA"},
                                                                               {Trait::latin1ToString("&hopf;"), u"\xD835\xDD59"},
                                                                               {Trait::latin1ToString("&horbar;"), u"\x2015"},
                                                                               {Trait::latin1ToString("&hscr;"), u"\xD835\xDCBD"},
                                                                               {Trait::latin1ToString("&hslash;"), u"\x210F"},
                                                                               {Trait::latin1ToString("&hstrok;"), u"\x0127"},
                                                                               {Trait::latin1ToString("&hybull;"), u"\x2043"},
                                                                               {Trait::latin1ToString("&hyphen;"), u"\x2010"},
                                                                               {Trait::latin1ToString("&iacute"), u"\x00ED"},
                                                                               {Trait::latin1ToString("&iacute;"), u"\x00ED"},
                                                                               {Trait::latin1ToString("&ic;"), u"\x2063"},
                                                                               {Trait::latin1ToString("&icirc"), u"\x00EE"},
                                                                               {Trait::latin1ToString("&icirc;"), u"\x00EE"},
                                                                               {Trait::latin1ToString("&icy;"), u"\x0438"},
                                                                               {Trait::latin1ToString("&iecy;"), u"\x0435"},
                                                                               {Trait::latin1ToString("&iexcl"), u"\x00A1"},
                                                                               {Trait::latin1ToString("&iexcl;"), u"\x00A1"},
                                                                               {Trait::latin1ToString("&iff;"), u"\x21D4"},
                                                                               {Trait::latin1ToString("&ifr;"), u"\xD835\xDD26"},
                                                                               {Trait::latin1ToString("&igrave"), u"\x00EC"},
                                                                               {Trait::latin1ToString("&igrave;"), u"\x00EC"},
                                                                               {Trait::latin1ToString("&ii;"), u"\x2148"},
                                                                               {Trait::latin1ToString("&iiiint;"), u"\x2A0C"},
                                                                               {Trait::latin1ToString("&iiint;"), u"\x222D"},
                                                                               {Trait::latin1ToString("&iinfin;"), u"\x29DC"},
                                                                               {Trait::latin1ToString("&iiota;"), u"\x2129"},
                                                                               {Trait::latin1ToString("&ijlig;"), u"\x0133"},
                                                                               {Trait::latin1ToString("&imacr;"), u"\x012B"},
                                                                               {Trait::latin1ToString("&image;"), u"\x2111"},
                                                                               {Trait::latin1ToString("&imagline;"), u"\x2110"},
                                                                               {Trait::latin1ToString("&imagpart;"), u"\x2111"},
                                                                               {Trait::latin1ToString("&imath;"), u"\x0131"},
                                                                               {Trait::latin1ToString("&imof;"), u"\x22B7"},
                                                                               {Trait::latin1ToString("&imped;"), u"\x01B5"},
                                                                               {Trait::latin1ToString("&in;"), u"\x2208"},
                                                                               {Trait::latin1ToString("&incare;"), u"\x2105"},
                                                                               {Trait::latin1ToString("&infin;"), u"\x221E"},
                                                                               {Trait::latin1ToString("&infintie;"), u"\x29DD"},
                                                                               {Trait::latin1ToString("&inodot;"), u"\x0131"},
                                                                               {Trait::latin1ToString("&int;"), u"\x222B"},
                                                                               {Trait::latin1ToString("&intcal;"), u"\x22BA"},
                                                                               {Trait::latin1ToString("&integers;"), u"\x2124"},
                                                                               {Trait::latin1ToString("&intercal;"), u"\x22BA"},
                                                                               {Trait::latin1ToString("&intlarhk;"), u"\x2A17"},
                                                                               {Trait::latin1ToString("&intprod;"), u"\x2A3C"},
                                                                               {Trait::latin1ToString("&iocy;"), u"\x0451"},
                                                                               {Trait::latin1ToString("&iogon;"), u"\x012F"},
                                                                               {Trait::latin1ToString("&iopf;"), u"\xD835\xDD5A"},
                                                                               {Trait::latin1ToString("&iota;"), u"\x03B9"},
                                                                               {Trait::latin1ToString("&iprod;"), u"\x2A3C"},
                                                                               {Trait::latin1ToString("&iquest"), u"\x00BF"},
                                                                               {Trait::latin1ToString("&iquest;"), u"\x00BF"},
                                                                               {Trait::latin1ToString("&iscr;"), u"\xD835\xDCBE"},
                                                                               {Trait::latin1ToString("&isin;"), u"\x2208"},
                                                                               {Trait::latin1ToString("&isinE;"), u"\x22F9"},
                                                                               {Trait::latin1ToString("&isindot;"), u"\x22F5"},
                                                                               {Trait::latin1ToString("&isins;"), u"\x22F4"},
                                                                               {Trait::latin1ToString("&isinsv;"), u"\x22F3"},
                                                                               {Trait::latin1ToString("&isinv;"), u"\x2208"},
                                                                               {Trait::latin1ToString("&it;"), u"\x2062"},
                                                                               {Trait::latin1ToString("&itilde;"), u"\x0129"},
                                                                               {Trait::latin1ToString("&iukcy;"), u"\x0456"},
                                                                               {Trait::latin1ToString("&iuml"), u"\x00EF"},
                                                                               {Trait::latin1ToString("&iuml;"), u"\x00EF"},
                                                                               {Trait::latin1ToString("&jcirc;"), u"\x0135"},
                                                                               {Trait::latin1ToString("&jcy;"), u"\x0439"},
                                                                               {Trait::latin1ToString("&jfr;"), u"\xD835\xDD27"},
                                                                               {Trait::latin1ToString("&jmath;"), u"\x0237"},
                                                                               {Trait::latin1ToString("&jopf;"), u"\xD835\xDD5B"},
                                                                               {Trait::latin1ToString("&jscr;"), u"\xD835\xDCBF"},
                                                                               {Trait::latin1ToString("&jsercy;"), u"\x0458"},
                                                                               {Trait::latin1ToString("&jukcy;"), u"\x0454"},
                                                                               {Trait::latin1ToString("&kappa;"), u"\x03BA"},
                                                                               {Trait::latin1ToString("&kappav;"), u"\x03F0"},
                                                                               {Trait::latin1ToString("&kcedil;"), u"\x0137"},
                                                                               {Trait::latin1ToString("&kcy;"), u"\x043A"},
                                                                               {Trait::latin1ToString("&kfr;"), u"\xD835\xDD28"},
                                                                               {Trait::latin1ToString("&kgreen;"), u"\x0138"},
                                                                               {Trait::latin1ToString("&khcy;"), u"\x0445"},
                                                                               {Trait::latin1ToString("&kjcy;"), u"\x045C"},
                                                                               {Trait::latin1ToString("&kopf;"), u"\xD835\xDD5C"},
                                                                               {Trait::latin1ToString("&kscr;"), u"\xD835\xDCC0"},
                                                                               {Trait::latin1ToString("&lAarr;"), u"\x21DA"},
                                                                               {Trait::latin1ToString("&lArr;"), u"\x21D0"},
                                                                               {Trait::latin1ToString("&lAtail;"), u"\x291B"},
                                                                               {Trait::latin1ToString("&lBarr;"), u"\x290E"},
                                                                               {Trait::latin1ToString("&lE;"), u"\x2266"},
                                                                               {Trait::latin1ToString("&lEg;"), u"\x2A8B"},
                                                                               {Trait::latin1ToString("&lHar;"), u"\x2962"},
                                                                               {Trait::latin1ToString("&lacute;"), u"\x013A"},
                                                                               {Trait::latin1ToString("&laemptyv;"), u"\x29B4"},
                                                                               {Trait::latin1ToString("&lagran;"), u"\x2112"},
                                                                               {Trait::latin1ToString("&lambda;"), u"\x03BB"},
                                                                               {Trait::latin1ToString("&lang;"), u"\x27E8"},
                                                                               {Trait::latin1ToString("&langd;"), u"\x2991"},
                                                                               {Trait::latin1ToString("&langle;"), u"\x27E8"},
                                                                               {Trait::latin1ToString("&lap;"), u"\x2A85"},
                                                                               {Trait::latin1ToString("&laquo"), u"\x00AB"},
                                                                               {Trait::latin1ToString("&laquo;"), u"\x00AB"},
                                                                               {Trait::latin1ToString("&larr;"), u"\x2190"},
                                                                               {Trait::latin1ToString("&larrb;"), u"\x21E4"},
                                                                               {Trait::latin1ToString("&larrbfs;"), u"\x291F"},
                                                                               {Trait::latin1ToString("&larrfs;"), u"\x291D"},
                                                                               {Trait::latin1ToString("&larrhk;"), u"\x21A9"},
                                                                               {Trait::latin1ToString("&larrlp;"), u"\x21AB"},
                                                                               {Trait::latin1ToString("&larrpl;"), u"\x2939"},
                                                                               {Trait::latin1ToString("&larrsim;"), u"\x2973"},
                                                                               {Trait::latin1ToString("&larrtl;"), u"\x21A2"},
                                                                               {Trait::latin1ToString("&lat;"), u"\x2AAB"},
                                                                               {Trait::latin1ToString("&latail;"), u"\x2919"},
                                                                               {Trait::latin1ToString("&late;"), u"\x2AAD"},
                                                                               {Trait::latin1ToString("&lates;"), u"\x2AAD\xFE00"},
                                                                               {Trait::latin1ToString("&lbarr;"), u"\x290C"},
                                                                               {Trait::latin1ToString("&lbbrk;"), u"\x2772"},
                                                                               {Trait::latin1ToString("&lbrace;"), u"\x007B"},
                                                                               {Trait::latin1ToString("&lbrack;"), u"\x005B"},
                                                                               {Trait::latin1ToString("&lbrke;"), u"\x298B"},
                                                                               {Trait::latin1ToString("&lbrksld;"), u"\x298F"},
                                                                               {Trait::latin1ToString("&lbrkslu;"), u"\x298D"},
                                                                               {Trait::latin1ToString("&lcaron;"), u"\x013E"},
                                                                               {Trait::latin1ToString("&lcedil;"), u"\x013C"},
                                                                               {Trait::latin1ToString("&lceil;"), u"\x2308"},
                                                                               {Trait::latin1ToString("&lcub;"), u"\x007B"},
                                                                               {Trait::latin1ToString("&lcy;"), u"\x043B"},
                                                                               {Trait::latin1ToString("&ldca;"), u"\x2936"},
                                                                               {Trait::latin1ToString("&ldquo;"), u"\x201C"},
                                                                               {Trait::latin1ToString("&ldquor;"), u"\x201E"},
                                                                               {Trait::latin1ToString("&ldrdhar;"), u"\x2967"},
                                                                               {Trait::latin1ToString("&ldrushar;"), u"\x294B"},
                                                                               {Trait::latin1ToString("&ldsh;"), u"\x21B2"},
                                                                               {Trait::latin1ToString("&le;"), u"\x2264"},
                                                                               {Trait::latin1ToString("&leftarrow;"), u"\x2190"},
                                                                               {Trait::latin1ToString("&leftarrowtail;"), u"\x21A2"},
                                                                               {Trait::latin1ToString("&leftharpoondown;"), u"\x21BD"},
                                                                               {Trait::latin1ToString("&leftharpoonup;"), u"\x21BC"},
                                                                               {Trait::latin1ToString("&leftleftarrows;"), u"\x21C7"},
                                                                               {Trait::latin1ToString("&leftrightarrow;"), u"\x2194"},
                                                                               {Trait::latin1ToString("&leftrightarrows;"), u"\x21C6"},
                                                                               {Trait::latin1ToString("&leftrightharpoons;"), u"\x21CB"},
                                                                               {Trait::latin1ToString("&leftrightsquigarrow;"), u"\x21AD"},
                                                                               {Trait::latin1ToString("&leftthreetimes;"), u"\x22CB"},
                                                                               {Trait::latin1ToString("&leg;"), u"\x22DA"},
                                                                               {Trait::latin1ToString("&leq;"), u"\x2264"},
                                                                               {Trait::latin1ToString("&leqq;"), u"\x2266"},
                                                                               {Trait::latin1ToString("&leqslant;"), u"\x2A7D"},
                                                                               {Trait::latin1ToString("&les;"), u"\x2A7D"},
                                                                               {Trait::latin1ToString("&lescc;"), u"\x2AA8"},
                                                                               {Trait::latin1ToString("&lesdot;"), u"\x2A7F"},
                                                                               {Trait::latin1ToString("&lesdoto;"), u"\x2A81"},
                                                                               {Trait::latin1ToString("&lesdotor;"), u"\x2A83"},
                                                                               {Trait::latin1ToString("&lesg;"), u"\x22DA\xFE00"},
                                                                               {Trait::latin1ToString("&lesges;"), u"\x2A93"},
                                                                               {Trait::latin1ToString("&lessapprox;"), u"\x2A85"},
                                                                               {Trait::latin1ToString("&lessdot;"), u"\x22D6"},
                                                                               {Trait::latin1ToString("&lesseqgtr;"), u"\x22DA"},
                                                                               {Trait::latin1ToString("&lesseqqgtr;"), u"\x2A8B"},
                                                                               {Trait::latin1ToString("&lessgtr;"), u"\x2276"},
                                                                               {Trait::latin1ToString("&lesssim;"), u"\x2272"},
                                                                               {Trait::latin1ToString("&lfisht;"), u"\x297C"},
                                                                               {Trait::latin1ToString("&lfloor;"), u"\x230A"},
                                                                               {Trait::latin1ToString("&lfr;"), u"\xD835\xDD29"},
                                                                               {Trait::latin1ToString("&lg;"), u"\x2276"},
                                                                               {Trait::latin1ToString("&lgE;"), u"\x2A91"},
                                                                               {Trait::latin1ToString("&lhard;"), u"\x21BD"},
                                                                               {Trait::latin1ToString("&lharu;"), u"\x21BC"},
                                                                               {Trait::latin1ToString("&lharul;"), u"\x296A"},
                                                                               {Trait::latin1ToString("&lhblk;"), u"\x2584"},
                                                                               {Trait::latin1ToString("&ljcy;"), u"\x0459"},
                                                                               {Trait::latin1ToString("&ll;"), u"\x226A"},
                                                                               {Trait::latin1ToString("&llarr;"), u"\x21C7"},
                                                                               {Trait::latin1ToString("&llcorner;"), u"\x231E"},
                                                                               {Trait::latin1ToString("&llhard;"), u"\x296B"},
                                                                               {Trait::latin1ToString("&lltri;"), u"\x25FA"},
                                                                               {Trait::latin1ToString("&lmidot;"), u"\x0140"},
                                                                               {Trait::latin1ToString("&lmoust;"), u"\x23B0"},
                                                                               {Trait::latin1ToString("&lmoustache;"), u"\x23B0"},
                                                                               {Trait::latin1ToString("&lnE;"), u"\x2268"},
                                                                               {Trait::latin1ToString("&lnap;"), u"\x2A89"},
                                                                               {Trait::latin1ToString("&lnapprox;"), u"\x2A89"},
                                                                               {Trait::latin1ToString("&lne;"), u"\x2A87"},
                                                                               {Trait::latin1ToString("&lneq;"), u"\x2A87"},
                                                                               {Trait::latin1ToString("&lneqq;"), u"\x2268"},
                                                                               {Trait::latin1ToString("&lnsim;"), u"\x22E6"},
                                                                               {Trait::latin1ToString("&loang;"), u"\x27EC"},
                                                                               {Trait::latin1ToString("&loarr;"), u"\x21FD"},
                                                                               {Trait::latin1ToString("&lobrk;"), u"\x27E6"},
                                                                               {Trait::latin1ToString("&longleftarrow;"), u"\x27F5"},
                                                                               {Trait::latin1ToString("&longleftrightarrow;"), u"\x27F7"},
                                                                               {Trait::latin1ToString("&longmapsto;"), u"\x27FC"},
                                                                               {Trait::latin1ToString("&longrightarrow;"), u"\x27F6"},
                                                                               {Trait::latin1ToString("&looparrowleft;"), u"\x21AB"},
                                                                               {Trait::latin1ToString("&looparrowright;"), u"\x21AC"},
                                                                               {Trait::latin1ToString("&lopar;"), u"\x2985"},
                                                                               {Trait::latin1ToString("&lopf;"), u"\xD835\xDD5D"},
                                                                               {Trait::latin1ToString("&loplus;"), u"\x2A2D"},
                                                                               {Trait::latin1ToString("&lotimes;"), u"\x2A34"},
                                                                               {Trait::latin1ToString("&lowast;"), u"\x2217"},
                                                                               {Trait::latin1ToString("&lowbar;"), u"\x005F"},
                                                                               {Trait::latin1ToString("&loz;"), u"\x25CA"},
                                                                               {Trait::latin1ToString("&lozenge;"), u"\x25CA"},
                                                                               {Trait::latin1ToString("&lozf;"), u"\x29EB"},
                                                                               {Trait::latin1ToString("&lpar;"), u"\x0028"},
                                                                               {Trait::latin1ToString("&lparlt;"), u"\x2993"},
                                                                               {Trait::latin1ToString("&lrarr;"), u"\x21C6"},
                                                                               {Trait::latin1ToString("&lrcorner;"), u"\x231F"},
                                                                               {Trait::latin1ToString("&lrhar;"), u"\x21CB"},
                                                                               {Trait::latin1ToString("&lrhard;"), u"\x296D"},
                                                                               {Trait::latin1ToString("&lrm;"), u"\x200E"},
                                                                               {Trait::latin1ToString("&lrtri;"), u"\x22BF"},
                                                                               {Trait::latin1ToString("&lsaquo;"), u"\x2039"},
                                                                               {Trait::latin1ToString("&lscr;"), u"\xD835\xDCC1"},
                                                                               {Trait::latin1ToString("&lsh;"), u"\x21B0"},
                                                                               {Trait::latin1ToString("&lsim;"), u"\x2272"},
                                                                               {Trait::latin1ToString("&lsime;"), u"\x2A8D"},
                                                                               {Trait::latin1ToString("&lsimg;"), u"\x2A8F"},
                                                                               {Trait::latin1ToString("&lsqb;"), u"\x005B"},
                                                                               {Trait::latin1ToString("&lsquo;"), u"\x2018"},
                                                                               {Trait::latin1ToString("&lsquor;"), u"\x201A"},
                                                                               {Trait::latin1ToString("&lstrok;"), u"\x0142"},
                                                                               {Trait::latin1ToString("&lt"), u"\x003C"},
                                                                               {Trait::latin1ToString("&lt;"), u"\x003C"},
                                                                               {Trait::latin1ToString("&ltcc;"), u"\x2AA6"},
                                                                               {Trait::latin1ToString("&ltcir;"), u"\x2A79"},
                                                                               {Trait::latin1ToString("&ltdot;"), u"\x22D6"},
                                                                               {Trait::latin1ToString("&lthree;"), u"\x22CB"},
                                                                               {Trait::latin1ToString("&ltimes;"), u"\x22C9"},
                                                                               {Trait::latin1ToString("&ltlarr;"), u"\x2976"},
                                                                               {Trait::latin1ToString("&ltquest;"), u"\x2A7B"},
                                                                               {Trait::latin1ToString("&ltrPar;"), u"\x2996"},
                                                                               {Trait::latin1ToString("&ltri;"), u"\x25C3"},
                                                                               {Trait::latin1ToString("&ltrie;"), u"\x22B4"},
                                                                               {Trait::latin1ToString("&ltrif;"), u"\x25C2"},
                                                                               {Trait::latin1ToString("&lurdshar;"), u"\x294A"},
                                                                               {Trait::latin1ToString("&luruhar;"), u"\x2966"},
                                                                               {Trait::latin1ToString("&lvertneqq;"), u"\x2268\xFE00"},
                                                                               {Trait::latin1ToString("&lvnE;"), u"\x2268\xFE00"},
                                                                               {Trait::latin1ToString("&mDDot;"), u"\x223A"},
                                                                               {Trait::latin1ToString("&macr"), u"\x00AF"},
                                                                               {Trait::latin1ToString("&macr;"), u"\x00AF"},
                                                                               {Trait::latin1ToString("&male;"), u"\x2642"},
                                                                               {Trait::latin1ToString("&malt;"), u"\x2720"},
                                                                               {Trait::latin1ToString("&maltese;"), u"\x2720"},
                                                                               {Trait::latin1ToString("&map;"), u"\x21A6"},
                                                                               {Trait::latin1ToString("&mapsto;"), u"\x21A6"},
                                                                               {Trait::latin1ToString("&mapstodown;"), u"\x21A7"},
                                                                               {Trait::latin1ToString("&mapstoleft;"), u"\x21A4"},
                                                                               {Trait::latin1ToString("&mapstoup;"), u"\x21A5"},
                                                                               {Trait::latin1ToString("&marker;"), u"\x25AE"},
                                                                               {Trait::latin1ToString("&mcomma;"), u"\x2A29"},
                                                                               {Trait::latin1ToString("&mcy;"), u"\x043C"},
                                                                               {Trait::latin1ToString("&mdash;"), u"\x2014"},
                                                                               {Trait::latin1ToString("&measuredangle;"), u"\x2221"},
                                                                               {Trait::latin1ToString("&mfr;"), u"\xD835\xDD2A"},
                                                                               {Trait::latin1ToString("&mho;"), u"\x2127"},
                                                                               {Trait::latin1ToString("&micro"), u"\x00B5"},
                                                                               {Trait::latin1ToString("&micro;"), u"\x00B5"},
                                                                               {Trait::latin1ToString("&mid;"), u"\x2223"},
                                                                               {Trait::latin1ToString("&midast;"), u"\x002A"},
                                                                               {Trait::latin1ToString("&midcir;"), u"\x2AF0"},
                                                                               {Trait::latin1ToString("&middot"), u"\x00B7"},
                                                                               {Trait::latin1ToString("&middot;"), u"\x00B7"},
                                                                               {Trait::latin1ToString("&minus;"), u"\x2212"},
                                                                               {Trait::latin1ToString("&minusb;"), u"\x229F"},
                                                                               {Trait::latin1ToString("&minusd;"), u"\x2238"},
                                                                               {Trait::latin1ToString("&minusdu;"), u"\x2A2A"},
                                                                               {Trait::latin1ToString("&mlcp;"), u"\x2ADB"},
                                                                               {Trait::latin1ToString("&mldr;"), u"\x2026"},
                                                                               {Trait::latin1ToString("&mnplus;"), u"\x2213"},
                                                                               {Trait::latin1ToString("&models;"), u"\x22A7"},
                                                                               {Trait::latin1ToString("&mopf;"), u"\xD835\xDD5E"},
                                                                               {Trait::latin1ToString("&mp;"), u"\x2213"},
                                                                               {Trait::latin1ToString("&mscr;"), u"\xD835\xDCC2"},
                                                                               {Trait::latin1ToString("&mstpos;"), u"\x223E"},
                                                                               {Trait::latin1ToString("&mu;"), u"\x03BC"},
                                                                               {Trait::latin1ToString("&multimap;"), u"\x22B8"},
                                                                               {Trait::latin1ToString("&mumap;"), u"\x22B8"},
                                                                               {Trait::latin1ToString("&nGg;"), u"\x22D9\x0338"},
                                                                               {Trait::latin1ToString("&nGt;"), u"\x226B\x20D2"},
                                                                               {Trait::latin1ToString("&nGtv;"), u"\x226B\x0338"},
                                                                               {Trait::latin1ToString("&nLeftarrow;"), u"\x21CD"},
                                                                               {Trait::latin1ToString("&nLeftrightarrow;"), u"\x21CE"},
                                                                               {Trait::latin1ToString("&nLl;"), u"\x22D8\x0338"},
                                                                               {Trait::latin1ToString("&nLt;"), u"\x226A\x20D2"},
                                                                               {Trait::latin1ToString("&nLtv;"), u"\x226A\x0338"},
                                                                               {Trait::latin1ToString("&nRightarrow;"), u"\x21CF"},
                                                                               {Trait::latin1ToString("&nVDash;"), u"\x22AF"},
                                                                               {Trait::latin1ToString("&nVdash;"), u"\x22AE"},
                                                                               {Trait::latin1ToString("&nabla;"), u"\x2207"},
                                                                               {Trait::latin1ToString("&nacute;"), u"\x0144"},
                                                                               {Trait::latin1ToString("&nang;"), u"\x2220\x20D2"},
                                                                               {Trait::latin1ToString("&nap;"), u"\x2249"},
                                                                               {Trait::latin1ToString("&napE;"), u"\x2A70\x0338"},
                                                                               {Trait::latin1ToString("&napid;"), u"\x224B\x0338"},
                                                                               {Trait::latin1ToString("&napos;"), u"\x0149"},
                                                                               {Trait::latin1ToString("&napprox;"), u"\x2249"},
                                                                               {Trait::latin1ToString("&natur;"), u"\x266E"},
                                                                               {Trait::latin1ToString("&natural;"), u"\x266E"},
                                                                               {Trait::latin1ToString("&naturals;"), u"\x2115"},
                                                                               {Trait::latin1ToString("&nbsp"), u"\x00A0"},
                                                                               {Trait::latin1ToString("&nbsp;"), u"\x00A0"},
                                                                               {Trait::latin1ToString("&nbump;"), u"\x224E\x0338"},
                                                                               {Trait::latin1ToString("&nbumpe;"), u"\x224F\x0338"},
                                                                               {Trait::latin1ToString("&ncap;"), u"\x2A43"},
                                                                               {Trait::latin1ToString("&ncaron;"), u"\x0148"},
                                                                               {Trait::latin1ToString("&ncedil;"), u"\x0146"},
                                                                               {Trait::latin1ToString("&ncong;"), u"\x2247"},
                                                                               {Trait::latin1ToString("&ncongdot;"), u"\x2A6D\x0338"},
                                                                               {Trait::latin1ToString("&ncup;"), u"\x2A42"},
                                                                               {Trait::latin1ToString("&ncy;"), u"\x043D"},
                                                                               {Trait::latin1ToString("&ndash;"), u"\x2013"},
                                                                               {Trait::latin1ToString("&ne;"), u"\x2260"},
                                                                               {Trait::latin1ToString("&neArr;"), u"\x21D7"},
                                                                               {Trait::latin1ToString("&nearhk;"), u"\x2924"},
                                                                               {Trait::latin1ToString("&nearr;"), u"\x2197"},
                                                                               {Trait::latin1ToString("&nearrow;"), u"\x2197"},
                                                                               {Trait::latin1ToString("&nedot;"), u"\x2250\x0338"},
                                                                               {Trait::latin1ToString("&nequiv;"), u"\x2262"},
                                                                               {Trait::latin1ToString("&nesear;"), u"\x2928"},
                                                                               {Trait::latin1ToString("&nesim;"), u"\x2242\x0338"},
                                                                               {Trait::latin1ToString("&nexist;"), u"\x2204"},
                                                                               {Trait::latin1ToString("&nexists;"), u"\x2204"},
                                                                               {Trait::latin1ToString("&nfr;"), u"\xD835\xDD2B"},
                                                                               {Trait::latin1ToString("&ngE;"), u"\x2267\x0338"},
                                                                               {Trait::latin1ToString("&nge;"), u"\x2271"},
                                                                               {Trait::latin1ToString("&ngeq;"), u"\x2271"},
                                                                               {Trait::latin1ToString("&ngeqq;"), u"\x2267\x0338"},
                                                                               {Trait::latin1ToString("&ngeqslant;"), u"\x2A7E\x0338"},
                                                                               {Trait::latin1ToString("&nges;"), u"\x2A7E\x0338"},
                                                                               {Trait::latin1ToString("&ngsim;"), u"\x2275"},
                                                                               {Trait::latin1ToString("&ngt;"), u"\x226F"},
                                                                               {Trait::latin1ToString("&ngtr;"), u"\x226F"},
                                                                               {Trait::latin1ToString("&nhArr;"), u"\x21CE"},
                                                                               {Trait::latin1ToString("&nharr;"), u"\x21AE"},
                                                                               {Trait::latin1ToString("&nhpar;"), u"\x2AF2"},
                                                                               {Trait::latin1ToString("&ni;"), u"\x220B"},
                                                                               {Trait::latin1ToString("&nis;"), u"\x22FC"},
                                                                               {Trait::latin1ToString("&nisd;"), u"\x22FA"},
                                                                               {Trait::latin1ToString("&niv;"), u"\x220B"},
                                                                               {Trait::latin1ToString("&njcy;"), u"\x045A"},
                                                                               {Trait::latin1ToString("&nlArr;"), u"\x21CD"},
                                                                               {Trait::latin1ToString("&nlE;"), u"\x2266\x0338"},
                                                                               {Trait::latin1ToString("&nlarr;"), u"\x219A"},
                                                                               {Trait::latin1ToString("&nldr;"), u"\x2025"},
                                                                               {Trait::latin1ToString("&nle;"), u"\x2270"},
                                                                               {Trait::latin1ToString("&nleftarrow;"), u"\x219A"},
                                                                               {Trait::latin1ToString("&nleftrightarrow;"), u"\x21AE"},
                                                                               {Trait::latin1ToString("&nleq;"), u"\x2270"},
                                                                               {Trait::latin1ToString("&nleqq;"), u"\x2266\x0338"},
                                                                               {Trait::latin1ToString("&nleqslant;"), u"\x2A7D\x0338"},
                                                                               {Trait::latin1ToString("&nles;"), u"\x2A7D\x0338"},
                                                                               {Trait::latin1ToString("&nless;"), u"\x226E"},
                                                                               {Trait::latin1ToString("&nlsim;"), u"\x2274"},
                                                                               {Trait::latin1ToString("&nlt;"), u"\x226E"},
                                                                               {Trait::latin1ToString("&nltri;"), u"\x22EA"},
                                                                               {Trait::latin1ToString("&nltrie;"), u"\x22EC"},
                                                                               {Trait::latin1ToString("&nmid;"), u"\x2224"},
                                                                               {Trait::latin1ToString("&nopf;"), u"\xD835\xDD5F"},
                                                                               {Trait::latin1ToString("&not"), u"\x00AC"},
                                                                               {Trait::latin1ToString("&not;"), u"\x00AC"},
                                                                               {Trait::latin1ToString("&notin;"), u"\x2209"},
                                                                               {Trait::latin1ToString("&notinE;"), u"\x22F9\x0338"},
                                                                               {Trait::latin1ToString("&notindot;"), u"\x22F5\x0338"},
                                                                               {Trait::latin1ToString("&notinva;"), u"\x2209"},
                                                                               {Trait::latin1ToString("&notinvb;"), u"\x22F7"},
                                                                               {Trait::latin1ToString("&notinvc;"), u"\x22F6"},
                                                                               {Trait::latin1ToString("&notni;"), u"\x220C"},
                                                                               {Trait::latin1ToString("&notniva;"), u"\x220C"},
                                                                               {Trait::latin1ToString("&notnivb;"), u"\x22FE"},
                                                                               {Trait::latin1ToString("&notnivc;"), u"\x22FD"},
                                                                               {Trait::latin1ToString("&npar;"), u"\x2226"},
                                                                               {Trait::latin1ToString("&nparallel;"), u"\x2226"},
                                                                               {Trait::latin1ToString("&nparsl;"), u"\x2AFD\x20E5"},
                                                                               {Trait::latin1ToString("&npart;"), u"\x2202\x0338"},
                                                                               {Trait::latin1ToString("&npolint;"), u"\x2A14"},
                                                                               {Trait::latin1ToString("&npr;"), u"\x2280"},
                                                                               {Trait::latin1ToString("&nprcue;"), u"\x22E0"},
                                                                               {Trait::latin1ToString("&npre;"), u"\x2AAF\x0338"},
                                                                               {Trait::latin1ToString("&nprec;"), u"\x2280"},
                                                                               {Trait::latin1ToString("&npreceq;"), u"\x2AAF\x0338"},
                                                                               {Trait::latin1ToString("&nrArr;"), u"\x21CF"},
                                                                               {Trait::latin1ToString("&nrarr;"), u"\x219B"},
                                                                               {Trait::latin1ToString("&nrarrc;"), u"\x2933\x0338"},
                                                                               {Trait::latin1ToString("&nrarrw;"), u"\x219D\x0338"},
                                                                               {Trait::latin1ToString("&nrightarrow;"), u"\x219B"},
                                                                               {Trait::latin1ToString("&nrtri;"), u"\x22EB"},
                                                                               {Trait::latin1ToString("&nrtrie;"), u"\x22ED"},
                                                                               {Trait::latin1ToString("&nsc;"), u"\x2281"},
                                                                               {Trait::latin1ToString("&nsccue;"), u"\x22E1"},
                                                                               {Trait::latin1ToString("&nsce;"), u"\x2AB0\x0338"},
                                                                               {Trait::latin1ToString("&nscr;"), u"\xD835\xDCC3"},
                                                                               {Trait::latin1ToString("&nshortmid;"), u"\x2224"},
                                                                               {Trait::latin1ToString("&nshortparallel;"), u"\x2226"},
                                                                               {Trait::latin1ToString("&nsim;"), u"\x2241"},
                                                                               {Trait::latin1ToString("&nsime;"), u"\x2244"},
                                                                               {Trait::latin1ToString("&nsimeq;"), u"\x2244"},
                                                                               {Trait::latin1ToString("&nsmid;"), u"\x2224"},
                                                                               {Trait::latin1ToString("&nspar;"), u"\x2226"},
                                                                               {Trait::latin1ToString("&nsqsube;"), u"\x22E2"},
                                                                               {Trait::latin1ToString("&nsqsupe;"), u"\x22E3"},
                                                                               {Trait::latin1ToString("&nsub;"), u"\x2284"},
                                                                               {Trait::latin1ToString("&nsubE;"), u"\x2AC5\x0338"},
                                                                               {Trait::latin1ToString("&nsube;"), u"\x2288"},
                                                                               {Trait::latin1ToString("&nsubset;"), u"\x2282\x20D2"},
                                                                               {Trait::latin1ToString("&nsubseteq;"), u"\x2288"},
                                                                               {Trait::latin1ToString("&nsubseteqq;"), u"\x2AC5\x0338"},
                                                                               {Trait::latin1ToString("&nsucc;"), u"\x2281"},
                                                                               {Trait::latin1ToString("&nsucceq;"), u"\x2AB0\x0338"},
                                                                               {Trait::latin1ToString("&nsup;"), u"\x2285"},
                                                                               {Trait::latin1ToString("&nsupE;"), u"\x2AC6\x0338"},
                                                                               {Trait::latin1ToString("&nsupe;"), u"\x2289"},
                                                                               {Trait::latin1ToString("&nsupset;"), u"\x2283\x20D2"},
                                                                               {Trait::latin1ToString("&nsupseteq;"), u"\x2289"},
                                                                               {Trait::latin1ToString("&nsupseteqq;"), u"\x2AC6\x0338"},
                                                                               {Trait::latin1ToString("&ntgl;"), u"\x2279"},
                                                                               {Trait::latin1ToString("&ntilde"), u"\x00F1"},
                                                                               {Trait::latin1ToString("&ntilde;"), u"\x00F1"},
                                                                               {Trait::latin1ToString("&ntlg;"), u"\x2278"},
                                                                               {Trait::latin1ToString("&ntriangleleft;"), u"\x22EA"},
                                                                               {Trait::latin1ToString("&ntrianglelefteq;"), u"\x22EC"},
                                                                               {Trait::latin1ToString("&ntriangleright;"), u"\x22EB"},
                                                                               {Trait::latin1ToString("&ntrianglerighteq;"), u"\x22ED"},
                                                                               {Trait::latin1ToString("&nu;"), u"\x03BD"},
                                                                               {Trait::latin1ToString("&num;"), u"\x0023"},
                                                                               {Trait::latin1ToString("&numero;"), u"\x2116"},
                                                                               {Trait::latin1ToString("&numsp;"), u"\x2007"},
                                                                               {Trait::latin1ToString("&nvDash;"), u"\x22AD"},
                                                                               {Trait::latin1ToString("&nvHarr;"), u"\x2904"},
                                                                               {Trait::latin1ToString("&nvap;"), u"\x224D\x20D2"},
                                                                               {Trait::latin1ToString("&nvdash;"), u"\x22AC"},
                                                                               {Trait::latin1ToString("&nvge;"), u"\x2265\x20D2"},
                                                                               {Trait::latin1ToString("&nvgt;"), u"\x003E\x20D2"},
                                                                               {Trait::latin1ToString("&nvinfin;"), u"\x29DE"},
                                                                               {Trait::latin1ToString("&nvlArr;"), u"\x2902"},
                                                                               {Trait::latin1ToString("&nvle;"), u"\x2264\x20D2"},
                                                                               {Trait::latin1ToString("&nvlt;"), u"\x003C\x20D2"},
                                                                               {Trait::latin1ToString("&nvltrie;"), u"\x22B4\x20D2"},
                                                                               {Trait::latin1ToString("&nvrArr;"), u"\x2903"},
                                                                               {Trait::latin1ToString("&nvrtrie;"), u"\x22B5\x20D2"},
                                                                               {Trait::latin1ToString("&nvsim;"), u"\x223C\x20D2"},
                                                                               {Trait::latin1ToString("&nwArr;"), u"\x21D6"},
                                                                               {Trait::latin1ToString("&nwarhk;"), u"\x2923"},
                                                                               {Trait::latin1ToString("&nwarr;"), u"\x2196"},
                                                                               {Trait::latin1ToString("&nwarrow;"), u"\x2196"},
                                                                               {Trait::latin1ToString("&nwnear;"), u"\x2927"},
                                                                               {Trait::latin1ToString("&oS;"), u"\x24C8"},
                                                                               {Trait::latin1ToString("&oacute"), u"\x00F3"},
                                                                               {Trait::latin1ToString("&oacute;"), u"\x00F3"},
                                                                               {Trait::latin1ToString("&oast;"), u"\x229B"},
                                                                               {Trait::latin1ToString("&ocir;"), u"\x229A"},
                                                                               {Trait::latin1ToString("&ocirc"), u"\x00F4"},
                                                                               {Trait::latin1ToString("&ocirc;"), u"\x00F4"},
                                                                               {Trait::latin1ToString("&ocy;"), u"\x043E"},
                                                                               {Trait::latin1ToString("&odash;"), u"\x229D"},
                                                                               {Trait::latin1ToString("&odblac;"), u"\x0151"},
                                                                               {Trait::latin1ToString("&odiv;"), u"\x2A38"},
                                                                               {Trait::latin1ToString("&odot;"), u"\x2299"},
                                                                               {Trait::latin1ToString("&odsold;"), u"\x29BC"},
                                                                               {Trait::latin1ToString("&oelig;"), u"\x0153"},
                                                                               {Trait::latin1ToString("&ofcir;"), u"\x29BF"},
                                                                               {Trait::latin1ToString("&ofr;"), u"\xD835\xDD2C"},
                                                                               {Trait::latin1ToString("&ogon;"), u"\x02DB"},
                                                                               {Trait::latin1ToString("&ograve"), u"\x00F2"},
                                                                               {Trait::latin1ToString("&ograve;"), u"\x00F2"},
                                                                               {Trait::latin1ToString("&ogt;"), u"\x29C1"},
                                                                               {Trait::latin1ToString("&ohbar;"), u"\x29B5"},
                                                                               {Trait::latin1ToString("&ohm;"), u"\x03A9"},
                                                                               {Trait::latin1ToString("&oint;"), u"\x222E"},
                                                                               {Trait::latin1ToString("&olarr;"), u"\x21BA"},
                                                                               {Trait::latin1ToString("&olcir;"), u"\x29BE"},
                                                                               {Trait::latin1ToString("&olcross;"), u"\x29BB"},
                                                                               {Trait::latin1ToString("&oline;"), u"\x203E"},
                                                                               {Trait::latin1ToString("&olt;"), u"\x29C0"},
                                                                               {Trait::latin1ToString("&omacr;"), u"\x014D"},
                                                                               {Trait::latin1ToString("&omega;"), u"\x03C9"},
                                                                               {Trait::latin1ToString("&omicron;"), u"\x03BF"},
                                                                               {Trait::latin1ToString("&omid;"), u"\x29B6"},
                                                                               {Trait::latin1ToString("&ominus;"), u"\x2296"},
                                                                               {Trait::latin1ToString("&oopf;"), u"\xD835\xDD60"},
                                                                               {Trait::latin1ToString("&opar;"), u"\x29B7"},
                                                                               {Trait::latin1ToString("&operp;"), u"\x29B9"},
                                                                               {Trait::latin1ToString("&oplus;"), u"\x2295"},
                                                                               {Trait::latin1ToString("&or;"), u"\x2228"},
                                                                               {Trait::latin1ToString("&orarr;"), u"\x21BB"},
                                                                               {Trait::latin1ToString("&ord;"), u"\x2A5D"},
                                                                               {Trait::latin1ToString("&order;"), u"\x2134"},
                                                                               {Trait::latin1ToString("&orderof;"), u"\x2134"},
                                                                               {Trait::latin1ToString("&ordf"), u"\x00AA"},
                                                                               {Trait::latin1ToString("&ordf;"), u"\x00AA"},
                                                                               {Trait::latin1ToString("&ordm"), u"\x00BA"},
                                                                               {Trait::latin1ToString("&ordm;"), u"\x00BA"},
                                                                               {Trait::latin1ToString("&origof;"), u"\x22B6"},
                                                                               {Trait::latin1ToString("&oror;"), u"\x2A56"},
                                                                               {Trait::latin1ToString("&orslope;"), u"\x2A57"},
                                                                               {Trait::latin1ToString("&orv;"), u"\x2A5B"},
                                                                               {Trait::latin1ToString("&oscr;"), u"\x2134"},
                                                                               {Trait::latin1ToString("&oslash"), u"\x00F8"},
                                                                               {Trait::latin1ToString("&oslash;"), u"\x00F8"},
                                                                               {Trait::latin1ToString("&osol;"), u"\x2298"},
                                                                               {Trait::latin1ToString("&otilde"), u"\x00F5"},
                                                                               {Trait::latin1ToString("&otilde;"), u"\x00F5"},
                                                                               {Trait::latin1ToString("&otimes;"), u"\x2297"},
                                                                               {Trait::latin1ToString("&otimesas;"), u"\x2A36"},
                                                                               {Trait::latin1ToString("&ouml"), u"\x00F6"},
                                                                               {Trait::latin1ToString("&ouml;"), u"\x00F6"},
                                                                               {Trait::latin1ToString("&ovbar;"), u"\x233D"},
                                                                               {Trait::latin1ToString("&par;"), u"\x2225"},
                                                                               {Trait::latin1ToString("&para"), u"\x00B6"},
                                                                               {Trait::latin1ToString("&para;"), u"\x00B6"},
                                                                               {Trait::latin1ToString("&parallel;"), u"\x2225"},
                                                                               {Trait::latin1ToString("&parsim;"), u"\x2AF3"},
                                                                               {Trait::latin1ToString("&parsl;"), u"\x2AFD"},
                                                                               {Trait::latin1ToString("&part;"), u"\x2202"},
                                                                               {Trait::latin1ToString("&pcy;"), u"\x043F"},
                                                                               {Trait::latin1ToString("&percnt;"), u"\x0025"},
                                                                               {Trait::latin1ToString("&period;"), u"\x002E"},
                                                                               {Trait::latin1ToString("&permil;"), u"\x2030"},
                                                                               {Trait::latin1ToString("&perp;"), u"\x22A5"},
                                                                               {Trait::latin1ToString("&pertenk;"), u"\x2031"},
                                                                               {Trait::latin1ToString("&pfr;"), u"\xD835\xDD2D"},
                                                                               {Trait::latin1ToString("&phi;"), u"\x03C6"},
                                                                               {Trait::latin1ToString("&phiv;"), u"\x03D5"},
                                                                               {Trait::latin1ToString("&phmmat;"), u"\x2133"},
                                                                               {Trait::latin1ToString("&phone;"), u"\x260E"},
                                                                               {Trait::latin1ToString("&pi;"), u"\x03C0"},
                                                                               {Trait::latin1ToString("&pitchfork;"), u"\x22D4"},
                                                                               {Trait::latin1ToString("&piv;"), u"\x03D6"},
                                                                               {Trait::latin1ToString("&planck;"), u"\x210F"},
                                                                               {Trait::latin1ToString("&planckh;"), u"\x210E"},
                                                                               {Trait::latin1ToString("&plankv;"), u"\x210F"},
                                                                               {Trait::latin1ToString("&plus;"), u"\x002B"},
                                                                               {Trait::latin1ToString("&plusacir;"), u"\x2A23"},
                                                                               {Trait::latin1ToString("&plusb;"), u"\x229E"},
                                                                               {Trait::latin1ToString("&pluscir;"), u"\x2A22"},
                                                                               {Trait::latin1ToString("&plusdo;"), u"\x2214"},
                                                                               {Trait::latin1ToString("&plusdu;"), u"\x2A25"},
                                                                               {Trait::latin1ToString("&pluse;"), u"\x2A72"},
                                                                               {Trait::latin1ToString("&plusmn"), u"\x00B1"},
                                                                               {Trait::latin1ToString("&plusmn;"), u"\x00B1"},
                                                                               {Trait::latin1ToString("&plussim;"), u"\x2A26"},
                                                                               {Trait::latin1ToString("&plustwo;"), u"\x2A27"},
                                                                               {Trait::latin1ToString("&pm;"), u"\x00B1"},
                                                                               {Trait::latin1ToString("&pointint;"), u"\x2A15"},
                                                                               {Trait::latin1ToString("&popf;"), u"\xD835\xDD61"},
                                                                               {Trait::latin1ToString("&pound"), u"\x00A3"},
                                                                               {Trait::latin1ToString("&pound;"), u"\x00A3"},
                                                                               {Trait::latin1ToString("&pr;"), u"\x227A"},
                                                                               {Trait::latin1ToString("&prE;"), u"\x2AB3"},
                                                                               {Trait::latin1ToString("&prap;"), u"\x2AB7"},
                                                                               {Trait::latin1ToString("&prcue;"), u"\x227C"},
                                                                               {Trait::latin1ToString("&pre;"), u"\x2AAF"},
                                                                               {Trait::latin1ToString("&prec;"), u"\x227A"},
                                                                               {Trait::latin1ToString("&precapprox;"), u"\x2AB7"},
                                                                               {Trait::latin1ToString("&preccurlyeq;"), u"\x227C"},
                                                                               {Trait::latin1ToString("&preceq;"), u"\x2AAF"},
                                                                               {Trait::latin1ToString("&precnapprox;"), u"\x2AB9"},
                                                                               {Trait::latin1ToString("&precneqq;"), u"\x2AB5"},
                                                                               {Trait::latin1ToString("&precnsim;"), u"\x22E8"},
                                                                               {Trait::latin1ToString("&precsim;"), u"\x227E"},
                                                                               {Trait::latin1ToString("&prime;"), u"\x2032"},
                                                                               {Trait::latin1ToString("&primes;"), u"\x2119"},
                                                                               {Trait::latin1ToString("&prnE;"), u"\x2AB5"},
                                                                               {Trait::latin1ToString("&prnap;"), u"\x2AB9"},
                                                                               {Trait::latin1ToString("&prnsim;"), u"\x22E8"},
                                                                               {Trait::latin1ToString("&prod;"), u"\x220F"},
                                                                               {Trait::latin1ToString("&profalar;"), u"\x232E"},
                                                                               {Trait::latin1ToString("&profline;"), u"\x2312"},
                                                                               {Trait::latin1ToString("&profsurf;"), u"\x2313"},
                                                                               {Trait::latin1ToString("&prop;"), u"\x221D"},
                                                                               {Trait::latin1ToString("&propto;"), u"\x221D"},
                                                                               {Trait::latin1ToString("&prsim;"), u"\x227E"},
                                                                               {Trait::latin1ToString("&prurel;"), u"\x22B0"},
                                                                               {Trait::latin1ToString("&pscr;"), u"\xD835\xDCC5"},
                                                                               {Trait::latin1ToString("&psi;"), u"\x03C8"},
                                                                               {Trait::latin1ToString("&puncsp;"), u"\x2008"},
                                                                               {Trait::latin1ToString("&qfr;"), u"\xD835\xDD2E"},
                                                                               {Trait::latin1ToString("&qint;"), u"\x2A0C"},
                                                                               {Trait::latin1ToString("&qopf;"), u"\xD835\xDD62"},
                                                                               {Trait::latin1ToString("&qprime;"), u"\x2057"},
                                                                               {Trait::latin1ToString("&qscr;"), u"\xD835\xDCC6"},
                                                                               {Trait::latin1ToString("&quaternions;"), u"\x210D"},
                                                                               {Trait::latin1ToString("&quatint;"), u"\x2A16"},
                                                                               {Trait::latin1ToString("&quest;"), u"\x003F"},
                                                                               {Trait::latin1ToString("&questeq;"), u"\x225F"},
                                                                               {Trait::latin1ToString("&quot"), u"\x0022"},
                                                                               {Trait::latin1ToString("&quot;"), u"\x0022"},
                                                                               {Trait::latin1ToString("&rAarr;"), u"\x21DB"},
                                                                               {Trait::latin1ToString("&rArr;"), u"\x21D2"},
                                                                               {Trait::latin1ToString("&rAtail;"), u"\x291C"},
                                                                               {Trait::latin1ToString("&rBarr;"), u"\x290F"},
                                                                               {Trait::latin1ToString("&rHar;"), u"\x2964"},
                                                                               {Trait::latin1ToString("&race;"), u"\x223D\x0331"},
                                                                               {Trait::latin1ToString("&racute;"), u"\x0155"},
                                                                               {Trait::latin1ToString("&radic;"), u"\x221A"},
                                                                               {Trait::latin1ToString("&raemptyv;"), u"\x29B3"},
                                                                               {Trait::latin1ToString("&rang;"), u"\x27E9"},
                                                                               {Trait::latin1ToString("&rangd;"), u"\x2992"},
                                                                               {Trait::latin1ToString("&range;"), u"\x29A5"},
                                                                               {Trait::latin1ToString("&rangle;"), u"\x27E9"},
                                                                               {Trait::latin1ToString("&raquo"), u"\x00BB"},
                                                                               {Trait::latin1ToString("&raquo;"), u"\x00BB"},
                                                                               {Trait::latin1ToString("&rarr;"), u"\x2192"},
                                                                               {Trait::latin1ToString("&rarrap;"), u"\x2975"},
                                                                               {Trait::latin1ToString("&rarrb;"), u"\x21E5"},
                                                                               {Trait::latin1ToString("&rarrbfs;"), u"\x2920"},
                                                                               {Trait::latin1ToString("&rarrc;"), u"\x2933"},
                                                                               {Trait::latin1ToString("&rarrfs;"), u"\x291E"},
                                                                               {Trait::latin1ToString("&rarrhk;"), u"\x21AA"},
                                                                               {Trait::latin1ToString("&rarrlp;"), u"\x21AC"},
                                                                               {Trait::latin1ToString("&rarrpl;"), u"\x2945"},
                                                                               {Trait::latin1ToString("&rarrsim;"), u"\x2974"},
                                                                               {Trait::latin1ToString("&rarrtl;"), u"\x21A3"},
                                                                               {Trait::latin1ToString("&rarrw;"), u"\x219D"},
                                                                               {Trait::latin1ToString("&ratail;"), u"\x291A"},
                                                                               {Trait::latin1ToString("&ratio;"), u"\x2236"},
                                                                               {Trait::latin1ToString("&rationals;"), u"\x211A"},
                                                                               {Trait::latin1ToString("&rbarr;"), u"\x290D"},
                                                                               {Trait::latin1ToString("&rbbrk;"), u"\x2773"},
                                                                               {Trait::latin1ToString("&rbrace;"), u"\x007D"},
                                                                               {Trait::latin1ToString("&rbrack;"), u"\x005D"},
                                                                               {Trait::latin1ToString("&rbrke;"), u"\x298C"},
                                                                               {Trait::latin1ToString("&rbrksld;"), u"\x298E"},
                                                                               {Trait::latin1ToString("&rbrkslu;"), u"\x2990"},
                                                                               {Trait::latin1ToString("&rcaron;"), u"\x0159"},
                                                                               {Trait::latin1ToString("&rcedil;"), u"\x0157"},
                                                                               {Trait::latin1ToString("&rceil;"), u"\x2309"},
                                                                               {Trait::latin1ToString("&rcub;"), u"\x007D"},
                                                                               {Trait::latin1ToString("&rcy;"), u"\x0440"},
                                                                               {Trait::latin1ToString("&rdca;"), u"\x2937"},
                                                                               {Trait::latin1ToString("&rdldhar;"), u"\x2969"},
                                                                               {Trait::latin1ToString("&rdquo;"), u"\x201D"},
                                                                               {Trait::latin1ToString("&rdquor;"), u"\x201D"},
                                                                               {Trait::latin1ToString("&rdsh;"), u"\x21B3"},
                                                                               {Trait::latin1ToString("&real;"), u"\x211C"},
                                                                               {Trait::latin1ToString("&realine;"), u"\x211B"},
                                                                               {Trait::latin1ToString("&realpart;"), u"\x211C"},
                                                                               {Trait::latin1ToString("&reals;"), u"\x211D"},
                                                                               {Trait::latin1ToString("&rect;"), u"\x25AD"},
                                                                               {Trait::latin1ToString("&reg"), u"\x00AE"},
                                                                               {Trait::latin1ToString("&reg;"), u"\x00AE"},
                                                                               {Trait::latin1ToString("&rfisht;"), u"\x297D"},
                                                                               {Trait::latin1ToString("&rfloor;"), u"\x230B"},
                                                                               {Trait::latin1ToString("&rfr;"), u"\xD835\xDD2F"},
                                                                               {Trait::latin1ToString("&rhard;"), u"\x21C1"},
                                                                               {Trait::latin1ToString("&rharu;"), u"\x21C0"},
                                                                               {Trait::latin1ToString("&rharul;"), u"\x296C"},
                                                                               {Trait::latin1ToString("&rho;"), u"\x03C1"},
                                                                               {Trait::latin1ToString("&rhov;"), u"\x03F1"},
                                                                               {Trait::latin1ToString("&rightarrow;"), u"\x2192"},
                                                                               {Trait::latin1ToString("&rightarrowtail;"), u"\x21A3"},
                                                                               {Trait::latin1ToString("&rightharpoondown;"), u"\x21C1"},
                                                                               {Trait::latin1ToString("&rightharpoonup;"), u"\x21C0"},
                                                                               {Trait::latin1ToString("&rightleftarrows;"), u"\x21C4"},
                                                                               {Trait::latin1ToString("&rightleftharpoons;"), u"\x21CC"},
                                                                               {Trait::latin1ToString("&rightrightarrows;"), u"\x21C9"},
                                                                               {Trait::latin1ToString("&rightsquigarrow;"), u"\x219D"},
                                                                               {Trait::latin1ToString("&rightthreetimes;"), u"\x22CC"},
                                                                               {Trait::latin1ToString("&ring;"), u"\x02DA"},
                                                                               {Trait::latin1ToString("&risingdotseq;"), u"\x2253"},
                                                                               {Trait::latin1ToString("&rlarr;"), u"\x21C4"},
                                                                               {Trait::latin1ToString("&rlhar;"), u"\x21CC"},
                                                                               {Trait::latin1ToString("&rlm;"), u"\x200F"},
                                                                               {Trait::latin1ToString("&rmoust;"), u"\x23B1"},
                                                                               {Trait::latin1ToString("&rmoustache;"), u"\x23B1"},
                                                                               {Trait::latin1ToString("&rnmid;"), u"\x2AEE"},
                                                                               {Trait::latin1ToString("&roang;"), u"\x27ED"},
                                                                               {Trait::latin1ToString("&roarr;"), u"\x21FE"},
                                                                               {Trait::latin1ToString("&robrk;"), u"\x27E7"},
                                                                               {Trait::latin1ToString("&ropar;"), u"\x2986"},
                                                                               {Trait::latin1ToString("&ropf;"), u"\xD835\xDD63"},
                                                                               {Trait::latin1ToString("&roplus;"), u"\x2A2E"},
                                                                               {Trait::latin1ToString("&rotimes;"), u"\x2A35"},
                                                                               {Trait::latin1ToString("&rpar;"), u"\x0029"},
                                                                               {Trait::latin1ToString("&rpargt;"), u"\x2994"},
                                                                               {Trait::latin1ToString("&rppolint;"), u"\x2A12"},
                                                                               {Trait::latin1ToString("&rrarr;"), u"\x21C9"},
                                                                               {Trait::latin1ToString("&rsaquo;"), u"\x203A"},
                                                                               {Trait::latin1ToString("&rscr;"), u"\xD835\xDCC7"},
                                                                               {Trait::latin1ToString("&rsh;"), u"\x21B1"},
                                                                               {Trait::latin1ToString("&rsqb;"), u"\x005D"},
                                                                               {Trait::latin1ToString("&rsquo;"), u"\x2019"},
                                                                               {Trait::latin1ToString("&rsquor;"), u"\x2019"},
                                                                               {Trait::latin1ToString("&rthree;"), u"\x22CC"},
                                                                               {Trait::latin1ToString("&rtimes;"), u"\x22CA"},
                                                                               {Trait::latin1ToString("&rtri;"), u"\x25B9"},
                                                                               {Trait::latin1ToString("&rtrie;"), u"\x22B5"},
                                                                               {Trait::latin1ToString("&rtrif;"), u"\x25B8"},
                                                                               {Trait::latin1ToString("&rtriltri;"), u"\x29CE"},
                                                                               {Trait::latin1ToString("&ruluhar;"), u"\x2968"},
                                                                               {Trait::latin1ToString("&rx;"), u"\x211E"},
                                                                               {Trait::latin1ToString("&sacute;"), u"\x015B"},
                                                                               {Trait::latin1ToString("&sbquo;"), u"\x201A"},
                                                                               {Trait::latin1ToString("&sc;"), u"\x227B"},
                                                                               {Trait::latin1ToString("&scE;"), u"\x2AB4"},
                                                                               {Trait::latin1ToString("&scap;"), u"\x2AB8"},
                                                                               {Trait::latin1ToString("&scaron;"), u"\x0161"},
                                                                               {Trait::latin1ToString("&sccue;"), u"\x227D"},
                                                                               {Trait::latin1ToString("&sce;"), u"\x2AB0"},
                                                                               {Trait::latin1ToString("&scedil;"), u"\x015F"},
                                                                               {Trait::latin1ToString("&scirc;"), u"\x015D"},
                                                                               {Trait::latin1ToString("&scnE;"), u"\x2AB6"},
                                                                               {Trait::latin1ToString("&scnap;"), u"\x2ABA"},
                                                                               {Trait::latin1ToString("&scnsim;"), u"\x22E9"},
                                                                               {Trait::latin1ToString("&scpolint;"), u"\x2A13"},
                                                                               {Trait::latin1ToString("&scsim;"), u"\x227F"},
                                                                               {Trait::latin1ToString("&scy;"), u"\x0441"},
                                                                               {Trait::latin1ToString("&sdot;"), u"\x22C5"},
                                                                               {Trait::latin1ToString("&sdotb;"), u"\x22A1"},
                                                                               {Trait::latin1ToString("&sdote;"), u"\x2A66"},
                                                                               {Trait::latin1ToString("&seArr;"), u"\x21D8"},
                                                                               {Trait::latin1ToString("&searhk;"), u"\x2925"},
                                                                               {Trait::latin1ToString("&searr;"), u"\x2198"},
                                                                               {Trait::latin1ToString("&searrow;"), u"\x2198"},
                                                                               {Trait::latin1ToString("&sect"), u"\x00A7"},
                                                                               {Trait::latin1ToString("&sect;"), u"\x00A7"},
                                                                               {Trait::latin1ToString("&semi;"), u"\x003B"},
                                                                               {Trait::latin1ToString("&seswar;"), u"\x2929"},
                                                                               {Trait::latin1ToString("&setminus;"), u"\x2216"},
                                                                               {Trait::latin1ToString("&setmn;"), u"\x2216"},
                                                                               {Trait::latin1ToString("&sext;"), u"\x2736"},
                                                                               {Trait::latin1ToString("&sfr;"), u"\xD835\xDD30"},
                                                                               {Trait::latin1ToString("&sfrown;"), u"\x2322"},
                                                                               {Trait::latin1ToString("&sharp;"), u"\x266F"},
                                                                               {Trait::latin1ToString("&shchcy;"), u"\x0449"},
                                                                               {Trait::latin1ToString("&shcy;"), u"\x0448"},
                                                                               {Trait::latin1ToString("&shortmid;"), u"\x2223"},
                                                                               {Trait::latin1ToString("&shortparallel;"), u"\x2225"},
                                                                               {Trait::latin1ToString("&shy"), u"\x00AD"},
                                                                               {Trait::latin1ToString("&shy;"), u"\x00AD"},
                                                                               {Trait::latin1ToString("&sigma;"), u"\x03C3"},
                                                                               {Trait::latin1ToString("&sigmaf;"), u"\x03C2"},
                                                                               {Trait::latin1ToString("&sigmav;"), u"\x03C2"},
                                                                               {Trait::latin1ToString("&sim;"), u"\x223C"},
                                                                               {Trait::latin1ToString("&simdot;"), u"\x2A6A"},
                                                                               {Trait::latin1ToString("&sime;"), u"\x2243"},
                                                                               {Trait::latin1ToString("&simeq;"), u"\x2243"},
                                                                               {Trait::latin1ToString("&simg;"), u"\x2A9E"},
                                                                               {Trait::latin1ToString("&simgE;"), u"\x2AA0"},
                                                                               {Trait::latin1ToString("&siml;"), u"\x2A9D"},
                                                                               {Trait::latin1ToString("&simlE;"), u"\x2A9F"},
                                                                               {Trait::latin1ToString("&simne;"), u"\x2246"},
                                                                               {Trait::latin1ToString("&simplus;"), u"\x2A24"},
                                                                               {Trait::latin1ToString("&simrarr;"), u"\x2972"},
                                                                               {Trait::latin1ToString("&slarr;"), u"\x2190"},
                                                                               {Trait::latin1ToString("&smallsetminus;"), u"\x2216"},
                                                                               {Trait::latin1ToString("&smashp;"), u"\x2A33"},
                                                                               {Trait::latin1ToString("&smeparsl;"), u"\x29E4"},
                                                                               {Trait::latin1ToString("&smid;"), u"\x2223"},
                                                                               {Trait::latin1ToString("&smile;"), u"\x2323"},
                                                                               {Trait::latin1ToString("&smt;"), u"\x2AAA"},
                                                                               {Trait::latin1ToString("&smte;"), u"\x2AAC"},
                                                                               {Trait::latin1ToString("&smtes;"), u"\x2AAC\xFE00"},
                                                                               {Trait::latin1ToString("&softcy;"), u"\x044C"},
                                                                               {Trait::latin1ToString("&sol;"), u"\x002F"},
                                                                               {Trait::latin1ToString("&solb;"), u"\x29C4"},
                                                                               {Trait::latin1ToString("&solbar;"), u"\x233F"},
                                                                               {Trait::latin1ToString("&sopf;"), u"\xD835\xDD64"},
                                                                               {Trait::latin1ToString("&spades;"), u"\x2660"},
                                                                               {Trait::latin1ToString("&spadesuit;"), u"\x2660"},
                                                                               {Trait::latin1ToString("&spar;"), u"\x2225"},
                                                                               {Trait::latin1ToString("&sqcap;"), u"\x2293"},
                                                                               {Trait::latin1ToString("&sqcaps;"), u"\x2293\xFE00"},
                                                                               {Trait::latin1ToString("&sqcup;"), u"\x2294"},
                                                                               {Trait::latin1ToString("&sqcups;"), u"\x2294\xFE00"},
                                                                               {Trait::latin1ToString("&sqsub;"), u"\x228F"},
                                                                               {Trait::latin1ToString("&sqsube;"), u"\x2291"},
                                                                               {Trait::latin1ToString("&sqsubset;"), u"\x228F"},
                                                                               {Trait::latin1ToString("&sqsubseteq;"), u"\x2291"},
                                                                               {Trait::latin1ToString("&sqsup;"), u"\x2290"},
                                                                               {Trait::latin1ToString("&sqsupe;"), u"\x2292"},
                                                                               {Trait::latin1ToString("&sqsupset;"), u"\x2290"},
                                                                               {Trait::latin1ToString("&sqsupseteq;"), u"\x2292"},
                                                                               {Trait::latin1ToString("&squ;"), u"\x25A1"},
                                                                               {Trait::latin1ToString("&square;"), u"\x25A1"},
                                                                               {Trait::latin1ToString("&squarf;"), u"\x25AA"},
                                                                               {Trait::latin1ToString("&squf;"), u"\x25AA"},
                                                                               {Trait::latin1ToString("&srarr;"), u"\x2192"},
                                                                               {Trait::latin1ToString("&sscr;"), u"\xD835\xDCC8"},
                                                                               {Trait::latin1ToString("&ssetmn;"), u"\x2216"},
                                                                               {Trait::latin1ToString("&ssmile;"), u"\x2323"},
                                                                               {Trait::latin1ToString("&sstarf;"), u"\x22C6"},
                                                                               {Trait::latin1ToString("&star;"), u"\x2606"},
                                                                               {Trait::latin1ToString("&starf;"), u"\x2605"},
                                                                               {Trait::latin1ToString("&straightepsilon;"), u"\x03F5"},
                                                                               {Trait::latin1ToString("&straightphi;"), u"\x03D5"},
                                                                               {Trait::latin1ToString("&strns;"), u"\x00AF"},
                                                                               {Trait::latin1ToString("&sub;"), u"\x2282"},
                                                                               {Trait::latin1ToString("&subE;"), u"\x2AC5"},
                                                                               {Trait::latin1ToString("&subdot;"), u"\x2ABD"},
                                                                               {Trait::latin1ToString("&sube;"), u"\x2286"},
                                                                               {Trait::latin1ToString("&subedot;"), u"\x2AC3"},
                                                                               {Trait::latin1ToString("&submult;"), u"\x2AC1"},
                                                                               {Trait::latin1ToString("&subnE;"), u"\x2ACB"},
                                                                               {Trait::latin1ToString("&subne;"), u"\x228A"},
                                                                               {Trait::latin1ToString("&subplus;"), u"\x2ABF"},
                                                                               {Trait::latin1ToString("&subrarr;"), u"\x2979"},
                                                                               {Trait::latin1ToString("&subset;"), u"\x2282"},
                                                                               {Trait::latin1ToString("&subseteq;"), u"\x2286"},
                                                                               {Trait::latin1ToString("&subseteqq;"), u"\x2AC5"},
                                                                               {Trait::latin1ToString("&subsetneq;"), u"\x228A"},
                                                                               {Trait::latin1ToString("&subsetneqq;"), u"\x2ACB"},
                                                                               {Trait::latin1ToString("&subsim;"), u"\x2AC7"},
                                                                               {Trait::latin1ToString("&subsub;"), u"\x2AD5"},
                                                                               {Trait::latin1ToString("&subsup;"), u"\x2AD3"},
                                                                               {Trait::latin1ToString("&succ;"), u"\x227B"},
                                                                               {Trait::latin1ToString("&succapprox;"), u"\x2AB8"},
                                                                               {Trait::latin1ToString("&succcurlyeq;"), u"\x227D"},
                                                                               {Trait::latin1ToString("&succeq;"), u"\x2AB0"},
                                                                               {Trait::latin1ToString("&succnapprox;"), u"\x2ABA"},
                                                                               {Trait::latin1ToString("&succneqq;"), u"\x2AB6"},
                                                                               {Trait::latin1ToString("&succnsim;"), u"\x22E9"},
                                                                               {Trait::latin1ToString("&succsim;"), u"\x227F"},
                                                                               {Trait::latin1ToString("&sum;"), u"\x2211"},
                                                                               {Trait::latin1ToString("&sung;"), u"\x266A"},
                                                                               {Trait::latin1ToString("&sup1"), u"\x00B9"},
                                                                               {Trait::latin1ToString("&sup1;"), u"\x00B9"},
                                                                               {Trait::latin1ToString("&sup2"), u"\x00B2"},
                                                                               {Trait::latin1ToString("&sup2;"), u"\x00B2"},
                                                                               {Trait::latin1ToString("&sup3"), u"\x00B3"},
                                                                               {Trait::latin1ToString("&sup3;"), u"\x00B3"},
                                                                               {Trait::latin1ToString("&sup;"), u"\x2283"},
                                                                               {Trait::latin1ToString("&supE;"), u"\x2AC6"},
                                                                               {Trait::latin1ToString("&supdot;"), u"\x2ABE"},
                                                                               {Trait::latin1ToString("&supdsub;"), u"\x2AD8"},
                                                                               {Trait::latin1ToString("&supe;"), u"\x2287"},
                                                                               {Trait::latin1ToString("&supedot;"), u"\x2AC4"},
                                                                               {Trait::latin1ToString("&suphsol;"), u"\x27C9"},
                                                                               {Trait::latin1ToString("&suphsub;"), u"\x2AD7"},
                                                                               {Trait::latin1ToString("&suplarr;"), u"\x297B"},
                                                                               {Trait::latin1ToString("&supmult;"), u"\x2AC2"},
                                                                               {Trait::latin1ToString("&supnE;"), u"\x2ACC"},
                                                                               {Trait::latin1ToString("&supne;"), u"\x228B"},
                                                                               {Trait::latin1ToString("&supplus;"), u"\x2AC0"},
                                                                               {Trait::latin1ToString("&supset;"), u"\x2283"},
                                                                               {Trait::latin1ToString("&supseteq;"), u"\x2287"},
                                                                               {Trait::latin1ToString("&supseteqq;"), u"\x2AC6"},
                                                                               {Trait::latin1ToString("&supsetneq;"), u"\x228B"},
                                                                               {Trait::latin1ToString("&supsetneqq;"), u"\x2ACC"},
                                                                               {Trait::latin1ToString("&supsim;"), u"\x2AC8"},
                                                                               {Trait::latin1ToString("&supsub;"), u"\x2AD4"},
                                                                               {Trait::latin1ToString("&supsup;"), u"\x2AD6"},
                                                                               {Trait::latin1ToString("&swArr;"), u"\x21D9"},
                                                                               {Trait::latin1ToString("&swarhk;"), u"\x2926"},
                                                                               {Trait::latin1ToString("&swarr;"), u"\x2199"},
                                                                               {Trait::latin1ToString("&swarrow;"), u"\x2199"},
                                                                               {Trait::latin1ToString("&swnwar;"), u"\x292A"},
                                                                               {Trait::latin1ToString("&szlig"), u"\x00DF"},
                                                                               {Trait::latin1ToString("&szlig;"), u"\x00DF"},
                                                                               {Trait::latin1ToString("&target;"), u"\x2316"},
                                                                               {Trait::latin1ToString("&tau;"), u"\x03C4"},
                                                                               {Trait::latin1ToString("&tbrk;"), u"\x23B4"},
                                                                               {Trait::latin1ToString("&tcaron;"), u"\x0165"},
                                                                               {Trait::latin1ToString("&tcedil;"), u"\x0163"},
                                                                               {Trait::latin1ToString("&tcy;"), u"\x0442"},
                                                                               {Trait::latin1ToString("&tdot;"), u"\x20DB"},
                                                                               {Trait::latin1ToString("&telrec;"), u"\x2315"},
                                                                               {Trait::latin1ToString("&tfr;"), u"\xD835\xDD31"},
                                                                               {Trait::latin1ToString("&there4;"), u"\x2234"},
                                                                               {Trait::latin1ToString("&therefore;"), u"\x2234"},
                                                                               {Trait::latin1ToString("&theta;"), u"\x03B8"},
                                                                               {Trait::latin1ToString("&thetasym;"), u"\x03D1"},
                                                                               {Trait::latin1ToString("&thetav;"), u"\x03D1"},
                                                                               {Trait::latin1ToString("&thickapprox;"), u"\x2248"},
                                                                               {Trait::latin1ToString("&thicksim;"), u"\x223C"},
                                                                               {Trait::latin1ToString("&thinsp;"), u"\x2009"},
                                                                               {Trait::latin1ToString("&thkap;"), u"\x2248"},
                                                                               {Trait::latin1ToString("&thksim;"), u"\x223C"},
                                                                               {Trait::latin1ToString("&thorn"), u"\x00FE"},
                                                                               {Trait::latin1ToString("&thorn;"), u"\x00FE"},
                                                                               {Trait::latin1ToString("&tilde;"), u"\x02DC"},
                                                                               {Trait::latin1ToString("&times"), u"\x00D7"},
                                                                               {Trait::latin1ToString("&times;"), u"\x00D7"},
                                                                               {Trait::latin1ToString("&timesb;"), u"\x22A0"},
                                                                               {Trait::latin1ToString("&timesbar;"), u"\x2A31"},
                                                                               {Trait::latin1ToString("&timesd;"), u"\x2A30"},
                                                                               {Trait::latin1ToString("&tint;"), u"\x222D"},
                                                                               {Trait::latin1ToString("&toea;"), u"\x2928"},
                                                                               {Trait::latin1ToString("&top;"), u"\x22A4"},
                                                                               {Trait::latin1ToString("&topbot;"), u"\x2336"},
                                                                               {Trait::latin1ToString("&topcir;"), u"\x2AF1"},
                                                                               {Trait::latin1ToString("&topf;"), u"\xD835\xDD65"},
                                                                               {Trait::latin1ToString("&topfork;"), u"\x2ADA"},
                                                                               {Trait::latin1ToString("&tosa;"), u"\x2929"},
                                                                               {Trait::latin1ToString("&tprime;"), u"\x2034"},
                                                                               {Trait::latin1ToString("&trade;"), u"\x2122"},
                                                                               {Trait::latin1ToString("&triangle;"), u"\x25B5"},
                                                                               {Trait::latin1ToString("&triangledown;"), u"\x25BF"},
                                                                               {Trait::latin1ToString("&triangleleft;"), u"\x25C3"},
                                                                               {Trait::latin1ToString("&trianglelefteq;"), u"\x22B4"},
                                                                               {Trait::latin1ToString("&triangleq;"), u"\x225C"},
                                                                               {Trait::latin1ToString("&triangleright;"), u"\x25B9"},
                                                                               {Trait::latin1ToString("&trianglerighteq;"), u"\x22B5"},
                                                                               {Trait::latin1ToString("&tridot;"), u"\x25EC"},
                                                                               {Trait::latin1ToString("&trie;"), u"\x225C"},
                                                                               {Trait::latin1ToString("&triminus;"), u"\x2A3A"},
                                                                               {Trait::latin1ToString("&triplus;"), u"\x2A39"},
                                                                               {Trait::latin1ToString("&trisb;"), u"\x29CD"},
                                                                               {Trait::latin1ToString("&tritime;"), u"\x2A3B"},
                                                                               {Trait::latin1ToString("&trpezium;"), u"\x23E2"},
                                                                               {Trait::latin1ToString("&tscr;"), u"\xD835\xDCC9"},
                                                                               {Trait::latin1ToString("&tscy;"), u"\x0446"},
                                                                               {Trait::latin1ToString("&tshcy;"), u"\x045B"},
                                                                               {Trait::latin1ToString("&tstrok;"), u"\x0167"},
                                                                               {Trait::latin1ToString("&twixt;"), u"\x226C"},
                                                                               {Trait::latin1ToString("&twoheadleftarrow;"), u"\x219E"},
                                                                               {Trait::latin1ToString("&twoheadrightarrow;"), u"\x21A0"},
                                                                               {Trait::latin1ToString("&uArr;"), u"\x21D1"},
                                                                               {Trait::latin1ToString("&uHar;"), u"\x2963"},
                                                                               {Trait::latin1ToString("&uacute"), u"\x00FA"},
                                                                               {Trait::latin1ToString("&uacute;"), u"\x00FA"},
                                                                               {Trait::latin1ToString("&uarr;"), u"\x2191"},
                                                                               {Trait::latin1ToString("&ubrcy;"), u"\x045E"},
                                                                               {Trait::latin1ToString("&ubreve;"), u"\x016D"},
                                                                               {Trait::latin1ToString("&ucirc"), u"\x00FB"},
                                                                               {Trait::latin1ToString("&ucirc;"), u"\x00FB"},
                                                                               {Trait::latin1ToString("&ucy;"), u"\x0443"},
                                                                               {Trait::latin1ToString("&udarr;"), u"\x21C5"},
                                                                               {Trait::latin1ToString("&udblac;"), u"\x0171"},
                                                                               {Trait::latin1ToString("&udhar;"), u"\x296E"},
                                                                               {Trait::latin1ToString("&ufisht;"), u"\x297E"},
                                                                               {Trait::latin1ToString("&ufr;"), u"\xD835\xDD32"},
                                                                               {Trait::latin1ToString("&ugrave"), u"\x00F9"},
                                                                               {Trait::latin1ToString("&ugrave;"), u"\x00F9"},
                                                                               {Trait::latin1ToString("&uharl;"), u"\x21BF"},
                                                                               {Trait::latin1ToString("&uharr;"), u"\x21BE"},
                                                                               {Trait::latin1ToString("&uhblk;"), u"\x2580"},
                                                                               {Trait::latin1ToString("&ulcorn;"), u"\x231C"},
                                                                               {Trait::latin1ToString("&ulcorner;"), u"\x231C"},
                                                                               {Trait::latin1ToString("&ulcrop;"), u"\x230F"},
                                                                               {Trait::latin1ToString("&ultri;"), u"\x25F8"},
                                                                               {Trait::latin1ToString("&umacr;"), u"\x016B"},
                                                                               {Trait::latin1ToString("&uml"), u"\x00A8"},
                                                                               {Trait::latin1ToString("&uml;"), u"\x00A8"},
                                                                               {Trait::latin1ToString("&uogon;"), u"\x0173"},
                                                                               {Trait::latin1ToString("&uopf;"), u"\xD835\xDD66"},
                                                                               {Trait::latin1ToString("&uparrow;"), u"\x2191"},
                                                                               {Trait::latin1ToString("&updownarrow;"), u"\x2195"},
                                                                               {Trait::latin1ToString("&upharpoonleft;"), u"\x21BF"},
                                                                               {Trait::latin1ToString("&upharpoonright;"), u"\x21BE"},
                                                                               {Trait::latin1ToString("&uplus;"), u"\x228E"},
                                                                               {Trait::latin1ToString("&upsi;"), u"\x03C5"},
                                                                               {Trait::latin1ToString("&upsih;"), u"\x03D2"},
                                                                               {Trait::latin1ToString("&upsilon;"), u"\x03C5"},
                                                                               {Trait::latin1ToString("&upuparrows;"), u"\x21C8"},
                                                                               {Trait::latin1ToString("&urcorn;"), u"\x231D"},
                                                                               {Trait::latin1ToString("&urcorner;"), u"\x231D"},
                                                                               {Trait::latin1ToString("&urcrop;"), u"\x230E"},
                                                                               {Trait::latin1ToString("&uring;"), u"\x016F"},
                                                                               {Trait::latin1ToString("&urtri;"), u"\x25F9"},
                                                                               {Trait::latin1ToString("&uscr;"), u"\xD835\xDCCA"},
                                                                               {Trait::latin1ToString("&utdot;"), u"\x22F0"},
                                                                               {Trait::latin1ToString("&utilde;"), u"\x0169"},
                                                                               {Trait::latin1ToString("&utri;"), u"\x25B5"},
                                                                               {Trait::latin1ToString("&utrif;"), u"\x25B4"},
                                                                               {Trait::latin1ToString("&uuarr;"), u"\x21C8"},
                                                                               {Trait::latin1ToString("&uuml"), u"\x00FC"},
                                                                               {Trait::latin1ToString("&uuml;"), u"\x00FC"},
                                                                               {Trait::latin1ToString("&uwangle;"), u"\x29A7"},
                                                                               {Trait::latin1ToString("&vArr;"), u"\x21D5"},
                                                                               {Trait::latin1ToString("&vBar;"), u"\x2AE8"},
                                                                               {Trait::latin1ToString("&vBarv;"), u"\x2AE9"},
                                                                               {Trait::latin1ToString("&vDash;"), u"\x22A8"},
                                                                               {Trait::latin1ToString("&vangrt;"), u"\x299C"},
                                                                               {Trait::latin1ToString("&varepsilon;"), u"\x03F5"},
                                                                               {Trait::latin1ToString("&varkappa;"), u"\x03F0"},
                                                                               {Trait::latin1ToString("&varnothing;"), u"\x2205"},
                                                                               {Trait::latin1ToString("&varphi;"), u"\x03D5"},
                                                                               {Trait::latin1ToString("&varpi;"), u"\x03D6"},
                                                                               {Trait::latin1ToString("&varpropto;"), u"\x221D"},
                                                                               {Trait::latin1ToString("&varr;"), u"\x2195"},
                                                                               {Trait::latin1ToString("&varrho;"), u"\x03F1"},
                                                                               {Trait::latin1ToString("&varsigma;"), u"\x03C2"},
                                                                               {Trait::latin1ToString("&varsubsetneq;"), u"\x228A\xFE00"},
                                                                               {Trait::latin1ToString("&varsubsetneqq;"), u"\x2ACB\xFE00"},
                                                                               {Trait::latin1ToString("&varsupsetneq;"), u"\x228B\xFE00"},
                                                                               {Trait::latin1ToString("&varsupsetneqq;"), u"\x2ACC\xFE00"},
                                                                               {Trait::latin1ToString("&vartheta;"), u"\x03D1"},
                                                                               {Trait::latin1ToString("&vartriangleleft;"), u"\x22B2"},
                                                                               {Trait::latin1ToString("&vartriangleright;"), u"\x22B3"},
                                                                               {Trait::latin1ToString("&vcy;"), u"\x0432"},
                                                                               {Trait::latin1ToString("&vdash;"), u"\x22A2"},
                                                                               {Trait::latin1ToString("&vee;"), u"\x2228"},
                                                                               {Trait::latin1ToString("&veebar;"), u"\x22BB"},
                                                                               {Trait::latin1ToString("&veeeq;"), u"\x225A"},
                                                                               {Trait::latin1ToString("&vellip;"), u"\x22EE"},
                                                                               {Trait::latin1ToString("&verbar;"), u"\x007C"},
                                                                               {Trait::latin1ToString("&vert;"), u"\x007C"},
                                                                               {Trait::latin1ToString("&vfr;"), u"\xD835\xDD33"},
                                                                               {Trait::latin1ToString("&vltri;"), u"\x22B2"},
                                                                               {Trait::latin1ToString("&vnsub;"), u"\x2282\x20D2"},
                                                                               {Trait::latin1ToString("&vnsup;"), u"\x2283\x20D2"},
                                                                               {Trait::latin1ToString("&vopf;"), u"\xD835\xDD67"},
                                                                               {Trait::latin1ToString("&vprop;"), u"\x221D"},
                                                                               {Trait::latin1ToString("&vrtri;"), u"\x22B3"},
                                                                               {Trait::latin1ToString("&vscr;"), u"\xD835\xDCCB"},
                                                                               {Trait::latin1ToString("&vsubnE;"), u"\x2ACB\xFE00"},
                                                                               {Trait::latin1ToString("&vsubne;"), u"\x228A\xFE00"},
                                                                               {Trait::latin1ToString("&vsupnE;"), u"\x2ACC\xFE00"},
                                                                               {Trait::latin1ToString("&vsupne;"), u"\x228B\xFE00"},
                                                                               {Trait::latin1ToString("&vzigzag;"), u"\x299A"},
                                                                               {Trait::latin1ToString("&wcirc;"), u"\x0175"},
                                                                               {Trait::latin1ToString("&wedbar;"), u"\x2A5F"},
                                                                               {Trait::latin1ToString("&wedge;"), u"\x2227"},
                                                                               {Trait::latin1ToString("&wedgeq;"), u"\x2259"},
                                                                               {Trait::latin1ToString("&weierp;"), u"\x2118"},
                                                                               {Trait::latin1ToString("&wfr;"), u"\xD835\xDD34"},
                                                                               {Trait::latin1ToString("&wopf;"), u"\xD835\xDD68"},
                                                                               {Trait::latin1ToString("&wp;"), u"\x2118"},
                                                                               {Trait::latin1ToString("&wr;"), u"\x2240"},
                                                                               {Trait::latin1ToString("&wreath;"), u"\x2240"},
                                                                               {Trait::latin1ToString("&wscr;"), u"\xD835\xDCCC"},
                                                                               {Trait::latin1ToString("&xcap;"), u"\x22C2"},
                                                                               {Trait::latin1ToString("&xcirc;"), u"\x25EF"},
                                                                               {Trait::latin1ToString("&xcup;"), u"\x22C3"},
                                                                               {Trait::latin1ToString("&xdtri;"), u"\x25BD"},
                                                                               {Trait::latin1ToString("&xfr;"), u"\xD835\xDD35"},
                                                                               {Trait::latin1ToString("&xhArr;"), u"\x27FA"},
                                                                               {Trait::latin1ToString("&xharr;"), u"\x27F7"},
                                                                               {Trait::latin1ToString("&xi;"), u"\x03BE"},
                                                                               {Trait::latin1ToString("&xlArr;"), u"\x27F8"},
                                                                               {Trait::latin1ToString("&xlarr;"), u"\x27F5"},
                                                                               {Trait::latin1ToString("&xmap;"), u"\x27FC"},
                                                                               {Trait::latin1ToString("&xnis;"), u"\x22FB"},
                                                                               {Trait::latin1ToString("&xodot;"), u"\x2A00"},
                                                                               {Trait::latin1ToString("&xopf;"), u"\xD835\xDD69"},
                                                                               {Trait::latin1ToString("&xoplus;"), u"\x2A01"},
                                                                               {Trait::latin1ToString("&xotime;"), u"\x2A02"},
                                                                               {Trait::latin1ToString("&xrArr;"), u"\x27F9"},
                                                                               {Trait::latin1ToString("&xrarr;"), u"\x27F6"},
                                                                               {Trait::latin1ToString("&xscr;"), u"\xD835\xDCCD"},
                                                                               {Trait::latin1ToString("&xsqcup;"), u"\x2A06"},
                                                                               {Trait::latin1ToString("&xuplus;"), u"\x2A04"},
                                                                               {Trait::latin1ToString("&xutri;"), u"\x25B3"},
                                                                               {Trait::latin1ToString("&xvee;"), u"\x22C1"},
                                                                               {Trait::latin1ToString("&xwedge;"), u"\x22C0"},
                                                                               {Trait::latin1ToString("&yacute"), u"\x00FD"},
                                                                               {Trait::latin1ToString("&yacute;"), u"\x00FD"},
                                                                               {Trait::latin1ToString("&yacy;"), u"\x044F"},
                                                                               {Trait::latin1ToString("&ycirc;"), u"\x0177"},
                                                                               {Trait::latin1ToString("&ycy;"), u"\x044B"},
                                                                               {Trait::latin1ToString("&yen"), u"\x00A5"},
                                                                               {Trait::latin1ToString("&yen;"), u"\x00A5"},
                                                                               {Trait::latin1ToString("&yfr;"), u"\xD835\xDD36"},
                                                                               {Trait::latin1ToString("&yicy;"), u"\x0457"},
                                                                               {Trait::latin1ToString("&yopf;"), u"\xD835\xDD6A"},
                                                                               {Trait::latin1ToString("&yscr;"), u"\xD835\xDCCE"},
                                                                               {Trait::latin1ToString("&yucy;"), u"\x044E"},
                                                                               {Trait::latin1ToString("&yuml"), u"\x00FF"},
                                                                               {Trait::latin1ToString("&yuml;"), u"\x00FF"},
                                                                               {Trait::latin1ToString("&zacute;"), u"\x017A"},
                                                                               {Trait::latin1ToString("&zcaron;"), u"\x017E"},
                                                                               {Trait::latin1ToString("&zcy;"), u"\x0437"},
                                                                               {Trait::latin1ToString("&zdot;"), u"\x017C"},
                                                                               {Trait::latin1ToString("&zeetrf;"), u"\x2128"},
                                                                               {Trait::latin1ToString("&zeta;"), u"\x03B6"},
                                                                               {Trait::latin1ToString("&zfr;"), u"\xD835\xDD37"},
                                                                               {Trait::latin1ToString("&zhcy;"), u"\x0436"},
                                                                               {Trait::latin1ToString("&zigrarr;"), u"\x21DD"},
                                                                               {Trait::latin1ToString("&zopf;"), u"\xD835\xDD6B"},
                                                                               {Trait::latin1ToString("&zscr;"), u"\xD835\xDCCF"},
                                                                               {Trait::latin1ToString("&zwj;"), u"\x200D"},
                                                                               {Trait::latin1ToString("&zwnj;"), u"\x200C"}};

} /* namespace MD */

#endif // MD4QT_ENTITIES_MAP_H_INCLUDED
