
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraZoomControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraZoomControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraZoomControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraZoomControl::staticMetaObject);
}


// double QCameraZoomControl::currentDigitalZoom()


static void _init_f_currentDigitalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_currentDigitalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->currentDigitalZoom ());
}


// double QCameraZoomControl::currentOpticalZoom()


static void _init_f_currentOpticalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_currentOpticalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->currentOpticalZoom ());
}


// double QCameraZoomControl::maximumDigitalZoom()


static void _init_f_maximumDigitalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_maximumDigitalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->maximumDigitalZoom ());
}


// double QCameraZoomControl::maximumOpticalZoom()


static void _init_f_maximumOpticalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_maximumOpticalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->maximumOpticalZoom ());
}


// double QCameraZoomControl::requestedDigitalZoom()


static void _init_f_requestedDigitalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_requestedDigitalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->requestedDigitalZoom ());
}


// double QCameraZoomControl::requestedOpticalZoom()


static void _init_f_requestedOpticalZoom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_requestedOpticalZoom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl *)cls)->requestedOpticalZoom ());
}


// void QCameraZoomControl::zoomTo(double optical, double digital)


static void _init_f_zoomTo_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("optical");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("digital");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_zoomTo_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl *)cls)->zoomTo (arg1, arg2);
}


// static QString QCameraZoomControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraZoomControl::tr (arg1, arg2, arg3));
}


// static QString QCameraZoomControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraZoomControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCameraZoomControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("currentDigitalZoom", "@brief Method double QCameraZoomControl::currentDigitalZoom()\n", true, &_init_f_currentDigitalZoom_c0, &_call_f_currentDigitalZoom_c0);
  methods += new qt_gsi::GenericMethod ("currentOpticalZoom", "@brief Method double QCameraZoomControl::currentOpticalZoom()\n", true, &_init_f_currentOpticalZoom_c0, &_call_f_currentOpticalZoom_c0);
  methods += new qt_gsi::GenericMethod ("maximumDigitalZoom", "@brief Method double QCameraZoomControl::maximumDigitalZoom()\n", true, &_init_f_maximumDigitalZoom_c0, &_call_f_maximumDigitalZoom_c0);
  methods += new qt_gsi::GenericMethod ("maximumOpticalZoom", "@brief Method double QCameraZoomControl::maximumOpticalZoom()\n", true, &_init_f_maximumOpticalZoom_c0, &_call_f_maximumOpticalZoom_c0);
  methods += new qt_gsi::GenericMethod ("requestedDigitalZoom", "@brief Method double QCameraZoomControl::requestedDigitalZoom()\n", true, &_init_f_requestedDigitalZoom_c0, &_call_f_requestedDigitalZoom_c0);
  methods += new qt_gsi::GenericMethod ("requestedOpticalZoom", "@brief Method double QCameraZoomControl::requestedOpticalZoom()\n", true, &_init_f_requestedOpticalZoom_c0, &_call_f_requestedOpticalZoom_c0);
  methods += new qt_gsi::GenericMethod ("zoomTo", "@brief Method void QCameraZoomControl::zoomTo(double optical, double digital)\n", false, &_init_f_zoomTo_2034, &_call_f_zoomTo_2034);
  methods += gsi::qt_signal<double > ("currentDigitalZoomChanged(double)", "currentDigitalZoomChanged", gsi::arg("digitalZoom"), "@brief Signal declaration for QCameraZoomControl::currentDigitalZoomChanged(double digitalZoom)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("currentOpticalZoomChanged(double)", "currentOpticalZoomChanged", gsi::arg("opticalZoom"), "@brief Signal declaration for QCameraZoomControl::currentOpticalZoomChanged(double opticalZoom)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCameraZoomControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("maximumDigitalZoomChanged(double)", "maximumDigitalZoomChanged", gsi::arg("arg1"), "@brief Signal declaration for QCameraZoomControl::maximumDigitalZoomChanged(double)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("maximumOpticalZoomChanged(double)", "maximumOpticalZoomChanged", gsi::arg("arg1"), "@brief Signal declaration for QCameraZoomControl::maximumOpticalZoomChanged(double)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QCameraZoomControl::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("requestedDigitalZoomChanged(double)", "requestedDigitalZoomChanged", gsi::arg("digitalZoom"), "@brief Signal declaration for QCameraZoomControl::requestedDigitalZoomChanged(double digitalZoom)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("requestedOpticalZoomChanged(double)", "requestedOpticalZoomChanged", gsi::arg("opticalZoom"), "@brief Signal declaration for QCameraZoomControl::requestedOpticalZoomChanged(double opticalZoom)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraZoomControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraZoomControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QCameraZoomControl> decl_QCameraZoomControl (qtdecl_QMediaControl (), "QtMultimedia", "QCameraZoomControl_Native",
  methods_QCameraZoomControl (),
  "@hide\n@alias QCameraZoomControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCameraZoomControl> &qtdecl_QCameraZoomControl () { return decl_QCameraZoomControl; }

}


class QCameraZoomControl_Adaptor : public QCameraZoomControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCameraZoomControl_Adaptor();

  //  [adaptor ctor] QCameraZoomControl::QCameraZoomControl()
  QCameraZoomControl_Adaptor() : QCameraZoomControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCameraZoomControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCameraZoomControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCameraZoomControl::isSignalConnected(signal);
  }

  //  [expose] int QCameraZoomControl::receivers(const char *signal)
  int fp_QCameraZoomControl_receivers_c1731 (const char *signal) const {
    return QCameraZoomControl::receivers(signal);
  }

  //  [expose] QObject *QCameraZoomControl::sender()
  QObject * fp_QCameraZoomControl_sender_c0 () const {
    return QCameraZoomControl::sender();
  }

  //  [expose] int QCameraZoomControl::senderSignalIndex()
  int fp_QCameraZoomControl_senderSignalIndex_c0 () const {
    return QCameraZoomControl::senderSignalIndex();
  }

  //  [adaptor impl] double QCameraZoomControl::currentDigitalZoom()
  double cbs_currentDigitalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("currentDigitalZoom");
  }

  virtual double currentDigitalZoom() const
  {
    if (cb_currentDigitalZoom_c0_0.can_issue()) {
      return cb_currentDigitalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_currentDigitalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("currentDigitalZoom");
    }
  }

  //  [emitter impl] void QCameraZoomControl::currentDigitalZoomChanged(double digitalZoom)
  void emitter_QCameraZoomControl_currentDigitalZoomChanged_1071(double digitalZoom)
  {
    emit QCameraZoomControl::currentDigitalZoomChanged(digitalZoom);
  }

  //  [adaptor impl] double QCameraZoomControl::currentOpticalZoom()
  double cbs_currentOpticalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("currentOpticalZoom");
  }

  virtual double currentOpticalZoom() const
  {
    if (cb_currentOpticalZoom_c0_0.can_issue()) {
      return cb_currentOpticalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_currentOpticalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("currentOpticalZoom");
    }
  }

  //  [emitter impl] void QCameraZoomControl::currentOpticalZoomChanged(double opticalZoom)
  void emitter_QCameraZoomControl_currentOpticalZoomChanged_1071(double opticalZoom)
  {
    emit QCameraZoomControl::currentOpticalZoomChanged(opticalZoom);
  }

  //  [emitter impl] void QCameraZoomControl::destroyed(QObject *)
  void emitter_QCameraZoomControl_destroyed_1302(QObject *arg1)
  {
    emit QCameraZoomControl::destroyed(arg1);
  }

  //  [adaptor impl] bool QCameraZoomControl::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QCameraZoomControl::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCameraZoomControl_Adaptor, bool, QEvent *>(&QCameraZoomControl_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QCameraZoomControl::event(_event);
    }
  }

  //  [adaptor impl] bool QCameraZoomControl::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QCameraZoomControl::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCameraZoomControl_Adaptor, bool, QObject *, QEvent *>(&QCameraZoomControl_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QCameraZoomControl::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] double QCameraZoomControl::maximumDigitalZoom()
  double cbs_maximumDigitalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("maximumDigitalZoom");
  }

  virtual double maximumDigitalZoom() const
  {
    if (cb_maximumDigitalZoom_c0_0.can_issue()) {
      return cb_maximumDigitalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_maximumDigitalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("maximumDigitalZoom");
    }
  }

  //  [emitter impl] void QCameraZoomControl::maximumDigitalZoomChanged(double)
  void emitter_QCameraZoomControl_maximumDigitalZoomChanged_1071(double arg1)
  {
    emit QCameraZoomControl::maximumDigitalZoomChanged(arg1);
  }

  //  [adaptor impl] double QCameraZoomControl::maximumOpticalZoom()
  double cbs_maximumOpticalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("maximumOpticalZoom");
  }

  virtual double maximumOpticalZoom() const
  {
    if (cb_maximumOpticalZoom_c0_0.can_issue()) {
      return cb_maximumOpticalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_maximumOpticalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("maximumOpticalZoom");
    }
  }

  //  [emitter impl] void QCameraZoomControl::maximumOpticalZoomChanged(double)
  void emitter_QCameraZoomControl_maximumOpticalZoomChanged_1071(double arg1)
  {
    emit QCameraZoomControl::maximumOpticalZoomChanged(arg1);
  }

  //  [emitter impl] void QCameraZoomControl::objectNameChanged(const QString &objectName)
  void emitter_QCameraZoomControl_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QCameraZoomControl::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] double QCameraZoomControl::requestedDigitalZoom()
  double cbs_requestedDigitalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("requestedDigitalZoom");
  }

  virtual double requestedDigitalZoom() const
  {
    if (cb_requestedDigitalZoom_c0_0.can_issue()) {
      return cb_requestedDigitalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_requestedDigitalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("requestedDigitalZoom");
    }
  }

  //  [emitter impl] void QCameraZoomControl::requestedDigitalZoomChanged(double digitalZoom)
  void emitter_QCameraZoomControl_requestedDigitalZoomChanged_1071(double digitalZoom)
  {
    emit QCameraZoomControl::requestedDigitalZoomChanged(digitalZoom);
  }

  //  [adaptor impl] double QCameraZoomControl::requestedOpticalZoom()
  double cbs_requestedOpticalZoom_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("requestedOpticalZoom");
  }

  virtual double requestedOpticalZoom() const
  {
    if (cb_requestedOpticalZoom_c0_0.can_issue()) {
      return cb_requestedOpticalZoom_c0_0.issue<QCameraZoomControl_Adaptor, double>(&QCameraZoomControl_Adaptor::cbs_requestedOpticalZoom_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("requestedOpticalZoom");
    }
  }

  //  [emitter impl] void QCameraZoomControl::requestedOpticalZoomChanged(double opticalZoom)
  void emitter_QCameraZoomControl_requestedOpticalZoomChanged_1071(double opticalZoom)
  {
    emit QCameraZoomControl::requestedOpticalZoomChanged(opticalZoom);
  }

  //  [adaptor impl] void QCameraZoomControl::zoomTo(double optical, double digital)
  void cbs_zoomTo_2034_0(double optical, double digital)
  {
    __SUPPRESS_UNUSED_WARNING (optical);
    __SUPPRESS_UNUSED_WARNING (digital);
    throw qt_gsi::AbstractMethodCalledException("zoomTo");
  }

  virtual void zoomTo(double optical, double digital)
  {
    if (cb_zoomTo_2034_0.can_issue()) {
      cb_zoomTo_2034_0.issue<QCameraZoomControl_Adaptor, double, double>(&QCameraZoomControl_Adaptor::cbs_zoomTo_2034_0, optical, digital);
    } else {
      throw qt_gsi::AbstractMethodCalledException("zoomTo");
    }
  }

  //  [adaptor impl] void QCameraZoomControl::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QCameraZoomControl::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCameraZoomControl_Adaptor, QChildEvent *>(&QCameraZoomControl_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QCameraZoomControl::childEvent(event);
    }
  }

  //  [adaptor impl] void QCameraZoomControl::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QCameraZoomControl::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCameraZoomControl_Adaptor, QEvent *>(&QCameraZoomControl_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QCameraZoomControl::customEvent(event);
    }
  }

  //  [adaptor impl] void QCameraZoomControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCameraZoomControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCameraZoomControl_Adaptor, const QMetaMethod &>(&QCameraZoomControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCameraZoomControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCameraZoomControl::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QCameraZoomControl::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCameraZoomControl_Adaptor, QTimerEvent *>(&QCameraZoomControl_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QCameraZoomControl::timerEvent(event);
    }
  }

  gsi::Callback cb_currentDigitalZoom_c0_0;
  gsi::Callback cb_currentOpticalZoom_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_maximumDigitalZoom_c0_0;
  gsi::Callback cb_maximumOpticalZoom_c0_0;
  gsi::Callback cb_requestedDigitalZoom_c0_0;
  gsi::Callback cb_requestedOpticalZoom_c0_0;
  gsi::Callback cb_zoomTo_2034_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCameraZoomControl_Adaptor::~QCameraZoomControl_Adaptor() { }

//  Constructor QCameraZoomControl::QCameraZoomControl() (adaptor class)

static void _init_ctor_QCameraZoomControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QCameraZoomControl_Adaptor> ();
}

static void _call_ctor_QCameraZoomControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraZoomControl_Adaptor *> (new QCameraZoomControl_Adaptor ());
}


// void QCameraZoomControl::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// double QCameraZoomControl::currentDigitalZoom()

static void _init_cbs_currentDigitalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_currentDigitalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_currentDigitalZoom_c0_0 ());
}

static void _set_callback_cbs_currentDigitalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_currentDigitalZoom_c0_0 = cb;
}


// emitter void QCameraZoomControl::currentDigitalZoomChanged(double digitalZoom)

static void _init_emitter_currentDigitalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("digitalZoom");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentDigitalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QCameraZoomControl_Adaptor *)cls)->emitter_QCameraZoomControl_currentDigitalZoomChanged_1071 (arg1);
}


// double QCameraZoomControl::currentOpticalZoom()

static void _init_cbs_currentOpticalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_currentOpticalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_currentOpticalZoom_c0_0 ());
}

static void _set_callback_cbs_currentOpticalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_currentOpticalZoom_c0_0 = cb;
}


// emitter void QCameraZoomControl::currentOpticalZoomChanged(double opticalZoom)

static void _init_emitter_currentOpticalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opticalZoom");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentOpticalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QCameraZoomControl_Adaptor *)cls)->emitter_QCameraZoomControl_currentOpticalZoomChanged_1071 (arg1);
}


// void QCameraZoomControl::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QCameraZoomControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QCameraZoomControl_Adaptor *)cls)->emitter_QCameraZoomControl_destroyed_1302 (arg1);
}


// void QCameraZoomControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QCameraZoomControl::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraZoomControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCameraZoomControl::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraZoomControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QCameraZoomControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCameraZoomControl_Adaptor *)cls)->fp_QCameraZoomControl_isSignalConnected_c2394 (arg1));
}


// double QCameraZoomControl::maximumDigitalZoom()

static void _init_cbs_maximumDigitalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_maximumDigitalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_maximumDigitalZoom_c0_0 ());
}

static void _set_callback_cbs_maximumDigitalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_maximumDigitalZoom_c0_0 = cb;
}


// emitter void QCameraZoomControl::maximumDigitalZoomChanged(double)

static void _init_emitter_maximumDigitalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_maximumDigitalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QCameraZoomControl_Adaptor *)cls)->emitter_QCameraZoomControl_maximumDigitalZoomChanged_1071 (arg1);
}


// double QCameraZoomControl::maximumOpticalZoom()

static void _init_cbs_maximumOpticalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_maximumOpticalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_maximumOpticalZoom_c0_0 ());
}

static void _set_callback_cbs_maximumOpticalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_maximumOpticalZoom_c0_0 = cb;
}


// emitter void QCameraZoomControl::maximumOpticalZoomChanged(double)

static void _init_emitter_maximumOpticalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_maximumOpticalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QCameraZoomControl_Adaptor *)cls)->emitter_QCameraZoomControl_maximumOpticalZoomChanged_1071 (arg1);
}


// emitter void QCameraZoomControl::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCameraZoomControl_Adaptor *)cls)->emitter_QCameraZoomControl_objectNameChanged_4567 (arg1);
}


// exposed int QCameraZoomControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCameraZoomControl_Adaptor *)cls)->fp_QCameraZoomControl_receivers_c1731 (arg1));
}


// double QCameraZoomControl::requestedDigitalZoom()

static void _init_cbs_requestedDigitalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_requestedDigitalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_requestedDigitalZoom_c0_0 ());
}

static void _set_callback_cbs_requestedDigitalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_requestedDigitalZoom_c0_0 = cb;
}


// emitter void QCameraZoomControl::requestedDigitalZoomChanged(double digitalZoom)

static void _init_emitter_requestedDigitalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("digitalZoom");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_requestedDigitalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QCameraZoomControl_Adaptor *)cls)->emitter_QCameraZoomControl_requestedDigitalZoomChanged_1071 (arg1);
}


// double QCameraZoomControl::requestedOpticalZoom()

static void _init_cbs_requestedOpticalZoom_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_requestedOpticalZoom_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QCameraZoomControl_Adaptor *)cls)->cbs_requestedOpticalZoom_c0_0 ());
}

static void _set_callback_cbs_requestedOpticalZoom_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_requestedOpticalZoom_c0_0 = cb;
}


// emitter void QCameraZoomControl::requestedOpticalZoomChanged(double opticalZoom)

static void _init_emitter_requestedOpticalZoomChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opticalZoom");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_requestedOpticalZoomChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QCameraZoomControl_Adaptor *)cls)->emitter_QCameraZoomControl_requestedOpticalZoomChanged_1071 (arg1);
}


// exposed QObject *QCameraZoomControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCameraZoomControl_Adaptor *)cls)->fp_QCameraZoomControl_sender_c0 ());
}


// exposed int QCameraZoomControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraZoomControl_Adaptor *)cls)->fp_QCameraZoomControl_senderSignalIndex_c0 ());
}


// void QCameraZoomControl::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QCameraZoomControl::zoomTo(double optical, double digital)

static void _init_cbs_zoomTo_2034_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("optical");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("digital");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_zoomTo_2034_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  double arg2 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraZoomControl_Adaptor *)cls)->cbs_zoomTo_2034_0 (arg1, arg2);
}

static void _set_callback_cbs_zoomTo_2034_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraZoomControl_Adaptor *)cls)->cb_zoomTo_2034_0 = cb;
}


namespace gsi
{

gsi::Class<QCameraZoomControl> &qtdecl_QCameraZoomControl ();

static gsi::Methods methods_QCameraZoomControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCameraZoomControl::QCameraZoomControl()\nThis method creates an object of class QCameraZoomControl.", &_init_ctor_QCameraZoomControl_Adaptor_0, &_call_ctor_QCameraZoomControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCameraZoomControl::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("currentDigitalZoom", "@brief Virtual method double QCameraZoomControl::currentDigitalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_currentDigitalZoom_c0_0, &_call_cbs_currentDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("currentDigitalZoom", "@hide", true, &_init_cbs_currentDigitalZoom_c0_0, &_call_cbs_currentDigitalZoom_c0_0, &_set_callback_cbs_currentDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_currentDigitalZoomChanged", "@brief Emitter for signal void QCameraZoomControl::currentDigitalZoomChanged(double digitalZoom)\nCall this method to emit this signal.", false, &_init_emitter_currentDigitalZoomChanged_1071, &_call_emitter_currentDigitalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("currentOpticalZoom", "@brief Virtual method double QCameraZoomControl::currentOpticalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_currentOpticalZoom_c0_0, &_call_cbs_currentOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("currentOpticalZoom", "@hide", true, &_init_cbs_currentOpticalZoom_c0_0, &_call_cbs_currentOpticalZoom_c0_0, &_set_callback_cbs_currentOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_currentOpticalZoomChanged", "@brief Emitter for signal void QCameraZoomControl::currentOpticalZoomChanged(double opticalZoom)\nCall this method to emit this signal.", false, &_init_emitter_currentOpticalZoomChanged_1071, &_call_emitter_currentOpticalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCameraZoomControl::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCameraZoomControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCameraZoomControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCameraZoomControl::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCameraZoomControl::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCameraZoomControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("maximumDigitalZoom", "@brief Virtual method double QCameraZoomControl::maximumDigitalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumDigitalZoom_c0_0, &_call_cbs_maximumDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("maximumDigitalZoom", "@hide", true, &_init_cbs_maximumDigitalZoom_c0_0, &_call_cbs_maximumDigitalZoom_c0_0, &_set_callback_cbs_maximumDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_maximumDigitalZoomChanged", "@brief Emitter for signal void QCameraZoomControl::maximumDigitalZoomChanged(double)\nCall this method to emit this signal.", false, &_init_emitter_maximumDigitalZoomChanged_1071, &_call_emitter_maximumDigitalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("maximumOpticalZoom", "@brief Virtual method double QCameraZoomControl::maximumOpticalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumOpticalZoom_c0_0, &_call_cbs_maximumOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("maximumOpticalZoom", "@hide", true, &_init_cbs_maximumOpticalZoom_c0_0, &_call_cbs_maximumOpticalZoom_c0_0, &_set_callback_cbs_maximumOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_maximumOpticalZoomChanged", "@brief Emitter for signal void QCameraZoomControl::maximumOpticalZoomChanged(double)\nCall this method to emit this signal.", false, &_init_emitter_maximumOpticalZoomChanged_1071, &_call_emitter_maximumOpticalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QCameraZoomControl::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCameraZoomControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("requestedDigitalZoom", "@brief Virtual method double QCameraZoomControl::requestedDigitalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_requestedDigitalZoom_c0_0, &_call_cbs_requestedDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("requestedDigitalZoom", "@hide", true, &_init_cbs_requestedDigitalZoom_c0_0, &_call_cbs_requestedDigitalZoom_c0_0, &_set_callback_cbs_requestedDigitalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_requestedDigitalZoomChanged", "@brief Emitter for signal void QCameraZoomControl::requestedDigitalZoomChanged(double digitalZoom)\nCall this method to emit this signal.", false, &_init_emitter_requestedDigitalZoomChanged_1071, &_call_emitter_requestedDigitalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("requestedOpticalZoom", "@brief Virtual method double QCameraZoomControl::requestedOpticalZoom()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_requestedOpticalZoom_c0_0, &_call_cbs_requestedOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("requestedOpticalZoom", "@hide", true, &_init_cbs_requestedOpticalZoom_c0_0, &_call_cbs_requestedOpticalZoom_c0_0, &_set_callback_cbs_requestedOpticalZoom_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_requestedOpticalZoomChanged", "@brief Emitter for signal void QCameraZoomControl::requestedOpticalZoomChanged(double opticalZoom)\nCall this method to emit this signal.", false, &_init_emitter_requestedOpticalZoomChanged_1071, &_call_emitter_requestedOpticalZoomChanged_1071);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCameraZoomControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCameraZoomControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCameraZoomControl::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("zoomTo", "@brief Virtual method void QCameraZoomControl::zoomTo(double optical, double digital)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_zoomTo_2034_0, &_call_cbs_zoomTo_2034_0);
  methods += new qt_gsi::GenericMethod ("zoomTo", "@hide", false, &_init_cbs_zoomTo_2034_0, &_call_cbs_zoomTo_2034_0, &_set_callback_cbs_zoomTo_2034_0);
  return methods;
}

gsi::Class<QCameraZoomControl_Adaptor> decl_QCameraZoomControl_Adaptor (qtdecl_QCameraZoomControl (), "QtMultimedia", "QCameraZoomControl",
  methods_QCameraZoomControl_Adaptor (),
  "@qt\n@brief Binding of QCameraZoomControl");

}

