/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.text.NumberFormat;
import java.util.Collection;
import net.sourceforge.stripes.validation.NumberTypeConverterSupport;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteTypeConverter
extends NumberTypeConverterSupport
implements TypeConverter<Byte> {
    @Override
    public Byte convert(String input, Class<? extends Byte> targetType, Collection<ValidationError> errors) {
        Number number = this.parse(input, errors);
        Byte retval = null;
        if (errors.size() == 0) {
            long output = number.longValue();
            if (output < -128L || output > 127L) {
                errors.add(new ScopedLocalizableError("converter.byte", "outOfRange", (byte)-128, (byte)127));
            } else {
                retval = new Byte((byte)output);
            }
        }
        return retval;
    }

    @Override
    protected NumberFormat[] getNumberFormats() {
        return new NumberFormat[]{NumberFormat.getIntegerInstance(this.getLocale())};
    }
}

