/*
 * Copyright 2011 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.block.function.primitive;

import java.io.Serializable;

import com.gs.collections.api.block.function.primitive.CharToCharFunction;

/**
 * A CharFunction can be used to convert one character to another.
 *
 * @deprecated since 3.0. Use {@link CharToCharFunction} instead.
 */
@Deprecated
public interface CharFunction
        extends Serializable
{
    CharFunction TO_UPPERCASE = new CharFunction()
    {
        private static final long serialVersionUID = 1L;

        public char valueOf(char character)
        {
            return Character.toUpperCase(character);
        }
    };

    CharFunction TO_LOWERCASE = new CharFunction()
    {
        private static final long serialVersionUID = 1L;

        public char valueOf(char character)
        {
            return Character.toLowerCase(character);
        }
    };

    char valueOf(char character);
}
