package eventgrid

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/eventgrid/2018-01-01/eventgrid"

// AppAction enumerates the values for app action.
type AppAction string

const (
	// ChangedAppSettings There was an operation to change app setting on the web app.
	ChangedAppSettings AppAction = "ChangedAppSettings"
	// Completed The job has completed.
	Completed AppAction = "Completed"
	// Failed The job has failed to complete.
	Failed AppAction = "Failed"
	// Restarted Web app was restarted.
	Restarted AppAction = "Restarted"
	// Started The job has started.
	Started AppAction = "Started"
	// Stopped Web app was stopped.
	Stopped AppAction = "Stopped"
)

// PossibleAppActionValues returns an array of possible values for the AppAction const type.
func PossibleAppActionValues() []AppAction {
	return []AppAction{ChangedAppSettings, Completed, Failed, Restarted, Started, Stopped}
}

// AppServicePlanAction enumerates the values for app service plan action.
type AppServicePlanAction string

const (
	// Updated App Service plan is being updated.
	Updated AppServicePlanAction = "Updated"
)

// PossibleAppServicePlanActionValues returns an array of possible values for the AppServicePlanAction const type.
func PossibleAppServicePlanActionValues() []AppServicePlanAction {
	return []AppServicePlanAction{Updated}
}

// AsyncStatus enumerates the values for async status.
type AsyncStatus string

const (
	// AsyncStatusCompleted Async operation has completed.
	AsyncStatusCompleted AsyncStatus = "Completed"
	// AsyncStatusFailed Async operation failed to complete.
	AsyncStatusFailed AsyncStatus = "Failed"
	// AsyncStatusStarted Async operation has started.
	AsyncStatusStarted AsyncStatus = "Started"
)

// PossibleAsyncStatusValues returns an array of possible values for the AsyncStatus const type.
func PossibleAsyncStatusValues() []AsyncStatus {
	return []AsyncStatus{AsyncStatusCompleted, AsyncStatusFailed, AsyncStatusStarted}
}

// MediaJobErrorCategory enumerates the values for media job error category.
type MediaJobErrorCategory string

const (
	// Configuration The error is configuration related.
	Configuration MediaJobErrorCategory = "Configuration"
	// Content The error is related to data in the input files.
	Content MediaJobErrorCategory = "Content"
	// Download The error is download related.
	Download MediaJobErrorCategory = "Download"
	// Service The error is service related.
	Service MediaJobErrorCategory = "Service"
	// Upload The error is upload related.
	Upload MediaJobErrorCategory = "Upload"
)

// PossibleMediaJobErrorCategoryValues returns an array of possible values for the MediaJobErrorCategory const type.
func PossibleMediaJobErrorCategoryValues() []MediaJobErrorCategory {
	return []MediaJobErrorCategory{Configuration, Content, Download, Service, Upload}
}

// MediaJobErrorCode enumerates the values for media job error code.
type MediaJobErrorCode string

const (
	// ConfigurationUnsupported There was a problem with the combination of input files and the configuration
	// settings applied, fix the configuration settings and retry with the same input, or change input to match
	// the configuration.
	ConfigurationUnsupported MediaJobErrorCode = "ConfigurationUnsupported"
	// ContentMalformed There was a problem with the input content (for example: zero byte files, or
	// corrupt/non-decodable files), check the input files.
	ContentMalformed MediaJobErrorCode = "ContentMalformed"
	// ContentUnsupported There was a problem with the format of the input (not valid media file, or an
	// unsupported file/codec), check the validity of the input files.
	ContentUnsupported MediaJobErrorCode = "ContentUnsupported"
	// DownloadNotAccessible While trying to download the input files, the files were not accessible, please
	// check the availability of the source.
	DownloadNotAccessible MediaJobErrorCode = "DownloadNotAccessible"
	// DownloadTransientError While trying to download the input files, there was an issue during transfer
	// (storage service, network errors), see details and check your source.
	DownloadTransientError MediaJobErrorCode = "DownloadTransientError"
	// ServiceError Fatal service error, please contact support.
	ServiceError MediaJobErrorCode = "ServiceError"
	// ServiceTransientError Transient error, please retry, if retry is unsuccessful, please contact support.
	ServiceTransientError MediaJobErrorCode = "ServiceTransientError"
	// UploadNotAccessible While trying to upload the output files, the destination was not reachable, please
	// check the availability of the destination.
	UploadNotAccessible MediaJobErrorCode = "UploadNotAccessible"
	// UploadTransientError While trying to upload the output files, there was an issue during transfer
	// (storage service, network errors), see details and check your destination.
	UploadTransientError MediaJobErrorCode = "UploadTransientError"
)

// PossibleMediaJobErrorCodeValues returns an array of possible values for the MediaJobErrorCode const type.
func PossibleMediaJobErrorCodeValues() []MediaJobErrorCode {
	return []MediaJobErrorCode{ConfigurationUnsupported, ContentMalformed, ContentUnsupported, DownloadNotAccessible, DownloadTransientError, ServiceError, ServiceTransientError, UploadNotAccessible, UploadTransientError}
}

// MediaJobRetry enumerates the values for media job retry.
type MediaJobRetry string

const (
	// DoNotRetry Issue needs to be investigated and then the job resubmitted with corrections or retried once
	// the underlying issue has been corrected.
	DoNotRetry MediaJobRetry = "DoNotRetry"
	// MayRetry Issue may be resolved after waiting for a period of time and resubmitting the same Job.
	MayRetry MediaJobRetry = "MayRetry"
)

// PossibleMediaJobRetryValues returns an array of possible values for the MediaJobRetry const type.
func PossibleMediaJobRetryValues() []MediaJobRetry {
	return []MediaJobRetry{DoNotRetry, MayRetry}
}

// MediaJobState enumerates the values for media job state.
type MediaJobState string

const (
	// Canceled The job was canceled. This is a final state for the job.
	Canceled MediaJobState = "Canceled"
	// Canceling The job is in the process of being canceled. This is a transient state for the job.
	Canceling MediaJobState = "Canceling"
	// Error The job has encountered an error. This is a final state for the job.
	Error MediaJobState = "Error"
	// Finished The job is finished. This is a final state for the job.
	Finished MediaJobState = "Finished"
	// Processing The job is processing. This is a transient state for the job.
	Processing MediaJobState = "Processing"
	// Queued The job is in a queued state, waiting for resources to become available. This is a transient
	// state.
	Queued MediaJobState = "Queued"
	// Scheduled The job is being scheduled to run on an available resource. This is a transient state, between
	// queued and processing states.
	Scheduled MediaJobState = "Scheduled"
)

// PossibleMediaJobStateValues returns an array of possible values for the MediaJobState const type.
func PossibleMediaJobStateValues() []MediaJobState {
	return []MediaJobState{Canceled, Canceling, Error, Finished, Processing, Queued, Scheduled}
}

// OdataType enumerates the values for odata type.
type OdataType string

const (
	// OdataTypeMediaJobOutput ...
	OdataTypeMediaJobOutput OdataType = "MediaJobOutput"
	// OdataTypeMicrosoftMediaJobOutputAsset ...
	OdataTypeMicrosoftMediaJobOutputAsset OdataType = "#Microsoft.Media.JobOutputAsset"
)

// PossibleOdataTypeValues returns an array of possible values for the OdataType const type.
func PossibleOdataTypeValues() []OdataType {
	return []OdataType{OdataTypeMediaJobOutput, OdataTypeMicrosoftMediaJobOutputAsset}
}

// StampKind enumerates the values for stamp kind.
type StampKind string

const (
	// AseV1 App Service Plan is running on an App Service Environment V1.
	AseV1 StampKind = "AseV1"
	// AseV2 App Service Plan is running on an App Service Environment V2.
	AseV2 StampKind = "AseV2"
	// Public App Service Plan is running on a public stamp.
	Public StampKind = "Public"
)

// PossibleStampKindValues returns an array of possible values for the StampKind const type.
func PossibleStampKindValues() []StampKind {
	return []StampKind{AseV1, AseV2, Public}
}

// AppConfigurationKeyValueDeletedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.AppConfiguration.KeyValueDeleted event.
type AppConfigurationKeyValueDeletedEventData struct {
	// Key - The key used to identify the key-value that was deleted.
	Key *string `json:"key,omitempty"`
	// Label - The label, if any, used to identify the key-value that was deleted.
	Label *string `json:"label,omitempty"`
	// Etag - The etag representing the key-value that was deleted.
	Etag *string `json:"etag,omitempty"`
}

// AppConfigurationKeyValueModifiedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.AppConfiguration.KeyValueModified event.
type AppConfigurationKeyValueModifiedEventData struct {
	// Key - The key used to identify the key-value that was modified.
	Key *string `json:"key,omitempty"`
	// Label - The label, if any, used to identify the key-value that was modified.
	Label *string `json:"label,omitempty"`
	// Etag - The etag representing the new state of the key-value.
	Etag *string `json:"etag,omitempty"`
}

// AppEventTypeDetail detail of action on the app.
type AppEventTypeDetail struct {
	// Action - Type of action of the operation. Possible values include: 'Restarted', 'Stopped', 'ChangedAppSettings', 'Started', 'Completed', 'Failed'
	Action AppAction `json:"action,omitempty"`
}

// AppServicePlanEventTypeDetail detail of action on the app service plan.
type AppServicePlanEventTypeDetail struct {
	// StampKind - Kind of environment where app service plan is. Possible values include: 'Public', 'AseV1', 'AseV2'
	StampKind StampKind `json:"stampKind,omitempty"`
	// Action - Type of action on the app service plan. Possible values include: 'Updated'
	Action AppServicePlanAction `json:"action,omitempty"`
	// Status - Possible values include: 'AsyncStatusStarted', 'AsyncStatusCompleted', 'AsyncStatusFailed'
	Status AsyncStatus `json:"status,omitempty"`
}

// ContainerRegistryArtifactEventData the content of the event request message.
type ContainerRegistryArtifactEventData struct {
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Action - The action that encompasses the provided event.
	Action *string `json:"action,omitempty"`
	// Target - The target of the event.
	Target *ContainerRegistryArtifactEventTarget `json:"target,omitempty"`
}

// ContainerRegistryArtifactEventTarget the target of the event.
type ContainerRegistryArtifactEventTarget struct {
	// MediaType - The MIME type of the artifact.
	MediaType *string `json:"mediaType,omitempty"`
	// Size - The size in bytes of the artifact.
	Size *int64 `json:"size,omitempty"`
	// Digest - The digest of the artifact.
	Digest *string `json:"digest,omitempty"`
	// Repository - The repository name of the artifact.
	Repository *string `json:"repository,omitempty"`
	// Tag - The tag of the artifact.
	Tag *string `json:"tag,omitempty"`
	// Name - The name of the artifact.
	Name *string `json:"name,omitempty"`
	// Version - The version of the artifact.
	Version *string `json:"version,omitempty"`
}

// ContainerRegistryChartDeletedEventData schema of the Data property of an EventGridEvent for a
// Microsoft.ContainerRegistry.ChartDeleted event.
type ContainerRegistryChartDeletedEventData struct {
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Action - The action that encompasses the provided event.
	Action *string `json:"action,omitempty"`
	// Target - The target of the event.
	Target *ContainerRegistryArtifactEventTarget `json:"target,omitempty"`
}

// ContainerRegistryChartPushedEventData schema of the Data property of an EventGridEvent for a
// Microsoft.ContainerRegistry.ChartPushed event.
type ContainerRegistryChartPushedEventData struct {
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Action - The action that encompasses the provided event.
	Action *string `json:"action,omitempty"`
	// Target - The target of the event.
	Target *ContainerRegistryArtifactEventTarget `json:"target,omitempty"`
}

// ContainerRegistryEventActor the agent that initiated the event. For most situations, this could be from
// the authorization context of the request.
type ContainerRegistryEventActor struct {
	// Name - The subject or username associated with the request context that generated the event.
	Name *string `json:"name,omitempty"`
}

// ContainerRegistryEventData the content of the event request message.
type ContainerRegistryEventData struct {
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Action - The action that encompasses the provided event.
	Action *string `json:"action,omitempty"`
	// Target - The target of the event.
	Target *ContainerRegistryEventTarget `json:"target,omitempty"`
	// Request - The request that generated the event.
	Request *ContainerRegistryEventRequest `json:"request,omitempty"`
	// Actor - The agent that initiated the event. For most situations, this could be from the authorization context of the request.
	Actor *ContainerRegistryEventActor `json:"actor,omitempty"`
	// Source - The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
	Source *ContainerRegistryEventSource `json:"source,omitempty"`
}

// ContainerRegistryEventRequest the request that generated the event.
type ContainerRegistryEventRequest struct {
	// ID - The ID of the request that initiated the event.
	ID *string `json:"id,omitempty"`
	// Addr - The IP or hostname and possibly port of the client connection that initiated the event. This is the RemoteAddr from the standard http request.
	Addr *string `json:"addr,omitempty"`
	// Host - The externally accessible hostname of the registry instance, as specified by the http host header on incoming requests.
	Host *string `json:"host,omitempty"`
	// Method - The request method that generated the event.
	Method *string `json:"method,omitempty"`
	// Useragent - The user agent header of the request.
	Useragent *string `json:"useragent,omitempty"`
}

// ContainerRegistryEventSource the registry node that generated the event. Put differently, while the
// actor initiates the event, the source generates it.
type ContainerRegistryEventSource struct {
	// Addr - The IP or hostname and the port of the registry node that generated the event. Generally, this will be resolved by os.Hostname() along with the running port.
	Addr *string `json:"addr,omitempty"`
	// InstanceID - The running instance of an application. Changes after each restart.
	InstanceID *string `json:"instanceID,omitempty"`
}

// ContainerRegistryEventTarget the target of the event.
type ContainerRegistryEventTarget struct {
	// MediaType - The MIME type of the referenced object.
	MediaType *string `json:"mediaType,omitempty"`
	// Size - The number of bytes of the content. Same as Length field.
	Size *int64 `json:"size,omitempty"`
	// Digest - The digest of the content, as defined by the Registry V2 HTTP API Specification.
	Digest *string `json:"digest,omitempty"`
	// Length - The number of bytes of the content. Same as Size field.
	Length *int64 `json:"length,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
	// URL - The direct URL to the content.
	URL *string `json:"url,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
}

// ContainerRegistryImageDeletedEventData schema of the Data property of an EventGridEvent for a
// Microsoft.ContainerRegistry.ImageDeleted event.
type ContainerRegistryImageDeletedEventData struct {
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Action - The action that encompasses the provided event.
	Action *string `json:"action,omitempty"`
	// Target - The target of the event.
	Target *ContainerRegistryEventTarget `json:"target,omitempty"`
	// Request - The request that generated the event.
	Request *ContainerRegistryEventRequest `json:"request,omitempty"`
	// Actor - The agent that initiated the event. For most situations, this could be from the authorization context of the request.
	Actor *ContainerRegistryEventActor `json:"actor,omitempty"`
	// Source - The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
	Source *ContainerRegistryEventSource `json:"source,omitempty"`
}

// ContainerRegistryImagePushedEventData schema of the Data property of an EventGridEvent for a
// Microsoft.ContainerRegistry.ImagePushed event.
type ContainerRegistryImagePushedEventData struct {
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Action - The action that encompasses the provided event.
	Action *string `json:"action,omitempty"`
	// Target - The target of the event.
	Target *ContainerRegistryEventTarget `json:"target,omitempty"`
	// Request - The request that generated the event.
	Request *ContainerRegistryEventRequest `json:"request,omitempty"`
	// Actor - The agent that initiated the event. For most situations, this could be from the authorization context of the request.
	Actor *ContainerRegistryEventActor `json:"actor,omitempty"`
	// Source - The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
	Source *ContainerRegistryEventSource `json:"source,omitempty"`
}

// DeviceConnectionStateEventInfo information about the device connection state event.
type DeviceConnectionStateEventInfo struct {
	// SequenceNumber - Sequence number is string representation of a hexadecimal number. string compare can be used to identify the larger number because both in ASCII and HEX numbers come after alphabets. If you are converting the string to hex, then the number is a 256 bit number.
	SequenceNumber *string `json:"sequenceNumber,omitempty"`
}

// DeviceConnectionStateEventProperties schema of the Data property of an EventGridEvent for a device
// connection state event (DeviceConnected, DeviceDisconnected).
type DeviceConnectionStateEventProperties struct {
	// DeviceID - The unique identifier of the device. This case-sensitive string can be up to 128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
	DeviceID *string `json:"deviceId,omitempty"`
	// ModuleID - The unique identifier of the module. This case-sensitive string can be up to 128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
	ModuleID *string `json:"moduleId,omitempty"`
	// HubName - Name of the IoT Hub where the device was created or deleted.
	HubName *string `json:"hubName,omitempty"`
	// DeviceConnectionStateEventInfo - Information about the device connection state event.
	DeviceConnectionStateEventInfo *DeviceConnectionStateEventInfo `json:"deviceConnectionStateEventInfo,omitempty"`
}

// DeviceLifeCycleEventProperties schema of the Data property of an EventGridEvent for a device life cycle
// event (DeviceCreated, DeviceDeleted).
type DeviceLifeCycleEventProperties struct {
	// DeviceID - The unique identifier of the device. This case-sensitive string can be up to 128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
	DeviceID *string `json:"deviceId,omitempty"`
	// HubName - Name of the IoT Hub where the device was created or deleted.
	HubName *string `json:"hubName,omitempty"`
	// Twin - Information about the device twin, which is the cloud representation of application device metadata.
	Twin *DeviceTwinInfo `json:"twin,omitempty"`
}

// DeviceTelemetryEventProperties schema of the Data property of an EventGridEvent for a device telemetry
// event (DeviceTelemetry).
type DeviceTelemetryEventProperties struct {
	// Body - The content of the message from the device.
	Body interface{} `json:"body,omitempty"`
	// Properties - Application properties are user-defined strings that can be added to the message. These fields are optional.
	Properties map[string]*string `json:"properties"`
	// SystemProperties - System properties help identify contents and source of the messages.
	SystemProperties map[string]*string `json:"systemProperties"`
}

// MarshalJSON is the custom marshaler for DeviceTelemetryEventProperties.
func (dtep DeviceTelemetryEventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dtep.Body != nil {
		objectMap["body"] = dtep.Body
	}
	if dtep.Properties != nil {
		objectMap["properties"] = dtep.Properties
	}
	if dtep.SystemProperties != nil {
		objectMap["systemProperties"] = dtep.SystemProperties
	}
	return json.Marshal(objectMap)
}

// DeviceTwinInfo information about the device twin, which is the cloud representation of application
// device metadata.
type DeviceTwinInfo struct {
	// AuthenticationType - Authentication type used for this device: either SAS, SelfSigned, or CertificateAuthority.
	AuthenticationType *string `json:"authenticationType,omitempty"`
	// CloudToDeviceMessageCount - Count of cloud to device messages sent to this device.
	CloudToDeviceMessageCount *float64 `json:"cloudToDeviceMessageCount,omitempty"`
	// ConnectionState - Whether the device is connected or disconnected.
	ConnectionState *string `json:"connectionState,omitempty"`
	// DeviceID - The unique identifier of the device twin.
	DeviceID *string `json:"deviceId,omitempty"`
	// Etag - A piece of information that describes the content of the device twin. Each etag is guaranteed to be unique per device twin.
	Etag *string `json:"etag,omitempty"`
	// LastActivityTime - The ISO8601 timestamp of the last activity.
	LastActivityTime *string `json:"lastActivityTime,omitempty"`
	// Properties - Properties JSON element.
	Properties *DeviceTwinInfoProperties `json:"properties,omitempty"`
	// Status - Whether the device twin is enabled or disabled.
	Status *string `json:"status,omitempty"`
	// StatusUpdateTime - The ISO8601 timestamp of the last device twin status update.
	StatusUpdateTime *string `json:"statusUpdateTime,omitempty"`
	// Version - An integer that is incremented by one each time the device twin is updated.
	Version *float64 `json:"version,omitempty"`
	// X509Thumbprint - The thumbprint is a unique value for the x509 certificate, commonly used to find a particular certificate in a certificate store. The thumbprint is dynamically generated using the SHA1 algorithm, and does not physically exist in the certificate.
	X509Thumbprint *DeviceTwinInfoX509Thumbprint `json:"x509Thumbprint,omitempty"`
}

// DeviceTwinInfoProperties properties JSON element.
type DeviceTwinInfoProperties struct {
	// Desired - A portion of the properties that can be written only by the application back-end, and read by the device.
	Desired *DeviceTwinProperties `json:"desired,omitempty"`
	// Reported - A portion of the properties that can be written only by the device, and read by the application back-end.
	Reported *DeviceTwinProperties `json:"reported,omitempty"`
}

// DeviceTwinInfoX509Thumbprint the thumbprint is a unique value for the x509 certificate, commonly used to
// find a particular certificate in a certificate store. The thumbprint is dynamically generated using the
// SHA1 algorithm, and does not physically exist in the certificate.
type DeviceTwinInfoX509Thumbprint struct {
	// PrimaryThumbprint - Primary thumbprint for the x509 certificate.
	PrimaryThumbprint *string `json:"primaryThumbprint,omitempty"`
	// SecondaryThumbprint - Secondary thumbprint for the x509 certificate.
	SecondaryThumbprint *string `json:"secondaryThumbprint,omitempty"`
}

// DeviceTwinMetadata metadata information for the properties JSON document.
type DeviceTwinMetadata struct {
	// LastUpdated - The ISO8601 timestamp of the last time the properties were updated.
	LastUpdated *string `json:"lastUpdated,omitempty"`
}

// DeviceTwinProperties a portion of the properties that can be written only by the application back-end,
// and read by the device.
type DeviceTwinProperties struct {
	// Metadata - Metadata information for the properties JSON document.
	Metadata *DeviceTwinMetadata `json:"metadata,omitempty"`
	// Version - Version of device twin properties.
	Version *float64 `json:"version,omitempty"`
}

// Event properties of an event published to an Event Grid topic.
type Event struct {
	// ID - An unique identifier for the event.
	ID *string `json:"id,omitempty"`
	// Topic - The resource path of the event source.
	Topic *string `json:"topic,omitempty"`
	// Subject - A resource path relative to the topic path.
	Subject *string `json:"subject,omitempty"`
	// Data - Event data specific to the event type.
	Data interface{} `json:"data,omitempty"`
	// EventType - The type of the event that occurred.
	EventType *string `json:"eventType,omitempty"`
	// EventTime - The time (in UTC) the event was generated.
	EventTime *date.Time `json:"eventTime,omitempty"`
	// MetadataVersion - READ-ONLY; The schema version of the event metadata.
	MetadataVersion *string `json:"metadataVersion,omitempty"`
	// DataVersion - The schema version of the data object.
	DataVersion *string `json:"dataVersion,omitempty"`
}

// EventHubCaptureFileCreatedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.EventHub.CaptureFileCreated event.
type EventHubCaptureFileCreatedEventData struct {
	// Fileurl - The path to the capture file.
	Fileurl *string `json:"fileurl,omitempty"`
	// FileType - The file type of the capture file.
	FileType *string `json:"fileType,omitempty"`
	// PartitionID - The shard ID.
	PartitionID *string `json:"partitionId,omitempty"`
	// SizeInBytes - The file size.
	SizeInBytes *int32 `json:"sizeInBytes,omitempty"`
	// EventCount - The number of events in the file.
	EventCount *int32 `json:"eventCount,omitempty"`
	// FirstSequenceNumber - The smallest sequence number from the queue.
	FirstSequenceNumber *int32 `json:"firstSequenceNumber,omitempty"`
	// LastSequenceNumber - The last sequence number from the queue.
	LastSequenceNumber *int32 `json:"lastSequenceNumber,omitempty"`
	// FirstEnqueueTime - The first time from the queue.
	FirstEnqueueTime *date.Time `json:"firstEnqueueTime,omitempty"`
	// LastEnqueueTime - The last time from the queue.
	LastEnqueueTime *date.Time `json:"lastEnqueueTime,omitempty"`
}

// IotHubDeviceConnectedEventData event data for Microsoft.Devices.DeviceConnected event.
type IotHubDeviceConnectedEventData struct {
	// DeviceID - The unique identifier of the device. This case-sensitive string can be up to 128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
	DeviceID *string `json:"deviceId,omitempty"`
	// ModuleID - The unique identifier of the module. This case-sensitive string can be up to 128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
	ModuleID *string `json:"moduleId,omitempty"`
	// HubName - Name of the IoT Hub where the device was created or deleted.
	HubName *string `json:"hubName,omitempty"`
	// DeviceConnectionStateEventInfo - Information about the device connection state event.
	DeviceConnectionStateEventInfo *DeviceConnectionStateEventInfo `json:"deviceConnectionStateEventInfo,omitempty"`
}

// IotHubDeviceCreatedEventData event data for Microsoft.Devices.DeviceCreated event.
type IotHubDeviceCreatedEventData struct {
	// DeviceID - The unique identifier of the device. This case-sensitive string can be up to 128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
	DeviceID *string `json:"deviceId,omitempty"`
	// HubName - Name of the IoT Hub where the device was created or deleted.
	HubName *string `json:"hubName,omitempty"`
	// Twin - Information about the device twin, which is the cloud representation of application device metadata.
	Twin *DeviceTwinInfo `json:"twin,omitempty"`
}

// IotHubDeviceDeletedEventData event data for Microsoft.Devices.DeviceDeleted event.
type IotHubDeviceDeletedEventData struct {
	// DeviceID - The unique identifier of the device. This case-sensitive string can be up to 128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
	DeviceID *string `json:"deviceId,omitempty"`
	// HubName - Name of the IoT Hub where the device was created or deleted.
	HubName *string `json:"hubName,omitempty"`
	// Twin - Information about the device twin, which is the cloud representation of application device metadata.
	Twin *DeviceTwinInfo `json:"twin,omitempty"`
}

// IotHubDeviceDisconnectedEventData event data for Microsoft.Devices.DeviceDisconnected event.
type IotHubDeviceDisconnectedEventData struct {
	// DeviceID - The unique identifier of the device. This case-sensitive string can be up to 128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
	DeviceID *string `json:"deviceId,omitempty"`
	// ModuleID - The unique identifier of the module. This case-sensitive string can be up to 128 characters long, and supports ASCII 7-bit alphanumeric characters plus the following special characters: - : . + % _ &#35; * ? ! ( ) , = @ ; $ '.
	ModuleID *string `json:"moduleId,omitempty"`
	// HubName - Name of the IoT Hub where the device was created or deleted.
	HubName *string `json:"hubName,omitempty"`
	// DeviceConnectionStateEventInfo - Information about the device connection state event.
	DeviceConnectionStateEventInfo *DeviceConnectionStateEventInfo `json:"deviceConnectionStateEventInfo,omitempty"`
}

// IotHubDeviceTelemetryEventData event data for Microsoft.Devices.DeviceTelemetry event.
type IotHubDeviceTelemetryEventData struct {
	// Body - The content of the message from the device.
	Body interface{} `json:"body,omitempty"`
	// Properties - Application properties are user-defined strings that can be added to the message. These fields are optional.
	Properties map[string]*string `json:"properties"`
	// SystemProperties - System properties help identify contents and source of the messages.
	SystemProperties map[string]*string `json:"systemProperties"`
}

// MarshalJSON is the custom marshaler for IotHubDeviceTelemetryEventData.
func (ihdted IotHubDeviceTelemetryEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihdted.Body != nil {
		objectMap["body"] = ihdted.Body
	}
	if ihdted.Properties != nil {
		objectMap["properties"] = ihdted.Properties
	}
	if ihdted.SystemProperties != nil {
		objectMap["systemProperties"] = ihdted.SystemProperties
	}
	return json.Marshal(objectMap)
}

// KeyVaultCertificateExpiredEventData schema of the Data property of an EventGridEvent for an
// CertificateExpired event.
type KeyVaultCertificateExpiredEventData struct {
	// ID - The id of the object that triggered this event.
	ID *string `json:"id,omitempty"`
	// VaultName - Key vault name of the object that triggered this event.
	VaultName *string `json:"vaultName,omitempty"`
	// ObjectType - The type of the object that triggered this event
	ObjectType *string `json:"objectType,omitempty"`
	// ObjectName - The name of the object that triggered this event
	ObjectName *string `json:"objectName,omitempty"`
	// Version - The version of the object that triggered this event
	Version *string `json:"version,omitempty"`
	// Nbf - Not before date of the object that triggered this event
	Nbf *float64 `json:"nbf,omitempty"`
	// Exp - The expiration date of the object that triggered this event
	Exp *float64 `json:"exp,omitempty"`
}

// KeyVaultCertificateNearExpiryEventData schema of the Data property of an EventGridEvent for an
// CertificateNearExpiry event.
type KeyVaultCertificateNearExpiryEventData struct {
	// ID - The id of the object that triggered this event.
	ID *string `json:"id,omitempty"`
	// VaultName - Key vault name of the object that triggered this event.
	VaultName *string `json:"vaultName,omitempty"`
	// ObjectType - The type of the object that triggered this event
	ObjectType *string `json:"objectType,omitempty"`
	// ObjectName - The name of the object that triggered this event
	ObjectName *string `json:"objectName,omitempty"`
	// Version - The version of the object that triggered this event
	Version *string `json:"version,omitempty"`
	// Nbf - Not before date of the object that triggered this event
	Nbf *float64 `json:"nbf,omitempty"`
	// Exp - The expiration date of the object that triggered this event
	Exp *float64 `json:"exp,omitempty"`
}

// KeyVaultCertificateNewVersionCreatedEventData schema of the Data property of an EventGridEvent for an
// CertificateNewVersionCreated event.
type KeyVaultCertificateNewVersionCreatedEventData struct {
	// ID - The id of the object that triggered this event.
	ID *string `json:"id,omitempty"`
	// VaultName - Key vault name of the object that triggered this event.
	VaultName *string `json:"vaultName,omitempty"`
	// ObjectType - The type of the object that triggered this event
	ObjectType *string `json:"objectType,omitempty"`
	// ObjectName - The name of the object that triggered this event
	ObjectName *string `json:"objectName,omitempty"`
	// Version - The version of the object that triggered this event
	Version *string `json:"version,omitempty"`
	// Nbf - Not before date of the object that triggered this event
	Nbf *float64 `json:"nbf,omitempty"`
	// Exp - The expiration date of the object that triggered this event
	Exp *float64 `json:"exp,omitempty"`
}

// KeyVaultKeyExpiredEventData schema of the Data property of an EventGridEvent for an KeyExpired event.
type KeyVaultKeyExpiredEventData struct {
	// ID - The id of the object that triggered this event.
	ID *string `json:"id,omitempty"`
	// VaultName - Key vault name of the object that triggered this event.
	VaultName *string `json:"vaultName,omitempty"`
	// ObjectType - The type of the object that triggered this event
	ObjectType *string `json:"objectType,omitempty"`
	// ObjectName - The name of the object that triggered this event
	ObjectName *string `json:"objectName,omitempty"`
	// Version - The version of the object that triggered this event
	Version *string `json:"version,omitempty"`
	// Nbf - Not before date of the object that triggered this event
	Nbf *float64 `json:"nbf,omitempty"`
	// Exp - The expiration date of the object that triggered this event
	Exp *float64 `json:"exp,omitempty"`
}

// KeyVaultKeyNearExpiryEventData schema of the Data property of an EventGridEvent for an KeyNearExpiry
// event.
type KeyVaultKeyNearExpiryEventData struct {
	// ID - The id of the object that triggered this event.
	ID *string `json:"id,omitempty"`
	// VaultName - Key vault name of the object that triggered this event.
	VaultName *string `json:"vaultName,omitempty"`
	// ObjectType - The type of the object that triggered this event
	ObjectType *string `json:"objectType,omitempty"`
	// ObjectName - The name of the object that triggered this event
	ObjectName *string `json:"objectName,omitempty"`
	// Version - The version of the object that triggered this event
	Version *string `json:"version,omitempty"`
	// Nbf - Not before date of the object that triggered this event
	Nbf *float64 `json:"nbf,omitempty"`
	// Exp - The expiration date of the object that triggered this event
	Exp *float64 `json:"exp,omitempty"`
}

// KeyVaultKeyNewVersionCreatedEventData schema of the Data property of an EventGridEvent for an
// KeyNewVersionCreated event.
type KeyVaultKeyNewVersionCreatedEventData struct {
	// ID - The id of the object that triggered this event.
	ID *string `json:"id,omitempty"`
	// VaultName - Key vault name of the object that triggered this event.
	VaultName *string `json:"vaultName,omitempty"`
	// ObjectType - The type of the object that triggered this event
	ObjectType *string `json:"objectType,omitempty"`
	// ObjectName - The name of the object that triggered this event
	ObjectName *string `json:"objectName,omitempty"`
	// Version - The version of the object that triggered this event
	Version *string `json:"version,omitempty"`
	// Nbf - Not before date of the object that triggered this event
	Nbf *float64 `json:"nbf,omitempty"`
	// Exp - The expiration date of the object that triggered this event
	Exp *float64 `json:"exp,omitempty"`
}

// KeyVaultSecretExpiredEventData schema of the Data property of an EventGridEvent for an SecretExpired
// event.
type KeyVaultSecretExpiredEventData struct {
	// ID - The id of the object that triggered this event.
	ID *string `json:"id,omitempty"`
	// VaultName - Key vault name of the object that triggered this event.
	VaultName *string `json:"vaultName,omitempty"`
	// ObjectType - The type of the object that triggered this event
	ObjectType *string `json:"objectType,omitempty"`
	// ObjectName - The name of the object that triggered this event
	ObjectName *string `json:"objectName,omitempty"`
	// Version - The version of the object that triggered this event
	Version *string `json:"version,omitempty"`
	// Nbf - Not before date of the object that triggered this event
	Nbf *float64 `json:"nbf,omitempty"`
	// Exp - The expiration date of the object that triggered this event
	Exp *float64 `json:"exp,omitempty"`
}

// KeyVaultSecretNearExpiryEventData schema of the Data property of an EventGridEvent for an
// SecretNearExpiry event.
type KeyVaultSecretNearExpiryEventData struct {
	// ID - The id of the object that triggered this event.
	ID *string `json:"id,omitempty"`
	// VaultName - Key vault name of the object that triggered this event.
	VaultName *string `json:"vaultName,omitempty"`
	// ObjectType - The type of the object that triggered this event
	ObjectType *string `json:"objectType,omitempty"`
	// ObjectName - The name of the object that triggered this event
	ObjectName *string `json:"objectName,omitempty"`
	// Version - The version of the object that triggered this event
	Version *string `json:"version,omitempty"`
	// Nbf - Not before date of the object that triggered this event
	Nbf *float64 `json:"nbf,omitempty"`
	// Exp - The expiration date of the object that triggered this event
	Exp *float64 `json:"exp,omitempty"`
}

// KeyVaultSecretNewVersionCreatedEventData schema of the Data property of an EventGridEvent for an
// SecretNewVersionCreated event.
type KeyVaultSecretNewVersionCreatedEventData struct {
	// ID - The id of the object that triggered this event.
	ID *string `json:"id,omitempty"`
	// VaultName - Key vault name of the object that triggered this event.
	VaultName *string `json:"vaultName,omitempty"`
	// ObjectType - The type of the object that triggered this event
	ObjectType *string `json:"objectType,omitempty"`
	// ObjectName - The name of the object that triggered this event
	ObjectName *string `json:"objectName,omitempty"`
	// Version - The version of the object that triggered this event
	Version *string `json:"version,omitempty"`
	// Nbf - Not before date of the object that triggered this event
	Nbf *float64 `json:"nbf,omitempty"`
	// Exp - The expiration date of the object that triggered this event
	Exp *float64 `json:"exp,omitempty"`
}

// MachineLearningServicesDatasetDriftDetectedEventData schema of the Data property of an EventGridEvent
// for an Microsoft.MachineLearningServices.DatasetDriftDetected event.
type MachineLearningServicesDatasetDriftDetectedEventData struct {
	// DataDriftID - The ID of the data drift monitor that triggered the event.
	DataDriftID *string `json:"dataDriftId,omitempty"`
	// DataDriftName - The name of the data drift monitor that triggered the event.
	DataDriftName *string `json:"dataDriftName,omitempty"`
	// RunID - The ID of the Run that detected data drift.
	RunID *string `json:"runId,omitempty"`
	// BaseDatasetID - The ID of the base Dataset used to detect drift.
	BaseDatasetID *string `json:"baseDatasetId,omitempty"`
	// TargetDatasetID - The ID of the target Dataset used to detect drift.
	TargetDatasetID *string `json:"targetDatasetId,omitempty"`
	// DriftCoefficient - The coefficient result that triggered the event.
	DriftCoefficient *float64 `json:"driftCoefficient,omitempty"`
	// StartTime - The start time of the target dataset time series that resulted in drift detection.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the target dataset time series that resulted in drift detection.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// MachineLearningServicesModelDeployedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.MachineLearningServices.ModelDeployed event.
type MachineLearningServicesModelDeployedEventData struct {
	// ServiceName - The name of the deployed service.
	ServiceName *string `json:"serviceName,omitempty"`
	// ServiceComputeType - The compute type (e.g. ACI, AKS) of the deployed service.
	ServiceComputeType *string `json:"serviceComputeType,omitempty"`
	// ModelIds - A common separated list of model IDs. The IDs of the models deployed in the service.
	ModelIds *string `json:"modelIds,omitempty"`
	// ServiceTags - The tags of the deployed service.
	ServiceTags interface{} `json:"serviceTags,omitempty"`
	// ServiceProperties - The properties of the deployed service.
	ServiceProperties interface{} `json:"serviceProperties,omitempty"`
}

// MachineLearningServicesModelRegisteredEventData schema of the Data property of an EventGridEvent for an
// Microsoft.MachineLearningServices.ModelRegistered event.
type MachineLearningServicesModelRegisteredEventData struct {
	// ModelName - The name of the model that was registered.
	ModelName *string `json:"modelName,omitempty"`
	// ModelVersion - The version of the model that was registered.
	ModelVersion *string `json:"modelVersion,omitempty"`
	// ModelTags - The tags of the model that was registered.
	ModelTags interface{} `json:"modelTags,omitempty"`
	// ModelProperties - The properties of the model that was registered.
	ModelProperties interface{} `json:"modelProperties,omitempty"`
}

// MachineLearningServicesRunCompletedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.MachineLearningServices.RunCompleted event.
type MachineLearningServicesRunCompletedEventData struct {
	// ExperimentID - The ID of the experiment that the run belongs to.
	ExperimentID *string `json:"experimentId,omitempty"`
	// ExperimentName - The name of the experiment that the run belongs to.
	ExperimentName *string `json:"experimentName,omitempty"`
	// RunID - The ID of the Run that was completed.
	RunID *string `json:"runId,omitempty"`
	// RunType - The Run Type of the completed Run.
	RunType *string `json:"runType,omitempty"`
	// RunTags - The tags of the completed Run.
	RunTags interface{} `json:"runTags,omitempty"`
	// RunProperties - The properties of the completed Run.
	RunProperties interface{} `json:"runProperties,omitempty"`
}

// MachineLearningServicesRunStatusChangedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.MachineLearningServices.RunStatusChanged event.
type MachineLearningServicesRunStatusChangedEventData struct {
	// ExperimentID - The ID of the experiment that the Machine Learning Run belongs to.
	ExperimentID *string `json:"experimentId,omitempty"`
	// ExperimentName - The name of the experiment that the Machine Learning Run belongs to.
	ExperimentName *string `json:"experimentName,omitempty"`
	// RunID - The ID of the Machine Learning Run.
	RunID *string `json:"runId,omitempty"`
	// RunType - The Run Type of the Machine Learning Run.
	RunType *string `json:"runType,omitempty"`
	// RunTags - The tags of the Machine Learning Run.
	RunTags interface{} `json:"runTags,omitempty"`
	// RunProperties - The properties of the Machine Learning Run.
	RunProperties interface{} `json:"runProperties,omitempty"`
	// RunStatus - The status of the Machine Learning Run.
	RunStatus *string `json:"runStatus,omitempty"`
}

// MapsGeofenceEnteredEventData schema of the Data property of an EventGridEvent for a
// Microsoft.Maps.GeofenceEntered event.
type MapsGeofenceEnteredEventData struct {
	// ExpiredGeofenceGeometryID - Lists of the geometry ID of the geofence which is expired relative to the user time in the request.
	ExpiredGeofenceGeometryID *[]string `json:"expiredGeofenceGeometryId,omitempty"`
	// Geometries - Lists the fence geometries that either fully contain the coordinate position or have an overlap with the searchBuffer around the fence.
	Geometries *[]MapsGeofenceGeometry `json:"geometries,omitempty"`
	// InvalidPeriodGeofenceGeometryID - Lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request.
	InvalidPeriodGeofenceGeometryID *[]string `json:"invalidPeriodGeofenceGeometryId,omitempty"`
	// IsEventPublished - True if at least one event is published to the Azure Maps event subscriber, false if no event is published to the Azure Maps event subscriber.
	IsEventPublished *bool `json:"isEventPublished,omitempty"`
}

// MapsGeofenceEventProperties schema of the Data property of an EventGridEvent for a Geofence event
// (GeofenceEntered, GeofenceExited, GeofenceResult).
type MapsGeofenceEventProperties struct {
	// ExpiredGeofenceGeometryID - Lists of the geometry ID of the geofence which is expired relative to the user time in the request.
	ExpiredGeofenceGeometryID *[]string `json:"expiredGeofenceGeometryId,omitempty"`
	// Geometries - Lists the fence geometries that either fully contain the coordinate position or have an overlap with the searchBuffer around the fence.
	Geometries *[]MapsGeofenceGeometry `json:"geometries,omitempty"`
	// InvalidPeriodGeofenceGeometryID - Lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request.
	InvalidPeriodGeofenceGeometryID *[]string `json:"invalidPeriodGeofenceGeometryId,omitempty"`
	// IsEventPublished - True if at least one event is published to the Azure Maps event subscriber, false if no event is published to the Azure Maps event subscriber.
	IsEventPublished *bool `json:"isEventPublished,omitempty"`
}

// MapsGeofenceExitedEventData schema of the Data property of an EventGridEvent for a
// Microsoft.Maps.GeofenceExited event.
type MapsGeofenceExitedEventData struct {
	// ExpiredGeofenceGeometryID - Lists of the geometry ID of the geofence which is expired relative to the user time in the request.
	ExpiredGeofenceGeometryID *[]string `json:"expiredGeofenceGeometryId,omitempty"`
	// Geometries - Lists the fence geometries that either fully contain the coordinate position or have an overlap with the searchBuffer around the fence.
	Geometries *[]MapsGeofenceGeometry `json:"geometries,omitempty"`
	// InvalidPeriodGeofenceGeometryID - Lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request.
	InvalidPeriodGeofenceGeometryID *[]string `json:"invalidPeriodGeofenceGeometryId,omitempty"`
	// IsEventPublished - True if at least one event is published to the Azure Maps event subscriber, false if no event is published to the Azure Maps event subscriber.
	IsEventPublished *bool `json:"isEventPublished,omitempty"`
}

// MapsGeofenceGeometry the geofence geometry.
type MapsGeofenceGeometry struct {
	// DeviceID - ID of the device.
	DeviceID *string `json:"deviceId,omitempty"`
	// Distance - Distance from the coordinate to the closest border of the geofence. Positive means the coordinate is outside of the geofence. If the coordinate is outside of the geofence, but more than the value of searchBuffer away from the closest geofence border, then the value is 999. Negative means the coordinate is inside of the geofence. If the coordinate is inside the polygon, but more than the value of searchBuffer away from the closest geofencing border,then the value is -999. A value of 999 means that there is great confidence the coordinate is well outside the geofence. A value of -999 means that there is great confidence the coordinate is well within the geofence.
	Distance *float64 `json:"distance,omitempty"`
	// GeometryID - The unique ID for the geofence geometry.
	GeometryID *string `json:"geometryId,omitempty"`
	// NearestLat - Latitude of the nearest point of the geometry.
	NearestLat *float64 `json:"nearestLat,omitempty"`
	// NearestLon - Longitude of the nearest point of the geometry.
	NearestLon *float64 `json:"nearestLon,omitempty"`
	// UdID - The unique id returned from user upload service when uploading a geofence. Will not be included in geofencing post API.
	UdID *string `json:"udId,omitempty"`
}

// MapsGeofenceResultEventData schema of the Data property of an EventGridEvent for a
// Microsoft.Maps.GeofenceResult event.
type MapsGeofenceResultEventData struct {
	// ExpiredGeofenceGeometryID - Lists of the geometry ID of the geofence which is expired relative to the user time in the request.
	ExpiredGeofenceGeometryID *[]string `json:"expiredGeofenceGeometryId,omitempty"`
	// Geometries - Lists the fence geometries that either fully contain the coordinate position or have an overlap with the searchBuffer around the fence.
	Geometries *[]MapsGeofenceGeometry `json:"geometries,omitempty"`
	// InvalidPeriodGeofenceGeometryID - Lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request.
	InvalidPeriodGeofenceGeometryID *[]string `json:"invalidPeriodGeofenceGeometryId,omitempty"`
	// IsEventPublished - True if at least one event is published to the Azure Maps event subscriber, false if no event is published to the Azure Maps event subscriber.
	IsEventPublished *bool `json:"isEventPublished,omitempty"`
}

// MediaJobCanceledEventData job canceled event data
type MediaJobCanceledEventData struct {
	// Outputs - Gets the Job outputs.
	Outputs *[]BasicMediaJobOutput `json:"outputs,omitempty"`
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// State - READ-ONLY; The new state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State MediaJobState `json:"state,omitempty"`
	// CorrelationData - Gets the Job correlation data.
	CorrelationData map[string]*string `json:"correlationData"`
}

// MarshalJSON is the custom marshaler for MediaJobCanceledEventData.
func (mjced MediaJobCanceledEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mjced.Outputs != nil {
		objectMap["outputs"] = mjced.Outputs
	}
	if mjced.CorrelationData != nil {
		objectMap["correlationData"] = mjced.CorrelationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MediaJobCanceledEventData struct.
func (mjced *MediaJobCanceledEventData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "outputs":
			if v != nil {
				outputs, err := unmarshalBasicMediaJobOutputArray(*v)
				if err != nil {
					return err
				}
				mjced.Outputs = &outputs
			}
		case "previousState":
			if v != nil {
				var previousState MediaJobState
				err = json.Unmarshal(*v, &previousState)
				if err != nil {
					return err
				}
				mjced.PreviousState = previousState
			}
		case "state":
			if v != nil {
				var state MediaJobState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mjced.State = state
			}
		case "correlationData":
			if v != nil {
				var correlationData map[string]*string
				err = json.Unmarshal(*v, &correlationData)
				if err != nil {
					return err
				}
				mjced.CorrelationData = correlationData
			}
		}
	}

	return nil
}

// MediaJobCancelingEventData job canceling event data
type MediaJobCancelingEventData struct {
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// State - READ-ONLY; The new state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State MediaJobState `json:"state,omitempty"`
	// CorrelationData - Gets the Job correlation data.
	CorrelationData map[string]*string `json:"correlationData"`
}

// MarshalJSON is the custom marshaler for MediaJobCancelingEventData.
func (mjced MediaJobCancelingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mjced.CorrelationData != nil {
		objectMap["correlationData"] = mjced.CorrelationData
	}
	return json.Marshal(objectMap)
}

// MediaJobError details of JobOutput errors.
type MediaJobError struct {
	// Code - READ-ONLY; Error code describing the error. Possible values include: 'ServiceError', 'ServiceTransientError', 'DownloadNotAccessible', 'DownloadTransientError', 'UploadNotAccessible', 'UploadTransientError', 'ConfigurationUnsupported', 'ContentMalformed', 'ContentUnsupported'
	Code MediaJobErrorCode `json:"code,omitempty"`
	// Message - READ-ONLY; A human-readable language-dependent representation of the error.
	Message *string `json:"message,omitempty"`
	// Category - READ-ONLY; Helps with categorization of errors. Possible values include: 'Service', 'Download', 'Upload', 'Configuration', 'Content'
	Category MediaJobErrorCategory `json:"category,omitempty"`
	// Retry - READ-ONLY; Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via Azure Portal. Possible values include: 'DoNotRetry', 'MayRetry'
	Retry MediaJobRetry `json:"retry,omitempty"`
	// Details - READ-ONLY; An array of details about specific errors that led to this reported error.
	Details *[]MediaJobErrorDetail `json:"details,omitempty"`
}

// MediaJobErrorDetail details of JobOutput errors.
type MediaJobErrorDetail struct {
	// Code - READ-ONLY; Code describing the error detail.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A human-readable representation of the error.
	Message *string `json:"message,omitempty"`
}

// MediaJobErroredEventData job error state event data
type MediaJobErroredEventData struct {
	// Outputs - Gets the Job outputs.
	Outputs *[]BasicMediaJobOutput `json:"outputs,omitempty"`
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// State - READ-ONLY; The new state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State MediaJobState `json:"state,omitempty"`
	// CorrelationData - Gets the Job correlation data.
	CorrelationData map[string]*string `json:"correlationData"`
}

// MarshalJSON is the custom marshaler for MediaJobErroredEventData.
func (mjeed MediaJobErroredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mjeed.Outputs != nil {
		objectMap["outputs"] = mjeed.Outputs
	}
	if mjeed.CorrelationData != nil {
		objectMap["correlationData"] = mjeed.CorrelationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MediaJobErroredEventData struct.
func (mjeed *MediaJobErroredEventData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "outputs":
			if v != nil {
				outputs, err := unmarshalBasicMediaJobOutputArray(*v)
				if err != nil {
					return err
				}
				mjeed.Outputs = &outputs
			}
		case "previousState":
			if v != nil {
				var previousState MediaJobState
				err = json.Unmarshal(*v, &previousState)
				if err != nil {
					return err
				}
				mjeed.PreviousState = previousState
			}
		case "state":
			if v != nil {
				var state MediaJobState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mjeed.State = state
			}
		case "correlationData":
			if v != nil {
				var correlationData map[string]*string
				err = json.Unmarshal(*v, &correlationData)
				if err != nil {
					return err
				}
				mjeed.CorrelationData = correlationData
			}
		}
	}

	return nil
}

// MediaJobFinishedEventData job finished event data
type MediaJobFinishedEventData struct {
	// Outputs - Gets the Job outputs.
	Outputs *[]BasicMediaJobOutput `json:"outputs,omitempty"`
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// State - READ-ONLY; The new state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State MediaJobState `json:"state,omitempty"`
	// CorrelationData - Gets the Job correlation data.
	CorrelationData map[string]*string `json:"correlationData"`
}

// MarshalJSON is the custom marshaler for MediaJobFinishedEventData.
func (mjfed MediaJobFinishedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mjfed.Outputs != nil {
		objectMap["outputs"] = mjfed.Outputs
	}
	if mjfed.CorrelationData != nil {
		objectMap["correlationData"] = mjfed.CorrelationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MediaJobFinishedEventData struct.
func (mjfed *MediaJobFinishedEventData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "outputs":
			if v != nil {
				outputs, err := unmarshalBasicMediaJobOutputArray(*v)
				if err != nil {
					return err
				}
				mjfed.Outputs = &outputs
			}
		case "previousState":
			if v != nil {
				var previousState MediaJobState
				err = json.Unmarshal(*v, &previousState)
				if err != nil {
					return err
				}
				mjfed.PreviousState = previousState
			}
		case "state":
			if v != nil {
				var state MediaJobState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mjfed.State = state
			}
		case "correlationData":
			if v != nil {
				var correlationData map[string]*string
				err = json.Unmarshal(*v, &correlationData)
				if err != nil {
					return err
				}
				mjfed.CorrelationData = correlationData
			}
		}
	}

	return nil
}

// BasicMediaJobOutput the event data for a Job output.
type BasicMediaJobOutput interface {
	AsMediaJobOutputAsset() (*MediaJobOutputAsset, bool)
	AsMediaJobOutput() (*MediaJobOutput, bool)
}

// MediaJobOutput the event data for a Job output.
type MediaJobOutput struct {
	// Error - Gets the Job output error.
	Error *MediaJobError `json:"error,omitempty"`
	// Label - Gets the Job output label.
	Label *string `json:"label,omitempty"`
	// Progress - Gets the Job output progress.
	Progress *int64 `json:"progress,omitempty"`
	// State - Gets the Job output state. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State MediaJobState `json:"state,omitempty"`
	// OdataType - Possible values include: 'OdataTypeMediaJobOutput', 'OdataTypeMicrosoftMediaJobOutputAsset'
	OdataType OdataType `json:"@odata.type,omitempty"`
}

func unmarshalBasicMediaJobOutput(body []byte) (BasicMediaJobOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaJobOutputAsset):
		var mjoa MediaJobOutputAsset
		err := json.Unmarshal(body, &mjoa)
		return mjoa, err
	default:
		var mjo MediaJobOutput
		err := json.Unmarshal(body, &mjo)
		return mjo, err
	}
}
func unmarshalBasicMediaJobOutputArray(body []byte) ([]BasicMediaJobOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mjoArray := make([]BasicMediaJobOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mjo, err := unmarshalBasicMediaJobOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		mjoArray[index] = mjo
	}
	return mjoArray, nil
}

// MarshalJSON is the custom marshaler for MediaJobOutput.
func (mjo MediaJobOutput) MarshalJSON() ([]byte, error) {
	mjo.OdataType = OdataTypeMediaJobOutput
	objectMap := make(map[string]interface{})
	if mjo.Error != nil {
		objectMap["error"] = mjo.Error
	}
	if mjo.Label != nil {
		objectMap["label"] = mjo.Label
	}
	if mjo.Progress != nil {
		objectMap["progress"] = mjo.Progress
	}
	if mjo.State != "" {
		objectMap["state"] = mjo.State
	}
	if mjo.OdataType != "" {
		objectMap["@odata.type"] = mjo.OdataType
	}
	return json.Marshal(objectMap)
}

// AsMediaJobOutputAsset is the BasicMediaJobOutput implementation for MediaJobOutput.
func (mjo MediaJobOutput) AsMediaJobOutputAsset() (*MediaJobOutputAsset, bool) {
	return nil, false
}

// AsMediaJobOutput is the BasicMediaJobOutput implementation for MediaJobOutput.
func (mjo MediaJobOutput) AsMediaJobOutput() (*MediaJobOutput, bool) {
	return &mjo, true
}

// AsBasicMediaJobOutput is the BasicMediaJobOutput implementation for MediaJobOutput.
func (mjo MediaJobOutput) AsBasicMediaJobOutput() (BasicMediaJobOutput, bool) {
	return &mjo, true
}

// MediaJobOutputAsset the event data for a Job output asset.
type MediaJobOutputAsset struct {
	// AssetName - Gets the Job output asset name.
	AssetName *string `json:"assetName,omitempty"`
	// Error - Gets the Job output error.
	Error *MediaJobError `json:"error,omitempty"`
	// Label - Gets the Job output label.
	Label *string `json:"label,omitempty"`
	// Progress - Gets the Job output progress.
	Progress *int64 `json:"progress,omitempty"`
	// State - Gets the Job output state. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State MediaJobState `json:"state,omitempty"`
	// OdataType - Possible values include: 'OdataTypeMediaJobOutput', 'OdataTypeMicrosoftMediaJobOutputAsset'
	OdataType OdataType `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for MediaJobOutputAsset.
func (mjoa MediaJobOutputAsset) MarshalJSON() ([]byte, error) {
	mjoa.OdataType = OdataTypeMicrosoftMediaJobOutputAsset
	objectMap := make(map[string]interface{})
	if mjoa.AssetName != nil {
		objectMap["assetName"] = mjoa.AssetName
	}
	if mjoa.Error != nil {
		objectMap["error"] = mjoa.Error
	}
	if mjoa.Label != nil {
		objectMap["label"] = mjoa.Label
	}
	if mjoa.Progress != nil {
		objectMap["progress"] = mjoa.Progress
	}
	if mjoa.State != "" {
		objectMap["state"] = mjoa.State
	}
	if mjoa.OdataType != "" {
		objectMap["@odata.type"] = mjoa.OdataType
	}
	return json.Marshal(objectMap)
}

// AsMediaJobOutputAsset is the BasicMediaJobOutput implementation for MediaJobOutputAsset.
func (mjoa MediaJobOutputAsset) AsMediaJobOutputAsset() (*MediaJobOutputAsset, bool) {
	return &mjoa, true
}

// AsMediaJobOutput is the BasicMediaJobOutput implementation for MediaJobOutputAsset.
func (mjoa MediaJobOutputAsset) AsMediaJobOutput() (*MediaJobOutput, bool) {
	return nil, false
}

// AsBasicMediaJobOutput is the BasicMediaJobOutput implementation for MediaJobOutputAsset.
func (mjoa MediaJobOutputAsset) AsBasicMediaJobOutput() (BasicMediaJobOutput, bool) {
	return &mjoa, true
}

// MediaJobOutputCanceledEventData job output canceled event data
type MediaJobOutputCanceledEventData struct {
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// Output - Gets the output.
	Output BasicMediaJobOutput `json:"output,omitempty"`
	// JobCorrelationData - Gets the Job correlation data.
	JobCorrelationData map[string]*string `json:"jobCorrelationData"`
}

// MarshalJSON is the custom marshaler for MediaJobOutputCanceledEventData.
func (mjoced MediaJobOutputCanceledEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["output"] = mjoced.Output
	if mjoced.JobCorrelationData != nil {
		objectMap["jobCorrelationData"] = mjoced.JobCorrelationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MediaJobOutputCanceledEventData struct.
func (mjoced *MediaJobOutputCanceledEventData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "previousState":
			if v != nil {
				var previousState MediaJobState
				err = json.Unmarshal(*v, &previousState)
				if err != nil {
					return err
				}
				mjoced.PreviousState = previousState
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMediaJobOutput(*v)
				if err != nil {
					return err
				}
				mjoced.Output = output
			}
		case "jobCorrelationData":
			if v != nil {
				var jobCorrelationData map[string]*string
				err = json.Unmarshal(*v, &jobCorrelationData)
				if err != nil {
					return err
				}
				mjoced.JobCorrelationData = jobCorrelationData
			}
		}
	}

	return nil
}

// MediaJobOutputCancelingEventData job output canceling event data
type MediaJobOutputCancelingEventData struct {
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// Output - Gets the output.
	Output BasicMediaJobOutput `json:"output,omitempty"`
	// JobCorrelationData - Gets the Job correlation data.
	JobCorrelationData map[string]*string `json:"jobCorrelationData"`
}

// MarshalJSON is the custom marshaler for MediaJobOutputCancelingEventData.
func (mjoced MediaJobOutputCancelingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["output"] = mjoced.Output
	if mjoced.JobCorrelationData != nil {
		objectMap["jobCorrelationData"] = mjoced.JobCorrelationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MediaJobOutputCancelingEventData struct.
func (mjoced *MediaJobOutputCancelingEventData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "previousState":
			if v != nil {
				var previousState MediaJobState
				err = json.Unmarshal(*v, &previousState)
				if err != nil {
					return err
				}
				mjoced.PreviousState = previousState
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMediaJobOutput(*v)
				if err != nil {
					return err
				}
				mjoced.Output = output
			}
		case "jobCorrelationData":
			if v != nil {
				var jobCorrelationData map[string]*string
				err = json.Unmarshal(*v, &jobCorrelationData)
				if err != nil {
					return err
				}
				mjoced.JobCorrelationData = jobCorrelationData
			}
		}
	}

	return nil
}

// MediaJobOutputErroredEventData job output error event data
type MediaJobOutputErroredEventData struct {
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// Output - Gets the output.
	Output BasicMediaJobOutput `json:"output,omitempty"`
	// JobCorrelationData - Gets the Job correlation data.
	JobCorrelationData map[string]*string `json:"jobCorrelationData"`
}

// MarshalJSON is the custom marshaler for MediaJobOutputErroredEventData.
func (mjoeed MediaJobOutputErroredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["output"] = mjoeed.Output
	if mjoeed.JobCorrelationData != nil {
		objectMap["jobCorrelationData"] = mjoeed.JobCorrelationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MediaJobOutputErroredEventData struct.
func (mjoeed *MediaJobOutputErroredEventData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "previousState":
			if v != nil {
				var previousState MediaJobState
				err = json.Unmarshal(*v, &previousState)
				if err != nil {
					return err
				}
				mjoeed.PreviousState = previousState
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMediaJobOutput(*v)
				if err != nil {
					return err
				}
				mjoeed.Output = output
			}
		case "jobCorrelationData":
			if v != nil {
				var jobCorrelationData map[string]*string
				err = json.Unmarshal(*v, &jobCorrelationData)
				if err != nil {
					return err
				}
				mjoeed.JobCorrelationData = jobCorrelationData
			}
		}
	}

	return nil
}

// MediaJobOutputFinishedEventData job output finished event data
type MediaJobOutputFinishedEventData struct {
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// Output - Gets the output.
	Output BasicMediaJobOutput `json:"output,omitempty"`
	// JobCorrelationData - Gets the Job correlation data.
	JobCorrelationData map[string]*string `json:"jobCorrelationData"`
}

// MarshalJSON is the custom marshaler for MediaJobOutputFinishedEventData.
func (mjofed MediaJobOutputFinishedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["output"] = mjofed.Output
	if mjofed.JobCorrelationData != nil {
		objectMap["jobCorrelationData"] = mjofed.JobCorrelationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MediaJobOutputFinishedEventData struct.
func (mjofed *MediaJobOutputFinishedEventData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "previousState":
			if v != nil {
				var previousState MediaJobState
				err = json.Unmarshal(*v, &previousState)
				if err != nil {
					return err
				}
				mjofed.PreviousState = previousState
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMediaJobOutput(*v)
				if err != nil {
					return err
				}
				mjofed.Output = output
			}
		case "jobCorrelationData":
			if v != nil {
				var jobCorrelationData map[string]*string
				err = json.Unmarshal(*v, &jobCorrelationData)
				if err != nil {
					return err
				}
				mjofed.JobCorrelationData = jobCorrelationData
			}
		}
	}

	return nil
}

// MediaJobOutputProcessingEventData job output processing event data
type MediaJobOutputProcessingEventData struct {
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// Output - Gets the output.
	Output BasicMediaJobOutput `json:"output,omitempty"`
	// JobCorrelationData - Gets the Job correlation data.
	JobCorrelationData map[string]*string `json:"jobCorrelationData"`
}

// MarshalJSON is the custom marshaler for MediaJobOutputProcessingEventData.
func (mjoped MediaJobOutputProcessingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["output"] = mjoped.Output
	if mjoped.JobCorrelationData != nil {
		objectMap["jobCorrelationData"] = mjoped.JobCorrelationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MediaJobOutputProcessingEventData struct.
func (mjoped *MediaJobOutputProcessingEventData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "previousState":
			if v != nil {
				var previousState MediaJobState
				err = json.Unmarshal(*v, &previousState)
				if err != nil {
					return err
				}
				mjoped.PreviousState = previousState
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMediaJobOutput(*v)
				if err != nil {
					return err
				}
				mjoped.Output = output
			}
		case "jobCorrelationData":
			if v != nil {
				var jobCorrelationData map[string]*string
				err = json.Unmarshal(*v, &jobCorrelationData)
				if err != nil {
					return err
				}
				mjoped.JobCorrelationData = jobCorrelationData
			}
		}
	}

	return nil
}

// MediaJobOutputProgressEventData job Output Progress Event Data.
type MediaJobOutputProgressEventData struct {
	// Label - Gets the Job output label.
	Label *string `json:"label,omitempty"`
	// Progress - Gets the Job output progress.
	Progress *int64 `json:"progress,omitempty"`
	// JobCorrelationData - Gets the Job correlation data.
	JobCorrelationData map[string]*string `json:"jobCorrelationData"`
}

// MarshalJSON is the custom marshaler for MediaJobOutputProgressEventData.
func (mjoped MediaJobOutputProgressEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mjoped.Label != nil {
		objectMap["label"] = mjoped.Label
	}
	if mjoped.Progress != nil {
		objectMap["progress"] = mjoped.Progress
	}
	if mjoped.JobCorrelationData != nil {
		objectMap["jobCorrelationData"] = mjoped.JobCorrelationData
	}
	return json.Marshal(objectMap)
}

// MediaJobOutputScheduledEventData job output scheduled event data
type MediaJobOutputScheduledEventData struct {
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// Output - Gets the output.
	Output BasicMediaJobOutput `json:"output,omitempty"`
	// JobCorrelationData - Gets the Job correlation data.
	JobCorrelationData map[string]*string `json:"jobCorrelationData"`
}

// MarshalJSON is the custom marshaler for MediaJobOutputScheduledEventData.
func (mjosed MediaJobOutputScheduledEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["output"] = mjosed.Output
	if mjosed.JobCorrelationData != nil {
		objectMap["jobCorrelationData"] = mjosed.JobCorrelationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MediaJobOutputScheduledEventData struct.
func (mjosed *MediaJobOutputScheduledEventData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "previousState":
			if v != nil {
				var previousState MediaJobState
				err = json.Unmarshal(*v, &previousState)
				if err != nil {
					return err
				}
				mjosed.PreviousState = previousState
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMediaJobOutput(*v)
				if err != nil {
					return err
				}
				mjosed.Output = output
			}
		case "jobCorrelationData":
			if v != nil {
				var jobCorrelationData map[string]*string
				err = json.Unmarshal(*v, &jobCorrelationData)
				if err != nil {
					return err
				}
				mjosed.JobCorrelationData = jobCorrelationData
			}
		}
	}

	return nil
}

// MediaJobOutputStateChangeEventData schema of the Data property of an EventGridEvent for a
// Microsoft.Media.JobOutputStateChange event.
type MediaJobOutputStateChangeEventData struct {
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// Output - Gets the output.
	Output BasicMediaJobOutput `json:"output,omitempty"`
	// JobCorrelationData - Gets the Job correlation data.
	JobCorrelationData map[string]*string `json:"jobCorrelationData"`
}

// MarshalJSON is the custom marshaler for MediaJobOutputStateChangeEventData.
func (mjosced MediaJobOutputStateChangeEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["output"] = mjosced.Output
	if mjosced.JobCorrelationData != nil {
		objectMap["jobCorrelationData"] = mjosced.JobCorrelationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MediaJobOutputStateChangeEventData struct.
func (mjosced *MediaJobOutputStateChangeEventData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "previousState":
			if v != nil {
				var previousState MediaJobState
				err = json.Unmarshal(*v, &previousState)
				if err != nil {
					return err
				}
				mjosced.PreviousState = previousState
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMediaJobOutput(*v)
				if err != nil {
					return err
				}
				mjosced.Output = output
			}
		case "jobCorrelationData":
			if v != nil {
				var jobCorrelationData map[string]*string
				err = json.Unmarshal(*v, &jobCorrelationData)
				if err != nil {
					return err
				}
				mjosced.JobCorrelationData = jobCorrelationData
			}
		}
	}

	return nil
}

// MediaJobProcessingEventData job processing event data
type MediaJobProcessingEventData struct {
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// State - READ-ONLY; The new state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State MediaJobState `json:"state,omitempty"`
	// CorrelationData - Gets the Job correlation data.
	CorrelationData map[string]*string `json:"correlationData"`
}

// MarshalJSON is the custom marshaler for MediaJobProcessingEventData.
func (mjped MediaJobProcessingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mjped.CorrelationData != nil {
		objectMap["correlationData"] = mjped.CorrelationData
	}
	return json.Marshal(objectMap)
}

// MediaJobScheduledEventData job scheduled event data
type MediaJobScheduledEventData struct {
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// State - READ-ONLY; The new state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State MediaJobState `json:"state,omitempty"`
	// CorrelationData - Gets the Job correlation data.
	CorrelationData map[string]*string `json:"correlationData"`
}

// MarshalJSON is the custom marshaler for MediaJobScheduledEventData.
func (mjsed MediaJobScheduledEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mjsed.CorrelationData != nil {
		objectMap["correlationData"] = mjsed.CorrelationData
	}
	return json.Marshal(objectMap)
}

// MediaJobStateChangeEventData schema of the Data property of an EventGridEvent for a
// Microsoft.Media.JobStateChange event.
type MediaJobStateChangeEventData struct {
	// PreviousState - READ-ONLY; The previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	PreviousState MediaJobState `json:"previousState,omitempty"`
	// State - READ-ONLY; The new state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State MediaJobState `json:"state,omitempty"`
	// CorrelationData - Gets the Job correlation data.
	CorrelationData map[string]*string `json:"correlationData"`
}

// MarshalJSON is the custom marshaler for MediaJobStateChangeEventData.
func (mjsced MediaJobStateChangeEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mjsced.CorrelationData != nil {
		objectMap["correlationData"] = mjsced.CorrelationData
	}
	return json.Marshal(objectMap)
}

// MediaLiveEventConnectionRejectedEventData encoder connection rejected event data.
type MediaLiveEventConnectionRejectedEventData struct {
	// IngestURL - READ-ONLY; Gets the ingest URL provided by the live event.
	IngestURL *string `json:"ingestUrl,omitempty"`
	// StreamID - READ-ONLY; Gets the stream Id.
	StreamID *string `json:"streamId,omitempty"`
	// EncoderIP - READ-ONLY; Gets the remote IP.
	EncoderIP *string `json:"encoderIp,omitempty"`
	// EncoderPort - READ-ONLY; Gets the remote port.
	EncoderPort *string `json:"encoderPort,omitempty"`
	// ResultCode - READ-ONLY; Gets the result code.
	ResultCode *string `json:"resultCode,omitempty"`
}

// MediaLiveEventEncoderConnectedEventData encoder connect event data.
type MediaLiveEventEncoderConnectedEventData struct {
	// IngestURL - READ-ONLY; Gets the ingest URL provided by the live event.
	IngestURL *string `json:"ingestUrl,omitempty"`
	// StreamID - READ-ONLY; Gets the stream Id.
	StreamID *string `json:"streamId,omitempty"`
	// EncoderIP - READ-ONLY; Gets the remote IP.
	EncoderIP *string `json:"encoderIp,omitempty"`
	// EncoderPort - READ-ONLY; Gets the remote port.
	EncoderPort *string `json:"encoderPort,omitempty"`
}

// MediaLiveEventEncoderDisconnectedEventData encoder disconnected event data.
type MediaLiveEventEncoderDisconnectedEventData struct {
	// IngestURL - READ-ONLY; Gets the ingest URL provided by the live event.
	IngestURL *string `json:"ingestUrl,omitempty"`
	// StreamID - READ-ONLY; Gets the stream Id.
	StreamID *string `json:"streamId,omitempty"`
	// EncoderIP - READ-ONLY; Gets the remote IP.
	EncoderIP *string `json:"encoderIp,omitempty"`
	// EncoderPort - READ-ONLY; Gets the remote port.
	EncoderPort *string `json:"encoderPort,omitempty"`
	// ResultCode - READ-ONLY; Gets the result code.
	ResultCode *string `json:"resultCode,omitempty"`
}

// MediaLiveEventIncomingDataChunkDroppedEventData ingest fragment dropped event data.
type MediaLiveEventIncomingDataChunkDroppedEventData struct {
	// Timestamp - READ-ONLY; Gets the timestamp of the data chunk dropped.
	Timestamp *string `json:"timestamp,omitempty"`
	// TrackType - READ-ONLY; Gets the type of the track (Audio / Video).
	TrackType *string `json:"trackType,omitempty"`
	// Bitrate - READ-ONLY; Gets the bitrate of the track.
	Bitrate *int64 `json:"bitrate,omitempty"`
	// Timescale - READ-ONLY; Gets the timescale of the Timestamp.
	Timescale *string `json:"timescale,omitempty"`
	// ResultCode - READ-ONLY; Gets the result code for fragment drop operation.
	ResultCode *string `json:"resultCode,omitempty"`
	// TrackName - READ-ONLY; Gets the name of the track for which fragment is dropped.
	TrackName *string `json:"trackName,omitempty"`
}

// MediaLiveEventIncomingStreamReceivedEventData encoder connect event data.
type MediaLiveEventIncomingStreamReceivedEventData struct {
	// IngestURL - READ-ONLY; Gets the ingest URL provided by the live event.
	IngestURL *string `json:"ingestUrl,omitempty"`
	// TrackType - READ-ONLY; Gets the type of the track (Audio / Video).
	TrackType *string `json:"trackType,omitempty"`
	// TrackName - READ-ONLY; Gets the track name.
	TrackName *string `json:"trackName,omitempty"`
	// Bitrate - READ-ONLY; Gets the bitrate of the track.
	Bitrate *int64 `json:"bitrate,omitempty"`
	// EncoderIP - READ-ONLY; Gets the remote IP.
	EncoderIP *string `json:"encoderIp,omitempty"`
	// EncoderPort - READ-ONLY; Gets the remote port.
	EncoderPort *string `json:"encoderPort,omitempty"`
	// Timestamp - READ-ONLY; Gets the first timestamp of the data chunk received.
	Timestamp *string `json:"timestamp,omitempty"`
	// Duration - READ-ONLY; Gets the duration of the first data chunk.
	Duration *string `json:"duration,omitempty"`
	// Timescale - READ-ONLY; Gets the timescale in which timestamp is represented.
	Timescale *string `json:"timescale,omitempty"`
}

// MediaLiveEventIncomingStreamsOutOfSyncEventData incoming streams out of sync event data.
type MediaLiveEventIncomingStreamsOutOfSyncEventData struct {
	// MinLastTimestamp - READ-ONLY; Gets the minimum last timestamp received.
	MinLastTimestamp *string `json:"minLastTimestamp,omitempty"`
	// TypeOfStreamWithMinLastTimestamp - READ-ONLY; Gets the type of stream with minimum last timestamp.
	TypeOfStreamWithMinLastTimestamp *string `json:"typeOfStreamWithMinLastTimestamp,omitempty"`
	// MaxLastTimestamp - READ-ONLY; Gets the maximum timestamp among all the tracks (audio or video).
	MaxLastTimestamp *string `json:"maxLastTimestamp,omitempty"`
	// TypeOfStreamWithMaxLastTimestamp - READ-ONLY; Gets the type of stream with maximum last timestamp.
	TypeOfStreamWithMaxLastTimestamp *string `json:"typeOfStreamWithMaxLastTimestamp,omitempty"`
	// TimescaleOfMinLastTimestamp - READ-ONLY; Gets the timescale in which "MinLastTimestamp" is represented.
	TimescaleOfMinLastTimestamp *string `json:"timescaleOfMinLastTimestamp,omitempty"`
	// TimescaleOfMaxLastTimestamp - READ-ONLY; Gets the timescale in which "MaxLastTimestamp" is represented.
	TimescaleOfMaxLastTimestamp *string `json:"timescaleOfMaxLastTimestamp,omitempty"`
}

// MediaLiveEventIncomingVideoStreamsOutOfSyncEventData incoming video stream out of synch event data.
type MediaLiveEventIncomingVideoStreamsOutOfSyncEventData struct {
	// FirstTimestamp - READ-ONLY; Gets the first timestamp received for one of the quality levels.
	FirstTimestamp *string `json:"firstTimestamp,omitempty"`
	// FirstDuration - READ-ONLY; Gets the duration of the data chunk with first timestamp.
	FirstDuration *string `json:"firstDuration,omitempty"`
	// SecondTimestamp - READ-ONLY; Gets the timestamp received for some other quality levels.
	SecondTimestamp *string `json:"secondTimestamp,omitempty"`
	// SecondDuration - READ-ONLY; Gets the duration of the data chunk with second timestamp.
	SecondDuration *string `json:"secondDuration,omitempty"`
	// Timescale - READ-ONLY; Gets the timescale in which both the timestamps and durations are represented.
	Timescale *string `json:"timescale,omitempty"`
}

// MediaLiveEventIngestHeartbeatEventData ingest fragment dropped event data.
type MediaLiveEventIngestHeartbeatEventData struct {
	// TrackType - READ-ONLY; Gets the type of the track (Audio / Video).
	TrackType *string `json:"trackType,omitempty"`
	// TrackName - READ-ONLY; Gets the track name.
	TrackName *string `json:"trackName,omitempty"`
	// Bitrate - READ-ONLY; Gets the bitrate of the track.
	Bitrate *int64 `json:"bitrate,omitempty"`
	// IncomingBitrate - READ-ONLY; Gets the incoming bitrate.
	IncomingBitrate *int64 `json:"incomingBitrate,omitempty"`
	// LastTimestamp - READ-ONLY; Gets the last timestamp.
	LastTimestamp *string `json:"lastTimestamp,omitempty"`
	// Timescale - READ-ONLY; Gets the timescale of the last timestamp.
	Timescale *string `json:"timescale,omitempty"`
	// OverlapCount - READ-ONLY; Gets the fragment Overlap count.
	OverlapCount *int64 `json:"overlapCount,omitempty"`
	// DiscontinuityCount - READ-ONLY; Gets the fragment Discontinuity count.
	DiscontinuityCount *int64 `json:"discontinuityCount,omitempty"`
	// NonincreasingCount - READ-ONLY; Gets Non increasing count.
	NonincreasingCount *int64 `json:"nonincreasingCount,omitempty"`
	// UnexpectedBitrate - READ-ONLY; Gets a value indicating whether unexpected bitrate is present or not.
	UnexpectedBitrate *bool `json:"unexpectedBitrate,omitempty"`
	// State - READ-ONLY; Gets the state of the live event.
	State *string `json:"state,omitempty"`
	// Healthy - READ-ONLY; Gets a value indicating whether preview is healthy or not.
	Healthy *bool `json:"healthy,omitempty"`
}

// MediaLiveEventTrackDiscontinuityDetectedEventData ingest track discontinuity detected event data.
type MediaLiveEventTrackDiscontinuityDetectedEventData struct {
	// TrackType - READ-ONLY; Gets the type of the track (Audio / Video).
	TrackType *string `json:"trackType,omitempty"`
	// TrackName - READ-ONLY; Gets the track name.
	TrackName *string `json:"trackName,omitempty"`
	// Bitrate - READ-ONLY; Gets the bitrate.
	Bitrate *int64 `json:"bitrate,omitempty"`
	// PreviousTimestamp - READ-ONLY; Gets the timestamp of the previous fragment.
	PreviousTimestamp *string `json:"previousTimestamp,omitempty"`
	// NewTimestamp - READ-ONLY; Gets the timestamp of the current fragment.
	NewTimestamp *string `json:"newTimestamp,omitempty"`
	// Timescale - READ-ONLY; Gets the timescale in which both timestamps and discontinuity gap are represented.
	Timescale *string `json:"timescale,omitempty"`
	// DiscontinuityGap - READ-ONLY; Gets the discontinuity gap between PreviousTimestamp and NewTimestamp.
	DiscontinuityGap *string `json:"discontinuityGap,omitempty"`
}

// RedisExportRDBCompletedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Cache.ExportRDBCompleted event.
type RedisExportRDBCompletedEventData struct {
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Name - The name of this event.
	Name *string `json:"name,omitempty"`
	// Status - The status of this event. Failed or  succeeded
	Status *string `json:"status,omitempty"`
}

// RedisImportRDBCompletedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Cache.ImportRDBCompleted event.
type RedisImportRDBCompletedEventData struct {
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Name - The name of this event.
	Name *string `json:"name,omitempty"`
	// Status - The status of this event. Failed or  succeeded
	Status *string `json:"status,omitempty"`
}

// RedisPatchingCompletedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Cache.PatchingCompleted event.
type RedisPatchingCompletedEventData struct {
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Name - The name of this event.
	Name *string `json:"name,omitempty"`
	// Status - The status of this event. Failed or  succeeded
	Status *string `json:"status,omitempty"`
}

// RedisScalingCompletedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Cache.ScalingCompleted event.
type RedisScalingCompletedEventData struct {
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Name - The name of this event.
	Name *string `json:"name,omitempty"`
	// Status - The status of this event. Failed or  succeeded
	Status *string `json:"status,omitempty"`
}

// ResourceActionCancelData schema of the Data property of an EventGridEvent for an
// Microsoft.Resources.ResourceActionCancel event. This is raised when a resource action operation is
// canceled.
type ResourceActionCancelData struct {
	// TenantID - The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - The subscription ID of the resource.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The resource group of the resource.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ResourceProvider - The resource provider performing the operation.
	ResourceProvider *string `json:"resourceProvider,omitempty"`
	// ResourceURI - The URI of the resource in the operation.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OperationName - The operation that was performed.
	OperationName *string `json:"operationName,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Authorization - The requested authorization for the operation.
	Authorization *string `json:"authorization,omitempty"`
	// Claims - The properties of the claims.
	Claims *string `json:"claims,omitempty"`
	// CorrelationID - An operation ID used for troubleshooting.
	CorrelationID *string `json:"correlationId,omitempty"`
	// HTTPRequest - The details of the operation.
	HTTPRequest *string `json:"httpRequest,omitempty"`
}

// ResourceActionFailureData schema of the Data property of an EventGridEvent for a
// Microsoft.Resources.ResourceActionFailure event. This is raised when a resource action operation fails.
type ResourceActionFailureData struct {
	// TenantID - The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - The subscription ID of the resource.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The resource group of the resource.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ResourceProvider - The resource provider performing the operation.
	ResourceProvider *string `json:"resourceProvider,omitempty"`
	// ResourceURI - The URI of the resource in the operation.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OperationName - The operation that was performed.
	OperationName *string `json:"operationName,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Authorization - The requested authorization for the operation.
	Authorization *string `json:"authorization,omitempty"`
	// Claims - The properties of the claims.
	Claims *string `json:"claims,omitempty"`
	// CorrelationID - An operation ID used for troubleshooting.
	CorrelationID *string `json:"correlationId,omitempty"`
	// HTTPRequest - The details of the operation.
	HTTPRequest *string `json:"httpRequest,omitempty"`
}

// ResourceActionSuccessData schema of the Data property of an EventGridEvent for a
// Microsoft.Resources.ResourceActionSuccess event. This is raised when a resource action operation
// succeeds.
type ResourceActionSuccessData struct {
	// TenantID - The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - The subscription ID of the resource.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The resource group of the resource.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ResourceProvider - The resource provider performing the operation.
	ResourceProvider *string `json:"resourceProvider,omitempty"`
	// ResourceURI - The URI of the resource in the operation.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OperationName - The operation that was performed.
	OperationName *string `json:"operationName,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Authorization - The requested authorization for the operation.
	Authorization *string `json:"authorization,omitempty"`
	// Claims - The properties of the claims.
	Claims *string `json:"claims,omitempty"`
	// CorrelationID - An operation ID used for troubleshooting.
	CorrelationID *string `json:"correlationId,omitempty"`
	// HTTPRequest - The details of the operation.
	HTTPRequest *string `json:"httpRequest,omitempty"`
}

// ResourceDeleteCancelData schema of the Data property of an EventGridEvent for an
// Microsoft.Resources.ResourceDeleteCancel event. This is raised when a resource delete operation is
// canceled.
type ResourceDeleteCancelData struct {
	// TenantID - The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - The subscription ID of the resource.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The resource group of the resource.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ResourceProvider - The resource provider performing the operation.
	ResourceProvider *string `json:"resourceProvider,omitempty"`
	// ResourceURI - The URI of the resource in the operation.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OperationName - The operation that was performed.
	OperationName *string `json:"operationName,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Authorization - The requested authorization for the operation.
	Authorization *string `json:"authorization,omitempty"`
	// Claims - The properties of the claims.
	Claims *string `json:"claims,omitempty"`
	// CorrelationID - An operation ID used for troubleshooting.
	CorrelationID *string `json:"correlationId,omitempty"`
	// HTTPRequest - The details of the operation.
	HTTPRequest *string `json:"httpRequest,omitempty"`
}

// ResourceDeleteFailureData schema of the Data property of an EventGridEvent for a
// Microsoft.Resources.ResourceDeleteFailure event. This is raised when a resource delete operation fails.
type ResourceDeleteFailureData struct {
	// TenantID - The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - The subscription ID of the resource.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The resource group of the resource.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ResourceProvider - The resource provider performing the operation.
	ResourceProvider *string `json:"resourceProvider,omitempty"`
	// ResourceURI - The URI of the resource in the operation.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OperationName - The operation that was performed.
	OperationName *string `json:"operationName,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Authorization - The requested authorization for the operation.
	Authorization *string `json:"authorization,omitempty"`
	// Claims - The properties of the claims.
	Claims *string `json:"claims,omitempty"`
	// CorrelationID - An operation ID used for troubleshooting.
	CorrelationID *string `json:"correlationId,omitempty"`
	// HTTPRequest - The details of the operation.
	HTTPRequest *string `json:"httpRequest,omitempty"`
}

// ResourceDeleteSuccessData schema of the Data property of an EventGridEvent for a
// Microsoft.Resources.ResourceDeleteSuccess event. This is raised when a resource delete operation
// succeeds.
type ResourceDeleteSuccessData struct {
	// TenantID - The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - The subscription ID of the resource.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The resource group of the resource.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ResourceProvider - The resource provider performing the operation.
	ResourceProvider *string `json:"resourceProvider,omitempty"`
	// ResourceURI - The URI of the resource in the operation.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OperationName - The operation that was performed.
	OperationName *string `json:"operationName,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Authorization - The requested authorization for the operation.
	Authorization *string `json:"authorization,omitempty"`
	// Claims - The properties of the claims.
	Claims *string `json:"claims,omitempty"`
	// CorrelationID - An operation ID used for troubleshooting.
	CorrelationID *string `json:"correlationId,omitempty"`
	// HTTPRequest - The details of the operation.
	HTTPRequest *string `json:"httpRequest,omitempty"`
}

// ResourceWriteCancelData schema of the Data property of an EventGridEvent for a
// Microsoft.Resources.ResourceWriteCancel event. This is raised when a resource create or update operation
// is canceled.
type ResourceWriteCancelData struct {
	// TenantID - The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - The subscription ID of the resource.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The resource group of the resource.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ResourceProvider - The resource provider performing the operation.
	ResourceProvider *string `json:"resourceProvider,omitempty"`
	// ResourceURI - The URI of the resource in the operation.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OperationName - The operation that was performed.
	OperationName *string `json:"operationName,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Authorization - The requested authorization for the operation.
	Authorization *string `json:"authorization,omitempty"`
	// Claims - The properties of the claims.
	Claims *string `json:"claims,omitempty"`
	// CorrelationID - An operation ID used for troubleshooting.
	CorrelationID *string `json:"correlationId,omitempty"`
	// HTTPRequest - The details of the operation.
	HTTPRequest *string `json:"httpRequest,omitempty"`
}

// ResourceWriteFailureData schema of the Data property of an EventGridEvent for a
// Microsoft.Resources.ResourceWriteFailure event. This is raised when a resource create or update
// operation fails.
type ResourceWriteFailureData struct {
	// TenantID - The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - The subscription ID of the resource.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The resource group of the resource.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ResourceProvider - The resource provider performing the operation.
	ResourceProvider *string `json:"resourceProvider,omitempty"`
	// ResourceURI - The URI of the resource in the operation.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OperationName - The operation that was performed.
	OperationName *string `json:"operationName,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Authorization - The requested authorization for the operation.
	Authorization *string `json:"authorization,omitempty"`
	// Claims - The properties of the claims.
	Claims *string `json:"claims,omitempty"`
	// CorrelationID - An operation ID used for troubleshooting.
	CorrelationID *string `json:"correlationId,omitempty"`
	// HTTPRequest - The details of the operation.
	HTTPRequest *string `json:"httpRequest,omitempty"`
}

// ResourceWriteSuccessData schema of the Data property of an EventGridEvent for a
// Microsoft.Resources.ResourceWriteSuccess event. This is raised when a resource create or update
// operation succeeds.
type ResourceWriteSuccessData struct {
	// TenantID - The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - The subscription ID of the resource.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The resource group of the resource.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ResourceProvider - The resource provider performing the operation.
	ResourceProvider *string `json:"resourceProvider,omitempty"`
	// ResourceURI - The URI of the resource in the operation.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OperationName - The operation that was performed.
	OperationName *string `json:"operationName,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Authorization - The requested authorization for the operation.
	Authorization *string `json:"authorization,omitempty"`
	// Claims - The properties of the claims.
	Claims *string `json:"claims,omitempty"`
	// CorrelationID - An operation ID used for troubleshooting.
	CorrelationID *string `json:"correlationId,omitempty"`
	// HTTPRequest - The details of the operation.
	HTTPRequest *string `json:"httpRequest,omitempty"`
}

// ServiceBusActiveMessagesAvailableWithNoListenersEventData schema of the Data property of an
// EventGridEvent for a Microsoft.ServiceBus.ActiveMessagesAvailableWithNoListeners event.
type ServiceBusActiveMessagesAvailableWithNoListenersEventData struct {
	// NamespaceName - The namespace name of the Microsoft.ServiceBus resource.
	NamespaceName *string `json:"namespaceName,omitempty"`
	// RequestURI - The endpoint of the Microsoft.ServiceBus resource.
	RequestURI *string `json:"requestUri,omitempty"`
	// EntityType - The entity type of the Microsoft.ServiceBus resource. Could be one of 'queue' or 'subscriber'.
	EntityType *string `json:"entityType,omitempty"`
	// QueueName - The name of the Microsoft.ServiceBus queue. If the entity type is of type 'subscriber', then this value will be null.
	QueueName *string `json:"queueName,omitempty"`
	// TopicName - The name of the Microsoft.ServiceBus topic. If the entity type is of type 'queue', then this value will be null.
	TopicName *string `json:"topicName,omitempty"`
	// SubscriptionName - The name of the Microsoft.ServiceBus topic's subscription. If the entity type is of type 'queue', then this value will be null.
	SubscriptionName *string `json:"subscriptionName,omitempty"`
}

// ServiceBusDeadletterMessagesAvailableWithNoListenersEventData schema of the Data property of an
// EventGridEvent for a Microsoft.ServiceBus.DeadletterMessagesAvailableWithNoListenersEvent event.
type ServiceBusDeadletterMessagesAvailableWithNoListenersEventData struct {
	// NamespaceName - The namespace name of the Microsoft.ServiceBus resource.
	NamespaceName *string `json:"namespaceName,omitempty"`
	// RequestURI - The endpoint of the Microsoft.ServiceBus resource.
	RequestURI *string `json:"requestUri,omitempty"`
	// EntityType - The entity type of the Microsoft.ServiceBus resource. Could be one of 'queue' or 'subscriber'.
	EntityType *string `json:"entityType,omitempty"`
	// QueueName - The name of the Microsoft.ServiceBus queue. If the entity type is of type 'subscriber', then this value will be null.
	QueueName *string `json:"queueName,omitempty"`
	// TopicName - The name of the Microsoft.ServiceBus topic. If the entity type is of type 'queue', then this value will be null.
	TopicName *string `json:"topicName,omitempty"`
	// SubscriptionName - The name of the Microsoft.ServiceBus topic's subscription. If the entity type is of type 'queue', then this value will be null.
	SubscriptionName *string `json:"subscriptionName,omitempty"`
}

// SignalRServiceClientConnectionConnectedEventData schema of the Data property of an EventGridEvent for a
// Microsoft.SignalRService.ClientConnectionConnected event.
type SignalRServiceClientConnectionConnectedEventData struct {
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// HubName - The hub of connected client connection.
	HubName *string `json:"hubName,omitempty"`
	// ConnectionID - The connection Id of connected client connection.
	ConnectionID *string `json:"connectionId,omitempty"`
	// UserID - The user Id of connected client connection.
	UserID *string `json:"userId,omitempty"`
}

// SignalRServiceClientConnectionDisconnectedEventData schema of the Data property of an EventGridEvent for
// a Microsoft.SignalRService.ClientConnectionDisconnected event.
type SignalRServiceClientConnectionDisconnectedEventData struct {
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// HubName - The hub of connected client connection.
	HubName *string `json:"hubName,omitempty"`
	// ConnectionID - The connection Id of connected client connection.
	ConnectionID *string `json:"connectionId,omitempty"`
	// UserID - The user Id of connected client connection.
	UserID *string `json:"userId,omitempty"`
	// ErrorMessage - The message of error that cause the client connection disconnected.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// StorageBlobCreatedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Storage.BlobCreated event.
type StorageBlobCreatedEventData struct {
	// API - The name of the API/operation that triggered this event.
	API *string `json:"api,omitempty"`
	// ClientRequestID - A request id provided by the client of the storage API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// RequestID - The request id generated by the Storage service for the storage API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// ETag - The etag of the blob at the time this event was triggered.
	ETag *string `json:"eTag,omitempty"`
	// ContentType - The content type of the blob. This is the same as what would be returned in the Content-Type header from the blob.
	ContentType *string `json:"contentType,omitempty"`
	// ContentLength - The size of the blob in bytes. This is the same as what would be returned in the Content-Length header from the blob.
	ContentLength *int64 `json:"contentLength,omitempty"`
	// ContentOffset - The offset of the blob in bytes.
	ContentOffset *int64 `json:"contentOffset,omitempty"`
	// BlobType - The type of blob.
	BlobType *string `json:"blobType,omitempty"`
	// URL - The path to the blob.
	URL *string `json:"url,omitempty"`
	// Sequencer - An opaque string value representing the logical sequence of events for any particular blob name. Users can use standard string comparison to understand the relative sequence of two events on the same blob name.
	Sequencer *string `json:"sequencer,omitempty"`
	// Identity - The identity of the requester that triggered this event.
	Identity *string `json:"identity,omitempty"`
	// StorageDiagnostics - For service use only. Diagnostic data occasionally included by the Azure Storage service. This property should be ignored by event consumers.
	StorageDiagnostics interface{} `json:"storageDiagnostics,omitempty"`
}

// StorageBlobDeletedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Storage.BlobDeleted event.
type StorageBlobDeletedEventData struct {
	// API - The name of the API/operation that triggered this event.
	API *string `json:"api,omitempty"`
	// ClientRequestID - A request id provided by the client of the storage API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// RequestID - The request id generated by the Storage service for the storage API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// ContentType - The content type of the blob. This is the same as what would be returned in the Content-Type header from the blob.
	ContentType *string `json:"contentType,omitempty"`
	// BlobType - The type of blob.
	BlobType *string `json:"blobType,omitempty"`
	// URL - The path to the blob.
	URL *string `json:"url,omitempty"`
	// Sequencer - An opaque string value representing the logical sequence of events for any particular blob name. Users can use standard string comparison to understand the relative sequence of two events on the same blob name.
	Sequencer *string `json:"sequencer,omitempty"`
	// Identity - The identity of the requester that triggered this event.
	Identity *string `json:"identity,omitempty"`
	// StorageDiagnostics - For service use only. Diagnostic data occasionally included by the Azure Storage service. This property should be ignored by event consumers.
	StorageDiagnostics interface{} `json:"storageDiagnostics,omitempty"`
}

// StorageBlobRenamedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Storage.BlobRenamed event.
type StorageBlobRenamedEventData struct {
	// API - The name of the API/operation that triggered this event.
	API *string `json:"api,omitempty"`
	// ClientRequestID - A request id provided by the client of the storage API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// RequestID - The request id generated by the storage service for the storage API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// SourceURL - The path to the blob that was renamed.
	SourceURL *string `json:"sourceUrl,omitempty"`
	// DestinationURL - The new path to the blob after the rename operation.
	DestinationURL *string `json:"destinationUrl,omitempty"`
	// Sequencer - An opaque string value representing the logical sequence of events for any particular blob name. Users can use standard string comparison to understand the relative sequence of two events on the same blob name.
	Sequencer *string `json:"sequencer,omitempty"`
	// Identity - The identity of the requester that triggered this event.
	Identity *string `json:"identity,omitempty"`
	// StorageDiagnostics - For service use only. Diagnostic data occasionally included by the Azure Storage service. This property should be ignored by event consumers.
	StorageDiagnostics interface{} `json:"storageDiagnostics,omitempty"`
}

// StorageDirectoryCreatedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Storage.DirectoryCreated event.
type StorageDirectoryCreatedEventData struct {
	// API - The name of the API/operation that triggered this event.
	API *string `json:"api,omitempty"`
	// ClientRequestID - A request id provided by the client of the storage API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// RequestID - The request id generated by the storage service for the storage API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// ETag - The etag of the directory at the time this event was triggered.
	ETag *string `json:"eTag,omitempty"`
	// URL - The path to the directory.
	URL *string `json:"url,omitempty"`
	// Sequencer - An opaque string value representing the logical sequence of events for any particular directory name. Users can use standard string comparison to understand the relative sequence of two events on the same directory name.
	Sequencer *string `json:"sequencer,omitempty"`
	// Identity - The identity of the requester that triggered this event.
	Identity *string `json:"identity,omitempty"`
	// StorageDiagnostics - For service use only. Diagnostic data occasionally included by the Azure Storage service. This property should be ignored by event consumers.
	StorageDiagnostics interface{} `json:"storageDiagnostics,omitempty"`
}

// StorageDirectoryDeletedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Storage.DirectoryDeleted event.
type StorageDirectoryDeletedEventData struct {
	// API - The name of the API/operation that triggered this event.
	API *string `json:"api,omitempty"`
	// ClientRequestID - A request id provided by the client of the storage API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// RequestID - The request id generated by the storage service for the storage API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// URL - The path to the deleted directory.
	URL *string `json:"url,omitempty"`
	// Recursive - Is this event for a recursive delete operation.
	Recursive *bool `json:"recursive,omitempty"`
	// Sequencer - An opaque string value representing the logical sequence of events for any particular directory name. Users can use standard string comparison to understand the relative sequence of two events on the same directory name.
	Sequencer *string `json:"sequencer,omitempty"`
	// Identity - The identity of the requester that triggered this event.
	Identity *string `json:"identity,omitempty"`
	// StorageDiagnostics - For service use only. Diagnostic data occasionally included by the Azure Storage service. This property should be ignored by event consumers.
	StorageDiagnostics interface{} `json:"storageDiagnostics,omitempty"`
}

// StorageDirectoryRenamedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Storage.DirectoryRenamed event.
type StorageDirectoryRenamedEventData struct {
	// API - The name of the API/operation that triggered this event.
	API *string `json:"api,omitempty"`
	// ClientRequestID - A request id provided by the client of the storage API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// RequestID - The request id generated by the storage service for the storage API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// SourceURL - The path to the directory that was renamed.
	SourceURL *string `json:"sourceUrl,omitempty"`
	// DestinationURL - The new path to the directory after the rename operation.
	DestinationURL *string `json:"destinationUrl,omitempty"`
	// Sequencer - An opaque string value representing the logical sequence of events for any particular directory name. Users can use standard string comparison to understand the relative sequence of two events on the same directory name.
	Sequencer *string `json:"sequencer,omitempty"`
	// Identity - The identity of the requester that triggered this event.
	Identity *string `json:"identity,omitempty"`
	// StorageDiagnostics - For service use only. Diagnostic data occasionally included by the Azure Storage service. This property should be ignored by event consumers.
	StorageDiagnostics interface{} `json:"storageDiagnostics,omitempty"`
}

// SubscriptionDeletedEventData schema of the Data property of an EventGridEvent for a
// Microsoft.EventGrid.SubscriptionDeletedEvent.
type SubscriptionDeletedEventData struct {
	// EventSubscriptionID - READ-ONLY; The Azure resource ID of the deleted event subscription.
	EventSubscriptionID *string `json:"eventSubscriptionId,omitempty"`
}

// SubscriptionValidationEventData schema of the Data property of an EventGridEvent for a
// Microsoft.EventGrid.SubscriptionValidationEvent.
type SubscriptionValidationEventData struct {
	// ValidationCode - READ-ONLY; The validation code sent by Azure Event Grid to validate an event subscription. To complete the validation handshake, the subscriber must either respond with this validation code as part of the validation response, or perform a GET request on the validationUrl (available starting version 2018-05-01-preview).
	ValidationCode *string `json:"validationCode,omitempty"`
	// ValidationURL - READ-ONLY; The validation URL sent by Azure Event Grid (available starting version 2018-05-01-preview). To complete the validation handshake, the subscriber must either respond with the validationCode as part of the validation response, or perform a GET request on the validationUrl (available starting version 2018-05-01-preview).
	ValidationURL *string `json:"validationUrl,omitempty"`
}

// SubscriptionValidationResponse to complete an event subscription validation handshake, a subscriber can
// use either the validationCode or the validationUrl received in a SubscriptionValidationEvent. When the
// validationCode is used, the SubscriptionValidationResponse can be used to build the response.
type SubscriptionValidationResponse struct {
	// ValidationResponse - The validation response sent by the subscriber to Azure Event Grid to complete the validation of an event subscription.
	ValidationResponse *string `json:"validationResponse,omitempty"`
}

// WebAppServicePlanUpdatedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.AppServicePlanUpdated event.
type WebAppServicePlanUpdatedEventData struct {
	AppServicePlanEventTypeDetail *AppServicePlanEventTypeDetail `json:"appServicePlanEventTypeDetail,omitempty"`
	// Sku - sku of app service plan.
	Sku *WebAppServicePlanUpdatedEventDataSku `json:"sku,omitempty"`
	// Name - name of the app service plan that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the app service plan API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the app service plan API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the app service plan API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebAppServicePlanUpdatedEventDataSku sku of app service plan.
type WebAppServicePlanUpdatedEventDataSku struct {
	// Name - name of app service plan sku.
	Name *string `json:"name,omitempty"`
	// Tier - tier of app service plan sku.
	Tier *string `json:"Tier,omitempty"`
	// Size - size of app service plan sku.
	Size *string `json:"Size,omitempty"`
	// Family - family of app service plan sku.
	Family *string `json:"Family,omitempty"`
	// Capacity - capacity of app service plan sku.
	Capacity *string `json:"Capacity,omitempty"`
}

// WebAppUpdatedEventData schema of the Data property of an EventGridEvent for an Microsoft.Web.AppUpdated
// event.
type WebAppUpdatedEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebBackupOperationCompletedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.BackupOperationCompleted event.
type WebBackupOperationCompletedEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebBackupOperationFailedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.BackupOperationFailed event.
type WebBackupOperationFailedEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebBackupOperationStartedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.BackupOperationStarted event.
type WebBackupOperationStartedEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebRestoreOperationCompletedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.RestoreOperationCompleted event.
type WebRestoreOperationCompletedEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebRestoreOperationFailedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.RestoreOperationFailed event.
type WebRestoreOperationFailedEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebRestoreOperationStartedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.RestoreOperationStarted event.
type WebRestoreOperationStartedEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebSlotSwapCompletedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.SlotSwapCompleted event.
type WebSlotSwapCompletedEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebSlotSwapFailedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.SlotSwapFailed event.
type WebSlotSwapFailedEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebSlotSwapStartedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.SlotSwapStarted event.
type WebSlotSwapStartedEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebSlotSwapWithPreviewCancelledEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.SlotSwapWithPreviewCancelled event.
type WebSlotSwapWithPreviewCancelledEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}

// WebSlotSwapWithPreviewStartedEventData schema of the Data property of an EventGridEvent for an
// Microsoft.Web.SlotSwapWithPreviewStarted event.
type WebSlotSwapWithPreviewStartedEventData struct {
	AppEventTypeDetail *AppEventTypeDetail `json:"appEventTypeDetail,omitempty"`
	// Name - name of the web site that had this event.
	Name *string `json:"name,omitempty"`
	// ClientRequestID - The client request id generated by the app service for the site API operation that triggered this event.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// CorrelationRequestID - The correlation request id generated by the app service for the site API operation that triggered this event.
	CorrelationRequestID *string `json:"correlationRequestId,omitempty"`
	// RequestID - The request id generated by the app service for the site API operation that triggered this event.
	RequestID *string `json:"requestId,omitempty"`
	// Address - HTTP request URL of this operation.
	Address *string `json:"address,omitempty"`
	// Verb - HTTP verb of this operation.
	Verb *string `json:"verb,omitempty"`
}
