/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.hyperbolic;

import hypergraph.hyperbolic.AbstractModel;
import hypergraph.hyperbolic.Complex;
import hypergraph.hyperbolic.ComplexVector;
import hypergraph.hyperbolic.Functions;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.hyperbolic.ModelVector;

public class PoincareModel
extends AbstractModel {
    private ComplexVector v1 = new ComplexVector();

    public PoincareModel() {
        this.setViewMatrix(null);
    }

    public ModelPoint getOrigin() {
        return new Complex();
    }

    public hypergraph.hyperbolic.Isometry getIdentity() {
        return new Isometry();
    }

    public hypergraph.hyperbolic.Isometry getRotation(double d) {
        return new Isometry(new Complex(Complex.getRotation(d / 2.0)), new Complex());
    }

    public void getTranslation(hypergraph.hyperbolic.Isometry isometry, ModelPoint modelPoint, double d) {
        Complex complex = (Complex)modelPoint;
        double d2 = 1.0;
        if (Math.abs(d - 1.0) > 0.01) {
            d2 = this.dist(complex) * d;
            d2 = (Math.exp(d2) - 1.0) / (Math.exp(d2) + 1.0);
            d2 /= complex.norm();
        }
        ((Isometry)isometry).a.real = 1.0;
        ((Isometry)isometry).a.imag = 0.0;
        ((Isometry)isometry).c.real = complex.real * d2;
        ((Isometry)isometry).c.imag = -complex.imag * d2;
    }

    public void setOrientation() {
    }

    public double getDistance(ModelPoint modelPoint, ModelPoint modelPoint2, ModelPoint modelPoint3, boolean bl, boolean bl2) {
        return this.dist(modelPoint, this.getProjection(modelPoint, modelPoint2, modelPoint3, bl, bl2));
    }

    public double getAngle(ModelPoint modelPoint, ModelPoint modelPoint2, ModelPoint modelPoint3) {
        double d = this.dist(modelPoint, modelPoint2);
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = this.dist(modelPoint, modelPoint3);
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = this.dist(modelPoint2, modelPoint3);
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = (Functions.cosh(d) * Functions.cosh(d2) - Functions.cosh(d3)) / (Functions.sinh(d) * Functions.sinh(d2));
        if (d4 > 1.0) {
            d4 = 1.0;
        }
        if (d4 < -1.0) {
            d4 = -1.0;
        }
        double d5 = Math.acos(d4);
        return d5;
    }

    public ModelPoint getProjection(ModelPoint modelPoint, ModelPoint modelPoint2, ModelPoint modelPoint3, boolean bl, boolean bl2) {
        ModelPoint modelPoint4;
        double d = this.getAngle(modelPoint2, modelPoint, modelPoint3);
        if (Math.abs(d) > 1.0E-7) {
            double d2 = Functions.arsinh(Functions.sinh(this.dist(modelPoint2, modelPoint)) * Math.sin(d));
            double d3 = Functions.arcosh(Functions.cosh(this.dist(modelPoint, modelPoint2)) / Functions.cosh(d2));
            ModelPoint modelPoint5 = (ModelPoint)modelPoint2.clone();
            this.getTranslation(modelPoint2, modelPoint3, d3 / this.dist(modelPoint2, modelPoint3)).apply(modelPoint5);
            ModelPoint modelPoint6 = (ModelPoint)modelPoint2.clone();
            this.getTranslation(modelPoint2, modelPoint3, -d3 / this.dist(modelPoint2, modelPoint3)).apply(modelPoint6);
            modelPoint4 = this.dist(modelPoint, modelPoint5) > this.dist(modelPoint, modelPoint6) ? modelPoint6 : modelPoint5;
        } else {
            modelPoint4 = modelPoint;
        }
        if (!bl && !bl2) {
            return modelPoint4;
        }
        if (this.getAngle(modelPoint4, modelPoint2, modelPoint3) > 1.5707963267948966) {
            return modelPoint4;
        }
        if (this.dist(modelPoint4, modelPoint2) < this.dist(modelPoint4, modelPoint3)) {
            if (bl) {
                return modelPoint2;
            }
            return modelPoint4;
        }
        if (bl2) {
            return modelPoint3;
        }
        return modelPoint4;
    }

    public double dist(ModelPoint modelPoint) {
        double d = ((Complex)modelPoint).norm();
        return Math.log((1.0 + d) / (1.0 - d));
    }

    public double dist(ModelPoint modelPoint, ModelPoint modelPoint2) {
        double d = ((Complex)modelPoint).real;
        double d2 = ((Complex)modelPoint).imag;
        double d3 = ((Complex)modelPoint2).real;
        double d4 = ((Complex)modelPoint2).imag;
        double d5 = d - d3;
        double d6 = d2 - d4;
        double d7 = 1.0 - d * d3 - d2 * d4;
        double d8 = d * d4 - d2 * d3;
        double d9 = Math.sqrt((d5 * d5 + d6 * d6) / (d7 * d7 + d8 * d8));
        return Math.log((1.0 + d9) / (1.0 - d9));
    }

    double getReciprocalScale(ModelPoint modelPoint) {
        return (1.0 - ((Complex)modelPoint).norm2()) / 2.0;
    }

    double getScale(ModelPoint modelPoint) {
        return 2.0 / (1.0 - ((Complex)modelPoint).norm2());
    }

    public double length2(ModelVector modelVector) {
        double d = ((ComplexVector)modelVector).v.real * ((ComplexVector)modelVector).v.real + ((ComplexVector)modelVector).v.imag * ((ComplexVector)modelVector).v.imag;
        double d2 = ((ComplexVector)modelVector).base.real * ((ComplexVector)modelVector).base.real + ((ComplexVector)modelVector).base.imag * ((ComplexVector)modelVector).base.imag;
        double d3 = 2.0 / (1.0 - d2);
        return d3 * d3 * d;
    }

    public double length(ModelVector modelVector) {
        double d = ((ComplexVector)modelVector).v.real * ((ComplexVector)modelVector).v.real + ((ComplexVector)modelVector).v.imag * ((ComplexVector)modelVector).v.imag;
        double d2 = ((ComplexVector)modelVector).base.real * ((ComplexVector)modelVector).base.real + ((ComplexVector)modelVector).base.imag * ((ComplexVector)modelVector).base.imag;
        double d3 = 2.0 / (1.0 - d2);
        return d3 * Math.sqrt(d);
    }

    public double product(ModelVector modelVector, ModelVector modelVector2) {
        if (modelVector.getBase().equals(modelVector2.getBase())) {
            double d = 2.0 / (1.0 - ((ComplexVector)modelVector).base.norm2());
            return d * d * (((ComplexVector)modelVector).v.real * ((ComplexVector)modelVector2).v.real + ((ComplexVector)modelVector).v.imag * ((ComplexVector)modelVector2).v.imag);
        }
        return Double.NaN;
    }

    public ModelPoint exp(ModelVector modelVector, double d) {
        ComplexVector complexVector = (ComplexVector)modelVector;
        if (complexVector.v.norm2() == 0.0) {
            return (ModelPoint)modelVector.getBase().clone();
        }
        double d2 = Math.exp(d);
        d2 = (d2 - 1.0) / (d2 + 1.0);
        Complex complex = new Complex(complexVector.v);
        complex.multiply(d2 / complexVector.v.norm());
        this.getTranslation(this.isom1, (ModelPoint)complexVector.base);
        this.isom1.apply(complex);
        return complex;
    }

    public ModelVector getDefaultVector() {
        ComplexVector complexVector = new ComplexVector(new Complex(), new Complex(0.5, 0.0));
        return complexVector;
    }

    public void distanceGradient(ModelPoint modelPoint, ModelPoint modelPoint2, ModelVector modelVector) {
        ((Isometry)this.isom1).a.real = 1.0;
        ((Isometry)this.isom1).a.imag = 0.0;
        ((Isometry)this.isom1).c.real = -((Complex)modelPoint).real;
        ((Isometry)this.isom1).c.imag = ((Complex)modelPoint).imag;
        ((Complex)this.z1).real = ((Complex)modelPoint2).real;
        ((Complex)this.z1).imag = ((Complex)modelPoint2).imag;
        this.isom1.apply(this.z1);
        double d = 2.0 * Math.sqrt(((Complex)this.z1).real * ((Complex)this.z1).real + ((Complex)this.z1).imag * ((Complex)this.z1).imag);
        this.v1.base.real = 0.0;
        this.v1.base.imag = 0.0;
        this.v1.v.real = -((Complex)this.z1).real / d;
        this.v1.v.imag = -((Complex)this.z1).imag / d;
        ((Isometry)this.isom1).a.real = 1.0;
        ((Isometry)this.isom1).a.imag = 0.0;
        ((Isometry)this.isom1).c.real = ((Complex)modelPoint).real;
        ((Isometry)this.isom1).c.imag = -((Complex)modelPoint).imag;
        this.isom1.apply(this.v1);
        modelVector.setTo(this.v1);
    }

    public ModelVector distanceGradient(ModelPoint modelPoint, ModelPoint modelPoint2) {
        ComplexVector complexVector = new ComplexVector();
        this.distanceGradient(modelPoint, modelPoint2, complexVector);
        return complexVector;
    }

    public class Isometry
    implements hypergraph.hyperbolic.Isometry {
        Complex a;
        Complex c;

        public Isometry() {
            this.a = new Complex(1.0);
            this.c = new Complex();
        }

        public Isometry(Isometry isometry) {
            this.a = new Complex(isometry.a);
            this.c = new Complex(isometry.c);
        }

        public Isometry(ModelPoint modelPoint, ModelPoint modelPoint2) {
            this(((Complex)modelPoint).getReal(), ((Complex)modelPoint).getImag(), ((Complex)modelPoint2).getReal(), ((Complex)modelPoint2).getImag());
        }

        public Isometry(double d, double d2, double d3, double d4) {
            this.a = new Complex(d, d2);
            this.c = new Complex(d3, d4);
        }

        public boolean equals(Object object) {
            return this.a.equals(((Isometry)object).a) && this.c.equals(((Isometry)object).c);
        }

        public void setToIdentity() {
            this.a.real = 1.0;
            this.a.imag = 0.0;
            this.c.real = 0.0;
            this.c.imag = 0.0;
        }

        public void multiplyRight(hypergraph.hyperbolic.Isometry isometry) {
            Isometry isometry2 = (Isometry)isometry;
            double d = isometry2.a.real * this.a.real - isometry2.a.imag * this.a.imag + isometry2.c.real * this.c.real + isometry2.c.imag * this.c.imag;
            double d2 = isometry2.a.real * this.a.imag + isometry2.a.imag * this.a.real - isometry2.c.real * this.c.imag + isometry2.c.imag * this.c.real;
            double d3 = isometry2.a.real * this.c.real - isometry2.a.imag * this.c.imag + isometry2.c.real * this.a.real + isometry2.c.imag * this.a.imag;
            double d4 = isometry2.a.real * this.c.imag + isometry2.a.imag * this.c.real - isometry2.c.real * this.a.imag + isometry2.c.imag * this.a.real;
            this.a.real = d;
            this.a.imag = d2;
            this.c.real = d3;
            this.c.imag = d4;
        }

        public void multiplyLeft(hypergraph.hyperbolic.Isometry isometry) {
            Isometry isometry2 = new Isometry((Isometry)isometry);
            isometry2.multiplyRight(this);
            this.a = new Complex(isometry2.a);
            this.c = new Complex(isometry2.c);
        }

        public void apply(ModelPoint modelPoint) {
            if (modelPoint == null) {
                return;
            }
            double d = this.a.real * ((Complex)modelPoint).real - this.a.imag * ((Complex)modelPoint).imag + this.c.real;
            double d2 = this.a.real * ((Complex)modelPoint).imag + this.a.imag * ((Complex)modelPoint).real - this.c.imag;
            double d3 = this.c.real * ((Complex)modelPoint).real - this.c.imag * ((Complex)modelPoint).imag + this.a.real;
            double d4 = this.c.real * ((Complex)modelPoint).imag + this.c.imag * ((Complex)modelPoint).real - this.a.imag;
            double d5 = d3 * d3 + d4 * d4;
            ((Complex)modelPoint).real = (d * d3 + d2 * d4) / d5;
            ((Complex)modelPoint).imag = (-d * d4 + d2 * d3) / d5;
        }

        public void apply(ModelVector modelVector) {
            ComplexVector complexVector = (ComplexVector)modelVector;
            PoincareModel.this.z3.setTo(this.c);
            ((Complex)PoincareModel.this.z3).multiply(complexVector.base);
            this.a.conjugate();
            ((Complex)PoincareModel.this.z3).add(this.a);
            this.a.conjugate();
            ((Complex)PoincareModel.this.z3).multiply((Complex)PoincareModel.this.z3);
            ((Complex)PoincareModel.this.z3).reciprocal();
            ((Complex)PoincareModel.this.z3).multiply(this.a.norm2() - this.c.norm2());
            complexVector.v.multiply((Complex)PoincareModel.this.z3);
            this.apply(complexVector.base);
        }

        public hypergraph.hyperbolic.Isometry getInvers() {
            return new Isometry(new Complex(this.a.getReal(), -this.a.getImag()), new Complex(-this.c.getReal(), -this.c.getImag()));
        }

        public void invert() {
            this.a.imag = -this.a.imag;
            this.c.real = -this.c.real;
            this.c.imag = -this.c.imag;
        }

        public void setTo(hypergraph.hyperbolic.Isometry isometry) {
            this.a.real = ((Isometry)isometry).a.real;
            this.a.imag = ((Isometry)isometry).a.imag;
            this.c.real = ((Isometry)isometry).c.real;
            this.c.imag = ((Isometry)isometry).c.imag;
        }

        public Object clone() {
            return new Isometry(this);
        }

        public String toString() {
            return "( " + this.a + " ; " + this.c + " )";
        }
    }
}

