//
// C++ Implementation: sessionmanager
//
// Description: 
//
//
// Author: Rikard Bjorklind <olof@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "sessionmanager.h"
#include "session.h"
#include <QtGui>

SessionManager::SessionManager( QTabWidget * aSessionTabs, boost::shared_ptr< BackendConnection > aConnection, QObject * parent ) :
						QObject(parent), backendConnection(aConnection), sessionTabs(aSessionTabs) 
{
	connect( sessionTabs, SIGNAL(currentChanged(int)), SLOT(onActiveSessionChanged(int)));
}

SessionManager::~SessionManager()
{
}

void SessionManager::createSession( int id )
{
	if(!sessionMap.contains(id)) {
		Session* session = new Session(id); // no parent here since we add it to a tabbar.
											// This connect forwards chat signals from the session to us so that we send them to the backend.
		QObject::connect(session,SIGNAL(sendChat( int,const QString&)),this,SLOT(sendChat( int, const QString& )));
		QObject::connect(session,SIGNAL(getUserFileList(int)),this,SLOT(getUserFileList( int )));
		sessionMap[id] = session;
		sessionTabs->addTab(session,tr("Connecting..."));
	}
}

void SessionManager::hubUpdated( int id, const QString& hubName)
{
	if(sessionMap.contains(id)) {
		Session* session = sessionMap[id];
		int index = sessionTabs->indexOf(session);
		QString hubn = hubName;
		if(hubName.length() > 30) {
			hubn.truncate( 30 );
			hubn = hubn + "...";
		}
		sessionTabs->setTabText(index,hubn);
		sessionTabs->setCurrentIndex(index);
	}
}

void SessionManager::connectionFailed( int id, const QString& reason)
{
	if(sessionMap.contains(id)) {
		sessionMap[id]->onFailed(reason);
	} else QMessageBox::critical(0,tr("Connection Failed"),tr("Connection failed: ") + reason);
}

void SessionManager::privateChat(int id,const QString& from,const QString& msg)
{
	if(sessionMap.contains(id))
		sessionMap[id]->onPrivateChatMessage(from,msg);
}

void SessionManager::usersUpdated( int id , QList< User * > users )
{
	if(sessionMap.contains(id)) sessionMap[id]->onUsersUpdated(users);
}

void SessionManager::chatMessage( int id, const QString &msg )
{
	if(sessionMap.contains(id)) sessionMap[id]->onChatMessage(msg);
}

void SessionManager::sendChat( int id, const QString &msg )
{
	backendConnection->sendChat(id,msg);	
}

void SessionManager::getUserFileList( int userId )
{
	backendConnection->getUserFileList( userId );
}

void SessionManager::sessionInfo( int id, const QString &hubName, const QString &/*url*/, const QList< User * > users )
{
	createSession( id );
	hubUpdated( id,hubName );
	usersUpdated( id,users );
	// TODO put the url in the session so that the fav command works.
}

void SessionManager::closeCurrentSession( )
{
	try {
		Session* session = qobject_cast<Session*>(sessionTabs->currentWidget());
		sessionTabs->removeTab(sessionTabs->currentIndex());
		sessionMap.remove( session->getId() );
		backendConnection->closeSession( session->getId() );
		delete session;
	}
	catch(...) {}
}

void SessionManager::userRemoved( int session, int userid )
{
	if(sessionMap.contains( session )) sessionMap[session]->onUserRemoved(userid);
}

void SessionManager::onHubStats( int session, qint64 sharesize)
{
	if(sessionMap.contains(session)) {
		sessionMap[session]->onHubStats(sharesize);
		if( sessionTabs->currentWidget() == sessionMap[session] ) emit currentHubTotalShare( sharesize );
	}
	
}

void SessionManager::onActiveSessionChanged( int /*session*/ )
{
	Session* sess = (Session*)sessionTabs->currentWidget();
	emit currentHubTotalShare( sess->getTotalShared() );
}
