DACSLIST(1)                  DACS Commands Manual                  DACSLIST(1)



[1mNAME[0m
       dacslist - list jurisdictions

[1mSYNOPSIS[0m
       [1mdacslist [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [[1m-f[22m] [[1m-j [4m[22mjurisdiction-name[24m] [[1m-k[22m]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       For a jurisdiction configured on the host where this program is run,
       the [1mdacslist [22mutility lists information about all known jurisdictions in
       the same federation. It can also display information about the
       federation.

       This program is also available as a [1mDACS [22mweb service,
       [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[2].

           [1mSecurity[0m
           Because this program may access the federation and jurisdiction key
           files (item types federation_keys and jurisdiction_keys,
           respectively), only the [1mDACS [22madministrator should be able to run
           this command.

[1mOPTIONS[0m
       The program respects the [1m-format [22mflag. Except for error messages,
       information is printed to the standard output.

       [1m-f[0m
           Only list information about the federation. Equivalent to -j "".

       [1m-j [4m[22mjurisdiction-name[0m
           Limit the output to the specified jurisdiction name. As a special
           case, if the argument is the empty string, only federation-scoped
           information will be returned.

       [1m-k[0m
           Only the federation's or a jurisdiction's public key (if known)
           will be displayed. If [1m-j [22mis given and is not the empty string, that
           jurisdiction name is selected; if [1m-j [22mis given and is the empty
           string, the federation is selected; and if the argument is absent,
           the current jurisdiction is selected. A PEM [[34m[1mRFC 1421[0m[1m[22m[3], [34m[1mRFC[0m
           [1m[34m1422[0m[1m[22m[4], [34m[1mRFC 1423[0m[1m[22m[5], [34m[1mRFC 1424[0m[1m[22m[6]] formatted key is returned.

           [1mNote[0m
           In the current implementation, a jurisdiction's public key can only
           be provided by one of the jurisdictions configured on the same
           host.

[1mEXAMPLES[0m
       To list all jurisdictions in the same federation as jurisdiction J1,
       which must be configured on this host:

           % dacslist -uj J1

       To copy the public encryption key for J1 to pubkey:

           % dacslist -uj J1 -k > pubkey

       To display the public encryption key for J1's federation:

           % dacslist -uj J1 -f -k

       To retrieve the public encryption key for J1, which must be in the same
       federation as J2:

           % dacslist -uj J2 -k -j J1

       To display information about the federation to which jurisdiction J1
       belongs:

           % dacslist -uj J1 -f


[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.
       Error messages are printed to stderr.

[1mSEE ALSO[0m
       [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[2], [34m[1mdacs.groups(5)[0m[1m[22m[7]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[8])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[9] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

        3. RFC 1421
           http://www.rfc-editor.org/rfc/rfc1421.txt

        4. RFC 1422
           http://www.rfc-editor.org/rfc/rfc1422.txt

        5. RFC 1423
           http://www.rfc-editor.org/rfc/rfc1423.txt

        6. RFC 1424
           http://www.rfc-editor.org/rfc/rfc1424.txt

        7. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

        8. www.dss.ca
           http://www.dss.ca

        9. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                       DACSLIST(1)
