#ifndef _ACCESSLOG_H
#define _ACCESSLOG_H

// A class to log clients that just disconnected. Since this is shared by all
// Server instances, we try not to let write() block too much, and rather do
// all the I/O in a separate I/O thread.

#include <pthread.h>
#include <stdio.h>
#include <string>
#include <vector>

#include "client.h"
#include "thread.h"

class AccessLogThread : public Thread {
public:
	// Used if we do not have a file to log to. The thread will still exist,
	// but won't actually write anywhere.
	AccessLogThread();

	// Log to a given file. If the file can't be opened, log an error
	// to the error log, and work as if we didn't have a log file.
	AccessLogThread(const std::string &filename);

	// Add a log entry. Entries are written out at least once every second.
	void write(const ClientStats& client);

private:
	virtual void do_work();

	// The file we are logging to. If NULL, do not log.
	FILE *logfp;
	std::string filename;

	pthread_mutex_t mutex;
	std::vector<ClientStats> pending_writes;
};

#endif  // _ACCESSLOG_H
