#include "netbuffer"

unsigned Netbuffer::netread (int fd, int timeout) {    
    PROFILE("Netbuffer::netread");

    if (timeout) {
	Fdset set(timeout);
	set.add(fd);
	set.wait_r();
	if (! set.readable(fd)) {
	    msg(Mstr("Fd ") + Mstr(fd) +
		Mstr(" failed to become readable within ") + Mstr(timeout) +
		Mstr(" sec"));
	    return 0;
	}
    }
    
    check_space(config.buffersize());

    // Read from the network. If this fails, don't throw an exception
    // because it's quite common (too much logging otherwise).
    ssize_t nread = read (fd, buf_data + buf_sz, config.buffersize());
    if (nread < 0) {
	msg(Mstr("Read failed on fd ") + fd + ": " + strerror(errno));
	return 0;
    }
    buf_sz += nread;

    if (config.debug() && nread) {
        ostringstream o;
        o << "Got " << nread << " bytes from fd " << fd << ": ";
        for (unsigned i = 0; i < (unsigned)nread; i++)
            o << printable(buf_data[i]);
        o << "\n";
        _debugmsg (o.str());
    }
    
    return nread;
}
